/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="GraphDefinition", profile="http://hl7.org/fhir/StructureDefinition/GraphDefinition")
public class GraphDefinition
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this graph definition, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this graph definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this graph definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the graph definition is stored on different servers.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the graph definition", formalDefinition="The identifier that is used to identify this version of the graph definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the graph definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="versionAlgorithm", type={StringType.class, Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How to compare versions", formalDefinition="Indicates the mechanism used to compare versions to determine which is more current.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/version-algorithm")
    protected DataType versionAlgorithm;
    @Child(name="name", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this graph definition (computer friendly)", formalDefinition="A natural language name identifying the graph definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this graph definition (human friendly)", formalDefinition="A short, descriptive, user-friendly title for the capability statement.")
    protected StringType title;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this graph definition. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this graph definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the graph definition was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the graph definition changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher/steward (organization or individual)", formalDefinition="The name of the organization or individual responsible for the release and ongoing maintenance of the graph definition.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the graph definition", formalDefinition="A free text natural language description of the graph definition from a consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate graph definition instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for graph definition (if applicable)", formalDefinition="A legal or geographic region in which the graph definition is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this graph definition is defined", formalDefinition="Explanation of why this graph definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="start", type={IdType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Starting Node", formalDefinition="The Node at which instances of this graph start. If there is no nominated start, the graph can start at any of the nodes.")
    protected IdType start;
    @Child(name="node", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Potential target for the link", formalDefinition="Potential target for the link.")
    protected List<GraphDefinitionNodeComponent> node;
    @Child(name="link", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Links this graph makes rules about", formalDefinition="Links this graph makes rules about.")
    protected List<GraphDefinitionLinkComponent> link;
    private static final long serialVersionUID = 806947141L;
    @SearchParamDefinition(name="context-quantity", path="(ActivityDefinition.useContext.value as Quantity) | (ActivityDefinition.useContext.value as Range) | (ActorDefinition.useContext.value as Quantity) | (ActorDefinition.useContext.value as Range) | (CapabilityStatement.useContext.value as Quantity) | (CapabilityStatement.useContext.value as Range) | (ChargeItemDefinition.useContext.value as Quantity) | (ChargeItemDefinition.useContext.value as Range) | (Citation.useContext.value as Quantity) | (Citation.useContext.value as Range) | (CodeSystem.useContext.value as Quantity) | (CodeSystem.useContext.value as Range) | (CompartmentDefinition.useContext.value as Quantity) | (CompartmentDefinition.useContext.value as Range) | (ConceptMap.useContext.value as Quantity) | (ConceptMap.useContext.value as Range) | (ConditionDefinition.useContext.value as Quantity) | (ConditionDefinition.useContext.value as Range) | (EventDefinition.useContext.value as Quantity) | (EventDefinition.useContext.value as Range) | (Evidence.useContext.value as Quantity) | (Evidence.useContext.value as Range) | (EvidenceReport.useContext.value as Quantity) | (EvidenceReport.useContext.value as Range) | (EvidenceVariable.useContext.value as Quantity) | (EvidenceVariable.useContext.value as Range) | (ExampleScenario.useContext.value as Quantity) | (ExampleScenario.useContext.value as Range) | (GraphDefinition.useContext.value as Quantity) | (GraphDefinition.useContext.value as Range) | (ImplementationGuide.useContext.value as Quantity) | (ImplementationGuide.useContext.value as Range) | (Library.useContext.value as Quantity) | (Library.useContext.value as Range) | (Measure.useContext.value as Quantity) | (Measure.useContext.value as Range) | (MessageDefinition.useContext.value as Quantity) | (MessageDefinition.useContext.value as Range) | (NamingSystem.useContext.value as Quantity) | (NamingSystem.useContext.value as Range) | (OperationDefinition.useContext.value as Quantity) | (OperationDefinition.useContext.value as Range) | (PlanDefinition.useContext.value as Quantity) | (PlanDefinition.useContext.value as Range) | (Questionnaire.useContext.value as Quantity) | (Questionnaire.useContext.value as Range) | (Requirements.useContext.value as Quantity) | (Requirements.useContext.value as Range) | (SearchParameter.useContext.value as Quantity) | (SearchParameter.useContext.value as Range) | (StructureDefinition.useContext.value as Quantity) | (StructureDefinition.useContext.value as Range) | (StructureMap.useContext.value as Quantity) | (StructureMap.useContext.value as Range) | (TerminologyCapabilities.useContext.value as Quantity) | (TerminologyCapabilities.useContext.value as Range) | (TestScript.useContext.value as Quantity) | (TestScript.useContext.value as Range) | (ValueSet.useContext.value as Quantity) | (ValueSet.useContext.value as Range)", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A quantity- or range-valued use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A quantity- or range-valued use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A quantity- or range-valued use context assigned to the charge item definition\r\n* [Citation](citation.html): A quantity- or range-valued use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A quantity- or range-valued use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A quantity- or range-valued use context assigned to the event definition\r\n* [Evidence](evidence.html): A quantity- or range-valued use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A quantity- or range-valued use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A quantity- or range-valued use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A quantity- or range-valued use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [Library](library.html): A quantity- or range-valued use context assigned to the library\r\n* [Measure](measure.html): A quantity- or range-valued use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A quantity- or range-valued use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A quantity- or range-valued use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A quantity- or range-valued use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A quantity- or range-valued use context assigned to the test script\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type-quantity", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and quantity- or range-based value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and quantity- or range-based value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and quantity- or range-based value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and quantity- or range-based value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and quantity- or range-based value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and quantity- or range-based value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and quantity- or range-based value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and quantity- or range-based value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and quantity- or range-based value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and quantity- or range-based value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [Library](library.html): A use context type and quantity- or range-based value assigned to the library\r\n* [Measure](measure.html): A use context type and quantity- or range-based value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and quantity- or range-based value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and quantity- or range-based value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and quantity- or range-based value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and quantity- or range-based value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="ActivityDefinition.useContext | ActorDefinition.useContext | CapabilityStatement.useContext | ChargeItemDefinition.useContext | Citation.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | ConditionDefinition.useContext | EventDefinition.useContext | Evidence.useContext | EvidenceReport.useContext | EvidenceVariable.useContext | ExampleScenario.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | Library.useContext | Measure.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | PlanDefinition.useContext | Questionnaire.useContext | Requirements.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | TestScript.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context type and value assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context type and value assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context type and value assigned to the charge item definition\r\n* [Citation](citation.html): A use context type and value assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context type and value assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context type and value assigned to the event definition\r\n* [Evidence](evidence.html): A use context type and value assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context type and value assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context type and value assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context type and value assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [Library](library.html): A use context type and value assigned to the library\r\n* [Measure](measure.html): A use context type and value assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context type and value assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context type and value assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context type and value assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context type and value assigned to the test script\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="context-type", path="ActivityDefinition.useContext.code | ActorDefinition.useContext.code | CapabilityStatement.useContext.code | ChargeItemDefinition.useContext.code | Citation.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | ConditionDefinition.useContext.code | EventDefinition.useContext.code | Evidence.useContext.code | EvidenceReport.useContext.code | EvidenceVariable.useContext.code | ExampleScenario.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | Library.useContext.code | Measure.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | PlanDefinition.useContext.code | Questionnaire.useContext.code | Requirements.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | TestScript.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A type of use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A type of use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A type of use context assigned to the charge item definition\r\n* [Citation](citation.html): A type of use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A type of use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A type of use context assigned to the event definition\r\n* [Evidence](evidence.html): A type of use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A type of use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A type of use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A type of use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [Library](library.html): A type of use context assigned to the library\r\n* [Measure](measure.html): A type of use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A type of use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A type of use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A type of use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A type of use context assigned to the test script\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="context", path="(ActivityDefinition.useContext.value as CodeableConcept) | (ActorDefinition.useContext.value as CodeableConcept) | (CapabilityStatement.useContext.value as CodeableConcept) | (ChargeItemDefinition.useContext.value as CodeableConcept) | (Citation.useContext.value as CodeableConcept) | (CodeSystem.useContext.value as CodeableConcept) | (CompartmentDefinition.useContext.value as CodeableConcept) | (ConceptMap.useContext.value as CodeableConcept) | (ConditionDefinition.useContext.value as CodeableConcept) | (EventDefinition.useContext.value as CodeableConcept) | (Evidence.useContext.value as CodeableConcept) | (EvidenceReport.useContext.value as CodeableConcept) | (EvidenceVariable.useContext.value as CodeableConcept) | (ExampleScenario.useContext.value as CodeableConcept) | (GraphDefinition.useContext.value as CodeableConcept) | (ImplementationGuide.useContext.value as CodeableConcept) | (Library.useContext.value as CodeableConcept) | (Measure.useContext.value as CodeableConcept) | (MessageDefinition.useContext.value as CodeableConcept) | (NamingSystem.useContext.value as CodeableConcept) | (OperationDefinition.useContext.value as CodeableConcept) | (PlanDefinition.useContext.value as CodeableConcept) | (Questionnaire.useContext.value as CodeableConcept) | (Requirements.useContext.value as CodeableConcept) | (SearchParameter.useContext.value as CodeableConcept) | (StructureDefinition.useContext.value as CodeableConcept) | (StructureMap.useContext.value as CodeableConcept) | (TerminologyCapabilities.useContext.value as CodeableConcept) | (TestScript.useContext.value as CodeableConcept) | (ValueSet.useContext.value as CodeableConcept)", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): A use context assigned to the activity definition\r\n* [ActorDefinition](actordefinition.html): A use context assigned to the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): A use context assigned to the charge item definition\r\n* [Citation](citation.html): A use context assigned to the citation\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [ConditionDefinition](conditiondefinition.html): A use context assigned to the condition definition\r\n* [EventDefinition](eventdefinition.html): A use context assigned to the event definition\r\n* [Evidence](evidence.html): A use context assigned to the evidence\r\n* [EvidenceReport](evidencereport.html): A use context assigned to the evidence report\r\n* [EvidenceVariable](evidencevariable.html): A use context assigned to the evidence variable\r\n* [ExampleScenario](examplescenario.html): A use context assigned to the example scenario\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [Library](library.html): A use context assigned to the library\r\n* [Measure](measure.html): A use context assigned to the measure\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [PlanDefinition](plandefinition.html): A use context assigned to the plan definition\r\n* [Questionnaire](questionnaire.html): A use context assigned to the questionnaire\r\n* [Requirements](requirements.html): A use context assigned to the requirements\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [TestScript](testscript.html): A use context assigned to the test script\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="date", path="ActivityDefinition.date | ActorDefinition.date | CapabilityStatement.date | ChargeItemDefinition.date | Citation.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | ConditionDefinition.date | EventDefinition.date | Evidence.date | EvidenceVariable.date | ExampleScenario.date | GraphDefinition.date | ImplementationGuide.date | Library.date | Measure.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | PlanDefinition.date | Questionnaire.date | Requirements.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | SubscriptionTopic.date | TerminologyCapabilities.date | TestScript.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The activity definition publication date\r\n* [ActorDefinition](actordefinition.html): The Actor Definition publication date\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The charge item definition publication date\r\n* [Citation](citation.html): The citation publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [ConditionDefinition](conditiondefinition.html): The condition definition publication date\r\n* [EventDefinition](eventdefinition.html): The event definition publication date\r\n* [Evidence](evidence.html): The evidence publication date\r\n* [EvidenceVariable](evidencevariable.html): The evidence variable publication date\r\n* [ExampleScenario](examplescenario.html): The example scenario publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [Library](library.html): The library publication date\r\n* [Measure](measure.html): The measure publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [PlanDefinition](plandefinition.html): The plan definition publication date\r\n* [Questionnaire](questionnaire.html): The questionnaire publication date\r\n* [Requirements](requirements.html): The requirements publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [SubscriptionTopic](subscriptiontopic.html): Date status first applied\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [TestScript](testscript.html): The test script publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="ActivityDefinition.description | ActorDefinition.description | CapabilityStatement.description | ChargeItemDefinition.description | Citation.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | ConditionDefinition.description | EventDefinition.description | Evidence.description | EvidenceVariable.description | GraphDefinition.description | ImplementationGuide.description | Library.description | Measure.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | PlanDefinition.description | Questionnaire.description | Requirements.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | TestScript.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The description of the activity definition\r\n* [ActorDefinition](actordefinition.html): The description of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The description of the charge item definition\r\n* [Citation](citation.html): The description of the citation\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The description of the condition definition\r\n* [EventDefinition](eventdefinition.html): The description of the event definition\r\n* [Evidence](evidence.html): The description of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The description of the evidence variable\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [Library](library.html): The description of the library\r\n* [Measure](measure.html): The description of the measure\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [PlanDefinition](plandefinition.html): The description of the plan definition\r\n* [Questionnaire](questionnaire.html): The description of the questionnaire\r\n* [Requirements](requirements.html): The description of the requirements\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [TestScript](testscript.html): The description of the test script\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="jurisdiction", path="ActivityDefinition.jurisdiction | ActorDefinition.jurisdiction | CapabilityStatement.jurisdiction | ChargeItemDefinition.jurisdiction | Citation.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | ConditionDefinition.jurisdiction | EventDefinition.jurisdiction | ExampleScenario.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | Library.jurisdiction | Measure.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | PlanDefinition.jurisdiction | Questionnaire.jurisdiction | Requirements.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | TestScript.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Intended jurisdiction for the activity definition\r\n* [ActorDefinition](actordefinition.html): Intended jurisdiction for the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Intended jurisdiction for the charge item definition\r\n* [Citation](citation.html): Intended jurisdiction for the citation\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Intended jurisdiction for the condition definition\r\n* [EventDefinition](eventdefinition.html): Intended jurisdiction for the event definition\r\n* [ExampleScenario](examplescenario.html): Intended jurisdiction for the example scenario\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [Library](library.html): Intended jurisdiction for the library\r\n* [Measure](measure.html): Intended jurisdiction for the measure\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [PlanDefinition](plandefinition.html): Intended jurisdiction for the plan definition\r\n* [Questionnaire](questionnaire.html): Intended jurisdiction for the questionnaire\r\n* [Requirements](requirements.html): Intended jurisdiction for the requirements\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [TestScript](testscript.html): Intended jurisdiction for the test script\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ActivityDefinition.name | CapabilityStatement.name | Citation.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | ConditionDefinition.name | EventDefinition.name | EvidenceVariable.name | ExampleScenario.name | GraphDefinition.name | ImplementationGuide.name | Library.name | Measure.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | PlanDefinition.name | Questionnaire.name | Requirements.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | TestScript.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Computationally friendly name of the activity definition\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [Citation](citation.html): Computationally friendly name of the citation\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Computationally friendly name of the condition definition\r\n* [EventDefinition](eventdefinition.html): Computationally friendly name of the event definition\r\n* [EvidenceVariable](evidencevariable.html): Computationally friendly name of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Computationally friendly name of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [Library](library.html): Computationally friendly name of the library\r\n* [Measure](measure.html): Computationally friendly name of the measure\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [PlanDefinition](plandefinition.html): Computationally friendly name of the plan definition\r\n* [Questionnaire](questionnaire.html): Computationally friendly name of the questionnaire\r\n* [Requirements](requirements.html): Computationally friendly name of the requirements\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [TestScript](testscript.html): Computationally friendly name of the test script\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ActivityDefinition.publisher | ActorDefinition.publisher | CapabilityStatement.publisher | ChargeItemDefinition.publisher | Citation.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | ConditionDefinition.publisher | EventDefinition.publisher | Evidence.publisher | EvidenceReport.publisher | EvidenceVariable.publisher | ExampleScenario.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | Library.publisher | Measure.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | PlanDefinition.publisher | Questionnaire.publisher | Requirements.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | TestScript.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): Name of the publisher of the activity definition\r\n* [ActorDefinition](actordefinition.html): Name of the publisher of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): Name of the publisher of the charge item definition\r\n* [Citation](citation.html): Name of the publisher of the citation\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): Name of the publisher of the condition definition\r\n* [EventDefinition](eventdefinition.html): Name of the publisher of the event definition\r\n* [Evidence](evidence.html): Name of the publisher of the evidence\r\n* [EvidenceReport](evidencereport.html): Name of the publisher of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): Name of the publisher of the evidence variable\r\n* [ExampleScenario](examplescenario.html): Name of the publisher of the example scenario\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [Library](library.html): Name of the publisher of the library\r\n* [Measure](measure.html): Name of the publisher of the measure\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [PlanDefinition](plandefinition.html): Name of the publisher of the plan definition\r\n* [Questionnaire](questionnaire.html): Name of the publisher of the questionnaire\r\n* [Requirements](requirements.html): Name of the publisher of the requirements\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [TestScript](testscript.html): Name of the publisher of the test script\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="ActivityDefinition.status | ActorDefinition.status | CapabilityStatement.status | ChargeItemDefinition.status | Citation.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | ConditionDefinition.status | EventDefinition.status | Evidence.status | EvidenceReport.status | EvidenceVariable.status | ExampleScenario.status | GraphDefinition.status | ImplementationGuide.status | Library.status | Measure.status | MedicationKnowledge.status | MessageDefinition.status | NamingSystem.status | ObservationDefinition.status | OperationDefinition.status | PlanDefinition.status | Questionnaire.status | Requirements.status | SearchParameter.status | SpecimenDefinition.status | StructureDefinition.status | StructureMap.status | SubscriptionTopic.status | TerminologyCapabilities.status | TestScript.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The current status of the activity definition\r\n* [ActorDefinition](actordefinition.html): The current status of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The current status of the charge item definition\r\n* [Citation](citation.html): The current status of the citation\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The current status of the condition definition\r\n* [EventDefinition](eventdefinition.html): The current status of the event definition\r\n* [Evidence](evidence.html): The current status of the evidence\r\n* [EvidenceReport](evidencereport.html): The current status of the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The current status of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The current status of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [Library](library.html): The current status of the library\r\n* [Measure](measure.html): The current status of the measure\r\n* [MedicationKnowledge](medicationknowledge.html): active | inactive | entered-in-error\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [ObservationDefinition](observationdefinition.html): Publication status of the ObservationDefinition: draft, active, retired, unknown\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [PlanDefinition](plandefinition.html): The current status of the plan definition\r\n* [Questionnaire](questionnaire.html): The current status of the questionnaire\r\n* [Requirements](requirements.html): The current status of the requirements\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): Publication status of the SpecimenDefinition: draft, active, retired, unknown\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): draft | active | retired | unknown\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [TestScript](testscript.html): The current status of the test script\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="url", path="ActivityDefinition.url | ActorDefinition.url | CapabilityStatement.url | ChargeItemDefinition.url | Citation.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | ConditionDefinition.url | EventDefinition.url | Evidence.url | EvidenceReport.url | EvidenceVariable.url | ExampleScenario.url | GraphDefinition.url | ImplementationGuide.url | Library.url | Measure.url | MessageDefinition.url | NamingSystem.url | ObservationDefinition.url | OperationDefinition.url | PlanDefinition.url | Questionnaire.url | Requirements.url | SearchParameter.url | SpecimenDefinition.url | StructureDefinition.url | StructureMap.url | SubscriptionTopic.url | TerminologyCapabilities.url | TestScript.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The uri that identifies the activity definition\r\n* [ActorDefinition](actordefinition.html): The uri that identifies the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The uri that identifies the charge item definition\r\n* [Citation](citation.html): The uri that identifies the citation\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The URI that identifies the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The uri that identifies the condition definition\r\n* [EventDefinition](eventdefinition.html): The uri that identifies the event definition\r\n* [Evidence](evidence.html): The uri that identifies the evidence\r\n* [EvidenceReport](evidencereport.html): The uri that identifies the evidence report\r\n* [EvidenceVariable](evidencevariable.html): The uri that identifies the evidence variable\r\n* [ExampleScenario](examplescenario.html): The uri that identifies the example scenario\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [Library](library.html): The uri that identifies the library\r\n* [Measure](measure.html): The uri that identifies the measure\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [ObservationDefinition](observationdefinition.html): The uri that identifies the observation definition\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [PlanDefinition](plandefinition.html): The uri that identifies the plan definition\r\n* [Questionnaire](questionnaire.html): The uri that identifies the questionnaire\r\n* [Requirements](requirements.html): The uri that identifies the requirements\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [SpecimenDefinition](specimendefinition.html): The uri that identifies the specimen definition\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Logical canonical URL to reference this SubscriptionTopic (globally unique)\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [TestScript](testscript.html): The uri that identifies the test script\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="ActivityDefinition.version | ActorDefinition.version | CapabilityStatement.version | ChargeItemDefinition.version | Citation.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | ConditionDefinition.version | EventDefinition.version | Evidence.version | EvidenceVariable.version | ExampleScenario.version | GraphDefinition.version | ImplementationGuide.version | Library.version | Measure.version | MessageDefinition.version | NamingSystem.version | OperationDefinition.version | PlanDefinition.version | Questionnaire.version | Requirements.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | SubscriptionTopic.version | TerminologyCapabilities.version | TestScript.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [ActivityDefinition](activitydefinition.html): The business version of the activity definition\r\n* [ActorDefinition](actordefinition.html): The business version of the Actor Definition\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [ChargeItemDefinition](chargeitemdefinition.html): The business version of the charge item definition\r\n* [Citation](citation.html): The business version of the citation\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [ConditionDefinition](conditiondefinition.html): The business version of the condition definition\r\n* [EventDefinition](eventdefinition.html): The business version of the event definition\r\n* [Evidence](evidence.html): The business version of the evidence\r\n* [EvidenceVariable](evidencevariable.html): The business version of the evidence variable\r\n* [ExampleScenario](examplescenario.html): The business version of the example scenario\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [Library](library.html): The business version of the library\r\n* [Measure](measure.html): The business version of the measure\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [NamingSystem](namingsystem.html): The business version of the naming system\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [PlanDefinition](plandefinition.html): The business version of the plan definition\r\n* [Questionnaire](questionnaire.html): The business version of the questionnaire\r\n* [Requirements](requirements.html): The business version of the requirements\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [SubscriptionTopic](subscriptiontopic.html): Business version of the SubscriptionTopic\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [TestScript](testscript.html): The business version of the test script\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="start", path="GraphDefinition.start", description="Type of resource at which the graph starts", type="token")
    public static final String SP_START = "start";
    public static final TokenClientParam START = new TokenClientParam("start");

    public GraphDefinition() {
    }

    public GraphDefinition(String name, Enumerations.PublicationStatus status) {
        this.setName(name);
        this.setStatus(status);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public GraphDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public GraphDefinition setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public GraphDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public GraphDefinition setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public DataType getVersionAlgorithm() {
        return this.versionAlgorithm;
    }

    @Override
    public StringType getVersionAlgorithmStringType() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new StringType();
        }
        if (!(this.versionAlgorithm instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (StringType)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmStringType() {
        return this != null && this.versionAlgorithm instanceof StringType;
    }

    @Override
    public Coding getVersionAlgorithmCoding() throws FHIRException {
        if (this.versionAlgorithm == null) {
            this.versionAlgorithm = new Coding();
        }
        if (!(this.versionAlgorithm instanceof Coding)) {
            throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.versionAlgorithm.getClass().getName() + " was encountered");
        }
        return (Coding)this.versionAlgorithm;
    }

    @Override
    public boolean hasVersionAlgorithmCoding() {
        return this != null && this.versionAlgorithm instanceof Coding;
    }

    @Override
    public boolean hasVersionAlgorithm() {
        return this.versionAlgorithm != null && !this.versionAlgorithm.isEmpty();
    }

    @Override
    public GraphDefinition setVersionAlgorithm(DataType value) {
        if (value != null && !(value instanceof StringType) && !(value instanceof Coding)) {
            throw new Error("Not the right type for GraphDefinition.versionAlgorithm[x]: " + value.fhirType());
        }
        this.versionAlgorithm = value;
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public GraphDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public GraphDefinition setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public GraphDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public GraphDefinition setTitle(String value) {
        if (Utilities.noString(value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public GraphDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public GraphDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public GraphDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public GraphDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public GraphDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public GraphDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public GraphDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public GraphDefinition setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public GraphDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public GraphDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public GraphDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public GraphDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public GraphDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public GraphDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public GraphDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public GraphDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public GraphDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public GraphDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public IdType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new IdType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public GraphDefinition setStartElement(IdType value) {
        this.start = value;
        return this;
    }

    public String getStart() {
        return this.start == null ? null : this.start.getValue();
    }

    public GraphDefinition setStart(String value) {
        if (Utilities.noString(value)) {
            this.start = null;
        } else {
            if (this.start == null) {
                this.start = new IdType();
            }
            this.start.setValue(value);
        }
        return this;
    }

    public List<GraphDefinitionNodeComponent> getNode() {
        if (this.node == null) {
            this.node = new ArrayList<GraphDefinitionNodeComponent>();
        }
        return this.node;
    }

    public GraphDefinition setNode(List<GraphDefinitionNodeComponent> theNode) {
        this.node = theNode;
        return this;
    }

    public boolean hasNode() {
        if (this.node == null) {
            return false;
        }
        for (GraphDefinitionNodeComponent item : this.node) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GraphDefinitionNodeComponent addNode() {
        GraphDefinitionNodeComponent t = new GraphDefinitionNodeComponent();
        if (this.node == null) {
            this.node = new ArrayList<GraphDefinitionNodeComponent>();
        }
        this.node.add(t);
        return t;
    }

    public GraphDefinition addNode(GraphDefinitionNodeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.node == null) {
            this.node = new ArrayList<GraphDefinitionNodeComponent>();
        }
        this.node.add(t);
        return this;
    }

    public GraphDefinitionNodeComponent getNodeFirstRep() {
        if (this.getNode().isEmpty()) {
            this.addNode();
        }
        return this.getNode().get(0);
    }

    public List<GraphDefinitionLinkComponent> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<GraphDefinitionLinkComponent>();
        }
        return this.link;
    }

    public GraphDefinition setLink(List<GraphDefinitionLinkComponent> theLink) {
        this.link = theLink;
        return this;
    }

    public boolean hasLink() {
        if (this.link == null) {
            return false;
        }
        for (GraphDefinitionLinkComponent item : this.link) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GraphDefinitionLinkComponent addLink() {
        GraphDefinitionLinkComponent t = new GraphDefinitionLinkComponent();
        if (this.link == null) {
            this.link = new ArrayList<GraphDefinitionLinkComponent>();
        }
        this.link.add(t);
        return t;
    }

    public GraphDefinition addLink(GraphDefinitionLinkComponent t) {
        if (t == null) {
            return this;
        }
        if (this.link == null) {
            this.link = new ArrayList<GraphDefinitionLinkComponent>();
        }
        this.link.add(t);
        return this;
    }

    public GraphDefinitionLinkComponent getLinkFirstRep() {
        if (this.getLink().isEmpty()) {
            this.addLink();
        }
        return this.getLink().get(0);
    }

    @Override
    public int getIdentifierMax() {
        return 0;
    }

    @Override
    public List<Identifier> getIdentifier() {
        return new ArrayList<Identifier>();
    }

    @Override
    public GraphDefinition setIdentifier(List<Identifier> theIdentifier) {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"identifier\"");
    }

    @Override
    public boolean hasIdentifier() {
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"identifier\"");
    }

    @Override
    public GraphDefinition addIdentifier(Identifier t) {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"identifier\"");
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"identifier\"");
    }

    @Override
    public int getCopyrightMax() {
        return 0;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public boolean hasCopyrightElement() {
        return false;
    }

    @Override
    public boolean hasCopyright() {
        return false;
    }

    @Override
    public GraphDefinition setCopyrightElement(MarkdownType value) {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public String getCopyright() {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public GraphDefinition setCopyright(String value) {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"copyright\"");
    }

    @Override
    public int getCopyrightLabelMax() {
        return 0;
    }

    @Override
    public StringType getCopyrightLabelElement() {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public boolean hasCopyrightLabelElement() {
        return false;
    }

    @Override
    public boolean hasCopyrightLabel() {
        return false;
    }

    @Override
    public GraphDefinition setCopyrightLabelElement(StringType value) {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public String getCopyrightLabel() {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    public GraphDefinition setCopyrightLabel(String value) {
        throw new Error("The resource type \"GraphDefinition\" does not implement the property \"copyrightLabel\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this graph definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this graph definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the graph definition is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the graph definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the graph definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the graph definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property("title", "string", "A short, descriptive, user-friendly title for the capability statement.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this graph definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this graph definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the graph definition was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the graph definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the graph definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the graph definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate graph definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the graph definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this graph definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property(SP_START, "id", "The Node at which instances of this graph start. If there is no nominated start, the graph can start at any of the nodes.", 0, 1, this.start));
        children.add(new Property("node", "", "Potential target for the link.", 0, Integer.MAX_VALUE, this.node));
        children.add(new Property("link", "", "Links this graph makes rules about.", 0, Integer.MAX_VALUE, this.link));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this graph definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this graph definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the graph definition is stored on different servers.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the graph definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the graph definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case -115699031: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1508158071: {
                return new Property("versionAlgorithm[x]", "string|Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1836908904: {
                return new Property("versionAlgorithm[x]", "string", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 1373807809: {
                return new Property("versionAlgorithm[x]", "Coding", "Indicates the mechanism used to compare versions to determine which is more current.", 0, 1, this.versionAlgorithm);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the graph definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property("title", "string", "A short, descriptive, user-friendly title for the capability statement.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this graph definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this graph definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the graph definition was last significantly changed. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the graph definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual responsible for the release and ongoing maintenance of the graph definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the graph definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate graph definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the graph definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this graph definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 109757538: {
                return new Property(SP_START, "id", "The Node at which instances of this graph start. If there is no nominated start, the graph can start at any of the nodes.", 0, 1, this.start);
            }
            case 3386882: {
                return new Property("node", "", "Potential target for the link.", 0, Integer.MAX_VALUE, this.node);
            }
            case 3321850: {
                return new Property("link", "", "Links this graph makes rules about.", 0, Integer.MAX_VALUE, this.link);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 1508158071: {
                Base[] baseArray;
                if (this.versionAlgorithm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.versionAlgorithm;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.start;
                }
                return baseArray;
            }
            case 3386882: {
                return this.node == null ? new Base[]{} : this.node.toArray(new Base[this.node.size()]);
            }
            case 3321850: {
                return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 1508158071: {
                this.versionAlgorithm = TypeConvertor.castToType(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 109757538: {
                this.start = TypeConvertor.castToId(value);
                return value;
            }
            case 3386882: {
                this.getNode().add((GraphDefinitionNodeComponent)((Object)value));
                return value;
            }
            case 3321850: {
                this.getLink().add((GraphDefinitionLinkComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("versionAlgorithm[x]")) {
            this.versionAlgorithm = TypeConvertor.castToType(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("title")) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals(SP_START)) {
            this.start = TypeConvertor.castToId(value);
        } else if (name.equals("node")) {
            this.getNode().add((GraphDefinitionNodeComponent)((Object)value));
        } else if (name.equals("link")) {
            this.getLink().add((GraphDefinitionLinkComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -115699031: {
                return this.getVersionAlgorithm();
            }
            case 1508158071: {
                return this.getVersionAlgorithm();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 109757538: {
                return this.getStartElement();
            }
            case 3386882: {
                return this.addNode();
            }
            case 3321850: {
                return this.addLink();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 1508158071: {
                return new String[]{"string", "Coding"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 109757538: {
                return new String[]{"id"};
            }
            case 3386882: {
                return new String[0];
            }
            case 3321850: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.version");
        }
        if (name.equals("versionAlgorithmString")) {
            this.versionAlgorithm = new StringType();
            return this.versionAlgorithm;
        }
        if (name.equals("versionAlgorithmCoding")) {
            this.versionAlgorithm = new Coding();
            return this.versionAlgorithm;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.name");
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.purpose");
        }
        if (name.equals(SP_START)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.start");
        }
        if (name.equals("node")) {
            return this.addNode();
        }
        if (name.equals("link")) {
            return this.addLink();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "GraphDefinition";
    }

    @Override
    public GraphDefinition copy() {
        GraphDefinition dst = new GraphDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(GraphDefinition dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.versionAlgorithm = this.versionAlgorithm == null ? null : this.versionAlgorithm.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        IdType idType = dst.start = this.start == null ? null : this.start.copy();
        if (this.node != null) {
            dst.node = new ArrayList<GraphDefinitionNodeComponent>();
            for (GraphDefinitionNodeComponent graphDefinitionNodeComponent : this.node) {
                dst.node.add(graphDefinitionNodeComponent.copy());
            }
        }
        if (this.link != null) {
            dst.link = new ArrayList<GraphDefinitionLinkComponent>();
            for (GraphDefinitionLinkComponent graphDefinitionLinkComponent : this.link) {
                dst.link.add(graphDefinitionLinkComponent.copy());
            }
        }
    }

    protected GraphDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof GraphDefinition)) {
            return false;
        }
        GraphDefinition o = (GraphDefinition)other_;
        return GraphDefinition.compareDeep(this.url, o.url, true) && GraphDefinition.compareDeep(this.version, o.version, true) && GraphDefinition.compareDeep(this.versionAlgorithm, o.versionAlgorithm, true) && GraphDefinition.compareDeep(this.name, o.name, true) && GraphDefinition.compareDeep(this.title, o.title, true) && GraphDefinition.compareDeep(this.status, o.status, true) && GraphDefinition.compareDeep(this.experimental, o.experimental, true) && GraphDefinition.compareDeep(this.date, o.date, true) && GraphDefinition.compareDeep(this.publisher, o.publisher, true) && GraphDefinition.compareDeep(this.contact, o.contact, true) && GraphDefinition.compareDeep(this.description, o.description, true) && GraphDefinition.compareDeep(this.useContext, o.useContext, true) && GraphDefinition.compareDeep(this.jurisdiction, o.jurisdiction, true) && GraphDefinition.compareDeep(this.purpose, o.purpose, true) && GraphDefinition.compareDeep(this.start, o.start, true) && GraphDefinition.compareDeep(this.node, o.node, true) && GraphDefinition.compareDeep(this.link, o.link, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof GraphDefinition)) {
            return false;
        }
        GraphDefinition o = (GraphDefinition)other_;
        return GraphDefinition.compareValues(this.url, o.url, true) && GraphDefinition.compareValues(this.version, o.version, true) && GraphDefinition.compareValues(this.name, o.name, true) && GraphDefinition.compareValues(this.title, o.title, true) && GraphDefinition.compareValues(this.status, o.status, true) && GraphDefinition.compareValues(this.experimental, o.experimental, true) && GraphDefinition.compareValues(this.date, o.date, true) && GraphDefinition.compareValues(this.publisher, o.publisher, true) && GraphDefinition.compareValues(this.description, o.description, true) && GraphDefinition.compareValues(this.purpose, o.purpose, true) && GraphDefinition.compareValues(this.start, o.start, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.url, this.version, this.versionAlgorithm, this.name, this.title, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.start, this.node, this.link);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.GraphDefinition;
    }

    @Override
    public boolean supportsCopyright() {
        return false;
    }

    @Block
    public static class GraphDefinitionLinkCompartmentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="use", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="where | requires", formalDefinition="Defines how the compartment rule is used - whether it it is used to test whether resources are subject to the rule, or whether it is a rule that must be followed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/graph-compartment-use")
        protected Enumeration<GraphCompartmentUse> use;
        @Child(name="rule", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="identical | matching | different | custom", formalDefinition="identical | matching | different | no-rule | custom.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/graph-compartment-rule")
        protected Enumeration<GraphCompartmentRule> rule;
        @Child(name="code", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Patient | Encounter | RelatedPerson | Practitioner | Device", formalDefinition="Identifies the compartment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/compartment-type")
        protected Enumeration<Enumerations.CompartmentType> code;
        @Child(name="expression", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Custom rule, as a FHIRPath expression", formalDefinition="Custom rule, as a FHIRPath expression.")
        protected StringType expression;
        @Child(name="description", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Documentation for FHIRPath expression", formalDefinition="Documentation for FHIRPath expression.")
        protected StringType description;
        private static final long serialVersionUID = 2140045786L;

        public GraphDefinitionLinkCompartmentComponent() {
        }

        public GraphDefinitionLinkCompartmentComponent(GraphCompartmentUse use, GraphCompartmentRule rule, Enumerations.CompartmentType code) {
            this.setUse(use);
            this.setRule(rule);
            this.setCode(code);
        }

        public Enumeration<GraphCompartmentUse> getUseElement() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkCompartmentComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new Enumeration<GraphCompartmentUse>(new GraphCompartmentUseEnumFactory());
                }
            }
            return this.use;
        }

        public boolean hasUseElement() {
            return this.use != null && !this.use.isEmpty();
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public GraphDefinitionLinkCompartmentComponent setUseElement(Enumeration<GraphCompartmentUse> value) {
            this.use = value;
            return this;
        }

        public GraphCompartmentUse getUse() {
            return this.use == null ? null : (GraphCompartmentUse)((Object)this.use.getValue());
        }

        public GraphDefinitionLinkCompartmentComponent setUse(GraphCompartmentUse value) {
            if (this.use == null) {
                this.use = new Enumeration<GraphCompartmentUse>(new GraphCompartmentUseEnumFactory());
            }
            this.use.setValue((Object)value);
            return this;
        }

        public Enumeration<GraphCompartmentRule> getRuleElement() {
            if (this.rule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkCompartmentComponent.rule");
                }
                if (Configuration.doAutoCreate()) {
                    this.rule = new Enumeration<GraphCompartmentRule>(new GraphCompartmentRuleEnumFactory());
                }
            }
            return this.rule;
        }

        public boolean hasRuleElement() {
            return this.rule != null && !this.rule.isEmpty();
        }

        public boolean hasRule() {
            return this.rule != null && !this.rule.isEmpty();
        }

        public GraphDefinitionLinkCompartmentComponent setRuleElement(Enumeration<GraphCompartmentRule> value) {
            this.rule = value;
            return this;
        }

        public GraphCompartmentRule getRule() {
            return this.rule == null ? null : (GraphCompartmentRule)((Object)this.rule.getValue());
        }

        public GraphDefinitionLinkCompartmentComponent setRule(GraphCompartmentRule value) {
            if (this.rule == null) {
                this.rule = new Enumeration<GraphCompartmentRule>(new GraphCompartmentRuleEnumFactory());
            }
            this.rule.setValue((Object)value);
            return this;
        }

        public Enumeration<Enumerations.CompartmentType> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkCompartmentComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<Enumerations.CompartmentType>(new Enumerations.CompartmentTypeEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public GraphDefinitionLinkCompartmentComponent setCodeElement(Enumeration<Enumerations.CompartmentType> value) {
            this.code = value;
            return this;
        }

        public Enumerations.CompartmentType getCode() {
            return this.code == null ? null : (Enumerations.CompartmentType)((Object)this.code.getValue());
        }

        public GraphDefinitionLinkCompartmentComponent setCode(Enumerations.CompartmentType value) {
            if (this.code == null) {
                this.code = new Enumeration<Enumerations.CompartmentType>(new Enumerations.CompartmentTypeEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkCompartmentComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public GraphDefinitionLinkCompartmentComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public GraphDefinitionLinkCompartmentComponent setExpression(String value) {
            if (Utilities.noString(value)) {
                this.expression = null;
            } else {
                if (this.expression == null) {
                    this.expression = new StringType();
                }
                this.expression.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkCompartmentComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public GraphDefinitionLinkCompartmentComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public GraphDefinitionLinkCompartmentComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("use", "code", "Defines how the compartment rule is used - whether it it is used to test whether resources are subject to the rule, or whether it is a rule that must be followed.", 0, 1, this.use));
            children.add(new Property("rule", "code", "identical | matching | different | no-rule | custom.", 0, 1, this.rule));
            children.add(new Property("code", "code", "Identifies the compartment.", 0, 1, this.code));
            children.add(new Property("expression", "string", "Custom rule, as a FHIRPath expression.", 0, 1, this.expression));
            children.add(new Property(GraphDefinition.SP_DESCRIPTION, "string", "Documentation for FHIRPath expression.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 116103: {
                    return new Property("use", "code", "Defines how the compartment rule is used - whether it it is used to test whether resources are subject to the rule, or whether it is a rule that must be followed.", 0, 1, this.use);
                }
                case 3512060: {
                    return new Property("rule", "code", "identical | matching | different | no-rule | custom.", 0, 1, this.rule);
                }
                case 3059181: {
                    return new Property("code", "code", "Identifies the compartment.", 0, 1, this.code);
                }
                case -1795452264: {
                    return new Property("expression", "string", "Custom rule, as a FHIRPath expression.", 0, 1, this.expression);
                }
                case -1724546052: {
                    return new Property(GraphDefinition.SP_DESCRIPTION, "string", "Documentation for FHIRPath expression.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.use;
                    }
                    return baseArray;
                }
                case 3512060: {
                    Base[] baseArray;
                    if (this.rule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.rule;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.code;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.expression;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 116103: {
                    value = new GraphCompartmentUseEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.use = value;
                    return value;
                }
                case 3512060: {
                    value = new GraphCompartmentRuleEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.rule = value;
                    return value;
                }
                case 3059181: {
                    value = new Enumerations.CompartmentTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.code = value;
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("use")) {
                value = new GraphCompartmentUseEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.use = value;
            } else if (name.equals("rule")) {
                value = new GraphCompartmentRuleEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.rule = value;
            } else if (name.equals("code")) {
                value = new Enumerations.CompartmentTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.code = value;
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToString(value);
            } else if (name.equals(GraphDefinition.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116103: {
                    return this.getUseElement();
                }
                case 3512060: {
                    return this.getRuleElement();
                }
                case 3059181: {
                    return this.getCodeElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 116103: {
                    return new String[]{"code"};
                }
                case 3512060: {
                    return new String[]{"code"};
                }
                case 3059181: {
                    return new String[]{"code"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("use")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.compartment.use");
            }
            if (name.equals("rule")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.compartment.rule");
            }
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.compartment.code");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.compartment.expression");
            }
            if (name.equals(GraphDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.compartment.description");
            }
            return super.addChild(name);
        }

        @Override
        public GraphDefinitionLinkCompartmentComponent copy() {
            GraphDefinitionLinkCompartmentComponent dst = new GraphDefinitionLinkCompartmentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GraphDefinitionLinkCompartmentComponent dst) {
            super.copyValues(dst);
            dst.use = this.use == null ? null : this.use.copy();
            dst.rule = this.rule == null ? null : this.rule.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionLinkCompartmentComponent)) {
                return false;
            }
            GraphDefinitionLinkCompartmentComponent o = (GraphDefinitionLinkCompartmentComponent)other_;
            return GraphDefinitionLinkCompartmentComponent.compareDeep(this.use, o.use, true) && GraphDefinitionLinkCompartmentComponent.compareDeep(this.rule, o.rule, true) && GraphDefinitionLinkCompartmentComponent.compareDeep(this.code, o.code, true) && GraphDefinitionLinkCompartmentComponent.compareDeep(this.expression, o.expression, true) && GraphDefinitionLinkCompartmentComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionLinkCompartmentComponent)) {
                return false;
            }
            GraphDefinitionLinkCompartmentComponent o = (GraphDefinitionLinkCompartmentComponent)other_;
            return GraphDefinitionLinkCompartmentComponent.compareValues(this.use, o.use, true) && GraphDefinitionLinkCompartmentComponent.compareValues(this.rule, o.rule, true) && GraphDefinitionLinkCompartmentComponent.compareValues(this.code, o.code, true) && GraphDefinitionLinkCompartmentComponent.compareValues(this.expression, o.expression, true) && GraphDefinitionLinkCompartmentComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.use, this.rule, this.code, this.expression, this.description);
        }

        @Override
        public String fhirType() {
            return "GraphDefinition.link.compartment";
        }
    }

    @Block
    public static class GraphDefinitionLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why this link is specified", formalDefinition="Information about why this link is of interest in this graph definition.")
        protected StringType description;
        @Child(name="min", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Minimum occurrences for this link", formalDefinition="Minimum occurrences for this link.")
        protected IntegerType min;
        @Child(name="max", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum occurrences for this link", formalDefinition="Maximum occurrences for this link.")
        protected StringType max;
        @Child(name="sourceId", type={IdType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Source Node for this link", formalDefinition="The source node for this link.")
        protected IdType sourceId;
        @Child(name="path", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Path in the resource that contains the link", formalDefinition="A FHIRPath expression that identifies one of FHIR References to other resources.")
        protected StringType path;
        @Child(name="sliceName", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Which slice (if profiled)", formalDefinition="Which slice (if profiled).")
        protected StringType sliceName;
        @Child(name="targetId", type={IdType.class}, order=7, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Target Node for this link", formalDefinition="The target node for this link.")
        protected IdType targetId;
        @Child(name="params", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Criteria for reverse lookup", formalDefinition="A set of parameters to look up.")
        protected StringType params;
        @Child(name="compartment", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Compartment Consistency Rules", formalDefinition="Compartment Consistency Rules.")
        protected List<GraphDefinitionLinkCompartmentComponent> compartment;
        private static final long serialVersionUID = -433118895L;

        public GraphDefinitionLinkComponent() {
        }

        public GraphDefinitionLinkComponent(String sourceId, String targetId) {
            this.setSourceId(sourceId);
            this.setTargetId(targetId);
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public GraphDefinitionLinkComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public GraphDefinitionLinkComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public IntegerType getMinElement() {
            if (this.min == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.min");
                }
                if (Configuration.doAutoCreate()) {
                    this.min = new IntegerType();
                }
            }
            return this.min;
        }

        public boolean hasMinElement() {
            return this.min != null && !this.min.isEmpty();
        }

        public boolean hasMin() {
            return this.min != null && !this.min.isEmpty();
        }

        public GraphDefinitionLinkComponent setMinElement(IntegerType value) {
            this.min = value;
            return this;
        }

        public int getMin() {
            return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
        }

        public GraphDefinitionLinkComponent setMin(int value) {
            if (this.min == null) {
                this.min = new IntegerType();
            }
            this.min.setValue((Object)value);
            return this;
        }

        public StringType getMaxElement() {
            if (this.max == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.max");
                }
                if (Configuration.doAutoCreate()) {
                    this.max = new StringType();
                }
            }
            return this.max;
        }

        public boolean hasMaxElement() {
            return this.max != null && !this.max.isEmpty();
        }

        public boolean hasMax() {
            return this.max != null && !this.max.isEmpty();
        }

        public GraphDefinitionLinkComponent setMaxElement(StringType value) {
            this.max = value;
            return this;
        }

        public String getMax() {
            return this.max == null ? null : (String)this.max.getValue();
        }

        public GraphDefinitionLinkComponent setMax(String value) {
            if (Utilities.noString(value)) {
                this.max = null;
            } else {
                if (this.max == null) {
                    this.max = new StringType();
                }
                this.max.setValue(value);
            }
            return this;
        }

        public IdType getSourceIdElement() {
            if (this.sourceId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.sourceId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sourceId = new IdType();
                }
            }
            return this.sourceId;
        }

        public boolean hasSourceIdElement() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public boolean hasSourceId() {
            return this.sourceId != null && !this.sourceId.isEmpty();
        }

        public GraphDefinitionLinkComponent setSourceIdElement(IdType value) {
            this.sourceId = value;
            return this;
        }

        public String getSourceId() {
            return this.sourceId == null ? null : this.sourceId.getValue();
        }

        public GraphDefinitionLinkComponent setSourceId(String value) {
            if (this.sourceId == null) {
                this.sourceId = new IdType();
            }
            this.sourceId.setValue(value);
            return this;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public GraphDefinitionLinkComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public GraphDefinitionLinkComponent setPath(String value) {
            if (Utilities.noString(value)) {
                this.path = null;
            } else {
                if (this.path == null) {
                    this.path = new StringType();
                }
                this.path.setValue(value);
            }
            return this;
        }

        public StringType getSliceNameElement() {
            if (this.sliceName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.sliceName");
                }
                if (Configuration.doAutoCreate()) {
                    this.sliceName = new StringType();
                }
            }
            return this.sliceName;
        }

        public boolean hasSliceNameElement() {
            return this.sliceName != null && !this.sliceName.isEmpty();
        }

        public boolean hasSliceName() {
            return this.sliceName != null && !this.sliceName.isEmpty();
        }

        public GraphDefinitionLinkComponent setSliceNameElement(StringType value) {
            this.sliceName = value;
            return this;
        }

        public String getSliceName() {
            return this.sliceName == null ? null : (String)this.sliceName.getValue();
        }

        public GraphDefinitionLinkComponent setSliceName(String value) {
            if (Utilities.noString(value)) {
                this.sliceName = null;
            } else {
                if (this.sliceName == null) {
                    this.sliceName = new StringType();
                }
                this.sliceName.setValue(value);
            }
            return this;
        }

        public IdType getTargetIdElement() {
            if (this.targetId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.targetId");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetId = new IdType();
                }
            }
            return this.targetId;
        }

        public boolean hasTargetIdElement() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public boolean hasTargetId() {
            return this.targetId != null && !this.targetId.isEmpty();
        }

        public GraphDefinitionLinkComponent setTargetIdElement(IdType value) {
            this.targetId = value;
            return this;
        }

        public String getTargetId() {
            return this.targetId == null ? null : this.targetId.getValue();
        }

        public GraphDefinitionLinkComponent setTargetId(String value) {
            if (this.targetId == null) {
                this.targetId = new IdType();
            }
            this.targetId.setValue(value);
            return this;
        }

        public StringType getParamsElement() {
            if (this.params == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.params");
                }
                if (Configuration.doAutoCreate()) {
                    this.params = new StringType();
                }
            }
            return this.params;
        }

        public boolean hasParamsElement() {
            return this.params != null && !this.params.isEmpty();
        }

        public boolean hasParams() {
            return this.params != null && !this.params.isEmpty();
        }

        public GraphDefinitionLinkComponent setParamsElement(StringType value) {
            this.params = value;
            return this;
        }

        public String getParams() {
            return this.params == null ? null : (String)this.params.getValue();
        }

        public GraphDefinitionLinkComponent setParams(String value) {
            if (Utilities.noString(value)) {
                this.params = null;
            } else {
                if (this.params == null) {
                    this.params = new StringType();
                }
                this.params.setValue(value);
            }
            return this;
        }

        public List<GraphDefinitionLinkCompartmentComponent> getCompartment() {
            if (this.compartment == null) {
                this.compartment = new ArrayList<GraphDefinitionLinkCompartmentComponent>();
            }
            return this.compartment;
        }

        public GraphDefinitionLinkComponent setCompartment(List<GraphDefinitionLinkCompartmentComponent> theCompartment) {
            this.compartment = theCompartment;
            return this;
        }

        public boolean hasCompartment() {
            if (this.compartment == null) {
                return false;
            }
            for (GraphDefinitionLinkCompartmentComponent item : this.compartment) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GraphDefinitionLinkCompartmentComponent addCompartment() {
            GraphDefinitionLinkCompartmentComponent t = new GraphDefinitionLinkCompartmentComponent();
            if (this.compartment == null) {
                this.compartment = new ArrayList<GraphDefinitionLinkCompartmentComponent>();
            }
            this.compartment.add(t);
            return t;
        }

        public GraphDefinitionLinkComponent addCompartment(GraphDefinitionLinkCompartmentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.compartment == null) {
                this.compartment = new ArrayList<GraphDefinitionLinkCompartmentComponent>();
            }
            this.compartment.add(t);
            return this;
        }

        public GraphDefinitionLinkCompartmentComponent getCompartmentFirstRep() {
            if (this.getCompartment().isEmpty()) {
                this.addCompartment();
            }
            return this.getCompartment().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(GraphDefinition.SP_DESCRIPTION, "string", "Information about why this link is of interest in this graph definition.", 0, 1, this.description));
            children.add(new Property("min", "integer", "Minimum occurrences for this link.", 0, 1, this.min));
            children.add(new Property("max", "string", "Maximum occurrences for this link.", 0, 1, this.max));
            children.add(new Property("sourceId", "id", "The source node for this link.", 0, 1, this.sourceId));
            children.add(new Property("path", "string", "A FHIRPath expression that identifies one of FHIR References to other resources.", 0, 1, this.path));
            children.add(new Property("sliceName", "string", "Which slice (if profiled).", 0, 1, this.sliceName));
            children.add(new Property("targetId", "id", "The target node for this link.", 0, 1, this.targetId));
            children.add(new Property("params", "string", "A set of parameters to look up.", 0, 1, this.params));
            children.add(new Property("compartment", "", "Compartment Consistency Rules.", 0, Integer.MAX_VALUE, this.compartment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property(GraphDefinition.SP_DESCRIPTION, "string", "Information about why this link is of interest in this graph definition.", 0, 1, this.description);
                }
                case 108114: {
                    return new Property("min", "integer", "Minimum occurrences for this link.", 0, 1, this.min);
                }
                case 107876: {
                    return new Property("max", "string", "Maximum occurrences for this link.", 0, 1, this.max);
                }
                case 1746327190: {
                    return new Property("sourceId", "id", "The source node for this link.", 0, 1, this.sourceId);
                }
                case 3433509: {
                    return new Property("path", "string", "A FHIRPath expression that identifies one of FHIR References to other resources.", 0, 1, this.path);
                }
                case -825289923: {
                    return new Property("sliceName", "string", "Which slice (if profiled).", 0, 1, this.sliceName);
                }
                case -441951604: {
                    return new Property("targetId", "id", "The target node for this link.", 0, 1, this.targetId);
                }
                case -995427962: {
                    return new Property("params", "string", "A set of parameters to look up.", 0, 1, this.params);
                }
                case -397756334: {
                    return new Property("compartment", "", "Compartment Consistency Rules.", 0, Integer.MAX_VALUE, this.compartment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 108114: {
                    Base[] baseArray;
                    if (this.min == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.min;
                    }
                    return baseArray;
                }
                case 107876: {
                    Base[] baseArray;
                    if (this.max == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.max;
                    }
                    return baseArray;
                }
                case 1746327190: {
                    Base[] baseArray;
                    if (this.sourceId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.sourceId;
                    }
                    return baseArray;
                }
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.path;
                    }
                    return baseArray;
                }
                case -825289923: {
                    Base[] baseArray;
                    if (this.sliceName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.sliceName;
                    }
                    return baseArray;
                }
                case -441951604: {
                    Base[] baseArray;
                    if (this.targetId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.targetId;
                    }
                    return baseArray;
                }
                case -995427962: {
                    Base[] baseArray;
                    if (this.params == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.params;
                    }
                    return baseArray;
                }
                case -397756334: {
                    return this.compartment == null ? new Base[]{} : this.compartment.toArray(new Base[this.compartment.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 108114: {
                    this.min = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 107876: {
                    this.max = TypeConvertor.castToString(value);
                    return value;
                }
                case 1746327190: {
                    this.sourceId = TypeConvertor.castToId(value);
                    return value;
                }
                case 3433509: {
                    this.path = TypeConvertor.castToString(value);
                    return value;
                }
                case -825289923: {
                    this.sliceName = TypeConvertor.castToString(value);
                    return value;
                }
                case -441951604: {
                    this.targetId = TypeConvertor.castToId(value);
                    return value;
                }
                case -995427962: {
                    this.params = TypeConvertor.castToString(value);
                    return value;
                }
                case -397756334: {
                    this.getCompartment().add((GraphDefinitionLinkCompartmentComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(GraphDefinition.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("min")) {
                this.min = TypeConvertor.castToInteger(value);
            } else if (name.equals("max")) {
                this.max = TypeConvertor.castToString(value);
            } else if (name.equals("sourceId")) {
                this.sourceId = TypeConvertor.castToId(value);
            } else if (name.equals("path")) {
                this.path = TypeConvertor.castToString(value);
            } else if (name.equals("sliceName")) {
                this.sliceName = TypeConvertor.castToString(value);
            } else if (name.equals("targetId")) {
                this.targetId = TypeConvertor.castToId(value);
            } else if (name.equals("params")) {
                this.params = TypeConvertor.castToString(value);
            } else if (name.equals("compartment")) {
                this.getCompartment().add((GraphDefinitionLinkCompartmentComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 108114: {
                    return this.getMinElement();
                }
                case 107876: {
                    return this.getMaxElement();
                }
                case 1746327190: {
                    return this.getSourceIdElement();
                }
                case 3433509: {
                    return this.getPathElement();
                }
                case -825289923: {
                    return this.getSliceNameElement();
                }
                case -441951604: {
                    return this.getTargetIdElement();
                }
                case -995427962: {
                    return this.getParamsElement();
                }
                case -397756334: {
                    return this.addCompartment();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 108114: {
                    return new String[]{"integer"};
                }
                case 107876: {
                    return new String[]{"string"};
                }
                case 1746327190: {
                    return new String[]{"id"};
                }
                case 3433509: {
                    return new String[]{"string"};
                }
                case -825289923: {
                    return new String[]{"string"};
                }
                case -441951604: {
                    return new String[]{"id"};
                }
                case -995427962: {
                    return new String[]{"string"};
                }
                case -397756334: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(GraphDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.description");
            }
            if (name.equals("min")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.min");
            }
            if (name.equals("max")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.max");
            }
            if (name.equals("sourceId")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.sourceId");
            }
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.path");
            }
            if (name.equals("sliceName")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.sliceName");
            }
            if (name.equals("targetId")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.targetId");
            }
            if (name.equals("params")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.link.params");
            }
            if (name.equals("compartment")) {
                return this.addCompartment();
            }
            return super.addChild(name);
        }

        @Override
        public GraphDefinitionLinkComponent copy() {
            GraphDefinitionLinkComponent dst = new GraphDefinitionLinkComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GraphDefinitionLinkComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.min = this.min == null ? null : this.min.copy();
            dst.max = this.max == null ? null : this.max.copy();
            dst.sourceId = this.sourceId == null ? null : this.sourceId.copy();
            dst.path = this.path == null ? null : this.path.copy();
            dst.sliceName = this.sliceName == null ? null : this.sliceName.copy();
            dst.targetId = this.targetId == null ? null : this.targetId.copy();
            StringType stringType = dst.params = this.params == null ? null : this.params.copy();
            if (this.compartment != null) {
                dst.compartment = new ArrayList<GraphDefinitionLinkCompartmentComponent>();
                for (GraphDefinitionLinkCompartmentComponent i2 : this.compartment) {
                    dst.compartment.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionLinkComponent)) {
                return false;
            }
            GraphDefinitionLinkComponent o = (GraphDefinitionLinkComponent)other_;
            return GraphDefinitionLinkComponent.compareDeep(this.description, o.description, true) && GraphDefinitionLinkComponent.compareDeep(this.min, o.min, true) && GraphDefinitionLinkComponent.compareDeep(this.max, o.max, true) && GraphDefinitionLinkComponent.compareDeep(this.sourceId, o.sourceId, true) && GraphDefinitionLinkComponent.compareDeep(this.path, o.path, true) && GraphDefinitionLinkComponent.compareDeep(this.sliceName, o.sliceName, true) && GraphDefinitionLinkComponent.compareDeep(this.targetId, o.targetId, true) && GraphDefinitionLinkComponent.compareDeep(this.params, o.params, true) && GraphDefinitionLinkComponent.compareDeep(this.compartment, o.compartment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionLinkComponent)) {
                return false;
            }
            GraphDefinitionLinkComponent o = (GraphDefinitionLinkComponent)other_;
            return GraphDefinitionLinkComponent.compareValues(this.description, o.description, true) && GraphDefinitionLinkComponent.compareValues(this.min, o.min, true) && GraphDefinitionLinkComponent.compareValues(this.max, o.max, true) && GraphDefinitionLinkComponent.compareValues(this.sourceId, o.sourceId, true) && GraphDefinitionLinkComponent.compareValues(this.path, o.path, true) && GraphDefinitionLinkComponent.compareValues(this.sliceName, o.sliceName, true) && GraphDefinitionLinkComponent.compareValues(this.targetId, o.targetId, true) && GraphDefinitionLinkComponent.compareValues(this.params, o.params, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.description, this.min, this.max, this.sourceId, this.path, this.sliceName, this.targetId, this.params, this.compartment);
        }

        @Override
        public String fhirType() {
            return "GraphDefinition.link";
        }
    }

    @Block
    public static class GraphDefinitionNodeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="nodeId", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Internal ID - target for link references", formalDefinition="Internal ID of node - target for link references.")
        protected IdType nodeId;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why this node is specified", formalDefinition="Information about why this node is of interest in this graph definition.")
        protected StringType description;
        @Child(name="type", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of resource this link refers to", formalDefinition="Type of resource this link refers to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-resource-types")
        protected Enumeration<Enumerations.AllResourceTypes> type;
        @Child(name="profile", type={CanonicalType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Profile for the target resource", formalDefinition="Profile for the target resource.")
        protected CanonicalType profile;
        private static final long serialVersionUID = 938227649L;

        public GraphDefinitionNodeComponent() {
        }

        public GraphDefinitionNodeComponent(String nodeId, Enumerations.AllResourceTypes type) {
            this.setNodeId(nodeId);
            this.setType(type);
        }

        public IdType getNodeIdElement() {
            if (this.nodeId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionNodeComponent.nodeId");
                }
                if (Configuration.doAutoCreate()) {
                    this.nodeId = new IdType();
                }
            }
            return this.nodeId;
        }

        public boolean hasNodeIdElement() {
            return this.nodeId != null && !this.nodeId.isEmpty();
        }

        public boolean hasNodeId() {
            return this.nodeId != null && !this.nodeId.isEmpty();
        }

        public GraphDefinitionNodeComponent setNodeIdElement(IdType value) {
            this.nodeId = value;
            return this;
        }

        public String getNodeId() {
            return this.nodeId == null ? null : this.nodeId.getValue();
        }

        public GraphDefinitionNodeComponent setNodeId(String value) {
            if (this.nodeId == null) {
                this.nodeId = new IdType();
            }
            this.nodeId.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionNodeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public GraphDefinitionNodeComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public GraphDefinitionNodeComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Enumeration<Enumerations.AllResourceTypes> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionNodeComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.AllResourceTypes>(new Enumerations.AllResourceTypesEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public GraphDefinitionNodeComponent setTypeElement(Enumeration<Enumerations.AllResourceTypes> value) {
            this.type = value;
            return this;
        }

        public Enumerations.AllResourceTypes getType() {
            return this.type == null ? null : (Enumerations.AllResourceTypes)((Object)this.type.getValue());
        }

        public GraphDefinitionNodeComponent setType(Enumerations.AllResourceTypes value) {
            if (this.type == null) {
                this.type = new Enumeration<Enumerations.AllResourceTypes>(new Enumerations.AllResourceTypesEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public CanonicalType getProfileElement() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionNodeComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new CanonicalType();
                }
            }
            return this.profile;
        }

        public boolean hasProfileElement() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public GraphDefinitionNodeComponent setProfileElement(CanonicalType value) {
            this.profile = value;
            return this;
        }

        public String getProfile() {
            return this.profile == null ? null : (String)this.profile.getValue();
        }

        public GraphDefinitionNodeComponent setProfile(String value) {
            if (Utilities.noString(value)) {
                this.profile = null;
            } else {
                if (this.profile == null) {
                    this.profile = new CanonicalType();
                }
                this.profile.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("nodeId", "id", "Internal ID of node - target for link references.", 0, 1, this.nodeId));
            children.add(new Property(GraphDefinition.SP_DESCRIPTION, "string", "Information about why this node is of interest in this graph definition.", 0, 1, this.description));
            children.add(new Property("type", "code", "Type of resource this link refers to.", 0, 1, this.type));
            children.add(new Property("profile", "canonical(StructureDefinition)", "Profile for the target resource.", 0, 1, this.profile));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1040171331: {
                    return new Property("nodeId", "id", "Internal ID of node - target for link references.", 0, 1, this.nodeId);
                }
                case -1724546052: {
                    return new Property(GraphDefinition.SP_DESCRIPTION, "string", "Information about why this node is of interest in this graph definition.", 0, 1, this.description);
                }
                case 3575610: {
                    return new Property("type", "code", "Type of resource this link refers to.", 0, 1, this.type);
                }
                case -309425751: {
                    return new Property("profile", "canonical(StructureDefinition)", "Profile for the target resource.", 0, 1, this.profile);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1040171331: {
                    Base[] baseArray;
                    if (this.nodeId == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.nodeId;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.type;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1040171331: {
                    this.nodeId = TypeConvertor.castToId(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.AllResourceTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -309425751: {
                    this.profile = TypeConvertor.castToCanonical(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("nodeId")) {
                this.nodeId = TypeConvertor.castToId(value);
            } else if (name.equals(GraphDefinition.SP_DESCRIPTION)) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("type")) {
                value = new Enumerations.AllResourceTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("profile")) {
                this.profile = TypeConvertor.castToCanonical(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1040171331: {
                    return this.getNodeIdElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
                case -309425751: {
                    return this.getProfileElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1040171331: {
                    return new String[]{"id"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case -309425751: {
                    return new String[]{"canonical"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("nodeId")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.node.nodeId");
            }
            if (name.equals(GraphDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.node.description");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.node.type");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.node.profile");
            }
            return super.addChild(name);
        }

        @Override
        public GraphDefinitionNodeComponent copy() {
            GraphDefinitionNodeComponent dst = new GraphDefinitionNodeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GraphDefinitionNodeComponent dst) {
            super.copyValues(dst);
            dst.nodeId = this.nodeId == null ? null : this.nodeId.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionNodeComponent)) {
                return false;
            }
            GraphDefinitionNodeComponent o = (GraphDefinitionNodeComponent)other_;
            return GraphDefinitionNodeComponent.compareDeep(this.nodeId, o.nodeId, true) && GraphDefinitionNodeComponent.compareDeep(this.description, o.description, true) && GraphDefinitionNodeComponent.compareDeep(this.type, o.type, true) && GraphDefinitionNodeComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionNodeComponent)) {
                return false;
            }
            GraphDefinitionNodeComponent o = (GraphDefinitionNodeComponent)other_;
            return GraphDefinitionNodeComponent.compareValues(this.nodeId, o.nodeId, true) && GraphDefinitionNodeComponent.compareValues(this.description, o.description, true) && GraphDefinitionNodeComponent.compareValues(this.type, o.type, true) && GraphDefinitionNodeComponent.compareValues(this.profile, o.profile, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.nodeId, this.description, this.type, this.profile);
        }

        @Override
        public String fhirType() {
            return "GraphDefinition.node";
        }
    }

    public static class GraphCompartmentUseEnumFactory
    implements EnumFactory<GraphCompartmentUse> {
        @Override
        public GraphCompartmentUse fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("where".equals(codeString)) {
                return GraphCompartmentUse.WHERE;
            }
            if ("requires".equals(codeString)) {
                return GraphCompartmentUse.REQUIRES;
            }
            throw new IllegalArgumentException("Unknown GraphCompartmentUse code '" + codeString + "'");
        }

        public Enumeration<GraphCompartmentUse> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GraphCompartmentUse>(this, GraphCompartmentUse.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<GraphCompartmentUse>(this, GraphCompartmentUse.NULL, code);
            }
            if ("where".equals(codeString)) {
                return new Enumeration<GraphCompartmentUse>(this, GraphCompartmentUse.WHERE, code);
            }
            if ("requires".equals(codeString)) {
                return new Enumeration<GraphCompartmentUse>(this, GraphCompartmentUse.REQUIRES, code);
            }
            throw new FHIRException("Unknown GraphCompartmentUse code '" + codeString + "'");
        }

        @Override
        public String toCode(GraphCompartmentUse code) {
            if (code == GraphCompartmentUse.WHERE) {
                return "where";
            }
            if (code == GraphCompartmentUse.REQUIRES) {
                return "requires";
            }
            return "?";
        }

        @Override
        public String toSystem(GraphCompartmentUse code) {
            return code.getSystem();
        }
    }

    public static enum GraphCompartmentUse {
        WHERE,
        REQUIRES,
        NULL;


        public static GraphCompartmentUse fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("where".equals(codeString)) {
                return WHERE;
            }
            if ("requires".equals(codeString)) {
                return REQUIRES;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GraphCompartmentUse code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case WHERE: {
                    return "where";
                }
                case REQUIRES: {
                    return "requires";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case WHERE: {
                    return "http://hl7.org/fhir/graph-compartment-use";
                }
                case REQUIRES: {
                    return "http://hl7.org/fhir/graph-compartment-use";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case WHERE: {
                    return "This compartment rule is a condition for whether the rule applies.";
                }
                case REQUIRES: {
                    return "This compartment rule is enforced on any relationships that meet the conditions.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case WHERE: {
                    return "Where";
                }
                case REQUIRES: {
                    return "requires";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class GraphCompartmentRuleEnumFactory
    implements EnumFactory<GraphCompartmentRule> {
        @Override
        public GraphCompartmentRule fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("identical".equals(codeString)) {
                return GraphCompartmentRule.IDENTICAL;
            }
            if ("matching".equals(codeString)) {
                return GraphCompartmentRule.MATCHING;
            }
            if ("different".equals(codeString)) {
                return GraphCompartmentRule.DIFFERENT;
            }
            if ("custom".equals(codeString)) {
                return GraphCompartmentRule.CUSTOM;
            }
            throw new IllegalArgumentException("Unknown GraphCompartmentRule code '" + codeString + "'");
        }

        public Enumeration<GraphCompartmentRule> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GraphCompartmentRule>(this, GraphCompartmentRule.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<GraphCompartmentRule>(this, GraphCompartmentRule.NULL, code);
            }
            if ("identical".equals(codeString)) {
                return new Enumeration<GraphCompartmentRule>(this, GraphCompartmentRule.IDENTICAL, code);
            }
            if ("matching".equals(codeString)) {
                return new Enumeration<GraphCompartmentRule>(this, GraphCompartmentRule.MATCHING, code);
            }
            if ("different".equals(codeString)) {
                return new Enumeration<GraphCompartmentRule>(this, GraphCompartmentRule.DIFFERENT, code);
            }
            if ("custom".equals(codeString)) {
                return new Enumeration<GraphCompartmentRule>(this, GraphCompartmentRule.CUSTOM, code);
            }
            throw new FHIRException("Unknown GraphCompartmentRule code '" + codeString + "'");
        }

        @Override
        public String toCode(GraphCompartmentRule code) {
            if (code == GraphCompartmentRule.IDENTICAL) {
                return "identical";
            }
            if (code == GraphCompartmentRule.MATCHING) {
                return "matching";
            }
            if (code == GraphCompartmentRule.DIFFERENT) {
                return "different";
            }
            if (code == GraphCompartmentRule.CUSTOM) {
                return "custom";
            }
            return "?";
        }

        @Override
        public String toSystem(GraphCompartmentRule code) {
            return code.getSystem();
        }
    }

    public static enum GraphCompartmentRule {
        IDENTICAL,
        MATCHING,
        DIFFERENT,
        CUSTOM,
        NULL;


        public static GraphCompartmentRule fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("identical".equals(codeString)) {
                return IDENTICAL;
            }
            if ("matching".equals(codeString)) {
                return MATCHING;
            }
            if ("different".equals(codeString)) {
                return DIFFERENT;
            }
            if ("custom".equals(codeString)) {
                return CUSTOM;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GraphCompartmentRule code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case IDENTICAL: {
                    return "identical";
                }
                case MATCHING: {
                    return "matching";
                }
                case DIFFERENT: {
                    return "different";
                }
                case CUSTOM: {
                    return "custom";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case IDENTICAL: {
                    return "http://hl7.org/fhir/graph-compartment-rule";
                }
                case MATCHING: {
                    return "http://hl7.org/fhir/graph-compartment-rule";
                }
                case DIFFERENT: {
                    return "http://hl7.org/fhir/graph-compartment-rule";
                }
                case CUSTOM: {
                    return "http://hl7.org/fhir/graph-compartment-rule";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case IDENTICAL: {
                    return "The compartment must be identical (the same literal reference).";
                }
                case MATCHING: {
                    return "The compartment must be the same - the record must be about the same patient, but the reference may be different.";
                }
                case DIFFERENT: {
                    return "The compartment must be different.";
                }
                case CUSTOM: {
                    return "The compartment rule is defined in the accompanying FHIRPath expression.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case IDENTICAL: {
                    return "Identical";
                }
                case MATCHING: {
                    return "Matching";
                }
                case DIFFERENT: {
                    return "Different";
                }
                case CUSTOM: {
                    return "Custom";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

