/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="GenomicStudy", profile="http://hl7.org/fhir/StructureDefinition/GenomicStudy")
public class GenomicStudy
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Identifiers for this genomic study", formalDefinition="Identifiers for this genomic study.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="The status of the genomic study", formalDefinition="The status of the genomic study.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/genomicstudy-status")
    protected CodeableConcept status;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The type of the study (e.g., Familial variant segregation, Functional variation detection, or Gene expression profiling)", formalDefinition="The type of the study, e.g., Familial variant segregation, Functional variation detection, or Gene expression profiling.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/genomicstudy-type")
    protected List<CodeableConcept> type;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class, Organization.class, Procedure.class, Practitioner.class, Medication.class, Substance.class, BiologicallyDerivedProduct.class, NutritionProduct.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The primary subject of the genomic study", formalDefinition="The primary subject of the genomic study.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The healthcare event with which this genomics study is associated", formalDefinition="The healthcare event with which this genomics study is associated.")
    protected Reference encounter;
    @Child(name="startDate", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the genomic study was started", formalDefinition="When the genomic study was started.")
    protected DateTimeType startDate;
    @Child(name="basedOn", type={ServiceRequest.class, Task.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Event resources that the genomic study is based on", formalDefinition="Event resources that the genomic study is based on.")
    protected List<Reference> basedOn;
    @Child(name="referrer", type={Practitioner.class, PractitionerRole.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Healthcare professional who requested or referred the genomic study", formalDefinition="Healthcare professional who requested or referred the genomic study.")
    protected Reference referrer;
    @Child(name="interpreter", type={Practitioner.class, PractitionerRole.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Healthcare professionals who interpreted the genomic study", formalDefinition="Healthcare professionals who interpreted the genomic study.")
    protected List<Reference> interpreter;
    @Child(name="reason", type={CodeableReference.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why the genomic study was performed", formalDefinition="Why the genomic study was performed.")
    protected List<CodeableReference> reason;
    @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The defined protocol that describes the study", formalDefinition="The defined protocol that describes the study.")
    protected CanonicalType instantiatesCanonical;
    @Child(name="instantiatesUri", type={UriType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The URL pointing to an externally maintained protocol that describes the study", formalDefinition="The URL pointing to an externally maintained protocol that describes the study.")
    protected UriType instantiatesUri;
    @Child(name="note", type={Annotation.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments related to the genomic study", formalDefinition="Comments related to the genomic study.")
    protected List<Annotation> note;
    @Child(name="description", type={StringType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of the genomic study", formalDefinition="Description of the genomic study.")
    protected StringType description;
    @Child(name="analysis", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Genomic Analysis Event", formalDefinition="The details about a specific analysis that was performed in this GenomicStudy.")
    protected List<GenomicStudyAnalysisComponent> analysis;
    private static final long serialVersionUID = -345111606L;
    @SearchParamDefinition(name="analysis-patient", path="GenomicStudy.analysis.subject.where(resolve() is Patient)", description="Who the analysis is about", type="reference", target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_ANALYSIS_PATIENT = "analysis-patient";
    public static final ReferenceClientParam ANALYSIS_PATIENT = new ReferenceClientParam("analysis-patient");
    public static final Include INCLUDE_ANALYSIS_PATIENT = new Include("GenomicStudy:analysis-patient").toLocked();
    @SearchParamDefinition(name="analysis-subject", path="GenomicStudy.analysis.subject", description="Who the analysis is about", type="reference", target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_ANALYSIS_SUBJECT = "analysis-subject";
    public static final ReferenceClientParam ANALYSIS_SUBJECT = new ReferenceClientParam("analysis-subject");
    public static final Include INCLUDE_ANALYSIS_SUBJECT = new Include("GenomicStudy:analysis-subject").toLocked();
    @SearchParamDefinition(name="identifier", path="GenomicStudy.identifier", description="Identifiers for the Study", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="GenomicStudy.subject.where(resolve() is Patient)", description="Who the study is about", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("GenomicStudy:patient").toLocked();
    @SearchParamDefinition(name="status", path="GenomicStudy.status", description="The status of the study", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="GenomicStudy.subject", description="Who the study is about", type="reference", target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("GenomicStudy:subject").toLocked();

    public GenomicStudy() {
    }

    public GenomicStudy(CodeableConcept status, Reference subject) {
        this.setStatus(status);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public GenomicStudy setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public GenomicStudy addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getStatus() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GenomicStudy.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new CodeableConcept();
            }
        }
        return this.status;
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public GenomicStudy setStatus(CodeableConcept value) {
        this.status = value;
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public GenomicStudy setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public GenomicStudy addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GenomicStudy.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public GenomicStudy setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GenomicStudy.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public GenomicStudy setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DateTimeType getStartDateElement() {
        if (this.startDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GenomicStudy.startDate");
            }
            if (Configuration.doAutoCreate()) {
                this.startDate = new DateTimeType();
            }
        }
        return this.startDate;
    }

    public boolean hasStartDateElement() {
        return this.startDate != null && !this.startDate.isEmpty();
    }

    public boolean hasStartDate() {
        return this.startDate != null && !this.startDate.isEmpty();
    }

    public GenomicStudy setStartDateElement(DateTimeType value) {
        this.startDate = value;
        return this;
    }

    public Date getStartDate() {
        return this.startDate == null ? null : (Date)this.startDate.getValue();
    }

    public GenomicStudy setStartDate(Date value) {
        if (value == null) {
            this.startDate = null;
        } else {
            if (this.startDate == null) {
                this.startDate = new DateTimeType();
            }
            this.startDate.setValue(value);
        }
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public GenomicStudy setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public GenomicStudy addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Reference getReferrer() {
        if (this.referrer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GenomicStudy.referrer");
            }
            if (Configuration.doAutoCreate()) {
                this.referrer = new Reference();
            }
        }
        return this.referrer;
    }

    public boolean hasReferrer() {
        return this.referrer != null && !this.referrer.isEmpty();
    }

    public GenomicStudy setReferrer(Reference value) {
        this.referrer = value;
        return this;
    }

    public List<Reference> getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = new ArrayList<Reference>();
        }
        return this.interpreter;
    }

    public GenomicStudy setInterpreter(List<Reference> theInterpreter) {
        this.interpreter = theInterpreter;
        return this;
    }

    public boolean hasInterpreter() {
        if (this.interpreter == null) {
            return false;
        }
        for (Reference item : this.interpreter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInterpreter() {
        Reference t = new Reference();
        if (this.interpreter == null) {
            this.interpreter = new ArrayList<Reference>();
        }
        this.interpreter.add(t);
        return t;
    }

    public GenomicStudy addInterpreter(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.interpreter == null) {
            this.interpreter = new ArrayList<Reference>();
        }
        this.interpreter.add(t);
        return this;
    }

    public Reference getInterpreterFirstRep() {
        if (this.getInterpreter().isEmpty()) {
            this.addInterpreter();
        }
        return this.getInterpreter().get(0);
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public GenomicStudy setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public GenomicStudy addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public CanonicalType getInstantiatesCanonicalElement() {
        if (this.instantiatesCanonical == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GenomicStudy.instantiatesCanonical");
            }
            if (Configuration.doAutoCreate()) {
                this.instantiatesCanonical = new CanonicalType();
            }
        }
        return this.instantiatesCanonical;
    }

    public boolean hasInstantiatesCanonicalElement() {
        return this.instantiatesCanonical != null && !this.instantiatesCanonical.isEmpty();
    }

    public boolean hasInstantiatesCanonical() {
        return this.instantiatesCanonical != null && !this.instantiatesCanonical.isEmpty();
    }

    public GenomicStudy setInstantiatesCanonicalElement(CanonicalType value) {
        this.instantiatesCanonical = value;
        return this;
    }

    public String getInstantiatesCanonical() {
        return this.instantiatesCanonical == null ? null : (String)this.instantiatesCanonical.getValue();
    }

    public GenomicStudy setInstantiatesCanonical(String value) {
        if (Utilities.noString(value)) {
            this.instantiatesCanonical = null;
        } else {
            if (this.instantiatesCanonical == null) {
                this.instantiatesCanonical = new CanonicalType();
            }
            this.instantiatesCanonical.setValue(value);
        }
        return this;
    }

    public UriType getInstantiatesUriElement() {
        if (this.instantiatesUri == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GenomicStudy.instantiatesUri");
            }
            if (Configuration.doAutoCreate()) {
                this.instantiatesUri = new UriType();
            }
        }
        return this.instantiatesUri;
    }

    public boolean hasInstantiatesUriElement() {
        return this.instantiatesUri != null && !this.instantiatesUri.isEmpty();
    }

    public boolean hasInstantiatesUri() {
        return this.instantiatesUri != null && !this.instantiatesUri.isEmpty();
    }

    public GenomicStudy setInstantiatesUriElement(UriType value) {
        this.instantiatesUri = value;
        return this;
    }

    public String getInstantiatesUri() {
        return this.instantiatesUri == null ? null : (String)this.instantiatesUri.getValue();
    }

    public GenomicStudy setInstantiatesUri(String value) {
        if (Utilities.noString(value)) {
            this.instantiatesUri = null;
        } else {
            if (this.instantiatesUri == null) {
                this.instantiatesUri = new UriType();
            }
            this.instantiatesUri.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public GenomicStudy setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public GenomicStudy addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GenomicStudy.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public GenomicStudy setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public GenomicStudy setDescription(String value) {
        if (Utilities.noString(value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<GenomicStudyAnalysisComponent> getAnalysis() {
        if (this.analysis == null) {
            this.analysis = new ArrayList<GenomicStudyAnalysisComponent>();
        }
        return this.analysis;
    }

    public GenomicStudy setAnalysis(List<GenomicStudyAnalysisComponent> theAnalysis) {
        this.analysis = theAnalysis;
        return this;
    }

    public boolean hasAnalysis() {
        if (this.analysis == null) {
            return false;
        }
        for (GenomicStudyAnalysisComponent item : this.analysis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GenomicStudyAnalysisComponent addAnalysis() {
        GenomicStudyAnalysisComponent t = new GenomicStudyAnalysisComponent();
        if (this.analysis == null) {
            this.analysis = new ArrayList<GenomicStudyAnalysisComponent>();
        }
        this.analysis.add(t);
        return t;
    }

    public GenomicStudy addAnalysis(GenomicStudyAnalysisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.analysis == null) {
            this.analysis = new ArrayList<GenomicStudyAnalysisComponent>();
        }
        this.analysis.add(t);
        return this;
    }

    public GenomicStudyAnalysisComponent getAnalysisFirstRep() {
        if (this.getAnalysis().isEmpty()) {
            this.addAnalysis();
        }
        return this.getAnalysis().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers for this genomic study.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "CodeableConcept", "The status of the genomic study.", 0, 1, this.status));
        children.add(new Property("type", "CodeableConcept", "The type of the study, e.g., Familial variant segregation, Functional variation detection, or Gene expression profiling.", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|BiologicallyDerivedProduct|NutritionProduct)", "The primary subject of the genomic study.", 0, 1, this.subject));
        children.add(new Property("encounter", "Reference(Encounter)", "The healthcare event with which this genomics study is associated.", 0, 1, this.encounter));
        children.add(new Property("startDate", "dateTime", "When the genomic study was started.", 0, 1, this.startDate));
        children.add(new Property("basedOn", "Reference(ServiceRequest|Task)", "Event resources that the genomic study is based on.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("referrer", "Reference(Practitioner|PractitionerRole)", "Healthcare professional who requested or referred the genomic study.", 0, 1, this.referrer));
        children.add(new Property("interpreter", "Reference(Practitioner|PractitionerRole)", "Healthcare professionals who interpreted the genomic study.", 0, Integer.MAX_VALUE, this.interpreter));
        children.add(new Property("reason", "CodeableReference(Condition|Observation)", "Why the genomic study was performed.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("instantiatesCanonical", "canonical(PlanDefinition)", "The defined protocol that describes the study.", 0, 1, this.instantiatesCanonical));
        children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol that describes the study.", 0, 1, this.instantiatesUri));
        children.add(new Property("note", "Annotation", "Comments related to the genomic study.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("description", "string", "Description of the genomic study.", 0, 1, this.description));
        children.add(new Property("analysis", "", "The details about a specific analysis that was performed in this GenomicStudy.", 0, Integer.MAX_VALUE, this.analysis));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers for this genomic study.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "CodeableConcept", "The status of the genomic study.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "The type of the study, e.g., Familial variant segregation, Functional variation detection, or Gene expression profiling.", 0, Integer.MAX_VALUE, this.type);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|BiologicallyDerivedProduct|NutritionProduct)", "The primary subject of the genomic study.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property("encounter", "Reference(Encounter)", "The healthcare event with which this genomics study is associated.", 0, 1, this.encounter);
            }
            case -2129778896: {
                return new Property("startDate", "dateTime", "When the genomic study was started.", 0, 1, this.startDate);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(ServiceRequest|Task)", "Event resources that the genomic study is based on.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -722568161: {
                return new Property("referrer", "Reference(Practitioner|PractitionerRole)", "Healthcare professional who requested or referred the genomic study.", 0, 1, this.referrer);
            }
            case -2008009094: {
                return new Property("interpreter", "Reference(Practitioner|PractitionerRole)", "Healthcare professionals who interpreted the genomic study.", 0, Integer.MAX_VALUE, this.interpreter);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation)", "Why the genomic study was performed.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 8911915: {
                return new Property("instantiatesCanonical", "canonical(PlanDefinition)", "The defined protocol that describes the study.", 0, 1, this.instantiatesCanonical);
            }
            case -1926393373: {
                return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol that describes the study.", 0, 1, this.instantiatesUri);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Comments related to the genomic study.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1724546052: {
                return new Property("description", "string", "Description of the genomic study.", 0, 1, this.description);
            }
            case -1024445732: {
                return new Property("analysis", "", "The details about a specific analysis that was performed in this GenomicStudy.", 0, Integer.MAX_VALUE, this.analysis);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.encounter;
                }
                return baseArray;
            }
            case -2129778896: {
                Base[] baseArray;
                if (this.startDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.startDate;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -722568161: {
                Base[] baseArray;
                if (this.referrer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.referrer;
                }
                return baseArray;
            }
            case -2008009094: {
                return this.interpreter == null ? new Base[]{} : this.interpreter.toArray(new Base[this.interpreter.size()]);
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 8911915: {
                Base[] baseArray;
                if (this.instantiatesCanonical == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.instantiatesCanonical;
                }
                return baseArray;
            }
            case -1926393373: {
                Base[] baseArray;
                if (this.instantiatesUri == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.instantiatesUri;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -1024445732: {
                return this.analysis == null ? new Base[]{} : this.analysis.toArray(new Base[this.analysis.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                this.status = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3575610: {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -2129778896: {
                this.startDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -722568161: {
                this.referrer = TypeConvertor.castToReference(value);
                return value;
            }
            case -2008009094: {
                this.getInterpreter().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 8911915: {
                this.instantiatesCanonical = TypeConvertor.castToCanonical(value);
                return value;
            }
            case -1926393373: {
                this.instantiatesUri = TypeConvertor.castToUri(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case -1024445732: {
                this.getAnalysis().add((GenomicStudyAnalysisComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("type")) {
            this.getType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("startDate")) {
            this.startDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("referrer")) {
            this.referrer = TypeConvertor.castToReference(value);
        } else if (name.equals("interpreter")) {
            this.getInterpreter().add(TypeConvertor.castToReference(value));
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("instantiatesCanonical")) {
            this.instantiatesCanonical = TypeConvertor.castToCanonical(value);
        } else if (name.equals("instantiatesUri")) {
            this.instantiatesUri = TypeConvertor.castToUri(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals("analysis")) {
            this.getAnalysis().add((GenomicStudyAnalysisComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatus();
            }
            case 3575610: {
                return this.addType();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -2129778896: {
                return this.getStartDateElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -722568161: {
                return this.getReferrer();
            }
            case -2008009094: {
                return this.addInterpreter();
            }
            case -934964668: {
                return this.addReason();
            }
            case 8911915: {
                return this.getInstantiatesCanonicalElement();
            }
            case -1926393373: {
                return this.getInstantiatesUriElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1024445732: {
                return this.addAnalysis();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -2129778896: {
                return new String[]{"dateTime"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -722568161: {
                return new String[]{"Reference"};
            }
            case -2008009094: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 8911915: {
                return new String[]{"canonical"};
            }
            case -1926393373: {
                return new String[]{"uri"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -1024445732: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            this.status = new CodeableConcept();
            return this.status;
        }
        if (name.equals("type")) {
            return this.addType();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("startDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type GenomicStudy.startDate");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("referrer")) {
            this.referrer = new Reference();
            return this.referrer;
        }
        if (name.equals("interpreter")) {
            return this.addInterpreter();
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("instantiatesCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type GenomicStudy.instantiatesCanonical");
        }
        if (name.equals("instantiatesUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type GenomicStudy.instantiatesUri");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type GenomicStudy.description");
        }
        if (name.equals("analysis")) {
            return this.addAnalysis();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "GenomicStudy";
    }

    @Override
    public GenomicStudy copy() {
        GenomicStudy dst = new GenomicStudy();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(GenomicStudy dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        CodeableConcept codeableConcept = dst.status = this.status == null ? null : this.status.copy();
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.type) {
                dst.type.add(codeableConcept2.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        DateTimeType dateTimeType = dst.startDate = this.startDate == null ? null : this.startDate.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Reference reference = dst.referrer = this.referrer == null ? null : this.referrer.copy();
        if (this.interpreter != null) {
            dst.interpreter = new ArrayList<Reference>();
            for (Reference reference2 : this.interpreter) {
                dst.interpreter.add(reference2.copy());
            }
        }
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        dst.instantiatesCanonical = this.instantiatesCanonical == null ? null : this.instantiatesCanonical.copy();
        UriType uriType = dst.instantiatesUri = this.instantiatesUri == null ? null : this.instantiatesUri.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.analysis != null) {
            dst.analysis = new ArrayList<GenomicStudyAnalysisComponent>();
            for (GenomicStudyAnalysisComponent genomicStudyAnalysisComponent : this.analysis) {
                dst.analysis.add(genomicStudyAnalysisComponent.copy());
            }
        }
    }

    protected GenomicStudy typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof GenomicStudy)) {
            return false;
        }
        GenomicStudy o = (GenomicStudy)other_;
        return GenomicStudy.compareDeep(this.identifier, o.identifier, true) && GenomicStudy.compareDeep(this.status, o.status, true) && GenomicStudy.compareDeep(this.type, o.type, true) && GenomicStudy.compareDeep(this.subject, o.subject, true) && GenomicStudy.compareDeep(this.encounter, o.encounter, true) && GenomicStudy.compareDeep(this.startDate, o.startDate, true) && GenomicStudy.compareDeep(this.basedOn, o.basedOn, true) && GenomicStudy.compareDeep(this.referrer, o.referrer, true) && GenomicStudy.compareDeep(this.interpreter, o.interpreter, true) && GenomicStudy.compareDeep(this.reason, o.reason, true) && GenomicStudy.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && GenomicStudy.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && GenomicStudy.compareDeep(this.note, o.note, true) && GenomicStudy.compareDeep(this.description, o.description, true) && GenomicStudy.compareDeep(this.analysis, o.analysis, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof GenomicStudy)) {
            return false;
        }
        GenomicStudy o = (GenomicStudy)other_;
        return GenomicStudy.compareValues(this.startDate, o.startDate, true) && GenomicStudy.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && GenomicStudy.compareValues(this.instantiatesUri, o.instantiatesUri, true) && GenomicStudy.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.type, this.subject, this.encounter, this.startDate, this.basedOn, this.referrer, this.interpreter, this.reason, this.instantiatesCanonical, this.instantiatesUri, this.note, this.description, this.analysis);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.GenomicStudy;
    }

    @Block
    public static class GenomicStudyAnalysisDeviceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="device", type={Device.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Device used for the analysis", formalDefinition="Device used for the analysis.")
        protected Reference device;
        @Child(name="function", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific function for the device used for the analysis", formalDefinition="Specific function for the device used for the analysis.")
        protected CodeableConcept function;
        private static final long serialVersionUID = 1643933108L;

        public Reference getDevice() {
            if (this.device == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisDeviceComponent.device");
                }
                if (Configuration.doAutoCreate()) {
                    this.device = new Reference();
                }
            }
            return this.device;
        }

        public boolean hasDevice() {
            return this.device != null && !this.device.isEmpty();
        }

        public GenomicStudyAnalysisDeviceComponent setDevice(Reference value) {
            this.device = value;
            return this;
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisDeviceComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public GenomicStudyAnalysisDeviceComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("device", "Reference(Device)", "Device used for the analysis.", 0, 1, this.device));
            children.add(new Property("function", "CodeableConcept", "Specific function for the device used for the analysis.", 0, 1, this.function));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1335157162: {
                    return new Property("device", "Reference(Device)", "Device used for the analysis.", 0, 1, this.device);
                }
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Specific function for the device used for the analysis.", 0, 1, this.function);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    Base[] baseArray;
                    if (this.device == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.device;
                    }
                    return baseArray;
                }
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.function;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    this.device = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("device")) {
                this.device = TypeConvertor.castToReference(value);
            } else if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    return this.getDevice();
                }
                case 1380938712: {
                    return this.getFunction();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1335157162: {
                    return new String[]{"Reference"};
                }
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("device")) {
                this.device = new Reference();
                return this.device;
            }
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            return super.addChild(name);
        }

        @Override
        public GenomicStudyAnalysisDeviceComponent copy() {
            GenomicStudyAnalysisDeviceComponent dst = new GenomicStudyAnalysisDeviceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GenomicStudyAnalysisDeviceComponent dst) {
            super.copyValues(dst);
            dst.device = this.device == null ? null : this.device.copy();
            dst.function = this.function == null ? null : this.function.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GenomicStudyAnalysisDeviceComponent)) {
                return false;
            }
            GenomicStudyAnalysisDeviceComponent o = (GenomicStudyAnalysisDeviceComponent)other_;
            return GenomicStudyAnalysisDeviceComponent.compareDeep(this.device, o.device, true) && GenomicStudyAnalysisDeviceComponent.compareDeep(this.function, o.function, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GenomicStudyAnalysisDeviceComponent)) {
                return false;
            }
            GenomicStudyAnalysisDeviceComponent o = (GenomicStudyAnalysisDeviceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.device, this.function);
        }

        @Override
        public String fhirType() {
            return "GenomicStudy.analysis.device";
        }
    }

    @Block
    public static class GenomicStudyAnalysisPerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Organization.class, Device.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The organization, healthcare professional, or others who participated in performing this analysis", formalDefinition="The organization, healthcare professional, or others who participated in performing this analysis.")
        protected Reference actor;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Role of the actor for this analysis", formalDefinition="Role of the actor for this analysis.")
        protected CodeableConcept role;
        private static final long serialVersionUID = 827444743L;

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisPerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public GenomicStudyAnalysisPerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisPerformerComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public GenomicStudyAnalysisPerformerComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|Device)", "The organization, healthcare professional, or others who participated in performing this analysis.", 0, 1, this.actor));
            children.add(new Property("role", "CodeableConcept", "Role of the actor for this analysis.", 0, 1, this.role));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|Device)", "The organization, healthcare professional, or others who participated in performing this analysis.", 0, 1, this.actor);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Role of the actor for this analysis.", 0, 1, this.role);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.actor;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return this.getActor();
                }
                case 3506294: {
                    return this.getRole();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92645877: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            return super.addChild(name);
        }

        @Override
        public GenomicStudyAnalysisPerformerComponent copy() {
            GenomicStudyAnalysisPerformerComponent dst = new GenomicStudyAnalysisPerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GenomicStudyAnalysisPerformerComponent dst) {
            super.copyValues(dst);
            dst.actor = this.actor == null ? null : this.actor.copy();
            dst.role = this.role == null ? null : this.role.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GenomicStudyAnalysisPerformerComponent)) {
                return false;
            }
            GenomicStudyAnalysisPerformerComponent o = (GenomicStudyAnalysisPerformerComponent)other_;
            return GenomicStudyAnalysisPerformerComponent.compareDeep(this.actor, o.actor, true) && GenomicStudyAnalysisPerformerComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GenomicStudyAnalysisPerformerComponent)) {
                return false;
            }
            GenomicStudyAnalysisPerformerComponent o = (GenomicStudyAnalysisPerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.actor, this.role);
        }

        @Override
        public String fhirType() {
            return "GenomicStudy.analysis.performer";
        }
    }

    @Block
    public static class GenomicStudyAnalysisOutputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="file", type={DocumentReference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="File containing output data", formalDefinition="File containing output data.")
        protected Reference file;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of output data (e.g., VCF, MAF, or BAM)", formalDefinition="Type of output data, e.g., VCF, MAF, or BAM.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/genomicstudy-dataformat")
        protected CodeableConcept type;
        private static final long serialVersionUID = -2075265800L;

        public Reference getFile() {
            if (this.file == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisOutputComponent.file");
                }
                if (Configuration.doAutoCreate()) {
                    this.file = new Reference();
                }
            }
            return this.file;
        }

        public boolean hasFile() {
            return this.file != null && !this.file.isEmpty();
        }

        public GenomicStudyAnalysisOutputComponent setFile(Reference value) {
            this.file = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisOutputComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public GenomicStudyAnalysisOutputComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("file", "Reference(DocumentReference)", "File containing output data.", 0, 1, this.file));
            children.add(new Property("type", "CodeableConcept", "Type of output data, e.g., VCF, MAF, or BAM.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3143036: {
                    return new Property("file", "Reference(DocumentReference)", "File containing output data.", 0, 1, this.file);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of output data, e.g., VCF, MAF, or BAM.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3143036: {
                    Base[] baseArray;
                    if (this.file == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.file;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3143036: {
                    this.file = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("file")) {
                this.file = TypeConvertor.castToReference(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3143036: {
                    return this.getFile();
                }
                case 3575610: {
                    return this.getType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3143036: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("file")) {
                this.file = new Reference();
                return this.file;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            return super.addChild(name);
        }

        @Override
        public GenomicStudyAnalysisOutputComponent copy() {
            GenomicStudyAnalysisOutputComponent dst = new GenomicStudyAnalysisOutputComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GenomicStudyAnalysisOutputComponent dst) {
            super.copyValues(dst);
            dst.file = this.file == null ? null : this.file.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GenomicStudyAnalysisOutputComponent)) {
                return false;
            }
            GenomicStudyAnalysisOutputComponent o = (GenomicStudyAnalysisOutputComponent)other_;
            return GenomicStudyAnalysisOutputComponent.compareDeep(this.file, o.file, true) && GenomicStudyAnalysisOutputComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GenomicStudyAnalysisOutputComponent)) {
                return false;
            }
            GenomicStudyAnalysisOutputComponent o = (GenomicStudyAnalysisOutputComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.file, this.type);
        }

        @Override
        public String fhirType() {
            return "GenomicStudy.analysis.output";
        }
    }

    @Block
    public static class GenomicStudyAnalysisInputComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="file", type={DocumentReference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="File containing input data", formalDefinition="File containing input data.")
        protected Reference file;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of input data (e.g., BAM, CRAM, or FASTA)", formalDefinition="Type of input data, e.g., BAM, CRAM, or FASTA.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/genomicstudy-dataformat")
        protected CodeableConcept type;
        @Child(name="generatedBy", type={Identifier.class, GenomicStudy.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The analysis event or other GenomicStudy that generated this input file", formalDefinition="The analysis event or other GenomicStudy that generated this input file.")
        protected DataType generatedBy;
        private static final long serialVersionUID = -650883036L;

        public Reference getFile() {
            if (this.file == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisInputComponent.file");
                }
                if (Configuration.doAutoCreate()) {
                    this.file = new Reference();
                }
            }
            return this.file;
        }

        public boolean hasFile() {
            return this.file != null && !this.file.isEmpty();
        }

        public GenomicStudyAnalysisInputComponent setFile(Reference value) {
            this.file = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisInputComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public GenomicStudyAnalysisInputComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getGeneratedBy() {
            return this.generatedBy;
        }

        public Identifier getGeneratedByIdentifier() throws FHIRException {
            if (this.generatedBy == null) {
                this.generatedBy = new Identifier();
            }
            if (!(this.generatedBy instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.generatedBy.getClass().getName() + " was encountered");
            }
            return (Identifier)this.generatedBy;
        }

        public boolean hasGeneratedByIdentifier() {
            return this != null && this.generatedBy instanceof Identifier;
        }

        public Reference getGeneratedByReference() throws FHIRException {
            if (this.generatedBy == null) {
                this.generatedBy = new Reference();
            }
            if (!(this.generatedBy instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.generatedBy.getClass().getName() + " was encountered");
            }
            return (Reference)this.generatedBy;
        }

        public boolean hasGeneratedByReference() {
            return this != null && this.generatedBy instanceof Reference;
        }

        public boolean hasGeneratedBy() {
            return this.generatedBy != null && !this.generatedBy.isEmpty();
        }

        public GenomicStudyAnalysisInputComponent setGeneratedBy(DataType value) {
            if (value != null && !(value instanceof Identifier) && !(value instanceof Reference)) {
                throw new Error("Not the right type for GenomicStudy.analysis.input.generatedBy[x]: " + value.fhirType());
            }
            this.generatedBy = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("file", "Reference(DocumentReference)", "File containing input data.", 0, 1, this.file));
            children.add(new Property("type", "CodeableConcept", "Type of input data, e.g., BAM, CRAM, or FASTA.", 0, 1, this.type));
            children.add(new Property("generatedBy[x]", "Identifier|Reference(GenomicStudy)", "The analysis event or other GenomicStudy that generated this input file.", 0, 1, this.generatedBy));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3143036: {
                    return new Property("file", "Reference(DocumentReference)", "File containing input data.", 0, 1, this.file);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Type of input data, e.g., BAM, CRAM, or FASTA.", 0, 1, this.type);
                }
                case -1669563270: {
                    return new Property("generatedBy[x]", "Identifier|Reference(GenomicStudy)", "The analysis event or other GenomicStudy that generated this input file.", 0, 1, this.generatedBy);
                }
                case 886733382: {
                    return new Property("generatedBy[x]", "Identifier|Reference(GenomicStudy)", "The analysis event or other GenomicStudy that generated this input file.", 0, 1, this.generatedBy);
                }
                case 913138575: {
                    return new Property("generatedBy[x]", "Identifier", "The analysis event or other GenomicStudy that generated this input file.", 0, 1, this.generatedBy);
                }
                case -1397681243: {
                    return new Property("generatedBy[x]", "Reference(GenomicStudy)", "The analysis event or other GenomicStudy that generated this input file.", 0, 1, this.generatedBy);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3143036: {
                    Base[] baseArray;
                    if (this.file == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.file;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 886733382: {
                    Base[] baseArray;
                    if (this.generatedBy == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.generatedBy;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3143036: {
                    this.file = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 886733382: {
                    this.generatedBy = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("file")) {
                this.file = TypeConvertor.castToReference(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("generatedBy[x]")) {
                this.generatedBy = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3143036: {
                    return this.getFile();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1669563270: {
                    return this.getGeneratedBy();
                }
                case 886733382: {
                    return this.getGeneratedBy();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3143036: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 886733382: {
                    return new String[]{"Identifier", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("file")) {
                this.file = new Reference();
                return this.file;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("generatedByIdentifier")) {
                this.generatedBy = new Identifier();
                return this.generatedBy;
            }
            if (name.equals("generatedByReference")) {
                this.generatedBy = new Reference();
                return this.generatedBy;
            }
            return super.addChild(name);
        }

        @Override
        public GenomicStudyAnalysisInputComponent copy() {
            GenomicStudyAnalysisInputComponent dst = new GenomicStudyAnalysisInputComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GenomicStudyAnalysisInputComponent dst) {
            super.copyValues(dst);
            dst.file = this.file == null ? null : this.file.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.generatedBy = this.generatedBy == null ? null : this.generatedBy.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GenomicStudyAnalysisInputComponent)) {
                return false;
            }
            GenomicStudyAnalysisInputComponent o = (GenomicStudyAnalysisInputComponent)other_;
            return GenomicStudyAnalysisInputComponent.compareDeep(this.file, o.file, true) && GenomicStudyAnalysisInputComponent.compareDeep(this.type, o.type, true) && GenomicStudyAnalysisInputComponent.compareDeep(this.generatedBy, o.generatedBy, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GenomicStudyAnalysisInputComponent)) {
                return false;
            }
            GenomicStudyAnalysisInputComponent o = (GenomicStudyAnalysisInputComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.file, this.type, this.generatedBy);
        }

        @Override
        public String fhirType() {
            return "GenomicStudy.analysis.input";
        }
    }

    @Block
    public static class GenomicStudyAnalysisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Identifiers for the analysis event", formalDefinition="Identifiers for the analysis event.")
        protected List<Identifier> identifier;
        @Child(name="methodType", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Type of the methods used in the analysis (e.g., FISH, Karyotyping, MSI)", formalDefinition="Type of the methods used in the analysis, e.g., Fluorescence in situ hybridization (FISH), Karyotyping, or Microsatellite instability testing (MSI).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/genomicstudy-methodtype")
        protected List<CodeableConcept> methodType;
        @Child(name="changeType", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Type of the genomic changes studied in the analysis (e.g., DNA, RNA, or AA change)", formalDefinition="Type of the genomic changes studied in the analysis, e.g., DNA, RNA, or amino acid change.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/genomicstudy-changetype")
        protected List<CodeableConcept> changeType;
        @Child(name="genomeBuild", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Genome build that is used in this analysis", formalDefinition="The reference genome build that is used in this analysis.")
        @Binding(valueSet="http://loinc.org/vs/LL1040-6")
        protected CodeableConcept genomeBuild;
        @Child(name="instantiatesCanonical", type={CanonicalType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The defined protocol that describes the analysis", formalDefinition="The defined protocol that describes the analysis.")
        protected CanonicalType instantiatesCanonical;
        @Child(name="instantiatesUri", type={UriType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The URL pointing to an externally maintained protocol that describes the analysis", formalDefinition="The URL pointing to an externally maintained protocol that describes the analysis.")
        protected UriType instantiatesUri;
        @Child(name="title", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the analysis event (human friendly)", formalDefinition="Name of the analysis event (human friendly).")
        protected StringType title;
        @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class, Organization.class, Procedure.class, Practitioner.class, Medication.class, Substance.class, BiologicallyDerivedProduct.class, NutritionProduct.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The subject of the analysis event", formalDefinition="The subject of the analysis event.")
        protected Reference subject;
        @Child(name="specimen", type={Specimen.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The specimen used in the analysis event", formalDefinition="The specimen used in the analysis event.")
        protected List<Reference> specimen;
        @Child(name="date", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date of the analysis event", formalDefinition="The date of the analysis event.")
        protected DateTimeType date;
        @Child(name="note", type={Annotation.class}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Any notes capture with the analysis event", formalDefinition="Any notes capture with the analysis event.")
        protected List<Annotation> note;
        @Child(name="protocolPerformed", type={Procedure.class, Task.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The protocol that was performed for the analysis event", formalDefinition="The protocol that was performed for the analysis event.")
        protected Reference protocolPerformed;
        @Child(name="regionsStudied", type={DocumentReference.class, Observation.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The genomic regions to be studied in the analysis (BED file)", formalDefinition="The genomic regions to be studied in the analysis (BED file).")
        protected List<Reference> regionsStudied;
        @Child(name="regionsCalled", type={DocumentReference.class, Observation.class}, order=14, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Genomic regions actually called in the analysis event (BED file)", formalDefinition="Genomic regions actually called in the analysis event (BED file).")
        protected List<Reference> regionsCalled;
        @Child(name="input", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Inputs for the analysis event", formalDefinition="Inputs for the analysis event.")
        protected List<GenomicStudyAnalysisInputComponent> input;
        @Child(name="output", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Outputs for the analysis event", formalDefinition="Outputs for the analysis event.")
        protected List<GenomicStudyAnalysisOutputComponent> output;
        @Child(name="performer", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Performer for the analysis event", formalDefinition="Performer for the analysis event.")
        protected List<GenomicStudyAnalysisPerformerComponent> performer;
        @Child(name="device", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Devices used for the analysis (e.g., instruments, software), with settings and parameters", formalDefinition="Devices used for the analysis (e.g., instruments, software), with settings and parameters.")
        protected List<GenomicStudyAnalysisDeviceComponent> device;
        private static final long serialVersionUID = 400268376L;

        public List<Identifier> getIdentifier() {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            return this.identifier;
        }

        public GenomicStudyAnalysisComponent setIdentifier(List<Identifier> theIdentifier) {
            this.identifier = theIdentifier;
            return this;
        }

        public boolean hasIdentifier() {
            if (this.identifier == null) {
                return false;
            }
            for (Identifier item : this.identifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Identifier addIdentifier() {
            Identifier t = new Identifier();
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addIdentifier(Identifier t) {
            if (t == null) {
                return this;
            }
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier>();
            }
            this.identifier.add(t);
            return this;
        }

        public Identifier getIdentifierFirstRep() {
            if (this.getIdentifier().isEmpty()) {
                this.addIdentifier();
            }
            return this.getIdentifier().get(0);
        }

        public List<CodeableConcept> getMethodType() {
            if (this.methodType == null) {
                this.methodType = new ArrayList<CodeableConcept>();
            }
            return this.methodType;
        }

        public GenomicStudyAnalysisComponent setMethodType(List<CodeableConcept> theMethodType) {
            this.methodType = theMethodType;
            return this;
        }

        public boolean hasMethodType() {
            if (this.methodType == null) {
                return false;
            }
            for (CodeableConcept item : this.methodType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addMethodType() {
            CodeableConcept t = new CodeableConcept();
            if (this.methodType == null) {
                this.methodType = new ArrayList<CodeableConcept>();
            }
            this.methodType.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addMethodType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.methodType == null) {
                this.methodType = new ArrayList<CodeableConcept>();
            }
            this.methodType.add(t);
            return this;
        }

        public CodeableConcept getMethodTypeFirstRep() {
            if (this.getMethodType().isEmpty()) {
                this.addMethodType();
            }
            return this.getMethodType().get(0);
        }

        public List<CodeableConcept> getChangeType() {
            if (this.changeType == null) {
                this.changeType = new ArrayList<CodeableConcept>();
            }
            return this.changeType;
        }

        public GenomicStudyAnalysisComponent setChangeType(List<CodeableConcept> theChangeType) {
            this.changeType = theChangeType;
            return this;
        }

        public boolean hasChangeType() {
            if (this.changeType == null) {
                return false;
            }
            for (CodeableConcept item : this.changeType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addChangeType() {
            CodeableConcept t = new CodeableConcept();
            if (this.changeType == null) {
                this.changeType = new ArrayList<CodeableConcept>();
            }
            this.changeType.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addChangeType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.changeType == null) {
                this.changeType = new ArrayList<CodeableConcept>();
            }
            this.changeType.add(t);
            return this;
        }

        public CodeableConcept getChangeTypeFirstRep() {
            if (this.getChangeType().isEmpty()) {
                this.addChangeType();
            }
            return this.getChangeType().get(0);
        }

        public CodeableConcept getGenomeBuild() {
            if (this.genomeBuild == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisComponent.genomeBuild");
                }
                if (Configuration.doAutoCreate()) {
                    this.genomeBuild = new CodeableConcept();
                }
            }
            return this.genomeBuild;
        }

        public boolean hasGenomeBuild() {
            return this.genomeBuild != null && !this.genomeBuild.isEmpty();
        }

        public GenomicStudyAnalysisComponent setGenomeBuild(CodeableConcept value) {
            this.genomeBuild = value;
            return this;
        }

        public CanonicalType getInstantiatesCanonicalElement() {
            if (this.instantiatesCanonical == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisComponent.instantiatesCanonical");
                }
                if (Configuration.doAutoCreate()) {
                    this.instantiatesCanonical = new CanonicalType();
                }
            }
            return this.instantiatesCanonical;
        }

        public boolean hasInstantiatesCanonicalElement() {
            return this.instantiatesCanonical != null && !this.instantiatesCanonical.isEmpty();
        }

        public boolean hasInstantiatesCanonical() {
            return this.instantiatesCanonical != null && !this.instantiatesCanonical.isEmpty();
        }

        public GenomicStudyAnalysisComponent setInstantiatesCanonicalElement(CanonicalType value) {
            this.instantiatesCanonical = value;
            return this;
        }

        public String getInstantiatesCanonical() {
            return this.instantiatesCanonical == null ? null : (String)this.instantiatesCanonical.getValue();
        }

        public GenomicStudyAnalysisComponent setInstantiatesCanonical(String value) {
            if (Utilities.noString(value)) {
                this.instantiatesCanonical = null;
            } else {
                if (this.instantiatesCanonical == null) {
                    this.instantiatesCanonical = new CanonicalType();
                }
                this.instantiatesCanonical.setValue(value);
            }
            return this;
        }

        public UriType getInstantiatesUriElement() {
            if (this.instantiatesUri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisComponent.instantiatesUri");
                }
                if (Configuration.doAutoCreate()) {
                    this.instantiatesUri = new UriType();
                }
            }
            return this.instantiatesUri;
        }

        public boolean hasInstantiatesUriElement() {
            return this.instantiatesUri != null && !this.instantiatesUri.isEmpty();
        }

        public boolean hasInstantiatesUri() {
            return this.instantiatesUri != null && !this.instantiatesUri.isEmpty();
        }

        public GenomicStudyAnalysisComponent setInstantiatesUriElement(UriType value) {
            this.instantiatesUri = value;
            return this;
        }

        public String getInstantiatesUri() {
            return this.instantiatesUri == null ? null : (String)this.instantiatesUri.getValue();
        }

        public GenomicStudyAnalysisComponent setInstantiatesUri(String value) {
            if (Utilities.noString(value)) {
                this.instantiatesUri = null;
            } else {
                if (this.instantiatesUri == null) {
                    this.instantiatesUri = new UriType();
                }
                this.instantiatesUri.setValue(value);
            }
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public GenomicStudyAnalysisComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public GenomicStudyAnalysisComponent setTitle(String value) {
            if (Utilities.noString(value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public Reference getSubject() {
            if (this.subject == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisComponent.subject");
                }
                if (Configuration.doAutoCreate()) {
                    this.subject = new Reference();
                }
            }
            return this.subject;
        }

        public boolean hasSubject() {
            return this.subject != null && !this.subject.isEmpty();
        }

        public GenomicStudyAnalysisComponent setSubject(Reference value) {
            this.subject = value;
            return this;
        }

        public List<Reference> getSpecimen() {
            if (this.specimen == null) {
                this.specimen = new ArrayList<Reference>();
            }
            return this.specimen;
        }

        public GenomicStudyAnalysisComponent setSpecimen(List<Reference> theSpecimen) {
            this.specimen = theSpecimen;
            return this;
        }

        public boolean hasSpecimen() {
            if (this.specimen == null) {
                return false;
            }
            for (Reference item : this.specimen) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSpecimen() {
            Reference t = new Reference();
            if (this.specimen == null) {
                this.specimen = new ArrayList<Reference>();
            }
            this.specimen.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addSpecimen(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.specimen == null) {
                this.specimen = new ArrayList<Reference>();
            }
            this.specimen.add(t);
            return this;
        }

        public Reference getSpecimenFirstRep() {
            if (this.getSpecimen().isEmpty()) {
                this.addSpecimen();
            }
            return this.getSpecimen().get(0);
        }

        public DateTimeType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateTimeType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public GenomicStudyAnalysisComponent setDateElement(DateTimeType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public GenomicStudyAnalysisComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateTimeType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public GenomicStudyAnalysisComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        public Reference getProtocolPerformed() {
            if (this.protocolPerformed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GenomicStudyAnalysisComponent.protocolPerformed");
                }
                if (Configuration.doAutoCreate()) {
                    this.protocolPerformed = new Reference();
                }
            }
            return this.protocolPerformed;
        }

        public boolean hasProtocolPerformed() {
            return this.protocolPerformed != null && !this.protocolPerformed.isEmpty();
        }

        public GenomicStudyAnalysisComponent setProtocolPerformed(Reference value) {
            this.protocolPerformed = value;
            return this;
        }

        public List<Reference> getRegionsStudied() {
            if (this.regionsStudied == null) {
                this.regionsStudied = new ArrayList<Reference>();
            }
            return this.regionsStudied;
        }

        public GenomicStudyAnalysisComponent setRegionsStudied(List<Reference> theRegionsStudied) {
            this.regionsStudied = theRegionsStudied;
            return this;
        }

        public boolean hasRegionsStudied() {
            if (this.regionsStudied == null) {
                return false;
            }
            for (Reference item : this.regionsStudied) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addRegionsStudied() {
            Reference t = new Reference();
            if (this.regionsStudied == null) {
                this.regionsStudied = new ArrayList<Reference>();
            }
            this.regionsStudied.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addRegionsStudied(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.regionsStudied == null) {
                this.regionsStudied = new ArrayList<Reference>();
            }
            this.regionsStudied.add(t);
            return this;
        }

        public Reference getRegionsStudiedFirstRep() {
            if (this.getRegionsStudied().isEmpty()) {
                this.addRegionsStudied();
            }
            return this.getRegionsStudied().get(0);
        }

        public List<Reference> getRegionsCalled() {
            if (this.regionsCalled == null) {
                this.regionsCalled = new ArrayList<Reference>();
            }
            return this.regionsCalled;
        }

        public GenomicStudyAnalysisComponent setRegionsCalled(List<Reference> theRegionsCalled) {
            this.regionsCalled = theRegionsCalled;
            return this;
        }

        public boolean hasRegionsCalled() {
            if (this.regionsCalled == null) {
                return false;
            }
            for (Reference item : this.regionsCalled) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addRegionsCalled() {
            Reference t = new Reference();
            if (this.regionsCalled == null) {
                this.regionsCalled = new ArrayList<Reference>();
            }
            this.regionsCalled.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addRegionsCalled(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.regionsCalled == null) {
                this.regionsCalled = new ArrayList<Reference>();
            }
            this.regionsCalled.add(t);
            return this;
        }

        public Reference getRegionsCalledFirstRep() {
            if (this.getRegionsCalled().isEmpty()) {
                this.addRegionsCalled();
            }
            return this.getRegionsCalled().get(0);
        }

        public List<GenomicStudyAnalysisInputComponent> getInput() {
            if (this.input == null) {
                this.input = new ArrayList<GenomicStudyAnalysisInputComponent>();
            }
            return this.input;
        }

        public GenomicStudyAnalysisComponent setInput(List<GenomicStudyAnalysisInputComponent> theInput) {
            this.input = theInput;
            return this;
        }

        public boolean hasInput() {
            if (this.input == null) {
                return false;
            }
            for (GenomicStudyAnalysisInputComponent item : this.input) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GenomicStudyAnalysisInputComponent addInput() {
            GenomicStudyAnalysisInputComponent t = new GenomicStudyAnalysisInputComponent();
            if (this.input == null) {
                this.input = new ArrayList<GenomicStudyAnalysisInputComponent>();
            }
            this.input.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addInput(GenomicStudyAnalysisInputComponent t) {
            if (t == null) {
                return this;
            }
            if (this.input == null) {
                this.input = new ArrayList<GenomicStudyAnalysisInputComponent>();
            }
            this.input.add(t);
            return this;
        }

        public GenomicStudyAnalysisInputComponent getInputFirstRep() {
            if (this.getInput().isEmpty()) {
                this.addInput();
            }
            return this.getInput().get(0);
        }

        public List<GenomicStudyAnalysisOutputComponent> getOutput() {
            if (this.output == null) {
                this.output = new ArrayList<GenomicStudyAnalysisOutputComponent>();
            }
            return this.output;
        }

        public GenomicStudyAnalysisComponent setOutput(List<GenomicStudyAnalysisOutputComponent> theOutput) {
            this.output = theOutput;
            return this;
        }

        public boolean hasOutput() {
            if (this.output == null) {
                return false;
            }
            for (GenomicStudyAnalysisOutputComponent item : this.output) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GenomicStudyAnalysisOutputComponent addOutput() {
            GenomicStudyAnalysisOutputComponent t = new GenomicStudyAnalysisOutputComponent();
            if (this.output == null) {
                this.output = new ArrayList<GenomicStudyAnalysisOutputComponent>();
            }
            this.output.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addOutput(GenomicStudyAnalysisOutputComponent t) {
            if (t == null) {
                return this;
            }
            if (this.output == null) {
                this.output = new ArrayList<GenomicStudyAnalysisOutputComponent>();
            }
            this.output.add(t);
            return this;
        }

        public GenomicStudyAnalysisOutputComponent getOutputFirstRep() {
            if (this.getOutput().isEmpty()) {
                this.addOutput();
            }
            return this.getOutput().get(0);
        }

        public List<GenomicStudyAnalysisPerformerComponent> getPerformer() {
            if (this.performer == null) {
                this.performer = new ArrayList<GenomicStudyAnalysisPerformerComponent>();
            }
            return this.performer;
        }

        public GenomicStudyAnalysisComponent setPerformer(List<GenomicStudyAnalysisPerformerComponent> thePerformer) {
            this.performer = thePerformer;
            return this;
        }

        public boolean hasPerformer() {
            if (this.performer == null) {
                return false;
            }
            for (GenomicStudyAnalysisPerformerComponent item : this.performer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GenomicStudyAnalysisPerformerComponent addPerformer() {
            GenomicStudyAnalysisPerformerComponent t = new GenomicStudyAnalysisPerformerComponent();
            if (this.performer == null) {
                this.performer = new ArrayList<GenomicStudyAnalysisPerformerComponent>();
            }
            this.performer.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addPerformer(GenomicStudyAnalysisPerformerComponent t) {
            if (t == null) {
                return this;
            }
            if (this.performer == null) {
                this.performer = new ArrayList<GenomicStudyAnalysisPerformerComponent>();
            }
            this.performer.add(t);
            return this;
        }

        public GenomicStudyAnalysisPerformerComponent getPerformerFirstRep() {
            if (this.getPerformer().isEmpty()) {
                this.addPerformer();
            }
            return this.getPerformer().get(0);
        }

        public List<GenomicStudyAnalysisDeviceComponent> getDevice() {
            if (this.device == null) {
                this.device = new ArrayList<GenomicStudyAnalysisDeviceComponent>();
            }
            return this.device;
        }

        public GenomicStudyAnalysisComponent setDevice(List<GenomicStudyAnalysisDeviceComponent> theDevice) {
            this.device = theDevice;
            return this;
        }

        public boolean hasDevice() {
            if (this.device == null) {
                return false;
            }
            for (GenomicStudyAnalysisDeviceComponent item : this.device) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GenomicStudyAnalysisDeviceComponent addDevice() {
            GenomicStudyAnalysisDeviceComponent t = new GenomicStudyAnalysisDeviceComponent();
            if (this.device == null) {
                this.device = new ArrayList<GenomicStudyAnalysisDeviceComponent>();
            }
            this.device.add(t);
            return t;
        }

        public GenomicStudyAnalysisComponent addDevice(GenomicStudyAnalysisDeviceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.device == null) {
                this.device = new ArrayList<GenomicStudyAnalysisDeviceComponent>();
            }
            this.device.add(t);
            return this;
        }

        public GenomicStudyAnalysisDeviceComponent getDeviceFirstRep() {
            if (this.getDevice().isEmpty()) {
                this.addDevice();
            }
            return this.getDevice().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(GenomicStudy.SP_IDENTIFIER, "Identifier", "Identifiers for the analysis event.", 0, Integer.MAX_VALUE, this.identifier));
            children.add(new Property("methodType", "CodeableConcept", "Type of the methods used in the analysis, e.g., Fluorescence in situ hybridization (FISH), Karyotyping, or Microsatellite instability testing (MSI).", 0, Integer.MAX_VALUE, this.methodType));
            children.add(new Property("changeType", "CodeableConcept", "Type of the genomic changes studied in the analysis, e.g., DNA, RNA, or amino acid change.", 0, Integer.MAX_VALUE, this.changeType));
            children.add(new Property("genomeBuild", "CodeableConcept", "The reference genome build that is used in this analysis.", 0, 1, this.genomeBuild));
            children.add(new Property("instantiatesCanonical", "canonical(PlanDefinition|ActivityDefinition)", "The defined protocol that describes the analysis.", 0, 1, this.instantiatesCanonical));
            children.add(new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol that describes the analysis.", 0, 1, this.instantiatesUri));
            children.add(new Property("title", "string", "Name of the analysis event (human friendly).", 0, 1, this.title));
            children.add(new Property(GenomicStudy.SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|BiologicallyDerivedProduct|NutritionProduct)", "The subject of the analysis event.", 0, 1, this.subject));
            children.add(new Property("specimen", "Reference(Specimen)", "The specimen used in the analysis event.", 0, Integer.MAX_VALUE, this.specimen));
            children.add(new Property("date", "dateTime", "The date of the analysis event.", 0, 1, this.date));
            children.add(new Property("note", "Annotation", "Any notes capture with the analysis event.", 0, Integer.MAX_VALUE, this.note));
            children.add(new Property("protocolPerformed", "Reference(Procedure|Task)", "The protocol that was performed for the analysis event.", 0, 1, this.protocolPerformed));
            children.add(new Property("regionsStudied", "Reference(DocumentReference|Observation)", "The genomic regions to be studied in the analysis (BED file).", 0, Integer.MAX_VALUE, this.regionsStudied));
            children.add(new Property("regionsCalled", "Reference(DocumentReference|Observation)", "Genomic regions actually called in the analysis event (BED file).", 0, Integer.MAX_VALUE, this.regionsCalled));
            children.add(new Property("input", "", "Inputs for the analysis event.", 0, Integer.MAX_VALUE, this.input));
            children.add(new Property("output", "", "Outputs for the analysis event.", 0, Integer.MAX_VALUE, this.output));
            children.add(new Property("performer", "", "Performer for the analysis event.", 0, Integer.MAX_VALUE, this.performer));
            children.add(new Property("device", "", "Devices used for the analysis (e.g., instruments, software), with settings and parameters.", 0, Integer.MAX_VALUE, this.device));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(GenomicStudy.SP_IDENTIFIER, "Identifier", "Identifiers for the analysis event.", 0, Integer.MAX_VALUE, this.identifier);
                }
                case -722961477: {
                    return new Property("methodType", "CodeableConcept", "Type of the methods used in the analysis, e.g., Fluorescence in situ hybridization (FISH), Karyotyping, or Microsatellite instability testing (MSI).", 0, Integer.MAX_VALUE, this.methodType);
                }
                case -2131902710: {
                    return new Property("changeType", "CodeableConcept", "Type of the genomic changes studied in the analysis, e.g., DNA, RNA, or amino acid change.", 0, Integer.MAX_VALUE, this.changeType);
                }
                case 1061239735: {
                    return new Property("genomeBuild", "CodeableConcept", "The reference genome build that is used in this analysis.", 0, 1, this.genomeBuild);
                }
                case 8911915: {
                    return new Property("instantiatesCanonical", "canonical(PlanDefinition|ActivityDefinition)", "The defined protocol that describes the analysis.", 0, 1, this.instantiatesCanonical);
                }
                case -1926393373: {
                    return new Property("instantiatesUri", "uri", "The URL pointing to an externally maintained protocol that describes the analysis.", 0, 1, this.instantiatesUri);
                }
                case 110371416: {
                    return new Property("title", "string", "Name of the analysis event (human friendly).", 0, 1, this.title);
                }
                case -1867885268: {
                    return new Property(GenomicStudy.SP_SUBJECT, "Reference(Patient|Group|Device|Location|Organization|Procedure|Practitioner|Medication|Substance|BiologicallyDerivedProduct|NutritionProduct)", "The subject of the analysis event.", 0, 1, this.subject);
                }
                case -2132868344: {
                    return new Property("specimen", "Reference(Specimen)", "The specimen used in the analysis event.", 0, Integer.MAX_VALUE, this.specimen);
                }
                case 3076014: {
                    return new Property("date", "dateTime", "The date of the analysis event.", 0, 1, this.date);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Any notes capture with the analysis event.", 0, Integer.MAX_VALUE, this.note);
                }
                case -1565516792: {
                    return new Property("protocolPerformed", "Reference(Procedure|Task)", "The protocol that was performed for the analysis event.", 0, 1, this.protocolPerformed);
                }
                case 391791385: {
                    return new Property("regionsStudied", "Reference(DocumentReference|Observation)", "The genomic regions to be studied in the analysis (BED file).", 0, Integer.MAX_VALUE, this.regionsStudied);
                }
                case -2125803428: {
                    return new Property("regionsCalled", "Reference(DocumentReference|Observation)", "Genomic regions actually called in the analysis event (BED file).", 0, Integer.MAX_VALUE, this.regionsCalled);
                }
                case 100358090: {
                    return new Property("input", "", "Inputs for the analysis event.", 0, Integer.MAX_VALUE, this.input);
                }
                case -1005512447: {
                    return new Property("output", "", "Outputs for the analysis event.", 0, Integer.MAX_VALUE, this.output);
                }
                case 481140686: {
                    return new Property("performer", "", "Performer for the analysis event.", 0, Integer.MAX_VALUE, this.performer);
                }
                case -1335157162: {
                    return new Property("device", "", "Devices used for the analysis (e.g., instruments, software), with settings and parameters.", 0, Integer.MAX_VALUE, this.device);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
                }
                case -722961477: {
                    return this.methodType == null ? new Base[]{} : this.methodType.toArray(new Base[this.methodType.size()]);
                }
                case -2131902710: {
                    return this.changeType == null ? new Base[]{} : this.changeType.toArray(new Base[this.changeType.size()]);
                }
                case 1061239735: {
                    Base[] baseArray;
                    if (this.genomeBuild == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.genomeBuild;
                    }
                    return baseArray;
                }
                case 8911915: {
                    Base[] baseArray;
                    if (this.instantiatesCanonical == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.instantiatesCanonical;
                    }
                    return baseArray;
                }
                case -1926393373: {
                    Base[] baseArray;
                    if (this.instantiatesUri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.instantiatesUri;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.title;
                    }
                    return baseArray;
                }
                case -1867885268: {
                    Base[] baseArray;
                    if (this.subject == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.subject;
                    }
                    return baseArray;
                }
                case -2132868344: {
                    return this.specimen == null ? new Base[]{} : this.specimen.toArray(new Base[this.specimen.size()]);
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.date;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
                case -1565516792: {
                    Base[] baseArray;
                    if (this.protocolPerformed == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.protocolPerformed;
                    }
                    return baseArray;
                }
                case 391791385: {
                    return this.regionsStudied == null ? new Base[]{} : this.regionsStudied.toArray(new Base[this.regionsStudied.size()]);
                }
                case -2125803428: {
                    return this.regionsCalled == null ? new Base[]{} : this.regionsCalled.toArray(new Base[this.regionsCalled.size()]);
                }
                case 100358090: {
                    return this.input == null ? new Base[]{} : this.input.toArray(new Base[this.input.size()]);
                }
                case -1005512447: {
                    return this.output == null ? new Base[]{} : this.output.toArray(new Base[this.output.size()]);
                }
                case 481140686: {
                    return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
                }
                case -1335157162: {
                    return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                    return value;
                }
                case -722961477: {
                    this.getMethodType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -2131902710: {
                    this.getChangeType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1061239735: {
                    this.genomeBuild = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 8911915: {
                    this.instantiatesCanonical = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -1926393373: {
                    this.instantiatesUri = TypeConvertor.castToUri(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case -1867885268: {
                    this.subject = TypeConvertor.castToReference(value);
                    return value;
                }
                case -2132868344: {
                    this.getSpecimen().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 3076014: {
                    this.date = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
                case -1565516792: {
                    this.protocolPerformed = TypeConvertor.castToReference(value);
                    return value;
                }
                case 391791385: {
                    this.getRegionsStudied().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -2125803428: {
                    this.getRegionsCalled().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 100358090: {
                    this.getInput().add((GenomicStudyAnalysisInputComponent)value);
                    return value;
                }
                case -1005512447: {
                    this.getOutput().add((GenomicStudyAnalysisOutputComponent)value);
                    return value;
                }
                case 481140686: {
                    this.getPerformer().add((GenomicStudyAnalysisPerformerComponent)value);
                    return value;
                }
                case -1335157162: {
                    this.getDevice().add((GenomicStudyAnalysisDeviceComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(GenomicStudy.SP_IDENTIFIER)) {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
            } else if (name.equals("methodType")) {
                this.getMethodType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("changeType")) {
                this.getChangeType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("genomeBuild")) {
                this.genomeBuild = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("instantiatesCanonical")) {
                this.instantiatesCanonical = TypeConvertor.castToCanonical(value);
            } else if (name.equals("instantiatesUri")) {
                this.instantiatesUri = TypeConvertor.castToUri(value);
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals(GenomicStudy.SP_SUBJECT)) {
                this.subject = TypeConvertor.castToReference(value);
            } else if (name.equals("specimen")) {
                this.getSpecimen().add(TypeConvertor.castToReference(value));
            } else if (name.equals("date")) {
                this.date = TypeConvertor.castToDateTime(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else if (name.equals("protocolPerformed")) {
                this.protocolPerformed = TypeConvertor.castToReference(value);
            } else if (name.equals("regionsStudied")) {
                this.getRegionsStudied().add(TypeConvertor.castToReference(value));
            } else if (name.equals("regionsCalled")) {
                this.getRegionsCalled().add(TypeConvertor.castToReference(value));
            } else if (name.equals("input")) {
                this.getInput().add((GenomicStudyAnalysisInputComponent)value);
            } else if (name.equals("output")) {
                this.getOutput().add((GenomicStudyAnalysisOutputComponent)value);
            } else if (name.equals("performer")) {
                this.getPerformer().add((GenomicStudyAnalysisPerformerComponent)value);
            } else if (name.equals("device")) {
                this.getDevice().add((GenomicStudyAnalysisDeviceComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.addIdentifier();
                }
                case -722961477: {
                    return this.addMethodType();
                }
                case -2131902710: {
                    return this.addChangeType();
                }
                case 1061239735: {
                    return this.getGenomeBuild();
                }
                case 8911915: {
                    return this.getInstantiatesCanonicalElement();
                }
                case -1926393373: {
                    return this.getInstantiatesUriElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case -1867885268: {
                    return this.getSubject();
                }
                case -2132868344: {
                    return this.addSpecimen();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case 3387378: {
                    return this.addNote();
                }
                case -1565516792: {
                    return this.getProtocolPerformed();
                }
                case 391791385: {
                    return this.addRegionsStudied();
                }
                case -2125803428: {
                    return this.addRegionsCalled();
                }
                case 100358090: {
                    return this.addInput();
                }
                case -1005512447: {
                    return this.addOutput();
                }
                case 481140686: {
                    return this.addPerformer();
                }
                case -1335157162: {
                    return this.addDevice();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -722961477: {
                    return new String[]{"CodeableConcept"};
                }
                case -2131902710: {
                    return new String[]{"CodeableConcept"};
                }
                case 1061239735: {
                    return new String[]{"CodeableConcept"};
                }
                case 8911915: {
                    return new String[]{"canonical"};
                }
                case -1926393373: {
                    return new String[]{"uri"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case -1867885268: {
                    return new String[]{"Reference"};
                }
                case -2132868344: {
                    return new String[]{"Reference"};
                }
                case 3076014: {
                    return new String[]{"dateTime"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
                case -1565516792: {
                    return new String[]{"Reference"};
                }
                case 391791385: {
                    return new String[]{"Reference"};
                }
                case -2125803428: {
                    return new String[]{"Reference"};
                }
                case 100358090: {
                    return new String[0];
                }
                case -1005512447: {
                    return new String[0];
                }
                case 481140686: {
                    return new String[0];
                }
                case -1335157162: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(GenomicStudy.SP_IDENTIFIER)) {
                return this.addIdentifier();
            }
            if (name.equals("methodType")) {
                return this.addMethodType();
            }
            if (name.equals("changeType")) {
                return this.addChangeType();
            }
            if (name.equals("genomeBuild")) {
                this.genomeBuild = new CodeableConcept();
                return this.genomeBuild;
            }
            if (name.equals("instantiatesCanonical")) {
                throw new FHIRException("Cannot call addChild on a primitive type GenomicStudy.analysis.instantiatesCanonical");
            }
            if (name.equals("instantiatesUri")) {
                throw new FHIRException("Cannot call addChild on a primitive type GenomicStudy.analysis.instantiatesUri");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type GenomicStudy.analysis.title");
            }
            if (name.equals(GenomicStudy.SP_SUBJECT)) {
                this.subject = new Reference();
                return this.subject;
            }
            if (name.equals("specimen")) {
                return this.addSpecimen();
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type GenomicStudy.analysis.date");
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            if (name.equals("protocolPerformed")) {
                this.protocolPerformed = new Reference();
                return this.protocolPerformed;
            }
            if (name.equals("regionsStudied")) {
                return this.addRegionsStudied();
            }
            if (name.equals("regionsCalled")) {
                return this.addRegionsCalled();
            }
            if (name.equals("input")) {
                return this.addInput();
            }
            if (name.equals("output")) {
                return this.addOutput();
            }
            if (name.equals("performer")) {
                return this.addPerformer();
            }
            if (name.equals("device")) {
                return this.addDevice();
            }
            return super.addChild(name);
        }

        @Override
        public GenomicStudyAnalysisComponent copy() {
            GenomicStudyAnalysisComponent dst = new GenomicStudyAnalysisComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(GenomicStudyAnalysisComponent dst) {
            super.copyValues(dst);
            if (this.identifier != null) {
                dst.identifier = new ArrayList<Identifier>();
                for (Identifier identifier : this.identifier) {
                    dst.identifier.add(identifier.copy());
                }
            }
            if (this.methodType != null) {
                dst.methodType = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.methodType) {
                    dst.methodType.add(codeableConcept.copy());
                }
            }
            if (this.changeType != null) {
                dst.changeType = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.changeType) {
                    dst.changeType.add(codeableConcept.copy());
                }
            }
            dst.genomeBuild = this.genomeBuild == null ? null : this.genomeBuild.copy();
            dst.instantiatesCanonical = this.instantiatesCanonical == null ? null : this.instantiatesCanonical.copy();
            dst.instantiatesUri = this.instantiatesUri == null ? null : this.instantiatesUri.copy();
            dst.title = this.title == null ? null : this.title.copy();
            Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
            if (this.specimen != null) {
                dst.specimen = new ArrayList<Reference>();
                for (Reference reference2 : this.specimen) {
                    dst.specimen.add(reference2.copy());
                }
            }
            DateTimeType dateTimeType = dst.date = this.date == null ? null : this.date.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
            Reference reference3 = dst.protocolPerformed = this.protocolPerformed == null ? null : this.protocolPerformed.copy();
            if (this.regionsStudied != null) {
                dst.regionsStudied = new ArrayList<Reference>();
                for (Reference reference4 : this.regionsStudied) {
                    dst.regionsStudied.add(reference4.copy());
                }
            }
            if (this.regionsCalled != null) {
                dst.regionsCalled = new ArrayList<Reference>();
                for (Reference reference5 : this.regionsCalled) {
                    dst.regionsCalled.add(reference5.copy());
                }
            }
            if (this.input != null) {
                dst.input = new ArrayList<GenomicStudyAnalysisInputComponent>();
                for (GenomicStudyAnalysisInputComponent genomicStudyAnalysisInputComponent : this.input) {
                    dst.input.add(genomicStudyAnalysisInputComponent.copy());
                }
            }
            if (this.output != null) {
                dst.output = new ArrayList<GenomicStudyAnalysisOutputComponent>();
                for (GenomicStudyAnalysisOutputComponent genomicStudyAnalysisOutputComponent : this.output) {
                    dst.output.add(genomicStudyAnalysisOutputComponent.copy());
                }
            }
            if (this.performer != null) {
                dst.performer = new ArrayList<GenomicStudyAnalysisPerformerComponent>();
                for (GenomicStudyAnalysisPerformerComponent genomicStudyAnalysisPerformerComponent : this.performer) {
                    dst.performer.add(genomicStudyAnalysisPerformerComponent.copy());
                }
            }
            if (this.device != null) {
                dst.device = new ArrayList<GenomicStudyAnalysisDeviceComponent>();
                for (GenomicStudyAnalysisDeviceComponent genomicStudyAnalysisDeviceComponent : this.device) {
                    dst.device.add(genomicStudyAnalysisDeviceComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GenomicStudyAnalysisComponent)) {
                return false;
            }
            GenomicStudyAnalysisComponent o = (GenomicStudyAnalysisComponent)other_;
            return GenomicStudyAnalysisComponent.compareDeep(this.identifier, o.identifier, true) && GenomicStudyAnalysisComponent.compareDeep(this.methodType, o.methodType, true) && GenomicStudyAnalysisComponent.compareDeep(this.changeType, o.changeType, true) && GenomicStudyAnalysisComponent.compareDeep(this.genomeBuild, o.genomeBuild, true) && GenomicStudyAnalysisComponent.compareDeep(this.instantiatesCanonical, o.instantiatesCanonical, true) && GenomicStudyAnalysisComponent.compareDeep(this.instantiatesUri, o.instantiatesUri, true) && GenomicStudyAnalysisComponent.compareDeep(this.title, o.title, true) && GenomicStudyAnalysisComponent.compareDeep(this.subject, o.subject, true) && GenomicStudyAnalysisComponent.compareDeep(this.specimen, o.specimen, true) && GenomicStudyAnalysisComponent.compareDeep(this.date, o.date, true) && GenomicStudyAnalysisComponent.compareDeep(this.note, o.note, true) && GenomicStudyAnalysisComponent.compareDeep(this.protocolPerformed, o.protocolPerformed, true) && GenomicStudyAnalysisComponent.compareDeep(this.regionsStudied, o.regionsStudied, true) && GenomicStudyAnalysisComponent.compareDeep(this.regionsCalled, o.regionsCalled, true) && GenomicStudyAnalysisComponent.compareDeep(this.input, o.input, true) && GenomicStudyAnalysisComponent.compareDeep(this.output, o.output, true) && GenomicStudyAnalysisComponent.compareDeep(this.performer, o.performer, true) && GenomicStudyAnalysisComponent.compareDeep(this.device, o.device, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GenomicStudyAnalysisComponent)) {
                return false;
            }
            GenomicStudyAnalysisComponent o = (GenomicStudyAnalysisComponent)other_;
            return GenomicStudyAnalysisComponent.compareValues(this.instantiatesCanonical, o.instantiatesCanonical, true) && GenomicStudyAnalysisComponent.compareValues(this.instantiatesUri, o.instantiatesUri, true) && GenomicStudyAnalysisComponent.compareValues(this.title, o.title, true) && GenomicStudyAnalysisComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.methodType, this.changeType, this.genomeBuild, this.instantiatesCanonical, this.instantiatesUri, this.title, this.subject, this.specimen, this.date, this.note, this.protocolPerformed, this.regionsStudied, this.regionsCalled, this.input, this.output, this.performer, this.device);
        }

        @Override
        public String fhirType() {
            return "GenomicStudy.analysis";
        }
    }
}

