/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="DeviceUsage", profile="http://hl7.org/fhir/StructureDefinition/DeviceUsage")
public class DeviceUsage
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifier for this record", formalDefinition="An external identifier for this statement such as an IRI.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={ServiceRequest.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Fulfills plan, proposal or order", formalDefinition="A plan, proposal or order that is fulfilled in whole or in part by this DeviceUsage.")
    protected List<Reference> basedOn;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | completed | not-done | entered-in-error +", formalDefinition="A code representing the patient or other source's judgment about the state of the device used that this statement is about.  Generally this will be active or completed.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/deviceusage-status")
    protected Enumeration<DeviceUsageStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The category of the statement - classifying how the statement is made", formalDefinition="This attribute indicates a category for the statement - The device statement may be made in an inpatient or outpatient settting (inpatient | outpatient | community | patientspecified).")
    protected List<CodeableConcept> category;
    @Child(name="patient", type={Patient.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Patient using device", formalDefinition="The patient who used the device.")
    protected Reference patient;
    @Child(name="derivedFrom", type={ServiceRequest.class, Procedure.class, Claim.class, Observation.class, QuestionnaireResponse.class, DocumentReference.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Supporting information", formalDefinition="Allows linking the DeviceUsage to the underlying Request, or to other information that supports or is used to derive the DeviceUsage.")
    protected List<Reference> derivedFrom;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The encounter or episode of care that establishes the context for this device use statement", formalDefinition="The encounter or episode of care that establishes the context for this device use statement.")
    protected Reference context;
    @Child(name="timing", type={Timing.class, Period.class, DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How often  the device was used", formalDefinition="How often the device was used.")
    protected DataType timing;
    @Child(name="dateAsserted", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the statement was made (and recorded)", formalDefinition="The time at which the statement was recorded by informationSource.")
    protected DateTimeType dateAsserted;
    @Child(name="usageStatus", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The status of the device usage, for example always, sometimes, never. This is not the same as the status of the statement", formalDefinition="The status of the device usage, for example always, sometimes, never. This is not the same as the status of the statement.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/deviceusage-status")
    protected CodeableConcept usageStatus;
    @Child(name="usageReason", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The reason for asserting the usage status - for example forgot, lost, stolen, broken", formalDefinition="The reason for asserting the usage status - for example forgot, lost, stolen, broken.")
    protected List<CodeableConcept> usageReason;
    @Child(name="adherence", type={}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How device is being used", formalDefinition="This indicates how or if the device is being used.")
    protected DeviceUsageAdherenceComponent adherence;
    @Child(name="informationSource", type={Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class, Organization.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who made the statement", formalDefinition="Who reported the device was being used by the patient.")
    protected Reference informationSource;
    @Child(name="device", type={CodeableReference.class}, order=13, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code or Reference to device used", formalDefinition="Code or Reference to device used.")
    protected CodeableReference device;
    @Child(name="reason", type={CodeableReference.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why device was used", formalDefinition="Reason or justification for the use of the device. A coded concept, or another resource whose existence justifies this DeviceUsage.")
    protected List<CodeableReference> reason;
    @Child(name="bodySite", type={CodeableReference.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Target body site", formalDefinition="Indicates the anotomic location on the subject's body where the device was used ( i.e. the target).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected CodeableReference bodySite;
    @Child(name="note", type={Annotation.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Addition details (comments, instructions)", formalDefinition="Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -10803928L;
    @SearchParamDefinition(name="device", path="DeviceUsage.device.concept", description="Search by device", type="token")
    public static final String SP_DEVICE = "device";
    public static final TokenClientParam DEVICE = new TokenClientParam("device");
    @SearchParamDefinition(name="identifier", path="DeviceUsage.identifier", description="Search by identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.subject | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DeviceUsage:patient").toLocked();

    public DeviceUsage() {
    }

    public DeviceUsage(DeviceUsageStatus status, Reference patient, CodeableReference device) {
        this.setStatus(status);
        this.setPatient(patient);
        this.setDevice(device);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DeviceUsage setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceUsage addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public DeviceUsage setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public DeviceUsage addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Enumeration<DeviceUsageStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUsage.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DeviceUsageStatus>(new DeviceUsageStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DeviceUsage setStatusElement(Enumeration<DeviceUsageStatus> value) {
        this.status = value;
        return this;
    }

    public DeviceUsageStatus getStatus() {
        return this.status == null ? null : (DeviceUsageStatus)((Object)this.status.getValue());
    }

    public DeviceUsage setStatus(DeviceUsageStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<DeviceUsageStatus>(new DeviceUsageStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public DeviceUsage setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public DeviceUsage addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUsage.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public DeviceUsage setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public List<Reference> getDerivedFrom() {
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        return this.derivedFrom;
    }

    public DeviceUsage setDerivedFrom(List<Reference> theDerivedFrom) {
        this.derivedFrom = theDerivedFrom;
        return this;
    }

    public boolean hasDerivedFrom() {
        if (this.derivedFrom == null) {
            return false;
        }
        for (Reference item : this.derivedFrom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDerivedFrom() {
        Reference t = new Reference();
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return t;
    }

    public DeviceUsage addDerivedFrom(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.derivedFrom == null) {
            this.derivedFrom = new ArrayList<Reference>();
        }
        this.derivedFrom.add(t);
        return this;
    }

    public Reference getDerivedFromFirstRep() {
        if (this.getDerivedFrom().isEmpty()) {
            this.addDerivedFrom();
        }
        return this.getDerivedFrom().get(0);
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUsage.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public DeviceUsage setContext(Reference value) {
        this.context = value;
        return this;
    }

    public DataType getTiming() {
        return this.timing;
    }

    public Timing getTimingTiming() throws FHIRException {
        if (this.timing == null) {
            this.timing = new Timing();
        }
        if (!(this.timing instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Timing)this.timing;
    }

    public boolean hasTimingTiming() {
        return this != null && this.timing instanceof Timing;
    }

    public Period getTimingPeriod() throws FHIRException {
        if (this.timing == null) {
            this.timing = new Period();
        }
        if (!(this.timing instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Period)this.timing;
    }

    public boolean hasTimingPeriod() {
        return this != null && this.timing instanceof Period;
    }

    public DateTimeType getTimingDateTimeType() throws FHIRException {
        if (this.timing == null) {
            this.timing = new DateTimeType();
        }
        if (!(this.timing instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.timing;
    }

    public boolean hasTimingDateTimeType() {
        return this != null && this.timing instanceof DateTimeType;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public DeviceUsage setTiming(DataType value) {
        if (!(value == null || value instanceof Timing || value instanceof Period || value instanceof DateTimeType)) {
            throw new Error("Not the right type for DeviceUsage.timing[x]: " + value.fhirType());
        }
        this.timing = value;
        return this;
    }

    public DateTimeType getDateAssertedElement() {
        if (this.dateAsserted == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUsage.dateAsserted");
            }
            if (Configuration.doAutoCreate()) {
                this.dateAsserted = new DateTimeType();
            }
        }
        return this.dateAsserted;
    }

    public boolean hasDateAssertedElement() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public boolean hasDateAsserted() {
        return this.dateAsserted != null && !this.dateAsserted.isEmpty();
    }

    public DeviceUsage setDateAssertedElement(DateTimeType value) {
        this.dateAsserted = value;
        return this;
    }

    public Date getDateAsserted() {
        return this.dateAsserted == null ? null : (Date)this.dateAsserted.getValue();
    }

    public DeviceUsage setDateAsserted(Date value) {
        if (value == null) {
            this.dateAsserted = null;
        } else {
            if (this.dateAsserted == null) {
                this.dateAsserted = new DateTimeType();
            }
            this.dateAsserted.setValue(value);
        }
        return this;
    }

    public CodeableConcept getUsageStatus() {
        if (this.usageStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUsage.usageStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.usageStatus = new CodeableConcept();
            }
        }
        return this.usageStatus;
    }

    public boolean hasUsageStatus() {
        return this.usageStatus != null && !this.usageStatus.isEmpty();
    }

    public DeviceUsage setUsageStatus(CodeableConcept value) {
        this.usageStatus = value;
        return this;
    }

    public List<CodeableConcept> getUsageReason() {
        if (this.usageReason == null) {
            this.usageReason = new ArrayList<CodeableConcept>();
        }
        return this.usageReason;
    }

    public DeviceUsage setUsageReason(List<CodeableConcept> theUsageReason) {
        this.usageReason = theUsageReason;
        return this;
    }

    public boolean hasUsageReason() {
        if (this.usageReason == null) {
            return false;
        }
        for (CodeableConcept item : this.usageReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addUsageReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.usageReason == null) {
            this.usageReason = new ArrayList<CodeableConcept>();
        }
        this.usageReason.add(t);
        return t;
    }

    public DeviceUsage addUsageReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.usageReason == null) {
            this.usageReason = new ArrayList<CodeableConcept>();
        }
        this.usageReason.add(t);
        return this;
    }

    public CodeableConcept getUsageReasonFirstRep() {
        if (this.getUsageReason().isEmpty()) {
            this.addUsageReason();
        }
        return this.getUsageReason().get(0);
    }

    public DeviceUsageAdherenceComponent getAdherence() {
        if (this.adherence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUsage.adherence");
            }
            if (Configuration.doAutoCreate()) {
                this.adherence = new DeviceUsageAdherenceComponent();
            }
        }
        return this.adherence;
    }

    public boolean hasAdherence() {
        return this.adherence != null && !this.adherence.isEmpty();
    }

    public DeviceUsage setAdherence(DeviceUsageAdherenceComponent value) {
        this.adherence = value;
        return this;
    }

    public Reference getInformationSource() {
        if (this.informationSource == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUsage.informationSource");
            }
            if (Configuration.doAutoCreate()) {
                this.informationSource = new Reference();
            }
        }
        return this.informationSource;
    }

    public boolean hasInformationSource() {
        return this.informationSource != null && !this.informationSource.isEmpty();
    }

    public DeviceUsage setInformationSource(Reference value) {
        this.informationSource = value;
        return this;
    }

    public CodeableReference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUsage.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new CodeableReference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public DeviceUsage setDevice(CodeableReference value) {
        this.device = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public DeviceUsage setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public DeviceUsage addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public CodeableReference getBodySite() {
        if (this.bodySite == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUsage.bodySite");
            }
            if (Configuration.doAutoCreate()) {
                this.bodySite = new CodeableReference();
            }
        }
        return this.bodySite;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public DeviceUsage setBodySite(CodeableReference value) {
        this.bodySite = value;
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public DeviceUsage setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public DeviceUsage addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "An external identifier for this statement such as an IRI.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("basedOn", "Reference(ServiceRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this DeviceUsage.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("status", "code", "A code representing the patient or other source's judgment about the state of the device used that this statement is about.  Generally this will be active or completed.", 0, 1, this.status));
        children.add(new Property("category", "CodeableConcept", "This attribute indicates a category for the statement - The device statement may be made in an inpatient or outpatient settting (inpatient | outpatient | community | patientspecified).", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient who used the device.", 0, 1, this.patient));
        children.add(new Property("derivedFrom", "Reference(ServiceRequest|Procedure|Claim|Observation|QuestionnaireResponse|DocumentReference)", "Allows linking the DeviceUsage to the underlying Request, or to other information that supports or is used to derive the DeviceUsage.", 0, Integer.MAX_VALUE, this.derivedFrom));
        children.add(new Property("context", "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this device use statement.", 0, 1, this.context));
        children.add(new Property("timing[x]", "Timing|Period|dateTime", "How often the device was used.", 0, 1, this.timing));
        children.add(new Property("dateAsserted", "dateTime", "The time at which the statement was recorded by informationSource.", 0, 1, this.dateAsserted));
        children.add(new Property("usageStatus", "CodeableConcept", "The status of the device usage, for example always, sometimes, never. This is not the same as the status of the statement.", 0, 1, this.usageStatus));
        children.add(new Property("usageReason", "CodeableConcept", "The reason for asserting the usage status - for example forgot, lost, stolen, broken.", 0, Integer.MAX_VALUE, this.usageReason));
        children.add(new Property("adherence", "", "This indicates how or if the device is being used.", 0, 1, this.adherence));
        children.add(new Property("informationSource", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "Who reported the device was being used by the patient.", 0, 1, this.informationSource));
        children.add(new Property(SP_DEVICE, "CodeableReference(Device|DeviceDefinition)", "Code or Reference to device used.", 0, 1, this.device));
        children.add(new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference|Procedure)", "Reason or justification for the use of the device. A coded concept, or another resource whose existence justifies this DeviceUsage.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("bodySite", "CodeableReference(BodyStructure)", "Indicates the anotomic location on the subject's body where the device was used ( i.e. the target).", 0, 1, this.bodySite));
        children.add(new Property("note", "Annotation", "Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "An external identifier for this statement such as an IRI.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(ServiceRequest)", "A plan, proposal or order that is fulfilled in whole or in part by this DeviceUsage.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -892481550: {
                return new Property("status", "code", "A code representing the patient or other source's judgment about the state of the device used that this statement is about.  Generally this will be active or completed.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "This attribute indicates a category for the statement - The device statement may be made in an inpatient or outpatient settting (inpatient | outpatient | community | patientspecified).", 0, Integer.MAX_VALUE, this.category);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient who used the device.", 0, 1, this.patient);
            }
            case 1077922663: {
                return new Property("derivedFrom", "Reference(ServiceRequest|Procedure|Claim|Observation|QuestionnaireResponse|DocumentReference)", "Allows linking the DeviceUsage to the underlying Request, or to other information that supports or is used to derive the DeviceUsage.", 0, Integer.MAX_VALUE, this.derivedFrom);
            }
            case 951530927: {
                return new Property("context", "Reference(Encounter|EpisodeOfCare)", "The encounter or episode of care that establishes the context for this device use statement.", 0, 1, this.context);
            }
            case 164632566: {
                return new Property("timing[x]", "Timing|Period|dateTime", "How often the device was used.", 0, 1, this.timing);
            }
            case -873664438: {
                return new Property("timing[x]", "Timing|Period|dateTime", "How often the device was used.", 0, 1, this.timing);
            }
            case -497554124: {
                return new Property("timing[x]", "Timing", "How often the device was used.", 0, 1, this.timing);
            }
            case -615615829: {
                return new Property("timing[x]", "Period", "How often the device was used.", 0, 1, this.timing);
            }
            case -1837458939: {
                return new Property("timing[x]", "dateTime", "How often the device was used.", 0, 1, this.timing);
            }
            case -1980855245: {
                return new Property("dateAsserted", "dateTime", "The time at which the statement was recorded by informationSource.", 0, 1, this.dateAsserted);
            }
            case 907197683: {
                return new Property("usageStatus", "CodeableConcept", "The status of the device usage, for example always, sometimes, never. This is not the same as the status of the statement.", 0, 1, this.usageStatus);
            }
            case 864714565: {
                return new Property("usageReason", "CodeableConcept", "The reason for asserting the usage status - for example forgot, lost, stolen, broken.", 0, Integer.MAX_VALUE, this.usageReason);
            }
            case -231003683: {
                return new Property("adherence", "", "This indicates how or if the device is being used.", 0, 1, this.adherence);
            }
            case -2123220889: {
                return new Property("informationSource", "Reference(Patient|Practitioner|PractitionerRole|RelatedPerson|Organization)", "Who reported the device was being used by the patient.", 0, 1, this.informationSource);
            }
            case -1335157162: {
                return new Property(SP_DEVICE, "CodeableReference(Device|DeviceDefinition)", "Code or Reference to device used.", 0, 1, this.device);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference|Procedure)", "Reason or justification for the use of the device. A coded concept, or another resource whose existence justifies this DeviceUsage.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableReference(BodyStructure)", "Indicates the anotomic location on the subject's body where the device was used ( i.e. the target).", 0, 1, this.bodySite);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case 1077922663: {
                return this.derivedFrom == null ? new Base[]{} : this.derivedFrom.toArray(new Base[this.derivedFrom.size()]);
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.context;
                }
                return baseArray;
            }
            case -873664438: {
                Base[] baseArray;
                if (this.timing == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.timing;
                }
                return baseArray;
            }
            case -1980855245: {
                Base[] baseArray;
                if (this.dateAsserted == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.dateAsserted;
                }
                return baseArray;
            }
            case 907197683: {
                Base[] baseArray;
                if (this.usageStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.usageStatus;
                }
                return baseArray;
            }
            case 864714565: {
                return this.usageReason == null ? new Base[]{} : this.usageReason.toArray(new Base[this.usageReason.size()]);
            }
            case -231003683: {
                Base[] baseArray;
                if (this.adherence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.adherence;
                }
                return baseArray;
            }
            case -2123220889: {
                Base[] baseArray;
                if (this.informationSource == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.informationSource;
                }
                return baseArray;
            }
            case -1335157162: {
                Base[] baseArray;
                if (this.device == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.device;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1702620169: {
                Base[] baseArray;
                if (this.bodySite == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.bodySite;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new DeviceUsageStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 1077922663: {
                this.getDerivedFrom().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 951530927: {
                this.context = TypeConvertor.castToReference(value);
                return value;
            }
            case -873664438: {
                this.timing = TypeConvertor.castToType(value);
                return value;
            }
            case -1980855245: {
                this.dateAsserted = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 907197683: {
                this.usageStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 864714565: {
                this.getUsageReason().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -231003683: {
                this.adherence = (DeviceUsageAdherenceComponent)((Object)value);
                return value;
            }
            case -2123220889: {
                this.informationSource = TypeConvertor.castToReference(value);
                return value;
            }
            case -1335157162: {
                this.device = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 1702620169: {
                this.bodySite = TypeConvertor.castToCodeableReference(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals("status")) {
            value = new DeviceUsageStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("category")) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals("derivedFrom")) {
            this.getDerivedFrom().add(TypeConvertor.castToReference(value));
        } else if (name.equals("context")) {
            this.context = TypeConvertor.castToReference(value);
        } else if (name.equals("timing[x]")) {
            this.timing = TypeConvertor.castToType(value);
        } else if (name.equals("dateAsserted")) {
            this.dateAsserted = TypeConvertor.castToDateTime(value);
        } else if (name.equals("usageStatus")) {
            this.usageStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("usageReason")) {
            this.getUsageReason().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("adherence")) {
            this.adherence = (DeviceUsageAdherenceComponent)((Object)value);
        } else if (name.equals("informationSource")) {
            this.informationSource = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("bodySite")) {
            this.bodySite = TypeConvertor.castToCodeableReference(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1077922663: {
                return this.addDerivedFrom();
            }
            case 951530927: {
                return this.getContext();
            }
            case 164632566: {
                return this.getTiming();
            }
            case -873664438: {
                return this.getTiming();
            }
            case -1980855245: {
                return this.getDateAssertedElement();
            }
            case 907197683: {
                return this.getUsageStatus();
            }
            case 864714565: {
                return this.addUsageReason();
            }
            case -231003683: {
                return this.getAdherence();
            }
            case -2123220889: {
                return this.getInformationSource();
            }
            case -1335157162: {
                return this.getDevice();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1702620169: {
                return this.getBodySite();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1077922663: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -873664438: {
                return new String[]{"Timing", "Period", "dateTime"};
            }
            case -1980855245: {
                return new String[]{"dateTime"};
            }
            case 907197683: {
                return new String[]{"CodeableConcept"};
            }
            case 864714565: {
                return new String[]{"CodeableConcept"};
            }
            case -231003683: {
                return new String[0];
            }
            case -2123220889: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"CodeableReference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 1702620169: {
                return new String[]{"CodeableReference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceUsage.status");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("derivedFrom")) {
            return this.addDerivedFrom();
        }
        if (name.equals("context")) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("timingTiming")) {
            this.timing = new Timing();
            return this.timing;
        }
        if (name.equals("timingPeriod")) {
            this.timing = new Period();
            return this.timing;
        }
        if (name.equals("timingDateTime")) {
            this.timing = new DateTimeType();
            return this.timing;
        }
        if (name.equals("dateAsserted")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceUsage.dateAsserted");
        }
        if (name.equals("usageStatus")) {
            this.usageStatus = new CodeableConcept();
            return this.usageStatus;
        }
        if (name.equals("usageReason")) {
            return this.addUsageReason();
        }
        if (name.equals("adherence")) {
            this.adherence = new DeviceUsageAdherenceComponent();
            return this.adherence;
        }
        if (name.equals("informationSource")) {
            this.informationSource = new Reference();
            return this.informationSource;
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new CodeableReference();
            return this.device;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("bodySite")) {
            this.bodySite = new CodeableReference();
            return this.bodySite;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceUsage";
    }

    @Override
    public DeviceUsage copy() {
        DeviceUsage dst = new DeviceUsage();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DeviceUsage dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Enumeration<DeviceUsageStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        Reference reference = dst.patient = this.patient == null ? null : this.patient.copy();
        if (this.derivedFrom != null) {
            dst.derivedFrom = new ArrayList<Reference>();
            for (Reference reference2 : this.derivedFrom) {
                dst.derivedFrom.add(reference2.copy());
            }
        }
        dst.context = this.context == null ? null : this.context.copy();
        dst.timing = this.timing == null ? null : this.timing.copy();
        dst.dateAsserted = this.dateAsserted == null ? null : this.dateAsserted.copy();
        CodeableConcept codeableConcept = dst.usageStatus = this.usageStatus == null ? null : this.usageStatus.copy();
        if (this.usageReason != null) {
            dst.usageReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.usageReason) {
                dst.usageReason.add(codeableConcept2.copy());
            }
        }
        dst.adherence = this.adherence == null ? null : this.adherence.copy();
        dst.informationSource = this.informationSource == null ? null : this.informationSource.copy();
        CodeableReference codeableReference = dst.device = this.device == null ? null : this.device.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference2 : this.reason) {
                dst.reason.add(codeableReference2.copy());
            }
        }
        CodeableReference codeableReference3 = dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected DeviceUsage typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceUsage)) {
            return false;
        }
        DeviceUsage o = (DeviceUsage)other_;
        return DeviceUsage.compareDeep(this.identifier, o.identifier, true) && DeviceUsage.compareDeep(this.basedOn, o.basedOn, true) && DeviceUsage.compareDeep(this.status, o.status, true) && DeviceUsage.compareDeep(this.category, o.category, true) && DeviceUsage.compareDeep(this.patient, o.patient, true) && DeviceUsage.compareDeep(this.derivedFrom, o.derivedFrom, true) && DeviceUsage.compareDeep(this.context, o.context, true) && DeviceUsage.compareDeep(this.timing, o.timing, true) && DeviceUsage.compareDeep(this.dateAsserted, o.dateAsserted, true) && DeviceUsage.compareDeep(this.usageStatus, o.usageStatus, true) && DeviceUsage.compareDeep(this.usageReason, o.usageReason, true) && DeviceUsage.compareDeep(this.adherence, o.adherence, true) && DeviceUsage.compareDeep(this.informationSource, o.informationSource, true) && DeviceUsage.compareDeep(this.device, o.device, true) && DeviceUsage.compareDeep(this.reason, o.reason, true) && DeviceUsage.compareDeep(this.bodySite, o.bodySite, true) && DeviceUsage.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceUsage)) {
            return false;
        }
        DeviceUsage o = (DeviceUsage)other_;
        return DeviceUsage.compareValues(this.status, o.status, true) && DeviceUsage.compareValues(this.dateAsserted, o.dateAsserted, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.basedOn, this.status, this.category, this.patient, this.derivedFrom, this.context, this.timing, this.dateAsserted, this.usageStatus, this.usageReason, this.adherence, this.informationSource, this.device, this.reason, this.bodySite, this.note);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceUsage;
    }

    @Block
    public static class DeviceUsageAdherenceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="always | never | sometimes", formalDefinition="Type of adherence.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/deviceusage-adherence-code")
        protected CodeableConcept code;
        @Child(name="reason", type={CodeableConcept.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="lost | stolen | prescribed | broken | burned | forgot", formalDefinition="Reason for adherence type.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/deviceusage-adherence-reason")
        protected List<CodeableConcept> reason;
        private static final long serialVersionUID = -1932336797L;

        public DeviceUsageAdherenceComponent() {
        }

        public DeviceUsageAdherenceComponent(CodeableConcept code, CodeableConcept reason) {
            this.setCode(code);
            this.addReason(reason);
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceUsageAdherenceComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public DeviceUsageAdherenceComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<CodeableConcept> getReason() {
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            return this.reason;
        }

        public DeviceUsageAdherenceComponent setReason(List<CodeableConcept> theReason) {
            this.reason = theReason;
            return this;
        }

        public boolean hasReason() {
            if (this.reason == null) {
                return false;
            }
            for (CodeableConcept item : this.reason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return t;
        }

        public DeviceUsageAdherenceComponent addReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.reason == null) {
                this.reason = new ArrayList<CodeableConcept>();
            }
            this.reason.add(t);
            return this;
        }

        public CodeableConcept getReasonFirstRep() {
            if (this.getReason().isEmpty()) {
                this.addReason();
            }
            return this.getReason().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "Type of adherence.", 0, 1, this.code));
            children.add(new Property("reason", "CodeableConcept", "Reason for adherence type.", 0, Integer.MAX_VALUE, this.reason));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "Type of adherence.", 0, 1, this.code);
                }
                case -934964668: {
                    return new Property("reason", "CodeableConcept", "Reason for adherence type.", 0, Integer.MAX_VALUE, this.reason);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -934964668: {
                    return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -934964668: {
                    this.getReason().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reason")) {
                this.getReason().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -934964668: {
                    return this.addReason();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -934964668: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("reason")) {
                return this.addReason();
            }
            return super.addChild(name);
        }

        @Override
        public DeviceUsageAdherenceComponent copy() {
            DeviceUsageAdherenceComponent dst = new DeviceUsageAdherenceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceUsageAdherenceComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.reason != null) {
                dst.reason = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.reason) {
                    dst.reason.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceUsageAdherenceComponent)) {
                return false;
            }
            DeviceUsageAdherenceComponent o = (DeviceUsageAdherenceComponent)other_;
            return DeviceUsageAdherenceComponent.compareDeep(this.code, o.code, true) && DeviceUsageAdherenceComponent.compareDeep(this.reason, o.reason, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceUsageAdherenceComponent)) {
                return false;
            }
            DeviceUsageAdherenceComponent o = (DeviceUsageAdherenceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.reason);
        }

        @Override
        public String fhirType() {
            return "DeviceUsage.adherence";
        }
    }

    public static class DeviceUsageStatusEnumFactory
    implements EnumFactory<DeviceUsageStatus> {
        @Override
        public DeviceUsageStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return DeviceUsageStatus.ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return DeviceUsageStatus.COMPLETED;
            }
            if ("not-done".equals(codeString)) {
                return DeviceUsageStatus.NOTDONE;
            }
            if ("entered-in-error".equals(codeString)) {
                return DeviceUsageStatus.ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return DeviceUsageStatus.INTENDED;
            }
            if ("stopped".equals(codeString)) {
                return DeviceUsageStatus.STOPPED;
            }
            if ("on-hold".equals(codeString)) {
                return DeviceUsageStatus.ONHOLD;
            }
            throw new IllegalArgumentException("Unknown DeviceUsageStatus code '" + codeString + "'");
        }

        public Enumeration<DeviceUsageStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceUsageStatus>(this, DeviceUsageStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DeviceUsageStatus>(this, DeviceUsageStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<DeviceUsageStatus>(this, DeviceUsageStatus.ACTIVE, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<DeviceUsageStatus>(this, DeviceUsageStatus.COMPLETED, code);
            }
            if ("not-done".equals(codeString)) {
                return new Enumeration<DeviceUsageStatus>(this, DeviceUsageStatus.NOTDONE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DeviceUsageStatus>(this, DeviceUsageStatus.ENTEREDINERROR, code);
            }
            if ("intended".equals(codeString)) {
                return new Enumeration<DeviceUsageStatus>(this, DeviceUsageStatus.INTENDED, code);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<DeviceUsageStatus>(this, DeviceUsageStatus.STOPPED, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<DeviceUsageStatus>(this, DeviceUsageStatus.ONHOLD, code);
            }
            throw new FHIRException("Unknown DeviceUsageStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceUsageStatus code) {
            if (code == DeviceUsageStatus.ACTIVE) {
                return "active";
            }
            if (code == DeviceUsageStatus.COMPLETED) {
                return "completed";
            }
            if (code == DeviceUsageStatus.NOTDONE) {
                return "not-done";
            }
            if (code == DeviceUsageStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == DeviceUsageStatus.INTENDED) {
                return "intended";
            }
            if (code == DeviceUsageStatus.STOPPED) {
                return "stopped";
            }
            if (code == DeviceUsageStatus.ONHOLD) {
                return "on-hold";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceUsageStatus code) {
            return code.getSystem();
        }
    }

    public static enum DeviceUsageStatus {
        ACTIVE,
        COMPLETED,
        NOTDONE,
        ENTEREDINERROR,
        INTENDED,
        STOPPED,
        ONHOLD,
        NULL;


        public static DeviceUsageStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("not-done".equals(codeString)) {
                return NOTDONE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("intended".equals(codeString)) {
                return INTENDED;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceUsageStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case COMPLETED: {
                    return "completed";
                }
                case NOTDONE: {
                    return "not-done";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case INTENDED: {
                    return "intended";
                }
                case STOPPED: {
                    return "stopped";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/deviceusage-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/deviceusage-status";
                }
                case NOTDONE: {
                    return "http://hl7.org/fhir/deviceusage-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/deviceusage-status";
                }
                case INTENDED: {
                    return "http://hl7.org/fhir/deviceusage-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/deviceusage-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/deviceusage-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "The device is still being used.";
                }
                case COMPLETED: {
                    return "The device is no longer being used.";
                }
                case NOTDONE: {
                    return "The device was not used.";
                }
                case ENTEREDINERROR: {
                    return "The statement was recorded incorrectly.";
                }
                case INTENDED: {
                    return "The device may be used at some time in the future.";
                }
                case STOPPED: {
                    return "Actions implied by the statement have been permanently halted, before all of them occurred.";
                }
                case ONHOLD: {
                    return "Actions implied by the statement have been temporarily halted, but are expected to continue later. May also be called \"suspended\".";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case NOTDONE: {
                    return "Not done";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case INTENDED: {
                    return "Intended";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

