/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.ProductShelfLife;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DeviceDefinition", profile="http://hl7.org/fhir/StructureDefinition/DeviceDefinition")
public class DeviceDefinition
extends DomainResource {
    @Child(name="description", type={MarkdownType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Additional information to describe the device", formalDefinition="Additional information to describe the device.")
    protected MarkdownType description;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Instance identifier", formalDefinition="Unique instance identifiers assigned to a device by the software, manufacturers, other organizations or owners. For example: handle ID. The identifier is typically valued if the udiDeviceIdentifier, partNumber or modelNumber is not valued and represents a different type of identifier.  However, it is permissible to still include those identifiers in DeviceDefinition.identifier with the appropriate identifier.type.")
    protected List<Identifier> identifier;
    @Child(name="udiDeviceIdentifier", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Unique Device Identifier (UDI) Barcode string", formalDefinition="Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.")
    protected List<DeviceDefinitionUdiDeviceIdentifierComponent> udiDeviceIdentifier;
    @Child(name="regulatoryIdentifier", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Regulatory identifier(s) associated with this device", formalDefinition="Identifier associated with the regulatory documentation (certificates, technical documentation, post-market surveillance documentation and reports) of a set of device models sharing the same intended purpose, risk class and essential design and manufacturing characteristics. One example is the Basic UDI-DI in Europe.")
    protected List<DeviceDefinitionRegulatoryIdentifierComponent> regulatoryIdentifier;
    @Child(name="partNumber", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The part number or catalog number of the device", formalDefinition="The part number or catalog number of the device.")
    protected StringType partNumber;
    @Child(name="manufacturer", type={Organization.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of device manufacturer", formalDefinition="A name of the manufacturer  or legal representative e.g. labeler. Whether this is the actual manufacturer or the labeler or responsible depends on implementation and jurisdiction.")
    protected Reference manufacturer;
    @Child(name="deviceName", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The name or names of the device as given by the manufacturer", formalDefinition="The name or names of the device as given by the manufacturer.")
    protected List<DeviceDefinitionDeviceNameComponent> deviceName;
    @Child(name="modelNumber", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The catalog or model number for the device for example as defined by the manufacturer", formalDefinition="The model number for the device for example as defined by the manufacturer or labeler, or other agency.")
    protected StringType modelNumber;
    @Child(name="classification", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What kind of device or device system this is", formalDefinition="What kind of device or device system this is.")
    protected List<DeviceDefinitionClassificationComponent> classification;
    @Child(name="specialization", type={RelatedArtifact.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication", formalDefinition="The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication.")
    protected List<RelatedArtifact> specialization;
    @Child(name="hasPart", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A device, part of the current one", formalDefinition="A device that is part (for example a component) of the present device.")
    protected List<DeviceDefinitionHasPartComponent> hasPart;
    @Child(name="packaging", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Information about the packaging of the device, i.e. how the device is packaged", formalDefinition="Information about the packaging of the device, i.e. how the device is packaged.")
    protected List<DeviceDefinitionPackagingComponent> packaging;
    @Child(name="version", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The version of the device or software", formalDefinition="The version of the device or software.")
    protected List<DeviceDefinitionVersionComponent> version;
    @Child(name="safety", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Safety characteristics of the device", formalDefinition="Safety characteristics of the device.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-safety")
    protected List<CodeableConcept> safety;
    @Child(name="shelfLifeStorage", type={ProductShelfLife.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Shelf Life and storage information", formalDefinition="Shelf Life and storage information.")
    protected List<ProductShelfLife> shelfLifeStorage;
    @Child(name="languageCode", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Language code for the human-readable text strings produced by the device (all supported)", formalDefinition="Language code for the human-readable text strings produced by the device (all supported).")
    protected List<CodeableConcept> languageCode;
    @Child(name="property", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The potential, valid configuration settings of a device, e.g., regulation status, time properties", formalDefinition="The potential, valid configuration settings of a device, e.g., regulation status, time properties.")
    protected List<DeviceDefinitionPropertyComponent> property;
    @Child(name="owner", type={Organization.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Organization responsible for device", formalDefinition="An organization that is responsible for the provision and ongoing maintenance of the device.")
    protected Reference owner;
    @Child(name="contact", type={ContactPoint.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Details for human/organization for support", formalDefinition="Contact details for an organization or a particular human that is responsible for the device.")
    protected List<ContactPoint> contact;
    @Child(name="link", type={}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An associated device, attached to, used with, communicating with or linking a previous or new device model to the focal device", formalDefinition="An associated device, attached to, used with, communicating with or linking a previous or new device model to the focal device.")
    protected List<DeviceDefinitionLinkComponent> link;
    @Child(name="note", type={Annotation.class}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Device notes and comments", formalDefinition="Descriptive information, usage information or implantation information that is not captured in an existing element.")
    protected List<Annotation> note;
    @Child(name="parentDevice", type={DeviceDefinition.class}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The parent device it can be part of", formalDefinition="The parent device it can be part of.")
    protected Reference parentDevice;
    @Child(name="material", type={}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A substance used to create the material(s) of which the device is made", formalDefinition="A substance used to create the material(s) of which the device is made.")
    protected List<DeviceDefinitionMaterialComponent> material;
    @Child(name="productionIdentifierInUDI", type={CodeType.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="lot-number | manufactured-date | serial-number | expiration-date | biological-source | software-version", formalDefinition="Indicates the production identifier(s) that are expected to appear in the UDI carrier on the device label.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-productidentifierinudi")
    protected List<Enumeration<DeviceProductionIdentifierInUDI>> productionIdentifierInUDI;
    @Child(name="guideline", type={}, order=24, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Information aimed at providing directions for the usage of this model of device", formalDefinition="Information aimed at providing directions for the usage of this model of device.")
    protected DeviceDefinitionGuidelineComponent guideline;
    @Child(name="correctiveAction", type={}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Tracking of latest field safety corrective action", formalDefinition="Tracking of latest field safety corrective action.")
    protected DeviceDefinitionCorrectiveActionComponent correctiveAction;
    @Child(name="chargeItem", type={}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Billing code or reference associated with the device", formalDefinition="Billing code or reference associated with the device.")
    protected List<DeviceDefinitionChargeItemComponent> chargeItem;
    private static final long serialVersionUID = 1343213621L;
    @SearchParamDefinition(name="identifier", path="DeviceDefinition.identifier", description="The identifier of the component", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="parent", path="DeviceDefinition.parentDevice", description="The parent DeviceDefinition resource", type="reference", target={DeviceDefinition.class})
    public static final String SP_PARENT = "parent";
    public static final ReferenceClientParam PARENT = new ReferenceClientParam("parent");
    public static final Include INCLUDE_PARENT = new Include("DeviceDefinition:parent").toLocked();
    @SearchParamDefinition(name="type", path="DeviceDefinition.classification.type", description="The device component type", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public DeviceDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public DeviceDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DeviceDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<DeviceDefinitionUdiDeviceIdentifierComponent> getUdiDeviceIdentifier() {
        if (this.udiDeviceIdentifier == null) {
            this.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
        }
        return this.udiDeviceIdentifier;
    }

    public DeviceDefinition setUdiDeviceIdentifier(List<DeviceDefinitionUdiDeviceIdentifierComponent> theUdiDeviceIdentifier) {
        this.udiDeviceIdentifier = theUdiDeviceIdentifier;
        return this;
    }

    public boolean hasUdiDeviceIdentifier() {
        if (this.udiDeviceIdentifier == null) {
            return false;
        }
        for (DeviceDefinitionUdiDeviceIdentifierComponent item : this.udiDeviceIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionUdiDeviceIdentifierComponent addUdiDeviceIdentifier() {
        DeviceDefinitionUdiDeviceIdentifierComponent t = new DeviceDefinitionUdiDeviceIdentifierComponent();
        if (this.udiDeviceIdentifier == null) {
            this.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
        }
        this.udiDeviceIdentifier.add(t);
        return t;
    }

    public DeviceDefinition addUdiDeviceIdentifier(DeviceDefinitionUdiDeviceIdentifierComponent t) {
        if (t == null) {
            return this;
        }
        if (this.udiDeviceIdentifier == null) {
            this.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
        }
        this.udiDeviceIdentifier.add(t);
        return this;
    }

    public DeviceDefinitionUdiDeviceIdentifierComponent getUdiDeviceIdentifierFirstRep() {
        if (this.getUdiDeviceIdentifier().isEmpty()) {
            this.addUdiDeviceIdentifier();
        }
        return this.getUdiDeviceIdentifier().get(0);
    }

    public List<DeviceDefinitionRegulatoryIdentifierComponent> getRegulatoryIdentifier() {
        if (this.regulatoryIdentifier == null) {
            this.regulatoryIdentifier = new ArrayList<DeviceDefinitionRegulatoryIdentifierComponent>();
        }
        return this.regulatoryIdentifier;
    }

    public DeviceDefinition setRegulatoryIdentifier(List<DeviceDefinitionRegulatoryIdentifierComponent> theRegulatoryIdentifier) {
        this.regulatoryIdentifier = theRegulatoryIdentifier;
        return this;
    }

    public boolean hasRegulatoryIdentifier() {
        if (this.regulatoryIdentifier == null) {
            return false;
        }
        for (DeviceDefinitionRegulatoryIdentifierComponent item : this.regulatoryIdentifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionRegulatoryIdentifierComponent addRegulatoryIdentifier() {
        DeviceDefinitionRegulatoryIdentifierComponent t = new DeviceDefinitionRegulatoryIdentifierComponent();
        if (this.regulatoryIdentifier == null) {
            this.regulatoryIdentifier = new ArrayList<DeviceDefinitionRegulatoryIdentifierComponent>();
        }
        this.regulatoryIdentifier.add(t);
        return t;
    }

    public DeviceDefinition addRegulatoryIdentifier(DeviceDefinitionRegulatoryIdentifierComponent t) {
        if (t == null) {
            return this;
        }
        if (this.regulatoryIdentifier == null) {
            this.regulatoryIdentifier = new ArrayList<DeviceDefinitionRegulatoryIdentifierComponent>();
        }
        this.regulatoryIdentifier.add(t);
        return this;
    }

    public DeviceDefinitionRegulatoryIdentifierComponent getRegulatoryIdentifierFirstRep() {
        if (this.getRegulatoryIdentifier().isEmpty()) {
            this.addRegulatoryIdentifier();
        }
        return this.getRegulatoryIdentifier().get(0);
    }

    public StringType getPartNumberElement() {
        if (this.partNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.partNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.partNumber = new StringType();
            }
        }
        return this.partNumber;
    }

    public boolean hasPartNumberElement() {
        return this.partNumber != null && !this.partNumber.isEmpty();
    }

    public boolean hasPartNumber() {
        return this.partNumber != null && !this.partNumber.isEmpty();
    }

    public DeviceDefinition setPartNumberElement(StringType value) {
        this.partNumber = value;
        return this;
    }

    public String getPartNumber() {
        return this.partNumber == null ? null : (String)this.partNumber.getValue();
    }

    public DeviceDefinition setPartNumber(String value) {
        if (Utilities.noString(value)) {
            this.partNumber = null;
        } else {
            if (this.partNumber == null) {
                this.partNumber = new StringType();
            }
            this.partNumber.setValue(value);
        }
        return this;
    }

    public Reference getManufacturer() {
        if (this.manufacturer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.manufacturer");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturer = new Reference();
            }
        }
        return this.manufacturer;
    }

    public boolean hasManufacturer() {
        return this.manufacturer != null && !this.manufacturer.isEmpty();
    }

    public DeviceDefinition setManufacturer(Reference value) {
        this.manufacturer = value;
        return this;
    }

    public List<DeviceDefinitionDeviceNameComponent> getDeviceName() {
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDefinitionDeviceNameComponent>();
        }
        return this.deviceName;
    }

    public DeviceDefinition setDeviceName(List<DeviceDefinitionDeviceNameComponent> theDeviceName) {
        this.deviceName = theDeviceName;
        return this;
    }

    public boolean hasDeviceName() {
        if (this.deviceName == null) {
            return false;
        }
        for (DeviceDefinitionDeviceNameComponent item : this.deviceName) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionDeviceNameComponent addDeviceName() {
        DeviceDefinitionDeviceNameComponent t = new DeviceDefinitionDeviceNameComponent();
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDefinitionDeviceNameComponent>();
        }
        this.deviceName.add(t);
        return t;
    }

    public DeviceDefinition addDeviceName(DeviceDefinitionDeviceNameComponent t) {
        if (t == null) {
            return this;
        }
        if (this.deviceName == null) {
            this.deviceName = new ArrayList<DeviceDefinitionDeviceNameComponent>();
        }
        this.deviceName.add(t);
        return this;
    }

    public DeviceDefinitionDeviceNameComponent getDeviceNameFirstRep() {
        if (this.getDeviceName().isEmpty()) {
            this.addDeviceName();
        }
        return this.getDeviceName().get(0);
    }

    public StringType getModelNumberElement() {
        if (this.modelNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.modelNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.modelNumber = new StringType();
            }
        }
        return this.modelNumber;
    }

    public boolean hasModelNumberElement() {
        return this.modelNumber != null && !this.modelNumber.isEmpty();
    }

    public boolean hasModelNumber() {
        return this.modelNumber != null && !this.modelNumber.isEmpty();
    }

    public DeviceDefinition setModelNumberElement(StringType value) {
        this.modelNumber = value;
        return this;
    }

    public String getModelNumber() {
        return this.modelNumber == null ? null : (String)this.modelNumber.getValue();
    }

    public DeviceDefinition setModelNumber(String value) {
        if (Utilities.noString(value)) {
            this.modelNumber = null;
        } else {
            if (this.modelNumber == null) {
                this.modelNumber = new StringType();
            }
            this.modelNumber.setValue(value);
        }
        return this;
    }

    public List<DeviceDefinitionClassificationComponent> getClassification() {
        if (this.classification == null) {
            this.classification = new ArrayList<DeviceDefinitionClassificationComponent>();
        }
        return this.classification;
    }

    public DeviceDefinition setClassification(List<DeviceDefinitionClassificationComponent> theClassification) {
        this.classification = theClassification;
        return this;
    }

    public boolean hasClassification() {
        if (this.classification == null) {
            return false;
        }
        for (DeviceDefinitionClassificationComponent item : this.classification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionClassificationComponent addClassification() {
        DeviceDefinitionClassificationComponent t = new DeviceDefinitionClassificationComponent();
        if (this.classification == null) {
            this.classification = new ArrayList<DeviceDefinitionClassificationComponent>();
        }
        this.classification.add(t);
        return t;
    }

    public DeviceDefinition addClassification(DeviceDefinitionClassificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.classification == null) {
            this.classification = new ArrayList<DeviceDefinitionClassificationComponent>();
        }
        this.classification.add(t);
        return this;
    }

    public DeviceDefinitionClassificationComponent getClassificationFirstRep() {
        if (this.getClassification().isEmpty()) {
            this.addClassification();
        }
        return this.getClassification().get(0);
    }

    public List<RelatedArtifact> getSpecialization() {
        if (this.specialization == null) {
            this.specialization = new ArrayList<RelatedArtifact>();
        }
        return this.specialization;
    }

    public DeviceDefinition setSpecialization(List<RelatedArtifact> theSpecialization) {
        this.specialization = theSpecialization;
        return this;
    }

    public boolean hasSpecialization() {
        if (this.specialization == null) {
            return false;
        }
        for (RelatedArtifact item : this.specialization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addSpecialization() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.specialization == null) {
            this.specialization = new ArrayList<RelatedArtifact>();
        }
        this.specialization.add(t);
        return t;
    }

    public DeviceDefinition addSpecialization(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.specialization == null) {
            this.specialization = new ArrayList<RelatedArtifact>();
        }
        this.specialization.add(t);
        return this;
    }

    public RelatedArtifact getSpecializationFirstRep() {
        if (this.getSpecialization().isEmpty()) {
            this.addSpecialization();
        }
        return this.getSpecialization().get(0);
    }

    public List<DeviceDefinitionHasPartComponent> getHasPart() {
        if (this.hasPart == null) {
            this.hasPart = new ArrayList<DeviceDefinitionHasPartComponent>();
        }
        return this.hasPart;
    }

    public DeviceDefinition setHasPart(List<DeviceDefinitionHasPartComponent> theHasPart) {
        this.hasPart = theHasPart;
        return this;
    }

    public boolean hasHasPart() {
        if (this.hasPart == null) {
            return false;
        }
        for (DeviceDefinitionHasPartComponent item : this.hasPart) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionHasPartComponent addHasPart() {
        DeviceDefinitionHasPartComponent t = new DeviceDefinitionHasPartComponent();
        if (this.hasPart == null) {
            this.hasPart = new ArrayList<DeviceDefinitionHasPartComponent>();
        }
        this.hasPart.add(t);
        return t;
    }

    public DeviceDefinition addHasPart(DeviceDefinitionHasPartComponent t) {
        if (t == null) {
            return this;
        }
        if (this.hasPart == null) {
            this.hasPart = new ArrayList<DeviceDefinitionHasPartComponent>();
        }
        this.hasPart.add(t);
        return this;
    }

    public DeviceDefinitionHasPartComponent getHasPartFirstRep() {
        if (this.getHasPart().isEmpty()) {
            this.addHasPart();
        }
        return this.getHasPart().get(0);
    }

    public List<DeviceDefinitionPackagingComponent> getPackaging() {
        if (this.packaging == null) {
            this.packaging = new ArrayList<DeviceDefinitionPackagingComponent>();
        }
        return this.packaging;
    }

    public DeviceDefinition setPackaging(List<DeviceDefinitionPackagingComponent> thePackaging) {
        this.packaging = thePackaging;
        return this;
    }

    public boolean hasPackaging() {
        if (this.packaging == null) {
            return false;
        }
        for (DeviceDefinitionPackagingComponent item : this.packaging) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionPackagingComponent addPackaging() {
        DeviceDefinitionPackagingComponent t = new DeviceDefinitionPackagingComponent();
        if (this.packaging == null) {
            this.packaging = new ArrayList<DeviceDefinitionPackagingComponent>();
        }
        this.packaging.add(t);
        return t;
    }

    public DeviceDefinition addPackaging(DeviceDefinitionPackagingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.packaging == null) {
            this.packaging = new ArrayList<DeviceDefinitionPackagingComponent>();
        }
        this.packaging.add(t);
        return this;
    }

    public DeviceDefinitionPackagingComponent getPackagingFirstRep() {
        if (this.getPackaging().isEmpty()) {
            this.addPackaging();
        }
        return this.getPackaging().get(0);
    }

    public List<DeviceDefinitionVersionComponent> getVersion() {
        if (this.version == null) {
            this.version = new ArrayList<DeviceDefinitionVersionComponent>();
        }
        return this.version;
    }

    public DeviceDefinition setVersion(List<DeviceDefinitionVersionComponent> theVersion) {
        this.version = theVersion;
        return this;
    }

    public boolean hasVersion() {
        if (this.version == null) {
            return false;
        }
        for (DeviceDefinitionVersionComponent item : this.version) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionVersionComponent addVersion() {
        DeviceDefinitionVersionComponent t = new DeviceDefinitionVersionComponent();
        if (this.version == null) {
            this.version = new ArrayList<DeviceDefinitionVersionComponent>();
        }
        this.version.add(t);
        return t;
    }

    public DeviceDefinition addVersion(DeviceDefinitionVersionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.version == null) {
            this.version = new ArrayList<DeviceDefinitionVersionComponent>();
        }
        this.version.add(t);
        return this;
    }

    public DeviceDefinitionVersionComponent getVersionFirstRep() {
        if (this.getVersion().isEmpty()) {
            this.addVersion();
        }
        return this.getVersion().get(0);
    }

    public List<CodeableConcept> getSafety() {
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        return this.safety;
    }

    public DeviceDefinition setSafety(List<CodeableConcept> theSafety) {
        this.safety = theSafety;
        return this;
    }

    public boolean hasSafety() {
        if (this.safety == null) {
            return false;
        }
        for (CodeableConcept item : this.safety) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSafety() {
        CodeableConcept t = new CodeableConcept();
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        this.safety.add(t);
        return t;
    }

    public DeviceDefinition addSafety(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.safety == null) {
            this.safety = new ArrayList<CodeableConcept>();
        }
        this.safety.add(t);
        return this;
    }

    public CodeableConcept getSafetyFirstRep() {
        if (this.getSafety().isEmpty()) {
            this.addSafety();
        }
        return this.getSafety().get(0);
    }

    public List<ProductShelfLife> getShelfLifeStorage() {
        if (this.shelfLifeStorage == null) {
            this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
        }
        return this.shelfLifeStorage;
    }

    public DeviceDefinition setShelfLifeStorage(List<ProductShelfLife> theShelfLifeStorage) {
        this.shelfLifeStorage = theShelfLifeStorage;
        return this;
    }

    public boolean hasShelfLifeStorage() {
        if (this.shelfLifeStorage == null) {
            return false;
        }
        for (ProductShelfLife item : this.shelfLifeStorage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ProductShelfLife addShelfLifeStorage() {
        ProductShelfLife t = new ProductShelfLife();
        if (this.shelfLifeStorage == null) {
            this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
        }
        this.shelfLifeStorage.add(t);
        return t;
    }

    public DeviceDefinition addShelfLifeStorage(ProductShelfLife t) {
        if (t == null) {
            return this;
        }
        if (this.shelfLifeStorage == null) {
            this.shelfLifeStorage = new ArrayList<ProductShelfLife>();
        }
        this.shelfLifeStorage.add(t);
        return this;
    }

    public ProductShelfLife getShelfLifeStorageFirstRep() {
        if (this.getShelfLifeStorage().isEmpty()) {
            this.addShelfLifeStorage();
        }
        return this.getShelfLifeStorage().get(0);
    }

    public List<CodeableConcept> getLanguageCode() {
        if (this.languageCode == null) {
            this.languageCode = new ArrayList<CodeableConcept>();
        }
        return this.languageCode;
    }

    public DeviceDefinition setLanguageCode(List<CodeableConcept> theLanguageCode) {
        this.languageCode = theLanguageCode;
        return this;
    }

    public boolean hasLanguageCode() {
        if (this.languageCode == null) {
            return false;
        }
        for (CodeableConcept item : this.languageCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addLanguageCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.languageCode == null) {
            this.languageCode = new ArrayList<CodeableConcept>();
        }
        this.languageCode.add(t);
        return t;
    }

    public DeviceDefinition addLanguageCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.languageCode == null) {
            this.languageCode = new ArrayList<CodeableConcept>();
        }
        this.languageCode.add(t);
        return this;
    }

    public CodeableConcept getLanguageCodeFirstRep() {
        if (this.getLanguageCode().isEmpty()) {
            this.addLanguageCode();
        }
        return this.getLanguageCode().get(0);
    }

    public List<DeviceDefinitionPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<DeviceDefinitionPropertyComponent>();
        }
        return this.property;
    }

    public DeviceDefinition setProperty(List<DeviceDefinitionPropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (DeviceDefinitionPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionPropertyComponent addProperty() {
        DeviceDefinitionPropertyComponent t = new DeviceDefinitionPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<DeviceDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public DeviceDefinition addProperty(DeviceDefinitionPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<DeviceDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public DeviceDefinitionPropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public DeviceDefinition setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public DeviceDefinition setContact(List<ContactPoint> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public DeviceDefinition addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactPoint getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<DeviceDefinitionLinkComponent> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<DeviceDefinitionLinkComponent>();
        }
        return this.link;
    }

    public DeviceDefinition setLink(List<DeviceDefinitionLinkComponent> theLink) {
        this.link = theLink;
        return this;
    }

    public boolean hasLink() {
        if (this.link == null) {
            return false;
        }
        for (DeviceDefinitionLinkComponent item : this.link) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionLinkComponent addLink() {
        DeviceDefinitionLinkComponent t = new DeviceDefinitionLinkComponent();
        if (this.link == null) {
            this.link = new ArrayList<DeviceDefinitionLinkComponent>();
        }
        this.link.add(t);
        return t;
    }

    public DeviceDefinition addLink(DeviceDefinitionLinkComponent t) {
        if (t == null) {
            return this;
        }
        if (this.link == null) {
            this.link = new ArrayList<DeviceDefinitionLinkComponent>();
        }
        this.link.add(t);
        return this;
    }

    public DeviceDefinitionLinkComponent getLinkFirstRep() {
        if (this.getLink().isEmpty()) {
            this.addLink();
        }
        return this.getLink().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public DeviceDefinition setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public DeviceDefinition addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public Reference getParentDevice() {
        if (this.parentDevice == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.parentDevice");
            }
            if (Configuration.doAutoCreate()) {
                this.parentDevice = new Reference();
            }
        }
        return this.parentDevice;
    }

    public boolean hasParentDevice() {
        return this.parentDevice != null && !this.parentDevice.isEmpty();
    }

    public DeviceDefinition setParentDevice(Reference value) {
        this.parentDevice = value;
        return this;
    }

    public List<DeviceDefinitionMaterialComponent> getMaterial() {
        if (this.material == null) {
            this.material = new ArrayList<DeviceDefinitionMaterialComponent>();
        }
        return this.material;
    }

    public DeviceDefinition setMaterial(List<DeviceDefinitionMaterialComponent> theMaterial) {
        this.material = theMaterial;
        return this;
    }

    public boolean hasMaterial() {
        if (this.material == null) {
            return false;
        }
        for (DeviceDefinitionMaterialComponent item : this.material) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionMaterialComponent addMaterial() {
        DeviceDefinitionMaterialComponent t = new DeviceDefinitionMaterialComponent();
        if (this.material == null) {
            this.material = new ArrayList<DeviceDefinitionMaterialComponent>();
        }
        this.material.add(t);
        return t;
    }

    public DeviceDefinition addMaterial(DeviceDefinitionMaterialComponent t) {
        if (t == null) {
            return this;
        }
        if (this.material == null) {
            this.material = new ArrayList<DeviceDefinitionMaterialComponent>();
        }
        this.material.add(t);
        return this;
    }

    public DeviceDefinitionMaterialComponent getMaterialFirstRep() {
        if (this.getMaterial().isEmpty()) {
            this.addMaterial();
        }
        return this.getMaterial().get(0);
    }

    public List<Enumeration<DeviceProductionIdentifierInUDI>> getProductionIdentifierInUDI() {
        if (this.productionIdentifierInUDI == null) {
            this.productionIdentifierInUDI = new ArrayList<Enumeration<DeviceProductionIdentifierInUDI>>();
        }
        return this.productionIdentifierInUDI;
    }

    public DeviceDefinition setProductionIdentifierInUDI(List<Enumeration<DeviceProductionIdentifierInUDI>> theProductionIdentifierInUDI) {
        this.productionIdentifierInUDI = theProductionIdentifierInUDI;
        return this;
    }

    public boolean hasProductionIdentifierInUDI() {
        if (this.productionIdentifierInUDI == null) {
            return false;
        }
        for (Enumeration<DeviceProductionIdentifierInUDI> item : this.productionIdentifierInUDI) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<DeviceProductionIdentifierInUDI> addProductionIdentifierInUDIElement() {
        Enumeration<DeviceProductionIdentifierInUDI> t = new Enumeration<DeviceProductionIdentifierInUDI>(new DeviceProductionIdentifierInUDIEnumFactory());
        if (this.productionIdentifierInUDI == null) {
            this.productionIdentifierInUDI = new ArrayList<Enumeration<DeviceProductionIdentifierInUDI>>();
        }
        this.productionIdentifierInUDI.add(t);
        return t;
    }

    public DeviceDefinition addProductionIdentifierInUDI(DeviceProductionIdentifierInUDI value) {
        Enumeration<DeviceProductionIdentifierInUDI> t = new Enumeration<DeviceProductionIdentifierInUDI>(new DeviceProductionIdentifierInUDIEnumFactory());
        t.setValue((Object)value);
        if (this.productionIdentifierInUDI == null) {
            this.productionIdentifierInUDI = new ArrayList<Enumeration<DeviceProductionIdentifierInUDI>>();
        }
        this.productionIdentifierInUDI.add(t);
        return this;
    }

    public boolean hasProductionIdentifierInUDI(DeviceProductionIdentifierInUDI value) {
        if (this.productionIdentifierInUDI == null) {
            return false;
        }
        for (Enumeration<DeviceProductionIdentifierInUDI> v : this.productionIdentifierInUDI) {
            if (!((DeviceProductionIdentifierInUDI)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionGuidelineComponent getGuideline() {
        if (this.guideline == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.guideline");
            }
            if (Configuration.doAutoCreate()) {
                this.guideline = new DeviceDefinitionGuidelineComponent();
            }
        }
        return this.guideline;
    }

    public boolean hasGuideline() {
        return this.guideline != null && !this.guideline.isEmpty();
    }

    public DeviceDefinition setGuideline(DeviceDefinitionGuidelineComponent value) {
        this.guideline = value;
        return this;
    }

    public DeviceDefinitionCorrectiveActionComponent getCorrectiveAction() {
        if (this.correctiveAction == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceDefinition.correctiveAction");
            }
            if (Configuration.doAutoCreate()) {
                this.correctiveAction = new DeviceDefinitionCorrectiveActionComponent();
            }
        }
        return this.correctiveAction;
    }

    public boolean hasCorrectiveAction() {
        return this.correctiveAction != null && !this.correctiveAction.isEmpty();
    }

    public DeviceDefinition setCorrectiveAction(DeviceDefinitionCorrectiveActionComponent value) {
        this.correctiveAction = value;
        return this;
    }

    public List<DeviceDefinitionChargeItemComponent> getChargeItem() {
        if (this.chargeItem == null) {
            this.chargeItem = new ArrayList<DeviceDefinitionChargeItemComponent>();
        }
        return this.chargeItem;
    }

    public DeviceDefinition setChargeItem(List<DeviceDefinitionChargeItemComponent> theChargeItem) {
        this.chargeItem = theChargeItem;
        return this;
    }

    public boolean hasChargeItem() {
        if (this.chargeItem == null) {
            return false;
        }
        for (DeviceDefinitionChargeItemComponent item : this.chargeItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DeviceDefinitionChargeItemComponent addChargeItem() {
        DeviceDefinitionChargeItemComponent t = new DeviceDefinitionChargeItemComponent();
        if (this.chargeItem == null) {
            this.chargeItem = new ArrayList<DeviceDefinitionChargeItemComponent>();
        }
        this.chargeItem.add(t);
        return t;
    }

    public DeviceDefinition addChargeItem(DeviceDefinitionChargeItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.chargeItem == null) {
            this.chargeItem = new ArrayList<DeviceDefinitionChargeItemComponent>();
        }
        this.chargeItem.add(t);
        return this;
    }

    public DeviceDefinitionChargeItemComponent getChargeItemFirstRep() {
        if (this.getChargeItem().isEmpty()) {
            this.addChargeItem();
        }
        return this.getChargeItem().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("description", "markdown", "Additional information to describe the device.", 0, 1, this.description));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by the software, manufacturers, other organizations or owners. For example: handle ID. The identifier is typically valued if the udiDeviceIdentifier, partNumber or modelNumber is not valued and represents a different type of identifier.  However, it is permissible to still include those identifiers in DeviceDefinition.identifier with the appropriate identifier.type.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("udiDeviceIdentifier", "", "Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.", 0, Integer.MAX_VALUE, this.udiDeviceIdentifier));
        children.add(new Property("regulatoryIdentifier", "", "Identifier associated with the regulatory documentation (certificates, technical documentation, post-market surveillance documentation and reports) of a set of device models sharing the same intended purpose, risk class and essential design and manufacturing characteristics. One example is the Basic UDI-DI in Europe.", 0, Integer.MAX_VALUE, this.regulatoryIdentifier));
        children.add(new Property("partNumber", "string", "The part number or catalog number of the device.", 0, 1, this.partNumber));
        children.add(new Property("manufacturer", "Reference(Organization)", "A name of the manufacturer  or legal representative e.g. labeler. Whether this is the actual manufacturer or the labeler or responsible depends on implementation and jurisdiction.", 0, 1, this.manufacturer));
        children.add(new Property("deviceName", "", "The name or names of the device as given by the manufacturer.", 0, Integer.MAX_VALUE, this.deviceName));
        children.add(new Property("modelNumber", "string", "The model number for the device for example as defined by the manufacturer or labeler, or other agency.", 0, 1, this.modelNumber));
        children.add(new Property("classification", "", "What kind of device or device system this is.", 0, Integer.MAX_VALUE, this.classification));
        children.add(new Property("specialization", "RelatedArtifact", "The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication.", 0, Integer.MAX_VALUE, this.specialization));
        children.add(new Property("hasPart", "", "A device that is part (for example a component) of the present device.", 0, Integer.MAX_VALUE, this.hasPart));
        children.add(new Property("packaging", "", "Information about the packaging of the device, i.e. how the device is packaged.", 0, Integer.MAX_VALUE, this.packaging));
        children.add(new Property("version", "", "The version of the device or software.", 0, Integer.MAX_VALUE, this.version));
        children.add(new Property("safety", "CodeableConcept", "Safety characteristics of the device.", 0, Integer.MAX_VALUE, this.safety));
        children.add(new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage));
        children.add(new Property("languageCode", "CodeableConcept", "Language code for the human-readable text strings produced by the device (all supported).", 0, Integer.MAX_VALUE, this.languageCode));
        children.add(new Property("property", "", "The potential, valid configuration settings of a device, e.g., regulation status, time properties.", 0, Integer.MAX_VALUE, this.property));
        children.add(new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, 1, this.owner));
        children.add(new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("link", "", "An associated device, attached to, used with, communicating with or linking a previous or new device model to the focal device.", 0, Integer.MAX_VALUE, this.link));
        children.add(new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("parentDevice", "Reference(DeviceDefinition)", "The parent device it can be part of.", 0, 1, this.parentDevice));
        children.add(new Property("material", "", "A substance used to create the material(s) of which the device is made.", 0, Integer.MAX_VALUE, this.material));
        children.add(new Property("productionIdentifierInUDI", "code", "Indicates the production identifier(s) that are expected to appear in the UDI carrier on the device label.", 0, Integer.MAX_VALUE, this.productionIdentifierInUDI));
        children.add(new Property("guideline", "", "Information aimed at providing directions for the usage of this model of device.", 0, 1, this.guideline));
        children.add(new Property("correctiveAction", "", "Tracking of latest field safety corrective action.", 0, 1, this.correctiveAction));
        children.add(new Property("chargeItem", "", "Billing code or reference associated with the device.", 0, Integer.MAX_VALUE, this.chargeItem));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1724546052: {
                return new Property("description", "markdown", "Additional information to describe the device.", 0, 1, this.description);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a device by the software, manufacturers, other organizations or owners. For example: handle ID. The identifier is typically valued if the udiDeviceIdentifier, partNumber or modelNumber is not valued and represents a different type of identifier.  However, it is permissible to still include those identifiers in DeviceDefinition.identifier with the appropriate identifier.type.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -99121287: {
                return new Property("udiDeviceIdentifier", "", "Unique device identifier (UDI) assigned to device label or package.  Note that the Device may include multiple udiCarriers as it either may include just the udiCarrier for the jurisdiction it is sold, or for multiple jurisdictions it could have been sold.", 0, Integer.MAX_VALUE, this.udiDeviceIdentifier);
            }
            case 455683425: {
                return new Property("regulatoryIdentifier", "", "Identifier associated with the regulatory documentation (certificates, technical documentation, post-market surveillance documentation and reports) of a set of device models sharing the same intended purpose, risk class and essential design and manufacturing characteristics. One example is the Basic UDI-DI in Europe.", 0, Integer.MAX_VALUE, this.regulatoryIdentifier);
            }
            case -731502308: {
                return new Property("partNumber", "string", "The part number or catalog number of the device.", 0, 1, this.partNumber);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "A name of the manufacturer  or legal representative e.g. labeler. Whether this is the actual manufacturer or the labeler or responsible depends on implementation and jurisdiction.", 0, 1, this.manufacturer);
            }
            case 780988929: {
                return new Property("deviceName", "", "The name or names of the device as given by the manufacturer.", 0, Integer.MAX_VALUE, this.deviceName);
            }
            case 346619858: {
                return new Property("modelNumber", "string", "The model number for the device for example as defined by the manufacturer or labeler, or other agency.", 0, 1, this.modelNumber);
            }
            case 382350310: {
                return new Property("classification", "", "What kind of device or device system this is.", 0, Integer.MAX_VALUE, this.classification);
            }
            case 682815883: {
                return new Property("specialization", "RelatedArtifact", "The capabilities supported on a  device, the standards to which the device conforms for a particular purpose, and used for the communication.", 0, Integer.MAX_VALUE, this.specialization);
            }
            case 696815021: {
                return new Property("hasPart", "", "A device that is part (for example a component) of the present device.", 0, Integer.MAX_VALUE, this.hasPart);
            }
            case 1802065795: {
                return new Property("packaging", "", "Information about the packaging of the device, i.e. how the device is packaged.", 0, Integer.MAX_VALUE, this.packaging);
            }
            case 351608024: {
                return new Property("version", "", "The version of the device or software.", 0, Integer.MAX_VALUE, this.version);
            }
            case -909893934: {
                return new Property("safety", "CodeableConcept", "Safety characteristics of the device.", 0, Integer.MAX_VALUE, this.safety);
            }
            case 172049237: {
                return new Property("shelfLifeStorage", "ProductShelfLife", "Shelf Life and storage information.", 0, Integer.MAX_VALUE, this.shelfLifeStorage);
            }
            case -2092349083: {
                return new Property("languageCode", "CodeableConcept", "Language code for the human-readable text strings produced by the device (all supported).", 0, Integer.MAX_VALUE, this.languageCode);
            }
            case -993141291: {
                return new Property("property", "", "The potential, valid configuration settings of a device, e.g., regulation status, time properties.", 0, Integer.MAX_VALUE, this.property);
            }
            case 106164915: {
                return new Property("owner", "Reference(Organization)", "An organization that is responsible for the provision and ongoing maintenance of the device.", 0, 1, this.owner);
            }
            case 951526432: {
                return new Property("contact", "ContactPoint", "Contact details for an organization or a particular human that is responsible for the device.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 3321850: {
                return new Property("link", "", "An associated device, attached to, used with, communicating with or linking a previous or new device model to the focal device.", 0, Integer.MAX_VALUE, this.link);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Descriptive information, usage information or implantation information that is not captured in an existing element.", 0, Integer.MAX_VALUE, this.note);
            }
            case 620260256: {
                return new Property("parentDevice", "Reference(DeviceDefinition)", "The parent device it can be part of.", 0, 1, this.parentDevice);
            }
            case 299066663: {
                return new Property("material", "", "A substance used to create the material(s) of which the device is made.", 0, Integer.MAX_VALUE, this.material);
            }
            case 312405811: {
                return new Property("productionIdentifierInUDI", "code", "Indicates the production identifier(s) that are expected to appear in the UDI carrier on the device label.", 0, Integer.MAX_VALUE, this.productionIdentifierInUDI);
            }
            case -2075718416: {
                return new Property("guideline", "", "Information aimed at providing directions for the usage of this model of device.", 0, 1, this.guideline);
            }
            case 1354575876: {
                return new Property("correctiveAction", "", "Tracking of latest field safety corrective action.", 0, 1, this.correctiveAction);
            }
            case 1417779175: {
                return new Property("chargeItem", "", "Billing code or reference associated with the device.", 0, Integer.MAX_VALUE, this.chargeItem);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.description;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -99121287: {
                return this.udiDeviceIdentifier == null ? new Base[]{} : this.udiDeviceIdentifier.toArray(new Base[this.udiDeviceIdentifier.size()]);
            }
            case 455683425: {
                return this.regulatoryIdentifier == null ? new Base[]{} : this.regulatoryIdentifier.toArray(new Base[this.regulatoryIdentifier.size()]);
            }
            case -731502308: {
                Base[] baseArray;
                if (this.partNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.partNumber;
                }
                return baseArray;
            }
            case -1969347631: {
                Base[] baseArray;
                if (this.manufacturer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.manufacturer;
                }
                return baseArray;
            }
            case 780988929: {
                return this.deviceName == null ? new Base[]{} : this.deviceName.toArray(new Base[this.deviceName.size()]);
            }
            case 346619858: {
                Base[] baseArray;
                if (this.modelNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.modelNumber;
                }
                return baseArray;
            }
            case 382350310: {
                return this.classification == null ? new Base[]{} : this.classification.toArray(new Base[this.classification.size()]);
            }
            case 682815883: {
                return this.specialization == null ? new Base[]{} : this.specialization.toArray(new Base[this.specialization.size()]);
            }
            case 696815021: {
                return this.hasPart == null ? new Base[]{} : this.hasPart.toArray(new Base[this.hasPart.size()]);
            }
            case 1802065795: {
                return this.packaging == null ? new Base[]{} : this.packaging.toArray(new Base[this.packaging.size()]);
            }
            case 351608024: {
                return this.version == null ? new Base[]{} : this.version.toArray(new Base[this.version.size()]);
            }
            case -909893934: {
                return this.safety == null ? new Base[]{} : this.safety.toArray(new Base[this.safety.size()]);
            }
            case 172049237: {
                return this.shelfLifeStorage == null ? new Base[]{} : this.shelfLifeStorage.toArray(new Base[this.shelfLifeStorage.size()]);
            }
            case -2092349083: {
                return this.languageCode == null ? new Base[]{} : this.languageCode.toArray(new Base[this.languageCode.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
            case 106164915: {
                Base[] baseArray;
                if (this.owner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.owner;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 3321850: {
                return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 620260256: {
                Base[] baseArray;
                if (this.parentDevice == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.parentDevice;
                }
                return baseArray;
            }
            case 299066663: {
                return this.material == null ? new Base[]{} : this.material.toArray(new Base[this.material.size()]);
            }
            case 312405811: {
                return this.productionIdentifierInUDI == null ? new Base[]{} : this.productionIdentifierInUDI.toArray(new Base[this.productionIdentifierInUDI.size()]);
            }
            case -2075718416: {
                Base[] baseArray;
                if (this.guideline == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.guideline;
                }
                return baseArray;
            }
            case 1354575876: {
                Base[] baseArray;
                if (this.correctiveAction == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.correctiveAction;
                }
                return baseArray;
            }
            case 1417779175: {
                return this.chargeItem == null ? new Base[]{} : this.chargeItem.toArray(new Base[this.chargeItem.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -99121287: {
                this.getUdiDeviceIdentifier().add((DeviceDefinitionUdiDeviceIdentifierComponent)((Object)value));
                return value;
            }
            case 455683425: {
                this.getRegulatoryIdentifier().add((DeviceDefinitionRegulatoryIdentifierComponent)((Object)value));
                return value;
            }
            case -731502308: {
                this.partNumber = TypeConvertor.castToString(value);
                return value;
            }
            case -1969347631: {
                this.manufacturer = TypeConvertor.castToReference(value);
                return value;
            }
            case 780988929: {
                this.getDeviceName().add((DeviceDefinitionDeviceNameComponent)((Object)value));
                return value;
            }
            case 346619858: {
                this.modelNumber = TypeConvertor.castToString(value);
                return value;
            }
            case 382350310: {
                this.getClassification().add((DeviceDefinitionClassificationComponent)((Object)value));
                return value;
            }
            case 682815883: {
                this.getSpecialization().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case 696815021: {
                this.getHasPart().add((DeviceDefinitionHasPartComponent)((Object)value));
                return value;
            }
            case 1802065795: {
                this.getPackaging().add((DeviceDefinitionPackagingComponent)((Object)value));
                return value;
            }
            case 351608024: {
                this.getVersion().add((DeviceDefinitionVersionComponent)((Object)value));
                return value;
            }
            case -909893934: {
                this.getSafety().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 172049237: {
                this.getShelfLifeStorage().add(TypeConvertor.castToProductShelfLife(value));
                return value;
            }
            case -2092349083: {
                this.getLanguageCode().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -993141291: {
                this.getProperty().add((DeviceDefinitionPropertyComponent)((Object)value));
                return value;
            }
            case 106164915: {
                this.owner = TypeConvertor.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactPoint(value));
                return value;
            }
            case 3321850: {
                this.getLink().add((DeviceDefinitionLinkComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 620260256: {
                this.parentDevice = TypeConvertor.castToReference(value);
                return value;
            }
            case 299066663: {
                this.getMaterial().add((DeviceDefinitionMaterialComponent)((Object)value));
                return value;
            }
            case 312405811: {
                value = new DeviceProductionIdentifierInUDIEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getProductionIdentifierInUDI().add(value);
                return value;
            }
            case -2075718416: {
                this.guideline = (DeviceDefinitionGuidelineComponent)((Object)value);
                return value;
            }
            case 1354575876: {
                this.correctiveAction = (DeviceDefinitionCorrectiveActionComponent)((Object)value);
                return value;
            }
            case 1417779175: {
                this.getChargeItem().add((DeviceDefinitionChargeItemComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("udiDeviceIdentifier")) {
            this.getUdiDeviceIdentifier().add((DeviceDefinitionUdiDeviceIdentifierComponent)((Object)value));
        } else if (name.equals("regulatoryIdentifier")) {
            this.getRegulatoryIdentifier().add((DeviceDefinitionRegulatoryIdentifierComponent)((Object)value));
        } else if (name.equals("partNumber")) {
            this.partNumber = TypeConvertor.castToString(value);
        } else if (name.equals("manufacturer")) {
            this.manufacturer = TypeConvertor.castToReference(value);
        } else if (name.equals("deviceName")) {
            this.getDeviceName().add((DeviceDefinitionDeviceNameComponent)((Object)value));
        } else if (name.equals("modelNumber")) {
            this.modelNumber = TypeConvertor.castToString(value);
        } else if (name.equals("classification")) {
            this.getClassification().add((DeviceDefinitionClassificationComponent)((Object)value));
        } else if (name.equals("specialization")) {
            this.getSpecialization().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals("hasPart")) {
            this.getHasPart().add((DeviceDefinitionHasPartComponent)((Object)value));
        } else if (name.equals("packaging")) {
            this.getPackaging().add((DeviceDefinitionPackagingComponent)((Object)value));
        } else if (name.equals("version")) {
            this.getVersion().add((DeviceDefinitionVersionComponent)((Object)value));
        } else if (name.equals("safety")) {
            this.getSafety().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("shelfLifeStorage")) {
            this.getShelfLifeStorage().add(TypeConvertor.castToProductShelfLife(value));
        } else if (name.equals("languageCode")) {
            this.getLanguageCode().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("property")) {
            this.getProperty().add((DeviceDefinitionPropertyComponent)((Object)value));
        } else if (name.equals("owner")) {
            this.owner = TypeConvertor.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactPoint(value));
        } else if (name.equals("link")) {
            this.getLink().add((DeviceDefinitionLinkComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("parentDevice")) {
            this.parentDevice = TypeConvertor.castToReference(value);
        } else if (name.equals("material")) {
            this.getMaterial().add((DeviceDefinitionMaterialComponent)((Object)value));
        } else if (name.equals("productionIdentifierInUDI")) {
            value = new DeviceProductionIdentifierInUDIEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.getProductionIdentifierInUDI().add(value);
        } else if (name.equals("guideline")) {
            this.guideline = (DeviceDefinitionGuidelineComponent)((Object)value);
        } else if (name.equals("correctiveAction")) {
            this.correctiveAction = (DeviceDefinitionCorrectiveActionComponent)((Object)value);
        } else if (name.equals("chargeItem")) {
            this.getChargeItem().add((DeviceDefinitionChargeItemComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case -99121287: {
                return this.addUdiDeviceIdentifier();
            }
            case 455683425: {
                return this.addRegulatoryIdentifier();
            }
            case -731502308: {
                return this.getPartNumberElement();
            }
            case -1969347631: {
                return this.getManufacturer();
            }
            case 780988929: {
                return this.addDeviceName();
            }
            case 346619858: {
                return this.getModelNumberElement();
            }
            case 382350310: {
                return this.addClassification();
            }
            case 682815883: {
                return this.addSpecialization();
            }
            case 696815021: {
                return this.addHasPart();
            }
            case 1802065795: {
                return this.addPackaging();
            }
            case 351608024: {
                return this.addVersion();
            }
            case -909893934: {
                return this.addSafety();
            }
            case 172049237: {
                return this.addShelfLifeStorage();
            }
            case -2092349083: {
                return this.addLanguageCode();
            }
            case -993141291: {
                return this.addProperty();
            }
            case 106164915: {
                return this.getOwner();
            }
            case 951526432: {
                return this.addContact();
            }
            case 3321850: {
                return this.addLink();
            }
            case 3387378: {
                return this.addNote();
            }
            case 620260256: {
                return this.getParentDevice();
            }
            case 299066663: {
                return this.addMaterial();
            }
            case 312405811: {
                return this.addProductionIdentifierInUDIElement();
            }
            case -2075718416: {
                return this.getGuideline();
            }
            case 1354575876: {
                return this.getCorrectiveAction();
            }
            case 1417779175: {
                return this.addChargeItem();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -99121287: {
                return new String[0];
            }
            case 455683425: {
                return new String[0];
            }
            case -731502308: {
                return new String[]{"string"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case 780988929: {
                return new String[0];
            }
            case 346619858: {
                return new String[]{"string"};
            }
            case 382350310: {
                return new String[0];
            }
            case 682815883: {
                return new String[]{"RelatedArtifact"};
            }
            case 696815021: {
                return new String[0];
            }
            case 1802065795: {
                return new String[0];
            }
            case 351608024: {
                return new String[0];
            }
            case -909893934: {
                return new String[]{"CodeableConcept"};
            }
            case 172049237: {
                return new String[]{"ProductShelfLife"};
            }
            case -2092349083: {
                return new String[]{"CodeableConcept"};
            }
            case -993141291: {
                return new String[0];
            }
            case 106164915: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactPoint"};
            }
            case 3321850: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 620260256: {
                return new String[]{"Reference"};
            }
            case 299066663: {
                return new String[0];
            }
            case 312405811: {
                return new String[]{"code"};
            }
            case -2075718416: {
                return new String[0];
            }
            case 1354575876: {
                return new String[0];
            }
            case 1417779175: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.description");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("udiDeviceIdentifier")) {
            return this.addUdiDeviceIdentifier();
        }
        if (name.equals("regulatoryIdentifier")) {
            return this.addRegulatoryIdentifier();
        }
        if (name.equals("partNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.partNumber");
        }
        if (name.equals("manufacturer")) {
            this.manufacturer = new Reference();
            return this.manufacturer;
        }
        if (name.equals("deviceName")) {
            return this.addDeviceName();
        }
        if (name.equals("modelNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.modelNumber");
        }
        if (name.equals("classification")) {
            return this.addClassification();
        }
        if (name.equals("specialization")) {
            return this.addSpecialization();
        }
        if (name.equals("hasPart")) {
            return this.addHasPart();
        }
        if (name.equals("packaging")) {
            return this.addPackaging();
        }
        if (name.equals("version")) {
            return this.addVersion();
        }
        if (name.equals("safety")) {
            return this.addSafety();
        }
        if (name.equals("shelfLifeStorage")) {
            return this.addShelfLifeStorage();
        }
        if (name.equals("languageCode")) {
            return this.addLanguageCode();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        if (name.equals("owner")) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("link")) {
            return this.addLink();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("parentDevice")) {
            this.parentDevice = new Reference();
            return this.parentDevice;
        }
        if (name.equals("material")) {
            return this.addMaterial();
        }
        if (name.equals("productionIdentifierInUDI")) {
            throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.productionIdentifierInUDI");
        }
        if (name.equals("guideline")) {
            this.guideline = new DeviceDefinitionGuidelineComponent();
            return this.guideline;
        }
        if (name.equals("correctiveAction")) {
            this.correctiveAction = new DeviceDefinitionCorrectiveActionComponent();
            return this.correctiveAction;
        }
        if (name.equals("chargeItem")) {
            return this.addChargeItem();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceDefinition";
    }

    @Override
    public DeviceDefinition copy() {
        DeviceDefinition dst = new DeviceDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DeviceDefinition dst) {
        super.copyValues(dst);
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.udiDeviceIdentifier != null) {
            dst.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
            for (DeviceDefinitionUdiDeviceIdentifierComponent deviceDefinitionUdiDeviceIdentifierComponent : this.udiDeviceIdentifier) {
                dst.udiDeviceIdentifier.add(deviceDefinitionUdiDeviceIdentifierComponent.copy());
            }
        }
        if (this.regulatoryIdentifier != null) {
            dst.regulatoryIdentifier = new ArrayList<DeviceDefinitionRegulatoryIdentifierComponent>();
            for (DeviceDefinitionRegulatoryIdentifierComponent deviceDefinitionRegulatoryIdentifierComponent : this.regulatoryIdentifier) {
                dst.regulatoryIdentifier.add(deviceDefinitionRegulatoryIdentifierComponent.copy());
            }
        }
        dst.partNumber = this.partNumber == null ? null : this.partNumber.copy();
        Reference reference = dst.manufacturer = this.manufacturer == null ? null : this.manufacturer.copy();
        if (this.deviceName != null) {
            dst.deviceName = new ArrayList<DeviceDefinitionDeviceNameComponent>();
            for (DeviceDefinitionDeviceNameComponent deviceDefinitionDeviceNameComponent : this.deviceName) {
                dst.deviceName.add(deviceDefinitionDeviceNameComponent.copy());
            }
        }
        StringType stringType = dst.modelNumber = this.modelNumber == null ? null : this.modelNumber.copy();
        if (this.classification != null) {
            dst.classification = new ArrayList<DeviceDefinitionClassificationComponent>();
            for (DeviceDefinitionClassificationComponent deviceDefinitionClassificationComponent : this.classification) {
                dst.classification.add(deviceDefinitionClassificationComponent.copy());
            }
        }
        if (this.specialization != null) {
            dst.specialization = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.specialization) {
                dst.specialization.add(relatedArtifact.copy());
            }
        }
        if (this.hasPart != null) {
            dst.hasPart = new ArrayList<DeviceDefinitionHasPartComponent>();
            for (DeviceDefinitionHasPartComponent deviceDefinitionHasPartComponent : this.hasPart) {
                dst.hasPart.add(deviceDefinitionHasPartComponent.copy());
            }
        }
        if (this.packaging != null) {
            dst.packaging = new ArrayList<DeviceDefinitionPackagingComponent>();
            for (DeviceDefinitionPackagingComponent deviceDefinitionPackagingComponent : this.packaging) {
                dst.packaging.add(deviceDefinitionPackagingComponent.copy());
            }
        }
        if (this.version != null) {
            dst.version = new ArrayList<DeviceDefinitionVersionComponent>();
            for (DeviceDefinitionVersionComponent deviceDefinitionVersionComponent : this.version) {
                dst.version.add(deviceDefinitionVersionComponent.copy());
            }
        }
        if (this.safety != null) {
            dst.safety = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.safety) {
                dst.safety.add(codeableConcept.copy());
            }
        }
        if (this.shelfLifeStorage != null) {
            dst.shelfLifeStorage = new ArrayList<ProductShelfLife>();
            for (ProductShelfLife productShelfLife : this.shelfLifeStorage) {
                dst.shelfLifeStorage.add(productShelfLife.copy());
            }
        }
        if (this.languageCode != null) {
            dst.languageCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.languageCode) {
                dst.languageCode.add(codeableConcept.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<DeviceDefinitionPropertyComponent>();
            for (DeviceDefinitionPropertyComponent deviceDefinitionPropertyComponent : this.property) {
                dst.property.add(deviceDefinitionPropertyComponent.copy());
            }
        }
        Reference reference2 = dst.owner = this.owner == null ? null : this.owner.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        if (this.link != null) {
            dst.link = new ArrayList<DeviceDefinitionLinkComponent>();
            for (DeviceDefinitionLinkComponent deviceDefinitionLinkComponent : this.link) {
                dst.link.add(deviceDefinitionLinkComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        Reference reference3 = dst.parentDevice = this.parentDevice == null ? null : this.parentDevice.copy();
        if (this.material != null) {
            dst.material = new ArrayList<DeviceDefinitionMaterialComponent>();
            for (DeviceDefinitionMaterialComponent deviceDefinitionMaterialComponent : this.material) {
                dst.material.add(deviceDefinitionMaterialComponent.copy());
            }
        }
        if (this.productionIdentifierInUDI != null) {
            dst.productionIdentifierInUDI = new ArrayList<Enumeration<DeviceProductionIdentifierInUDI>>();
            for (Enumeration enumeration : this.productionIdentifierInUDI) {
                dst.productionIdentifierInUDI.add((Enumeration<DeviceProductionIdentifierInUDI>)enumeration.copy());
            }
        }
        dst.guideline = this.guideline == null ? null : this.guideline.copy();
        DeviceDefinitionCorrectiveActionComponent deviceDefinitionCorrectiveActionComponent = dst.correctiveAction = this.correctiveAction == null ? null : this.correctiveAction.copy();
        if (this.chargeItem != null) {
            dst.chargeItem = new ArrayList<DeviceDefinitionChargeItemComponent>();
            for (DeviceDefinitionChargeItemComponent deviceDefinitionChargeItemComponent : this.chargeItem) {
                dst.chargeItem.add(deviceDefinitionChargeItemComponent.copy());
            }
        }
    }

    protected DeviceDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceDefinition)) {
            return false;
        }
        DeviceDefinition o = (DeviceDefinition)other_;
        return DeviceDefinition.compareDeep(this.description, o.description, true) && DeviceDefinition.compareDeep(this.identifier, o.identifier, true) && DeviceDefinition.compareDeep(this.udiDeviceIdentifier, o.udiDeviceIdentifier, true) && DeviceDefinition.compareDeep(this.regulatoryIdentifier, o.regulatoryIdentifier, true) && DeviceDefinition.compareDeep(this.partNumber, o.partNumber, true) && DeviceDefinition.compareDeep(this.manufacturer, o.manufacturer, true) && DeviceDefinition.compareDeep(this.deviceName, o.deviceName, true) && DeviceDefinition.compareDeep(this.modelNumber, o.modelNumber, true) && DeviceDefinition.compareDeep(this.classification, o.classification, true) && DeviceDefinition.compareDeep(this.specialization, o.specialization, true) && DeviceDefinition.compareDeep(this.hasPart, o.hasPart, true) && DeviceDefinition.compareDeep(this.packaging, o.packaging, true) && DeviceDefinition.compareDeep(this.version, o.version, true) && DeviceDefinition.compareDeep(this.safety, o.safety, true) && DeviceDefinition.compareDeep(this.shelfLifeStorage, o.shelfLifeStorage, true) && DeviceDefinition.compareDeep(this.languageCode, o.languageCode, true) && DeviceDefinition.compareDeep(this.property, o.property, true) && DeviceDefinition.compareDeep(this.owner, o.owner, true) && DeviceDefinition.compareDeep(this.contact, o.contact, true) && DeviceDefinition.compareDeep(this.link, o.link, true) && DeviceDefinition.compareDeep(this.note, o.note, true) && DeviceDefinition.compareDeep(this.parentDevice, o.parentDevice, true) && DeviceDefinition.compareDeep(this.material, o.material, true) && DeviceDefinition.compareDeep(this.productionIdentifierInUDI, o.productionIdentifierInUDI, true) && DeviceDefinition.compareDeep(this.guideline, o.guideline, true) && DeviceDefinition.compareDeep(this.correctiveAction, o.correctiveAction, true) && DeviceDefinition.compareDeep(this.chargeItem, o.chargeItem, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DeviceDefinition)) {
            return false;
        }
        DeviceDefinition o = (DeviceDefinition)other_;
        return DeviceDefinition.compareValues(this.description, o.description, true) && DeviceDefinition.compareValues(this.partNumber, o.partNumber, true) && DeviceDefinition.compareValues(this.modelNumber, o.modelNumber, true) && DeviceDefinition.compareValues(this.productionIdentifierInUDI, o.productionIdentifierInUDI, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.description, this.identifier, this.udiDeviceIdentifier, this.regulatoryIdentifier, this.partNumber, this.manufacturer, this.deviceName, this.modelNumber, this.classification, this.specialization, this.hasPart, this.packaging, this.version, this.safety, this.shelfLifeStorage, this.languageCode, this.property, this.owner, this.contact, this.link, this.note, this.parentDevice, this.material, this.productionIdentifierInUDI, this.guideline, this.correctiveAction, this.chargeItem);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceDefinition;
    }

    @Block
    public static class DeviceDefinitionChargeItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="chargeItemCode", type={CodeableReference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The code or reference for the charge item", formalDefinition="The code or reference for the charge item.")
        protected CodeableReference chargeItemCode;
        @Child(name="count", type={Quantity.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Coefficient applicable to the billing code", formalDefinition="Coefficient applicable to the billing code.")
        protected Quantity count;
        @Child(name="effectivePeriod", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A specific time period in which this charge item applies", formalDefinition="A specific time period in which this charge item applies.")
        protected Period effectivePeriod;
        @Child(name="useContext", type={UsageContext.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The context to which this charge item applies", formalDefinition="The context to which this charge item applies.")
        protected List<UsageContext> useContext;
        private static final long serialVersionUID = 1312166907L;

        public DeviceDefinitionChargeItemComponent() {
        }

        public DeviceDefinitionChargeItemComponent(CodeableReference chargeItemCode, Quantity count) {
            this.setChargeItemCode(chargeItemCode);
            this.setCount(count);
        }

        public CodeableReference getChargeItemCode() {
            if (this.chargeItemCode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionChargeItemComponent.chargeItemCode");
                }
                if (Configuration.doAutoCreate()) {
                    this.chargeItemCode = new CodeableReference();
                }
            }
            return this.chargeItemCode;
        }

        public boolean hasChargeItemCode() {
            return this.chargeItemCode != null && !this.chargeItemCode.isEmpty();
        }

        public DeviceDefinitionChargeItemComponent setChargeItemCode(CodeableReference value) {
            this.chargeItemCode = value;
            return this;
        }

        public Quantity getCount() {
            if (this.count == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionChargeItemComponent.count");
                }
                if (Configuration.doAutoCreate()) {
                    this.count = new Quantity();
                }
            }
            return this.count;
        }

        public boolean hasCount() {
            return this.count != null && !this.count.isEmpty();
        }

        public DeviceDefinitionChargeItemComponent setCount(Quantity value) {
            this.count = value;
            return this;
        }

        public Period getEffectivePeriod() {
            if (this.effectivePeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionChargeItemComponent.effectivePeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.effectivePeriod = new Period();
                }
            }
            return this.effectivePeriod;
        }

        public boolean hasEffectivePeriod() {
            return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
        }

        public DeviceDefinitionChargeItemComponent setEffectivePeriod(Period value) {
            this.effectivePeriod = value;
            return this;
        }

        public List<UsageContext> getUseContext() {
            if (this.useContext == null) {
                this.useContext = new ArrayList<UsageContext>();
            }
            return this.useContext;
        }

        public DeviceDefinitionChargeItemComponent setUseContext(List<UsageContext> theUseContext) {
            this.useContext = theUseContext;
            return this;
        }

        public boolean hasUseContext() {
            if (this.useContext == null) {
                return false;
            }
            for (UsageContext item : this.useContext) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UsageContext addUseContext() {
            UsageContext t = new UsageContext();
            if (this.useContext == null) {
                this.useContext = new ArrayList<UsageContext>();
            }
            this.useContext.add(t);
            return t;
        }

        public DeviceDefinitionChargeItemComponent addUseContext(UsageContext t) {
            if (t == null) {
                return this;
            }
            if (this.useContext == null) {
                this.useContext = new ArrayList<UsageContext>();
            }
            this.useContext.add(t);
            return this;
        }

        public UsageContext getUseContextFirstRep() {
            if (this.getUseContext().isEmpty()) {
                this.addUseContext();
            }
            return this.getUseContext().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("chargeItemCode", "CodeableReference(ChargeItemDefinition)", "The code or reference for the charge item.", 0, 1, this.chargeItemCode));
            children.add(new Property("count", "Quantity", "Coefficient applicable to the billing code.", 0, 1, this.count));
            children.add(new Property("effectivePeriod", "Period", "A specific time period in which this charge item applies.", 0, 1, this.effectivePeriod));
            children.add(new Property("useContext", "UsageContext", "The context to which this charge item applies.", 0, Integer.MAX_VALUE, this.useContext));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -2001375628: {
                    return new Property("chargeItemCode", "CodeableReference(ChargeItemDefinition)", "The code or reference for the charge item.", 0, 1, this.chargeItemCode);
                }
                case 94851343: {
                    return new Property("count", "Quantity", "Coefficient applicable to the billing code.", 0, 1, this.count);
                }
                case -403934648: {
                    return new Property("effectivePeriod", "Period", "A specific time period in which this charge item applies.", 0, 1, this.effectivePeriod);
                }
                case -669707736: {
                    return new Property("useContext", "UsageContext", "The context to which this charge item applies.", 0, Integer.MAX_VALUE, this.useContext);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -2001375628: {
                    Base[] baseArray;
                    if (this.chargeItemCode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.chargeItemCode;
                    }
                    return baseArray;
                }
                case 94851343: {
                    Base[] baseArray;
                    if (this.count == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.count;
                    }
                    return baseArray;
                }
                case -403934648: {
                    Base[] baseArray;
                    if (this.effectivePeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.effectivePeriod;
                    }
                    return baseArray;
                }
                case -669707736: {
                    return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -2001375628: {
                    this.chargeItemCode = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
                case 94851343: {
                    this.count = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -403934648: {
                    this.effectivePeriod = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case -669707736: {
                    this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("chargeItemCode")) {
                this.chargeItemCode = TypeConvertor.castToCodeableReference(value);
            } else if (name.equals("count")) {
                this.count = TypeConvertor.castToQuantity(value);
            } else if (name.equals("effectivePeriod")) {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
            } else if (name.equals("useContext")) {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2001375628: {
                    return this.getChargeItemCode();
                }
                case 94851343: {
                    return this.getCount();
                }
                case -403934648: {
                    return this.getEffectivePeriod();
                }
                case -669707736: {
                    return this.addUseContext();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -2001375628: {
                    return new String[]{"CodeableReference"};
                }
                case 94851343: {
                    return new String[]{"Quantity"};
                }
                case -403934648: {
                    return new String[]{"Period"};
                }
                case -669707736: {
                    return new String[]{"UsageContext"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("chargeItemCode")) {
                this.chargeItemCode = new CodeableReference();
                return this.chargeItemCode;
            }
            if (name.equals("count")) {
                this.count = new Quantity();
                return this.count;
            }
            if (name.equals("effectivePeriod")) {
                this.effectivePeriod = new Period();
                return this.effectivePeriod;
            }
            if (name.equals("useContext")) {
                return this.addUseContext();
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionChargeItemComponent copy() {
            DeviceDefinitionChargeItemComponent dst = new DeviceDefinitionChargeItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionChargeItemComponent dst) {
            super.copyValues(dst);
            dst.chargeItemCode = this.chargeItemCode == null ? null : this.chargeItemCode.copy();
            dst.count = this.count == null ? null : this.count.copy();
            Period period = dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
            if (this.useContext != null) {
                dst.useContext = new ArrayList<UsageContext>();
                for (UsageContext i2 : this.useContext) {
                    dst.useContext.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionChargeItemComponent)) {
                return false;
            }
            DeviceDefinitionChargeItemComponent o = (DeviceDefinitionChargeItemComponent)other_;
            return DeviceDefinitionChargeItemComponent.compareDeep(this.chargeItemCode, o.chargeItemCode, true) && DeviceDefinitionChargeItemComponent.compareDeep(this.count, o.count, true) && DeviceDefinitionChargeItemComponent.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && DeviceDefinitionChargeItemComponent.compareDeep(this.useContext, o.useContext, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionChargeItemComponent)) {
                return false;
            }
            DeviceDefinitionChargeItemComponent o = (DeviceDefinitionChargeItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.chargeItemCode, this.count, this.effectivePeriod, this.useContext);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.chargeItem";
        }
    }

    @Block
    public static class DeviceDefinitionCorrectiveActionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="recall", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the corrective action was a recall", formalDefinition="Whether the last corrective action known for this device was a recall.")
        protected BooleanType recall;
        @Child(name="scope", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="model | lot-numbers | serial-numbers", formalDefinition="The scope of the corrective action - whether the action targeted all units of a given device model, or only a specific set of batches identified by lot numbers, or individually identified devices identified by the serial name.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-correctiveactionscope")
        protected Enumeration<DeviceCorrectiveActionScope> scope;
        @Child(name="period", type={Period.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Start and end dates of the  corrective action", formalDefinition="Start and end dates of the  corrective action.")
        protected Period period;
        private static final long serialVersionUID = -1936691252L;

        public DeviceDefinitionCorrectiveActionComponent() {
        }

        public DeviceDefinitionCorrectiveActionComponent(boolean recall, Period period) {
            this.setRecall(recall);
            this.setPeriod(period);
        }

        public BooleanType getRecallElement() {
            if (this.recall == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionCorrectiveActionComponent.recall");
                }
                if (Configuration.doAutoCreate()) {
                    this.recall = new BooleanType();
                }
            }
            return this.recall;
        }

        public boolean hasRecallElement() {
            return this.recall != null && !this.recall.isEmpty();
        }

        public boolean hasRecall() {
            return this.recall != null && !this.recall.isEmpty();
        }

        public DeviceDefinitionCorrectiveActionComponent setRecallElement(BooleanType value) {
            this.recall = value;
            return this;
        }

        public boolean getRecall() {
            return this.recall == null || this.recall.isEmpty() ? false : (Boolean)this.recall.getValue();
        }

        public DeviceDefinitionCorrectiveActionComponent setRecall(boolean value) {
            if (this.recall == null) {
                this.recall = new BooleanType();
            }
            this.recall.setValue((Object)value);
            return this;
        }

        public Enumeration<DeviceCorrectiveActionScope> getScopeElement() {
            if (this.scope == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionCorrectiveActionComponent.scope");
                }
                if (Configuration.doAutoCreate()) {
                    this.scope = new Enumeration<DeviceCorrectiveActionScope>(new DeviceCorrectiveActionScopeEnumFactory());
                }
            }
            return this.scope;
        }

        public boolean hasScopeElement() {
            return this.scope != null && !this.scope.isEmpty();
        }

        public boolean hasScope() {
            return this.scope != null && !this.scope.isEmpty();
        }

        public DeviceDefinitionCorrectiveActionComponent setScopeElement(Enumeration<DeviceCorrectiveActionScope> value) {
            this.scope = value;
            return this;
        }

        public DeviceCorrectiveActionScope getScope() {
            return this.scope == null ? null : (DeviceCorrectiveActionScope)((Object)this.scope.getValue());
        }

        public DeviceDefinitionCorrectiveActionComponent setScope(DeviceCorrectiveActionScope value) {
            if (value == null) {
                this.scope = null;
            } else {
                if (this.scope == null) {
                    this.scope = new Enumeration<DeviceCorrectiveActionScope>(new DeviceCorrectiveActionScopeEnumFactory());
                }
                this.scope.setValue((Object)value);
            }
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionCorrectiveActionComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public DeviceDefinitionCorrectiveActionComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("recall", "boolean", "Whether the last corrective action known for this device was a recall.", 0, 1, this.recall));
            children.add(new Property("scope", "code", "The scope of the corrective action - whether the action targeted all units of a given device model, or only a specific set of batches identified by lot numbers, or individually identified devices identified by the serial name.", 0, 1, this.scope));
            children.add(new Property("period", "Period", "Start and end dates of the  corrective action.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -934922479: {
                    return new Property("recall", "boolean", "Whether the last corrective action known for this device was a recall.", 0, 1, this.recall);
                }
                case 109264468: {
                    return new Property("scope", "code", "The scope of the corrective action - whether the action targeted all units of a given device model, or only a specific set of batches identified by lot numbers, or individually identified devices identified by the serial name.", 0, 1, this.scope);
                }
                case -991726143: {
                    return new Property("period", "Period", "Start and end dates of the  corrective action.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -934922479: {
                    Base[] baseArray;
                    if (this.recall == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.recall;
                    }
                    return baseArray;
                }
                case 109264468: {
                    Base[] baseArray;
                    if (this.scope == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.scope;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -934922479: {
                    this.recall = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 109264468: {
                    value = new DeviceCorrectiveActionScopeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.scope = value;
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("recall")) {
                this.recall = TypeConvertor.castToBoolean(value);
            } else if (name.equals("scope")) {
                value = new DeviceCorrectiveActionScopeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.scope = value;
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -934922479: {
                    return this.getRecallElement();
                }
                case 109264468: {
                    return this.getScopeElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -934922479: {
                    return new String[]{"boolean"};
                }
                case 109264468: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("recall")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.correctiveAction.recall");
            }
            if (name.equals("scope")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.correctiveAction.scope");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionCorrectiveActionComponent copy() {
            DeviceDefinitionCorrectiveActionComponent dst = new DeviceDefinitionCorrectiveActionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionCorrectiveActionComponent dst) {
            super.copyValues(dst);
            dst.recall = this.recall == null ? null : this.recall.copy();
            dst.scope = this.scope == null ? null : this.scope.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionCorrectiveActionComponent)) {
                return false;
            }
            DeviceDefinitionCorrectiveActionComponent o = (DeviceDefinitionCorrectiveActionComponent)other_;
            return DeviceDefinitionCorrectiveActionComponent.compareDeep(this.recall, o.recall, true) && DeviceDefinitionCorrectiveActionComponent.compareDeep(this.scope, o.scope, true) && DeviceDefinitionCorrectiveActionComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionCorrectiveActionComponent)) {
                return false;
            }
            DeviceDefinitionCorrectiveActionComponent o = (DeviceDefinitionCorrectiveActionComponent)other_;
            return DeviceDefinitionCorrectiveActionComponent.compareValues(this.recall, o.recall, true) && DeviceDefinitionCorrectiveActionComponent.compareValues(this.scope, o.scope, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.recall, this.scope, this.period);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.correctiveAction";
        }
    }

    @Block
    public static class DeviceDefinitionGuidelineComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="useContext", type={UsageContext.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The circumstances that form the setting for using the device", formalDefinition="The circumstances that form the setting for using the device.")
        protected List<UsageContext> useContext;
        @Child(name="usageInstruction", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Detailed written and visual directions for the user on how to use the device", formalDefinition="Detailed written and visual directions for the user on how to use the device.")
        protected MarkdownType usageInstruction;
        @Child(name="relatedArtifact", type={RelatedArtifact.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A source of information or reference for this guideline", formalDefinition="A source of information or reference for this guideline.")
        protected List<RelatedArtifact> relatedArtifact;
        @Child(name="indication", type={CodeableReference.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A clinical condition for which the device was designed to be used", formalDefinition="A clinical condition for which the device was designed to be used.")
        protected List<CodeableReference> indication;
        @Child(name="contraindication", type={CodeableReference.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A specific situation when a device should not be used because it may cause harm", formalDefinition="A specific situation when a device should not be used because it may cause harm.")
        protected List<CodeableReference> contraindication;
        @Child(name="warning", type={CodeableReference.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specific hazard alert information that a user needs to know before using the device", formalDefinition="Specific hazard alert information that a user needs to know before using the device.")
        protected List<CodeableReference> warning;
        @Child(name="intendedUse", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A description of the general purpose or medical use of the device or its function", formalDefinition="A description of the general purpose or medical use of the device or its function.")
        protected StringType intendedUse;
        private static final long serialVersionUID = -591777054L;

        public List<UsageContext> getUseContext() {
            if (this.useContext == null) {
                this.useContext = new ArrayList<UsageContext>();
            }
            return this.useContext;
        }

        public DeviceDefinitionGuidelineComponent setUseContext(List<UsageContext> theUseContext) {
            this.useContext = theUseContext;
            return this;
        }

        public boolean hasUseContext() {
            if (this.useContext == null) {
                return false;
            }
            for (UsageContext item : this.useContext) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UsageContext addUseContext() {
            UsageContext t = new UsageContext();
            if (this.useContext == null) {
                this.useContext = new ArrayList<UsageContext>();
            }
            this.useContext.add(t);
            return t;
        }

        public DeviceDefinitionGuidelineComponent addUseContext(UsageContext t) {
            if (t == null) {
                return this;
            }
            if (this.useContext == null) {
                this.useContext = new ArrayList<UsageContext>();
            }
            this.useContext.add(t);
            return this;
        }

        public UsageContext getUseContextFirstRep() {
            if (this.getUseContext().isEmpty()) {
                this.addUseContext();
            }
            return this.getUseContext().get(0);
        }

        public MarkdownType getUsageInstructionElement() {
            if (this.usageInstruction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionGuidelineComponent.usageInstruction");
                }
                if (Configuration.doAutoCreate()) {
                    this.usageInstruction = new MarkdownType();
                }
            }
            return this.usageInstruction;
        }

        public boolean hasUsageInstructionElement() {
            return this.usageInstruction != null && !this.usageInstruction.isEmpty();
        }

        public boolean hasUsageInstruction() {
            return this.usageInstruction != null && !this.usageInstruction.isEmpty();
        }

        public DeviceDefinitionGuidelineComponent setUsageInstructionElement(MarkdownType value) {
            this.usageInstruction = value;
            return this;
        }

        public String getUsageInstruction() {
            return this.usageInstruction == null ? null : (String)this.usageInstruction.getValue();
        }

        public DeviceDefinitionGuidelineComponent setUsageInstruction(String value) {
            if (value == null) {
                this.usageInstruction = null;
            } else {
                if (this.usageInstruction == null) {
                    this.usageInstruction = new MarkdownType();
                }
                this.usageInstruction.setValue(value);
            }
            return this;
        }

        public List<RelatedArtifact> getRelatedArtifact() {
            if (this.relatedArtifact == null) {
                this.relatedArtifact = new ArrayList<RelatedArtifact>();
            }
            return this.relatedArtifact;
        }

        public DeviceDefinitionGuidelineComponent setRelatedArtifact(List<RelatedArtifact> theRelatedArtifact) {
            this.relatedArtifact = theRelatedArtifact;
            return this;
        }

        public boolean hasRelatedArtifact() {
            if (this.relatedArtifact == null) {
                return false;
            }
            for (RelatedArtifact item : this.relatedArtifact) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RelatedArtifact addRelatedArtifact() {
            RelatedArtifact t = new RelatedArtifact();
            if (this.relatedArtifact == null) {
                this.relatedArtifact = new ArrayList<RelatedArtifact>();
            }
            this.relatedArtifact.add(t);
            return t;
        }

        public DeviceDefinitionGuidelineComponent addRelatedArtifact(RelatedArtifact t) {
            if (t == null) {
                return this;
            }
            if (this.relatedArtifact == null) {
                this.relatedArtifact = new ArrayList<RelatedArtifact>();
            }
            this.relatedArtifact.add(t);
            return this;
        }

        public RelatedArtifact getRelatedArtifactFirstRep() {
            if (this.getRelatedArtifact().isEmpty()) {
                this.addRelatedArtifact();
            }
            return this.getRelatedArtifact().get(0);
        }

        public List<CodeableReference> getIndication() {
            if (this.indication == null) {
                this.indication = new ArrayList<CodeableReference>();
            }
            return this.indication;
        }

        public DeviceDefinitionGuidelineComponent setIndication(List<CodeableReference> theIndication) {
            this.indication = theIndication;
            return this;
        }

        public boolean hasIndication() {
            if (this.indication == null) {
                return false;
            }
            for (CodeableReference item : this.indication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addIndication() {
            CodeableReference t = new CodeableReference();
            if (this.indication == null) {
                this.indication = new ArrayList<CodeableReference>();
            }
            this.indication.add(t);
            return t;
        }

        public DeviceDefinitionGuidelineComponent addIndication(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.indication == null) {
                this.indication = new ArrayList<CodeableReference>();
            }
            this.indication.add(t);
            return this;
        }

        public CodeableReference getIndicationFirstRep() {
            if (this.getIndication().isEmpty()) {
                this.addIndication();
            }
            return this.getIndication().get(0);
        }

        public List<CodeableReference> getContraindication() {
            if (this.contraindication == null) {
                this.contraindication = new ArrayList<CodeableReference>();
            }
            return this.contraindication;
        }

        public DeviceDefinitionGuidelineComponent setContraindication(List<CodeableReference> theContraindication) {
            this.contraindication = theContraindication;
            return this;
        }

        public boolean hasContraindication() {
            if (this.contraindication == null) {
                return false;
            }
            for (CodeableReference item : this.contraindication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addContraindication() {
            CodeableReference t = new CodeableReference();
            if (this.contraindication == null) {
                this.contraindication = new ArrayList<CodeableReference>();
            }
            this.contraindication.add(t);
            return t;
        }

        public DeviceDefinitionGuidelineComponent addContraindication(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.contraindication == null) {
                this.contraindication = new ArrayList<CodeableReference>();
            }
            this.contraindication.add(t);
            return this;
        }

        public CodeableReference getContraindicationFirstRep() {
            if (this.getContraindication().isEmpty()) {
                this.addContraindication();
            }
            return this.getContraindication().get(0);
        }

        public List<CodeableReference> getWarning() {
            if (this.warning == null) {
                this.warning = new ArrayList<CodeableReference>();
            }
            return this.warning;
        }

        public DeviceDefinitionGuidelineComponent setWarning(List<CodeableReference> theWarning) {
            this.warning = theWarning;
            return this;
        }

        public boolean hasWarning() {
            if (this.warning == null) {
                return false;
            }
            for (CodeableReference item : this.warning) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addWarning() {
            CodeableReference t = new CodeableReference();
            if (this.warning == null) {
                this.warning = new ArrayList<CodeableReference>();
            }
            this.warning.add(t);
            return t;
        }

        public DeviceDefinitionGuidelineComponent addWarning(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.warning == null) {
                this.warning = new ArrayList<CodeableReference>();
            }
            this.warning.add(t);
            return this;
        }

        public CodeableReference getWarningFirstRep() {
            if (this.getWarning().isEmpty()) {
                this.addWarning();
            }
            return this.getWarning().get(0);
        }

        public StringType getIntendedUseElement() {
            if (this.intendedUse == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionGuidelineComponent.intendedUse");
                }
                if (Configuration.doAutoCreate()) {
                    this.intendedUse = new StringType();
                }
            }
            return this.intendedUse;
        }

        public boolean hasIntendedUseElement() {
            return this.intendedUse != null && !this.intendedUse.isEmpty();
        }

        public boolean hasIntendedUse() {
            return this.intendedUse != null && !this.intendedUse.isEmpty();
        }

        public DeviceDefinitionGuidelineComponent setIntendedUseElement(StringType value) {
            this.intendedUse = value;
            return this;
        }

        public String getIntendedUse() {
            return this.intendedUse == null ? null : (String)this.intendedUse.getValue();
        }

        public DeviceDefinitionGuidelineComponent setIntendedUse(String value) {
            if (Utilities.noString(value)) {
                this.intendedUse = null;
            } else {
                if (this.intendedUse == null) {
                    this.intendedUse = new StringType();
                }
                this.intendedUse.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("useContext", "UsageContext", "The circumstances that form the setting for using the device.", 0, Integer.MAX_VALUE, this.useContext));
            children.add(new Property("usageInstruction", "markdown", "Detailed written and visual directions for the user on how to use the device.", 0, 1, this.usageInstruction));
            children.add(new Property("relatedArtifact", "RelatedArtifact", "A source of information or reference for this guideline.", 0, Integer.MAX_VALUE, this.relatedArtifact));
            children.add(new Property("indication", "CodeableReference(ClinicalUseDefinition)", "A clinical condition for which the device was designed to be used.", 0, Integer.MAX_VALUE, this.indication));
            children.add(new Property("contraindication", "CodeableReference(ClinicalUseDefinition)", "A specific situation when a device should not be used because it may cause harm.", 0, Integer.MAX_VALUE, this.contraindication));
            children.add(new Property("warning", "CodeableReference(ClinicalUseDefinition)", "Specific hazard alert information that a user needs to know before using the device.", 0, Integer.MAX_VALUE, this.warning));
            children.add(new Property("intendedUse", "string", "A description of the general purpose or medical use of the device or its function.", 0, 1, this.intendedUse));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -669707736: {
                    return new Property("useContext", "UsageContext", "The circumstances that form the setting for using the device.", 0, Integer.MAX_VALUE, this.useContext);
                }
                case 2138372141: {
                    return new Property("usageInstruction", "markdown", "Detailed written and visual directions for the user on how to use the device.", 0, 1, this.usageInstruction);
                }
                case 666807069: {
                    return new Property("relatedArtifact", "RelatedArtifact", "A source of information or reference for this guideline.", 0, Integer.MAX_VALUE, this.relatedArtifact);
                }
                case -597168804: {
                    return new Property("indication", "CodeableReference(ClinicalUseDefinition)", "A clinical condition for which the device was designed to be used.", 0, Integer.MAX_VALUE, this.indication);
                }
                case 107135229: {
                    return new Property("contraindication", "CodeableReference(ClinicalUseDefinition)", "A specific situation when a device should not be used because it may cause harm.", 0, Integer.MAX_VALUE, this.contraindication);
                }
                case 1124446108: {
                    return new Property("warning", "CodeableReference(ClinicalUseDefinition)", "Specific hazard alert information that a user needs to know before using the device.", 0, Integer.MAX_VALUE, this.warning);
                }
                case -1618671268: {
                    return new Property("intendedUse", "string", "A description of the general purpose or medical use of the device or its function.", 0, 1, this.intendedUse);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -669707736: {
                    return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
                }
                case 2138372141: {
                    Base[] baseArray;
                    if (this.usageInstruction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.usageInstruction;
                    }
                    return baseArray;
                }
                case 666807069: {
                    return this.relatedArtifact == null ? new Base[]{} : this.relatedArtifact.toArray(new Base[this.relatedArtifact.size()]);
                }
                case -597168804: {
                    return this.indication == null ? new Base[]{} : this.indication.toArray(new Base[this.indication.size()]);
                }
                case 107135229: {
                    return this.contraindication == null ? new Base[]{} : this.contraindication.toArray(new Base[this.contraindication.size()]);
                }
                case 1124446108: {
                    return this.warning == null ? new Base[]{} : this.warning.toArray(new Base[this.warning.size()]);
                }
                case -1618671268: {
                    Base[] baseArray;
                    if (this.intendedUse == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.intendedUse;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -669707736: {
                    this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                    return value;
                }
                case 2138372141: {
                    this.usageInstruction = TypeConvertor.castToMarkdown(value);
                    return value;
                }
                case 666807069: {
                    this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
                    return value;
                }
                case -597168804: {
                    this.getIndication().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case 107135229: {
                    this.getContraindication().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case 1124446108: {
                    this.getWarning().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case -1618671268: {
                    this.intendedUse = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("useContext")) {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
            } else if (name.equals("usageInstruction")) {
                this.usageInstruction = TypeConvertor.castToMarkdown(value);
            } else if (name.equals("relatedArtifact")) {
                this.getRelatedArtifact().add(TypeConvertor.castToRelatedArtifact(value));
            } else if (name.equals("indication")) {
                this.getIndication().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("contraindication")) {
                this.getContraindication().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("warning")) {
                this.getWarning().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("intendedUse")) {
                this.intendedUse = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -669707736: {
                    return this.addUseContext();
                }
                case 2138372141: {
                    return this.getUsageInstructionElement();
                }
                case 666807069: {
                    return this.addRelatedArtifact();
                }
                case -597168804: {
                    return this.addIndication();
                }
                case 107135229: {
                    return this.addContraindication();
                }
                case 1124446108: {
                    return this.addWarning();
                }
                case -1618671268: {
                    return this.getIntendedUseElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -669707736: {
                    return new String[]{"UsageContext"};
                }
                case 2138372141: {
                    return new String[]{"markdown"};
                }
                case 666807069: {
                    return new String[]{"RelatedArtifact"};
                }
                case -597168804: {
                    return new String[]{"CodeableReference"};
                }
                case 107135229: {
                    return new String[]{"CodeableReference"};
                }
                case 1124446108: {
                    return new String[]{"CodeableReference"};
                }
                case -1618671268: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("useContext")) {
                return this.addUseContext();
            }
            if (name.equals("usageInstruction")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.guideline.usageInstruction");
            }
            if (name.equals("relatedArtifact")) {
                return this.addRelatedArtifact();
            }
            if (name.equals("indication")) {
                return this.addIndication();
            }
            if (name.equals("contraindication")) {
                return this.addContraindication();
            }
            if (name.equals("warning")) {
                return this.addWarning();
            }
            if (name.equals("intendedUse")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.guideline.intendedUse");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionGuidelineComponent copy() {
            DeviceDefinitionGuidelineComponent dst = new DeviceDefinitionGuidelineComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionGuidelineComponent dst) {
            super.copyValues(dst);
            if (this.useContext != null) {
                dst.useContext = new ArrayList<UsageContext>();
                for (UsageContext usageContext : this.useContext) {
                    dst.useContext.add(usageContext.copy());
                }
            }
            MarkdownType markdownType = dst.usageInstruction = this.usageInstruction == null ? null : this.usageInstruction.copy();
            if (this.relatedArtifact != null) {
                dst.relatedArtifact = new ArrayList<RelatedArtifact>();
                for (RelatedArtifact relatedArtifact : this.relatedArtifact) {
                    dst.relatedArtifact.add(relatedArtifact.copy());
                }
            }
            if (this.indication != null) {
                dst.indication = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.indication) {
                    dst.indication.add(codeableReference.copy());
                }
            }
            if (this.contraindication != null) {
                dst.contraindication = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.contraindication) {
                    dst.contraindication.add(codeableReference.copy());
                }
            }
            if (this.warning != null) {
                dst.warning = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.warning) {
                    dst.warning.add(codeableReference.copy());
                }
            }
            dst.intendedUse = this.intendedUse == null ? null : this.intendedUse.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionGuidelineComponent)) {
                return false;
            }
            DeviceDefinitionGuidelineComponent o = (DeviceDefinitionGuidelineComponent)other_;
            return DeviceDefinitionGuidelineComponent.compareDeep(this.useContext, o.useContext, true) && DeviceDefinitionGuidelineComponent.compareDeep(this.usageInstruction, o.usageInstruction, true) && DeviceDefinitionGuidelineComponent.compareDeep(this.relatedArtifact, o.relatedArtifact, true) && DeviceDefinitionGuidelineComponent.compareDeep(this.indication, o.indication, true) && DeviceDefinitionGuidelineComponent.compareDeep(this.contraindication, o.contraindication, true) && DeviceDefinitionGuidelineComponent.compareDeep(this.warning, o.warning, true) && DeviceDefinitionGuidelineComponent.compareDeep(this.intendedUse, o.intendedUse, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionGuidelineComponent)) {
                return false;
            }
            DeviceDefinitionGuidelineComponent o = (DeviceDefinitionGuidelineComponent)other_;
            return DeviceDefinitionGuidelineComponent.compareValues(this.usageInstruction, o.usageInstruction, true) && DeviceDefinitionGuidelineComponent.compareValues(this.intendedUse, o.intendedUse, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.useContext, this.usageInstruction, this.relatedArtifact, this.indication, this.contraindication, this.warning, this.intendedUse);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.guideline";
        }
    }

    @Block
    public static class DeviceDefinitionMaterialComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A relevant substance that the device contains, may contain, or is made of", formalDefinition="A substance that the device contains, may contain, or is made of - for example latex - to be used to determine patient compatibility. This is not intended to represent the composition of the device, only the clinically relevant materials.")
        protected CodeableConcept substance;
        @Child(name="alternate", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates an alternative material of the device", formalDefinition="Indicates an alternative material of the device.")
        protected BooleanType alternate;
        @Child(name="allergenicIndicator", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the substance is a known or suspected allergen", formalDefinition="Whether the substance is a known or suspected allergen.")
        protected BooleanType allergenicIndicator;
        private static final long serialVersionUID = 1232736508L;

        public DeviceDefinitionMaterialComponent() {
        }

        public DeviceDefinitionMaterialComponent(CodeableConcept substance) {
            this.setSubstance(substance);
        }

        public CodeableConcept getSubstance() {
            if (this.substance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionMaterialComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substance = new CodeableConcept();
                }
            }
            return this.substance;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public DeviceDefinitionMaterialComponent setSubstance(CodeableConcept value) {
            this.substance = value;
            return this;
        }

        public BooleanType getAlternateElement() {
            if (this.alternate == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionMaterialComponent.alternate");
                }
                if (Configuration.doAutoCreate()) {
                    this.alternate = new BooleanType();
                }
            }
            return this.alternate;
        }

        public boolean hasAlternateElement() {
            return this.alternate != null && !this.alternate.isEmpty();
        }

        public boolean hasAlternate() {
            return this.alternate != null && !this.alternate.isEmpty();
        }

        public DeviceDefinitionMaterialComponent setAlternateElement(BooleanType value) {
            this.alternate = value;
            return this;
        }

        public boolean getAlternate() {
            return this.alternate == null || this.alternate.isEmpty() ? false : (Boolean)this.alternate.getValue();
        }

        public DeviceDefinitionMaterialComponent setAlternate(boolean value) {
            if (this.alternate == null) {
                this.alternate = new BooleanType();
            }
            this.alternate.setValue((Object)value);
            return this;
        }

        public BooleanType getAllergenicIndicatorElement() {
            if (this.allergenicIndicator == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionMaterialComponent.allergenicIndicator");
                }
                if (Configuration.doAutoCreate()) {
                    this.allergenicIndicator = new BooleanType();
                }
            }
            return this.allergenicIndicator;
        }

        public boolean hasAllergenicIndicatorElement() {
            return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
        }

        public boolean hasAllergenicIndicator() {
            return this.allergenicIndicator != null && !this.allergenicIndicator.isEmpty();
        }

        public DeviceDefinitionMaterialComponent setAllergenicIndicatorElement(BooleanType value) {
            this.allergenicIndicator = value;
            return this;
        }

        public boolean getAllergenicIndicator() {
            return this.allergenicIndicator == null || this.allergenicIndicator.isEmpty() ? false : (Boolean)this.allergenicIndicator.getValue();
        }

        public DeviceDefinitionMaterialComponent setAllergenicIndicator(boolean value) {
            if (this.allergenicIndicator == null) {
                this.allergenicIndicator = new BooleanType();
            }
            this.allergenicIndicator.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("substance", "CodeableConcept", "A substance that the device contains, may contain, or is made of - for example latex - to be used to determine patient compatibility. This is not intended to represent the composition of the device, only the clinically relevant materials.", 0, 1, this.substance));
            children.add(new Property("alternate", "boolean", "Indicates an alternative material of the device.", 0, 1, this.alternate));
            children.add(new Property("allergenicIndicator", "boolean", "Whether the substance is a known or suspected allergen.", 0, 1, this.allergenicIndicator));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 530040176: {
                    return new Property("substance", "CodeableConcept", "A substance that the device contains, may contain, or is made of - for example latex - to be used to determine patient compatibility. This is not intended to represent the composition of the device, only the clinically relevant materials.", 0, 1, this.substance);
                }
                case -1408024454: {
                    return new Property("alternate", "boolean", "Indicates an alternative material of the device.", 0, 1, this.alternate);
                }
                case 75406931: {
                    return new Property("allergenicIndicator", "boolean", "Whether the substance is a known or suspected allergen.", 0, 1, this.allergenicIndicator);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case -1408024454: {
                    Base[] baseArray;
                    if (this.alternate == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.alternate;
                    }
                    return baseArray;
                }
                case 75406931: {
                    Base[] baseArray;
                    if (this.allergenicIndicator == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.allergenicIndicator;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1408024454: {
                    this.alternate = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 75406931: {
                    this.allergenicIndicator = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("alternate")) {
                this.alternate = TypeConvertor.castToBoolean(value);
            } else if (name.equals("allergenicIndicator")) {
                this.allergenicIndicator = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return this.getSubstance();
                }
                case -1408024454: {
                    return this.getAlternateElement();
                }
                case 75406931: {
                    return this.getAllergenicIndicatorElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return new String[]{"CodeableConcept"};
                }
                case -1408024454: {
                    return new String[]{"boolean"};
                }
                case 75406931: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = new CodeableConcept();
                return this.substance;
            }
            if (name.equals("alternate")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.material.alternate");
            }
            if (name.equals("allergenicIndicator")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.material.allergenicIndicator");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionMaterialComponent copy() {
            DeviceDefinitionMaterialComponent dst = new DeviceDefinitionMaterialComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionMaterialComponent dst) {
            super.copyValues(dst);
            dst.substance = this.substance == null ? null : this.substance.copy();
            dst.alternate = this.alternate == null ? null : this.alternate.copy();
            dst.allergenicIndicator = this.allergenicIndicator == null ? null : this.allergenicIndicator.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionMaterialComponent)) {
                return false;
            }
            DeviceDefinitionMaterialComponent o = (DeviceDefinitionMaterialComponent)other_;
            return DeviceDefinitionMaterialComponent.compareDeep(this.substance, o.substance, true) && DeviceDefinitionMaterialComponent.compareDeep(this.alternate, o.alternate, true) && DeviceDefinitionMaterialComponent.compareDeep(this.allergenicIndicator, o.allergenicIndicator, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionMaterialComponent)) {
                return false;
            }
            DeviceDefinitionMaterialComponent o = (DeviceDefinitionMaterialComponent)other_;
            return DeviceDefinitionMaterialComponent.compareValues(this.alternate, o.alternate, true) && DeviceDefinitionMaterialComponent.compareValues(this.allergenicIndicator, o.allergenicIndicator, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.substance, this.alternate, this.allergenicIndicator);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.material";
        }
    }

    @Block
    public static class DeviceDefinitionLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relation", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type indicates the relationship of the related device to the device instance", formalDefinition="The type indicates the relationship of the related device to the device instance.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/devicedefinition-relationtype")
        protected Coding relation;
        @Child(name="relatedDevice", type={CodeableReference.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A reference to the linked device", formalDefinition="A reference to the linked device.")
        protected CodeableReference relatedDevice;
        private static final long serialVersionUID = 627614461L;

        public DeviceDefinitionLinkComponent() {
        }

        public DeviceDefinitionLinkComponent(Coding relation, CodeableReference relatedDevice) {
            this.setRelation(relation);
            this.setRelatedDevice(relatedDevice);
        }

        public Coding getRelation() {
            if (this.relation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionLinkComponent.relation");
                }
                if (Configuration.doAutoCreate()) {
                    this.relation = new Coding();
                }
            }
            return this.relation;
        }

        public boolean hasRelation() {
            return this.relation != null && !this.relation.isEmpty();
        }

        public DeviceDefinitionLinkComponent setRelation(Coding value) {
            this.relation = value;
            return this;
        }

        public CodeableReference getRelatedDevice() {
            if (this.relatedDevice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionLinkComponent.relatedDevice");
                }
                if (Configuration.doAutoCreate()) {
                    this.relatedDevice = new CodeableReference();
                }
            }
            return this.relatedDevice;
        }

        public boolean hasRelatedDevice() {
            return this.relatedDevice != null && !this.relatedDevice.isEmpty();
        }

        public DeviceDefinitionLinkComponent setRelatedDevice(CodeableReference value) {
            this.relatedDevice = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("relation", "Coding", "The type indicates the relationship of the related device to the device instance.", 0, 1, this.relation));
            children.add(new Property("relatedDevice", "CodeableReference(DeviceDefinition)", "A reference to the linked device.", 0, 1, this.relatedDevice));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -554436100: {
                    return new Property("relation", "Coding", "The type indicates the relationship of the related device to the device instance.", 0, 1, this.relation);
                }
                case -296314271: {
                    return new Property("relatedDevice", "CodeableReference(DeviceDefinition)", "A reference to the linked device.", 0, 1, this.relatedDevice);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    Base[] baseArray;
                    if (this.relation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relation;
                    }
                    return baseArray;
                }
                case -296314271: {
                    Base[] baseArray;
                    if (this.relatedDevice == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.relatedDevice;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    this.relation = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -296314271: {
                    this.relatedDevice = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relation")) {
                this.relation = TypeConvertor.castToCoding(value);
            } else if (name.equals("relatedDevice")) {
                this.relatedDevice = TypeConvertor.castToCodeableReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    return this.getRelation();
                }
                case -296314271: {
                    return this.getRelatedDevice();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    return new String[]{"Coding"};
                }
                case -296314271: {
                    return new String[]{"CodeableReference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relation")) {
                this.relation = new Coding();
                return this.relation;
            }
            if (name.equals("relatedDevice")) {
                this.relatedDevice = new CodeableReference();
                return this.relatedDevice;
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionLinkComponent copy() {
            DeviceDefinitionLinkComponent dst = new DeviceDefinitionLinkComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionLinkComponent dst) {
            super.copyValues(dst);
            dst.relation = this.relation == null ? null : this.relation.copy();
            dst.relatedDevice = this.relatedDevice == null ? null : this.relatedDevice.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionLinkComponent)) {
                return false;
            }
            DeviceDefinitionLinkComponent o = (DeviceDefinitionLinkComponent)other_;
            return DeviceDefinitionLinkComponent.compareDeep(this.relation, o.relation, true) && DeviceDefinitionLinkComponent.compareDeep(this.relatedDevice, o.relatedDevice, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionLinkComponent)) {
                return false;
            }
            DeviceDefinitionLinkComponent o = (DeviceDefinitionLinkComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.relation, this.relatedDevice);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.link";
        }
    }

    @Block
    public static class DeviceDefinitionPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that specifies the property", formalDefinition="Code that specifies the property.")
        protected CodeableConcept type;
        @Child(name="value", type={Quantity.class, CodeableConcept.class, StringType.class, BooleanType.class, IntegerType.class, Range.class, Attachment.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Property value - as a code or quantity", formalDefinition="Property value - the data type depends on the property type.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public DeviceDefinitionPropertyComponent() {
        }

        public DeviceDefinitionPropertyComponent(CodeableConcept type, DataType value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionPropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDefinitionPropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DeviceDefinitionPropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof Quantity || value instanceof CodeableConcept || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof Range || value instanceof Attachment)) {
                throw new Error("Not the right type for DeviceDefinition.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "Code that specifies the property.", 0, 1, this.type));
            children.add(new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Attachment", "Property value - the data type depends on the property type.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "Code that specifies the property.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Attachment", "Property value - the data type depends on the property type.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Attachment", "Property value - the data type depends on the property type.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Property value - the data type depends on the property type.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Property value - the data type depends on the property type.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "Property value - the data type depends on the property type.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "Property value - the data type depends on the property type.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "Property value - the data type depends on the property type.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "Property value - the data type depends on the property type.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "Property value - the data type depends on the property type.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity", "CodeableConcept", "string", "boolean", "integer", "Range", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionPropertyComponent copy() {
            DeviceDefinitionPropertyComponent dst = new DeviceDefinitionPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionPropertyComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionPropertyComponent)) {
                return false;
            }
            DeviceDefinitionPropertyComponent o = (DeviceDefinitionPropertyComponent)other_;
            return DeviceDefinitionPropertyComponent.compareDeep(this.type, o.type, true) && DeviceDefinitionPropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionPropertyComponent)) {
                return false;
            }
            DeviceDefinitionPropertyComponent o = (DeviceDefinitionPropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.property";
        }
    }

    @Block
    public static class DeviceDefinitionVersionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of the device version, e.g. manufacturer, approved, internal", formalDefinition="The type of the device version, e.g. manufacturer, approved, internal.")
        protected CodeableConcept type;
        @Child(name="component", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The hardware or software module of the device to which the version applies", formalDefinition="The hardware or software module of the device to which the version applies.")
        protected Identifier component;
        @Child(name="value", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The version text", formalDefinition="The version text.")
        protected StringType value;
        private static final long serialVersionUID = 645214295L;

        public DeviceDefinitionVersionComponent() {
        }

        public DeviceDefinitionVersionComponent(String value) {
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionVersionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDefinitionVersionComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Identifier getComponent() {
            if (this.component == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionVersionComponent.component");
                }
                if (Configuration.doAutoCreate()) {
                    this.component = new Identifier();
                }
            }
            return this.component;
        }

        public boolean hasComponent() {
            return this.component != null && !this.component.isEmpty();
        }

        public DeviceDefinitionVersionComponent setComponent(Identifier value) {
            this.component = value;
            return this;
        }

        public StringType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionVersionComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new StringType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DeviceDefinitionVersionComponent setValueElement(StringType value) {
            this.value = value;
            return this;
        }

        public String getValue() {
            return this.value == null ? null : (String)this.value.getValue();
        }

        public DeviceDefinitionVersionComponent setValue(String value) {
            if (this.value == null) {
                this.value = new StringType();
            }
            this.value.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "The type of the device version, e.g. manufacturer, approved, internal.", 0, 1, this.type));
            children.add(new Property("component", "Identifier", "The hardware or software module of the device to which the version applies.", 0, 1, this.component));
            children.add(new Property("value", "string", "The version text.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "The type of the device version, e.g. manufacturer, approved, internal.", 0, 1, this.type);
                }
                case -1399907075: {
                    return new Property("component", "Identifier", "The hardware or software module of the device to which the version applies.", 0, 1, this.component);
                }
                case 111972721: {
                    return new Property("value", "string", "The version text.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -1399907075: {
                    Base[] baseArray;
                    if (this.component == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.component;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1399907075: {
                    this.component = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("component")) {
                this.component = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("value")) {
                this.value = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1399907075: {
                    return this.getComponent();
                }
                case 111972721: {
                    return this.getValueElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1399907075: {
                    return new String[]{"Identifier"};
                }
                case 111972721: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("component")) {
                this.component = new Identifier();
                return this.component;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.version.value");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionVersionComponent copy() {
            DeviceDefinitionVersionComponent dst = new DeviceDefinitionVersionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionVersionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.component = this.component == null ? null : this.component.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionVersionComponent)) {
                return false;
            }
            DeviceDefinitionVersionComponent o = (DeviceDefinitionVersionComponent)other_;
            return DeviceDefinitionVersionComponent.compareDeep(this.type, o.type, true) && DeviceDefinitionVersionComponent.compareDeep(this.component, o.component, true) && DeviceDefinitionVersionComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionVersionComponent)) {
                return false;
            }
            DeviceDefinitionVersionComponent o = (DeviceDefinitionVersionComponent)other_;
            return DeviceDefinitionVersionComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.component, this.value);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.version";
        }
    }

    @Block
    public static class PackagingDistributorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Distributor's human-readable name", formalDefinition="Distributor's human-readable name.")
        protected StringType name;
        @Child(name="organizationReference", type={Organization.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Distributor as an Organization resource", formalDefinition="Distributor as an Organization resource.")
        protected List<Reference> organizationReference;
        private static final long serialVersionUID = 1587433419L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PackagingDistributorComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public PackagingDistributorComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public PackagingDistributorComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<Reference> getOrganizationReference() {
            if (this.organizationReference == null) {
                this.organizationReference = new ArrayList<Reference>();
            }
            return this.organizationReference;
        }

        public PackagingDistributorComponent setOrganizationReference(List<Reference> theOrganizationReference) {
            this.organizationReference = theOrganizationReference;
            return this;
        }

        public boolean hasOrganizationReference() {
            if (this.organizationReference == null) {
                return false;
            }
            for (Reference item : this.organizationReference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addOrganizationReference() {
            Reference t = new Reference();
            if (this.organizationReference == null) {
                this.organizationReference = new ArrayList<Reference>();
            }
            this.organizationReference.add(t);
            return t;
        }

        public PackagingDistributorComponent addOrganizationReference(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.organizationReference == null) {
                this.organizationReference = new ArrayList<Reference>();
            }
            this.organizationReference.add(t);
            return this;
        }

        public Reference getOrganizationReferenceFirstRep() {
            if (this.getOrganizationReference().isEmpty()) {
                this.addOrganizationReference();
            }
            return this.getOrganizationReference().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Distributor's human-readable name.", 0, 1, this.name));
            children.add(new Property("organizationReference", "Reference(Organization)", "Distributor as an Organization resource.", 0, Integer.MAX_VALUE, this.organizationReference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Distributor's human-readable name.", 0, 1, this.name);
                }
                case 1860475736: {
                    return new Property("organizationReference", "Reference(Organization)", "Distributor as an Organization resource.", 0, Integer.MAX_VALUE, this.organizationReference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 1860475736: {
                    return this.organizationReference == null ? new Base[]{} : this.organizationReference.toArray(new Base[this.organizationReference.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 1860475736: {
                    this.getOrganizationReference().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("organizationReference")) {
                this.getOrganizationReference().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 1860475736: {
                    return this.addOrganizationReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 1860475736: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.packaging.distributor.name");
            }
            if (name.equals("organizationReference")) {
                return this.addOrganizationReference();
            }
            return super.addChild(name);
        }

        @Override
        public PackagingDistributorComponent copy() {
            PackagingDistributorComponent dst = new PackagingDistributorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PackagingDistributorComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.organizationReference != null) {
                dst.organizationReference = new ArrayList<Reference>();
                for (Reference i2 : this.organizationReference) {
                    dst.organizationReference.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagingDistributorComponent)) {
                return false;
            }
            PackagingDistributorComponent o = (PackagingDistributorComponent)other_;
            return PackagingDistributorComponent.compareDeep(this.name, o.name, true) && PackagingDistributorComponent.compareDeep(this.organizationReference, o.organizationReference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PackagingDistributorComponent)) {
                return false;
            }
            PackagingDistributorComponent o = (PackagingDistributorComponent)other_;
            return PackagingDistributorComponent.compareValues(this.name, o.name, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.name, this.organizationReference);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.packaging.distributor";
        }
    }

    @Block
    public static class DeviceDefinitionPackagingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Business identifier of the packaged medication", formalDefinition="The business identifier of the packaged medication.")
        protected Identifier identifier;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A code that defines the specific type of packaging", formalDefinition="A code that defines the specific type of packaging.")
        protected CodeableConcept type;
        @Child(name="count", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The number of items contained in the package (devices or sub-packages)", formalDefinition="The number of items contained in the package (devices or sub-packages).")
        protected IntegerType count;
        @Child(name="distributor", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="An organization that distributes the packaged device", formalDefinition="An organization that distributes the packaged device.")
        protected List<PackagingDistributorComponent> distributor;
        @Child(name="udiDeviceIdentifier", type={DeviceDefinitionUdiDeviceIdentifierComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Unique Device Identifier (UDI) Barcode string on the packaging", formalDefinition="Unique Device Identifier (UDI) Barcode string on the packaging.")
        protected List<DeviceDefinitionUdiDeviceIdentifierComponent> udiDeviceIdentifier;
        @Child(name="packaging", type={DeviceDefinitionPackagingComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Allows packages within packages", formalDefinition="Allows packages within packages.")
        protected List<DeviceDefinitionPackagingComponent> packaging;
        private static final long serialVersionUID = 1022373074L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionPackagingComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public DeviceDefinitionPackagingComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionPackagingComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDefinitionPackagingComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public IntegerType getCountElement() {
            if (this.count == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionPackagingComponent.count");
                }
                if (Configuration.doAutoCreate()) {
                    this.count = new IntegerType();
                }
            }
            return this.count;
        }

        public boolean hasCountElement() {
            return this.count != null && !this.count.isEmpty();
        }

        public boolean hasCount() {
            return this.count != null && !this.count.isEmpty();
        }

        public DeviceDefinitionPackagingComponent setCountElement(IntegerType value) {
            this.count = value;
            return this;
        }

        public int getCount() {
            return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
        }

        public DeviceDefinitionPackagingComponent setCount(int value) {
            if (this.count == null) {
                this.count = new IntegerType();
            }
            this.count.setValue((Object)value);
            return this;
        }

        public List<PackagingDistributorComponent> getDistributor() {
            if (this.distributor == null) {
                this.distributor = new ArrayList<PackagingDistributorComponent>();
            }
            return this.distributor;
        }

        public DeviceDefinitionPackagingComponent setDistributor(List<PackagingDistributorComponent> theDistributor) {
            this.distributor = theDistributor;
            return this;
        }

        public boolean hasDistributor() {
            if (this.distributor == null) {
                return false;
            }
            for (PackagingDistributorComponent item : this.distributor) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PackagingDistributorComponent addDistributor() {
            PackagingDistributorComponent t = new PackagingDistributorComponent();
            if (this.distributor == null) {
                this.distributor = new ArrayList<PackagingDistributorComponent>();
            }
            this.distributor.add(t);
            return t;
        }

        public DeviceDefinitionPackagingComponent addDistributor(PackagingDistributorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.distributor == null) {
                this.distributor = new ArrayList<PackagingDistributorComponent>();
            }
            this.distributor.add(t);
            return this;
        }

        public PackagingDistributorComponent getDistributorFirstRep() {
            if (this.getDistributor().isEmpty()) {
                this.addDistributor();
            }
            return this.getDistributor().get(0);
        }

        public List<DeviceDefinitionUdiDeviceIdentifierComponent> getUdiDeviceIdentifier() {
            if (this.udiDeviceIdentifier == null) {
                this.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
            }
            return this.udiDeviceIdentifier;
        }

        public DeviceDefinitionPackagingComponent setUdiDeviceIdentifier(List<DeviceDefinitionUdiDeviceIdentifierComponent> theUdiDeviceIdentifier) {
            this.udiDeviceIdentifier = theUdiDeviceIdentifier;
            return this;
        }

        public boolean hasUdiDeviceIdentifier() {
            if (this.udiDeviceIdentifier == null) {
                return false;
            }
            for (DeviceDefinitionUdiDeviceIdentifierComponent item : this.udiDeviceIdentifier) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent addUdiDeviceIdentifier() {
            DeviceDefinitionUdiDeviceIdentifierComponent t = new DeviceDefinitionUdiDeviceIdentifierComponent();
            if (this.udiDeviceIdentifier == null) {
                this.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
            }
            this.udiDeviceIdentifier.add(t);
            return t;
        }

        public DeviceDefinitionPackagingComponent addUdiDeviceIdentifier(DeviceDefinitionUdiDeviceIdentifierComponent t) {
            if (t == null) {
                return this;
            }
            if (this.udiDeviceIdentifier == null) {
                this.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
            }
            this.udiDeviceIdentifier.add(t);
            return this;
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent getUdiDeviceIdentifierFirstRep() {
            if (this.getUdiDeviceIdentifier().isEmpty()) {
                this.addUdiDeviceIdentifier();
            }
            return this.getUdiDeviceIdentifier().get(0);
        }

        public List<DeviceDefinitionPackagingComponent> getPackaging() {
            if (this.packaging == null) {
                this.packaging = new ArrayList<DeviceDefinitionPackagingComponent>();
            }
            return this.packaging;
        }

        public DeviceDefinitionPackagingComponent setPackaging(List<DeviceDefinitionPackagingComponent> thePackaging) {
            this.packaging = thePackaging;
            return this;
        }

        public boolean hasPackaging() {
            if (this.packaging == null) {
                return false;
            }
            for (DeviceDefinitionPackagingComponent item : this.packaging) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DeviceDefinitionPackagingComponent addPackaging() {
            DeviceDefinitionPackagingComponent t = new DeviceDefinitionPackagingComponent();
            if (this.packaging == null) {
                this.packaging = new ArrayList<DeviceDefinitionPackagingComponent>();
            }
            this.packaging.add(t);
            return t;
        }

        public DeviceDefinitionPackagingComponent addPackaging(DeviceDefinitionPackagingComponent t) {
            if (t == null) {
                return this;
            }
            if (this.packaging == null) {
                this.packaging = new ArrayList<DeviceDefinitionPackagingComponent>();
            }
            this.packaging.add(t);
            return this;
        }

        public DeviceDefinitionPackagingComponent getPackagingFirstRep() {
            if (this.getPackaging().isEmpty()) {
                this.addPackaging();
            }
            return this.getPackaging().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceDefinition.SP_IDENTIFIER, "Identifier", "The business identifier of the packaged medication.", 0, 1, this.identifier));
            children.add(new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "A code that defines the specific type of packaging.", 0, 1, this.type));
            children.add(new Property("count", "integer", "The number of items contained in the package (devices or sub-packages).", 0, 1, this.count));
            children.add(new Property("distributor", "", "An organization that distributes the packaged device.", 0, Integer.MAX_VALUE, this.distributor));
            children.add(new Property("udiDeviceIdentifier", "@DeviceDefinition.udiDeviceIdentifier", "Unique Device Identifier (UDI) Barcode string on the packaging.", 0, Integer.MAX_VALUE, this.udiDeviceIdentifier));
            children.add(new Property("packaging", "@DeviceDefinition.packaging", "Allows packages within packages.", 0, Integer.MAX_VALUE, this.packaging));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(DeviceDefinition.SP_IDENTIFIER, "Identifier", "The business identifier of the packaged medication.", 0, 1, this.identifier);
                }
                case 3575610: {
                    return new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "A code that defines the specific type of packaging.", 0, 1, this.type);
                }
                case 94851343: {
                    return new Property("count", "integer", "The number of items contained in the package (devices or sub-packages).", 0, 1, this.count);
                }
                case 1334482919: {
                    return new Property("distributor", "", "An organization that distributes the packaged device.", 0, Integer.MAX_VALUE, this.distributor);
                }
                case -99121287: {
                    return new Property("udiDeviceIdentifier", "@DeviceDefinition.udiDeviceIdentifier", "Unique Device Identifier (UDI) Barcode string on the packaging.", 0, Integer.MAX_VALUE, this.udiDeviceIdentifier);
                }
                case 1802065795: {
                    return new Property("packaging", "@DeviceDefinition.packaging", "Allows packages within packages.", 0, Integer.MAX_VALUE, this.packaging);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 94851343: {
                    Base[] baseArray;
                    if (this.count == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.count;
                    }
                    return baseArray;
                }
                case 1334482919: {
                    return this.distributor == null ? new Base[]{} : this.distributor.toArray(new Base[this.distributor.size()]);
                }
                case -99121287: {
                    return this.udiDeviceIdentifier == null ? new Base[]{} : this.udiDeviceIdentifier.toArray(new Base[this.udiDeviceIdentifier.size()]);
                }
                case 1802065795: {
                    return this.packaging == null ? new Base[]{} : this.packaging.toArray(new Base[this.packaging.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 94851343: {
                    this.count = TypeConvertor.castToInteger(value);
                    return value;
                }
                case 1334482919: {
                    this.getDistributor().add((PackagingDistributorComponent)value);
                    return value;
                }
                case -99121287: {
                    this.getUdiDeviceIdentifier().add((DeviceDefinitionUdiDeviceIdentifierComponent)value);
                    return value;
                }
                case 1802065795: {
                    this.getPackaging().add((DeviceDefinitionPackagingComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_IDENTIFIER)) {
                this.identifier = TypeConvertor.castToIdentifier(value);
            } else if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("count")) {
                this.count = TypeConvertor.castToInteger(value);
            } else if (name.equals("distributor")) {
                this.getDistributor().add((PackagingDistributorComponent)value);
            } else if (name.equals("udiDeviceIdentifier")) {
                this.getUdiDeviceIdentifier().add((DeviceDefinitionUdiDeviceIdentifierComponent)value);
            } else if (name.equals("packaging")) {
                this.getPackaging().add((DeviceDefinitionPackagingComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case 3575610: {
                    return this.getType();
                }
                case 94851343: {
                    return this.getCountElement();
                }
                case 1334482919: {
                    return this.addDistributor();
                }
                case -99121287: {
                    return this.addUdiDeviceIdentifier();
                }
                case 1802065795: {
                    return this.addPackaging();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 94851343: {
                    return new String[]{"integer"};
                }
                case 1334482919: {
                    return new String[0];
                }
                case -99121287: {
                    return new String[]{"@DeviceDefinition.udiDeviceIdentifier"};
                }
                case 1802065795: {
                    return new String[]{"@DeviceDefinition.packaging"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("count")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.packaging.count");
            }
            if (name.equals("distributor")) {
                return this.addDistributor();
            }
            if (name.equals("udiDeviceIdentifier")) {
                return this.addUdiDeviceIdentifier();
            }
            if (name.equals("packaging")) {
                return this.addPackaging();
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionPackagingComponent copy() {
            DeviceDefinitionPackagingComponent dst = new DeviceDefinitionPackagingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionPackagingComponent dst) {
            super.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.type = this.type == null ? null : this.type.copy();
            IntegerType integerType = dst.count = this.count == null ? null : this.count.copy();
            if (this.distributor != null) {
                dst.distributor = new ArrayList<PackagingDistributorComponent>();
                for (PackagingDistributorComponent packagingDistributorComponent : this.distributor) {
                    dst.distributor.add(packagingDistributorComponent.copy());
                }
            }
            if (this.udiDeviceIdentifier != null) {
                dst.udiDeviceIdentifier = new ArrayList<DeviceDefinitionUdiDeviceIdentifierComponent>();
                for (DeviceDefinitionUdiDeviceIdentifierComponent deviceDefinitionUdiDeviceIdentifierComponent : this.udiDeviceIdentifier) {
                    dst.udiDeviceIdentifier.add(deviceDefinitionUdiDeviceIdentifierComponent.copy());
                }
            }
            if (this.packaging != null) {
                dst.packaging = new ArrayList<DeviceDefinitionPackagingComponent>();
                for (DeviceDefinitionPackagingComponent deviceDefinitionPackagingComponent : this.packaging) {
                    dst.packaging.add(deviceDefinitionPackagingComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionPackagingComponent)) {
                return false;
            }
            DeviceDefinitionPackagingComponent o = (DeviceDefinitionPackagingComponent)other_;
            return DeviceDefinitionPackagingComponent.compareDeep(this.identifier, o.identifier, true) && DeviceDefinitionPackagingComponent.compareDeep(this.type, o.type, true) && DeviceDefinitionPackagingComponent.compareDeep(this.count, o.count, true) && DeviceDefinitionPackagingComponent.compareDeep(this.distributor, o.distributor, true) && DeviceDefinitionPackagingComponent.compareDeep(this.udiDeviceIdentifier, o.udiDeviceIdentifier, true) && DeviceDefinitionPackagingComponent.compareDeep(this.packaging, o.packaging, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionPackagingComponent)) {
                return false;
            }
            DeviceDefinitionPackagingComponent o = (DeviceDefinitionPackagingComponent)other_;
            return DeviceDefinitionPackagingComponent.compareValues(this.count, o.count, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.type, this.count, this.distributor, this.udiDeviceIdentifier, this.packaging);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.packaging";
        }
    }

    @Block
    public static class DeviceDefinitionHasPartComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="reference", type={DeviceDefinition.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference to the part", formalDefinition="Reference to the device that is part of the current device.")
        protected Reference reference;
        @Child(name="count", type={IntegerType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Number of occurrences of the part", formalDefinition="Number of instances of the component device in the current device.")
        protected IntegerType count;
        private static final long serialVersionUID = -1166127369L;

        public DeviceDefinitionHasPartComponent() {
        }

        public DeviceDefinitionHasPartComponent(Reference reference) {
            this.setReference(reference);
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionHasPartComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public DeviceDefinitionHasPartComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public IntegerType getCountElement() {
            if (this.count == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionHasPartComponent.count");
                }
                if (Configuration.doAutoCreate()) {
                    this.count = new IntegerType();
                }
            }
            return this.count;
        }

        public boolean hasCountElement() {
            return this.count != null && !this.count.isEmpty();
        }

        public boolean hasCount() {
            return this.count != null && !this.count.isEmpty();
        }

        public DeviceDefinitionHasPartComponent setCountElement(IntegerType value) {
            this.count = value;
            return this;
        }

        public int getCount() {
            return this.count == null || this.count.isEmpty() ? 0 : (Integer)this.count.getValue();
        }

        public DeviceDefinitionHasPartComponent setCount(int value) {
            if (this.count == null) {
                this.count = new IntegerType();
            }
            this.count.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("reference", "Reference(DeviceDefinition)", "Reference to the device that is part of the current device.", 0, 1, this.reference));
            children.add(new Property("count", "integer", "Number of instances of the component device in the current device.", 0, 1, this.count));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -925155509: {
                    return new Property("reference", "Reference(DeviceDefinition)", "Reference to the device that is part of the current device.", 0, 1, this.reference);
                }
                case 94851343: {
                    return new Property("count", "integer", "Number of instances of the component device in the current device.", 0, 1, this.count);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.reference;
                    }
                    return baseArray;
                }
                case 94851343: {
                    Base[] baseArray;
                    if (this.count == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.count;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
                case 94851343: {
                    this.count = TypeConvertor.castToInteger(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else if (name.equals("count")) {
                this.count = TypeConvertor.castToInteger(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.getReference();
                }
                case 94851343: {
                    return this.getCountElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return new String[]{"Reference"};
                }
                case 94851343: {
                    return new String[]{"integer"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals("count")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.hasPart.count");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionHasPartComponent copy() {
            DeviceDefinitionHasPartComponent dst = new DeviceDefinitionHasPartComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionHasPartComponent dst) {
            super.copyValues(dst);
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.count = this.count == null ? null : this.count.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionHasPartComponent)) {
                return false;
            }
            DeviceDefinitionHasPartComponent o = (DeviceDefinitionHasPartComponent)other_;
            return DeviceDefinitionHasPartComponent.compareDeep(this.reference, o.reference, true) && DeviceDefinitionHasPartComponent.compareDeep(this.count, o.count, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionHasPartComponent)) {
                return false;
            }
            DeviceDefinitionHasPartComponent o = (DeviceDefinitionHasPartComponent)other_;
            return DeviceDefinitionHasPartComponent.compareValues(this.count, o.count, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.reference, this.count);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.hasPart";
        }
    }

    @Block
    public static class DeviceDefinitionClassificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A classification or risk class of the device model", formalDefinition="A classification or risk class of the device model.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-type")
        protected CodeableConcept type;
        @Child(name="justification", type={RelatedArtifact.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Further information qualifying this classification of the device model", formalDefinition="Further information qualifying this classification of the device model.")
        protected List<RelatedArtifact> justification;
        private static final long serialVersionUID = -1343788026L;

        public DeviceDefinitionClassificationComponent() {
        }

        public DeviceDefinitionClassificationComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionClassificationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDefinitionClassificationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<RelatedArtifact> getJustification() {
            if (this.justification == null) {
                this.justification = new ArrayList<RelatedArtifact>();
            }
            return this.justification;
        }

        public DeviceDefinitionClassificationComponent setJustification(List<RelatedArtifact> theJustification) {
            this.justification = theJustification;
            return this;
        }

        public boolean hasJustification() {
            if (this.justification == null) {
                return false;
            }
            for (RelatedArtifact item : this.justification) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public RelatedArtifact addJustification() {
            RelatedArtifact t = new RelatedArtifact();
            if (this.justification == null) {
                this.justification = new ArrayList<RelatedArtifact>();
            }
            this.justification.add(t);
            return t;
        }

        public DeviceDefinitionClassificationComponent addJustification(RelatedArtifact t) {
            if (t == null) {
                return this;
            }
            if (this.justification == null) {
                this.justification = new ArrayList<RelatedArtifact>();
            }
            this.justification.add(t);
            return this;
        }

        public RelatedArtifact getJustificationFirstRep() {
            if (this.getJustification().isEmpty()) {
                this.addJustification();
            }
            return this.getJustification().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "A classification or risk class of the device model.", 0, 1, this.type));
            children.add(new Property("justification", "RelatedArtifact", "Further information qualifying this classification of the device model.", 0, Integer.MAX_VALUE, this.justification));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(DeviceDefinition.SP_TYPE, "CodeableConcept", "A classification or risk class of the device model.", 0, 1, this.type);
                }
                case 1864993522: {
                    return new Property("justification", "RelatedArtifact", "Further information qualifying this classification of the device model.", 0, Integer.MAX_VALUE, this.justification);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1864993522: {
                    return this.justification == null ? new Base[]{} : this.justification.toArray(new Base[this.justification.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1864993522: {
                    this.getJustification().add(TypeConvertor.castToRelatedArtifact(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("justification")) {
                this.getJustification().add(TypeConvertor.castToRelatedArtifact(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 1864993522: {
                    return this.addJustification();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 1864993522: {
                    return new String[]{"RelatedArtifact"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("justification")) {
                return this.addJustification();
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionClassificationComponent copy() {
            DeviceDefinitionClassificationComponent dst = new DeviceDefinitionClassificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionClassificationComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.justification != null) {
                dst.justification = new ArrayList<RelatedArtifact>();
                for (RelatedArtifact i2 : this.justification) {
                    dst.justification.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionClassificationComponent)) {
                return false;
            }
            DeviceDefinitionClassificationComponent o = (DeviceDefinitionClassificationComponent)other_;
            return DeviceDefinitionClassificationComponent.compareDeep(this.type, o.type, true) && DeviceDefinitionClassificationComponent.compareDeep(this.justification, o.justification, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionClassificationComponent)) {
                return false;
            }
            DeviceDefinitionClassificationComponent o = (DeviceDefinitionClassificationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.justification);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.classification";
        }
    }

    @Block
    public static class DeviceDefinitionDeviceNameComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name that is used to refer to the device", formalDefinition="A human-friendly name that is used to refer to the device - depending on the type, it can be the brand name, the common name or alias, or other.")
        protected StringType name;
        @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="registered-name | user-friendly-name | patient-reported-name", formalDefinition="The type of deviceName.\nRegisteredName | UserFriendlyName | PatientReportedName.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/device-nametype")
        protected Enumeration<Enumerations.DeviceNameType> type;
        private static final long serialVersionUID = 918983440L;

        public DeviceDefinitionDeviceNameComponent() {
        }

        public DeviceDefinitionDeviceNameComponent(String name, Enumerations.DeviceNameType type) {
            this.setName(name);
            this.setType(type);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionDeviceNameComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public DeviceDefinitionDeviceNameComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public DeviceDefinitionDeviceNameComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public Enumeration<Enumerations.DeviceNameType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionDeviceNameComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.DeviceNameType>(new Enumerations.DeviceNameTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDefinitionDeviceNameComponent setTypeElement(Enumeration<Enumerations.DeviceNameType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.DeviceNameType getType() {
            return this.type == null ? null : (Enumerations.DeviceNameType)((Object)this.type.getValue());
        }

        public DeviceDefinitionDeviceNameComponent setType(Enumerations.DeviceNameType value) {
            if (this.type == null) {
                this.type = new Enumeration<Enumerations.DeviceNameType>(new Enumerations.DeviceNameTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "A human-friendly name that is used to refer to the device - depending on the type, it can be the brand name, the common name or alias, or other.", 0, 1, this.name));
            children.add(new Property(DeviceDefinition.SP_TYPE, "code", "The type of deviceName.\nRegisteredName | UserFriendlyName | PatientReportedName.", 0, 1, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "A human-friendly name that is used to refer to the device - depending on the type, it can be the brand name, the common name or alias, or other.", 0, 1, this.name);
                }
                case 3575610: {
                    return new Property(DeviceDefinition.SP_TYPE, "code", "The type of deviceName.\nRegisteredName | UserFriendlyName | PatientReportedName.", 0, 1, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 3575610: {
                    value = new Enumerations.DeviceNameTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals(DeviceDefinition.SP_TYPE)) {
                value = new Enumerations.DeviceNameTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3575610: {
                    return this.getTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.deviceName.name");
            }
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.deviceName.type");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionDeviceNameComponent copy() {
            DeviceDefinitionDeviceNameComponent dst = new DeviceDefinitionDeviceNameComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionDeviceNameComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.type = this.type == null ? null : this.type.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionDeviceNameComponent)) {
                return false;
            }
            DeviceDefinitionDeviceNameComponent o = (DeviceDefinitionDeviceNameComponent)other_;
            return DeviceDefinitionDeviceNameComponent.compareDeep(this.name, o.name, true) && DeviceDefinitionDeviceNameComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionDeviceNameComponent)) {
                return false;
            }
            DeviceDefinitionDeviceNameComponent o = (DeviceDefinitionDeviceNameComponent)other_;
            return DeviceDefinitionDeviceNameComponent.compareValues(this.name, o.name, true) && DeviceDefinitionDeviceNameComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.name, this.type);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.deviceName";
        }
    }

    @Block
    public static class DeviceDefinitionRegulatoryIdentifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="basic | master | license", formalDefinition="The type of identifier itself.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/devicedefinition-regulatory-identifier-type")
        protected Enumeration<DeviceDefinitionRegulatoryIdentifierType> type;
        @Child(name="deviceIdentifier", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The identifier itself", formalDefinition="The identifier itself.")
        protected StringType deviceIdentifier;
        @Child(name="issuer", type={UriType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The organization that issued this identifier", formalDefinition="The organization that issued this identifier.")
        protected UriType issuer;
        @Child(name="jurisdiction", type={UriType.class}, order=4, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The jurisdiction to which the deviceIdentifier applies", formalDefinition="The jurisdiction to which the deviceIdentifier applies.")
        protected UriType jurisdiction;
        private static final long serialVersionUID = 1438058623L;

        public DeviceDefinitionRegulatoryIdentifierComponent() {
        }

        public DeviceDefinitionRegulatoryIdentifierComponent(DeviceDefinitionRegulatoryIdentifierType type, String deviceIdentifier, String issuer, String jurisdiction) {
            this.setType(type);
            this.setDeviceIdentifier(deviceIdentifier);
            this.setIssuer(issuer);
            this.setJurisdiction(jurisdiction);
        }

        public Enumeration<DeviceDefinitionRegulatoryIdentifierType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionRegulatoryIdentifierComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<DeviceDefinitionRegulatoryIdentifierType>(new DeviceDefinitionRegulatoryIdentifierTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public DeviceDefinitionRegulatoryIdentifierComponent setTypeElement(Enumeration<DeviceDefinitionRegulatoryIdentifierType> value) {
            this.type = value;
            return this;
        }

        public DeviceDefinitionRegulatoryIdentifierType getType() {
            return this.type == null ? null : (DeviceDefinitionRegulatoryIdentifierType)((Object)this.type.getValue());
        }

        public DeviceDefinitionRegulatoryIdentifierComponent setType(DeviceDefinitionRegulatoryIdentifierType value) {
            if (this.type == null) {
                this.type = new Enumeration<DeviceDefinitionRegulatoryIdentifierType>(new DeviceDefinitionRegulatoryIdentifierTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public StringType getDeviceIdentifierElement() {
            if (this.deviceIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionRegulatoryIdentifierComponent.deviceIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.deviceIdentifier = new StringType();
                }
            }
            return this.deviceIdentifier;
        }

        public boolean hasDeviceIdentifierElement() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public boolean hasDeviceIdentifier() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public DeviceDefinitionRegulatoryIdentifierComponent setDeviceIdentifierElement(StringType value) {
            this.deviceIdentifier = value;
            return this;
        }

        public String getDeviceIdentifier() {
            return this.deviceIdentifier == null ? null : (String)this.deviceIdentifier.getValue();
        }

        public DeviceDefinitionRegulatoryIdentifierComponent setDeviceIdentifier(String value) {
            if (this.deviceIdentifier == null) {
                this.deviceIdentifier = new StringType();
            }
            this.deviceIdentifier.setValue(value);
            return this;
        }

        public UriType getIssuerElement() {
            if (this.issuer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionRegulatoryIdentifierComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuer = new UriType();
                }
            }
            return this.issuer;
        }

        public boolean hasIssuerElement() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public boolean hasIssuer() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public DeviceDefinitionRegulatoryIdentifierComponent setIssuerElement(UriType value) {
            this.issuer = value;
            return this;
        }

        public String getIssuer() {
            return this.issuer == null ? null : (String)this.issuer.getValue();
        }

        public DeviceDefinitionRegulatoryIdentifierComponent setIssuer(String value) {
            if (this.issuer == null) {
                this.issuer = new UriType();
            }
            this.issuer.setValue(value);
            return this;
        }

        public UriType getJurisdictionElement() {
            if (this.jurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionRegulatoryIdentifierComponent.jurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.jurisdiction = new UriType();
                }
            }
            return this.jurisdiction;
        }

        public boolean hasJurisdictionElement() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public boolean hasJurisdiction() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public DeviceDefinitionRegulatoryIdentifierComponent setJurisdictionElement(UriType value) {
            this.jurisdiction = value;
            return this;
        }

        public String getJurisdiction() {
            return this.jurisdiction == null ? null : (String)this.jurisdiction.getValue();
        }

        public DeviceDefinitionRegulatoryIdentifierComponent setJurisdiction(String value) {
            if (this.jurisdiction == null) {
                this.jurisdiction = new UriType();
            }
            this.jurisdiction.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(DeviceDefinition.SP_TYPE, "code", "The type of identifier itself.", 0, 1, this.type));
            children.add(new Property("deviceIdentifier", "string", "The identifier itself.", 0, 1, this.deviceIdentifier));
            children.add(new Property("issuer", "uri", "The organization that issued this identifier.", 0, 1, this.issuer));
            children.add(new Property("jurisdiction", "uri", "The jurisdiction to which the deviceIdentifier applies.", 0, 1, this.jurisdiction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(DeviceDefinition.SP_TYPE, "code", "The type of identifier itself.", 0, 1, this.type);
                }
                case 1322005407: {
                    return new Property("deviceIdentifier", "string", "The identifier itself.", 0, 1, this.deviceIdentifier);
                }
                case -1179159879: {
                    return new Property("issuer", "uri", "The organization that issued this identifier.", 0, 1, this.issuer);
                }
                case -507075711: {
                    return new Property("jurisdiction", "uri", "The jurisdiction to which the deviceIdentifier applies.", 0, 1, this.jurisdiction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 1322005407: {
                    Base[] baseArray;
                    if (this.deviceIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.deviceIdentifier;
                    }
                    return baseArray;
                }
                case -1179159879: {
                    Base[] baseArray;
                    if (this.issuer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.issuer;
                    }
                    return baseArray;
                }
                case -507075711: {
                    Base[] baseArray;
                    if (this.jurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.jurisdiction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new DeviceDefinitionRegulatoryIdentifierTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 1322005407: {
                    this.deviceIdentifier = TypeConvertor.castToString(value);
                    return value;
                }
                case -1179159879: {
                    this.issuer = TypeConvertor.castToUri(value);
                    return value;
                }
                case -507075711: {
                    this.jurisdiction = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                value = new DeviceDefinitionRegulatoryIdentifierTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("deviceIdentifier")) {
                this.deviceIdentifier = TypeConvertor.castToString(value);
            } else if (name.equals("issuer")) {
                this.issuer = TypeConvertor.castToUri(value);
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 1322005407: {
                    return this.getDeviceIdentifierElement();
                }
                case -1179159879: {
                    return this.getIssuerElement();
                }
                case -507075711: {
                    return this.getJurisdictionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 1322005407: {
                    return new String[]{"string"};
                }
                case -1179159879: {
                    return new String[]{"uri"};
                }
                case -507075711: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DeviceDefinition.SP_TYPE)) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.regulatoryIdentifier.type");
            }
            if (name.equals("deviceIdentifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.regulatoryIdentifier.deviceIdentifier");
            }
            if (name.equals("issuer")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.regulatoryIdentifier.issuer");
            }
            if (name.equals("jurisdiction")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.regulatoryIdentifier.jurisdiction");
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionRegulatoryIdentifierComponent copy() {
            DeviceDefinitionRegulatoryIdentifierComponent dst = new DeviceDefinitionRegulatoryIdentifierComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionRegulatoryIdentifierComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.deviceIdentifier = this.deviceIdentifier == null ? null : this.deviceIdentifier.copy();
            dst.issuer = this.issuer == null ? null : this.issuer.copy();
            dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionRegulatoryIdentifierComponent)) {
                return false;
            }
            DeviceDefinitionRegulatoryIdentifierComponent o = (DeviceDefinitionRegulatoryIdentifierComponent)other_;
            return DeviceDefinitionRegulatoryIdentifierComponent.compareDeep(this.type, o.type, true) && DeviceDefinitionRegulatoryIdentifierComponent.compareDeep(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceDefinitionRegulatoryIdentifierComponent.compareDeep(this.issuer, o.issuer, true) && DeviceDefinitionRegulatoryIdentifierComponent.compareDeep(this.jurisdiction, o.jurisdiction, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionRegulatoryIdentifierComponent)) {
                return false;
            }
            DeviceDefinitionRegulatoryIdentifierComponent o = (DeviceDefinitionRegulatoryIdentifierComponent)other_;
            return DeviceDefinitionRegulatoryIdentifierComponent.compareValues(this.type, o.type, true) && DeviceDefinitionRegulatoryIdentifierComponent.compareValues(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceDefinitionRegulatoryIdentifierComponent.compareValues(this.issuer, o.issuer, true) && DeviceDefinitionRegulatoryIdentifierComponent.compareValues(this.jurisdiction, o.jurisdiction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.deviceIdentifier, this.issuer, this.jurisdiction);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.regulatoryIdentifier";
        }
    }

    @Block
    public static class UdiDeviceIdentifierMarketDistributionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="marketPeriod", type={Period.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Begin and end dates for the commercial distribution of the device", formalDefinition="Begin and end dates for the commercial distribution of the device.")
        protected Period marketPeriod;
        @Child(name="subJurisdiction", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="National state or territory where the device is commercialized", formalDefinition="National state or territory to which the marketDistribution recers, typically where the device is commercialized.")
        protected UriType subJurisdiction;
        private static final long serialVersionUID = -1459036847L;

        public UdiDeviceIdentifierMarketDistributionComponent() {
        }

        public UdiDeviceIdentifierMarketDistributionComponent(Period marketPeriod, String subJurisdiction) {
            this.setMarketPeriod(marketPeriod);
            this.setSubJurisdiction(subJurisdiction);
        }

        public Period getMarketPeriod() {
            if (this.marketPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create UdiDeviceIdentifierMarketDistributionComponent.marketPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.marketPeriod = new Period();
                }
            }
            return this.marketPeriod;
        }

        public boolean hasMarketPeriod() {
            return this.marketPeriod != null && !this.marketPeriod.isEmpty();
        }

        public UdiDeviceIdentifierMarketDistributionComponent setMarketPeriod(Period value) {
            this.marketPeriod = value;
            return this;
        }

        public UriType getSubJurisdictionElement() {
            if (this.subJurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create UdiDeviceIdentifierMarketDistributionComponent.subJurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.subJurisdiction = new UriType();
                }
            }
            return this.subJurisdiction;
        }

        public boolean hasSubJurisdictionElement() {
            return this.subJurisdiction != null && !this.subJurisdiction.isEmpty();
        }

        public boolean hasSubJurisdiction() {
            return this.subJurisdiction != null && !this.subJurisdiction.isEmpty();
        }

        public UdiDeviceIdentifierMarketDistributionComponent setSubJurisdictionElement(UriType value) {
            this.subJurisdiction = value;
            return this;
        }

        public String getSubJurisdiction() {
            return this.subJurisdiction == null ? null : (String)this.subJurisdiction.getValue();
        }

        public UdiDeviceIdentifierMarketDistributionComponent setSubJurisdiction(String value) {
            if (this.subJurisdiction == null) {
                this.subJurisdiction = new UriType();
            }
            this.subJurisdiction.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("marketPeriod", "Period", "Begin and end dates for the commercial distribution of the device.", 0, 1, this.marketPeriod));
            children.add(new Property("subJurisdiction", "uri", "National state or territory to which the marketDistribution recers, typically where the device is commercialized.", 0, 1, this.subJurisdiction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -183772899: {
                    return new Property("marketPeriod", "Period", "Begin and end dates for the commercial distribution of the device.", 0, 1, this.marketPeriod);
                }
                case -777497119: {
                    return new Property("subJurisdiction", "uri", "National state or territory to which the marketDistribution recers, typically where the device is commercialized.", 0, 1, this.subJurisdiction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -183772899: {
                    Base[] baseArray;
                    if (this.marketPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.marketPeriod;
                    }
                    return baseArray;
                }
                case -777497119: {
                    Base[] baseArray;
                    if (this.subJurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.subJurisdiction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -183772899: {
                    this.marketPeriod = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case -777497119: {
                    this.subJurisdiction = TypeConvertor.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("marketPeriod")) {
                this.marketPeriod = TypeConvertor.castToPeriod(value);
            } else if (name.equals("subJurisdiction")) {
                this.subJurisdiction = TypeConvertor.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -183772899: {
                    return this.getMarketPeriod();
                }
                case -777497119: {
                    return this.getSubJurisdictionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -183772899: {
                    return new String[]{"Period"};
                }
                case -777497119: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("marketPeriod")) {
                this.marketPeriod = new Period();
                return this.marketPeriod;
            }
            if (name.equals("subJurisdiction")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.udiDeviceIdentifier.marketDistribution.subJurisdiction");
            }
            return super.addChild(name);
        }

        @Override
        public UdiDeviceIdentifierMarketDistributionComponent copy() {
            UdiDeviceIdentifierMarketDistributionComponent dst = new UdiDeviceIdentifierMarketDistributionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(UdiDeviceIdentifierMarketDistributionComponent dst) {
            super.copyValues(dst);
            dst.marketPeriod = this.marketPeriod == null ? null : this.marketPeriod.copy();
            dst.subJurisdiction = this.subJurisdiction == null ? null : this.subJurisdiction.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof UdiDeviceIdentifierMarketDistributionComponent)) {
                return false;
            }
            UdiDeviceIdentifierMarketDistributionComponent o = (UdiDeviceIdentifierMarketDistributionComponent)other_;
            return UdiDeviceIdentifierMarketDistributionComponent.compareDeep(this.marketPeriod, o.marketPeriod, true) && UdiDeviceIdentifierMarketDistributionComponent.compareDeep(this.subJurisdiction, o.subJurisdiction, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof UdiDeviceIdentifierMarketDistributionComponent)) {
                return false;
            }
            UdiDeviceIdentifierMarketDistributionComponent o = (UdiDeviceIdentifierMarketDistributionComponent)other_;
            return UdiDeviceIdentifierMarketDistributionComponent.compareValues(this.subJurisdiction, o.subJurisdiction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.marketPeriod, this.subJurisdiction);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.udiDeviceIdentifier.marketDistribution";
        }
    }

    @Block
    public static class DeviceDefinitionUdiDeviceIdentifierComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="deviceIdentifier", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The identifier that is to be associated with every Device that references this DeviceDefintiion for the issuer and jurisdiction provided in the DeviceDefinition.udiDeviceIdentifier", formalDefinition="The identifier that is to be associated with every Device that references this DeviceDefintiion for the issuer and jurisdiction provided in the DeviceDefinition.udiDeviceIdentifier.")
        protected StringType deviceIdentifier;
        @Child(name="issuer", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The organization that assigns the identifier algorithm", formalDefinition="The organization that assigns the identifier algorithm.")
        protected UriType issuer;
        @Child(name="jurisdiction", type={UriType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The jurisdiction to which the deviceIdentifier applies", formalDefinition="The jurisdiction to which the deviceIdentifier applies.")
        protected UriType jurisdiction;
        @Child(name="marketDistribution", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Indicates whether and when the device is available on the market", formalDefinition="Indicates where and when the device is available on the market.")
        protected List<UdiDeviceIdentifierMarketDistributionComponent> marketDistribution;
        private static final long serialVersionUID = -1819796108L;

        public DeviceDefinitionUdiDeviceIdentifierComponent() {
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent(String deviceIdentifier, String issuer, String jurisdiction) {
            this.setDeviceIdentifier(deviceIdentifier);
            this.setIssuer(issuer);
            this.setJurisdiction(jurisdiction);
        }

        public StringType getDeviceIdentifierElement() {
            if (this.deviceIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionUdiDeviceIdentifierComponent.deviceIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.deviceIdentifier = new StringType();
                }
            }
            return this.deviceIdentifier;
        }

        public boolean hasDeviceIdentifierElement() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public boolean hasDeviceIdentifier() {
            return this.deviceIdentifier != null && !this.deviceIdentifier.isEmpty();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setDeviceIdentifierElement(StringType value) {
            this.deviceIdentifier = value;
            return this;
        }

        public String getDeviceIdentifier() {
            return this.deviceIdentifier == null ? null : (String)this.deviceIdentifier.getValue();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setDeviceIdentifier(String value) {
            if (this.deviceIdentifier == null) {
                this.deviceIdentifier = new StringType();
            }
            this.deviceIdentifier.setValue(value);
            return this;
        }

        public UriType getIssuerElement() {
            if (this.issuer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionUdiDeviceIdentifierComponent.issuer");
                }
                if (Configuration.doAutoCreate()) {
                    this.issuer = new UriType();
                }
            }
            return this.issuer;
        }

        public boolean hasIssuerElement() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public boolean hasIssuer() {
            return this.issuer != null && !this.issuer.isEmpty();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setIssuerElement(UriType value) {
            this.issuer = value;
            return this;
        }

        public String getIssuer() {
            return this.issuer == null ? null : (String)this.issuer.getValue();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setIssuer(String value) {
            if (this.issuer == null) {
                this.issuer = new UriType();
            }
            this.issuer.setValue(value);
            return this;
        }

        public UriType getJurisdictionElement() {
            if (this.jurisdiction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DeviceDefinitionUdiDeviceIdentifierComponent.jurisdiction");
                }
                if (Configuration.doAutoCreate()) {
                    this.jurisdiction = new UriType();
                }
            }
            return this.jurisdiction;
        }

        public boolean hasJurisdictionElement() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public boolean hasJurisdiction() {
            return this.jurisdiction != null && !this.jurisdiction.isEmpty();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setJurisdictionElement(UriType value) {
            this.jurisdiction = value;
            return this;
        }

        public String getJurisdiction() {
            return this.jurisdiction == null ? null : (String)this.jurisdiction.getValue();
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setJurisdiction(String value) {
            if (this.jurisdiction == null) {
                this.jurisdiction = new UriType();
            }
            this.jurisdiction.setValue(value);
            return this;
        }

        public List<UdiDeviceIdentifierMarketDistributionComponent> getMarketDistribution() {
            if (this.marketDistribution == null) {
                this.marketDistribution = new ArrayList<UdiDeviceIdentifierMarketDistributionComponent>();
            }
            return this.marketDistribution;
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent setMarketDistribution(List<UdiDeviceIdentifierMarketDistributionComponent> theMarketDistribution) {
            this.marketDistribution = theMarketDistribution;
            return this;
        }

        public boolean hasMarketDistribution() {
            if (this.marketDistribution == null) {
                return false;
            }
            for (UdiDeviceIdentifierMarketDistributionComponent item : this.marketDistribution) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UdiDeviceIdentifierMarketDistributionComponent addMarketDistribution() {
            UdiDeviceIdentifierMarketDistributionComponent t = new UdiDeviceIdentifierMarketDistributionComponent();
            if (this.marketDistribution == null) {
                this.marketDistribution = new ArrayList<UdiDeviceIdentifierMarketDistributionComponent>();
            }
            this.marketDistribution.add(t);
            return t;
        }

        public DeviceDefinitionUdiDeviceIdentifierComponent addMarketDistribution(UdiDeviceIdentifierMarketDistributionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.marketDistribution == null) {
                this.marketDistribution = new ArrayList<UdiDeviceIdentifierMarketDistributionComponent>();
            }
            this.marketDistribution.add(t);
            return this;
        }

        public UdiDeviceIdentifierMarketDistributionComponent getMarketDistributionFirstRep() {
            if (this.getMarketDistribution().isEmpty()) {
                this.addMarketDistribution();
            }
            return this.getMarketDistribution().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("deviceIdentifier", "string", "The identifier that is to be associated with every Device that references this DeviceDefintiion for the issuer and jurisdiction provided in the DeviceDefinition.udiDeviceIdentifier.", 0, 1, this.deviceIdentifier));
            children.add(new Property("issuer", "uri", "The organization that assigns the identifier algorithm.", 0, 1, this.issuer));
            children.add(new Property("jurisdiction", "uri", "The jurisdiction to which the deviceIdentifier applies.", 0, 1, this.jurisdiction));
            children.add(new Property("marketDistribution", "", "Indicates where and when the device is available on the market.", 0, Integer.MAX_VALUE, this.marketDistribution));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1322005407: {
                    return new Property("deviceIdentifier", "string", "The identifier that is to be associated with every Device that references this DeviceDefintiion for the issuer and jurisdiction provided in the DeviceDefinition.udiDeviceIdentifier.", 0, 1, this.deviceIdentifier);
                }
                case -1179159879: {
                    return new Property("issuer", "uri", "The organization that assigns the identifier algorithm.", 0, 1, this.issuer);
                }
                case -507075711: {
                    return new Property("jurisdiction", "uri", "The jurisdiction to which the deviceIdentifier applies.", 0, 1, this.jurisdiction);
                }
                case 530037984: {
                    return new Property("marketDistribution", "", "Indicates where and when the device is available on the market.", 0, Integer.MAX_VALUE, this.marketDistribution);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    Base[] baseArray;
                    if (this.deviceIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.deviceIdentifier;
                    }
                    return baseArray;
                }
                case -1179159879: {
                    Base[] baseArray;
                    if (this.issuer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.issuer;
                    }
                    return baseArray;
                }
                case -507075711: {
                    Base[] baseArray;
                    if (this.jurisdiction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.jurisdiction;
                    }
                    return baseArray;
                }
                case 530037984: {
                    return this.marketDistribution == null ? new Base[]{} : this.marketDistribution.toArray(new Base[this.marketDistribution.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    this.deviceIdentifier = TypeConvertor.castToString(value);
                    return value;
                }
                case -1179159879: {
                    this.issuer = TypeConvertor.castToUri(value);
                    return value;
                }
                case -507075711: {
                    this.jurisdiction = TypeConvertor.castToUri(value);
                    return value;
                }
                case 530037984: {
                    this.getMarketDistribution().add((UdiDeviceIdentifierMarketDistributionComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                this.deviceIdentifier = TypeConvertor.castToString(value);
            } else if (name.equals("issuer")) {
                this.issuer = TypeConvertor.castToUri(value);
            } else if (name.equals("jurisdiction")) {
                this.jurisdiction = TypeConvertor.castToUri(value);
            } else if (name.equals("marketDistribution")) {
                this.getMarketDistribution().add((UdiDeviceIdentifierMarketDistributionComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    return this.getDeviceIdentifierElement();
                }
                case -1179159879: {
                    return this.getIssuerElement();
                }
                case -507075711: {
                    return this.getJurisdictionElement();
                }
                case 530037984: {
                    return this.addMarketDistribution();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1322005407: {
                    return new String[]{"string"};
                }
                case -1179159879: {
                    return new String[]{"uri"};
                }
                case -507075711: {
                    return new String[]{"uri"};
                }
                case 530037984: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("deviceIdentifier")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.udiDeviceIdentifier.deviceIdentifier");
            }
            if (name.equals("issuer")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.udiDeviceIdentifier.issuer");
            }
            if (name.equals("jurisdiction")) {
                throw new FHIRException("Cannot call addChild on a primitive type DeviceDefinition.udiDeviceIdentifier.jurisdiction");
            }
            if (name.equals("marketDistribution")) {
                return this.addMarketDistribution();
            }
            return super.addChild(name);
        }

        @Override
        public DeviceDefinitionUdiDeviceIdentifierComponent copy() {
            DeviceDefinitionUdiDeviceIdentifierComponent dst = new DeviceDefinitionUdiDeviceIdentifierComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DeviceDefinitionUdiDeviceIdentifierComponent dst) {
            super.copyValues(dst);
            dst.deviceIdentifier = this.deviceIdentifier == null ? null : this.deviceIdentifier.copy();
            dst.issuer = this.issuer == null ? null : this.issuer.copy();
            UriType uriType = dst.jurisdiction = this.jurisdiction == null ? null : this.jurisdiction.copy();
            if (this.marketDistribution != null) {
                dst.marketDistribution = new ArrayList<UdiDeviceIdentifierMarketDistributionComponent>();
                for (UdiDeviceIdentifierMarketDistributionComponent i2 : this.marketDistribution) {
                    dst.marketDistribution.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionUdiDeviceIdentifierComponent)) {
                return false;
            }
            DeviceDefinitionUdiDeviceIdentifierComponent o = (DeviceDefinitionUdiDeviceIdentifierComponent)other_;
            return DeviceDefinitionUdiDeviceIdentifierComponent.compareDeep(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceDefinitionUdiDeviceIdentifierComponent.compareDeep(this.issuer, o.issuer, true) && DeviceDefinitionUdiDeviceIdentifierComponent.compareDeep(this.jurisdiction, o.jurisdiction, true) && DeviceDefinitionUdiDeviceIdentifierComponent.compareDeep(this.marketDistribution, o.marketDistribution, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DeviceDefinitionUdiDeviceIdentifierComponent)) {
                return false;
            }
            DeviceDefinitionUdiDeviceIdentifierComponent o = (DeviceDefinitionUdiDeviceIdentifierComponent)other_;
            return DeviceDefinitionUdiDeviceIdentifierComponent.compareValues(this.deviceIdentifier, o.deviceIdentifier, true) && DeviceDefinitionUdiDeviceIdentifierComponent.compareValues(this.issuer, o.issuer, true) && DeviceDefinitionUdiDeviceIdentifierComponent.compareValues(this.jurisdiction, o.jurisdiction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.deviceIdentifier, this.issuer, this.jurisdiction, this.marketDistribution);
        }

        @Override
        public String fhirType() {
            return "DeviceDefinition.udiDeviceIdentifier";
        }
    }

    public static class DeviceProductionIdentifierInUDIEnumFactory
    implements EnumFactory<DeviceProductionIdentifierInUDI> {
        @Override
        public DeviceProductionIdentifierInUDI fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("lot-number".equals(codeString)) {
                return DeviceProductionIdentifierInUDI.LOTNUMBER;
            }
            if ("manufactured-date".equals(codeString)) {
                return DeviceProductionIdentifierInUDI.MANUFACTUREDDATE;
            }
            if ("serial-number".equals(codeString)) {
                return DeviceProductionIdentifierInUDI.SERIALNUMBER;
            }
            if ("expiration-date".equals(codeString)) {
                return DeviceProductionIdentifierInUDI.EXPIRATIONDATE;
            }
            if ("biological-source".equals(codeString)) {
                return DeviceProductionIdentifierInUDI.BIOLOGICALSOURCE;
            }
            if ("software-version".equals(codeString)) {
                return DeviceProductionIdentifierInUDI.SOFTWAREVERSION;
            }
            throw new IllegalArgumentException("Unknown DeviceProductionIdentifierInUDI code '" + codeString + "'");
        }

        public Enumeration<DeviceProductionIdentifierInUDI> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceProductionIdentifierInUDI>(this, DeviceProductionIdentifierInUDI.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DeviceProductionIdentifierInUDI>(this, DeviceProductionIdentifierInUDI.NULL, code);
            }
            if ("lot-number".equals(codeString)) {
                return new Enumeration<DeviceProductionIdentifierInUDI>(this, DeviceProductionIdentifierInUDI.LOTNUMBER, code);
            }
            if ("manufactured-date".equals(codeString)) {
                return new Enumeration<DeviceProductionIdentifierInUDI>(this, DeviceProductionIdentifierInUDI.MANUFACTUREDDATE, code);
            }
            if ("serial-number".equals(codeString)) {
                return new Enumeration<DeviceProductionIdentifierInUDI>(this, DeviceProductionIdentifierInUDI.SERIALNUMBER, code);
            }
            if ("expiration-date".equals(codeString)) {
                return new Enumeration<DeviceProductionIdentifierInUDI>(this, DeviceProductionIdentifierInUDI.EXPIRATIONDATE, code);
            }
            if ("biological-source".equals(codeString)) {
                return new Enumeration<DeviceProductionIdentifierInUDI>(this, DeviceProductionIdentifierInUDI.BIOLOGICALSOURCE, code);
            }
            if ("software-version".equals(codeString)) {
                return new Enumeration<DeviceProductionIdentifierInUDI>(this, DeviceProductionIdentifierInUDI.SOFTWAREVERSION, code);
            }
            throw new FHIRException("Unknown DeviceProductionIdentifierInUDI code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceProductionIdentifierInUDI code) {
            if (code == DeviceProductionIdentifierInUDI.LOTNUMBER) {
                return "lot-number";
            }
            if (code == DeviceProductionIdentifierInUDI.MANUFACTUREDDATE) {
                return "manufactured-date";
            }
            if (code == DeviceProductionIdentifierInUDI.SERIALNUMBER) {
                return "serial-number";
            }
            if (code == DeviceProductionIdentifierInUDI.EXPIRATIONDATE) {
                return "expiration-date";
            }
            if (code == DeviceProductionIdentifierInUDI.BIOLOGICALSOURCE) {
                return "biological-source";
            }
            if (code == DeviceProductionIdentifierInUDI.SOFTWAREVERSION) {
                return "software-version";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceProductionIdentifierInUDI code) {
            return code.getSystem();
        }
    }

    public static enum DeviceProductionIdentifierInUDI {
        LOTNUMBER,
        MANUFACTUREDDATE,
        SERIALNUMBER,
        EXPIRATIONDATE,
        BIOLOGICALSOURCE,
        SOFTWAREVERSION,
        NULL;


        public static DeviceProductionIdentifierInUDI fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("lot-number".equals(codeString)) {
                return LOTNUMBER;
            }
            if ("manufactured-date".equals(codeString)) {
                return MANUFACTUREDDATE;
            }
            if ("serial-number".equals(codeString)) {
                return SERIALNUMBER;
            }
            if ("expiration-date".equals(codeString)) {
                return EXPIRATIONDATE;
            }
            if ("biological-source".equals(codeString)) {
                return BIOLOGICALSOURCE;
            }
            if ("software-version".equals(codeString)) {
                return SOFTWAREVERSION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceProductionIdentifierInUDI code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case LOTNUMBER: {
                    return "lot-number";
                }
                case MANUFACTUREDDATE: {
                    return "manufactured-date";
                }
                case SERIALNUMBER: {
                    return "serial-number";
                }
                case EXPIRATIONDATE: {
                    return "expiration-date";
                }
                case BIOLOGICALSOURCE: {
                    return "biological-source";
                }
                case SOFTWAREVERSION: {
                    return "software-version";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case LOTNUMBER: {
                    return "http://hl7.org/fhir/device-productidentifierinudi";
                }
                case MANUFACTUREDDATE: {
                    return "http://hl7.org/fhir/device-productidentifierinudi";
                }
                case SERIALNUMBER: {
                    return "http://hl7.org/fhir/device-productidentifierinudi";
                }
                case EXPIRATIONDATE: {
                    return "http://hl7.org/fhir/device-productidentifierinudi";
                }
                case BIOLOGICALSOURCE: {
                    return "http://hl7.org/fhir/device-productidentifierinudi";
                }
                case SOFTWAREVERSION: {
                    return "http://hl7.org/fhir/device-productidentifierinudi";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case LOTNUMBER: {
                    return "The label includes the lot number.";
                }
                case MANUFACTUREDDATE: {
                    return "The label includes the manufacture date.";
                }
                case SERIALNUMBER: {
                    return "The label includes the serial number.";
                }
                case EXPIRATIONDATE: {
                    return "The label includes the expiration date.";
                }
                case BIOLOGICALSOURCE: {
                    return "The label includes the biological source identifier.";
                }
                case SOFTWAREVERSION: {
                    return "The label includes the software version.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case LOTNUMBER: {
                    return "Lot Number";
                }
                case MANUFACTUREDDATE: {
                    return "Manufactured date";
                }
                case SERIALNUMBER: {
                    return "Serial Number";
                }
                case EXPIRATIONDATE: {
                    return "Expiration date";
                }
                case BIOLOGICALSOURCE: {
                    return "Biological source";
                }
                case SOFTWAREVERSION: {
                    return "Software Version";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class DeviceDefinitionRegulatoryIdentifierTypeEnumFactory
    implements EnumFactory<DeviceDefinitionRegulatoryIdentifierType> {
        @Override
        public DeviceDefinitionRegulatoryIdentifierType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("basic".equals(codeString)) {
                return DeviceDefinitionRegulatoryIdentifierType.BASIC;
            }
            if ("master".equals(codeString)) {
                return DeviceDefinitionRegulatoryIdentifierType.MASTER;
            }
            if ("license".equals(codeString)) {
                return DeviceDefinitionRegulatoryIdentifierType.LICENSE;
            }
            throw new IllegalArgumentException("Unknown DeviceDefinitionRegulatoryIdentifierType code '" + codeString + "'");
        }

        public Enumeration<DeviceDefinitionRegulatoryIdentifierType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceDefinitionRegulatoryIdentifierType>(this, DeviceDefinitionRegulatoryIdentifierType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DeviceDefinitionRegulatoryIdentifierType>(this, DeviceDefinitionRegulatoryIdentifierType.NULL, code);
            }
            if ("basic".equals(codeString)) {
                return new Enumeration<DeviceDefinitionRegulatoryIdentifierType>(this, DeviceDefinitionRegulatoryIdentifierType.BASIC, code);
            }
            if ("master".equals(codeString)) {
                return new Enumeration<DeviceDefinitionRegulatoryIdentifierType>(this, DeviceDefinitionRegulatoryIdentifierType.MASTER, code);
            }
            if ("license".equals(codeString)) {
                return new Enumeration<DeviceDefinitionRegulatoryIdentifierType>(this, DeviceDefinitionRegulatoryIdentifierType.LICENSE, code);
            }
            throw new FHIRException("Unknown DeviceDefinitionRegulatoryIdentifierType code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceDefinitionRegulatoryIdentifierType code) {
            if (code == DeviceDefinitionRegulatoryIdentifierType.BASIC) {
                return "basic";
            }
            if (code == DeviceDefinitionRegulatoryIdentifierType.MASTER) {
                return "master";
            }
            if (code == DeviceDefinitionRegulatoryIdentifierType.LICENSE) {
                return "license";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceDefinitionRegulatoryIdentifierType code) {
            return code.getSystem();
        }
    }

    public static enum DeviceDefinitionRegulatoryIdentifierType {
        BASIC,
        MASTER,
        LICENSE,
        NULL;


        public static DeviceDefinitionRegulatoryIdentifierType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("basic".equals(codeString)) {
                return BASIC;
            }
            if ("master".equals(codeString)) {
                return MASTER;
            }
            if ("license".equals(codeString)) {
                return LICENSE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceDefinitionRegulatoryIdentifierType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BASIC: {
                    return "basic";
                }
                case MASTER: {
                    return "master";
                }
                case LICENSE: {
                    return "license";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BASIC: {
                    return "http://hl7.org/fhir/devicedefinition-regulatory-identifier-type";
                }
                case MASTER: {
                    return "http://hl7.org/fhir/devicedefinition-regulatory-identifier-type";
                }
                case LICENSE: {
                    return "http://hl7.org/fhir/devicedefinition-regulatory-identifier-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BASIC: {
                    return "EUDAMED's basic UDI-DI identifier.";
                }
                case MASTER: {
                    return "EUDAMED's master UDI-DI identifier.";
                }
                case LICENSE: {
                    return "The identifier is a license number.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BASIC: {
                    return "Basic";
                }
                case MASTER: {
                    return "Master";
                }
                case LICENSE: {
                    return "License";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class DeviceCorrectiveActionScopeEnumFactory
    implements EnumFactory<DeviceCorrectiveActionScope> {
        @Override
        public DeviceCorrectiveActionScope fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("model".equals(codeString)) {
                return DeviceCorrectiveActionScope.MODEL;
            }
            if ("lot-numbers".equals(codeString)) {
                return DeviceCorrectiveActionScope.LOTNUMBERS;
            }
            if ("serial-numbers".equals(codeString)) {
                return DeviceCorrectiveActionScope.SERIALNUMBERS;
            }
            throw new IllegalArgumentException("Unknown DeviceCorrectiveActionScope code '" + codeString + "'");
        }

        public Enumeration<DeviceCorrectiveActionScope> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DeviceCorrectiveActionScope>(this, DeviceCorrectiveActionScope.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<DeviceCorrectiveActionScope>(this, DeviceCorrectiveActionScope.NULL, code);
            }
            if ("model".equals(codeString)) {
                return new Enumeration<DeviceCorrectiveActionScope>(this, DeviceCorrectiveActionScope.MODEL, code);
            }
            if ("lot-numbers".equals(codeString)) {
                return new Enumeration<DeviceCorrectiveActionScope>(this, DeviceCorrectiveActionScope.LOTNUMBERS, code);
            }
            if ("serial-numbers".equals(codeString)) {
                return new Enumeration<DeviceCorrectiveActionScope>(this, DeviceCorrectiveActionScope.SERIALNUMBERS, code);
            }
            throw new FHIRException("Unknown DeviceCorrectiveActionScope code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceCorrectiveActionScope code) {
            if (code == DeviceCorrectiveActionScope.MODEL) {
                return "model";
            }
            if (code == DeviceCorrectiveActionScope.LOTNUMBERS) {
                return "lot-numbers";
            }
            if (code == DeviceCorrectiveActionScope.SERIALNUMBERS) {
                return "serial-numbers";
            }
            return "?";
        }

        @Override
        public String toSystem(DeviceCorrectiveActionScope code) {
            return code.getSystem();
        }
    }

    public static enum DeviceCorrectiveActionScope {
        MODEL,
        LOTNUMBERS,
        SERIALNUMBERS,
        NULL;


        public static DeviceCorrectiveActionScope fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("model".equals(codeString)) {
                return MODEL;
            }
            if ("lot-numbers".equals(codeString)) {
                return LOTNUMBERS;
            }
            if ("serial-numbers".equals(codeString)) {
                return SERIALNUMBERS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DeviceCorrectiveActionScope code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MODEL: {
                    return "model";
                }
                case LOTNUMBERS: {
                    return "lot-numbers";
                }
                case SERIALNUMBERS: {
                    return "serial-numbers";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MODEL: {
                    return "http://hl7.org/fhir/device-correctiveactionscope";
                }
                case LOTNUMBERS: {
                    return "http://hl7.org/fhir/device-correctiveactionscope";
                }
                case SERIALNUMBERS: {
                    return "http://hl7.org/fhir/device-correctiveactionscope";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MODEL: {
                    return "The corrective action was intended for all units of the same model.";
                }
                case LOTNUMBERS: {
                    return "The corrective action was intended for a specific batch of units identified by a lot number.";
                }
                case SERIALNUMBERS: {
                    return "The corrective action was intended for an individual unit (or a set of units) individually identified by serial number.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MODEL: {
                    return "Model";
                }
                case LOTNUMBERS: {
                    return "Lot Numbers";
                }
                case SERIALNUMBERS: {
                    return "Serial Numbers";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

