/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Consent", profile="http://hl7.org/fhir/StructureDefinition/Consent")
public class Consent
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier for this record (external references)", formalDefinition="Unique identifier for this copy of the Consent Statement.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | inactive | not-done | entered-in-error | unknown", formalDefinition="Indicates the current state of this Consent resource.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-state-codes")
    protected Enumeration<ConsentState> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of the consent statement - for indexing/retrieval", formalDefinition="A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-category")
    protected List<CodeableConcept> category;
    @Child(name="subject", type={Patient.class, Practitioner.class, Group.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the consent applies to", formalDefinition="The patient/healthcare practitioner or group of persons to whom this consent applies.")
    protected Reference subject;
    @Child(name="date", type={DateType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Fully executed date of the consent", formalDefinition="Date the consent instance was agreed to.")
    protected DateType date;
    @Child(name="period", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Effective period for this Consent", formalDefinition="Effective period for this Consent Resource and all provisions unless specified in that provision.")
    protected Period period;
    @Child(name="grantor", type={CareTeam.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, PractitionerRole.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is granting rights according to the policy and rules", formalDefinition="The entity responsible for granting the rights listed in a Consent Directive.")
    protected List<Reference> grantor;
    @Child(name="grantee", type={CareTeam.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, PractitionerRole.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who is agreeing to the policy and rules", formalDefinition="The entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.")
    protected List<Reference> grantee;
    @Child(name="manager", type={HealthcareService.class, Organization.class, Patient.class, Practitioner.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Consent workflow management", formalDefinition="The actor that manages the consent through its lifecycle.")
    protected List<Reference> manager;
    @Child(name="controller", type={HealthcareService.class, Organization.class, Patient.class, Practitioner.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Consent Enforcer", formalDefinition="The actor that controls/enforces the access according to the consent.")
    protected List<Reference> controller;
    @Child(name="sourceAttachment", type={Attachment.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Source from which this consent is taken", formalDefinition="The source on which this consent statement is based. The source might be a scanned original paper form.")
    protected List<Attachment> sourceAttachment;
    @Child(name="sourceReference", type={Consent.class, DocumentReference.class, Contract.class, QuestionnaireResponse.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Source from which this consent is taken", formalDefinition="A reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.")
    protected List<Reference> sourceReference;
    @Child(name="regulatoryBasis", type={CodeableConcept.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Regulations establishing base Consent", formalDefinition="A set of codes that indicate the regulatory basis (if any) that this consent supports.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-policy")
    protected List<CodeableConcept> regulatoryBasis;
    @Child(name="policyBasis", type={}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Computable version of the backing policy", formalDefinition="A Reference or URL used to uniquely identify the policy the organization will enforce for this Consent. This Reference or URL should be specific to the version of the policy and should be dereferencable to a computable policy of some form.")
    protected ConsentPolicyBasisComponent policyBasis;
    @Child(name="policyText", type={DocumentReference.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Human Readable Policy", formalDefinition="A Reference to the human readable policy explaining the basis for the Consent.")
    protected List<Reference> policyText;
    @Child(name="verification", type={}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Consent Verified by patient or family", formalDefinition="Whether a treatment instruction (e.g. artificial respiration: yes or no) was verified with the patient, his/her family or another authorized person.")
    protected List<ConsentVerificationComponent> verification;
    @Child(name="provision", type={}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Constraints to the base Consent.policyRule/Consent.policy", formalDefinition="An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.")
    protected ProvisionComponent provision;
    private static final long serialVersionUID = -1425171494L;
    @SearchParamDefinition(name="action", path="Consent.provision.action", description="Actions controlled by this rule", type="token")
    public static final String SP_ACTION = "action";
    public static final TokenClientParam ACTION = new TokenClientParam("action");
    @SearchParamDefinition(name="actor", path="Consent.provision.actor.reference", description="Resource for the actor (or group, by role)", type="reference", target={CareTeam.class, Device.class, Group.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("Consent:actor").toLocked();
    @SearchParamDefinition(name="category", path="Consent.category", description="Classification of the consent statement - for indexing/retrieval", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="controller", path="Consent.controller", description="Consent Enforcer", type="reference", target={HealthcareService.class, Organization.class, Patient.class, Practitioner.class})
    public static final String SP_CONTROLLER = "controller";
    public static final ReferenceClientParam CONTROLLER = new ReferenceClientParam("controller");
    public static final Include INCLUDE_CONTROLLER = new Include("Consent:controller").toLocked();
    @SearchParamDefinition(name="data", path="Consent.provision.data.reference", description="The actual data reference", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_DATA = "data";
    public static final ReferenceClientParam DATA = new ReferenceClientParam("data");
    public static final Include INCLUDE_DATA = new Include("Consent:data").toLocked();
    @SearchParamDefinition(name="grantee", path="Consent.grantee", description="Who is agreeing to the policy and rules", type="reference", target={CareTeam.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_GRANTEE = "grantee";
    public static final ReferenceClientParam GRANTEE = new ReferenceClientParam("grantee");
    public static final Include INCLUDE_GRANTEE = new Include("Consent:grantee").toLocked();
    @SearchParamDefinition(name="manager", path="Consent.manager", description="Consent workflow management", type="reference", target={HealthcareService.class, Organization.class, Patient.class, Practitioner.class})
    public static final String SP_MANAGER = "manager";
    public static final ReferenceClientParam MANAGER = new ReferenceClientParam("manager");
    public static final Include INCLUDE_MANAGER = new Include("Consent:manager").toLocked();
    @SearchParamDefinition(name="period", path="Consent.provision.period", description="Timeframe for this rule", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="purpose", path="Consent.provision.purpose", description="Context of activities covered by this rule", type="token")
    public static final String SP_PURPOSE = "purpose";
    public static final TokenClientParam PURPOSE = new TokenClientParam("purpose");
    @SearchParamDefinition(name="security-label", path="Consent.provision.securityLabel", description="Security Labels that define affected resources", type="token")
    public static final String SP_SECURITY_LABEL = "security-label";
    public static final TokenClientParam SECURITY_LABEL = new TokenClientParam("security-label");
    @SearchParamDefinition(name="source-reference", path="Consent.sourceReference", description="Search by reference to a Consent, DocumentReference, Contract  or QuestionnaireResponse", type="reference", target={Consent.class, Contract.class, DocumentReference.class, QuestionnaireResponse.class})
    public static final String SP_SOURCE_REFERENCE = "source-reference";
    public static final ReferenceClientParam SOURCE_REFERENCE = new ReferenceClientParam("source-reference");
    public static final Include INCLUDE_SOURCE_REFERENCE = new Include("Consent:source-reference").toLocked();
    @SearchParamDefinition(name="status", path="Consent.status", description="draft | active | inactive | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Consent.subject", description="Who the consent applies to", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class, Practitioner.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Consent:subject").toLocked();
    @SearchParamDefinition(name="verified-date", path="Consent.verification.verificationDate", description="When consent verified", type="date")
    public static final String SP_VERIFIED_DATE = "verified-date";
    public static final DateClientParam VERIFIED_DATE = new DateClientParam("verified-date");
    @SearchParamDefinition(name="verified", path="Consent.verification.verified", description="Has been verified", type="token")
    public static final String SP_VERIFIED = "verified";
    public static final TokenClientParam VERIFIED = new TokenClientParam("verified");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.as(dateTime) | DiagnosticReport.effective.as(Period) | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective.as(dateTime) | Observation.effective.as(Period) | Observation.effective.as(Timing) | Observation.effective.as(instant) | Procedure.occurrence.as(dateTime) | Procedure.occurrence.as(Period) | Procedure.occurrence.as(Timing) | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.subject | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Consent:patient").toLocked();

    public Consent() {
    }

    public Consent(ConsentState status) {
        this.setStatus(status);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Consent setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Consent addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ConsentState> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ConsentState>(new ConsentStateEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Consent setStatusElement(Enumeration<ConsentState> value) {
        this.status = value;
        return this;
    }

    public ConsentState getStatus() {
        return this.status == null ? null : (ConsentState)((Object)this.status.getValue());
    }

    public Consent setStatus(ConsentState value) {
        if (this.status == null) {
            this.status = new Enumeration<ConsentState>(new ConsentStateEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Consent setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Consent addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Consent setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public DateType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Consent setDateElement(DateType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Consent setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Consent setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<Reference> getGrantor() {
        if (this.grantor == null) {
            this.grantor = new ArrayList<Reference>();
        }
        return this.grantor;
    }

    public Consent setGrantor(List<Reference> theGrantor) {
        this.grantor = theGrantor;
        return this;
    }

    public boolean hasGrantor() {
        if (this.grantor == null) {
            return false;
        }
        for (Reference item : this.grantor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addGrantor() {
        Reference t = new Reference();
        if (this.grantor == null) {
            this.grantor = new ArrayList<Reference>();
        }
        this.grantor.add(t);
        return t;
    }

    public Consent addGrantor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.grantor == null) {
            this.grantor = new ArrayList<Reference>();
        }
        this.grantor.add(t);
        return this;
    }

    public Reference getGrantorFirstRep() {
        if (this.getGrantor().isEmpty()) {
            this.addGrantor();
        }
        return this.getGrantor().get(0);
    }

    public List<Reference> getGrantee() {
        if (this.grantee == null) {
            this.grantee = new ArrayList<Reference>();
        }
        return this.grantee;
    }

    public Consent setGrantee(List<Reference> theGrantee) {
        this.grantee = theGrantee;
        return this;
    }

    public boolean hasGrantee() {
        if (this.grantee == null) {
            return false;
        }
        for (Reference item : this.grantee) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addGrantee() {
        Reference t = new Reference();
        if (this.grantee == null) {
            this.grantee = new ArrayList<Reference>();
        }
        this.grantee.add(t);
        return t;
    }

    public Consent addGrantee(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.grantee == null) {
            this.grantee = new ArrayList<Reference>();
        }
        this.grantee.add(t);
        return this;
    }

    public Reference getGranteeFirstRep() {
        if (this.getGrantee().isEmpty()) {
            this.addGrantee();
        }
        return this.getGrantee().get(0);
    }

    public List<Reference> getManager() {
        if (this.manager == null) {
            this.manager = new ArrayList<Reference>();
        }
        return this.manager;
    }

    public Consent setManager(List<Reference> theManager) {
        this.manager = theManager;
        return this;
    }

    public boolean hasManager() {
        if (this.manager == null) {
            return false;
        }
        for (Reference item : this.manager) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManager() {
        Reference t = new Reference();
        if (this.manager == null) {
            this.manager = new ArrayList<Reference>();
        }
        this.manager.add(t);
        return t;
    }

    public Consent addManager(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manager == null) {
            this.manager = new ArrayList<Reference>();
        }
        this.manager.add(t);
        return this;
    }

    public Reference getManagerFirstRep() {
        if (this.getManager().isEmpty()) {
            this.addManager();
        }
        return this.getManager().get(0);
    }

    public List<Reference> getController() {
        if (this.controller == null) {
            this.controller = new ArrayList<Reference>();
        }
        return this.controller;
    }

    public Consent setController(List<Reference> theController) {
        this.controller = theController;
        return this;
    }

    public boolean hasController() {
        if (this.controller == null) {
            return false;
        }
        for (Reference item : this.controller) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addController() {
        Reference t = new Reference();
        if (this.controller == null) {
            this.controller = new ArrayList<Reference>();
        }
        this.controller.add(t);
        return t;
    }

    public Consent addController(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.controller == null) {
            this.controller = new ArrayList<Reference>();
        }
        this.controller.add(t);
        return this;
    }

    public Reference getControllerFirstRep() {
        if (this.getController().isEmpty()) {
            this.addController();
        }
        return this.getController().get(0);
    }

    public List<Attachment> getSourceAttachment() {
        if (this.sourceAttachment == null) {
            this.sourceAttachment = new ArrayList<Attachment>();
        }
        return this.sourceAttachment;
    }

    public Consent setSourceAttachment(List<Attachment> theSourceAttachment) {
        this.sourceAttachment = theSourceAttachment;
        return this;
    }

    public boolean hasSourceAttachment() {
        if (this.sourceAttachment == null) {
            return false;
        }
        for (Attachment item : this.sourceAttachment) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addSourceAttachment() {
        Attachment t = new Attachment();
        if (this.sourceAttachment == null) {
            this.sourceAttachment = new ArrayList<Attachment>();
        }
        this.sourceAttachment.add(t);
        return t;
    }

    public Consent addSourceAttachment(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.sourceAttachment == null) {
            this.sourceAttachment = new ArrayList<Attachment>();
        }
        this.sourceAttachment.add(t);
        return this;
    }

    public Attachment getSourceAttachmentFirstRep() {
        if (this.getSourceAttachment().isEmpty()) {
            this.addSourceAttachment();
        }
        return this.getSourceAttachment().get(0);
    }

    public List<Reference> getSourceReference() {
        if (this.sourceReference == null) {
            this.sourceReference = new ArrayList<Reference>();
        }
        return this.sourceReference;
    }

    public Consent setSourceReference(List<Reference> theSourceReference) {
        this.sourceReference = theSourceReference;
        return this;
    }

    public boolean hasSourceReference() {
        if (this.sourceReference == null) {
            return false;
        }
        for (Reference item : this.sourceReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSourceReference() {
        Reference t = new Reference();
        if (this.sourceReference == null) {
            this.sourceReference = new ArrayList<Reference>();
        }
        this.sourceReference.add(t);
        return t;
    }

    public Consent addSourceReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.sourceReference == null) {
            this.sourceReference = new ArrayList<Reference>();
        }
        this.sourceReference.add(t);
        return this;
    }

    public Reference getSourceReferenceFirstRep() {
        if (this.getSourceReference().isEmpty()) {
            this.addSourceReference();
        }
        return this.getSourceReference().get(0);
    }

    public List<CodeableConcept> getRegulatoryBasis() {
        if (this.regulatoryBasis == null) {
            this.regulatoryBasis = new ArrayList<CodeableConcept>();
        }
        return this.regulatoryBasis;
    }

    public Consent setRegulatoryBasis(List<CodeableConcept> theRegulatoryBasis) {
        this.regulatoryBasis = theRegulatoryBasis;
        return this;
    }

    public boolean hasRegulatoryBasis() {
        if (this.regulatoryBasis == null) {
            return false;
        }
        for (CodeableConcept item : this.regulatoryBasis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addRegulatoryBasis() {
        CodeableConcept t = new CodeableConcept();
        if (this.regulatoryBasis == null) {
            this.regulatoryBasis = new ArrayList<CodeableConcept>();
        }
        this.regulatoryBasis.add(t);
        return t;
    }

    public Consent addRegulatoryBasis(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.regulatoryBasis == null) {
            this.regulatoryBasis = new ArrayList<CodeableConcept>();
        }
        this.regulatoryBasis.add(t);
        return this;
    }

    public CodeableConcept getRegulatoryBasisFirstRep() {
        if (this.getRegulatoryBasis().isEmpty()) {
            this.addRegulatoryBasis();
        }
        return this.getRegulatoryBasis().get(0);
    }

    public ConsentPolicyBasisComponent getPolicyBasis() {
        if (this.policyBasis == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.policyBasis");
            }
            if (Configuration.doAutoCreate()) {
                this.policyBasis = new ConsentPolicyBasisComponent();
            }
        }
        return this.policyBasis;
    }

    public boolean hasPolicyBasis() {
        return this.policyBasis != null && !this.policyBasis.isEmpty();
    }

    public Consent setPolicyBasis(ConsentPolicyBasisComponent value) {
        this.policyBasis = value;
        return this;
    }

    public List<Reference> getPolicyText() {
        if (this.policyText == null) {
            this.policyText = new ArrayList<Reference>();
        }
        return this.policyText;
    }

    public Consent setPolicyText(List<Reference> thePolicyText) {
        this.policyText = thePolicyText;
        return this;
    }

    public boolean hasPolicyText() {
        if (this.policyText == null) {
            return false;
        }
        for (Reference item : this.policyText) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPolicyText() {
        Reference t = new Reference();
        if (this.policyText == null) {
            this.policyText = new ArrayList<Reference>();
        }
        this.policyText.add(t);
        return t;
    }

    public Consent addPolicyText(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.policyText == null) {
            this.policyText = new ArrayList<Reference>();
        }
        this.policyText.add(t);
        return this;
    }

    public Reference getPolicyTextFirstRep() {
        if (this.getPolicyText().isEmpty()) {
            this.addPolicyText();
        }
        return this.getPolicyText().get(0);
    }

    public List<ConsentVerificationComponent> getVerification() {
        if (this.verification == null) {
            this.verification = new ArrayList<ConsentVerificationComponent>();
        }
        return this.verification;
    }

    public Consent setVerification(List<ConsentVerificationComponent> theVerification) {
        this.verification = theVerification;
        return this;
    }

    public boolean hasVerification() {
        if (this.verification == null) {
            return false;
        }
        for (ConsentVerificationComponent item : this.verification) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ConsentVerificationComponent addVerification() {
        ConsentVerificationComponent t = new ConsentVerificationComponent();
        if (this.verification == null) {
            this.verification = new ArrayList<ConsentVerificationComponent>();
        }
        this.verification.add(t);
        return t;
    }

    public Consent addVerification(ConsentVerificationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.verification == null) {
            this.verification = new ArrayList<ConsentVerificationComponent>();
        }
        this.verification.add(t);
        return this;
    }

    public ConsentVerificationComponent getVerificationFirstRep() {
        if (this.getVerification().isEmpty()) {
            this.addVerification();
        }
        return this.getVerification().get(0);
    }

    public ProvisionComponent getProvision() {
        if (this.provision == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Consent.provision");
            }
            if (Configuration.doAutoCreate()) {
                this.provision = new ProvisionComponent();
            }
        }
        return this.provision;
    }

    public boolean hasProvision() {
        return this.provision != null && !this.provision.isEmpty();
    }

    public Consent setProvision(ProvisionComponent value) {
        this.provision = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this copy of the Consent Statement.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "Indicates the current state of this Consent resource.", 0, 1, this.status));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Practitioner|Group)", "The patient/healthcare practitioner or group of persons to whom this consent applies.", 0, 1, this.subject));
        children.add(new Property(SP_DATE, SP_DATE, "Date the consent instance was agreed to.", 0, 1, this.date));
        children.add(new Property(SP_PERIOD, "Period", "Effective period for this Consent Resource and all provisions unless specified in that provision.", 0, 1, this.period));
        children.add(new Property("grantor", "Reference(CareTeam|HealthcareService|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The entity responsible for granting the rights listed in a Consent Directive.", 0, Integer.MAX_VALUE, this.grantor));
        children.add(new Property(SP_GRANTEE, "Reference(CareTeam|HealthcareService|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.", 0, Integer.MAX_VALUE, this.grantee));
        children.add(new Property(SP_MANAGER, "Reference(HealthcareService|Organization|Patient|Practitioner)", "The actor that manages the consent through its lifecycle.", 0, Integer.MAX_VALUE, this.manager));
        children.add(new Property(SP_CONTROLLER, "Reference(HealthcareService|Organization|Patient|Practitioner)", "The actor that controls/enforces the access according to the consent.", 0, Integer.MAX_VALUE, this.controller));
        children.add(new Property("sourceAttachment", "Attachment", "The source on which this consent statement is based. The source might be a scanned original paper form.", 0, Integer.MAX_VALUE, this.sourceAttachment));
        children.add(new Property("sourceReference", "Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "A reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, Integer.MAX_VALUE, this.sourceReference));
        children.add(new Property("regulatoryBasis", "CodeableConcept", "A set of codes that indicate the regulatory basis (if any) that this consent supports.", 0, Integer.MAX_VALUE, this.regulatoryBasis));
        children.add(new Property("policyBasis", "", "A Reference or URL used to uniquely identify the policy the organization will enforce for this Consent. This Reference or URL should be specific to the version of the policy and should be dereferencable to a computable policy of some form.", 0, 1, this.policyBasis));
        children.add(new Property("policyText", "Reference(DocumentReference)", "A Reference to the human readable policy explaining the basis for the Consent.", 0, Integer.MAX_VALUE, this.policyText));
        children.add(new Property("verification", "", "Whether a treatment instruction (e.g. artificial respiration: yes or no) was verified with the patient, his/her family or another authorized person.", 0, Integer.MAX_VALUE, this.verification));
        children.add(new Property("provision", "", "An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.", 0, 1, this.provision));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this copy of the Consent Statement.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "Indicates the current state of this Consent resource.", 0, 1, this.status);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A classification of the type of consents found in the statement. This element supports indexing and retrieval of consent statements.", 0, Integer.MAX_VALUE, this.category);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Practitioner|Group)", "The patient/healthcare practitioner or group of persons to whom this consent applies.", 0, 1, this.subject);
            }
            case 3076014: {
                return new Property(SP_DATE, SP_DATE, "Date the consent instance was agreed to.", 0, 1, this.date);
            }
            case -991726143: {
                return new Property(SP_PERIOD, "Period", "Effective period for this Consent Resource and all provisions unless specified in that provision.", 0, 1, this.period);
            }
            case 280295423: {
                return new Property("grantor", "Reference(CareTeam|HealthcareService|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The entity responsible for granting the rights listed in a Consent Directive.", 0, Integer.MAX_VALUE, this.grantor);
            }
            case 280295100: {
                return new Property(SP_GRANTEE, "Reference(CareTeam|HealthcareService|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The entity responsible for complying with the Consent Directive, including any obligations or limitations on authorizations and enforcement of prohibitions.", 0, Integer.MAX_VALUE, this.grantee);
            }
            case 835260333: {
                return new Property(SP_MANAGER, "Reference(HealthcareService|Organization|Patient|Practitioner)", "The actor that manages the consent through its lifecycle.", 0, Integer.MAX_VALUE, this.manager);
            }
            case 637428636: {
                return new Property(SP_CONTROLLER, "Reference(HealthcareService|Organization|Patient|Practitioner)", "The actor that controls/enforces the access according to the consent.", 0, Integer.MAX_VALUE, this.controller);
            }
            case 1964406686: {
                return new Property("sourceAttachment", "Attachment", "The source on which this consent statement is based. The source might be a scanned original paper form.", 0, Integer.MAX_VALUE, this.sourceAttachment);
            }
            case -244259472: {
                return new Property("sourceReference", "Reference(Consent|DocumentReference|Contract|QuestionnaireResponse)", "A reference to a consent that links back to such a source, a reference to a document repository (e.g. XDS) that stores the original consent document.", 0, Integer.MAX_VALUE, this.sourceReference);
            }
            case -1780301690: {
                return new Property("regulatoryBasis", "CodeableConcept", "A set of codes that indicate the regulatory basis (if any) that this consent supports.", 0, Integer.MAX_VALUE, this.regulatoryBasis);
            }
            case 2138287660: {
                return new Property("policyBasis", "", "A Reference or URL used to uniquely identify the policy the organization will enforce for this Consent. This Reference or URL should be specific to the version of the policy and should be dereferencable to a computable policy of some form.", 0, 1, this.policyBasis);
            }
            case 1593537919: {
                return new Property("policyText", "Reference(DocumentReference)", "A Reference to the human readable policy explaining the basis for the Consent.", 0, Integer.MAX_VALUE, this.policyText);
            }
            case -1484401125: {
                return new Property("verification", "", "Whether a treatment instruction (e.g. artificial respiration: yes or no) was verified with the patient, his/her family or another authorized person.", 0, Integer.MAX_VALUE, this.verification);
            }
            case -547120939: {
                return new Property("provision", "", "An exception to the base policy of this consent. An exception can be an addition or removal of access permissions.", 0, 1, this.provision);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.date;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case 280295423: {
                return this.grantor == null ? new Base[]{} : this.grantor.toArray(new Base[this.grantor.size()]);
            }
            case 280295100: {
                return this.grantee == null ? new Base[]{} : this.grantee.toArray(new Base[this.grantee.size()]);
            }
            case 835260333: {
                return this.manager == null ? new Base[]{} : this.manager.toArray(new Base[this.manager.size()]);
            }
            case 637428636: {
                return this.controller == null ? new Base[]{} : this.controller.toArray(new Base[this.controller.size()]);
            }
            case 1964406686: {
                return this.sourceAttachment == null ? new Base[]{} : this.sourceAttachment.toArray(new Base[this.sourceAttachment.size()]);
            }
            case -244259472: {
                return this.sourceReference == null ? new Base[]{} : this.sourceReference.toArray(new Base[this.sourceReference.size()]);
            }
            case -1780301690: {
                return this.regulatoryBasis == null ? new Base[]{} : this.regulatoryBasis.toArray(new Base[this.regulatoryBasis.size()]);
            }
            case 2138287660: {
                Base[] baseArray;
                if (this.policyBasis == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.policyBasis;
                }
                return baseArray;
            }
            case 1593537919: {
                return this.policyText == null ? new Base[]{} : this.policyText.toArray(new Base[this.policyText.size()]);
            }
            case -1484401125: {
                return this.verification == null ? new Base[]{} : this.verification.toArray(new Base[this.verification.size()]);
            }
            case -547120939: {
                Base[] baseArray;
                if (this.provision == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.provision;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ConsentStateEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDate(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 280295423: {
                this.getGrantor().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 280295100: {
                this.getGrantee().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 835260333: {
                this.getManager().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 637428636: {
                this.getController().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1964406686: {
                this.getSourceAttachment().add(TypeConvertor.castToAttachment(value));
                return value;
            }
            case -244259472: {
                this.getSourceReference().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1780301690: {
                this.getRegulatoryBasis().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 2138287660: {
                this.policyBasis = (ConsentPolicyBasisComponent)((Object)value);
                return value;
            }
            case 1593537919: {
                this.getPolicyText().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1484401125: {
                this.getVerification().add((ConsentVerificationComponent)((Object)value));
                return value;
            }
            case -547120939: {
                this.provision = (ProvisionComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ConsentStateEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDate(value);
        } else if (name.equals(SP_PERIOD)) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals("grantor")) {
            this.getGrantor().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_GRANTEE)) {
            this.getGrantee().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_MANAGER)) {
            this.getManager().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_CONTROLLER)) {
            this.getController().add(TypeConvertor.castToReference(value));
        } else if (name.equals("sourceAttachment")) {
            this.getSourceAttachment().add(TypeConvertor.castToAttachment(value));
        } else if (name.equals("sourceReference")) {
            this.getSourceReference().add(TypeConvertor.castToReference(value));
        } else if (name.equals("regulatoryBasis")) {
            this.getRegulatoryBasis().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("policyBasis")) {
            this.policyBasis = (ConsentPolicyBasisComponent)((Object)value);
        } else if (name.equals("policyText")) {
            this.getPolicyText().add(TypeConvertor.castToReference(value));
        } else if (name.equals("verification")) {
            this.getVerification().add((ConsentVerificationComponent)((Object)value));
        } else if (name.equals("provision")) {
            this.provision = (ProvisionComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 280295423: {
                return this.addGrantor();
            }
            case 280295100: {
                return this.addGrantee();
            }
            case 835260333: {
                return this.addManager();
            }
            case 637428636: {
                return this.addController();
            }
            case 1964406686: {
                return this.addSourceAttachment();
            }
            case -244259472: {
                return this.addSourceReference();
            }
            case -1780301690: {
                return this.addRegulatoryBasis();
            }
            case 2138287660: {
                return this.getPolicyBasis();
            }
            case 1593537919: {
                return this.addPolicyText();
            }
            case -1484401125: {
                return this.addVerification();
            }
            case -547120939: {
                return this.getProvision();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{SP_DATE};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 280295423: {
                return new String[]{"Reference"};
            }
            case 280295100: {
                return new String[]{"Reference"};
            }
            case 835260333: {
                return new String[]{"Reference"};
            }
            case 637428636: {
                return new String[]{"Reference"};
            }
            case 1964406686: {
                return new String[]{"Attachment"};
            }
            case -244259472: {
                return new String[]{"Reference"};
            }
            case -1780301690: {
                return new String[]{"CodeableConcept"};
            }
            case 2138287660: {
                return new String[0];
            }
            case 1593537919: {
                return new String[]{"Reference"};
            }
            case -1484401125: {
                return new String[0];
            }
            case -547120939: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Consent.status");
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Consent.date");
        }
        if (name.equals(SP_PERIOD)) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("grantor")) {
            return this.addGrantor();
        }
        if (name.equals(SP_GRANTEE)) {
            return this.addGrantee();
        }
        if (name.equals(SP_MANAGER)) {
            return this.addManager();
        }
        if (name.equals(SP_CONTROLLER)) {
            return this.addController();
        }
        if (name.equals("sourceAttachment")) {
            return this.addSourceAttachment();
        }
        if (name.equals("sourceReference")) {
            return this.addSourceReference();
        }
        if (name.equals("regulatoryBasis")) {
            return this.addRegulatoryBasis();
        }
        if (name.equals("policyBasis")) {
            this.policyBasis = new ConsentPolicyBasisComponent();
            return this.policyBasis;
        }
        if (name.equals("policyText")) {
            return this.addPolicyText();
        }
        if (name.equals("verification")) {
            return this.addVerification();
        }
        if (name.equals("provision")) {
            this.provision = new ProvisionComponent();
            return this.provision;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Consent";
    }

    @Override
    public Consent copy() {
        Consent dst = new Consent();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Consent dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<ConsentState> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.date = this.date == null ? null : this.date.copy();
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.grantor != null) {
            dst.grantor = new ArrayList<Reference>();
            for (Reference reference : this.grantor) {
                dst.grantor.add(reference.copy());
            }
        }
        if (this.grantee != null) {
            dst.grantee = new ArrayList<Reference>();
            for (Reference reference : this.grantee) {
                dst.grantee.add(reference.copy());
            }
        }
        if (this.manager != null) {
            dst.manager = new ArrayList<Reference>();
            for (Reference reference : this.manager) {
                dst.manager.add(reference.copy());
            }
        }
        if (this.controller != null) {
            dst.controller = new ArrayList<Reference>();
            for (Reference reference : this.controller) {
                dst.controller.add(reference.copy());
            }
        }
        if (this.sourceAttachment != null) {
            dst.sourceAttachment = new ArrayList<Attachment>();
            for (Attachment attachment : this.sourceAttachment) {
                dst.sourceAttachment.add(attachment.copy());
            }
        }
        if (this.sourceReference != null) {
            dst.sourceReference = new ArrayList<Reference>();
            for (Reference reference : this.sourceReference) {
                dst.sourceReference.add(reference.copy());
            }
        }
        if (this.regulatoryBasis != null) {
            dst.regulatoryBasis = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.regulatoryBasis) {
                dst.regulatoryBasis.add(codeableConcept.copy());
            }
        }
        ConsentPolicyBasisComponent consentPolicyBasisComponent = dst.policyBasis = this.policyBasis == null ? null : this.policyBasis.copy();
        if (this.policyText != null) {
            dst.policyText = new ArrayList<Reference>();
            for (Reference reference : this.policyText) {
                dst.policyText.add(reference.copy());
            }
        }
        if (this.verification != null) {
            dst.verification = new ArrayList<ConsentVerificationComponent>();
            for (ConsentVerificationComponent consentVerificationComponent : this.verification) {
                dst.verification.add(consentVerificationComponent.copy());
            }
        }
        dst.provision = this.provision == null ? null : this.provision.copy();
    }

    protected Consent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Consent)) {
            return false;
        }
        Consent o = (Consent)other_;
        return Consent.compareDeep(this.identifier, o.identifier, true) && Consent.compareDeep(this.status, o.status, true) && Consent.compareDeep(this.category, o.category, true) && Consent.compareDeep(this.subject, o.subject, true) && Consent.compareDeep(this.date, o.date, true) && Consent.compareDeep(this.period, o.period, true) && Consent.compareDeep(this.grantor, o.grantor, true) && Consent.compareDeep(this.grantee, o.grantee, true) && Consent.compareDeep(this.manager, o.manager, true) && Consent.compareDeep(this.controller, o.controller, true) && Consent.compareDeep(this.sourceAttachment, o.sourceAttachment, true) && Consent.compareDeep(this.sourceReference, o.sourceReference, true) && Consent.compareDeep(this.regulatoryBasis, o.regulatoryBasis, true) && Consent.compareDeep(this.policyBasis, o.policyBasis, true) && Consent.compareDeep(this.policyText, o.policyText, true) && Consent.compareDeep(this.verification, o.verification, true) && Consent.compareDeep(this.provision, o.provision, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Consent)) {
            return false;
        }
        Consent o = (Consent)other_;
        return Consent.compareValues(this.status, o.status, true) && Consent.compareValues(this.date, o.date, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.category, this.subject, this.date, this.period, this.grantor, this.grantee, this.manager, this.controller, this.sourceAttachment, this.sourceReference, this.regulatoryBasis, this.policyBasis, this.policyText, this.verification, this.provision);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Consent;
    }

    @Block
    public static class ProvisionDataComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="meaning", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="instance | related | dependents | authoredby", formalDefinition="How the resource reference is interpreted when testing consent restrictions.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-data-meaning")
        protected Enumeration<Enumerations.ConsentDataMeaning> meaning;
        @Child(name="reference", type={Reference.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The actual data reference", formalDefinition="A reference to a specific resource that defines which resources are covered by this consent.")
        protected Reference reference;
        private static final long serialVersionUID = 1735979153L;

        public ProvisionDataComponent() {
        }

        public ProvisionDataComponent(Enumerations.ConsentDataMeaning meaning, Reference reference) {
            this.setMeaning(meaning);
            this.setReference(reference);
        }

        public Enumeration<Enumerations.ConsentDataMeaning> getMeaningElement() {
            if (this.meaning == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionDataComponent.meaning");
                }
                if (Configuration.doAutoCreate()) {
                    this.meaning = new Enumeration<Enumerations.ConsentDataMeaning>(new Enumerations.ConsentDataMeaningEnumFactory());
                }
            }
            return this.meaning;
        }

        public boolean hasMeaningElement() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public boolean hasMeaning() {
            return this.meaning != null && !this.meaning.isEmpty();
        }

        public ProvisionDataComponent setMeaningElement(Enumeration<Enumerations.ConsentDataMeaning> value) {
            this.meaning = value;
            return this;
        }

        public Enumerations.ConsentDataMeaning getMeaning() {
            return this.meaning == null ? null : (Enumerations.ConsentDataMeaning)((Object)this.meaning.getValue());
        }

        public ProvisionDataComponent setMeaning(Enumerations.ConsentDataMeaning value) {
            if (this.meaning == null) {
                this.meaning = new Enumeration<Enumerations.ConsentDataMeaning>(new Enumerations.ConsentDataMeaningEnumFactory());
            }
            this.meaning.setValue((Object)value);
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionDataComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ProvisionDataComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning));
            children.add(new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 938160637: {
                    return new Property("meaning", "code", "How the resource reference is interpreted when testing consent restrictions.", 0, 1, this.meaning);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "A reference to a specific resource that defines which resources are covered by this consent.", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    Base[] baseArray;
                    if (this.meaning == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.meaning;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    value = new Enumerations.ConsentDataMeaningEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.meaning = value;
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("meaning")) {
                value = new Enumerations.ConsentDataMeaningEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.meaning = value;
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return this.getMeaningElement();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 938160637: {
                    return new String[]{"code"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("meaning")) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.provision.data.meaning");
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ProvisionDataComponent copy() {
            ProvisionDataComponent dst = new ProvisionDataComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProvisionDataComponent dst) {
            super.copyValues(dst);
            dst.meaning = this.meaning == null ? null : this.meaning.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionDataComponent)) {
                return false;
            }
            ProvisionDataComponent o = (ProvisionDataComponent)other_;
            return ProvisionDataComponent.compareDeep(this.meaning, o.meaning, true) && ProvisionDataComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionDataComponent)) {
                return false;
            }
            ProvisionDataComponent o = (ProvisionDataComponent)other_;
            return ProvisionDataComponent.compareValues(this.meaning, o.meaning, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.meaning, this.reference);
        }

        @Override
        public String fhirType() {
            return "Consent.provision.data";
        }
    }

    @Block
    public static class ProvisionActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the actor is involved", formalDefinition="How the individual is involved in the resources content that is described in the exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participation-role-type")
        protected CodeableConcept role;
        @Child(name="reference", type={Device.class, Group.class, CareTeam.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, PractitionerRole.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource for the actor (or group, by role)", formalDefinition="The resource that identifies the actor. To identify actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').")
        protected Reference reference;
        private static final long serialVersionUID = -1992921787L;

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionActorComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public ProvisionActorComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionActorComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ProvisionActorComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("role", "CodeableConcept", "How the individual is involved in the resources content that is described in the exception.", 0, 1, this.role));
            children.add(new Property("reference", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The resource that identifies the actor. To identify actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, 1, this.reference));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3506294: {
                    return new Property("role", "CodeableConcept", "How the individual is involved in the resources content that is described in the exception.", 0, 1, this.role);
                }
                case -925155509: {
                    return new Property("reference", "Reference(Device|Group|CareTeam|Organization|Patient|Practitioner|RelatedPerson|PractitionerRole)", "The resource that identifies the actor. To identify actors by type, use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, 1, this.reference);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.reference;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case -925155509: {
                    return this.getReference();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -925155509: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            return super.addChild(name);
        }

        @Override
        public ProvisionActorComponent copy() {
            ProvisionActorComponent dst = new ProvisionActorComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProvisionActorComponent dst) {
            super.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.reference = this.reference == null ? null : this.reference.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionActorComponent)) {
                return false;
            }
            ProvisionActorComponent o = (ProvisionActorComponent)other_;
            return ProvisionActorComponent.compareDeep(this.role, o.role, true) && ProvisionActorComponent.compareDeep(this.reference, o.reference, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionActorComponent)) {
                return false;
            }
            ProvisionActorComponent o = (ProvisionActorComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.role, this.reference);
        }

        @Override
        public String fhirType() {
            return "Consent.provision.actor";
        }
    }

    @Block
    public static class ProvisionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
        @Description(shortDefinition="deny | permit", formalDefinition="Action  to take - permit or deny - when the provision conditions are met.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-provision-type")
        protected Enumeration<Enumerations.ConsentProvisionType> type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Timeframe for this provision", formalDefinition="Timeframe for this provision.")
        protected Period period;
        @Child(name="actor", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who|what controlled by this provision (or group, by role)", formalDefinition="Who or what is controlled by this provision. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').")
        protected List<ProvisionActorComponent> actor;
        @Child(name="action", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Actions controlled by this provision", formalDefinition="Actions controlled by this provision.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-action")
        protected List<CodeableConcept> action;
        @Child(name="securityLabel", type={Coding.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Security Labels that define affected resources", formalDefinition="A security label, comprised of 0..* security label fields (Privacy tags), which define which resources are controlled by this exception.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-label-examples")
        protected List<Coding> securityLabel;
        @Child(name="purpose", type={Coding.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Context of activities covered by this provision", formalDefinition="The context of the activities a user is taking - why the user is accessing the data - that are controlled by this provision.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
        protected List<Coding> purpose;
        @Child(name="documentType", type={Coding.class}, order=7, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="e.g. Resource Type, Profile, CDA, etc.", formalDefinition="The documentType(s) covered by this provision. The type can be a CDA document, or some other type that indicates what sort of information the consent relates to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-content-class")
        protected List<Coding> documentType;
        @Child(name="resourceType", type={Coding.class}, order=8, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="e.g. Resource Type, Profile, etc.", formalDefinition="The resourceType(s) covered by this provision. The type can be a FHIR resource type or a profile on a type that indicates what information the consent relates to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected List<Coding> resourceType;
        @Child(name="code", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="e.g. LOINC or SNOMED CT code, etc. in the content", formalDefinition="If this code is found in an instance, then the provision applies.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-content-code")
        protected List<CodeableConcept> code;
        @Child(name="dataPeriod", type={Period.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Timeframe for data controlled by this provision", formalDefinition="Clinical or Operational Relevant period of time that bounds the data controlled by this provision.")
        protected Period dataPeriod;
        @Child(name="data", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Data controlled by this provision", formalDefinition="The resources controlled by this provision if specific resources are referenced.")
        protected List<ProvisionDataComponent> data;
        @Child(name="expression", type={Expression.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A computable expression of the consent", formalDefinition="A computable (FHIRPath or other) definition of what is controlled by this consent.")
        protected Expression expression;
        @Child(name="provision", type={ProvisionComponent.class}, order=13, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Exception Provisions", formalDefinition="Provisions which provide exceptions to the base provision or subprovisions.")
        protected List<ProvisionComponent> provision;
        private static final long serialVersionUID = -1668990115L;

        public Enumeration<Enumerations.ConsentProvisionType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.ConsentProvisionType>(new Enumerations.ConsentProvisionTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ProvisionComponent setTypeElement(Enumeration<Enumerations.ConsentProvisionType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.ConsentProvisionType getType() {
            return this.type == null ? null : (Enumerations.ConsentProvisionType)((Object)this.type.getValue());
        }

        public ProvisionComponent setType(Enumerations.ConsentProvisionType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.ConsentProvisionType>(new Enumerations.ConsentProvisionTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ProvisionComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<ProvisionActorComponent> getActor() {
            if (this.actor == null) {
                this.actor = new ArrayList<ProvisionActorComponent>();
            }
            return this.actor;
        }

        public ProvisionComponent setActor(List<ProvisionActorComponent> theActor) {
            this.actor = theActor;
            return this;
        }

        public boolean hasActor() {
            if (this.actor == null) {
                return false;
            }
            for (ProvisionActorComponent item : this.actor) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProvisionActorComponent addActor() {
            ProvisionActorComponent t = new ProvisionActorComponent();
            if (this.actor == null) {
                this.actor = new ArrayList<ProvisionActorComponent>();
            }
            this.actor.add(t);
            return t;
        }

        public ProvisionComponent addActor(ProvisionActorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.actor == null) {
                this.actor = new ArrayList<ProvisionActorComponent>();
            }
            this.actor.add(t);
            return this;
        }

        public ProvisionActorComponent getActorFirstRep() {
            if (this.getActor().isEmpty()) {
                this.addActor();
            }
            return this.getActor().get(0);
        }

        public List<CodeableConcept> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            return this.action;
        }

        public ProvisionComponent setAction(List<CodeableConcept> theAction) {
            this.action = theAction;
            return this;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (CodeableConcept item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAction() {
            CodeableConcept t = new CodeableConcept();
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return t;
        }

        public ProvisionComponent addAction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return this;
        }

        public CodeableConcept getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                this.addAction();
            }
            return this.getAction().get(0);
        }

        public List<Coding> getSecurityLabel() {
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            return this.securityLabel;
        }

        public ProvisionComponent setSecurityLabel(List<Coding> theSecurityLabel) {
            this.securityLabel = theSecurityLabel;
            return this;
        }

        public boolean hasSecurityLabel() {
            if (this.securityLabel == null) {
                return false;
            }
            for (Coding item : this.securityLabel) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addSecurityLabel() {
            Coding t = new Coding();
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return t;
        }

        public ProvisionComponent addSecurityLabel(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<Coding>();
            }
            this.securityLabel.add(t);
            return this;
        }

        public Coding getSecurityLabelFirstRep() {
            if (this.getSecurityLabel().isEmpty()) {
                this.addSecurityLabel();
            }
            return this.getSecurityLabel().get(0);
        }

        public List<Coding> getPurpose() {
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            return this.purpose;
        }

        public ProvisionComponent setPurpose(List<Coding> thePurpose) {
            this.purpose = thePurpose;
            return this;
        }

        public boolean hasPurpose() {
            if (this.purpose == null) {
                return false;
            }
            for (Coding item : this.purpose) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addPurpose() {
            Coding t = new Coding();
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            this.purpose.add(t);
            return t;
        }

        public ProvisionComponent addPurpose(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.purpose == null) {
                this.purpose = new ArrayList<Coding>();
            }
            this.purpose.add(t);
            return this;
        }

        public Coding getPurposeFirstRep() {
            if (this.getPurpose().isEmpty()) {
                this.addPurpose();
            }
            return this.getPurpose().get(0);
        }

        public List<Coding> getDocumentType() {
            if (this.documentType == null) {
                this.documentType = new ArrayList<Coding>();
            }
            return this.documentType;
        }

        public ProvisionComponent setDocumentType(List<Coding> theDocumentType) {
            this.documentType = theDocumentType;
            return this;
        }

        public boolean hasDocumentType() {
            if (this.documentType == null) {
                return false;
            }
            for (Coding item : this.documentType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addDocumentType() {
            Coding t = new Coding();
            if (this.documentType == null) {
                this.documentType = new ArrayList<Coding>();
            }
            this.documentType.add(t);
            return t;
        }

        public ProvisionComponent addDocumentType(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.documentType == null) {
                this.documentType = new ArrayList<Coding>();
            }
            this.documentType.add(t);
            return this;
        }

        public Coding getDocumentTypeFirstRep() {
            if (this.getDocumentType().isEmpty()) {
                this.addDocumentType();
            }
            return this.getDocumentType().get(0);
        }

        public List<Coding> getResourceType() {
            if (this.resourceType == null) {
                this.resourceType = new ArrayList<Coding>();
            }
            return this.resourceType;
        }

        public ProvisionComponent setResourceType(List<Coding> theResourceType) {
            this.resourceType = theResourceType;
            return this;
        }

        public boolean hasResourceType() {
            if (this.resourceType == null) {
                return false;
            }
            for (Coding item : this.resourceType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addResourceType() {
            Coding t = new Coding();
            if (this.resourceType == null) {
                this.resourceType = new ArrayList<Coding>();
            }
            this.resourceType.add(t);
            return t;
        }

        public ProvisionComponent addResourceType(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.resourceType == null) {
                this.resourceType = new ArrayList<Coding>();
            }
            this.resourceType.add(t);
            return this;
        }

        public Coding getResourceTypeFirstRep() {
            if (this.getResourceType().isEmpty()) {
                this.addResourceType();
            }
            return this.getResourceType().get(0);
        }

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public ProvisionComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public ProvisionComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public Period getDataPeriod() {
            if (this.dataPeriod == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionComponent.dataPeriod");
                }
                if (Configuration.doAutoCreate()) {
                    this.dataPeriod = new Period();
                }
            }
            return this.dataPeriod;
        }

        public boolean hasDataPeriod() {
            return this.dataPeriod != null && !this.dataPeriod.isEmpty();
        }

        public ProvisionComponent setDataPeriod(Period value) {
            this.dataPeriod = value;
            return this;
        }

        public List<ProvisionDataComponent> getData() {
            if (this.data == null) {
                this.data = new ArrayList<ProvisionDataComponent>();
            }
            return this.data;
        }

        public ProvisionComponent setData(List<ProvisionDataComponent> theData) {
            this.data = theData;
            return this;
        }

        public boolean hasData() {
            if (this.data == null) {
                return false;
            }
            for (ProvisionDataComponent item : this.data) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProvisionDataComponent addData() {
            ProvisionDataComponent t = new ProvisionDataComponent();
            if (this.data == null) {
                this.data = new ArrayList<ProvisionDataComponent>();
            }
            this.data.add(t);
            return t;
        }

        public ProvisionComponent addData(ProvisionDataComponent t) {
            if (t == null) {
                return this;
            }
            if (this.data == null) {
                this.data = new ArrayList<ProvisionDataComponent>();
            }
            this.data.add(t);
            return this;
        }

        public ProvisionDataComponent getDataFirstRep() {
            if (this.getData().isEmpty()) {
                this.addData();
            }
            return this.getData().get(0);
        }

        public Expression getExpression() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProvisionComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new Expression();
                }
            }
            return this.expression;
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public ProvisionComponent setExpression(Expression value) {
            this.expression = value;
            return this;
        }

        public List<ProvisionComponent> getProvision() {
            if (this.provision == null) {
                this.provision = new ArrayList<ProvisionComponent>();
            }
            return this.provision;
        }

        public ProvisionComponent setProvision(List<ProvisionComponent> theProvision) {
            this.provision = theProvision;
            return this;
        }

        public boolean hasProvision() {
            if (this.provision == null) {
                return false;
            }
            for (ProvisionComponent item : this.provision) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ProvisionComponent addProvision() {
            ProvisionComponent t = new ProvisionComponent();
            if (this.provision == null) {
                this.provision = new ArrayList<ProvisionComponent>();
            }
            this.provision.add(t);
            return t;
        }

        public ProvisionComponent addProvision(ProvisionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.provision == null) {
                this.provision = new ArrayList<ProvisionComponent>();
            }
            this.provision.add(t);
            return this;
        }

        public ProvisionComponent getProvisionFirstRep() {
            if (this.getProvision().isEmpty()) {
                this.addProvision();
            }
            return this.getProvision().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "Action  to take - permit or deny - when the provision conditions are met.", 0, 1, this.type));
            children.add(new Property(Consent.SP_PERIOD, "Period", "Timeframe for this provision.", 0, 1, this.period));
            children.add(new Property(Consent.SP_ACTOR, "", "Who or what is controlled by this provision. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, Integer.MAX_VALUE, this.actor));
            children.add(new Property(Consent.SP_ACTION, "CodeableConcept", "Actions controlled by this provision.", 0, Integer.MAX_VALUE, this.action));
            children.add(new Property("securityLabel", "Coding", "A security label, comprised of 0..* security label fields (Privacy tags), which define which resources are controlled by this exception.", 0, Integer.MAX_VALUE, this.securityLabel));
            children.add(new Property(Consent.SP_PURPOSE, "Coding", "The context of the activities a user is taking - why the user is accessing the data - that are controlled by this provision.", 0, Integer.MAX_VALUE, this.purpose));
            children.add(new Property("documentType", "Coding", "The documentType(s) covered by this provision. The type can be a CDA document, or some other type that indicates what sort of information the consent relates to.", 0, Integer.MAX_VALUE, this.documentType));
            children.add(new Property("resourceType", "Coding", "The resourceType(s) covered by this provision. The type can be a FHIR resource type or a profile on a type that indicates what information the consent relates to.", 0, Integer.MAX_VALUE, this.resourceType));
            children.add(new Property("code", "CodeableConcept", "If this code is found in an instance, then the provision applies.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property("dataPeriod", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this provision.", 0, 1, this.dataPeriod));
            children.add(new Property(Consent.SP_DATA, "", "The resources controlled by this provision if specific resources are referenced.", 0, Integer.MAX_VALUE, this.data));
            children.add(new Property("expression", "Expression", "A computable (FHIRPath or other) definition of what is controlled by this consent.", 0, 1, this.expression));
            children.add(new Property("provision", "@Consent.provision", "Provisions which provide exceptions to the base provision or subprovisions.", 0, Integer.MAX_VALUE, this.provision));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "Action  to take - permit or deny - when the provision conditions are met.", 0, 1, this.type);
                }
                case -991726143: {
                    return new Property(Consent.SP_PERIOD, "Period", "Timeframe for this provision.", 0, 1, this.period);
                }
                case 92645877: {
                    return new Property(Consent.SP_ACTOR, "", "Who or what is controlled by this provision. Use group to identify a set of actors by some property they share (e.g. 'admitting officers').", 0, Integer.MAX_VALUE, this.actor);
                }
                case -1422950858: {
                    return new Property(Consent.SP_ACTION, "CodeableConcept", "Actions controlled by this provision.", 0, Integer.MAX_VALUE, this.action);
                }
                case -722296940: {
                    return new Property("securityLabel", "Coding", "A security label, comprised of 0..* security label fields (Privacy tags), which define which resources are controlled by this exception.", 0, Integer.MAX_VALUE, this.securityLabel);
                }
                case -220463842: {
                    return new Property(Consent.SP_PURPOSE, "Coding", "The context of the activities a user is taking - why the user is accessing the data - that are controlled by this provision.", 0, Integer.MAX_VALUE, this.purpose);
                }
                case -1473196299: {
                    return new Property("documentType", "Coding", "The documentType(s) covered by this provision. The type can be a CDA document, or some other type that indicates what sort of information the consent relates to.", 0, Integer.MAX_VALUE, this.documentType);
                }
                case -384364440: {
                    return new Property("resourceType", "Coding", "The resourceType(s) covered by this provision. The type can be a FHIR resource type or a profile on a type that indicates what information the consent relates to.", 0, Integer.MAX_VALUE, this.resourceType);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "If this code is found in an instance, then the provision applies.", 0, Integer.MAX_VALUE, this.code);
                }
                case 1177250315: {
                    return new Property("dataPeriod", "Period", "Clinical or Operational Relevant period of time that bounds the data controlled by this provision.", 0, 1, this.dataPeriod);
                }
                case 3076010: {
                    return new Property(Consent.SP_DATA, "", "The resources controlled by this provision if specific resources are referenced.", 0, Integer.MAX_VALUE, this.data);
                }
                case -1795452264: {
                    return new Property("expression", "Expression", "A computable (FHIRPath or other) definition of what is controlled by this consent.", 0, 1, this.expression);
                }
                case -547120939: {
                    return new Property("provision", "@Consent.provision", "Provisions which provide exceptions to the base provision or subprovisions.", 0, Integer.MAX_VALUE, this.provision);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
                case 92645877: {
                    return this.actor == null ? new Base[]{} : this.actor.toArray(new Base[this.actor.size()]);
                }
                case -1422950858: {
                    return this.action == null ? new Base[]{} : this.action.toArray(new Base[this.action.size()]);
                }
                case -722296940: {
                    return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
                }
                case -220463842: {
                    return this.purpose == null ? new Base[]{} : this.purpose.toArray(new Base[this.purpose.size()]);
                }
                case -1473196299: {
                    return this.documentType == null ? new Base[]{} : this.documentType.toArray(new Base[this.documentType.size()]);
                }
                case -384364440: {
                    return this.resourceType == null ? new Base[]{} : this.resourceType.toArray(new Base[this.resourceType.size()]);
                }
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case 1177250315: {
                    Base[] baseArray;
                    if (this.dataPeriod == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.dataPeriod;
                    }
                    return baseArray;
                }
                case 3076010: {
                    return this.data == null ? new Base[]{} : this.data.toArray(new Base[this.data.size()]);
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.expression;
                    }
                    return baseArray;
                }
                case -547120939: {
                    return this.provision == null ? new Base[]{} : this.provision.toArray(new Base[this.provision.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new Enumerations.ConsentProvisionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 92645877: {
                    this.getActor().add((ProvisionActorComponent)((Object)value));
                    return value;
                }
                case -1422950858: {
                    this.getAction().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -722296940: {
                    this.getSecurityLabel().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case -220463842: {
                    this.getPurpose().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case -1473196299: {
                    this.getDocumentType().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case -384364440: {
                    this.getResourceType().add(TypeConvertor.castToCoding(value));
                    return value;
                }
                case 3059181: {
                    this.getCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1177250315: {
                    this.dataPeriod = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case 3076010: {
                    this.getData().add((ProvisionDataComponent)((Object)value));
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToExpression(value);
                    return value;
                }
                case -547120939: {
                    this.getProvision().add((ProvisionComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new Enumerations.ConsentProvisionTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals(Consent.SP_PERIOD)) {
                this.period = TypeConvertor.castToPeriod(value);
            } else if (name.equals(Consent.SP_ACTOR)) {
                this.getActor().add((ProvisionActorComponent)((Object)value));
            } else if (name.equals(Consent.SP_ACTION)) {
                this.getAction().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("securityLabel")) {
                this.getSecurityLabel().add(TypeConvertor.castToCoding(value));
            } else if (name.equals(Consent.SP_PURPOSE)) {
                this.getPurpose().add(TypeConvertor.castToCoding(value));
            } else if (name.equals("documentType")) {
                this.getDocumentType().add(TypeConvertor.castToCoding(value));
            } else if (name.equals("resourceType")) {
                this.getResourceType().add(TypeConvertor.castToCoding(value));
            } else if (name.equals("code")) {
                this.getCode().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("dataPeriod")) {
                this.dataPeriod = TypeConvertor.castToPeriod(value);
            } else if (name.equals(Consent.SP_DATA)) {
                this.getData().add((ProvisionDataComponent)((Object)value));
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToExpression(value);
            } else if (name.equals("provision")) {
                this.getProvision().add((ProvisionComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case 92645877: {
                    return this.addActor();
                }
                case -1422950858: {
                    return this.addAction();
                }
                case -722296940: {
                    return this.addSecurityLabel();
                }
                case -220463842: {
                    return this.addPurpose();
                }
                case -1473196299: {
                    return this.addDocumentType();
                }
                case -384364440: {
                    return this.addResourceType();
                }
                case 3059181: {
                    return this.addCode();
                }
                case 1177250315: {
                    return this.getDataPeriod();
                }
                case 3076010: {
                    return this.addData();
                }
                case -1795452264: {
                    return this.getExpression();
                }
                case -547120939: {
                    return this.addProvision();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case 92645877: {
                    return new String[0];
                }
                case -1422950858: {
                    return new String[]{"CodeableConcept"};
                }
                case -722296940: {
                    return new String[]{"Coding"};
                }
                case -220463842: {
                    return new String[]{"Coding"};
                }
                case -1473196299: {
                    return new String[]{"Coding"};
                }
                case -384364440: {
                    return new String[]{"Coding"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case 1177250315: {
                    return new String[]{"Period"};
                }
                case 3076010: {
                    return new String[0];
                }
                case -1795452264: {
                    return new String[]{"Expression"};
                }
                case -547120939: {
                    return new String[]{"@Consent.provision"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.provision.type");
            }
            if (name.equals(Consent.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals(Consent.SP_ACTOR)) {
                return this.addActor();
            }
            if (name.equals(Consent.SP_ACTION)) {
                return this.addAction();
            }
            if (name.equals("securityLabel")) {
                return this.addSecurityLabel();
            }
            if (name.equals(Consent.SP_PURPOSE)) {
                return this.addPurpose();
            }
            if (name.equals("documentType")) {
                return this.addDocumentType();
            }
            if (name.equals("resourceType")) {
                return this.addResourceType();
            }
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals("dataPeriod")) {
                this.dataPeriod = new Period();
                return this.dataPeriod;
            }
            if (name.equals(Consent.SP_DATA)) {
                return this.addData();
            }
            if (name.equals("expression")) {
                this.expression = new Expression();
                return this.expression;
            }
            if (name.equals("provision")) {
                return this.addProvision();
            }
            return super.addChild(name);
        }

        @Override
        public ProvisionComponent copy() {
            ProvisionComponent dst = new ProvisionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ProvisionComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.actor != null) {
                dst.actor = new ArrayList<ProvisionActorComponent>();
                for (ProvisionActorComponent provisionActorComponent : this.actor) {
                    dst.actor.add(provisionActorComponent.copy());
                }
            }
            if (this.action != null) {
                dst.action = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.action) {
                    dst.action.add(codeableConcept.copy());
                }
            }
            if (this.securityLabel != null) {
                dst.securityLabel = new ArrayList<Coding>();
                for (Coding coding : this.securityLabel) {
                    dst.securityLabel.add(coding.copy());
                }
            }
            if (this.purpose != null) {
                dst.purpose = new ArrayList<Coding>();
                for (Coding coding : this.purpose) {
                    dst.purpose.add(coding.copy());
                }
            }
            if (this.documentType != null) {
                dst.documentType = new ArrayList<Coding>();
                for (Coding coding : this.documentType) {
                    dst.documentType.add(coding.copy());
                }
            }
            if (this.resourceType != null) {
                dst.resourceType = new ArrayList<Coding>();
                for (Coding coding : this.resourceType) {
                    dst.resourceType.add(coding.copy());
                }
            }
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            Period period2 = dst.dataPeriod = this.dataPeriod == null ? null : this.dataPeriod.copy();
            if (this.data != null) {
                dst.data = new ArrayList<ProvisionDataComponent>();
                for (ProvisionDataComponent provisionDataComponent : this.data) {
                    dst.data.add(provisionDataComponent.copy());
                }
            }
            Expression expression = dst.expression = this.expression == null ? null : this.expression.copy();
            if (this.provision != null) {
                dst.provision = new ArrayList<ProvisionComponent>();
                for (ProvisionComponent provisionComponent : this.provision) {
                    dst.provision.add(provisionComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionComponent)) {
                return false;
            }
            ProvisionComponent o = (ProvisionComponent)other_;
            return ProvisionComponent.compareDeep(this.type, o.type, true) && ProvisionComponent.compareDeep(this.period, o.period, true) && ProvisionComponent.compareDeep(this.actor, o.actor, true) && ProvisionComponent.compareDeep(this.action, o.action, true) && ProvisionComponent.compareDeep(this.securityLabel, o.securityLabel, true) && ProvisionComponent.compareDeep(this.purpose, o.purpose, true) && ProvisionComponent.compareDeep(this.documentType, o.documentType, true) && ProvisionComponent.compareDeep(this.resourceType, o.resourceType, true) && ProvisionComponent.compareDeep(this.code, o.code, true) && ProvisionComponent.compareDeep(this.dataPeriod, o.dataPeriod, true) && ProvisionComponent.compareDeep(this.data, o.data, true) && ProvisionComponent.compareDeep(this.expression, o.expression, true) && ProvisionComponent.compareDeep(this.provision, o.provision, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProvisionComponent)) {
                return false;
            }
            ProvisionComponent o = (ProvisionComponent)other_;
            return ProvisionComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.period, this.actor, this.action, this.securityLabel, this.purpose, this.documentType, this.resourceType, this.code, this.dataPeriod, this.data, this.expression, this.provision);
        }

        @Override
        public String fhirType() {
            return "Consent.provision";
        }
    }

    @Block
    public static class ConsentVerificationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="verified", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Has been verified", formalDefinition="Has the instruction been verified.")
        protected BooleanType verified;
        @Child(name="verificationType", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Business case of verification", formalDefinition="Extensible list of verification type starting with verification and re-validation.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/consent-verification")
        protected CodeableConcept verificationType;
        @Child(name="verifiedBy", type={Organization.class, Practitioner.class, PractitionerRole.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Person conducting verification", formalDefinition="The person who conducted the verification/validation of the Grantor decision.")
        protected Reference verifiedBy;
        @Child(name="verifiedWith", type={Patient.class, RelatedPerson.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Person who verified", formalDefinition="Who verified the instruction (Patient, Relative or other Authorized Person).")
        protected Reference verifiedWith;
        @Child(name="verificationDate", type={DateTimeType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="When consent verified", formalDefinition="Date(s) verification was collected.")
        protected List<DateTimeType> verificationDate;
        private static final long serialVersionUID = -1266157329L;

        public ConsentVerificationComponent() {
        }

        public ConsentVerificationComponent(boolean verified) {
            this.setVerified(verified);
        }

        public BooleanType getVerifiedElement() {
            if (this.verified == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentVerificationComponent.verified");
                }
                if (Configuration.doAutoCreate()) {
                    this.verified = new BooleanType();
                }
            }
            return this.verified;
        }

        public boolean hasVerifiedElement() {
            return this.verified != null && !this.verified.isEmpty();
        }

        public boolean hasVerified() {
            return this.verified != null && !this.verified.isEmpty();
        }

        public ConsentVerificationComponent setVerifiedElement(BooleanType value) {
            this.verified = value;
            return this;
        }

        public boolean getVerified() {
            return this.verified == null || this.verified.isEmpty() ? false : (Boolean)this.verified.getValue();
        }

        public ConsentVerificationComponent setVerified(boolean value) {
            if (this.verified == null) {
                this.verified = new BooleanType();
            }
            this.verified.setValue((Object)value);
            return this;
        }

        public CodeableConcept getVerificationType() {
            if (this.verificationType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentVerificationComponent.verificationType");
                }
                if (Configuration.doAutoCreate()) {
                    this.verificationType = new CodeableConcept();
                }
            }
            return this.verificationType;
        }

        public boolean hasVerificationType() {
            return this.verificationType != null && !this.verificationType.isEmpty();
        }

        public ConsentVerificationComponent setVerificationType(CodeableConcept value) {
            this.verificationType = value;
            return this;
        }

        public Reference getVerifiedBy() {
            if (this.verifiedBy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentVerificationComponent.verifiedBy");
                }
                if (Configuration.doAutoCreate()) {
                    this.verifiedBy = new Reference();
                }
            }
            return this.verifiedBy;
        }

        public boolean hasVerifiedBy() {
            return this.verifiedBy != null && !this.verifiedBy.isEmpty();
        }

        public ConsentVerificationComponent setVerifiedBy(Reference value) {
            this.verifiedBy = value;
            return this;
        }

        public Reference getVerifiedWith() {
            if (this.verifiedWith == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentVerificationComponent.verifiedWith");
                }
                if (Configuration.doAutoCreate()) {
                    this.verifiedWith = new Reference();
                }
            }
            return this.verifiedWith;
        }

        public boolean hasVerifiedWith() {
            return this.verifiedWith != null && !this.verifiedWith.isEmpty();
        }

        public ConsentVerificationComponent setVerifiedWith(Reference value) {
            this.verifiedWith = value;
            return this;
        }

        public List<DateTimeType> getVerificationDate() {
            if (this.verificationDate == null) {
                this.verificationDate = new ArrayList<DateTimeType>();
            }
            return this.verificationDate;
        }

        public ConsentVerificationComponent setVerificationDate(List<DateTimeType> theVerificationDate) {
            this.verificationDate = theVerificationDate;
            return this;
        }

        public boolean hasVerificationDate() {
            if (this.verificationDate == null) {
                return false;
            }
            for (DateTimeType item : this.verificationDate) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DateTimeType addVerificationDateElement() {
            DateTimeType t = new DateTimeType();
            if (this.verificationDate == null) {
                this.verificationDate = new ArrayList<DateTimeType>();
            }
            this.verificationDate.add(t);
            return t;
        }

        public ConsentVerificationComponent addVerificationDate(Date value) {
            DateTimeType t = new DateTimeType();
            t.setValue(value);
            if (this.verificationDate == null) {
                this.verificationDate = new ArrayList<DateTimeType>();
            }
            this.verificationDate.add(t);
            return this;
        }

        public boolean hasVerificationDate(Date value) {
            if (this.verificationDate == null) {
                return false;
            }
            for (DateTimeType v : this.verificationDate) {
                if (!((Date)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Consent.SP_VERIFIED, "boolean", "Has the instruction been verified.", 0, 1, this.verified));
            children.add(new Property("verificationType", "CodeableConcept", "Extensible list of verification type starting with verification and re-validation.", 0, 1, this.verificationType));
            children.add(new Property("verifiedBy", "Reference(Organization|Practitioner|PractitionerRole)", "The person who conducted the verification/validation of the Grantor decision.", 0, 1, this.verifiedBy));
            children.add(new Property("verifiedWith", "Reference(Patient|RelatedPerson)", "Who verified the instruction (Patient, Relative or other Authorized Person).", 0, 1, this.verifiedWith));
            children.add(new Property("verificationDate", "dateTime", "Date(s) verification was collected.", 0, Integer.MAX_VALUE, this.verificationDate));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1994383672: {
                    return new Property(Consent.SP_VERIFIED, "boolean", "Has the instruction been verified.", 0, 1, this.verified);
                }
                case 642733045: {
                    return new Property("verificationType", "CodeableConcept", "Extensible list of verification type starting with verification and re-validation.", 0, 1, this.verificationType);
                }
                case -1047292609: {
                    return new Property("verifiedBy", "Reference(Organization|Practitioner|PractitionerRole)", "The person who conducted the verification/validation of the Grantor decision.", 0, 1, this.verifiedBy);
                }
                case -1425236050: {
                    return new Property("verifiedWith", "Reference(Patient|RelatedPerson)", "Who verified the instruction (Patient, Relative or other Authorized Person).", 0, 1, this.verifiedWith);
                }
                case 642233449: {
                    return new Property("verificationDate", "dateTime", "Date(s) verification was collected.", 0, Integer.MAX_VALUE, this.verificationDate);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    Base[] baseArray;
                    if (this.verified == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.verified;
                    }
                    return baseArray;
                }
                case 642733045: {
                    Base[] baseArray;
                    if (this.verificationType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.verificationType;
                    }
                    return baseArray;
                }
                case -1047292609: {
                    Base[] baseArray;
                    if (this.verifiedBy == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.verifiedBy;
                    }
                    return baseArray;
                }
                case -1425236050: {
                    Base[] baseArray;
                    if (this.verifiedWith == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.verifiedWith;
                    }
                    return baseArray;
                }
                case 642233449: {
                    return this.verificationDate == null ? new Base[]{} : this.verificationDate.toArray(new Base[this.verificationDate.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    this.verified = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 642733045: {
                    this.verificationType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1047292609: {
                    this.verifiedBy = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1425236050: {
                    this.verifiedWith = TypeConvertor.castToReference(value);
                    return value;
                }
                case 642233449: {
                    this.getVerificationDate().add(TypeConvertor.castToDateTime(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Consent.SP_VERIFIED)) {
                this.verified = TypeConvertor.castToBoolean(value);
            } else if (name.equals("verificationType")) {
                this.verificationType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("verifiedBy")) {
                this.verifiedBy = TypeConvertor.castToReference(value);
            } else if (name.equals("verifiedWith")) {
                this.verifiedWith = TypeConvertor.castToReference(value);
            } else if (name.equals("verificationDate")) {
                this.getVerificationDate().add(TypeConvertor.castToDateTime(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    return this.getVerifiedElement();
                }
                case 642733045: {
                    return this.getVerificationType();
                }
                case -1047292609: {
                    return this.getVerifiedBy();
                }
                case -1425236050: {
                    return this.getVerifiedWith();
                }
                case 642233449: {
                    return this.addVerificationDateElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1994383672: {
                    return new String[]{"boolean"};
                }
                case 642733045: {
                    return new String[]{"CodeableConcept"};
                }
                case -1047292609: {
                    return new String[]{"Reference"};
                }
                case -1425236050: {
                    return new String[]{"Reference"};
                }
                case 642233449: {
                    return new String[]{"dateTime"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Consent.SP_VERIFIED)) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.verification.verified");
            }
            if (name.equals("verificationType")) {
                this.verificationType = new CodeableConcept();
                return this.verificationType;
            }
            if (name.equals("verifiedBy")) {
                this.verifiedBy = new Reference();
                return this.verifiedBy;
            }
            if (name.equals("verifiedWith")) {
                this.verifiedWith = new Reference();
                return this.verifiedWith;
            }
            if (name.equals("verificationDate")) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.verification.verificationDate");
            }
            return super.addChild(name);
        }

        @Override
        public ConsentVerificationComponent copy() {
            ConsentVerificationComponent dst = new ConsentVerificationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConsentVerificationComponent dst) {
            super.copyValues(dst);
            dst.verified = this.verified == null ? null : this.verified.copy();
            dst.verificationType = this.verificationType == null ? null : this.verificationType.copy();
            dst.verifiedBy = this.verifiedBy == null ? null : this.verifiedBy.copy();
            Reference reference = dst.verifiedWith = this.verifiedWith == null ? null : this.verifiedWith.copy();
            if (this.verificationDate != null) {
                dst.verificationDate = new ArrayList<DateTimeType>();
                for (DateTimeType i2 : this.verificationDate) {
                    dst.verificationDate.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentVerificationComponent)) {
                return false;
            }
            ConsentVerificationComponent o = (ConsentVerificationComponent)other_;
            return ConsentVerificationComponent.compareDeep(this.verified, o.verified, true) && ConsentVerificationComponent.compareDeep(this.verificationType, o.verificationType, true) && ConsentVerificationComponent.compareDeep(this.verifiedBy, o.verifiedBy, true) && ConsentVerificationComponent.compareDeep(this.verifiedWith, o.verifiedWith, true) && ConsentVerificationComponent.compareDeep(this.verificationDate, o.verificationDate, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentVerificationComponent)) {
                return false;
            }
            ConsentVerificationComponent o = (ConsentVerificationComponent)other_;
            return ConsentVerificationComponent.compareValues(this.verified, o.verified, true) && ConsentVerificationComponent.compareValues(this.verificationDate, o.verificationDate, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.verified, this.verificationType, this.verifiedBy, this.verifiedWith, this.verificationDate);
        }

        @Override
        public String fhirType() {
            return "Consent.verification";
        }
    }

    @Block
    public static class ConsentPolicyBasisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="reference", type={Reference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reference backing policy resource", formalDefinition="A Reference that identifies the policy the organization will enforce for this Consent.")
        protected Reference reference;
        @Child(name="url", type={UrlType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="URL to a computable backing policy", formalDefinition="A URL that links to a computable version of the policy the organization will enforce for this Consent.")
        protected UrlType url;
        private static final long serialVersionUID = 252506182L;

        public Reference getReference() {
            if (this.reference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentPolicyBasisComponent.reference");
                }
                if (Configuration.doAutoCreate()) {
                    this.reference = new Reference();
                }
            }
            return this.reference;
        }

        public boolean hasReference() {
            return this.reference != null && !this.reference.isEmpty();
        }

        public ConsentPolicyBasisComponent setReference(Reference value) {
            this.reference = value;
            return this;
        }

        public UrlType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ConsentPolicyBasisComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UrlType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public ConsentPolicyBasisComponent setUrlElement(UrlType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public ConsentPolicyBasisComponent setUrl(String value) {
            if (Utilities.noString(value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UrlType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("reference", "Reference(Any)", "A Reference that identifies the policy the organization will enforce for this Consent.", 0, 1, this.reference));
            children.add(new Property("url", "url", "A URL that links to a computable version of the policy the organization will enforce for this Consent.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -925155509: {
                    return new Property("reference", "Reference(Any)", "A Reference that identifies the policy the organization will enforce for this Consent.", 0, 1, this.reference);
                }
                case 116079: {
                    return new Property("url", "url", "A URL that links to a computable version of the policy the organization will enforce for this Consent.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    Base[] baseArray;
                    if (this.reference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.reference;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    this.reference = TypeConvertor.castToReference(value);
                    return value;
                }
                case 116079: {
                    this.url = TypeConvertor.castToUrl(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = TypeConvertor.castToReference(value);
            } else if (name.equals("url")) {
                this.url = TypeConvertor.castToUrl(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return this.getReference();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -925155509: {
                    return new String[]{"Reference"};
                }
                case 116079: {
                    return new String[]{"url"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("reference")) {
                this.reference = new Reference();
                return this.reference;
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type Consent.policyBasis.url");
            }
            return super.addChild(name);
        }

        @Override
        public ConsentPolicyBasisComponent copy() {
            ConsentPolicyBasisComponent dst = new ConsentPolicyBasisComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ConsentPolicyBasisComponent dst) {
            super.copyValues(dst);
            dst.reference = this.reference == null ? null : this.reference.copy();
            dst.url = this.url == null ? null : this.url.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentPolicyBasisComponent)) {
                return false;
            }
            ConsentPolicyBasisComponent o = (ConsentPolicyBasisComponent)other_;
            return ConsentPolicyBasisComponent.compareDeep(this.reference, o.reference, true) && ConsentPolicyBasisComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ConsentPolicyBasisComponent)) {
                return false;
            }
            ConsentPolicyBasisComponent o = (ConsentPolicyBasisComponent)other_;
            return ConsentPolicyBasisComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.reference, this.url);
        }

        @Override
        public String fhirType() {
            return "Consent.policyBasis";
        }
    }

    public static class ConsentStateEnumFactory
    implements EnumFactory<ConsentState> {
        @Override
        public ConsentState fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return ConsentState.DRAFT;
            }
            if ("active".equals(codeString)) {
                return ConsentState.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return ConsentState.INACTIVE;
            }
            if ("not-done".equals(codeString)) {
                return ConsentState.NOTDONE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ConsentState.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ConsentState.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ConsentState code '" + codeString + "'");
        }

        public Enumeration<ConsentState> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ConsentState>(this, ConsentState.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.NULL, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.DRAFT, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.ACTIVE, code);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.INACTIVE, code);
            }
            if ("not-done".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.NOTDONE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ConsentState>(this, ConsentState.UNKNOWN, code);
            }
            throw new FHIRException("Unknown ConsentState code '" + codeString + "'");
        }

        @Override
        public String toCode(ConsentState code) {
            if (code == ConsentState.DRAFT) {
                return "draft";
            }
            if (code == ConsentState.ACTIVE) {
                return "active";
            }
            if (code == ConsentState.INACTIVE) {
                return "inactive";
            }
            if (code == ConsentState.NOTDONE) {
                return "not-done";
            }
            if (code == ConsentState.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ConsentState.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ConsentState code) {
            return code.getSystem();
        }
    }

    public static enum ConsentState {
        DRAFT,
        ACTIVE,
        INACTIVE,
        NOTDONE,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ConsentState fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            if ("not-done".equals(codeString)) {
                return NOTDONE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ConsentState code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case NOTDONE: {
                    return "not-done";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case NOTDONE: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/consent-state-codes";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The consent is in development or awaiting use but is not yet intended to be acted upon.";
                }
                case ACTIVE: {
                    return "The consent is to be followed and enforced.";
                }
                case INACTIVE: {
                    return "The consent is terminated or replaced.";
                }
                case NOTDONE: {
                    return "The consent development has been terminated prior to completion.";
                }
                case ENTEREDINERROR: {
                    return "The consent was created wrongly (e.g. wrong patient) and should be ignored.";
                }
                case UNKNOWN: {
                    return "The resource is in an indeterminate state.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Pending";
                }
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case NOTDONE: {
                    return "Abandoned";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

