/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.SpecialClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Composition", profile="http://hl7.org/fhir/StructureDefinition/Composition")
public class Composition
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this Composition, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this Composition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this Composition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the Composition is stored on different servers.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Version-independent identifier for the Composition", formalDefinition="A version-independent identifier for the Composition. This identifier stays constant as the composition is changed over time.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An explicitly assigned identifer of a variation of the content in the Composition", formalDefinition="An explicitly assigned identifer of a variation of the content in the Composition.")
    protected StringType version;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="registered | partial | preliminary | final | amended | corrected | appended | cancelled | entered-in-error | deprecated | unknown", formalDefinition="The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/composition-status")
    protected Enumeration<Enumerations.CompositionStatus> status;
    @Child(name="type", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of composition (LOINC if possible)", formalDefinition="Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/doc-typecodes")
    protected CodeableConcept type;
    @Child(name="category", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Categorization of Composition", formalDefinition="A categorization for the type of the composition - helps for indexing and searching. This may be implied by or derived from the code specified in the Composition Type.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/referenced-item-category")
    protected List<CodeableConcept> category;
    @Child(name="subject", type={Reference.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what the composition is about", formalDefinition="Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).")
    protected List<Reference> subject;
    @Child(name="encounter", type={Encounter.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Context of the Composition", formalDefinition="Describes the clinical encounter or type of care this documentation is associated with.")
    protected Reference encounter;
    @Child(name="date", type={DateTimeType.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composition editing time", formalDefinition="The composition editing time, when the composition was last logically changed by the author.")
    protected DateTimeType date;
    @Child(name="useContext", type={UsageContext.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate Composition instances.")
    protected List<UsageContext> useContext;
    @Child(name="author", type={Practitioner.class, PractitionerRole.class, Device.class, Patient.class, RelatedPerson.class, Organization.class}, order=10, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what authored the composition", formalDefinition="Identifies who is responsible for the information in the composition, not necessarily who typed it in.")
    protected List<Reference> author;
    @Child(name="name", type={StringType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this Composition (computer friendly)", formalDefinition="A natural language name identifying the composition. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="title", type={StringType.class}, order=12, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human Readable name/title", formalDefinition="Official human-readable label for the composition.")
    protected StringType title;
    @Child(name="note", type={Annotation.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="For any additional notes", formalDefinition="For any additional notes.")
    protected List<Annotation> note;
    @Child(name="attester", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Attests to accuracy of composition", formalDefinition="A participant who has attested to the accuracy of the composition/document.")
    protected List<CompositionAttesterComponent> attester;
    @Child(name="custodian", type={Organization.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization which maintains the composition", formalDefinition="Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information.")
    protected Reference custodian;
    @Child(name="relatesTo", type={RelatedArtifact.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Relationships to other compositions/documents", formalDefinition="Relationships that this composition has with other compositions or documents that already exist.")
    protected List<RelatedArtifact> relatesTo;
    @Child(name="event", type={}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The clinical service(s) being documented", formalDefinition="The clinical service, such as a colonoscopy or an appendectomy, being documented.")
    protected List<CompositionEventComponent> event;
    @Child(name="section", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Composition is broken into sections", formalDefinition="The root of the sections that make up the composition.")
    protected List<SectionComponent> section;
    private static final long serialVersionUID = 2030933035L;
    @SearchParamDefinition(name="attester", path="Composition.attester.party", description="Who attested the composition", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_ATTESTER = "attester";
    public static final ReferenceClientParam ATTESTER = new ReferenceClientParam("attester");
    public static final Include INCLUDE_ATTESTER = new Include("Composition:attester").toLocked();
    @SearchParamDefinition(name="author", path="Composition.author", description="Who and/or what authored the composition", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("Composition:author").toLocked();
    @SearchParamDefinition(name="category", path="Composition.category", description="Categorization of Composition", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="context", path="Composition.event.code", description="Code(s) that apply to the event being documented", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="entry", path="Composition.section.entry", description="A reference to data that supports this section", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_ENTRY = "entry";
    public static final ReferenceClientParam ENTRY = new ReferenceClientParam("entry");
    public static final Include INCLUDE_ENTRY = new Include("Composition:entry").toLocked();
    @SearchParamDefinition(name="period", path="Composition.event.period", description="The period covered by the documentation", type="date")
    public static final String SP_PERIOD = "period";
    public static final DateClientParam PERIOD = new DateClientParam("period");
    @SearchParamDefinition(name="related", path="Composition.relatesTo.resourceReference", description="Target of the relationship", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_RELATED = "related";
    public static final ReferenceClientParam RELATED = new ReferenceClientParam("related");
    public static final Include INCLUDE_RELATED = new Include("Composition:related").toLocked();
    @SearchParamDefinition(name="section-code-text", path="Composition.section", description="Search on the section narrative of the resource", type="composite", compositeOf={"section", "section-text"})
    public static final String SP_SECTION_CODE_TEXT = "section-code-text";
    public static final CompositeClientParam<TokenClientParam, SpecialClientParam> SECTION_CODE_TEXT = new CompositeClientParam("section-code-text");
    @SearchParamDefinition(name="section-text", path="Composition.section.text | Composition.section.section.text", description="Search on the section narrative of the resource", type="special")
    public static final String SP_SECTION_TEXT = "section-text";
    public static final SpecialClientParam SECTION_TEXT = new SpecialClientParam("section-text");
    @SearchParamDefinition(name="section", path="Composition.section.code", description="Classification of section (recommended)", type="token")
    public static final String SP_SECTION = "section";
    public static final TokenClientParam SECTION = new TokenClientParam("section");
    @SearchParamDefinition(name="status", path="Composition.status", description="preliminary | final | amended | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Composition.subject", description="Who and/or what the composition is about", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Composition:subject").toLocked();
    @SearchParamDefinition(name="title", path="Composition.title", description="Human Readable name/title", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="url", path="Composition.url", description="The uri that identifies the activity definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="Composition.version", description="The business version of the activity definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.as(dateTime) | DiagnosticReport.effective.as(Period) | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective.as(dateTime) | Observation.effective.as(Period) | Observation.effective.as(Timing) | Observation.effective.as(instant) | Procedure.occurrence.as(dateTime) | Procedure.occurrence.as(Period) | Procedure.occurrence.as(Timing) | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="Composition.encounter | DeviceRequest.encounter | DiagnosticReport.encounter | Flag.encounter | List.encounter | NutritionOrder.encounter | Observation.encounter | Procedure.encounter | RiskAssessment.encounter | ServiceRequest.encounter | VisionPrescription.encounter", description="Multiple Resources: \r\n\r\n* [Composition](composition.html): Context of the Composition\r\n* [DeviceRequest](devicerequest.html): Encounter during which request was created\r\n* [DiagnosticReport](diagnosticreport.html): The Encounter when the order was made\r\n* [Flag](flag.html): Alert relevant during encounter\r\n* [List](list.html): Context in which list created\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this encounter identifier\r\n* [Observation](observation.html): Encounter related to the observation\r\n* [Procedure](procedure.html): The Encounter during which this Procedure was created\r\n* [RiskAssessment](riskassessment.html): Where was assessment performed?\r\n* [ServiceRequest](servicerequest.html): An encounter in which this request is made\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this encounter identifier\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Composition:encounter").toLocked();
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.subject | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Composition:patient").toLocked();
    @SearchParamDefinition(name="type", path="AllergyIntolerance.type | Composition.type | DocumentManifest.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [DocumentManifest](documentmanifest.html): Kind of document set\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public Composition() {
    }

    public Composition(Enumerations.CompositionStatus status, CodeableConcept type, Date date, Reference author, String title) {
        this.setStatus(status);
        this.setType(type);
        this.setDate(date);
        this.addAuthor(author);
        this.setTitle(title);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Composition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Composition setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Composition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Composition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Composition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Composition setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public Enumeration<Enumerations.CompositionStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.CompositionStatus>(new Enumerations.CompositionStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Composition setStatusElement(Enumeration<Enumerations.CompositionStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.CompositionStatus getStatus() {
        return this.status == null ? null : (Enumerations.CompositionStatus)((Object)this.status.getValue());
    }

    public Composition setStatus(Enumerations.CompositionStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.CompositionStatus>(new Enumerations.CompositionStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Composition setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Composition setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Composition addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public Composition setSubject(List<Reference> theSubject) {
        this.subject = theSubject;
        return this;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public Composition addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public Reference getSubjectFirstRep() {
        if (this.getSubject().isEmpty()) {
            this.addSubject();
        }
        return this.getSubject().get(0);
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public Composition setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Composition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Composition setDate(Date value) {
        if (this.date == null) {
            this.date = new DateTimeType();
        }
        this.date.setValue(value);
        return this;
    }

    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    public Composition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    public Composition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public List<Reference> getAuthor() {
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        return this.author;
    }

    public Composition setAuthor(List<Reference> theAuthor) {
        this.author = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.author == null) {
            return false;
        }
        for (Reference item : this.author) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthor() {
        Reference t = new Reference();
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return t;
    }

    public Composition addAuthor(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.author == null) {
            this.author = new ArrayList<Reference>();
        }
        this.author.add(t);
        return this;
    }

    public Reference getAuthorFirstRep() {
        if (this.getAuthor().isEmpty()) {
            this.addAuthor();
        }
        return this.getAuthor().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Composition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Composition setName(String value) {
        if (Utilities.noString(value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public Composition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public Composition setTitle(String value) {
        if (this.title == null) {
            this.title = new StringType();
        }
        this.title.setValue(value);
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Composition setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Composition addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<CompositionAttesterComponent> getAttester() {
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttesterComponent>();
        }
        return this.attester;
    }

    public Composition setAttester(List<CompositionAttesterComponent> theAttester) {
        this.attester = theAttester;
        return this;
    }

    public boolean hasAttester() {
        if (this.attester == null) {
            return false;
        }
        for (CompositionAttesterComponent item : this.attester) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompositionAttesterComponent addAttester() {
        CompositionAttesterComponent t = new CompositionAttesterComponent();
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttesterComponent>();
        }
        this.attester.add(t);
        return t;
    }

    public Composition addAttester(CompositionAttesterComponent t) {
        if (t == null) {
            return this;
        }
        if (this.attester == null) {
            this.attester = new ArrayList<CompositionAttesterComponent>();
        }
        this.attester.add(t);
        return this;
    }

    public CompositionAttesterComponent getAttesterFirstRep() {
        if (this.getAttester().isEmpty()) {
            this.addAttester();
        }
        return this.getAttester().get(0);
    }

    public Reference getCustodian() {
        if (this.custodian == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Composition.custodian");
            }
            if (Configuration.doAutoCreate()) {
                this.custodian = new Reference();
            }
        }
        return this.custodian;
    }

    public boolean hasCustodian() {
        return this.custodian != null && !this.custodian.isEmpty();
    }

    public Composition setCustodian(Reference value) {
        this.custodian = value;
        return this;
    }

    public List<RelatedArtifact> getRelatesTo() {
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<RelatedArtifact>();
        }
        return this.relatesTo;
    }

    public Composition setRelatesTo(List<RelatedArtifact> theRelatesTo) {
        this.relatesTo = theRelatesTo;
        return this;
    }

    public boolean hasRelatesTo() {
        if (this.relatesTo == null) {
            return false;
        }
        for (RelatedArtifact item : this.relatesTo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedArtifact addRelatesTo() {
        RelatedArtifact t = new RelatedArtifact();
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<RelatedArtifact>();
        }
        this.relatesTo.add(t);
        return t;
    }

    public Composition addRelatesTo(RelatedArtifact t) {
        if (t == null) {
            return this;
        }
        if (this.relatesTo == null) {
            this.relatesTo = new ArrayList<RelatedArtifact>();
        }
        this.relatesTo.add(t);
        return this;
    }

    public RelatedArtifact getRelatesToFirstRep() {
        if (this.getRelatesTo().isEmpty()) {
            this.addRelatesTo();
        }
        return this.getRelatesTo().get(0);
    }

    public List<CompositionEventComponent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<CompositionEventComponent>();
        }
        return this.event;
    }

    public Composition setEvent(List<CompositionEventComponent> theEvent) {
        this.event = theEvent;
        return this;
    }

    public boolean hasEvent() {
        if (this.event == null) {
            return false;
        }
        for (CompositionEventComponent item : this.event) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CompositionEventComponent addEvent() {
        CompositionEventComponent t = new CompositionEventComponent();
        if (this.event == null) {
            this.event = new ArrayList<CompositionEventComponent>();
        }
        this.event.add(t);
        return t;
    }

    public Composition addEvent(CompositionEventComponent t) {
        if (t == null) {
            return this;
        }
        if (this.event == null) {
            this.event = new ArrayList<CompositionEventComponent>();
        }
        this.event.add(t);
        return this;
    }

    public CompositionEventComponent getEventFirstRep() {
        if (this.getEvent().isEmpty()) {
            this.addEvent();
        }
        return this.getEvent().get(0);
    }

    public List<SectionComponent> getSection() {
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        return this.section;
    }

    public Composition setSection(List<SectionComponent> theSection) {
        this.section = theSection;
        return this;
    }

    public boolean hasSection() {
        if (this.section == null) {
            return false;
        }
        for (SectionComponent item : this.section) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SectionComponent addSection() {
        SectionComponent t = new SectionComponent();
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        this.section.add(t);
        return t;
    }

    public Composition addSection(SectionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.section == null) {
            this.section = new ArrayList<SectionComponent>();
        }
        this.section.add(t);
        return this;
    }

    public SectionComponent getSectionFirstRep() {
        if (this.getSection().isEmpty()) {
            this.addSection();
        }
        return this.getSection().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this Composition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this Composition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the Composition is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A version-independent identifier for the Composition. This identifier stays constant as the composition is changed over time.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "An explicitly assigned identifer of a variation of the content in the Composition.", 0, 1, this.version));
        children.add(new Property(SP_STATUS, "code", "The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.", 0, 1, this.status));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition.", 0, 1, this.type));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "A categorization for the type of the composition - helps for indexing and searching. This may be implied by or derived from the code specified in the Composition Type.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_SUBJECT, "Reference(Any)", "Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).", 0, Integer.MAX_VALUE, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "Describes the clinical encounter or type of care this documentation is associated with.", 0, 1, this.encounter));
        children.add(new Property(SP_DATE, "dateTime", "The composition editing time, when the composition was last logically changed by the author.", 0, 1, this.date));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate Composition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Device|Patient|RelatedPerson|Organization)", "Identifies who is responsible for the information in the composition, not necessarily who typed it in.", 0, Integer.MAX_VALUE, this.author));
        children.add(new Property("name", "string", "A natural language name identifying the composition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "Official human-readable label for the composition.", 0, 1, this.title));
        children.add(new Property("note", "Annotation", "For any additional notes.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property(SP_ATTESTER, "", "A participant who has attested to the accuracy of the composition/document.", 0, Integer.MAX_VALUE, this.attester));
        children.add(new Property("custodian", "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information.", 0, 1, this.custodian));
        children.add(new Property("relatesTo", "RelatedArtifact", "Relationships that this composition has with other compositions or documents that already exist.", 0, Integer.MAX_VALUE, this.relatesTo));
        children.add(new Property("event", "", "The clinical service, such as a colonoscopy or an appendectomy, being documented.", 0, Integer.MAX_VALUE, this.event));
        children.add(new Property(SP_SECTION, "", "The root of the sections that make up the composition.", 0, Integer.MAX_VALUE, this.section));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this Composition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which an authoritative instance of this Composition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the Composition is stored on different servers.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A version-independent identifier for the Composition. This identifier stays constant as the composition is changed over time.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "An explicitly assigned identifer of a variation of the content in the Composition.", 0, 1, this.version);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document.", 0, 1, this.status);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition.", 0, 1, this.type);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "A categorization for the type of the composition - helps for indexing and searching. This may be implied by or derived from the code specified in the Composition Type.", 0, Integer.MAX_VALUE, this.category);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Any)", "Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).", 0, Integer.MAX_VALUE, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "Describes the clinical encounter or type of care this documentation is associated with.", 0, 1, this.encounter);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The composition editing time, when the composition was last logically changed by the author.", 0, 1, this.date);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate Composition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -1406328437: {
                return new Property(SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Device|Patient|RelatedPerson|Organization)", "Identifies who is responsible for the information in the composition, not necessarily who typed it in.", 0, Integer.MAX_VALUE, this.author);
            }
            case 3373707: {
                return new Property("name", "string", "A natural language name identifying the composition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "Official human-readable label for the composition.", 0, 1, this.title);
            }
            case 3387378: {
                return new Property("note", "Annotation", "For any additional notes.", 0, Integer.MAX_VALUE, this.note);
            }
            case 542920370: {
                return new Property(SP_ATTESTER, "", "A participant who has attested to the accuracy of the composition/document.", 0, Integer.MAX_VALUE, this.attester);
            }
            case 1611297262: {
                return new Property("custodian", "Reference(Organization)", "Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information.", 0, 1, this.custodian);
            }
            case -7765931: {
                return new Property("relatesTo", "RelatedArtifact", "Relationships that this composition has with other compositions or documents that already exist.", 0, Integer.MAX_VALUE, this.relatesTo);
            }
            case 96891546: {
                return new Property("event", "", "The clinical service, such as a colonoscopy or an appendectomy, being documented.", 0, Integer.MAX_VALUE, this.event);
            }
            case 1970241253: {
                return new Property(SP_SECTION, "", "The root of the sections that make up the composition.", 0, Integer.MAX_VALUE, this.section);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.type;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1867885268: {
                return this.subject == null ? new Base[]{} : this.subject.toArray(new Base[this.subject.size()]);
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -1406328437: {
                return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.title;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 542920370: {
                return this.attester == null ? new Base[]{} : this.attester.toArray(new Base[this.attester.size()]);
            }
            case 1611297262: {
                Base[] baseArray;
                if (this.custodian == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.custodian;
                }
                return baseArray;
            }
            case -7765931: {
                return this.relatesTo == null ? new Base[]{} : this.relatesTo.toArray(new Base[this.relatesTo.size()]);
            }
            case 96891546: {
                return this.event == null ? new Base[]{} : this.event.toArray(new Base[this.event.size()]);
            }
            case 1970241253: {
                return this.section == null ? new Base[]{} : this.section.toArray(new Base[this.section.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.CompositionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.getSubject().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -1406328437: {
                this.getAuthor().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 542920370: {
                this.getAttester().add((CompositionAttesterComponent)((Object)value));
                return value;
            }
            case 1611297262: {
                this.custodian = TypeConvertor.castToReference(value);
                return value;
            }
            case -7765931: {
                this.getRelatesTo().add(TypeConvertor.castToRelatedArtifact(value));
                return value;
            }
            case 96891546: {
                this.getEvent().add((CompositionEventComponent)((Object)value));
                return value;
            }
            case 1970241253: {
                this.getSection().add((SectionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.CompositionStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_AUTHOR)) {
            this.getAuthor().add(TypeConvertor.castToReference(value));
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals(SP_ATTESTER)) {
            this.getAttester().add((CompositionAttesterComponent)((Object)value));
        } else if (name.equals("custodian")) {
            this.custodian = TypeConvertor.castToReference(value);
        } else if (name.equals("relatesTo")) {
            this.getRelatesTo().add(TypeConvertor.castToRelatedArtifact(value));
        } else if (name.equals("event")) {
            this.getEvent().add((CompositionEventComponent)((Object)value));
        } else if (name.equals(SP_SECTION)) {
            this.getSection().add((SectionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3575610: {
                return this.getType();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1867885268: {
                return this.addSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -1406328437: {
                return this.addAuthor();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case 542920370: {
                return this.addAttester();
            }
            case 1611297262: {
                return this.getCustodian();
            }
            case -7765931: {
                return this.addRelatesTo();
            }
            case 96891546: {
                return this.addEvent();
            }
            case 1970241253: {
                return this.addSection();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -1406328437: {
                return new String[]{"Reference"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 542920370: {
                return new String[0];
            }
            case 1611297262: {
                return new String[]{"Reference"};
            }
            case -7765931: {
                return new String[]{"RelatedArtifact"};
            }
            case 96891546: {
                return new String[0];
            }
            case 1970241253: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.version");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.status");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.date");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_AUTHOR)) {
            return this.addAuthor();
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Composition.title");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals(SP_ATTESTER)) {
            return this.addAttester();
        }
        if (name.equals("custodian")) {
            this.custodian = new Reference();
            return this.custodian;
        }
        if (name.equals("relatesTo")) {
            return this.addRelatesTo();
        }
        if (name.equals("event")) {
            return this.addEvent();
        }
        if (name.equals(SP_SECTION)) {
            return this.addSection();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Composition";
    }

    @Override
    public Composition copy() {
        Composition dst = new Composition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Composition dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.status = this.status == null ? null : this.status.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        DateTimeType dateTimeType = dst.date = this.date == null ? null : this.date.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.author != null) {
            dst.author = new ArrayList<Reference>();
            for (Reference reference : this.author) {
                dst.author.add(reference.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.attester != null) {
            dst.attester = new ArrayList<CompositionAttesterComponent>();
            for (CompositionAttesterComponent compositionAttesterComponent : this.attester) {
                dst.attester.add(compositionAttesterComponent.copy());
            }
        }
        Reference reference = dst.custodian = this.custodian == null ? null : this.custodian.copy();
        if (this.relatesTo != null) {
            dst.relatesTo = new ArrayList<RelatedArtifact>();
            for (RelatedArtifact relatedArtifact : this.relatesTo) {
                dst.relatesTo.add(relatedArtifact.copy());
            }
        }
        if (this.event != null) {
            dst.event = new ArrayList<CompositionEventComponent>();
            for (CompositionEventComponent compositionEventComponent : this.event) {
                dst.event.add(compositionEventComponent.copy());
            }
        }
        if (this.section != null) {
            dst.section = new ArrayList<SectionComponent>();
            for (SectionComponent sectionComponent : this.section) {
                dst.section.add(sectionComponent.copy());
            }
        }
    }

    protected Composition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Composition)) {
            return false;
        }
        Composition o = (Composition)other_;
        return Composition.compareDeep(this.url, o.url, true) && Composition.compareDeep(this.identifier, o.identifier, true) && Composition.compareDeep(this.version, o.version, true) && Composition.compareDeep(this.status, o.status, true) && Composition.compareDeep(this.type, o.type, true) && Composition.compareDeep(this.category, o.category, true) && Composition.compareDeep(this.subject, o.subject, true) && Composition.compareDeep(this.encounter, o.encounter, true) && Composition.compareDeep(this.date, o.date, true) && Composition.compareDeep(this.useContext, o.useContext, true) && Composition.compareDeep(this.author, o.author, true) && Composition.compareDeep(this.name, o.name, true) && Composition.compareDeep(this.title, o.title, true) && Composition.compareDeep(this.note, o.note, true) && Composition.compareDeep(this.attester, o.attester, true) && Composition.compareDeep(this.custodian, o.custodian, true) && Composition.compareDeep(this.relatesTo, o.relatesTo, true) && Composition.compareDeep(this.event, o.event, true) && Composition.compareDeep(this.section, o.section, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Composition)) {
            return false;
        }
        Composition o = (Composition)other_;
        return Composition.compareValues(this.url, o.url, true) && Composition.compareValues(this.version, o.version, true) && Composition.compareValues(this.status, o.status, true) && Composition.compareValues(this.date, o.date, true) && Composition.compareValues(this.name, o.name, true) && Composition.compareValues(this.title, o.title, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.url, this.identifier, this.version, this.status, this.type, this.category, this.subject, this.encounter, this.date, this.useContext, this.author, this.name, this.title, this.note, this.attester, this.custodian, this.relatesTo, this.event, this.section);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Composition;
    }

    @Block
    public static class SectionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="title", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Label for section (e.g. for ToC)", formalDefinition="The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.")
        protected StringType title;
        @Child(name="code", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Classification of section (recommended)", formalDefinition="A code identifying the kind of content contained within the section. This must be consistent with the section title.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/doc-section-codes")
        protected CodeableConcept code;
        @Child(name="author", type={Practitioner.class, PractitionerRole.class, Device.class, Patient.class, RelatedPerson.class, Organization.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Who and/or what authored the section", formalDefinition="Identifies who is responsible for the information in this section, not necessarily who typed it in.")
        protected List<Reference> author;
        @Child(name="focus", type={Reference.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who/what the section is about, when it is not about the subject of composition", formalDefinition="The actual focus of the section when it is not the subject of the composition, but instead represents something or someone associated with the subject such as (for a patient subject) a spouse, parent, fetus, or donor. If not focus is specified, the focus is assumed to be focus of the parent section, or, for a section in the Composition itself, the subject of the composition. Sections with a focus SHALL only include resources where the logical subject (patient, subject, focus, etc.) matches the section focus, or the resources have no logical subject (few resources).")
        protected Reference focus;
        @Child(name="text", type={Narrative.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text summary of the section, for human interpretation", formalDefinition="A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative.")
        protected Narrative text;
        @Child(name="mode", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="working | snapshot | changes", formalDefinition="How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-mode")
        protected Enumeration<Enumerations.ListMode> mode;
        @Child(name="orderedBy", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Order of section entries", formalDefinition="Specifies the order applied to the items in the section entries.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-order")
        protected CodeableConcept orderedBy;
        @Child(name="entry", type={Reference.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A reference to data that supports this section", formalDefinition="A reference to the actual resource from which the narrative in the section is derived.")
        protected List<Reference> entry;
        @Child(name="emptyReason", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why the section is empty", formalDefinition="If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/list-empty-reason")
        protected CodeableConcept emptyReason;
        @Child(name="section", type={SectionComponent.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Section", formalDefinition="A nested sub-section within this section.")
        protected List<SectionComponent> section;
        private static final long serialVersionUID = 911563193L;

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public SectionComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public SectionComponent setTitle(String value) {
            if (Utilities.noString(value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SectionComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<Reference> getAuthor() {
            if (this.author == null) {
                this.author = new ArrayList<Reference>();
            }
            return this.author;
        }

        public SectionComponent setAuthor(List<Reference> theAuthor) {
            this.author = theAuthor;
            return this;
        }

        public boolean hasAuthor() {
            if (this.author == null) {
                return false;
            }
            for (Reference item : this.author) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addAuthor() {
            Reference t = new Reference();
            if (this.author == null) {
                this.author = new ArrayList<Reference>();
            }
            this.author.add(t);
            return t;
        }

        public SectionComponent addAuthor(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.author == null) {
                this.author = new ArrayList<Reference>();
            }
            this.author.add(t);
            return this;
        }

        public Reference getAuthorFirstRep() {
            if (this.getAuthor().isEmpty()) {
                this.addAuthor();
            }
            return this.getAuthor().get(0);
        }

        public Reference getFocus() {
            if (this.focus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.focus");
                }
                if (Configuration.doAutoCreate()) {
                    this.focus = new Reference();
                }
            }
            return this.focus;
        }

        public boolean hasFocus() {
            return this.focus != null && !this.focus.isEmpty();
        }

        public SectionComponent setFocus(Reference value) {
            this.focus = value;
            return this;
        }

        public Narrative getText() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new Narrative();
                }
            }
            return this.text;
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public SectionComponent setText(Narrative value) {
            this.text = value;
            return this;
        }

        public Enumeration<Enumerations.ListMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public SectionComponent setModeElement(Enumeration<Enumerations.ListMode> value) {
            this.mode = value;
            return this;
        }

        public Enumerations.ListMode getMode() {
            return this.mode == null ? null : (Enumerations.ListMode)((Object)this.mode.getValue());
        }

        public SectionComponent setMode(Enumerations.ListMode value) {
            if (value == null) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new Enumeration<Enumerations.ListMode>(new Enumerations.ListModeEnumFactory());
                }
                this.mode.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getOrderedBy() {
            if (this.orderedBy == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.orderedBy");
                }
                if (Configuration.doAutoCreate()) {
                    this.orderedBy = new CodeableConcept();
                }
            }
            return this.orderedBy;
        }

        public boolean hasOrderedBy() {
            return this.orderedBy != null && !this.orderedBy.isEmpty();
        }

        public SectionComponent setOrderedBy(CodeableConcept value) {
            this.orderedBy = value;
            return this;
        }

        public List<Reference> getEntry() {
            if (this.entry == null) {
                this.entry = new ArrayList<Reference>();
            }
            return this.entry;
        }

        public SectionComponent setEntry(List<Reference> theEntry) {
            this.entry = theEntry;
            return this;
        }

        public boolean hasEntry() {
            if (this.entry == null) {
                return false;
            }
            for (Reference item : this.entry) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEntry() {
            Reference t = new Reference();
            if (this.entry == null) {
                this.entry = new ArrayList<Reference>();
            }
            this.entry.add(t);
            return t;
        }

        public SectionComponent addEntry(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.entry == null) {
                this.entry = new ArrayList<Reference>();
            }
            this.entry.add(t);
            return this;
        }

        public Reference getEntryFirstRep() {
            if (this.getEntry().isEmpty()) {
                this.addEntry();
            }
            return this.getEntry().get(0);
        }

        public CodeableConcept getEmptyReason() {
            if (this.emptyReason == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SectionComponent.emptyReason");
                }
                if (Configuration.doAutoCreate()) {
                    this.emptyReason = new CodeableConcept();
                }
            }
            return this.emptyReason;
        }

        public boolean hasEmptyReason() {
            return this.emptyReason != null && !this.emptyReason.isEmpty();
        }

        public SectionComponent setEmptyReason(CodeableConcept value) {
            this.emptyReason = value;
            return this;
        }

        public List<SectionComponent> getSection() {
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            return this.section;
        }

        public SectionComponent setSection(List<SectionComponent> theSection) {
            this.section = theSection;
            return this;
        }

        public boolean hasSection() {
            if (this.section == null) {
                return false;
            }
            for (SectionComponent item : this.section) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SectionComponent addSection() {
            SectionComponent t = new SectionComponent();
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            this.section.add(t);
            return t;
        }

        public SectionComponent addSection(SectionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.section == null) {
                this.section = new ArrayList<SectionComponent>();
            }
            this.section.add(t);
            return this;
        }

        public SectionComponent getSectionFirstRep() {
            if (this.getSection().isEmpty()) {
                this.addSection();
            }
            return this.getSection().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Composition.SP_TITLE, "string", "The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.", 0, 1, this.title));
            children.add(new Property("code", "CodeableConcept", "A code identifying the kind of content contained within the section. This must be consistent with the section title.", 0, 1, this.code));
            children.add(new Property(Composition.SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Device|Patient|RelatedPerson|Organization)", "Identifies who is responsible for the information in this section, not necessarily who typed it in.", 0, Integer.MAX_VALUE, this.author));
            children.add(new Property("focus", "Reference(Any)", "The actual focus of the section when it is not the subject of the composition, but instead represents something or someone associated with the subject such as (for a patient subject) a spouse, parent, fetus, or donor. If not focus is specified, the focus is assumed to be focus of the parent section, or, for a section in the Composition itself, the subject of the composition. Sections with a focus SHALL only include resources where the logical subject (patient, subject, focus, etc.) matches the section focus, or the resources have no logical subject (few resources).", 0, 1, this.focus));
            children.add(new Property("text", "Narrative", "A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative.", 0, 1, this.text));
            children.add(new Property("mode", "code", "How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, 1, this.mode));
            children.add(new Property("orderedBy", "CodeableConcept", "Specifies the order applied to the items in the section entries.", 0, 1, this.orderedBy));
            children.add(new Property(Composition.SP_ENTRY, "Reference(Any)", "A reference to the actual resource from which the narrative in the section is derived.", 0, Integer.MAX_VALUE, this.entry));
            children.add(new Property("emptyReason", "CodeableConcept", "If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.", 0, 1, this.emptyReason));
            children.add(new Property(Composition.SP_SECTION, "@Composition.section", "A nested sub-section within this section.", 0, Integer.MAX_VALUE, this.section));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 110371416: {
                    return new Property(Composition.SP_TITLE, "string", "The label for this particular section.  This will be part of the rendered content for the document, and is often used to build a table of contents.", 0, 1, this.title);
                }
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A code identifying the kind of content contained within the section. This must be consistent with the section title.", 0, 1, this.code);
                }
                case -1406328437: {
                    return new Property(Composition.SP_AUTHOR, "Reference(Practitioner|PractitionerRole|Device|Patient|RelatedPerson|Organization)", "Identifies who is responsible for the information in this section, not necessarily who typed it in.", 0, Integer.MAX_VALUE, this.author);
                }
                case 97604824: {
                    return new Property("focus", "Reference(Any)", "The actual focus of the section when it is not the subject of the composition, but instead represents something or someone associated with the subject such as (for a patient subject) a spouse, parent, fetus, or donor. If not focus is specified, the focus is assumed to be focus of the parent section, or, for a section in the Composition itself, the subject of the composition. Sections with a focus SHALL only include resources where the logical subject (patient, subject, focus, etc.) matches the section focus, or the resources have no logical subject (few resources).", 0, 1, this.focus);
                }
                case 3556653: {
                    return new Property("text", "Narrative", "A human-readable narrative that contains the attested content of the section, used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative.", 0, 1, this.text);
                }
                case 0x3339A3: {
                    return new Property("mode", "code", "How the entry list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.", 0, 1, this.mode);
                }
                case -391079516: {
                    return new Property("orderedBy", "CodeableConcept", "Specifies the order applied to the items in the section entries.", 0, 1, this.orderedBy);
                }
                case 96667762: {
                    return new Property(Composition.SP_ENTRY, "Reference(Any)", "A reference to the actual resource from which the narrative in the section is derived.", 0, Integer.MAX_VALUE, this.entry);
                }
                case 1140135409: {
                    return new Property("emptyReason", "CodeableConcept", "If the section is empty, why the list is empty. An empty section typically has some text explaining the empty reason.", 0, 1, this.emptyReason);
                }
                case 1970241253: {
                    return new Property(Composition.SP_SECTION, "@Composition.section", "A nested sub-section within this section.", 0, Integer.MAX_VALUE, this.section);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.title;
                    }
                    return baseArray;
                }
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.code;
                    }
                    return baseArray;
                }
                case -1406328437: {
                    return this.author == null ? new Base[]{} : this.author.toArray(new Base[this.author.size()]);
                }
                case 97604824: {
                    Base[] baseArray;
                    if (this.focus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.focus;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.text;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.mode;
                    }
                    return baseArray;
                }
                case -391079516: {
                    Base[] baseArray;
                    if (this.orderedBy == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.orderedBy;
                    }
                    return baseArray;
                }
                case 96667762: {
                    return this.entry == null ? new Base[]{} : this.entry.toArray(new Base[this.entry.size()]);
                }
                case 1140135409: {
                    Base[] baseArray;
                    if (this.emptyReason == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.emptyReason;
                    }
                    return baseArray;
                }
                case 1970241253: {
                    return this.section == null ? new Base[]{} : this.section.toArray(new Base[this.section.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
                case 3059181: {
                    this.code = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1406328437: {
                    this.getAuthor().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 97604824: {
                    this.focus = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToNarrative(value);
                    return value;
                }
                case 0x3339A3: {
                    value = new Enumerations.ListModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case -391079516: {
                    this.orderedBy = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 96667762: {
                    this.getEntry().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 1140135409: {
                    this.emptyReason = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1970241253: {
                    this.getSection().add((SectionComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Composition.SP_TITLE)) {
                this.title = TypeConvertor.castToString(value);
            } else if (name.equals("code")) {
                this.code = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Composition.SP_AUTHOR)) {
                this.getAuthor().add(TypeConvertor.castToReference(value));
            } else if (name.equals("focus")) {
                this.focus = TypeConvertor.castToReference(value);
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToNarrative(value);
            } else if (name.equals("mode")) {
                value = new Enumerations.ListModeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.mode = value;
            } else if (name.equals("orderedBy")) {
                this.orderedBy = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Composition.SP_ENTRY)) {
                this.getEntry().add(TypeConvertor.castToReference(value));
            } else if (name.equals("emptyReason")) {
                this.emptyReason = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(Composition.SP_SECTION)) {
                this.getSection().add((SectionComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return this.getTitleElement();
                }
                case 3059181: {
                    return this.getCode();
                }
                case -1406328437: {
                    return this.addAuthor();
                }
                case 97604824: {
                    return this.getFocus();
                }
                case 3556653: {
                    return this.getText();
                }
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case -391079516: {
                    return this.getOrderedBy();
                }
                case 96667762: {
                    return this.addEntry();
                }
                case 1140135409: {
                    return this.getEmptyReason();
                }
                case 1970241253: {
                    return this.addSection();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 110371416: {
                    return new String[]{"string"};
                }
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -1406328437: {
                    return new String[]{"Reference"};
                }
                case 97604824: {
                    return new String[]{"Reference"};
                }
                case 3556653: {
                    return new String[]{"Narrative"};
                }
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case -391079516: {
                    return new String[]{"CodeableConcept"};
                }
                case 96667762: {
                    return new String[]{"Reference"};
                }
                case 1140135409: {
                    return new String[]{"CodeableConcept"};
                }
                case 1970241253: {
                    return new String[]{"@Composition.section"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Composition.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.section.title");
            }
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals(Composition.SP_AUTHOR)) {
                return this.addAuthor();
            }
            if (name.equals("focus")) {
                this.focus = new Reference();
                return this.focus;
            }
            if (name.equals("text")) {
                this.text = new Narrative();
                return this.text;
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.section.mode");
            }
            if (name.equals("orderedBy")) {
                this.orderedBy = new CodeableConcept();
                return this.orderedBy;
            }
            if (name.equals(Composition.SP_ENTRY)) {
                return this.addEntry();
            }
            if (name.equals("emptyReason")) {
                this.emptyReason = new CodeableConcept();
                return this.emptyReason;
            }
            if (name.equals(Composition.SP_SECTION)) {
                return this.addSection();
            }
            return super.addChild(name);
        }

        @Override
        public SectionComponent copy() {
            SectionComponent dst = new SectionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SectionComponent dst) {
            super.copyValues(dst);
            dst.title = this.title == null ? null : this.title.copy();
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.author != null) {
                dst.author = new ArrayList<Reference>();
                for (Reference reference : this.author) {
                    dst.author.add(reference.copy());
                }
            }
            dst.focus = this.focus == null ? null : this.focus.copy();
            dst.text = this.text == null ? null : this.text.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
            CodeableConcept codeableConcept2 = dst.orderedBy = this.orderedBy == null ? null : this.orderedBy.copy();
            if (this.entry != null) {
                dst.entry = new ArrayList<Reference>();
                for (Reference reference : this.entry) {
                    dst.entry.add(reference.copy());
                }
            }
            CodeableConcept codeableConcept3 = dst.emptyReason = this.emptyReason == null ? null : this.emptyReason.copy();
            if (this.section != null) {
                dst.section = new ArrayList<SectionComponent>();
                for (SectionComponent sectionComponent : this.section) {
                    dst.section.add(sectionComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SectionComponent)) {
                return false;
            }
            SectionComponent o = (SectionComponent)other_;
            return SectionComponent.compareDeep(this.title, o.title, true) && SectionComponent.compareDeep(this.code, o.code, true) && SectionComponent.compareDeep(this.author, o.author, true) && SectionComponent.compareDeep(this.focus, o.focus, true) && SectionComponent.compareDeep(this.text, o.text, true) && SectionComponent.compareDeep(this.mode, o.mode, true) && SectionComponent.compareDeep(this.orderedBy, o.orderedBy, true) && SectionComponent.compareDeep(this.entry, o.entry, true) && SectionComponent.compareDeep(this.emptyReason, o.emptyReason, true) && SectionComponent.compareDeep(this.section, o.section, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SectionComponent)) {
                return false;
            }
            SectionComponent o = (SectionComponent)other_;
            return SectionComponent.compareValues(this.title, o.title, true) && SectionComponent.compareValues(this.mode, o.mode, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.title, this.code, this.author, this.focus, this.text, this.mode, this.orderedBy, this.entry, this.emptyReason, this.section);
        }

        @Override
        public String fhirType() {
            return "Composition.section";
        }
    }

    @Block
    public static class CompositionEventComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Code(s) that apply to the event being documented", formalDefinition="This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActCode")
        protected List<CodeableConcept> code;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The period covered by the documentation", formalDefinition="The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time.")
        protected Period period;
        @Child(name="detail", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The event(s) being documented", formalDefinition="The description and/or reference of the event(s) being documented. For example, this could be used to document such a colonoscopy or an appendectomy.")
        protected List<Reference> detail;
        private static final long serialVersionUID = 1593079240L;

        public List<CodeableConcept> getCode() {
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            return this.code;
        }

        public CompositionEventComponent setCode(List<CodeableConcept> theCode) {
            this.code = theCode;
            return this;
        }

        public boolean hasCode() {
            if (this.code == null) {
                return false;
            }
            for (CodeableConcept item : this.code) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addCode() {
            CodeableConcept t = new CodeableConcept();
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return t;
        }

        public CompositionEventComponent addCode(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.code == null) {
                this.code = new ArrayList<CodeableConcept>();
            }
            this.code.add(t);
            return this;
        }

        public CodeableConcept getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                this.addCode();
            }
            return this.getCode().get(0);
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionEventComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public CompositionEventComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public List<Reference> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            return this.detail;
        }

        public CompositionEventComponent setDetail(List<Reference> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (Reference item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addDetail() {
            Reference t = new Reference();
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return t;
        }

        public CompositionEventComponent addDetail(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<Reference>();
            }
            this.detail.add(t);
            return this;
        }

        public Reference getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.code));
            children.add(new Property(Composition.SP_PERIOD, "Period", "The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time.", 0, 1, this.period));
            children.add(new Property("detail", "Reference(Any)", "The description and/or reference of the event(s) being documented. For example, this could be used to document such a colonoscopy or an appendectomy.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.", 0, Integer.MAX_VALUE, this.code);
                }
                case -991726143: {
                    return new Property(Composition.SP_PERIOD, "Period", "The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time.", 0, 1, this.period);
                }
                case -1335224239: {
                    return new Property("detail", "Reference(Any)", "The description and/or reference of the event(s) being documented. For example, this could be used to document such a colonoscopy or an appendectomy.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.period;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.getCode().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add(TypeConvertor.castToReference(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.getCode().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals(Composition.SP_PERIOD)) {
                this.period = TypeConvertor.castToPeriod(value);
            } else if (name.equals("detail")) {
                this.getDetail().add(TypeConvertor.castToReference(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.addCode();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case -1335224239: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                return this.addCode();
            }
            if (name.equals(Composition.SP_PERIOD)) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public CompositionEventComponent copy() {
            CompositionEventComponent dst = new CompositionEventComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CompositionEventComponent dst) {
            super.copyValues(dst);
            if (this.code != null) {
                dst.code = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.code) {
                    dst.code.add(codeableConcept.copy());
                }
            }
            Period period = dst.period = this.period == null ? null : this.period.copy();
            if (this.detail != null) {
                dst.detail = new ArrayList<Reference>();
                for (Reference reference : this.detail) {
                    dst.detail.add(reference.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CompositionEventComponent)) {
                return false;
            }
            CompositionEventComponent o = (CompositionEventComponent)other_;
            return CompositionEventComponent.compareDeep(this.code, o.code, true) && CompositionEventComponent.compareDeep(this.period, o.period, true) && CompositionEventComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CompositionEventComponent)) {
                return false;
            }
            CompositionEventComponent o = (CompositionEventComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.period, this.detail);
        }

        @Override
        public String fhirType() {
            return "Composition.event";
        }
    }

    @Block
    public static class CompositionAttesterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="personal | professional | legal | official", formalDefinition="The type of attestation the authenticator offers.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/composition-attestation-mode")
        protected CodeableConcept mode;
        @Child(name="time", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="When the composition was attested", formalDefinition="When the composition was attested by the party.")
        protected DateTimeType time;
        @Child(name="party", type={Patient.class, RelatedPerson.class, Practitioner.class, PractitionerRole.class, Organization.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who attested the composition", formalDefinition="Who attested the composition in the specified way.")
        protected Reference party;
        private static final long serialVersionUID = 545132751L;

        public CompositionAttesterComponent() {
        }

        public CompositionAttesterComponent(CodeableConcept mode) {
            this.setMode(mode);
        }

        public CodeableConcept getMode() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionAttesterComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new CodeableConcept();
                }
            }
            return this.mode;
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public CompositionAttesterComponent setMode(CodeableConcept value) {
            this.mode = value;
            return this;
        }

        public DateTimeType getTimeElement() {
            if (this.time == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionAttesterComponent.time");
                }
                if (Configuration.doAutoCreate()) {
                    this.time = new DateTimeType();
                }
            }
            return this.time;
        }

        public boolean hasTimeElement() {
            return this.time != null && !this.time.isEmpty();
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public CompositionAttesterComponent setTimeElement(DateTimeType value) {
            this.time = value;
            return this;
        }

        public Date getTime() {
            return this.time == null ? null : (Date)this.time.getValue();
        }

        public CompositionAttesterComponent setTime(Date value) {
            if (value == null) {
                this.time = null;
            } else {
                if (this.time == null) {
                    this.time = new DateTimeType();
                }
                this.time.setValue(value);
            }
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CompositionAttesterComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public CompositionAttesterComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("mode", "CodeableConcept", "The type of attestation the authenticator offers.", 0, 1, this.mode));
            children.add(new Property("time", "dateTime", "When the composition was attested by the party.", 0, 1, this.time));
            children.add(new Property("party", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Who attested the composition in the specified way.", 0, 1, this.party));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property("mode", "CodeableConcept", "The type of attestation the authenticator offers.", 0, 1, this.mode);
                }
                case 3560141: {
                    return new Property("time", "dateTime", "When the composition was attested by the party.", 0, 1, this.time);
                }
                case 106437350: {
                    return new Property("party", "Reference(Patient|RelatedPerson|Practitioner|PractitionerRole|Organization)", "Who attested the composition in the specified way.", 0, 1, this.party);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.time;
                    }
                    return baseArray;
                }
                case 106437350: {
                    Base[] baseArray;
                    if (this.party == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.party;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    this.mode = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3560141: {
                    this.time = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 106437350: {
                    this.party = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                this.mode = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("time")) {
                this.time = TypeConvertor.castToDateTime(value);
            } else if (name.equals("party")) {
                this.party = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getMode();
                }
                case 3560141: {
                    return this.getTimeElement();
                }
                case 106437350: {
                    return this.getParty();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"CodeableConcept"};
                }
                case 3560141: {
                    return new String[]{"dateTime"};
                }
                case 106437350: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                this.mode = new CodeableConcept();
                return this.mode;
            }
            if (name.equals("time")) {
                throw new FHIRException("Cannot call addChild on a primitive type Composition.attester.time");
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            return super.addChild(name);
        }

        @Override
        public CompositionAttesterComponent copy() {
            CompositionAttesterComponent dst = new CompositionAttesterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(CompositionAttesterComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.time = this.time == null ? null : this.time.copy();
            dst.party = this.party == null ? null : this.party.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CompositionAttesterComponent)) {
                return false;
            }
            CompositionAttesterComponent o = (CompositionAttesterComponent)other_;
            return CompositionAttesterComponent.compareDeep(this.mode, o.mode, true) && CompositionAttesterComponent.compareDeep(this.time, o.time, true) && CompositionAttesterComponent.compareDeep(this.party, o.party, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CompositionAttesterComponent)) {
                return false;
            }
            CompositionAttesterComponent o = (CompositionAttesterComponent)other_;
            return CompositionAttesterComponent.compareValues(this.time, o.time, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.mode, this.time, this.party);
        }

        @Override
        public String fhirType() {
            return "Composition.attester";
        }
    }
}

