/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.TypeConvertor;

@DatatypeDef(name="CodeableReference")
public class CodeableReference
extends DataType
implements ICompositeType {
    @Child(name="concept", type={CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to a concept (by class)", formalDefinition="A reference to a concept - e.g. the information is identified by its general class to the degree of precision found in the terminology.")
    protected CodeableConcept concept;
    @Child(name="reference", type={Reference.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reference to a resource (by instance)", formalDefinition="A reference to a resource the provides exact details about the information being referenced.")
    protected Reference reference;
    private static final long serialVersionUID = 2070287445L;

    public CodeableReference() {
    }

    public CodeableConcept getConcept() {
        if (this.concept == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeableReference.concept");
            }
            if (Configuration.doAutoCreate()) {
                this.concept = new CodeableConcept();
            }
        }
        return this.concept;
    }

    public boolean hasConcept() {
        return this.concept != null && !this.concept.isEmpty();
    }

    public CodeableReference setConcept(CodeableConcept value) {
        this.concept = value;
        return this;
    }

    public Reference getReference() {
        if (this.reference == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create CodeableReference.reference");
            }
            if (Configuration.doAutoCreate()) {
                this.reference = new Reference();
            }
        }
        return this.reference;
    }

    public boolean hasReference() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public CodeableReference setReference(Reference value) {
        this.reference = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("concept", "CodeableConcept", "A reference to a concept - e.g. the information is identified by its general class to the degree of precision found in the terminology.", 0, 1, this.concept));
        children.add(new Property("reference", "Reference", "A reference to a resource the provides exact details about the information being referenced.", 0, 1, this.reference));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 951024232: {
                return new Property("concept", "CodeableConcept", "A reference to a concept - e.g. the information is identified by its general class to the degree of precision found in the terminology.", 0, 1, this.concept);
            }
            case -925155509: {
                return new Property("reference", "Reference", "A reference to a resource the provides exact details about the information being referenced.", 0, 1, this.reference);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 951024232: {
                Base[] baseArray;
                if (this.concept == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.concept;
                }
                return baseArray;
            }
            case -925155509: {
                Base[] baseArray;
                if (this.reference == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.reference;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 951024232: {
                this.concept = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -925155509: {
                this.reference = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("concept")) {
            this.concept = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("reference")) {
            this.reference = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 951024232: {
                return this.getConcept();
            }
            case -925155509: {
                return this.getReference();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 951024232: {
                return new String[]{"CodeableConcept"};
            }
            case -925155509: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("concept")) {
            this.concept = new CodeableConcept();
            return this.concept;
        }
        if (name.equals("reference")) {
            this.reference = new Reference();
            return this.reference;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "CodeableReference";
    }

    @Override
    public CodeableReference copy() {
        CodeableReference dst = new CodeableReference();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(CodeableReference dst) {
        super.copyValues(dst);
        dst.concept = this.concept == null ? null : this.concept.copy();
        dst.reference = this.reference == null ? null : this.reference.copy();
    }

    protected CodeableReference typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof CodeableReference)) {
            return false;
        }
        CodeableReference o = (CodeableReference)other_;
        return CodeableReference.compareDeep(this.concept, o.concept, true) && CodeableReference.compareDeep(this.reference, o.reference, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof CodeableReference)) {
            return false;
        }
        CodeableReference o = (CodeableReference)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.concept, this.reference);
    }

    public CodeableReference(CodeableConcept cc) {
        this.setConcept(cc);
    }

    public CodeableReference(Reference ref) {
        this.setReference(ref);
    }
}

