/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="BiologicallyDerivedProduct", profile="http://hl7.org/fhir/StructureDefinition/BiologicallyDerivedProduct")
public class BiologicallyDerivedProduct
extends DomainResource {
    @Child(name="productCategory", type={Coding.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="organ | tissue | fluid | cells | biologicalAgent", formalDefinition="Broad category of this product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/product-category")
    protected Coding productCategory;
    @Child(name="productCode", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A code that identifies the kind of this biologically derived product", formalDefinition="A codified value that systematically supports characterization and classification of medical products of human origin inclusive of processing conditions such as additives, volumes and handling conditions.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/biologicallyderived-productcodes")
    protected CodeableConcept productCode;
    @Child(name="parent", type={BiologicallyDerivedProduct.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The parent biologically-derived product", formalDefinition="Parent product (if any) for this biologically-derived product.")
    protected List<Reference> parent;
    @Child(name="request", type={ServiceRequest.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request to obtain and/or infuse this product", formalDefinition="Request to obtain and/or infuse this biologically derived product.")
    protected List<Reference> request;
    @Child(name="identifier", type={Identifier.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instance identifier", formalDefinition="Unique instance identifiers assigned to a biologically derived product. Note: This is a business identifier, not a resource identifier.")
    protected List<Identifier> identifier;
    @Child(name="biologicalSourceEvent", type={Identifier.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier that supports traceability to the event during which material in this product from one or more biological entities was obtained or pooled", formalDefinition="An identifier that supports traceability to the event during which material in this product from one or more biological entities was obtained or pooled.")
    protected Identifier biologicalSourceEvent;
    @Child(name="processingFacility", type={Organization.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Processing facilities responsible for the labeling and distribution of this biologically derived product", formalDefinition="Processing facilities responsible for the labeling and distribution of this biologically derived product.")
    protected List<Reference> processingFacility;
    @Child(name="division", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="A unique identifier for an aliquot of a product", formalDefinition="A unique identifier for an aliquot of a product.  Used to distinguish individual aliquots of a product carrying the same biologicalSource and productCode identifiers.")
    protected StringType division;
    @Child(name="productStatus", type={Coding.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="available | unavailable", formalDefinition="Whether the product is currently available.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/biologicallyderived-product-status")
    protected Coding productStatus;
    @Child(name="expirationDate", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date, and where relevant time, of expiration", formalDefinition="Date, and where relevant time, of expiration.")
    protected DateTimeType expirationDate;
    @Child(name="collection", type={}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How this product was collected", formalDefinition="How this product was collected.")
    protected BiologicallyDerivedProductCollectionComponent collection;
    @Child(name="storageTempRequirements", type={Range.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Product storage temperature requirements", formalDefinition="The temperature requirements for storage of the biologically-derived product.")
    protected Range storageTempRequirements;
    @Child(name="property", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A property that is specific to this BiologicallyDerviedProduct instance", formalDefinition="A property that is specific to this BiologicallyDerviedProduct instance.")
    protected List<BiologicallyDerivedProductPropertyComponent> property;
    private static final long serialVersionUID = 452844848L;
    @SearchParamDefinition(name="biological-source-event", path="BiologicallyDerivedProduct.biologicalSourceEvent", description="The biological source for the biologically derived product", type="token")
    public static final String SP_BIOLOGICAL_SOURCE_EVENT = "biological-source-event";
    public static final TokenClientParam BIOLOGICAL_SOURCE_EVENT = new TokenClientParam("biological-source-event");
    @SearchParamDefinition(name="collector", path="BiologicallyDerivedProduct.collection.collector", description="Procedure request to obtain this biologically derived product.", type="reference", target={Practitioner.class, PractitionerRole.class})
    public static final String SP_COLLECTOR = "collector";
    public static final ReferenceClientParam COLLECTOR = new ReferenceClientParam("collector");
    public static final Include INCLUDE_COLLECTOR = new Include("BiologicallyDerivedProduct:collector").toLocked();
    @SearchParamDefinition(name="identifier", path="BiologicallyDerivedProduct.identifier", description="Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="product-category", path="BiologicallyDerivedProduct.productCategory", description="Broad category of this product.", type="token")
    public static final String SP_PRODUCT_CATEGORY = "product-category";
    public static final TokenClientParam PRODUCT_CATEGORY = new TokenClientParam("product-category");
    @SearchParamDefinition(name="product-code", path="BiologicallyDerivedProduct.productCode", description="A code that identifies the kind of this biologically derived product (SNOMED CT code).", type="token")
    public static final String SP_PRODUCT_CODE = "product-code";
    public static final TokenClientParam PRODUCT_CODE = new TokenClientParam("product-code");
    @SearchParamDefinition(name="product-status", path="BiologicallyDerivedProduct.productStatus", description="Whether the product is currently available.", type="token")
    public static final String SP_PRODUCT_STATUS = "product-status";
    public static final TokenClientParam PRODUCT_STATUS = new TokenClientParam("product-status");
    @SearchParamDefinition(name="request", path="BiologicallyDerivedProduct.request", description="Procedure request to obtain this biologically derived product.", type="reference", target={ServiceRequest.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("BiologicallyDerivedProduct:request").toLocked();

    public Coding getProductCategory() {
        if (this.productCategory == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.productCategory");
            }
            if (Configuration.doAutoCreate()) {
                this.productCategory = new Coding();
            }
        }
        return this.productCategory;
    }

    public boolean hasProductCategory() {
        return this.productCategory != null && !this.productCategory.isEmpty();
    }

    public BiologicallyDerivedProduct setProductCategory(Coding value) {
        this.productCategory = value;
        return this;
    }

    public CodeableConcept getProductCode() {
        if (this.productCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.productCode");
            }
            if (Configuration.doAutoCreate()) {
                this.productCode = new CodeableConcept();
            }
        }
        return this.productCode;
    }

    public boolean hasProductCode() {
        return this.productCode != null && !this.productCode.isEmpty();
    }

    public BiologicallyDerivedProduct setProductCode(CodeableConcept value) {
        this.productCode = value;
        return this;
    }

    public List<Reference> getParent() {
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        return this.parent;
    }

    public BiologicallyDerivedProduct setParent(List<Reference> theParent) {
        this.parent = theParent;
        return this;
    }

    public boolean hasParent() {
        if (this.parent == null) {
            return false;
        }
        for (Reference item : this.parent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addParent() {
        Reference t = new Reference();
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        this.parent.add(t);
        return t;
    }

    public BiologicallyDerivedProduct addParent(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        this.parent.add(t);
        return this;
    }

    public Reference getParentFirstRep() {
        if (this.getParent().isEmpty()) {
            this.addParent();
        }
        return this.getParent().get(0);
    }

    public List<Reference> getRequest() {
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        return this.request;
    }

    public BiologicallyDerivedProduct setRequest(List<Reference> theRequest) {
        this.request = theRequest;
        return this;
    }

    public boolean hasRequest() {
        if (this.request == null) {
            return false;
        }
        for (Reference item : this.request) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRequest() {
        Reference t = new Reference();
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        this.request.add(t);
        return t;
    }

    public BiologicallyDerivedProduct addRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        this.request.add(t);
        return this;
    }

    public Reference getRequestFirstRep() {
        if (this.getRequest().isEmpty()) {
            this.addRequest();
        }
        return this.getRequest().get(0);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public BiologicallyDerivedProduct setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public BiologicallyDerivedProduct addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Identifier getBiologicalSourceEvent() {
        if (this.biologicalSourceEvent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.biologicalSourceEvent");
            }
            if (Configuration.doAutoCreate()) {
                this.biologicalSourceEvent = new Identifier();
            }
        }
        return this.biologicalSourceEvent;
    }

    public boolean hasBiologicalSourceEvent() {
        return this.biologicalSourceEvent != null && !this.biologicalSourceEvent.isEmpty();
    }

    public BiologicallyDerivedProduct setBiologicalSourceEvent(Identifier value) {
        this.biologicalSourceEvent = value;
        return this;
    }

    public List<Reference> getProcessingFacility() {
        if (this.processingFacility == null) {
            this.processingFacility = new ArrayList<Reference>();
        }
        return this.processingFacility;
    }

    public BiologicallyDerivedProduct setProcessingFacility(List<Reference> theProcessingFacility) {
        this.processingFacility = theProcessingFacility;
        return this;
    }

    public boolean hasProcessingFacility() {
        if (this.processingFacility == null) {
            return false;
        }
        for (Reference item : this.processingFacility) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProcessingFacility() {
        Reference t = new Reference();
        if (this.processingFacility == null) {
            this.processingFacility = new ArrayList<Reference>();
        }
        this.processingFacility.add(t);
        return t;
    }

    public BiologicallyDerivedProduct addProcessingFacility(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.processingFacility == null) {
            this.processingFacility = new ArrayList<Reference>();
        }
        this.processingFacility.add(t);
        return this;
    }

    public Reference getProcessingFacilityFirstRep() {
        if (this.getProcessingFacility().isEmpty()) {
            this.addProcessingFacility();
        }
        return this.getProcessingFacility().get(0);
    }

    public StringType getDivisionElement() {
        if (this.division == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.division");
            }
            if (Configuration.doAutoCreate()) {
                this.division = new StringType();
            }
        }
        return this.division;
    }

    public boolean hasDivisionElement() {
        return this.division != null && !this.division.isEmpty();
    }

    public boolean hasDivision() {
        return this.division != null && !this.division.isEmpty();
    }

    public BiologicallyDerivedProduct setDivisionElement(StringType value) {
        this.division = value;
        return this;
    }

    public String getDivision() {
        return this.division == null ? null : (String)this.division.getValue();
    }

    public BiologicallyDerivedProduct setDivision(String value) {
        if (Utilities.noString(value)) {
            this.division = null;
        } else {
            if (this.division == null) {
                this.division = new StringType();
            }
            this.division.setValue(value);
        }
        return this;
    }

    public Coding getProductStatus() {
        if (this.productStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.productStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.productStatus = new Coding();
            }
        }
        return this.productStatus;
    }

    public boolean hasProductStatus() {
        return this.productStatus != null && !this.productStatus.isEmpty();
    }

    public BiologicallyDerivedProduct setProductStatus(Coding value) {
        this.productStatus = value;
        return this;
    }

    public DateTimeType getExpirationDateElement() {
        if (this.expirationDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.expirationDate");
            }
            if (Configuration.doAutoCreate()) {
                this.expirationDate = new DateTimeType();
            }
        }
        return this.expirationDate;
    }

    public boolean hasExpirationDateElement() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public BiologicallyDerivedProduct setExpirationDateElement(DateTimeType value) {
        this.expirationDate = value;
        return this;
    }

    public Date getExpirationDate() {
        return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
    }

    public BiologicallyDerivedProduct setExpirationDate(Date value) {
        if (value == null) {
            this.expirationDate = null;
        } else {
            if (this.expirationDate == null) {
                this.expirationDate = new DateTimeType();
            }
            this.expirationDate.setValue(value);
        }
        return this;
    }

    public BiologicallyDerivedProductCollectionComponent getCollection() {
        if (this.collection == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.collection");
            }
            if (Configuration.doAutoCreate()) {
                this.collection = new BiologicallyDerivedProductCollectionComponent();
            }
        }
        return this.collection;
    }

    public boolean hasCollection() {
        return this.collection != null && !this.collection.isEmpty();
    }

    public BiologicallyDerivedProduct setCollection(BiologicallyDerivedProductCollectionComponent value) {
        this.collection = value;
        return this;
    }

    public Range getStorageTempRequirements() {
        if (this.storageTempRequirements == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.storageTempRequirements");
            }
            if (Configuration.doAutoCreate()) {
                this.storageTempRequirements = new Range();
            }
        }
        return this.storageTempRequirements;
    }

    public boolean hasStorageTempRequirements() {
        return this.storageTempRequirements != null && !this.storageTempRequirements.isEmpty();
    }

    public BiologicallyDerivedProduct setStorageTempRequirements(Range value) {
        this.storageTempRequirements = value;
        return this;
    }

    public List<BiologicallyDerivedProductPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<BiologicallyDerivedProductPropertyComponent>();
        }
        return this.property;
    }

    public BiologicallyDerivedProduct setProperty(List<BiologicallyDerivedProductPropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (BiologicallyDerivedProductPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BiologicallyDerivedProductPropertyComponent addProperty() {
        BiologicallyDerivedProductPropertyComponent t = new BiologicallyDerivedProductPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<BiologicallyDerivedProductPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public BiologicallyDerivedProduct addProperty(BiologicallyDerivedProductPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<BiologicallyDerivedProductPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public BiologicallyDerivedProductPropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("productCategory", "Coding", "Broad category of this product.", 0, 1, this.productCategory));
        children.add(new Property("productCode", "CodeableConcept", "A codified value that systematically supports characterization and classification of medical products of human origin inclusive of processing conditions such as additives, volumes and handling conditions.", 0, 1, this.productCode));
        children.add(new Property("parent", "Reference(BiologicallyDerivedProduct)", "Parent product (if any) for this biologically-derived product.", 0, Integer.MAX_VALUE, this.parent));
        children.add(new Property(SP_REQUEST, "Reference(ServiceRequest)", "Request to obtain and/or infuse this biologically derived product.", 0, Integer.MAX_VALUE, this.request));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a biologically derived product. Note: This is a business identifier, not a resource identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("biologicalSourceEvent", "Identifier", "An identifier that supports traceability to the event during which material in this product from one or more biological entities was obtained or pooled.", 0, 1, this.biologicalSourceEvent));
        children.add(new Property("processingFacility", "Reference(Organization)", "Processing facilities responsible for the labeling and distribution of this biologically derived product.", 0, Integer.MAX_VALUE, this.processingFacility));
        children.add(new Property("division", "string", "A unique identifier for an aliquot of a product.  Used to distinguish individual aliquots of a product carrying the same biologicalSource and productCode identifiers.", 0, 1, this.division));
        children.add(new Property("productStatus", "Coding", "Whether the product is currently available.", 0, 1, this.productStatus));
        children.add(new Property("expirationDate", "dateTime", "Date, and where relevant time, of expiration.", 0, 1, this.expirationDate));
        children.add(new Property("collection", "", "How this product was collected.", 0, 1, this.collection));
        children.add(new Property("storageTempRequirements", "Range", "The temperature requirements for storage of the biologically-derived product.", 0, 1, this.storageTempRequirements));
        children.add(new Property("property", "", "A property that is specific to this BiologicallyDerviedProduct instance.", 0, Integer.MAX_VALUE, this.property));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 197299981: {
                return new Property("productCategory", "Coding", "Broad category of this product.", 0, 1, this.productCategory);
            }
            case -1492131972: {
                return new Property("productCode", "CodeableConcept", "A codified value that systematically supports characterization and classification of medical products of human origin inclusive of processing conditions such as additives, volumes and handling conditions.", 0, 1, this.productCode);
            }
            case -995424086: {
                return new Property("parent", "Reference(BiologicallyDerivedProduct)", "Parent product (if any) for this biologically-derived product.", 0, Integer.MAX_VALUE, this.parent);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(ServiceRequest)", "Request to obtain and/or infuse this biologically derived product.", 0, Integer.MAX_VALUE, this.request);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique instance identifiers assigned to a biologically derived product. Note: This is a business identifier, not a resource identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -654468482: {
                return new Property("biologicalSourceEvent", "Identifier", "An identifier that supports traceability to the event during which material in this product from one or more biological entities was obtained or pooled.", 0, 1, this.biologicalSourceEvent);
            }
            case 39337686: {
                return new Property("processingFacility", "Reference(Organization)", "Processing facilities responsible for the labeling and distribution of this biologically derived product.", 0, Integer.MAX_VALUE, this.processingFacility);
            }
            case 364720301: {
                return new Property("division", "string", "A unique identifier for an aliquot of a product.  Used to distinguish individual aliquots of a product carrying the same biologicalSource and productCode identifiers.", 0, 1, this.division);
            }
            case 1042864577: {
                return new Property("productStatus", "Coding", "Whether the product is currently available.", 0, 1, this.productStatus);
            }
            case -668811523: {
                return new Property("expirationDate", "dateTime", "Date, and where relevant time, of expiration.", 0, 1, this.expirationDate);
            }
            case -1741312354: {
                return new Property("collection", "", "How this product was collected.", 0, 1, this.collection);
            }
            case 1643599647: {
                return new Property("storageTempRequirements", "Range", "The temperature requirements for storage of the biologically-derived product.", 0, 1, this.storageTempRequirements);
            }
            case -993141291: {
                return new Property("property", "", "A property that is specific to this BiologicallyDerviedProduct instance.", 0, Integer.MAX_VALUE, this.property);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 197299981: {
                Base[] baseArray;
                if (this.productCategory == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.productCategory;
                }
                return baseArray;
            }
            case -1492131972: {
                Base[] baseArray;
                if (this.productCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.productCode;
                }
                return baseArray;
            }
            case -995424086: {
                return this.parent == null ? new Base[]{} : this.parent.toArray(new Base[this.parent.size()]);
            }
            case 1095692943: {
                return this.request == null ? new Base[]{} : this.request.toArray(new Base[this.request.size()]);
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -654468482: {
                Base[] baseArray;
                if (this.biologicalSourceEvent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.biologicalSourceEvent;
                }
                return baseArray;
            }
            case 39337686: {
                return this.processingFacility == null ? new Base[]{} : this.processingFacility.toArray(new Base[this.processingFacility.size()]);
            }
            case 364720301: {
                Base[] baseArray;
                if (this.division == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.division;
                }
                return baseArray;
            }
            case 1042864577: {
                Base[] baseArray;
                if (this.productStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.productStatus;
                }
                return baseArray;
            }
            case -668811523: {
                Base[] baseArray;
                if (this.expirationDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.expirationDate;
                }
                return baseArray;
            }
            case -1741312354: {
                Base[] baseArray;
                if (this.collection == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.collection;
                }
                return baseArray;
            }
            case 1643599647: {
                Base[] baseArray;
                if (this.storageTempRequirements == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.storageTempRequirements;
                }
                return baseArray;
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 197299981: {
                this.productCategory = TypeConvertor.castToCoding(value);
                return value;
            }
            case -1492131972: {
                this.productCode = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -995424086: {
                this.getParent().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1095692943: {
                this.getRequest().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -654468482: {
                this.biologicalSourceEvent = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case 39337686: {
                this.getProcessingFacility().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 364720301: {
                this.division = TypeConvertor.castToString(value);
                return value;
            }
            case 1042864577: {
                this.productStatus = TypeConvertor.castToCoding(value);
                return value;
            }
            case -668811523: {
                this.expirationDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1741312354: {
                this.collection = (BiologicallyDerivedProductCollectionComponent)value;
                return value;
            }
            case 1643599647: {
                this.storageTempRequirements = TypeConvertor.castToRange(value);
                return value;
            }
            case -993141291: {
                this.getProperty().add((BiologicallyDerivedProductPropertyComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("productCategory")) {
            this.productCategory = TypeConvertor.castToCoding(value);
        } else if (name.equals("productCode")) {
            this.productCode = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("parent")) {
            this.getParent().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_REQUEST)) {
            this.getRequest().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("biologicalSourceEvent")) {
            this.biologicalSourceEvent = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("processingFacility")) {
            this.getProcessingFacility().add(TypeConvertor.castToReference(value));
        } else if (name.equals("division")) {
            this.division = TypeConvertor.castToString(value);
        } else if (name.equals("productStatus")) {
            this.productStatus = TypeConvertor.castToCoding(value);
        } else if (name.equals("expirationDate")) {
            this.expirationDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals("collection")) {
            this.collection = (BiologicallyDerivedProductCollectionComponent)value;
        } else if (name.equals("storageTempRequirements")) {
            this.storageTempRequirements = TypeConvertor.castToRange(value);
        } else if (name.equals("property")) {
            this.getProperty().add((BiologicallyDerivedProductPropertyComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 197299981: {
                return this.getProductCategory();
            }
            case -1492131972: {
                return this.getProductCode();
            }
            case -995424086: {
                return this.addParent();
            }
            case 1095692943: {
                return this.addRequest();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case -654468482: {
                return this.getBiologicalSourceEvent();
            }
            case 39337686: {
                return this.addProcessingFacility();
            }
            case 364720301: {
                return this.getDivisionElement();
            }
            case 1042864577: {
                return this.getProductStatus();
            }
            case -668811523: {
                return this.getExpirationDateElement();
            }
            case -1741312354: {
                return this.getCollection();
            }
            case 1643599647: {
                return this.getStorageTempRequirements();
            }
            case -993141291: {
                return this.addProperty();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 197299981: {
                return new String[]{"Coding"};
            }
            case -1492131972: {
                return new String[]{"CodeableConcept"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -654468482: {
                return new String[]{"Identifier"};
            }
            case 39337686: {
                return new String[]{"Reference"};
            }
            case 364720301: {
                return new String[]{"string"};
            }
            case 1042864577: {
                return new String[]{"Coding"};
            }
            case -668811523: {
                return new String[]{"dateTime"};
            }
            case -1741312354: {
                return new String[0];
            }
            case 1643599647: {
                return new String[]{"Range"};
            }
            case -993141291: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("productCategory")) {
            this.productCategory = new Coding();
            return this.productCategory;
        }
        if (name.equals("productCode")) {
            this.productCode = new CodeableConcept();
            return this.productCode;
        }
        if (name.equals("parent")) {
            return this.addParent();
        }
        if (name.equals(SP_REQUEST)) {
            return this.addRequest();
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("biologicalSourceEvent")) {
            this.biologicalSourceEvent = new Identifier();
            return this.biologicalSourceEvent;
        }
        if (name.equals("processingFacility")) {
            return this.addProcessingFacility();
        }
        if (name.equals("division")) {
            throw new FHIRException("Cannot call addChild on a primitive type BiologicallyDerivedProduct.division");
        }
        if (name.equals("productStatus")) {
            this.productStatus = new Coding();
            return this.productStatus;
        }
        if (name.equals("expirationDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type BiologicallyDerivedProduct.expirationDate");
        }
        if (name.equals("collection")) {
            this.collection = new BiologicallyDerivedProductCollectionComponent();
            return this.collection;
        }
        if (name.equals("storageTempRequirements")) {
            this.storageTempRequirements = new Range();
            return this.storageTempRequirements;
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "BiologicallyDerivedProduct";
    }

    @Override
    public BiologicallyDerivedProduct copy() {
        BiologicallyDerivedProduct dst = new BiologicallyDerivedProduct();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(BiologicallyDerivedProduct dst) {
        super.copyValues(dst);
        dst.productCategory = this.productCategory == null ? null : this.productCategory.copy();
        CodeableConcept codeableConcept = dst.productCode = this.productCode == null ? null : this.productCode.copy();
        if (this.parent != null) {
            dst.parent = new ArrayList<Reference>();
            for (Reference reference : this.parent) {
                dst.parent.add(reference.copy());
            }
        }
        if (this.request != null) {
            dst.request = new ArrayList<Reference>();
            for (Reference reference : this.request) {
                dst.request.add(reference.copy());
            }
        }
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Identifier identifier = dst.biologicalSourceEvent = this.biologicalSourceEvent == null ? null : this.biologicalSourceEvent.copy();
        if (this.processingFacility != null) {
            dst.processingFacility = new ArrayList<Reference>();
            for (Reference reference : this.processingFacility) {
                dst.processingFacility.add(reference.copy());
            }
        }
        dst.division = this.division == null ? null : this.division.copy();
        dst.productStatus = this.productStatus == null ? null : this.productStatus.copy();
        dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
        dst.collection = this.collection == null ? null : this.collection.copy();
        Range range = dst.storageTempRequirements = this.storageTempRequirements == null ? null : this.storageTempRequirements.copy();
        if (this.property != null) {
            dst.property = new ArrayList<BiologicallyDerivedProductPropertyComponent>();
            for (BiologicallyDerivedProductPropertyComponent biologicallyDerivedProductPropertyComponent : this.property) {
                dst.property.add(biologicallyDerivedProductPropertyComponent.copy());
            }
        }
    }

    protected BiologicallyDerivedProduct typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof BiologicallyDerivedProduct)) {
            return false;
        }
        BiologicallyDerivedProduct o = (BiologicallyDerivedProduct)other_;
        return BiologicallyDerivedProduct.compareDeep(this.productCategory, o.productCategory, true) && BiologicallyDerivedProduct.compareDeep(this.productCode, o.productCode, true) && BiologicallyDerivedProduct.compareDeep(this.parent, o.parent, true) && BiologicallyDerivedProduct.compareDeep(this.request, o.request, true) && BiologicallyDerivedProduct.compareDeep(this.identifier, o.identifier, true) && BiologicallyDerivedProduct.compareDeep(this.biologicalSourceEvent, o.biologicalSourceEvent, true) && BiologicallyDerivedProduct.compareDeep(this.processingFacility, o.processingFacility, true) && BiologicallyDerivedProduct.compareDeep(this.division, o.division, true) && BiologicallyDerivedProduct.compareDeep(this.productStatus, o.productStatus, true) && BiologicallyDerivedProduct.compareDeep(this.expirationDate, o.expirationDate, true) && BiologicallyDerivedProduct.compareDeep(this.collection, o.collection, true) && BiologicallyDerivedProduct.compareDeep(this.storageTempRequirements, o.storageTempRequirements, true) && BiologicallyDerivedProduct.compareDeep(this.property, o.property, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof BiologicallyDerivedProduct)) {
            return false;
        }
        BiologicallyDerivedProduct o = (BiologicallyDerivedProduct)other_;
        return BiologicallyDerivedProduct.compareValues(this.division, o.division, true) && BiologicallyDerivedProduct.compareValues(this.expirationDate, o.expirationDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.productCategory, this.productCode, this.parent, this.request, this.identifier, this.biologicalSourceEvent, this.processingFacility, this.division, this.productStatus, this.expirationDate, this.collection, this.storageTempRequirements, this.property);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.BiologicallyDerivedProduct;
    }

    @Block
    public static class BiologicallyDerivedProductPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Code that specifies the property", formalDefinition="Code that specifies the property. It should reference an established coding system.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/biologicallyderived-product-property-type-codes")
        protected Coding type;
        @Child(name="value", type={BooleanType.class, IntegerType.class, CodeableConcept.class, Period.class, Quantity.class, Range.class, Ratio.class, StringType.class, Attachment.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Property values", formalDefinition="Property values.")
        protected DataType value;
        private static final long serialVersionUID = -1544667497L;

        public BiologicallyDerivedProductPropertyComponent() {
        }

        public BiologicallyDerivedProductPropertyComponent(Coding type, DataType value) {
            this.setType(type);
            this.setValue(value);
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductPropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public BiologicallyDerivedProductPropertyComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Period getValuePeriod() throws FHIRException {
            if (this.value == null) {
                this.value = new Period();
            }
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this != null && this.value instanceof Period;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (this.value == null) {
                this.value = new Ratio();
            }
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this != null && this.value instanceof Ratio;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public BiologicallyDerivedProductPropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof BooleanType || value instanceof IntegerType || value instanceof CodeableConcept || value instanceof Period || value instanceof Quantity || value instanceof Range || value instanceof Ratio || value instanceof StringType || value instanceof Attachment)) {
                throw new Error("Not the right type for BiologicallyDerivedProduct.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "Coding", "Code that specifies the property. It should reference an established coding system.", 0, 1, this.type));
            children.add(new Property("value[x]", "boolean|integer|CodeableConcept|Period|Quantity|Range|Ratio|string|Attachment", "Property values.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "Coding", "Code that specifies the property. It should reference an established coding system.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "boolean|integer|CodeableConcept|Period|Quantity|Range|Ratio|string|Attachment", "Property values.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "boolean|integer|CodeableConcept|Period|Quantity|Range|Ratio|string|Attachment", "Property values.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "Property values.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "Property values.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "Property values.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "Period", "Property values.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "Property values.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "Property values.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "Ratio", "Property values.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "Property values.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "Property values.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCoding(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCoding(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"Coding"};
                }
                case 111972721: {
                    return new String[]{"boolean", "integer", "CodeableConcept", "Period", "Quantity", "Range", "Ratio", "string", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public BiologicallyDerivedProductPropertyComponent copy() {
            BiologicallyDerivedProductPropertyComponent dst = new BiologicallyDerivedProductPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BiologicallyDerivedProductPropertyComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductPropertyComponent)) {
                return false;
            }
            BiologicallyDerivedProductPropertyComponent o = (BiologicallyDerivedProductPropertyComponent)other_;
            return BiologicallyDerivedProductPropertyComponent.compareDeep(this.type, o.type, true) && BiologicallyDerivedProductPropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductPropertyComponent)) {
                return false;
            }
            BiologicallyDerivedProductPropertyComponent o = (BiologicallyDerivedProductPropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value);
        }

        @Override
        public String fhirType() {
            return "BiologicallyDerivedProduct.property";
        }
    }

    @Block
    public static class BiologicallyDerivedProductCollectionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="collector", type={Practitioner.class, PractitionerRole.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual performing collection", formalDefinition="Healthcare professional who is performing the collection.")
        protected Reference collector;
        @Child(name="source", type={Patient.class, Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The patient or entity providing the product", formalDefinition="The patient or entity, such as a hospital or vendor in the case of a processed/manipulated/manufactured product, providing the product.")
        protected Reference source;
        @Child(name="collected", type={DateTimeType.class, Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time of product collection", formalDefinition="Time of product collection.")
        protected DataType collected;
        private static final long serialVersionUID = 626956533L;

        public Reference getCollector() {
            if (this.collector == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductCollectionComponent.collector");
                }
                if (Configuration.doAutoCreate()) {
                    this.collector = new Reference();
                }
            }
            return this.collector;
        }

        public boolean hasCollector() {
            return this.collector != null && !this.collector.isEmpty();
        }

        public BiologicallyDerivedProductCollectionComponent setCollector(Reference value) {
            this.collector = value;
            return this;
        }

        public Reference getSource() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductCollectionComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new Reference();
                }
            }
            return this.source;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public BiologicallyDerivedProductCollectionComponent setSource(Reference value) {
            this.source = value;
            return this;
        }

        public DataType getCollected() {
            return this.collected;
        }

        public DateTimeType getCollectedDateTimeType() throws FHIRException {
            if (this.collected == null) {
                this.collected = new DateTimeType();
            }
            if (!(this.collected instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.collected.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.collected;
        }

        public boolean hasCollectedDateTimeType() {
            return this != null && this.collected instanceof DateTimeType;
        }

        public Period getCollectedPeriod() throws FHIRException {
            if (this.collected == null) {
                this.collected = new Period();
            }
            if (!(this.collected instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.collected.getClass().getName() + " was encountered");
            }
            return (Period)this.collected;
        }

        public boolean hasCollectedPeriod() {
            return this != null && this.collected instanceof Period;
        }

        public boolean hasCollected() {
            return this.collected != null && !this.collected.isEmpty();
        }

        public BiologicallyDerivedProductCollectionComponent setCollected(DataType value) {
            if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
                throw new Error("Not the right type for BiologicallyDerivedProduct.collection.collected[x]: " + value.fhirType());
            }
            this.collected = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(BiologicallyDerivedProduct.SP_COLLECTOR, "Reference(Practitioner|PractitionerRole)", "Healthcare professional who is performing the collection.", 0, 1, this.collector));
            children.add(new Property("source", "Reference(Patient|Organization)", "The patient or entity, such as a hospital or vendor in the case of a processed/manipulated/manufactured product, providing the product.", 0, 1, this.source));
            children.add(new Property("collected[x]", "dateTime|Period", "Time of product collection.", 0, 1, this.collected));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1883491469: {
                    return new Property(BiologicallyDerivedProduct.SP_COLLECTOR, "Reference(Practitioner|PractitionerRole)", "Healthcare professional who is performing the collection.", 0, 1, this.collector);
                }
                case -896505829: {
                    return new Property("source", "Reference(Patient|Organization)", "The patient or entity, such as a hospital or vendor in the case of a processed/manipulated/manufactured product, providing the product.", 0, 1, this.source);
                }
                case 1632037015: {
                    return new Property("collected[x]", "dateTime|Period", "Time of product collection.", 0, 1, this.collected);
                }
                case 1883491145: {
                    return new Property("collected[x]", "dateTime|Period", "Time of product collection.", 0, 1, this.collected);
                }
                case 2005009924: {
                    return new Property("collected[x]", "dateTime", "Time of product collection.", 0, 1, this.collected);
                }
                case 653185642: {
                    return new Property("collected[x]", "Period", "Time of product collection.", 0, 1, this.collected);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    Base[] baseArray;
                    if (this.collector == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.collector;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
                case 1883491145: {
                    Base[] baseArray;
                    if (this.collected == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.collected;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    this.collector = TypeConvertor.castToReference(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1883491145: {
                    this.collected = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(BiologicallyDerivedProduct.SP_COLLECTOR)) {
                this.collector = TypeConvertor.castToReference(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToReference(value);
            } else if (name.equals("collected[x]")) {
                this.collected = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    return this.getCollector();
                }
                case -896505829: {
                    return this.getSource();
                }
                case 1632037015: {
                    return this.getCollected();
                }
                case 1883491145: {
                    return this.getCollected();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    return new String[]{"Reference"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
                case 1883491145: {
                    return new String[]{"dateTime", "Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(BiologicallyDerivedProduct.SP_COLLECTOR)) {
                this.collector = new Reference();
                return this.collector;
            }
            if (name.equals("source")) {
                this.source = new Reference();
                return this.source;
            }
            if (name.equals("collectedDateTime")) {
                this.collected = new DateTimeType();
                return this.collected;
            }
            if (name.equals("collectedPeriod")) {
                this.collected = new Period();
                return this.collected;
            }
            return super.addChild(name);
        }

        @Override
        public BiologicallyDerivedProductCollectionComponent copy() {
            BiologicallyDerivedProductCollectionComponent dst = new BiologicallyDerivedProductCollectionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BiologicallyDerivedProductCollectionComponent dst) {
            super.copyValues(dst);
            dst.collector = this.collector == null ? null : this.collector.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.collected = this.collected == null ? null : this.collected.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductCollectionComponent)) {
                return false;
            }
            BiologicallyDerivedProductCollectionComponent o = (BiologicallyDerivedProductCollectionComponent)other_;
            return BiologicallyDerivedProductCollectionComponent.compareDeep(this.collector, o.collector, true) && BiologicallyDerivedProductCollectionComponent.compareDeep(this.source, o.source, true) && BiologicallyDerivedProductCollectionComponent.compareDeep(this.collected, o.collected, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductCollectionComponent)) {
                return false;
            }
            BiologicallyDerivedProductCollectionComponent o = (BiologicallyDerivedProductCollectionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.collector, this.source, this.collected);
        }

        @Override
        public String fhirType() {
            return "BiologicallyDerivedProduct.collection";
        }
    }
}

