/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.util.ElementUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.PrimitiveType;

@DatatypeDef(name="base64Binary")
public class Base64BinaryType
extends PrimitiveType<byte[]>
implements IPrimitiveType<byte[]>,
IBaseHasExtensions,
IElement,
Externalizable {
    private static final long serialVersionUID = 3L;
    private byte[] myValue;

    public Base64BinaryType() {
    }

    public Base64BinaryType(byte[] theBytes) {
        this.setValue(theBytes);
    }

    public Base64BinaryType(String theValue) {
        this.setValueAsString(theValue);
    }

    @Override
    protected byte[] parse(String theValue) {
        if (theValue != null) {
            return Base64.decodeBase64(theValue.getBytes(Constants.CHARSET_UTF8));
        }
        return null;
    }

    @Override
    protected String encode(byte[] theValue) {
        if (theValue == null) {
            return null;
        }
        return new String(Base64.encodeBase64(theValue), Constants.CHARSET_UTF8);
    }

    @Override
    public Base64BinaryType copy() {
        return new Base64BinaryType(this.getValue());
    }

    @Override
    protected DataType typedCopy() {
        return this.copy();
    }

    @Override
    public String fhirType() {
        return "base64Binary";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getValue());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setValue((byte[])in.readObject());
    }

    @Override
    public String getValueAsString() {
        return this.encode(this.myValue);
    }

    @Override
    public void setValueAsString(String theValue) throws IllegalArgumentException {
        if (theValue != null) {
            this.checkValidBase64(theValue);
        }
        this.fromStringValue(theValue);
        this.setValue(this.parse(theValue));
    }

    @Override
    public byte[] getValue() {
        return this.myValue;
    }

    public Base64BinaryType setValue(byte[] theValue) throws IllegalArgumentException {
        this.myValue = theValue;
        return (Base64BinaryType)super.setValue(theValue);
    }

    @Override
    public boolean hasValue() {
        return this.myValue != null && this.myValue.length > 0;
    }

    @Override
    public boolean isEmpty() {
        return ElementUtil.isEmpty(this.id, this.extension) && !this.hasValue();
    }

    @Override
    public String primitiveValue() {
        return this.encode(this.myValue);
    }

    public void checkValidBase64(String toCheck) throws DataFormatException {
        if (!org.hl7.fhir.utilities.Base64.isBase64(toCheck.getBytes())) {
            throw new DataFormatException("");
        }
    }
}

