/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;

@ResourceDef(name="AuditEvent", profile="http://hl7.org/fhir/StructureDefinition/AuditEvent")
public class AuditEvent
extends DomainResource {
    @Child(name="category", type={CodeableConcept.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type/identifier of event", formalDefinition="Classification of the type of event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-type")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specific type of event", formalDefinition="Describes what happened. The most specific code for the event.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-sub-type")
    protected CodeableConcept code;
    @Child(name="action", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of action performed during the event", formalDefinition="Indicator for type of action performed during the event that generated the audit.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-action")
    protected Enumeration<AuditEventAction> action;
    @Child(name="severity", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="emergency | alert | critical | error | warning | notice | informational | debug", formalDefinition="Indicates and enables segmentation of various severity including debugging from critical.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-severity")
    protected Enumeration<AuditEventSeverity> severity;
    @Child(name="occurred", type={Period.class, DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the activity occurred", formalDefinition="The time or period during which the activity occurred.")
    protected DataType occurred;
    @Child(name="recorded", type={InstantType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time when the event was recorded", formalDefinition="The time when the event was recorded.")
    protected InstantType recorded;
    @Child(name="outcome", type={}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the event succeeded or failed", formalDefinition="Indicates whether the event succeeded or failed. A free text descripiton can be given in outcome.text.")
    protected AuditEventOutcomeComponent outcome;
    @Child(name="authorization", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Authorization related to the event", formalDefinition="The authorization (e.g., PurposeOfUse) that was used during the event being recorded.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
    protected List<CodeableConcept> authorization;
    @Child(name="basedOn", type={CarePlan.class, DeviceRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class, Task.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Workflow authorization within which this event occurred", formalDefinition="Allows tracing of authorizatino for the events and tracking whether proposals/recommendations were acted upon.")
    protected List<Reference> basedOn;
    @Child(name="patient", type={Patient.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The patient is the subject of the data used/created/updated/deleted during the activity", formalDefinition="The patient element is available to enable deterministic tracking of activities that involve the patient as the subject of the data used in an activity.")
    protected Reference patient;
    @Child(name="encounter", type={Encounter.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter within which this event occurred or which the event is tightly associated", formalDefinition="This will typically be the encounter the event occurred, but some events may be initiated prior to or after the official completion of an encounter but still be tied to the context of the encounter (e.g. pre-admission lab tests).")
    protected Reference encounter;
    @Child(name="agent", type={}, order=11, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Actor involved in the event", formalDefinition="An actor taking an active role in the event or activity that is logged.")
    protected List<AuditEventAgentComponent> agent;
    @Child(name="source", type={}, order=12, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Audit Event Reporter", formalDefinition="The actor that is reporting the event.")
    protected AuditEventSourceComponent source;
    @Child(name="entity", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Data or objects used", formalDefinition="Specific instances of data or objects that have been accessed.")
    protected List<AuditEventEntityComponent> entity;
    private static final long serialVersionUID = -1335832480L;
    @SearchParamDefinition(name="action", path="AuditEvent.action", description="Type of action performed during the event", type="token")
    public static final String SP_ACTION = "action";
    public static final TokenClientParam ACTION = new TokenClientParam("action");
    @SearchParamDefinition(name="agent-role", path="AuditEvent.agent.role", description="Agent role in the event", type="token")
    public static final String SP_AGENT_ROLE = "agent-role";
    public static final TokenClientParam AGENT_ROLE = new TokenClientParam("agent-role");
    @SearchParamDefinition(name="agent", path="AuditEvent.agent.who", description="Identifier of who", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Device"), @Compartment(name="Base FHIR compartment definition for Practitioner")}, target={CareTeam.class, Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_AGENT = "agent";
    public static final ReferenceClientParam AGENT = new ReferenceClientParam("agent");
    public static final Include INCLUDE_AGENT = new Include("AuditEvent:agent").toLocked();
    @SearchParamDefinition(name="based-on", path="AuditEvent.basedOn", description="Reference to the service request.", type="reference", target={CarePlan.class, DeviceRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ServiceRequest.class, Task.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("AuditEvent:based-on").toLocked();
    @SearchParamDefinition(name="category", path="AuditEvent.category", description="Category of event", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="code", path="AuditEvent.code", description="More specific code for the event", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="AuditEvent.recorded", description="Time when the event was recorded", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="encounter", path="AuditEvent.encounter", description="Encounter related to the activity recorded in the AuditEvent", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("AuditEvent:encounter").toLocked();
    @SearchParamDefinition(name="entity-role", path="AuditEvent.entity.role", description="What role the entity played", type="token")
    public static final String SP_ENTITY_ROLE = "entity-role";
    public static final TokenClientParam ENTITY_ROLE = new TokenClientParam("entity-role");
    @SearchParamDefinition(name="entity", path="AuditEvent.entity.what", description="Specific instance of resource", type="reference", target={Account.class, ActivityDefinition.class, ActorDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, ArtifactAssessment.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CarePlan.class, CareTeam.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseDefinition.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceDispense.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, FormularyItem.class, GenomicStudy.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingSelection.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestOrchestration.class, Requirements.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, Transport.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_ENTITY = "entity";
    public static final ReferenceClientParam ENTITY = new ReferenceClientParam("entity");
    public static final Include INCLUDE_ENTITY = new Include("AuditEvent:entity").toLocked();
    @SearchParamDefinition(name="outcome", path="AuditEvent.outcome.code", description="Whether the event succeeded or failed", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");
    @SearchParamDefinition(name="patient", path="AuditEvent.patient", description="Where the activity involved patient data", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("AuditEvent:patient").toLocked();
    @SearchParamDefinition(name="policy", path="AuditEvent.agent.policy", description="Policy that authorized event", type="uri")
    public static final String SP_POLICY = "policy";
    public static final UriClientParam POLICY = new UriClientParam("policy");
    @SearchParamDefinition(name="purpose", path="AuditEvent.authorization | AuditEvent.agent.authorization", description="The authorization (purposeOfUse) of the event", type="token")
    public static final String SP_PURPOSE = "purpose";
    public static final TokenClientParam PURPOSE = new TokenClientParam("purpose");
    @SearchParamDefinition(name="source", path="AuditEvent.source.observer", description="The identity of source detecting the event", type="reference", target={CareTeam.class, Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("AuditEvent:source").toLocked();

    public AuditEvent() {
    }

    public AuditEvent(CodeableConcept code, Date recorded, AuditEventAgentComponent agent, AuditEventSourceComponent source) {
        this.setCode(code);
        this.setRecorded(recorded);
        this.addAgent(agent);
        this.setSource(source);
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public AuditEvent setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public AuditEvent addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public AuditEvent setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Enumeration<AuditEventAction> getActionElement() {
        if (this.action == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.action");
            }
            if (Configuration.doAutoCreate()) {
                this.action = new Enumeration<AuditEventAction>(new AuditEventActionEnumFactory());
            }
        }
        return this.action;
    }

    public boolean hasActionElement() {
        return this.action != null && !this.action.isEmpty();
    }

    public boolean hasAction() {
        return this.action != null && !this.action.isEmpty();
    }

    public AuditEvent setActionElement(Enumeration<AuditEventAction> value) {
        this.action = value;
        return this;
    }

    public AuditEventAction getAction() {
        return this.action == null ? null : (AuditEventAction)((Object)this.action.getValue());
    }

    public AuditEvent setAction(AuditEventAction value) {
        if (value == null) {
            this.action = null;
        } else {
            if (this.action == null) {
                this.action = new Enumeration<AuditEventAction>(new AuditEventActionEnumFactory());
            }
            this.action.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<AuditEventSeverity> getSeverityElement() {
        if (this.severity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.severity");
            }
            if (Configuration.doAutoCreate()) {
                this.severity = new Enumeration<AuditEventSeverity>(new AuditEventSeverityEnumFactory());
            }
        }
        return this.severity;
    }

    public boolean hasSeverityElement() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public boolean hasSeverity() {
        return this.severity != null && !this.severity.isEmpty();
    }

    public AuditEvent setSeverityElement(Enumeration<AuditEventSeverity> value) {
        this.severity = value;
        return this;
    }

    public AuditEventSeverity getSeverity() {
        return this.severity == null ? null : (AuditEventSeverity)((Object)this.severity.getValue());
    }

    public AuditEvent setSeverity(AuditEventSeverity value) {
        if (value == null) {
            this.severity = null;
        } else {
            if (this.severity == null) {
                this.severity = new Enumeration<AuditEventSeverity>(new AuditEventSeverityEnumFactory());
            }
            this.severity.setValue((Object)value);
        }
        return this;
    }

    public DataType getOccurred() {
        return this.occurred;
    }

    public Period getOccurredPeriod() throws FHIRException {
        if (this.occurred == null) {
            this.occurred = new Period();
        }
        if (!(this.occurred instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurred.getClass().getName() + " was encountered");
        }
        return (Period)this.occurred;
    }

    public boolean hasOccurredPeriod() {
        return this != null && this.occurred instanceof Period;
    }

    public DateTimeType getOccurredDateTimeType() throws FHIRException {
        if (this.occurred == null) {
            this.occurred = new DateTimeType();
        }
        if (!(this.occurred instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurred.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurred;
    }

    public boolean hasOccurredDateTimeType() {
        return this != null && this.occurred instanceof DateTimeType;
    }

    public boolean hasOccurred() {
        return this.occurred != null && !this.occurred.isEmpty();
    }

    public AuditEvent setOccurred(DataType value) {
        if (value != null && !(value instanceof Period) && !(value instanceof DateTimeType)) {
            throw new Error("Not the right type for AuditEvent.occurred[x]: " + value.fhirType());
        }
        this.occurred = value;
        return this;
    }

    public InstantType getRecordedElement() {
        if (this.recorded == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.recorded");
            }
            if (Configuration.doAutoCreate()) {
                this.recorded = new InstantType();
            }
        }
        return this.recorded;
    }

    public boolean hasRecordedElement() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public boolean hasRecorded() {
        return this.recorded != null && !this.recorded.isEmpty();
    }

    public AuditEvent setRecordedElement(InstantType value) {
        this.recorded = value;
        return this;
    }

    public Date getRecorded() {
        return this.recorded == null ? null : (Date)this.recorded.getValue();
    }

    public AuditEvent setRecorded(Date value) {
        if (this.recorded == null) {
            this.recorded = new InstantType();
        }
        this.recorded.setValue(value);
        return this;
    }

    public AuditEventOutcomeComponent getOutcome() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new AuditEventOutcomeComponent();
            }
        }
        return this.outcome;
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public AuditEvent setOutcome(AuditEventOutcomeComponent value) {
        this.outcome = value;
        return this;
    }

    public List<CodeableConcept> getAuthorization() {
        if (this.authorization == null) {
            this.authorization = new ArrayList<CodeableConcept>();
        }
        return this.authorization;
    }

    public AuditEvent setAuthorization(List<CodeableConcept> theAuthorization) {
        this.authorization = theAuthorization;
        return this;
    }

    public boolean hasAuthorization() {
        if (this.authorization == null) {
            return false;
        }
        for (CodeableConcept item : this.authorization) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAuthorization() {
        CodeableConcept t = new CodeableConcept();
        if (this.authorization == null) {
            this.authorization = new ArrayList<CodeableConcept>();
        }
        this.authorization.add(t);
        return t;
    }

    public AuditEvent addAuthorization(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.authorization == null) {
            this.authorization = new ArrayList<CodeableConcept>();
        }
        this.authorization.add(t);
        return this;
    }

    public CodeableConcept getAuthorizationFirstRep() {
        if (this.getAuthorization().isEmpty()) {
            this.addAuthorization();
        }
        return this.getAuthorization().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public AuditEvent setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public AuditEvent addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public AuditEvent setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public AuditEvent setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public List<AuditEventAgentComponent> getAgent() {
        if (this.agent == null) {
            this.agent = new ArrayList<AuditEventAgentComponent>();
        }
        return this.agent;
    }

    public AuditEvent setAgent(List<AuditEventAgentComponent> theAgent) {
        this.agent = theAgent;
        return this;
    }

    public boolean hasAgent() {
        if (this.agent == null) {
            return false;
        }
        for (AuditEventAgentComponent item : this.agent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AuditEventAgentComponent addAgent() {
        AuditEventAgentComponent t = new AuditEventAgentComponent();
        if (this.agent == null) {
            this.agent = new ArrayList<AuditEventAgentComponent>();
        }
        this.agent.add(t);
        return t;
    }

    public AuditEvent addAgent(AuditEventAgentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.agent == null) {
            this.agent = new ArrayList<AuditEventAgentComponent>();
        }
        this.agent.add(t);
        return this;
    }

    public AuditEventAgentComponent getAgentFirstRep() {
        if (this.getAgent().isEmpty()) {
            this.addAgent();
        }
        return this.getAgent().get(0);
    }

    public AuditEventSourceComponent getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AuditEvent.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new AuditEventSourceComponent();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public AuditEvent setSource(AuditEventSourceComponent value) {
        this.source = value;
        return this;
    }

    public List<AuditEventEntityComponent> getEntity() {
        if (this.entity == null) {
            this.entity = new ArrayList<AuditEventEntityComponent>();
        }
        return this.entity;
    }

    public AuditEvent setEntity(List<AuditEventEntityComponent> theEntity) {
        this.entity = theEntity;
        return this;
    }

    public boolean hasEntity() {
        if (this.entity == null) {
            return false;
        }
        for (AuditEventEntityComponent item : this.entity) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AuditEventEntityComponent addEntity() {
        AuditEventEntityComponent t = new AuditEventEntityComponent();
        if (this.entity == null) {
            this.entity = new ArrayList<AuditEventEntityComponent>();
        }
        this.entity.add(t);
        return t;
    }

    public AuditEvent addEntity(AuditEventEntityComponent t) {
        if (t == null) {
            return this;
        }
        if (this.entity == null) {
            this.entity = new ArrayList<AuditEventEntityComponent>();
        }
        this.entity.add(t);
        return this;
    }

    public AuditEventEntityComponent getEntityFirstRep() {
        if (this.getEntity().isEmpty()) {
            this.addEntity();
        }
        return this.getEntity().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "Classification of the type of event.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "Describes what happened. The most specific code for the event.", 0, 1, this.code));
        children.add(new Property(SP_ACTION, SP_CODE, "Indicator for type of action performed during the event that generated the audit.", 0, 1, this.action));
        children.add(new Property("severity", SP_CODE, "Indicates and enables segmentation of various severity including debugging from critical.", 0, 1, this.severity));
        children.add(new Property("occurred[x]", "Period|dateTime", "The time or period during which the activity occurred.", 0, 1, this.occurred));
        children.add(new Property("recorded", "instant", "The time when the event was recorded.", 0, 1, this.recorded));
        children.add(new Property(SP_OUTCOME, "", "Indicates whether the event succeeded or failed. A free text descripiton can be given in outcome.text.", 0, 1, this.outcome));
        children.add(new Property("authorization", "CodeableConcept", "The authorization (e.g., PurposeOfUse) that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.authorization));
        children.add(new Property("basedOn", "Reference(CarePlan|DeviceRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ServiceRequest|Task)", "Allows tracing of authorizatino for the events and tracking whether proposals/recommendations were acted upon.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient element is available to enable deterministic tracking of activities that involve the patient as the subject of the data used in an activity.", 0, 1, this.patient));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "This will typically be the encounter the event occurred, but some events may be initiated prior to or after the official completion of an encounter but still be tied to the context of the encounter (e.g. pre-admission lab tests).", 0, 1, this.encounter));
        children.add(new Property(SP_AGENT, "", "An actor taking an active role in the event or activity that is logged.", 0, Integer.MAX_VALUE, this.agent));
        children.add(new Property(SP_SOURCE, "", "The actor that is reporting the event.", 0, 1, this.source));
        children.add(new Property(SP_ENTITY, "", "Specific instances of data or objects that have been accessed.", 0, Integer.MAX_VALUE, this.entity));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "Classification of the type of event.", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Describes what happened. The most specific code for the event.", 0, 1, this.code);
            }
            case -1422950858: {
                return new Property(SP_ACTION, SP_CODE, "Indicator for type of action performed during the event that generated the audit.", 0, 1, this.action);
            }
            case 1478300413: {
                return new Property("severity", SP_CODE, "Indicates and enables segmentation of various severity including debugging from critical.", 0, 1, this.severity);
            }
            case 784181563: {
                return new Property("occurred[x]", "Period|dateTime", "The time or period during which the activity occurred.", 0, 1, this.occurred);
            }
            case 792816933: {
                return new Property("occurred[x]", "Period|dateTime", "The time or period during which the activity occurred.", 0, 1, this.occurred);
            }
            case 894082886: {
                return new Property("occurred[x]", "Period", "The time or period during which the activity occurred.", 0, 1, this.occurred);
            }
            case 1579027424: {
                return new Property("occurred[x]", "dateTime", "The time or period during which the activity occurred.", 0, 1, this.occurred);
            }
            case -799233872: {
                return new Property("recorded", "instant", "The time when the event was recorded.", 0, 1, this.recorded);
            }
            case -1106507950: {
                return new Property(SP_OUTCOME, "", "Indicates whether the event succeeded or failed. A free text descripiton can be given in outcome.text.", 0, 1, this.outcome);
            }
            case -1385570183: {
                return new Property("authorization", "CodeableConcept", "The authorization (e.g., PurposeOfUse) that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.authorization);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|DeviceRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ServiceRequest|Task)", "Allows tracing of authorizatino for the events and tracking whether proposals/recommendations were acted upon.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient element is available to enable deterministic tracking of activities that involve the patient as the subject of the data used in an activity.", 0, 1, this.patient);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "This will typically be the encounter the event occurred, but some events may be initiated prior to or after the official completion of an encounter but still be tied to the context of the encounter (e.g. pre-admission lab tests).", 0, 1, this.encounter);
            }
            case 92750597: {
                return new Property(SP_AGENT, "", "An actor taking an active role in the event or activity that is logged.", 0, Integer.MAX_VALUE, this.agent);
            }
            case -896505829: {
                return new Property(SP_SOURCE, "", "The actor that is reporting the event.", 0, 1, this.source);
            }
            case -1298275357: {
                return new Property(SP_ENTITY, "", "Specific instances of data or objects that have been accessed.", 0, Integer.MAX_VALUE, this.entity);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case -1422950858: {
                Base[] baseArray;
                if (this.action == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.action;
                }
                return baseArray;
            }
            case 1478300413: {
                Base[] baseArray;
                if (this.severity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.severity;
                }
                return baseArray;
            }
            case 792816933: {
                Base[] baseArray;
                if (this.occurred == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.occurred;
                }
                return baseArray;
            }
            case -799233872: {
                Base[] baseArray;
                if (this.recorded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.recorded;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.outcome;
                }
                return baseArray;
            }
            case -1385570183: {
                return this.authorization == null ? new Base[]{} : this.authorization.toArray(new Base[this.authorization.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.patient;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.encounter;
                }
                return baseArray;
            }
            case 92750597: {
                return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
            }
            case -896505829: {
                Base[] baseArray;
                if (this.source == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.source;
                }
                return baseArray;
            }
            case -1298275357: {
                return this.entity == null ? new Base[]{} : this.entity.toArray(new Base[this.entity.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 50511102: {
                this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1422950858: {
                value = new AuditEventActionEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.action = value;
                return value;
            }
            case 1478300413: {
                value = new AuditEventSeverityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.severity = value;
                return value;
            }
            case 792816933: {
                this.occurred = TypeConvertor.castToType(value);
                return value;
            }
            case -799233872: {
                this.recorded = TypeConvertor.castToInstant(value);
                return value;
            }
            case -1106507950: {
                this.outcome = (AuditEventOutcomeComponent)((Object)value);
                return value;
            }
            case -1385570183: {
                this.getAuthorization().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 92750597: {
                this.getAgent().add((AuditEventAgentComponent)((Object)value));
                return value;
            }
            case -896505829: {
                this.source = (AuditEventSourceComponent)((Object)value);
                return value;
            }
            case -1298275357: {
                this.getEntity().add((AuditEventEntityComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_ACTION)) {
            value = new AuditEventActionEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.action = value;
        } else if (name.equals("severity")) {
            value = new AuditEventSeverityEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.severity = value;
        } else if (name.equals("occurred[x]")) {
            this.occurred = TypeConvertor.castToType(value);
        } else if (name.equals("recorded")) {
            this.recorded = TypeConvertor.castToInstant(value);
        } else if (name.equals(SP_OUTCOME)) {
            this.outcome = (AuditEventOutcomeComponent)((Object)value);
        } else if (name.equals("authorization")) {
            this.getAuthorization().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_AGENT)) {
            this.getAgent().add((AuditEventAgentComponent)((Object)value));
        } else if (name.equals(SP_SOURCE)) {
            this.source = (AuditEventSourceComponent)((Object)value);
        } else if (name.equals(SP_ENTITY)) {
            this.getEntity().add((AuditEventEntityComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1422950858: {
                return this.getActionElement();
            }
            case 1478300413: {
                return this.getSeverityElement();
            }
            case 784181563: {
                return this.getOccurred();
            }
            case 792816933: {
                return this.getOccurred();
            }
            case -799233872: {
                return this.getRecordedElement();
            }
            case -1106507950: {
                return this.getOutcome();
            }
            case -1385570183: {
                return this.addAuthorization();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case 92750597: {
                return this.addAgent();
            }
            case -896505829: {
                return this.getSource();
            }
            case -1298275357: {
                return this.addEntity();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1422950858: {
                return new String[]{SP_CODE};
            }
            case 1478300413: {
                return new String[]{SP_CODE};
            }
            case 792816933: {
                return new String[]{"Period", "dateTime"};
            }
            case -799233872: {
                return new String[]{"instant"};
            }
            case -1106507950: {
                return new String[0];
            }
            case -1385570183: {
                return new String[]{"CodeableConcept"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 92750597: {
                return new String[0];
            }
            case -896505829: {
                return new String[0];
            }
            case -1298275357: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_ACTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.action");
        }
        if (name.equals("severity")) {
            throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.severity");
        }
        if (name.equals("occurredPeriod")) {
            this.occurred = new Period();
            return this.occurred;
        }
        if (name.equals("occurredDateTime")) {
            this.occurred = new DateTimeType();
            return this.occurred;
        }
        if (name.equals("recorded")) {
            throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.recorded");
        }
        if (name.equals(SP_OUTCOME)) {
            this.outcome = new AuditEventOutcomeComponent();
            return this.outcome;
        }
        if (name.equals("authorization")) {
            return this.addAuthorization();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_AGENT)) {
            return this.addAgent();
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new AuditEventSourceComponent();
            return this.source;
        }
        if (name.equals(SP_ENTITY)) {
            return this.addEntity();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AuditEvent";
    }

    @Override
    public AuditEvent copy() {
        AuditEvent dst = new AuditEvent();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(AuditEvent dst) {
        super.copyValues(dst);
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.action = this.action == null ? null : this.action.copy();
        dst.severity = this.severity == null ? null : this.severity.copy();
        dst.occurred = this.occurred == null ? null : this.occurred.copy();
        dst.recorded = this.recorded == null ? null : this.recorded.copy();
        AuditEventOutcomeComponent auditEventOutcomeComponent = dst.outcome = this.outcome == null ? null : this.outcome.copy();
        if (this.authorization != null) {
            dst.authorization = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.authorization) {
                dst.authorization.add(codeableConcept.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        Reference reference = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.agent != null) {
            dst.agent = new ArrayList<AuditEventAgentComponent>();
            for (AuditEventAgentComponent auditEventAgentComponent : this.agent) {
                dst.agent.add(auditEventAgentComponent.copy());
            }
        }
        AuditEventSourceComponent auditEventSourceComponent = dst.source = this.source == null ? null : this.source.copy();
        if (this.entity != null) {
            dst.entity = new ArrayList<AuditEventEntityComponent>();
            for (AuditEventEntityComponent auditEventEntityComponent : this.entity) {
                dst.entity.add(auditEventEntityComponent.copy());
            }
        }
    }

    protected AuditEvent typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AuditEvent)) {
            return false;
        }
        AuditEvent o = (AuditEvent)other_;
        return AuditEvent.compareDeep(this.category, o.category, true) && AuditEvent.compareDeep(this.code, o.code, true) && AuditEvent.compareDeep(this.action, o.action, true) && AuditEvent.compareDeep(this.severity, o.severity, true) && AuditEvent.compareDeep(this.occurred, o.occurred, true) && AuditEvent.compareDeep(this.recorded, o.recorded, true) && AuditEvent.compareDeep(this.outcome, o.outcome, true) && AuditEvent.compareDeep(this.authorization, o.authorization, true) && AuditEvent.compareDeep(this.basedOn, o.basedOn, true) && AuditEvent.compareDeep(this.patient, o.patient, true) && AuditEvent.compareDeep(this.encounter, o.encounter, true) && AuditEvent.compareDeep(this.agent, o.agent, true) && AuditEvent.compareDeep(this.source, o.source, true) && AuditEvent.compareDeep(this.entity, o.entity, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AuditEvent)) {
            return false;
        }
        AuditEvent o = (AuditEvent)other_;
        return AuditEvent.compareValues(this.action, o.action, true) && AuditEvent.compareValues(this.severity, o.severity, true) && AuditEvent.compareValues(this.recorded, o.recorded, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.category, this.code, this.action, this.severity, this.occurred, this.recorded, this.outcome, this.authorization, this.basedOn, this.patient, this.encounter, this.agent, this.source, this.entity);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AuditEvent;
    }

    @Block
    public static class AuditEventEntityDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of the property", formalDefinition="The type of extra detail provided in the value.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-type")
        protected CodeableConcept type;
        @Child(name="value", type={Quantity.class, CodeableConcept.class, StringType.class, BooleanType.class, IntegerType.class, Range.class, Ratio.class, TimeType.class, DateTimeType.class, Period.class, Base64BinaryType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Property value", formalDefinition="The  value of the extra detail.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public AuditEventEntityDetailComponent() {
        }

        public AuditEventEntityDetailComponent(CodeableConcept type, DataType value) {
            this.setType(type);
            this.setValue(value);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityDetailComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AuditEventEntityDetailComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this != null && this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this != null && this.value instanceof IntegerType;
        }

        public Range getValueRange() throws FHIRException {
            if (this.value == null) {
                this.value = new Range();
            }
            if (!(this.value instanceof Range)) {
                throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Range)this.value;
        }

        public boolean hasValueRange() {
            return this != null && this.value instanceof Range;
        }

        public Ratio getValueRatio() throws FHIRException {
            if (this.value == null) {
                this.value = new Ratio();
            }
            if (!(this.value instanceof Ratio)) {
                throw new FHIRException("Type mismatch: the type Ratio was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Ratio)this.value;
        }

        public boolean hasValueRatio() {
            return this != null && this.value instanceof Ratio;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new TimeType();
            }
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this != null && this.value instanceof TimeType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this != null && this.value instanceof DateTimeType;
        }

        public Period getValuePeriod() throws FHIRException {
            if (this.value == null) {
                this.value = new Period();
            }
            if (!(this.value instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Period)this.value;
        }

        public boolean hasValuePeriod() {
            return this != null && this.value instanceof Period;
        }

        public Base64BinaryType getValueBase64BinaryType() throws FHIRException {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            if (!(this.value instanceof Base64BinaryType)) {
                throw new FHIRException("Type mismatch: the type Base64BinaryType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Base64BinaryType)this.value;
        }

        public boolean hasValueBase64BinaryType() {
            return this != null && this.value instanceof Base64BinaryType;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AuditEventEntityDetailComponent setValue(DataType value) {
            if (!(value == null || value instanceof Quantity || value instanceof CodeableConcept || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof Range || value instanceof Ratio || value instanceof TimeType || value instanceof DateTimeType || value instanceof Period || value instanceof Base64BinaryType)) {
                throw new Error("Not the right type for AuditEvent.entity.detail.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The type of extra detail provided in the value.", 0, 1, this.type));
            children.add(new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Ratio|time|dateTime|Period|base64Binary", "The  value of the extra detail.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The type of extra detail provided in the value.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Ratio|time|dateTime|Period|base64Binary", "The  value of the extra detail.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Quantity|CodeableConcept|string|boolean|integer|Range|Ratio|time|dateTime|Period|base64Binary", "The  value of the extra detail.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The  value of the extra detail.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The  value of the extra detail.", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The  value of the extra detail.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The  value of the extra detail.", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The  value of the extra detail.", 0, 1, this.value);
                }
                case 2030761548: {
                    return new Property("value[x]", "Range", "The  value of the extra detail.", 0, 1, this.value);
                }
                case 2030767386: {
                    return new Property("value[x]", "Ratio", "The  value of the extra detail.", 0, 1, this.value);
                }
                case -765708322: {
                    return new Property("value[x]", "time", "The  value of the extra detail.", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The  value of the extra detail.", 0, 1, this.value);
                }
                case -1524344174: {
                    return new Property("value[x]", "Period", "The  value of the extra detail.", 0, 1, this.value);
                }
                case -1535024575: {
                    return new Property("value[x]", "base64Binary", "The  value of the extra detail.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"Quantity", "CodeableConcept", "string", "boolean", "integer", "Range", "Ratio", "time", "dateTime", "Period", "base64Binary"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueRange")) {
                this.value = new Range();
                return this.value;
            }
            if (name.equals("valueRatio")) {
                this.value = new Ratio();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valuePeriod")) {
                this.value = new Period();
                return this.value;
            }
            if (name.equals("valueBase64Binary")) {
                this.value = new Base64BinaryType();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventEntityDetailComponent copy() {
            AuditEventEntityDetailComponent dst = new AuditEventEntityDetailComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AuditEventEntityDetailComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventEntityDetailComponent)) {
                return false;
            }
            AuditEventEntityDetailComponent o = (AuditEventEntityDetailComponent)other_;
            return AuditEventEntityDetailComponent.compareDeep(this.type, o.type, true) && AuditEventEntityDetailComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventEntityDetailComponent)) {
                return false;
            }
            AuditEventEntityDetailComponent o = (AuditEventEntityDetailComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value);
        }

        @Override
        public String fhirType() {
            return "AuditEvent.entity.detail";
        }
    }

    @Block
    public static class AuditEventEntityComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="what", type={Reference.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific instance of resource", formalDefinition="Identifies a specific instance of the entity. The reference should be version specific. This is allowed to be a Parameters resource.")
        protected Reference what;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="What role the entity played", formalDefinition="Code representing the role the entity played in the event being audited.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/object-role")
        protected CodeableConcept role;
        @Child(name="securityLabel", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Security labels on the entity", formalDefinition="Security labels for the identified entity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-label-examples")
        protected List<CodeableConcept> securityLabel;
        @Child(name="query", type={Base64BinaryType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Query parameters", formalDefinition="The query parameters for a query-type entities.")
        protected Base64BinaryType query;
        @Child(name="detail", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional Information about the entity", formalDefinition="Tagged value pairs for conveying additional information about the entity.")
        protected List<AuditEventEntityDetailComponent> detail;
        @Child(name="agent", type={AuditEventAgentComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Entity is attributed to this agent", formalDefinition="The entity is attributed to an agent to express the agent's responsibility for that entity in the activity. This is most used to indicate when persistence media (the entity) are used by an agent. For example when importing data from a device, the device would be described in an entity, and the user importing data from that media would be indicated as the entity.agent.")
        protected List<AuditEventAgentComponent> agent;
        private static final long serialVersionUID = -711898650L;

        public Reference getWhat() {
            if (this.what == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityComponent.what");
                }
                if (Configuration.doAutoCreate()) {
                    this.what = new Reference();
                }
            }
            return this.what;
        }

        public boolean hasWhat() {
            return this.what != null && !this.what.isEmpty();
        }

        public AuditEventEntityComponent setWhat(Reference value) {
            this.what = value;
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public AuditEventEntityComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public List<CodeableConcept> getSecurityLabel() {
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<CodeableConcept>();
            }
            return this.securityLabel;
        }

        public AuditEventEntityComponent setSecurityLabel(List<CodeableConcept> theSecurityLabel) {
            this.securityLabel = theSecurityLabel;
            return this;
        }

        public boolean hasSecurityLabel() {
            if (this.securityLabel == null) {
                return false;
            }
            for (CodeableConcept item : this.securityLabel) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSecurityLabel() {
            CodeableConcept t = new CodeableConcept();
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<CodeableConcept>();
            }
            this.securityLabel.add(t);
            return t;
        }

        public AuditEventEntityComponent addSecurityLabel(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.securityLabel == null) {
                this.securityLabel = new ArrayList<CodeableConcept>();
            }
            this.securityLabel.add(t);
            return this;
        }

        public CodeableConcept getSecurityLabelFirstRep() {
            if (this.getSecurityLabel().isEmpty()) {
                this.addSecurityLabel();
            }
            return this.getSecurityLabel().get(0);
        }

        public Base64BinaryType getQueryElement() {
            if (this.query == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventEntityComponent.query");
                }
                if (Configuration.doAutoCreate()) {
                    this.query = new Base64BinaryType();
                }
            }
            return this.query;
        }

        public boolean hasQueryElement() {
            return this.query != null && !this.query.isEmpty();
        }

        public boolean hasQuery() {
            return this.query != null && !this.query.isEmpty();
        }

        public AuditEventEntityComponent setQueryElement(Base64BinaryType value) {
            this.query = value;
            return this;
        }

        public byte[] getQuery() {
            return this.query == null ? null : this.query.getValue();
        }

        public AuditEventEntityComponent setQuery(byte[] value) {
            if (value == null) {
                this.query = null;
            } else {
                if (this.query == null) {
                    this.query = new Base64BinaryType();
                }
                this.query.setValue(value);
            }
            return this;
        }

        public List<AuditEventEntityDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<AuditEventEntityDetailComponent>();
            }
            return this.detail;
        }

        public AuditEventEntityComponent setDetail(List<AuditEventEntityDetailComponent> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (AuditEventEntityDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AuditEventEntityDetailComponent addDetail() {
            AuditEventEntityDetailComponent t = new AuditEventEntityDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<AuditEventEntityDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public AuditEventEntityComponent addDetail(AuditEventEntityDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<AuditEventEntityDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        public AuditEventEntityDetailComponent getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        public List<AuditEventAgentComponent> getAgent() {
            if (this.agent == null) {
                this.agent = new ArrayList<AuditEventAgentComponent>();
            }
            return this.agent;
        }

        public AuditEventEntityComponent setAgent(List<AuditEventAgentComponent> theAgent) {
            this.agent = theAgent;
            return this;
        }

        public boolean hasAgent() {
            if (this.agent == null) {
                return false;
            }
            for (AuditEventAgentComponent item : this.agent) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AuditEventAgentComponent addAgent() {
            AuditEventAgentComponent t = new AuditEventAgentComponent();
            if (this.agent == null) {
                this.agent = new ArrayList<AuditEventAgentComponent>();
            }
            this.agent.add(t);
            return t;
        }

        public AuditEventEntityComponent addAgent(AuditEventAgentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.agent == null) {
                this.agent = new ArrayList<AuditEventAgentComponent>();
            }
            this.agent.add(t);
            return this;
        }

        public AuditEventAgentComponent getAgentFirstRep() {
            if (this.getAgent().isEmpty()) {
                this.addAgent();
            }
            return this.getAgent().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("what", "Reference(Any)", "Identifies a specific instance of the entity. The reference should be version specific. This is allowed to be a Parameters resource.", 0, 1, this.what));
            children.add(new Property("role", "CodeableConcept", "Code representing the role the entity played in the event being audited.", 0, 1, this.role));
            children.add(new Property("securityLabel", "CodeableConcept", "Security labels for the identified entity.", 0, Integer.MAX_VALUE, this.securityLabel));
            children.add(new Property("query", "base64Binary", "The query parameters for a query-type entities.", 0, 1, this.query));
            children.add(new Property("detail", "", "Tagged value pairs for conveying additional information about the entity.", 0, Integer.MAX_VALUE, this.detail));
            children.add(new Property(AuditEvent.SP_AGENT, "@AuditEvent.agent", "The entity is attributed to an agent to express the agent's responsibility for that entity in the activity. This is most used to indicate when persistence media (the entity) are used by an agent. For example when importing data from a device, the device would be described in an entity, and the user importing data from that media would be indicated as the entity.agent.", 0, Integer.MAX_VALUE, this.agent));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3648196: {
                    return new Property("what", "Reference(Any)", "Identifies a specific instance of the entity. The reference should be version specific. This is allowed to be a Parameters resource.", 0, 1, this.what);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Code representing the role the entity played in the event being audited.", 0, 1, this.role);
                }
                case -722296940: {
                    return new Property("securityLabel", "CodeableConcept", "Security labels for the identified entity.", 0, Integer.MAX_VALUE, this.securityLabel);
                }
                case 107944136: {
                    return new Property("query", "base64Binary", "The query parameters for a query-type entities.", 0, 1, this.query);
                }
                case -1335224239: {
                    return new Property("detail", "", "Tagged value pairs for conveying additional information about the entity.", 0, Integer.MAX_VALUE, this.detail);
                }
                case 92750597: {
                    return new Property(AuditEvent.SP_AGENT, "@AuditEvent.agent", "The entity is attributed to an agent to express the agent's responsibility for that entity in the activity. This is most used to indicate when persistence media (the entity) are used by an agent. For example when importing data from a device, the device would be described in an entity, and the user importing data from that media would be indicated as the entity.agent.", 0, Integer.MAX_VALUE, this.agent);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3648196: {
                    Base[] baseArray;
                    if (this.what == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.what;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
                case -722296940: {
                    return this.securityLabel == null ? new Base[]{} : this.securityLabel.toArray(new Base[this.securityLabel.size()]);
                }
                case 107944136: {
                    Base[] baseArray;
                    if (this.query == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.query;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
                case 92750597: {
                    return this.agent == null ? new Base[]{} : this.agent.toArray(new Base[this.agent.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3648196: {
                    this.what = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3506294: {
                    this.role = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -722296940: {
                    this.getSecurityLabel().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 107944136: {
                    this.query = TypeConvertor.castToBase64Binary(value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add((AuditEventEntityDetailComponent)value);
                    return value;
                }
                case 92750597: {
                    this.getAgent().add((AuditEventAgentComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("what")) {
                this.what = TypeConvertor.castToReference(value);
            } else if (name.equals("role")) {
                this.role = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("securityLabel")) {
                this.getSecurityLabel().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("query")) {
                this.query = TypeConvertor.castToBase64Binary(value);
            } else if (name.equals("detail")) {
                this.getDetail().add((AuditEventEntityDetailComponent)value);
            } else if (name.equals(AuditEvent.SP_AGENT)) {
                this.getAgent().add((AuditEventAgentComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3648196: {
                    return this.getWhat();
                }
                case 3506294: {
                    return this.getRole();
                }
                case -722296940: {
                    return this.addSecurityLabel();
                }
                case 107944136: {
                    return this.getQueryElement();
                }
                case -1335224239: {
                    return this.addDetail();
                }
                case 92750597: {
                    return this.addAgent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3648196: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case -722296940: {
                    return new String[]{"CodeableConcept"};
                }
                case 107944136: {
                    return new String[]{"base64Binary"};
                }
                case -1335224239: {
                    return new String[0];
                }
                case 92750597: {
                    return new String[]{"@AuditEvent.agent"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("what")) {
                this.what = new Reference();
                return this.what;
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("securityLabel")) {
                return this.addSecurityLabel();
            }
            if (name.equals("query")) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.entity.query");
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            if (name.equals(AuditEvent.SP_AGENT)) {
                return this.addAgent();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventEntityComponent copy() {
            AuditEventEntityComponent dst = new AuditEventEntityComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AuditEventEntityComponent dst) {
            super.copyValues(dst);
            dst.what = this.what == null ? null : this.what.copy();
            CodeableConcept codeableConcept = dst.role = this.role == null ? null : this.role.copy();
            if (this.securityLabel != null) {
                dst.securityLabel = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.securityLabel) {
                    dst.securityLabel.add(codeableConcept2.copy());
                }
            }
            Base64BinaryType base64BinaryType = dst.query = this.query == null ? null : this.query.copy();
            if (this.detail != null) {
                dst.detail = new ArrayList<AuditEventEntityDetailComponent>();
                for (AuditEventEntityDetailComponent auditEventEntityDetailComponent : this.detail) {
                    dst.detail.add(auditEventEntityDetailComponent.copy());
                }
            }
            if (this.agent != null) {
                dst.agent = new ArrayList<AuditEventAgentComponent>();
                for (AuditEventAgentComponent auditEventAgentComponent : this.agent) {
                    dst.agent.add(auditEventAgentComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventEntityComponent)) {
                return false;
            }
            AuditEventEntityComponent o = (AuditEventEntityComponent)other_;
            return AuditEventEntityComponent.compareDeep(this.what, o.what, true) && AuditEventEntityComponent.compareDeep(this.role, o.role, true) && AuditEventEntityComponent.compareDeep(this.securityLabel, o.securityLabel, true) && AuditEventEntityComponent.compareDeep(this.query, o.query, true) && AuditEventEntityComponent.compareDeep(this.detail, o.detail, true) && AuditEventEntityComponent.compareDeep(this.agent, o.agent, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventEntityComponent)) {
                return false;
            }
            AuditEventEntityComponent o = (AuditEventEntityComponent)other_;
            return AuditEventEntityComponent.compareValues(this.query, o.query, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.what, this.role, this.securityLabel, this.query, this.detail, this.agent);
        }

        @Override
        public String fhirType() {
            return "AuditEvent.entity";
        }
    }

    @Block
    public static class AuditEventSourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="site", type={Location.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Logical source location within the enterprise", formalDefinition="Logical source location within the healthcare enterprise network.  For example, a hospital or other provider location within a multi-entity provider group.")
        protected Reference site;
        @Child(name="observer", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, Patient.class, Device.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The identity of source detecting the event", formalDefinition="Identifier of the source where the event was detected.")
        protected Reference observer;
        @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The type of source where event originated", formalDefinition="Code specifying the type of source where event originated.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-source-type")
        protected List<CodeableConcept> type;
        private static final long serialVersionUID = -140005578L;

        public AuditEventSourceComponent() {
        }

        public AuditEventSourceComponent(Reference observer) {
            this.setObserver(observer);
        }

        public Reference getSite() {
            if (this.site == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventSourceComponent.site");
                }
                if (Configuration.doAutoCreate()) {
                    this.site = new Reference();
                }
            }
            return this.site;
        }

        public boolean hasSite() {
            return this.site != null && !this.site.isEmpty();
        }

        public AuditEventSourceComponent setSite(Reference value) {
            this.site = value;
            return this;
        }

        public Reference getObserver() {
            if (this.observer == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventSourceComponent.observer");
                }
                if (Configuration.doAutoCreate()) {
                    this.observer = new Reference();
                }
            }
            return this.observer;
        }

        public boolean hasObserver() {
            return this.observer != null && !this.observer.isEmpty();
        }

        public AuditEventSourceComponent setObserver(Reference value) {
            this.observer = value;
            return this;
        }

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public AuditEventSourceComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public AuditEventSourceComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("site", "Reference(Location)", "Logical source location within the healthcare enterprise network.  For example, a hospital or other provider location within a multi-entity provider group.", 0, 1, this.site));
            children.add(new Property("observer", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson)", "Identifier of the source where the event was detected.", 0, 1, this.observer));
            children.add(new Property("type", "CodeableConcept", "Code specifying the type of source where event originated.", 0, Integer.MAX_VALUE, this.type));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3530567: {
                    return new Property("site", "Reference(Location)", "Logical source location within the healthcare enterprise network.  For example, a hospital or other provider location within a multi-entity provider group.", 0, 1, this.site);
                }
                case 348607190: {
                    return new Property("observer", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson)", "Identifier of the source where the event was detected.", 0, 1, this.observer);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Code specifying the type of source where event originated.", 0, Integer.MAX_VALUE, this.type);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    Base[] baseArray;
                    if (this.site == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.site;
                    }
                    return baseArray;
                }
                case 348607190: {
                    Base[] baseArray;
                    if (this.observer == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.observer;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    this.site = TypeConvertor.castToReference(value);
                    return value;
                }
                case 348607190: {
                    this.observer = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("site")) {
                this.site = TypeConvertor.castToReference(value);
            } else if (name.equals("observer")) {
                this.observer = TypeConvertor.castToReference(value);
            } else if (name.equals("type")) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    return this.getSite();
                }
                case 348607190: {
                    return this.getObserver();
                }
                case 3575610: {
                    return this.addType();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3530567: {
                    return new String[]{"Reference"};
                }
                case 348607190: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("site")) {
                this.site = new Reference();
                return this.site;
            }
            if (name.equals("observer")) {
                this.observer = new Reference();
                return this.observer;
            }
            if (name.equals("type")) {
                return this.addType();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventSourceComponent copy() {
            AuditEventSourceComponent dst = new AuditEventSourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AuditEventSourceComponent dst) {
            super.copyValues(dst);
            dst.site = this.site == null ? null : this.site.copy();
            Reference reference = dst.observer = this.observer == null ? null : this.observer.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.type) {
                    dst.type.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventSourceComponent)) {
                return false;
            }
            AuditEventSourceComponent o = (AuditEventSourceComponent)other_;
            return AuditEventSourceComponent.compareDeep(this.site, o.site, true) && AuditEventSourceComponent.compareDeep(this.observer, o.observer, true) && AuditEventSourceComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventSourceComponent)) {
                return false;
            }
            AuditEventSourceComponent o = (AuditEventSourceComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.site, this.observer, this.type);
        }

        @Override
        public String fhirType() {
            return "AuditEvent.source";
        }
    }

    @Block
    public static class AuditEventAgentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How agent participated", formalDefinition="The Functional Role of the user when performing the event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participation-role-type")
        protected CodeableConcept type;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Agent role in the event", formalDefinition="The structural roles of the agent indicating the agent's competency. The security role enabling the agent with respect to the activity.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/security-role-type")
        protected List<CodeableConcept> role;
        @Child(name="who", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, Patient.class, Device.class, RelatedPerson.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Identifier of who", formalDefinition="Reference to who this agent is that was involved in the event.")
        protected Reference who;
        @Child(name="requestor", type={BooleanType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Whether user is initiator", formalDefinition="Indicator that the user is or is not the requestor, or initiator, for the event being audited.")
        protected BooleanType requestor;
        @Child(name="location", type={Location.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The agent location when the event occurred", formalDefinition="Where the agent location is known, the agent location when the event occurred.")
        protected Reference location;
        @Child(name="policy", type={UriType.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Policy that authorized the agent participation in the event", formalDefinition="Where the policy(ies) are known that authorized the agent participation in the event. Typically, a single activity may have multiple applicable policies, such as patient consent, guarantor funding, etc. The policy would also indicate the security token used.")
        protected List<UriType> policy;
        @Child(name="network", type={Endpoint.class, UriType.class, StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="This agent network location for the activity", formalDefinition="When the event utilizes a network there should be an agent describing the local system, and an agent describing remote system, with the network interface details.")
        protected DataType network;
        @Child(name="authorization", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Allowable authorization for this agent", formalDefinition="The authorization (e.g., PurposeOfUse) that was used during the event being recorded.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-PurposeOfUse")
        protected List<CodeableConcept> authorization;
        private static final long serialVersionUID = 509129255L;

        public AuditEventAgentComponent() {
        }

        public AuditEventAgentComponent(Reference who) {
            this.setWho(who);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public AuditEventAgentComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public List<CodeableConcept> getRole() {
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            return this.role;
        }

        public AuditEventAgentComponent setRole(List<CodeableConcept> theRole) {
            this.role = theRole;
            return this;
        }

        public boolean hasRole() {
            if (this.role == null) {
                return false;
            }
            for (CodeableConcept item : this.role) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRole() {
            CodeableConcept t = new CodeableConcept();
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return t;
        }

        public AuditEventAgentComponent addRole(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return this;
        }

        public CodeableConcept getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                this.addRole();
            }
            return this.getRole().get(0);
        }

        public Reference getWho() {
            if (this.who == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.who");
                }
                if (Configuration.doAutoCreate()) {
                    this.who = new Reference();
                }
            }
            return this.who;
        }

        public boolean hasWho() {
            return this.who != null && !this.who.isEmpty();
        }

        public AuditEventAgentComponent setWho(Reference value) {
            this.who = value;
            return this;
        }

        public BooleanType getRequestorElement() {
            if (this.requestor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.requestor");
                }
                if (Configuration.doAutoCreate()) {
                    this.requestor = new BooleanType();
                }
            }
            return this.requestor;
        }

        public boolean hasRequestorElement() {
            return this.requestor != null && !this.requestor.isEmpty();
        }

        public boolean hasRequestor() {
            return this.requestor != null && !this.requestor.isEmpty();
        }

        public AuditEventAgentComponent setRequestorElement(BooleanType value) {
            this.requestor = value;
            return this;
        }

        public boolean getRequestor() {
            return this.requestor == null || this.requestor.isEmpty() ? false : (Boolean)this.requestor.getValue();
        }

        public AuditEventAgentComponent setRequestor(boolean value) {
            if (this.requestor == null) {
                this.requestor = new BooleanType();
            }
            this.requestor.setValue((Object)value);
            return this;
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventAgentComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public AuditEventAgentComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public List<UriType> getPolicy() {
            if (this.policy == null) {
                this.policy = new ArrayList<UriType>();
            }
            return this.policy;
        }

        public AuditEventAgentComponent setPolicy(List<UriType> thePolicy) {
            this.policy = thePolicy;
            return this;
        }

        public boolean hasPolicy() {
            if (this.policy == null) {
                return false;
            }
            for (UriType item : this.policy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public UriType addPolicyElement() {
            UriType t = new UriType();
            if (this.policy == null) {
                this.policy = new ArrayList<UriType>();
            }
            this.policy.add(t);
            return t;
        }

        public AuditEventAgentComponent addPolicy(String value) {
            UriType t = new UriType();
            t.setValue(value);
            if (this.policy == null) {
                this.policy = new ArrayList<UriType>();
            }
            this.policy.add(t);
            return this;
        }

        public boolean hasPolicy(String value) {
            if (this.policy == null) {
                return false;
            }
            for (UriType v : this.policy) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public DataType getNetwork() {
            return this.network;
        }

        public Reference getNetworkReference() throws FHIRException {
            if (this.network == null) {
                this.network = new Reference();
            }
            if (!(this.network instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.network.getClass().getName() + " was encountered");
            }
            return (Reference)this.network;
        }

        public boolean hasNetworkReference() {
            return this != null && this.network instanceof Reference;
        }

        public UriType getNetworkUriType() throws FHIRException {
            if (this.network == null) {
                this.network = new UriType();
            }
            if (!(this.network instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.network.getClass().getName() + " was encountered");
            }
            return (UriType)this.network;
        }

        public boolean hasNetworkUriType() {
            return this != null && this.network instanceof UriType;
        }

        public StringType getNetworkStringType() throws FHIRException {
            if (this.network == null) {
                this.network = new StringType();
            }
            if (!(this.network instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.network.getClass().getName() + " was encountered");
            }
            return (StringType)this.network;
        }

        public boolean hasNetworkStringType() {
            return this != null && this.network instanceof StringType;
        }

        public boolean hasNetwork() {
            return this.network != null && !this.network.isEmpty();
        }

        public AuditEventAgentComponent setNetwork(DataType value) {
            if (!(value == null || value instanceof Reference || value instanceof UriType || value instanceof StringType)) {
                throw new Error("Not the right type for AuditEvent.agent.network[x]: " + value.fhirType());
            }
            this.network = value;
            return this;
        }

        public List<CodeableConcept> getAuthorization() {
            if (this.authorization == null) {
                this.authorization = new ArrayList<CodeableConcept>();
            }
            return this.authorization;
        }

        public AuditEventAgentComponent setAuthorization(List<CodeableConcept> theAuthorization) {
            this.authorization = theAuthorization;
            return this;
        }

        public boolean hasAuthorization() {
            if (this.authorization == null) {
                return false;
            }
            for (CodeableConcept item : this.authorization) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAuthorization() {
            CodeableConcept t = new CodeableConcept();
            if (this.authorization == null) {
                this.authorization = new ArrayList<CodeableConcept>();
            }
            this.authorization.add(t);
            return t;
        }

        public AuditEventAgentComponent addAuthorization(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.authorization == null) {
                this.authorization = new ArrayList<CodeableConcept>();
            }
            this.authorization.add(t);
            return this;
        }

        public CodeableConcept getAuthorizationFirstRep() {
            if (this.getAuthorization().isEmpty()) {
                this.addAuthorization();
            }
            return this.getAuthorization().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The Functional Role of the user when performing the event.", 0, 1, this.type));
            children.add(new Property("role", "CodeableConcept", "The structural roles of the agent indicating the agent's competency. The security role enabling the agent with respect to the activity.", 0, Integer.MAX_VALUE, this.role));
            children.add(new Property("who", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson)", "Reference to who this agent is that was involved in the event.", 0, 1, this.who));
            children.add(new Property("requestor", "boolean", "Indicator that the user is or is not the requestor, or initiator, for the event being audited.", 0, 1, this.requestor));
            children.add(new Property("location", "Reference(Location)", "Where the agent location is known, the agent location when the event occurred.", 0, 1, this.location));
            children.add(new Property(AuditEvent.SP_POLICY, "uri", "Where the policy(ies) are known that authorized the agent participation in the event. Typically, a single activity may have multiple applicable policies, such as patient consent, guarantor funding, etc. The policy would also indicate the security token used.", 0, Integer.MAX_VALUE, this.policy));
            children.add(new Property("network[x]", "Reference(Endpoint)|uri|string", "When the event utilizes a network there should be an agent describing the local system, and an agent describing remote system, with the network interface details.", 0, 1, this.network));
            children.add(new Property("authorization", "CodeableConcept", "The authorization (e.g., PurposeOfUse) that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.authorization));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The Functional Role of the user when performing the event.", 0, 1, this.type);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "The structural roles of the agent indicating the agent's competency. The security role enabling the agent with respect to the activity.", 0, Integer.MAX_VALUE, this.role);
                }
                case 117694: {
                    return new Property("who", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson)", "Reference to who this agent is that was involved in the event.", 0, 1, this.who);
                }
                case 693934258: {
                    return new Property("requestor", "boolean", "Indicator that the user is or is not the requestor, or initiator, for the event being audited.", 0, 1, this.requestor);
                }
                case 1901043637: {
                    return new Property("location", "Reference(Location)", "Where the agent location is known, the agent location when the event occurred.", 0, 1, this.location);
                }
                case -982670030: {
                    return new Property(AuditEvent.SP_POLICY, "uri", "Where the policy(ies) are known that authorized the agent participation in the event. Typically, a single activity may have multiple applicable policies, such as patient consent, guarantor funding, etc. The policy would also indicate the security token used.", 0, Integer.MAX_VALUE, this.policy);
                }
                case -478235758: {
                    return new Property("network[x]", "Reference(Endpoint)|uri|string", "When the event utilizes a network there should be an agent describing the local system, and an agent describing remote system, with the network interface details.", 0, 1, this.network);
                }
                case 1843485230: {
                    return new Property("network[x]", "Reference(Endpoint)|uri|string", "When the event utilizes a network there should be an agent describing the local system, and an agent describing remote system, with the network interface details.", 0, 1, this.network);
                }
                case -1769760579: {
                    return new Property("network[x]", "Reference(Endpoint)", "When the event utilizes a network there should be an agent describing the local system, and an agent describing remote system, with the network interface details.", 0, 1, this.network);
                }
                case -478241698: {
                    return new Property("network[x]", "uri", "When the event utilizes a network there should be an agent describing the local system, and an agent describing remote system, with the network interface details.", 0, 1, this.network);
                }
                case -946943009: {
                    return new Property("network[x]", "string", "When the event utilizes a network there should be an agent describing the local system, and an agent describing remote system, with the network interface details.", 0, 1, this.network);
                }
                case -1385570183: {
                    return new Property("authorization", "CodeableConcept", "The authorization (e.g., PurposeOfUse) that was used during the event being recorded.", 0, Integer.MAX_VALUE, this.authorization);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3506294: {
                    return this.role == null ? new Base[]{} : this.role.toArray(new Base[this.role.size()]);
                }
                case 117694: {
                    Base[] baseArray;
                    if (this.who == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.who;
                    }
                    return baseArray;
                }
                case 693934258: {
                    Base[] baseArray;
                    if (this.requestor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.requestor;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.location;
                    }
                    return baseArray;
                }
                case -982670030: {
                    return this.policy == null ? new Base[]{} : this.policy.toArray(new Base[this.policy.size()]);
                }
                case 1843485230: {
                    Base[] baseArray;
                    if (this.network == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.network;
                    }
                    return baseArray;
                }
                case -1385570183: {
                    return this.authorization == null ? new Base[]{} : this.authorization.toArray(new Base[this.authorization.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3506294: {
                    this.getRole().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 117694: {
                    this.who = TypeConvertor.castToReference(value);
                    return value;
                }
                case 693934258: {
                    this.requestor = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 1901043637: {
                    this.location = TypeConvertor.castToReference(value);
                    return value;
                }
                case -982670030: {
                    this.getPolicy().add(TypeConvertor.castToUri(value));
                    return value;
                }
                case 1843485230: {
                    this.network = TypeConvertor.castToType(value);
                    return value;
                }
                case -1385570183: {
                    this.getAuthorization().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("role")) {
                this.getRole().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("who")) {
                this.who = TypeConvertor.castToReference(value);
            } else if (name.equals("requestor")) {
                this.requestor = TypeConvertor.castToBoolean(value);
            } else if (name.equals("location")) {
                this.location = TypeConvertor.castToReference(value);
            } else if (name.equals(AuditEvent.SP_POLICY)) {
                this.getPolicy().add(TypeConvertor.castToUri(value));
            } else if (name.equals("network[x]")) {
                this.network = TypeConvertor.castToType(value);
            } else if (name.equals("authorization")) {
                this.getAuthorization().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case 3506294: {
                    return this.addRole();
                }
                case 117694: {
                    return this.getWho();
                }
                case 693934258: {
                    return this.getRequestorElement();
                }
                case 1901043637: {
                    return this.getLocation();
                }
                case -982670030: {
                    return this.addPolicyElement();
                }
                case -478235758: {
                    return this.getNetwork();
                }
                case 1843485230: {
                    return this.getNetwork();
                }
                case -1385570183: {
                    return this.addAuthorization();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 117694: {
                    return new String[]{"Reference"};
                }
                case 693934258: {
                    return new String[]{"boolean"};
                }
                case 1901043637: {
                    return new String[]{"Reference"};
                }
                case -982670030: {
                    return new String[]{"uri"};
                }
                case 1843485230: {
                    return new String[]{"Reference", "uri", "string"};
                }
                case -1385570183: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("role")) {
                return this.addRole();
            }
            if (name.equals("who")) {
                this.who = new Reference();
                return this.who;
            }
            if (name.equals("requestor")) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.agent.requestor");
            }
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals(AuditEvent.SP_POLICY)) {
                throw new FHIRException("Cannot call addChild on a primitive type AuditEvent.agent.policy");
            }
            if (name.equals("networkReference")) {
                this.network = new Reference();
                return this.network;
            }
            if (name.equals("networkUri")) {
                this.network = new UriType();
                return this.network;
            }
            if (name.equals("networkString")) {
                this.network = new StringType();
                return this.network;
            }
            if (name.equals("authorization")) {
                return this.addAuthorization();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventAgentComponent copy() {
            AuditEventAgentComponent dst = new AuditEventAgentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AuditEventAgentComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
            if (this.role != null) {
                dst.role = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept2 : this.role) {
                    dst.role.add(codeableConcept2.copy());
                }
            }
            dst.who = this.who == null ? null : this.who.copy();
            dst.requestor = this.requestor == null ? null : this.requestor.copy();
            Reference reference = dst.location = this.location == null ? null : this.location.copy();
            if (this.policy != null) {
                dst.policy = new ArrayList<UriType>();
                for (UriType uriType : this.policy) {
                    dst.policy.add(uriType.copy());
                }
            }
            DataType dataType = dst.network = this.network == null ? null : this.network.copy();
            if (this.authorization != null) {
                dst.authorization = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept3 : this.authorization) {
                    dst.authorization.add(codeableConcept3.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventAgentComponent)) {
                return false;
            }
            AuditEventAgentComponent o = (AuditEventAgentComponent)other_;
            return AuditEventAgentComponent.compareDeep(this.type, o.type, true) && AuditEventAgentComponent.compareDeep(this.role, o.role, true) && AuditEventAgentComponent.compareDeep(this.who, o.who, true) && AuditEventAgentComponent.compareDeep(this.requestor, o.requestor, true) && AuditEventAgentComponent.compareDeep(this.location, o.location, true) && AuditEventAgentComponent.compareDeep(this.policy, o.policy, true) && AuditEventAgentComponent.compareDeep(this.network, o.network, true) && AuditEventAgentComponent.compareDeep(this.authorization, o.authorization, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventAgentComponent)) {
                return false;
            }
            AuditEventAgentComponent o = (AuditEventAgentComponent)other_;
            return AuditEventAgentComponent.compareValues(this.requestor, o.requestor, true) && AuditEventAgentComponent.compareValues(this.policy, o.policy, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.role, this.who, this.requestor, this.location, this.policy, this.network, this.authorization);
        }

        @Override
        public String fhirType() {
            return "AuditEvent.agent";
        }
    }

    @Block
    public static class AuditEventOutcomeComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Whether the event succeeded or failed", formalDefinition="Indicates whether the event succeeded or failed.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-outcome")
        protected Coding code;
        @Child(name="detail", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Additional outcome detail", formalDefinition="Additional details about the error. This may be a text description of the error or a system code that identifies the error.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/audit-event-outcome-detail")
        protected List<CodeableConcept> detail;
        private static final long serialVersionUID = -1108329559L;

        public AuditEventOutcomeComponent() {
        }

        public AuditEventOutcomeComponent(Coding code) {
            this.setCode(code);
        }

        public Coding getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AuditEventOutcomeComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Coding();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public AuditEventOutcomeComponent setCode(Coding value) {
            this.code = value;
            return this;
        }

        public List<CodeableConcept> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<CodeableConcept>();
            }
            return this.detail;
        }

        public AuditEventOutcomeComponent setDetail(List<CodeableConcept> theDetail) {
            this.detail = theDetail;
            return this;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (CodeableConcept item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addDetail() {
            CodeableConcept t = new CodeableConcept();
            if (this.detail == null) {
                this.detail = new ArrayList<CodeableConcept>();
            }
            this.detail.add(t);
            return t;
        }

        public AuditEventOutcomeComponent addDetail(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<CodeableConcept>();
            }
            this.detail.add(t);
            return this;
        }

        public CodeableConcept getDetailFirstRep() {
            if (this.getDetail().isEmpty()) {
                this.addDetail();
            }
            return this.getDetail().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(AuditEvent.SP_CODE, "Coding", "Indicates whether the event succeeded or failed.", 0, 1, this.code));
            children.add(new Property("detail", "CodeableConcept", "Additional details about the error. This may be a text description of the error or a system code that identifies the error.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property(AuditEvent.SP_CODE, "Coding", "Indicates whether the event succeeded or failed.", 0, 1, this.code);
                }
                case -1335224239: {
                    return new Property("detail", "CodeableConcept", "Additional details about the error. This may be a text description of the error or a system code that identifies the error.", 0, Integer.MAX_VALUE, this.detail);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1335224239: {
                    return this.detail == null ? new Base[]{} : this.detail.toArray(new Base[this.detail.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -1335224239: {
                    this.getDetail().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(AuditEvent.SP_CODE)) {
                this.code = TypeConvertor.castToCoding(value);
            } else if (name.equals("detail")) {
                this.getDetail().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -1335224239: {
                    return this.addDetail();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"Coding"};
                }
                case -1335224239: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(AuditEvent.SP_CODE)) {
                this.code = new Coding();
                return this.code;
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AuditEventOutcomeComponent copy() {
            AuditEventOutcomeComponent dst = new AuditEventOutcomeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AuditEventOutcomeComponent dst) {
            super.copyValues(dst);
            Coding coding = dst.code = this.code == null ? null : this.code.copy();
            if (this.detail != null) {
                dst.detail = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.detail) {
                    dst.detail.add(i2.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventOutcomeComponent)) {
                return false;
            }
            AuditEventOutcomeComponent o = (AuditEventOutcomeComponent)other_;
            return AuditEventOutcomeComponent.compareDeep(this.code, o.code, true) && AuditEventOutcomeComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AuditEventOutcomeComponent)) {
                return false;
            }
            AuditEventOutcomeComponent o = (AuditEventOutcomeComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.detail);
        }

        @Override
        public String fhirType() {
            return "AuditEvent.outcome";
        }
    }

    public static class AuditEventSeverityEnumFactory
    implements EnumFactory<AuditEventSeverity> {
        @Override
        public AuditEventSeverity fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("emergency".equals(codeString)) {
                return AuditEventSeverity.EMERGENCY;
            }
            if ("alert".equals(codeString)) {
                return AuditEventSeverity.ALERT;
            }
            if ("critical".equals(codeString)) {
                return AuditEventSeverity.CRITICAL;
            }
            if ("error".equals(codeString)) {
                return AuditEventSeverity.ERROR;
            }
            if ("warning".equals(codeString)) {
                return AuditEventSeverity.WARNING;
            }
            if ("notice".equals(codeString)) {
                return AuditEventSeverity.NOTICE;
            }
            if ("informational".equals(codeString)) {
                return AuditEventSeverity.INFORMATIONAL;
            }
            if ("debug".equals(codeString)) {
                return AuditEventSeverity.DEBUG;
            }
            throw new IllegalArgumentException("Unknown AuditEventSeverity code '" + codeString + "'");
        }

        public Enumeration<AuditEventSeverity> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AuditEventSeverity>(this, AuditEventSeverity.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AuditEventSeverity>(this, AuditEventSeverity.NULL, code);
            }
            if ("emergency".equals(codeString)) {
                return new Enumeration<AuditEventSeverity>(this, AuditEventSeverity.EMERGENCY, code);
            }
            if ("alert".equals(codeString)) {
                return new Enumeration<AuditEventSeverity>(this, AuditEventSeverity.ALERT, code);
            }
            if ("critical".equals(codeString)) {
                return new Enumeration<AuditEventSeverity>(this, AuditEventSeverity.CRITICAL, code);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<AuditEventSeverity>(this, AuditEventSeverity.ERROR, code);
            }
            if ("warning".equals(codeString)) {
                return new Enumeration<AuditEventSeverity>(this, AuditEventSeverity.WARNING, code);
            }
            if ("notice".equals(codeString)) {
                return new Enumeration<AuditEventSeverity>(this, AuditEventSeverity.NOTICE, code);
            }
            if ("informational".equals(codeString)) {
                return new Enumeration<AuditEventSeverity>(this, AuditEventSeverity.INFORMATIONAL, code);
            }
            if ("debug".equals(codeString)) {
                return new Enumeration<AuditEventSeverity>(this, AuditEventSeverity.DEBUG, code);
            }
            throw new FHIRException("Unknown AuditEventSeverity code '" + codeString + "'");
        }

        @Override
        public String toCode(AuditEventSeverity code) {
            if (code == AuditEventSeverity.EMERGENCY) {
                return "emergency";
            }
            if (code == AuditEventSeverity.ALERT) {
                return "alert";
            }
            if (code == AuditEventSeverity.CRITICAL) {
                return "critical";
            }
            if (code == AuditEventSeverity.ERROR) {
                return "error";
            }
            if (code == AuditEventSeverity.WARNING) {
                return "warning";
            }
            if (code == AuditEventSeverity.NOTICE) {
                return "notice";
            }
            if (code == AuditEventSeverity.INFORMATIONAL) {
                return "informational";
            }
            if (code == AuditEventSeverity.DEBUG) {
                return "debug";
            }
            return "?";
        }

        @Override
        public String toSystem(AuditEventSeverity code) {
            return code.getSystem();
        }
    }

    public static enum AuditEventSeverity {
        EMERGENCY,
        ALERT,
        CRITICAL,
        ERROR,
        WARNING,
        NOTICE,
        INFORMATIONAL,
        DEBUG,
        NULL;


        public static AuditEventSeverity fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("emergency".equals(codeString)) {
                return EMERGENCY;
            }
            if ("alert".equals(codeString)) {
                return ALERT;
            }
            if ("critical".equals(codeString)) {
                return CRITICAL;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("warning".equals(codeString)) {
                return WARNING;
            }
            if ("notice".equals(codeString)) {
                return NOTICE;
            }
            if ("informational".equals(codeString)) {
                return INFORMATIONAL;
            }
            if ("debug".equals(codeString)) {
                return DEBUG;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AuditEventSeverity code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EMERGENCY: {
                    return "emergency";
                }
                case ALERT: {
                    return "alert";
                }
                case CRITICAL: {
                    return "critical";
                }
                case ERROR: {
                    return "error";
                }
                case WARNING: {
                    return "warning";
                }
                case NOTICE: {
                    return "notice";
                }
                case INFORMATIONAL: {
                    return "informational";
                }
                case DEBUG: {
                    return "debug";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EMERGENCY: {
                    return "http://hl7.org/fhir/audit-event-severity";
                }
                case ALERT: {
                    return "http://hl7.org/fhir/audit-event-severity";
                }
                case CRITICAL: {
                    return "http://hl7.org/fhir/audit-event-severity";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/audit-event-severity";
                }
                case WARNING: {
                    return "http://hl7.org/fhir/audit-event-severity";
                }
                case NOTICE: {
                    return "http://hl7.org/fhir/audit-event-severity";
                }
                case INFORMATIONAL: {
                    return "http://hl7.org/fhir/audit-event-severity";
                }
                case DEBUG: {
                    return "http://hl7.org/fhir/audit-event-severity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EMERGENCY: {
                    return "System is unusable. e.g., This level should only be reported by infrastructure and should not be used by applications.";
                }
                case ALERT: {
                    return "Notification should be sent to trigger action be taken. e.g., Loss of the primary network connection needing attention.";
                }
                case CRITICAL: {
                    return "Critical conditions. e.g., A failure in the system's primary application that will reset automatically.";
                }
                case ERROR: {
                    return "Error conditions. e.g., An application has exceeded its file storage limit and attempts to write are failing. ";
                }
                case WARNING: {
                    return "Warning conditions. May indicate that an error will occur if action is not taken. e.g., A non-root file system has only 2GB remaining.";
                }
                case NOTICE: {
                    return "Notice messages. Normal but significant condition. Events that are unusual, but not error conditions.";
                }
                case INFORMATIONAL: {
                    return "Normal operational messages that require no action. e.g., An application has started, paused, or ended successfully.";
                }
                case DEBUG: {
                    return "Debug-level messages. Information useful to developers for debugging the application.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EMERGENCY: {
                    return "Emergency";
                }
                case ALERT: {
                    return "Alert";
                }
                case CRITICAL: {
                    return "Critical";
                }
                case ERROR: {
                    return "Error";
                }
                case WARNING: {
                    return "Warning";
                }
                case NOTICE: {
                    return "Notice";
                }
                case INFORMATIONAL: {
                    return "Informational";
                }
                case DEBUG: {
                    return "Debug";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AuditEventActionEnumFactory
    implements EnumFactory<AuditEventAction> {
        @Override
        public AuditEventAction fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("C".equals(codeString)) {
                return AuditEventAction.C;
            }
            if ("R".equals(codeString)) {
                return AuditEventAction.R;
            }
            if ("U".equals(codeString)) {
                return AuditEventAction.U;
            }
            if ("D".equals(codeString)) {
                return AuditEventAction.D;
            }
            if ("E".equals(codeString)) {
                return AuditEventAction.E;
            }
            throw new IllegalArgumentException("Unknown AuditEventAction code '" + codeString + "'");
        }

        public Enumeration<AuditEventAction> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.NULL, code);
            }
            if ("C".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.C, code);
            }
            if ("R".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.R, code);
            }
            if ("U".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.U, code);
            }
            if ("D".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.D, code);
            }
            if ("E".equals(codeString)) {
                return new Enumeration<AuditEventAction>(this, AuditEventAction.E, code);
            }
            throw new FHIRException("Unknown AuditEventAction code '" + codeString + "'");
        }

        @Override
        public String toCode(AuditEventAction code) {
            if (code == AuditEventAction.C) {
                return "C";
            }
            if (code == AuditEventAction.R) {
                return "R";
            }
            if (code == AuditEventAction.U) {
                return "U";
            }
            if (code == AuditEventAction.D) {
                return "D";
            }
            if (code == AuditEventAction.E) {
                return "E";
            }
            return "?";
        }

        @Override
        public String toSystem(AuditEventAction code) {
            return code.getSystem();
        }
    }

    public static enum AuditEventAction {
        C,
        R,
        U,
        D,
        E,
        NULL;


        public static AuditEventAction fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("C".equals(codeString)) {
                return C;
            }
            if ("R".equals(codeString)) {
                return R;
            }
            if ("U".equals(codeString)) {
                return U;
            }
            if ("D".equals(codeString)) {
                return D;
            }
            if ("E".equals(codeString)) {
                return E;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AuditEventAction code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case C: {
                    return "C";
                }
                case R: {
                    return "R";
                }
                case U: {
                    return "U";
                }
                case D: {
                    return "D";
                }
                case E: {
                    return "E";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case C: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case R: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case U: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case D: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case E: {
                    return "http://hl7.org/fhir/audit-event-action";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case C: {
                    return "Create a new database object, such as placing an order.";
                }
                case R: {
                    return "Display or print data, such as a doctor census.";
                }
                case U: {
                    return "Update data, such as revise patient information.";
                }
                case D: {
                    return "Delete items, such as a doctor master file record.";
                }
                case E: {
                    return "Perform a system or application function such as log-on, program execution or use of an object's method, or perform a query/search operation.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case C: {
                    return "Create";
                }
                case R: {
                    return "Read/View/Print";
                }
                case U: {
                    return "Update";
                }
                case D: {
                    return "Delete";
                }
                case E: {
                    return "Execute";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

