/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="AllergyIntolerance", profile="http://hl7.org/fhir/StructureDefinition/AllergyIntolerance")
public class AllergyIntolerance
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External ids for this item", formalDefinition="Business identifiers assigned to this AllergyIntolerance by the performer or other systems which remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="clinicalStatus", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive | resolved", formalDefinition="The clinical status of the allergy or intolerance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergyintolerance-clinical")
    protected CodeableConcept clinicalStatus;
    @Child(name="verificationStatus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="unconfirmed | presumed | confirmed | refuted | entered-in-error", formalDefinition="Assertion about certainty associated with the propensity, or potential risk, of a reaction to the identified substance (including pharmaceutical product).  The verification status pertains to the allergy or intolerance, itself, not to any specific AllergyIntolerance attribute.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergyintolerance-verification")
    protected CodeableConcept verificationStatus;
    @Child(name="type", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="allergy | intolerance - Underlying mechanism (if known)", formalDefinition="Identification of the underlying physiological mechanism for the reaction risk.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergy-intolerance-type")
    protected CodeableConcept type;
    @Child(name="category", type={CodeType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="food | medication | environment | biologic", formalDefinition="Category of the identified substance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergy-intolerance-category")
    protected List<Enumeration<AllergyIntoleranceCategory>> category;
    @Child(name="criticality", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="low | high | unable-to-assess", formalDefinition="Estimate of the potential clinical harm, or seriousness, of the reaction to the identified substance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergy-intolerance-criticality")
    protected Enumeration<AllergyIntoleranceCriticality> criticality;
    @Child(name="code", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code that identifies the allergy or intolerance", formalDefinition="Code for an allergy or intolerance statement (either a positive or a negated/excluded statement).  This may be a code for a substance or pharmaceutical product that is considered to be responsible for the adverse reaction risk (e.g., \"Latex\"), an allergy or intolerance condition (e.g., \"Latex allergy\"), or a negated/excluded code for a specific substance or class (e.g., \"No latex allergy\") or a general or categorical negated statement (e.g.,  \"No known allergy\", \"No known drug allergies\").  Note: the substance for a specific reaction may be different from the substance identified as the cause of the risk, but it must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite product that includes the identified substance. It must be clinically safe to only process the 'code' and ignore the 'reaction.substance'.  If a receiving system is unable to confirm that AllergyIntolerance.reaction.substance falls within the semantic scope of AllergyIntolerance.code, then the receiving system should ignore AllergyIntolerance.reaction.substance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/allergyintolerance-code")
    protected CodeableConcept code;
    @Child(name="patient", type={Patient.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the allergy or intolerance is for", formalDefinition="The patient who has the allergy or intolerance.")
    protected Reference patient;
    @Child(name="encounter", type={Encounter.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter when the allergy or intolerance was asserted", formalDefinition="The encounter when the allergy or intolerance was asserted.")
    protected Reference encounter;
    @Child(name="onset", type={DateTimeType.class, Age.class, Period.class, Range.class, StringType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When allergy or intolerance was identified", formalDefinition="Estimated or actual date,  date-time, or age when allergy or intolerance was identified.")
    protected DataType onset;
    @Child(name="recordedDate", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date allergy or intolerance was first recorded", formalDefinition="The recordedDate represents when this particular AllergyIntolerance record was created in the system, which is often a system-generated date.")
    protected DateTimeType recordedDate;
    @Child(name="participant", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who or what participated in the activities related to the allergy or intolerance and how they were involved", formalDefinition="Indicates who or what participated in the activities related to the allergy or intolerance and how they were involved.")
    protected List<AllergyIntoleranceParticipantComponent> participant;
    @Child(name="lastOccurrence", type={DateTimeType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Date(/time) of last known occurrence of a reaction", formalDefinition="Represents the date and/or time of the last known occurrence of a reaction event.")
    protected DateTimeType lastOccurrence;
    @Child(name="note", type={Annotation.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional text not captured in other fields", formalDefinition="Additional narrative about the propensity for the Adverse Reaction, not captured in other fields.")
    protected List<Annotation> note;
    @Child(name="reaction", type={}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Adverse Reaction Events linked to exposure to substance", formalDefinition="Details about each adverse reaction event linked to exposure to the identified substance.")
    protected List<AllergyIntoleranceReactionComponent> reaction;
    private static final long serialVersionUID = -1955746770L;
    @SearchParamDefinition(name="category", path="AllergyIntolerance.category", description="food | medication | environment | biologic", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="clinical-status", path="AllergyIntolerance.clinicalStatus", description="active | inactive | resolved", type="token")
    public static final String SP_CLINICAL_STATUS = "clinical-status";
    public static final TokenClientParam CLINICAL_STATUS = new TokenClientParam("clinical-status");
    @SearchParamDefinition(name="criticality", path="AllergyIntolerance.criticality", description="low | high | unable-to-assess", type="token")
    public static final String SP_CRITICALITY = "criticality";
    public static final TokenClientParam CRITICALITY = new TokenClientParam("criticality");
    @SearchParamDefinition(name="last-date", path="AllergyIntolerance.lastOccurrence", description="Date(/time) of last known occurrence of a reaction", type="date")
    public static final String SP_LAST_DATE = "last-date";
    public static final DateClientParam LAST_DATE = new DateClientParam("last-date");
    @SearchParamDefinition(name="manifestation-code", path="AllergyIntolerance.reaction.manifestation.concept", description="Clinical symptoms/signs associated with the Event", type="token")
    public static final String SP_MANIFESTATION_CODE = "manifestation-code";
    public static final TokenClientParam MANIFESTATION_CODE = new TokenClientParam("manifestation-code");
    @SearchParamDefinition(name="manifestation-reference", path="AllergyIntolerance.reaction.manifestation.reference", description="Clinical symptoms/signs associated with the Event", type="reference")
    public static final String SP_MANIFESTATION_REFERENCE = "manifestation-reference";
    public static final ReferenceClientParam MANIFESTATION_REFERENCE = new ReferenceClientParam("manifestation-reference");
    public static final Include INCLUDE_MANIFESTATION_REFERENCE = new Include("AllergyIntolerance:manifestation-reference").toLocked();
    @SearchParamDefinition(name="participant", path="AllergyIntolerance.participant.actor", description="Who or what participated in the activities related to the allergy or intolerance", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient"), @Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={CareTeam.class, Device.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("AllergyIntolerance:participant").toLocked();
    @SearchParamDefinition(name="route", path="AllergyIntolerance.reaction.exposureRoute", description="How the subject was exposed to the substance", type="token")
    public static final String SP_ROUTE = "route";
    public static final TokenClientParam ROUTE = new TokenClientParam("route");
    @SearchParamDefinition(name="severity", path="AllergyIntolerance.reaction.severity", description="mild | moderate | severe (of event as a whole)", type="token")
    public static final String SP_SEVERITY = "severity";
    public static final TokenClientParam SEVERITY = new TokenClientParam("severity");
    @SearchParamDefinition(name="verification-status", path="AllergyIntolerance.verificationStatus", description="unconfirmed | presumed | confirmed | refuted | entered-in-error", type="token")
    public static final String SP_VERIFICATION_STATUS = "verification-status";
    public static final TokenClientParam VERIFICATION_STATUS = new TokenClientParam("verification-status");
    @SearchParamDefinition(name="code", path="AllergyIntolerance.code | AllergyIntolerance.reaction.substance | Condition.code | DeviceRequest.code.concept | DiagnosticReport.code | FamilyMemberHistory.condition.code | List.code | Medication.code | MedicationAdministration.medication.concept | MedicationDispense.medication.concept | MedicationRequest.medication.concept | MedicationUsage.medication.concept | Observation.code | Procedure.code", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Code that identifies the allergy or intolerance\r\n* [Condition](condition.html): Code for the condition\r\n* [DeviceRequest](devicerequest.html): Code for what is being requested/ordered\r\n* [DiagnosticReport](diagnosticreport.html): The code for the report, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a condition code\r\n* [List](list.html): What the purpose of this list is\r\n* [Medication](medication.html): Returns medications for a specific code\r\n* [MedicationAdministration](medicationadministration.html): Return administrations of this medication code\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses of this medicine code\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions of this medication code\r\n* [MedicationUsage](medicationusage.html): Return statements of this medication code\r\n* [Observation](observation.html): The code of the observation type\r\n* [Procedure](procedure.html): A code to identify a  procedure\r\n", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.date | DiagnosticReport.effective.as(dateTime) | DiagnosticReport.effective.as(Period) | Encounter.actualPeriod | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective.as(dateTime) | Observation.effective.as(Period) | Observation.effective.as(Timing) | Observation.effective.as(instant) | Procedure.occurrence.as(dateTime) | Procedure.occurrence.as(Period) | Procedure.occurrence.as(Timing) | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the actualPeriod the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.subject | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={BiologicallyDerivedProduct.class, Device.class, Group.class, Location.class, Medication.class, NutritionProduct.class, Organization.class, Patient.class, Practitioner.class, Procedure.class, Substance.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("AllergyIntolerance:patient").toLocked();
    @SearchParamDefinition(name="type", path="AllergyIntolerance.type | Composition.type | DocumentManifest.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [DocumentManifest](documentmanifest.html): Kind of document set\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public AllergyIntolerance() {
    }

    public AllergyIntolerance(Reference patient) {
        this.setPatient(patient);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public AllergyIntolerance setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public AllergyIntolerance addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getClinicalStatus() {
        if (this.clinicalStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.clinicalStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.clinicalStatus = new CodeableConcept();
            }
        }
        return this.clinicalStatus;
    }

    public boolean hasClinicalStatus() {
        return this.clinicalStatus != null && !this.clinicalStatus.isEmpty();
    }

    public AllergyIntolerance setClinicalStatus(CodeableConcept value) {
        this.clinicalStatus = value;
        return this;
    }

    public CodeableConcept getVerificationStatus() {
        if (this.verificationStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.verificationStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.verificationStatus = new CodeableConcept();
            }
        }
        return this.verificationStatus;
    }

    public boolean hasVerificationStatus() {
        return this.verificationStatus != null && !this.verificationStatus.isEmpty();
    }

    public AllergyIntolerance setVerificationStatus(CodeableConcept value) {
        this.verificationStatus = value;
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public AllergyIntolerance setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<Enumeration<AllergyIntoleranceCategory>> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<Enumeration<AllergyIntoleranceCategory>>();
        }
        return this.category;
    }

    public AllergyIntolerance setCategory(List<Enumeration<AllergyIntoleranceCategory>> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (Enumeration<AllergyIntoleranceCategory> item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<AllergyIntoleranceCategory> addCategoryElement() {
        Enumeration<AllergyIntoleranceCategory> t = new Enumeration<AllergyIntoleranceCategory>(new AllergyIntoleranceCategoryEnumFactory());
        if (this.category == null) {
            this.category = new ArrayList<Enumeration<AllergyIntoleranceCategory>>();
        }
        this.category.add(t);
        return t;
    }

    public AllergyIntolerance addCategory(AllergyIntoleranceCategory value) {
        Enumeration<AllergyIntoleranceCategory> t = new Enumeration<AllergyIntoleranceCategory>(new AllergyIntoleranceCategoryEnumFactory());
        t.setValue((Object)value);
        if (this.category == null) {
            this.category = new ArrayList<Enumeration<AllergyIntoleranceCategory>>();
        }
        this.category.add(t);
        return this;
    }

    public boolean hasCategory(AllergyIntoleranceCategory value) {
        if (this.category == null) {
            return false;
        }
        for (Enumeration<AllergyIntoleranceCategory> v : this.category) {
            if (!((AllergyIntoleranceCategory)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<AllergyIntoleranceCriticality> getCriticalityElement() {
        if (this.criticality == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.criticality");
            }
            if (Configuration.doAutoCreate()) {
                this.criticality = new Enumeration<AllergyIntoleranceCriticality>(new AllergyIntoleranceCriticalityEnumFactory());
            }
        }
        return this.criticality;
    }

    public boolean hasCriticalityElement() {
        return this.criticality != null && !this.criticality.isEmpty();
    }

    public boolean hasCriticality() {
        return this.criticality != null && !this.criticality.isEmpty();
    }

    public AllergyIntolerance setCriticalityElement(Enumeration<AllergyIntoleranceCriticality> value) {
        this.criticality = value;
        return this;
    }

    public AllergyIntoleranceCriticality getCriticality() {
        return this.criticality == null ? null : (AllergyIntoleranceCriticality)((Object)this.criticality.getValue());
    }

    public AllergyIntolerance setCriticality(AllergyIntoleranceCriticality value) {
        if (value == null) {
            this.criticality = null;
        } else {
            if (this.criticality == null) {
                this.criticality = new Enumeration<AllergyIntoleranceCriticality>(new AllergyIntoleranceCriticalityEnumFactory());
            }
            this.criticality.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public AllergyIntolerance setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public AllergyIntolerance setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public AllergyIntolerance setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DataType getOnset() {
        return this.onset;
    }

    public DateTimeType getOnsetDateTimeType() throws FHIRException {
        if (this.onset == null) {
            this.onset = new DateTimeType();
        }
        if (!(this.onset instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.onset;
    }

    public boolean hasOnsetDateTimeType() {
        return this != null && this.onset instanceof DateTimeType;
    }

    public Age getOnsetAge() throws FHIRException {
        if (this.onset == null) {
            this.onset = new Age();
        }
        if (!(this.onset instanceof Age)) {
            throw new FHIRException("Type mismatch: the type Age was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Age)this.onset;
    }

    public boolean hasOnsetAge() {
        return this != null && this.onset instanceof Age;
    }

    public Period getOnsetPeriod() throws FHIRException {
        if (this.onset == null) {
            this.onset = new Period();
        }
        if (!(this.onset instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Period)this.onset;
    }

    public boolean hasOnsetPeriod() {
        return this != null && this.onset instanceof Period;
    }

    public Range getOnsetRange() throws FHIRException {
        if (this.onset == null) {
            this.onset = new Range();
        }
        if (!(this.onset instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (Range)this.onset;
    }

    public boolean hasOnsetRange() {
        return this != null && this.onset instanceof Range;
    }

    public StringType getOnsetStringType() throws FHIRException {
        if (this.onset == null) {
            this.onset = new StringType();
        }
        if (!(this.onset instanceof StringType)) {
            throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.onset.getClass().getName() + " was encountered");
        }
        return (StringType)this.onset;
    }

    public boolean hasOnsetStringType() {
        return this != null && this.onset instanceof StringType;
    }

    public boolean hasOnset() {
        return this.onset != null && !this.onset.isEmpty();
    }

    public AllergyIntolerance setOnset(DataType value) {
        if (!(value == null || value instanceof DateTimeType || value instanceof Age || value instanceof Period || value instanceof Range || value instanceof StringType)) {
            throw new Error("Not the right type for AllergyIntolerance.onset[x]: " + value.fhirType());
        }
        this.onset = value;
        return this;
    }

    public DateTimeType getRecordedDateElement() {
        if (this.recordedDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.recordedDate");
            }
            if (Configuration.doAutoCreate()) {
                this.recordedDate = new DateTimeType();
            }
        }
        return this.recordedDate;
    }

    public boolean hasRecordedDateElement() {
        return this.recordedDate != null && !this.recordedDate.isEmpty();
    }

    public boolean hasRecordedDate() {
        return this.recordedDate != null && !this.recordedDate.isEmpty();
    }

    public AllergyIntolerance setRecordedDateElement(DateTimeType value) {
        this.recordedDate = value;
        return this;
    }

    public Date getRecordedDate() {
        return this.recordedDate == null ? null : (Date)this.recordedDate.getValue();
    }

    public AllergyIntolerance setRecordedDate(Date value) {
        if (value == null) {
            this.recordedDate = null;
        } else {
            if (this.recordedDate == null) {
                this.recordedDate = new DateTimeType();
            }
            this.recordedDate.setValue(value);
        }
        return this;
    }

    public List<AllergyIntoleranceParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<AllergyIntoleranceParticipantComponent>();
        }
        return this.participant;
    }

    public AllergyIntolerance setParticipant(List<AllergyIntoleranceParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (AllergyIntoleranceParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AllergyIntoleranceParticipantComponent addParticipant() {
        AllergyIntoleranceParticipantComponent t = new AllergyIntoleranceParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<AllergyIntoleranceParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public AllergyIntolerance addParticipant(AllergyIntoleranceParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<AllergyIntoleranceParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public AllergyIntoleranceParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public DateTimeType getLastOccurrenceElement() {
        if (this.lastOccurrence == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create AllergyIntolerance.lastOccurrence");
            }
            if (Configuration.doAutoCreate()) {
                this.lastOccurrence = new DateTimeType();
            }
        }
        return this.lastOccurrence;
    }

    public boolean hasLastOccurrenceElement() {
        return this.lastOccurrence != null && !this.lastOccurrence.isEmpty();
    }

    public boolean hasLastOccurrence() {
        return this.lastOccurrence != null && !this.lastOccurrence.isEmpty();
    }

    public AllergyIntolerance setLastOccurrenceElement(DateTimeType value) {
        this.lastOccurrence = value;
        return this;
    }

    public Date getLastOccurrence() {
        return this.lastOccurrence == null ? null : (Date)this.lastOccurrence.getValue();
    }

    public AllergyIntolerance setLastOccurrence(Date value) {
        if (value == null) {
            this.lastOccurrence = null;
        } else {
            if (this.lastOccurrence == null) {
                this.lastOccurrence = new DateTimeType();
            }
            this.lastOccurrence.setValue(value);
        }
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public AllergyIntolerance setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public AllergyIntolerance addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<AllergyIntoleranceReactionComponent> getReaction() {
        if (this.reaction == null) {
            this.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
        }
        return this.reaction;
    }

    public AllergyIntolerance setReaction(List<AllergyIntoleranceReactionComponent> theReaction) {
        this.reaction = theReaction;
        return this;
    }

    public boolean hasReaction() {
        if (this.reaction == null) {
            return false;
        }
        for (AllergyIntoleranceReactionComponent item : this.reaction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AllergyIntoleranceReactionComponent addReaction() {
        AllergyIntoleranceReactionComponent t = new AllergyIntoleranceReactionComponent();
        if (this.reaction == null) {
            this.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
        }
        this.reaction.add(t);
        return t;
    }

    public AllergyIntolerance addReaction(AllergyIntoleranceReactionComponent t) {
        if (t == null) {
            return this;
        }
        if (this.reaction == null) {
            this.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
        }
        this.reaction.add(t);
        return this;
    }

    public AllergyIntoleranceReactionComponent getReactionFirstRep() {
        if (this.getReaction().isEmpty()) {
            this.addReaction();
        }
        return this.getReaction().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this AllergyIntolerance by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("clinicalStatus", "CodeableConcept", "The clinical status of the allergy or intolerance.", 0, 1, this.clinicalStatus));
        children.add(new Property("verificationStatus", "CodeableConcept", "Assertion about certainty associated with the propensity, or potential risk, of a reaction to the identified substance (including pharmaceutical product).  The verification status pertains to the allergy or intolerance, itself, not to any specific AllergyIntolerance attribute.", 0, 1, this.verificationStatus));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Identification of the underlying physiological mechanism for the reaction risk.", 0, 1, this.type));
        children.add(new Property(SP_CATEGORY, SP_CODE, "Category of the identified substance.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CRITICALITY, SP_CODE, "Estimate of the potential clinical harm, or seriousness, of the reaction to the identified substance.", 0, 1, this.criticality));
        children.add(new Property(SP_CODE, "CodeableConcept", "Code for an allergy or intolerance statement (either a positive or a negated/excluded statement).  This may be a code for a substance or pharmaceutical product that is considered to be responsible for the adverse reaction risk (e.g., \"Latex\"), an allergy or intolerance condition (e.g., \"Latex allergy\"), or a negated/excluded code for a specific substance or class (e.g., \"No latex allergy\") or a general or categorical negated statement (e.g.,  \"No known allergy\", \"No known drug allergies\").  Note: the substance for a specific reaction may be different from the substance identified as the cause of the risk, but it must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite product that includes the identified substance. It must be clinically safe to only process the 'code' and ignore the 'reaction.substance'.  If a receiving system is unable to confirm that AllergyIntolerance.reaction.substance falls within the semantic scope of AllergyIntolerance.code, then the receiving system should ignore AllergyIntolerance.reaction.substance.", 0, 1, this.code));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient who has the allergy or intolerance.", 0, 1, this.patient));
        children.add(new Property("encounter", "Reference(Encounter)", "The encounter when the allergy or intolerance was asserted.", 0, 1, this.encounter));
        children.add(new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset));
        children.add(new Property("recordedDate", "dateTime", "The recordedDate represents when this particular AllergyIntolerance record was created in the system, which is often a system-generated date.", 0, 1, this.recordedDate));
        children.add(new Property(SP_PARTICIPANT, "", "Indicates who or what participated in the activities related to the allergy or intolerance and how they were involved.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property("lastOccurrence", "dateTime", "Represents the date and/or time of the last known occurrence of a reaction event.", 0, 1, this.lastOccurrence));
        children.add(new Property("note", "Annotation", "Additional narrative about the propensity for the Adverse Reaction, not captured in other fields.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("reaction", "", "Details about each adverse reaction event linked to exposure to the identified substance.", 0, Integer.MAX_VALUE, this.reaction));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this AllergyIntolerance by the performer or other systems which remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -462853915: {
                return new Property("clinicalStatus", "CodeableConcept", "The clinical status of the allergy or intolerance.", 0, 1, this.clinicalStatus);
            }
            case -842509843: {
                return new Property("verificationStatus", "CodeableConcept", "Assertion about certainty associated with the propensity, or potential risk, of a reaction to the identified substance (including pharmaceutical product).  The verification status pertains to the allergy or intolerance, itself, not to any specific AllergyIntolerance attribute.", 0, 1, this.verificationStatus);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Identification of the underlying physiological mechanism for the reaction risk.", 0, 1, this.type);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, SP_CODE, "Category of the identified substance.", 0, Integer.MAX_VALUE, this.category);
            }
            case -1608054609: {
                return new Property(SP_CRITICALITY, SP_CODE, "Estimate of the potential clinical harm, or seriousness, of the reaction to the identified substance.", 0, 1, this.criticality);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "Code for an allergy or intolerance statement (either a positive or a negated/excluded statement).  This may be a code for a substance or pharmaceutical product that is considered to be responsible for the adverse reaction risk (e.g., \"Latex\"), an allergy or intolerance condition (e.g., \"Latex allergy\"), or a negated/excluded code for a specific substance or class (e.g., \"No latex allergy\") or a general or categorical negated statement (e.g.,  \"No known allergy\", \"No known drug allergies\").  Note: the substance for a specific reaction may be different from the substance identified as the cause of the risk, but it must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite product that includes the identified substance. It must be clinically safe to only process the 'code' and ignore the 'reaction.substance'.  If a receiving system is unable to confirm that AllergyIntolerance.reaction.substance falls within the semantic scope of AllergyIntolerance.code, then the receiving system should ignore AllergyIntolerance.reaction.substance.", 0, 1, this.code);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient who has the allergy or intolerance.", 0, 1, this.patient);
            }
            case 1524132147: {
                return new Property("encounter", "Reference(Encounter)", "The encounter when the allergy or intolerance was asserted.", 0, 1, this.encounter);
            }
            case -1886216323: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case 105901603: {
                return new Property("onset[x]", "dateTime|Age|Period|Range|string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -1701663010: {
                return new Property("onset[x]", "dateTime", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -1886241828: {
                return new Property("onset[x]", "Age", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -1545082428: {
                return new Property("onset[x]", "Period", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -186664742: {
                return new Property("onset[x]", "Range", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -1445342188: {
                return new Property("onset[x]", "string", "Estimated or actual date,  date-time, or age when allergy or intolerance was identified.", 0, 1, this.onset);
            }
            case -1952893826: {
                return new Property("recordedDate", "dateTime", "The recordedDate represents when this particular AllergyIntolerance record was created in the system, which is often a system-generated date.", 0, 1, this.recordedDate);
            }
            case 767422259: {
                return new Property(SP_PARTICIPANT, "", "Indicates who or what participated in the activities related to the allergy or intolerance and how they were involved.", 0, Integer.MAX_VALUE, this.participant);
            }
            case 1896977671: {
                return new Property("lastOccurrence", "dateTime", "Represents the date and/or time of the last known occurrence of a reaction event.", 0, 1, this.lastOccurrence);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Additional narrative about the propensity for the Adverse Reaction, not captured in other fields.", 0, Integer.MAX_VALUE, this.note);
            }
            case -867509719: {
                return new Property("reaction", "", "Details about each adverse reaction event linked to exposure to the identified substance.", 0, Integer.MAX_VALUE, this.reaction);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -462853915: {
                Base[] baseArray;
                if (this.clinicalStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.clinicalStatus;
                }
                return baseArray;
            }
            case -842509843: {
                Base[] baseArray;
                if (this.verificationStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.verificationStatus;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.type;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1608054609: {
                Base[] baseArray;
                if (this.criticality == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.criticality;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.code;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.patient;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.encounter;
                }
                return baseArray;
            }
            case 105901603: {
                Base[] baseArray;
                if (this.onset == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.onset;
                }
                return baseArray;
            }
            case -1952893826: {
                Base[] baseArray;
                if (this.recordedDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.recordedDate;
                }
                return baseArray;
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case 1896977671: {
                Base[] baseArray;
                if (this.lastOccurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.lastOccurrence;
                }
                return baseArray;
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -867509719: {
                return this.reaction == null ? new Base[]{} : this.reaction.toArray(new Base[this.reaction.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -462853915: {
                this.clinicalStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -842509843: {
                this.verificationStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                value = new AllergyIntoleranceCategoryEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getCategory().add(value);
                return value;
            }
            case -1608054609: {
                value = new AllergyIntoleranceCriticalityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.criticality = value;
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case 105901603: {
                this.onset = TypeConvertor.castToType(value);
                return value;
            }
            case -1952893826: {
                this.recordedDate = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 767422259: {
                this.getParticipant().add((AllergyIntoleranceParticipantComponent)((Object)value));
                return value;
            }
            case 1896977671: {
                this.lastOccurrence = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -867509719: {
                this.getReaction().add((AllergyIntoleranceReactionComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("clinicalStatus")) {
            this.clinicalStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("verificationStatus")) {
            this.verificationStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            value = new AllergyIntoleranceCategoryEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.getCategory().add(value);
        } else if (name.equals(SP_CRITICALITY)) {
            value = new AllergyIntoleranceCriticalityEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.criticality = value;
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("onset[x]")) {
            this.onset = TypeConvertor.castToType(value);
        } else if (name.equals("recordedDate")) {
            this.recordedDate = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((AllergyIntoleranceParticipantComponent)((Object)value));
        } else if (name.equals("lastOccurrence")) {
            this.lastOccurrence = TypeConvertor.castToDateTime(value);
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("reaction")) {
            this.getReaction().add((AllergyIntoleranceReactionComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -462853915: {
                return this.getClinicalStatus();
            }
            case -842509843: {
                return this.getVerificationStatus();
            }
            case 3575610: {
                return this.getType();
            }
            case 50511102: {
                return this.addCategoryElement();
            }
            case -1608054609: {
                return this.getCriticalityElement();
            }
            case 3059181: {
                return this.getCode();
            }
            case -791418107: {
                return this.getPatient();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1886216323: {
                return this.getOnset();
            }
            case 105901603: {
                return this.getOnset();
            }
            case -1952893826: {
                return this.getRecordedDateElement();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case 1896977671: {
                return this.getLastOccurrenceElement();
            }
            case 3387378: {
                return this.addNote();
            }
            case -867509719: {
                return this.addReaction();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -462853915: {
                return new String[]{"CodeableConcept"};
            }
            case -842509843: {
                return new String[]{"CodeableConcept"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{SP_CODE};
            }
            case -1608054609: {
                return new String[]{SP_CODE};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case 105901603: {
                return new String[]{"dateTime", "Age", "Period", "Range", "string"};
            }
            case -1952893826: {
                return new String[]{"dateTime"};
            }
            case 767422259: {
                return new String[0];
            }
            case 1896977671: {
                return new String[]{"dateTime"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -867509719: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("clinicalStatus")) {
            this.clinicalStatus = new CodeableConcept();
            return this.clinicalStatus;
        }
        if (name.equals("verificationStatus")) {
            this.verificationStatus = new CodeableConcept();
            return this.verificationStatus;
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_CATEGORY)) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.category");
        }
        if (name.equals(SP_CRITICALITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.criticality");
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("onsetDateTime")) {
            this.onset = new DateTimeType();
            return this.onset;
        }
        if (name.equals("onsetAge")) {
            this.onset = new Age();
            return this.onset;
        }
        if (name.equals("onsetPeriod")) {
            this.onset = new Period();
            return this.onset;
        }
        if (name.equals("onsetRange")) {
            this.onset = new Range();
            return this.onset;
        }
        if (name.equals("onsetString")) {
            this.onset = new StringType();
            return this.onset;
        }
        if (name.equals("recordedDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.recordedDate");
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals("lastOccurrence")) {
            throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.lastOccurrence");
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("reaction")) {
            return this.addReaction();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "AllergyIntolerance";
    }

    @Override
    public AllergyIntolerance copy() {
        AllergyIntolerance dst = new AllergyIntolerance();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(AllergyIntolerance dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.clinicalStatus = this.clinicalStatus == null ? null : this.clinicalStatus.copy();
        dst.verificationStatus = this.verificationStatus == null ? null : this.verificationStatus.copy();
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.category != null) {
            dst.category = new ArrayList<Enumeration<AllergyIntoleranceCategory>>();
            for (Enumeration enumeration : this.category) {
                dst.category.add((Enumeration<AllergyIntoleranceCategory>)enumeration.copy());
            }
        }
        dst.criticality = this.criticality == null ? null : this.criticality.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.patient = this.patient == null ? null : this.patient.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.onset = this.onset == null ? null : this.onset.copy();
        DateTimeType dateTimeType = dst.recordedDate = this.recordedDate == null ? null : this.recordedDate.copy();
        if (this.participant != null) {
            dst.participant = new ArrayList<AllergyIntoleranceParticipantComponent>();
            for (AllergyIntoleranceParticipantComponent allergyIntoleranceParticipantComponent : this.participant) {
                dst.participant.add(allergyIntoleranceParticipantComponent.copy());
            }
        }
        DateTimeType dateTimeType2 = dst.lastOccurrence = this.lastOccurrence == null ? null : this.lastOccurrence.copy();
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.reaction != null) {
            dst.reaction = new ArrayList<AllergyIntoleranceReactionComponent>();
            for (AllergyIntoleranceReactionComponent allergyIntoleranceReactionComponent : this.reaction) {
                dst.reaction.add(allergyIntoleranceReactionComponent.copy());
            }
        }
    }

    protected AllergyIntolerance typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof AllergyIntolerance)) {
            return false;
        }
        AllergyIntolerance o = (AllergyIntolerance)other_;
        return AllergyIntolerance.compareDeep(this.identifier, o.identifier, true) && AllergyIntolerance.compareDeep(this.clinicalStatus, o.clinicalStatus, true) && AllergyIntolerance.compareDeep(this.verificationStatus, o.verificationStatus, true) && AllergyIntolerance.compareDeep(this.type, o.type, true) && AllergyIntolerance.compareDeep(this.category, o.category, true) && AllergyIntolerance.compareDeep(this.criticality, o.criticality, true) && AllergyIntolerance.compareDeep(this.code, o.code, true) && AllergyIntolerance.compareDeep(this.patient, o.patient, true) && AllergyIntolerance.compareDeep(this.encounter, o.encounter, true) && AllergyIntolerance.compareDeep(this.onset, o.onset, true) && AllergyIntolerance.compareDeep(this.recordedDate, o.recordedDate, true) && AllergyIntolerance.compareDeep(this.participant, o.participant, true) && AllergyIntolerance.compareDeep(this.lastOccurrence, o.lastOccurrence, true) && AllergyIntolerance.compareDeep(this.note, o.note, true) && AllergyIntolerance.compareDeep(this.reaction, o.reaction, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof AllergyIntolerance)) {
            return false;
        }
        AllergyIntolerance o = (AllergyIntolerance)other_;
        return AllergyIntolerance.compareValues(this.category, o.category, true) && AllergyIntolerance.compareValues(this.criticality, o.criticality, true) && AllergyIntolerance.compareValues(this.recordedDate, o.recordedDate, true) && AllergyIntolerance.compareValues(this.lastOccurrence, o.lastOccurrence, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.clinicalStatus, this.verificationStatus, this.type, this.category, this.criticality, this.code, this.patient, this.encounter, this.onset, this.recordedDate, this.participant, this.lastOccurrence, this.note, this.reaction);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.AllergyIntolerance;
    }

    @Block
    public static class AllergyIntoleranceReactionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="substance", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specific substance or pharmaceutical product considered to be responsible for event", formalDefinition="Identification of the specific substance (or pharmaceutical product) considered to be responsible for the Adverse Reaction event. Note: the substance for a specific reaction may be different from the substance identified as the cause of the risk, but it must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite product that includes the identified substance. It must be clinically safe to only process the 'code' and ignore the 'reaction.substance'.  If a receiving system is unable to confirm that AllergyIntolerance.reaction.substance falls within the semantic scope of AllergyIntolerance.code, then the receiving system should ignore AllergyIntolerance.reaction.substance.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/substance-code")
        protected CodeableConcept substance;
        @Child(name="manifestation", type={CodeableReference.class}, order=2, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Clinical symptoms/signs associated with the Event", formalDefinition="Clinical symptoms and/or signs that are observed or associated with the adverse reaction event.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
        protected List<CodeableReference> manifestation;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of the event as a whole", formalDefinition="Text description about the reaction as a whole, including details of the manifestation if required.")
        protected StringType description;
        @Child(name="onset", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date(/time) when manifestations showed", formalDefinition="Record of the date and/or time of the onset of the Reaction.")
        protected DateTimeType onset;
        @Child(name="severity", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="mild | moderate | severe (of event as a whole)", formalDefinition="Clinical assessment of the severity of the reaction event as a whole, potentially considering multiple different manifestations.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/reaction-event-severity")
        protected Enumeration<AllergyIntoleranceSeverity> severity;
        @Child(name="exposureRoute", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="How the subject was exposed to the substance", formalDefinition="Identification of the route by which the subject was exposed to the substance.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/route-codes")
        protected CodeableConcept exposureRoute;
        @Child(name="note", type={Annotation.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Text about event not captured in other fields", formalDefinition="Additional text about the adverse reaction event not captured in other fields.")
        protected List<Annotation> note;
        private static final long serialVersionUID = 1007789961L;

        public AllergyIntoleranceReactionComponent() {
        }

        public AllergyIntoleranceReactionComponent(CodeableReference manifestation) {
            this.addManifestation(manifestation);
        }

        public CodeableConcept getSubstance() {
            if (this.substance == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.substance");
                }
                if (Configuration.doAutoCreate()) {
                    this.substance = new CodeableConcept();
                }
            }
            return this.substance;
        }

        public boolean hasSubstance() {
            return this.substance != null && !this.substance.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setSubstance(CodeableConcept value) {
            this.substance = value;
            return this;
        }

        public List<CodeableReference> getManifestation() {
            if (this.manifestation == null) {
                this.manifestation = new ArrayList<CodeableReference>();
            }
            return this.manifestation;
        }

        public AllergyIntoleranceReactionComponent setManifestation(List<CodeableReference> theManifestation) {
            this.manifestation = theManifestation;
            return this;
        }

        public boolean hasManifestation() {
            if (this.manifestation == null) {
                return false;
            }
            for (CodeableReference item : this.manifestation) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableReference addManifestation() {
            CodeableReference t = new CodeableReference();
            if (this.manifestation == null) {
                this.manifestation = new ArrayList<CodeableReference>();
            }
            this.manifestation.add(t);
            return t;
        }

        public AllergyIntoleranceReactionComponent addManifestation(CodeableReference t) {
            if (t == null) {
                return this;
            }
            if (this.manifestation == null) {
                this.manifestation = new ArrayList<CodeableReference>();
            }
            this.manifestation.add(t);
            return this;
        }

        public CodeableReference getManifestationFirstRep() {
            if (this.getManifestation().isEmpty()) {
                this.addManifestation();
            }
            return this.getManifestation().get(0);
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public AllergyIntoleranceReactionComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public DateTimeType getOnsetElement() {
            if (this.onset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.onset");
                }
                if (Configuration.doAutoCreate()) {
                    this.onset = new DateTimeType();
                }
            }
            return this.onset;
        }

        public boolean hasOnsetElement() {
            return this.onset != null && !this.onset.isEmpty();
        }

        public boolean hasOnset() {
            return this.onset != null && !this.onset.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setOnsetElement(DateTimeType value) {
            this.onset = value;
            return this;
        }

        public Date getOnset() {
            return this.onset == null ? null : (Date)this.onset.getValue();
        }

        public AllergyIntoleranceReactionComponent setOnset(Date value) {
            if (value == null) {
                this.onset = null;
            } else {
                if (this.onset == null) {
                    this.onset = new DateTimeType();
                }
                this.onset.setValue(value);
            }
            return this;
        }

        public Enumeration<AllergyIntoleranceSeverity> getSeverityElement() {
            if (this.severity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.severity");
                }
                if (Configuration.doAutoCreate()) {
                    this.severity = new Enumeration<AllergyIntoleranceSeverity>(new AllergyIntoleranceSeverityEnumFactory());
                }
            }
            return this.severity;
        }

        public boolean hasSeverityElement() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public boolean hasSeverity() {
            return this.severity != null && !this.severity.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setSeverityElement(Enumeration<AllergyIntoleranceSeverity> value) {
            this.severity = value;
            return this;
        }

        public AllergyIntoleranceSeverity getSeverity() {
            return this.severity == null ? null : (AllergyIntoleranceSeverity)((Object)this.severity.getValue());
        }

        public AllergyIntoleranceReactionComponent setSeverity(AllergyIntoleranceSeverity value) {
            if (value == null) {
                this.severity = null;
            } else {
                if (this.severity == null) {
                    this.severity = new Enumeration<AllergyIntoleranceSeverity>(new AllergyIntoleranceSeverityEnumFactory());
                }
                this.severity.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getExposureRoute() {
            if (this.exposureRoute == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceReactionComponent.exposureRoute");
                }
                if (Configuration.doAutoCreate()) {
                    this.exposureRoute = new CodeableConcept();
                }
            }
            return this.exposureRoute;
        }

        public boolean hasExposureRoute() {
            return this.exposureRoute != null && !this.exposureRoute.isEmpty();
        }

        public AllergyIntoleranceReactionComponent setExposureRoute(CodeableConcept value) {
            this.exposureRoute = value;
            return this;
        }

        public List<Annotation> getNote() {
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            return this.note;
        }

        public AllergyIntoleranceReactionComponent setNote(List<Annotation> theNote) {
            this.note = theNote;
            return this;
        }

        public boolean hasNote() {
            if (this.note == null) {
                return false;
            }
            for (Annotation item : this.note) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Annotation addNote() {
            Annotation t = new Annotation();
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return t;
        }

        public AllergyIntoleranceReactionComponent addNote(Annotation t) {
            if (t == null) {
                return this;
            }
            if (this.note == null) {
                this.note = new ArrayList<Annotation>();
            }
            this.note.add(t);
            return this;
        }

        public Annotation getNoteFirstRep() {
            if (this.getNote().isEmpty()) {
                this.addNote();
            }
            return this.getNote().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("substance", "CodeableConcept", "Identification of the specific substance (or pharmaceutical product) considered to be responsible for the Adverse Reaction event. Note: the substance for a specific reaction may be different from the substance identified as the cause of the risk, but it must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite product that includes the identified substance. It must be clinically safe to only process the 'code' and ignore the 'reaction.substance'.  If a receiving system is unable to confirm that AllergyIntolerance.reaction.substance falls within the semantic scope of AllergyIntolerance.code, then the receiving system should ignore AllergyIntolerance.reaction.substance.", 0, 1, this.substance));
            children.add(new Property("manifestation", "CodeableReference(Observation)", "Clinical symptoms and/or signs that are observed or associated with the adverse reaction event.", 0, Integer.MAX_VALUE, this.manifestation));
            children.add(new Property("description", "string", "Text description about the reaction as a whole, including details of the manifestation if required.", 0, 1, this.description));
            children.add(new Property("onset", "dateTime", "Record of the date and/or time of the onset of the Reaction.", 0, 1, this.onset));
            children.add(new Property(AllergyIntolerance.SP_SEVERITY, AllergyIntolerance.SP_CODE, "Clinical assessment of the severity of the reaction event as a whole, potentially considering multiple different manifestations.", 0, 1, this.severity));
            children.add(new Property("exposureRoute", "CodeableConcept", "Identification of the route by which the subject was exposed to the substance.", 0, 1, this.exposureRoute));
            children.add(new Property("note", "Annotation", "Additional text about the adverse reaction event not captured in other fields.", 0, Integer.MAX_VALUE, this.note));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 530040176: {
                    return new Property("substance", "CodeableConcept", "Identification of the specific substance (or pharmaceutical product) considered to be responsible for the Adverse Reaction event. Note: the substance for a specific reaction may be different from the substance identified as the cause of the risk, but it must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite product that includes the identified substance. It must be clinically safe to only process the 'code' and ignore the 'reaction.substance'.  If a receiving system is unable to confirm that AllergyIntolerance.reaction.substance falls within the semantic scope of AllergyIntolerance.code, then the receiving system should ignore AllergyIntolerance.reaction.substance.", 0, 1, this.substance);
                }
                case 1115984422: {
                    return new Property("manifestation", "CodeableReference(Observation)", "Clinical symptoms and/or signs that are observed or associated with the adverse reaction event.", 0, Integer.MAX_VALUE, this.manifestation);
                }
                case -1724546052: {
                    return new Property("description", "string", "Text description about the reaction as a whole, including details of the manifestation if required.", 0, 1, this.description);
                }
                case 105901603: {
                    return new Property("onset", "dateTime", "Record of the date and/or time of the onset of the Reaction.", 0, 1, this.onset);
                }
                case 1478300413: {
                    return new Property(AllergyIntolerance.SP_SEVERITY, AllergyIntolerance.SP_CODE, "Clinical assessment of the severity of the reaction event as a whole, potentially considering multiple different manifestations.", 0, 1, this.severity);
                }
                case 421286274: {
                    return new Property("exposureRoute", "CodeableConcept", "Identification of the route by which the subject was exposed to the substance.", 0, 1, this.exposureRoute);
                }
                case 3387378: {
                    return new Property("note", "Annotation", "Additional text about the adverse reaction event not captured in other fields.", 0, Integer.MAX_VALUE, this.note);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    Base[] baseArray;
                    if (this.substance == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.substance;
                    }
                    return baseArray;
                }
                case 1115984422: {
                    return this.manifestation == null ? new Base[]{} : this.manifestation.toArray(new Base[this.manifestation.size()]);
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 105901603: {
                    Base[] baseArray;
                    if (this.onset == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.onset;
                    }
                    return baseArray;
                }
                case 1478300413: {
                    Base[] baseArray;
                    if (this.severity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.severity;
                    }
                    return baseArray;
                }
                case 421286274: {
                    Base[] baseArray;
                    if (this.exposureRoute == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.exposureRoute;
                    }
                    return baseArray;
                }
                case 3387378: {
                    return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    this.substance = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 1115984422: {
                    this.getManifestation().add(TypeConvertor.castToCodeableReference(value));
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 105901603: {
                    this.onset = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 1478300413: {
                    value = new AllergyIntoleranceSeverityEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.severity = value;
                    return value;
                }
                case 421286274: {
                    this.exposureRoute = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3387378: {
                    this.getNote().add(TypeConvertor.castToAnnotation(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("manifestation")) {
                this.getManifestation().add(TypeConvertor.castToCodeableReference(value));
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("onset")) {
                this.onset = TypeConvertor.castToDateTime(value);
            } else if (name.equals(AllergyIntolerance.SP_SEVERITY)) {
                value = new AllergyIntoleranceSeverityEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.severity = value;
            } else if (name.equals("exposureRoute")) {
                this.exposureRoute = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("note")) {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return this.getSubstance();
                }
                case 1115984422: {
                    return this.addManifestation();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 105901603: {
                    return this.getOnsetElement();
                }
                case 1478300413: {
                    return this.getSeverityElement();
                }
                case 421286274: {
                    return this.getExposureRoute();
                }
                case 3387378: {
                    return this.addNote();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 530040176: {
                    return new String[]{"CodeableConcept"};
                }
                case 1115984422: {
                    return new String[]{"CodeableReference"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 105901603: {
                    return new String[]{"dateTime"};
                }
                case 1478300413: {
                    return new String[]{AllergyIntolerance.SP_CODE};
                }
                case 421286274: {
                    return new String[]{"CodeableConcept"};
                }
                case 3387378: {
                    return new String[]{"Annotation"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("substance")) {
                this.substance = new CodeableConcept();
                return this.substance;
            }
            if (name.equals("manifestation")) {
                return this.addManifestation();
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.reaction.description");
            }
            if (name.equals("onset")) {
                throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.reaction.onset");
            }
            if (name.equals(AllergyIntolerance.SP_SEVERITY)) {
                throw new FHIRException("Cannot call addChild on a primitive type AllergyIntolerance.reaction.severity");
            }
            if (name.equals("exposureRoute")) {
                this.exposureRoute = new CodeableConcept();
                return this.exposureRoute;
            }
            if (name.equals("note")) {
                return this.addNote();
            }
            return super.addChild(name);
        }

        @Override
        public AllergyIntoleranceReactionComponent copy() {
            AllergyIntoleranceReactionComponent dst = new AllergyIntoleranceReactionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AllergyIntoleranceReactionComponent dst) {
            super.copyValues(dst);
            CodeableConcept codeableConcept = dst.substance = this.substance == null ? null : this.substance.copy();
            if (this.manifestation != null) {
                dst.manifestation = new ArrayList<CodeableReference>();
                for (CodeableReference codeableReference : this.manifestation) {
                    dst.manifestation.add(codeableReference.copy());
                }
            }
            dst.description = this.description == null ? null : this.description.copy();
            dst.onset = this.onset == null ? null : this.onset.copy();
            dst.severity = this.severity == null ? null : this.severity.copy();
            CodeableConcept codeableConcept2 = dst.exposureRoute = this.exposureRoute == null ? null : this.exposureRoute.copy();
            if (this.note != null) {
                dst.note = new ArrayList<Annotation>();
                for (Annotation annotation : this.note) {
                    dst.note.add(annotation.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AllergyIntoleranceReactionComponent)) {
                return false;
            }
            AllergyIntoleranceReactionComponent o = (AllergyIntoleranceReactionComponent)other_;
            return AllergyIntoleranceReactionComponent.compareDeep(this.substance, o.substance, true) && AllergyIntoleranceReactionComponent.compareDeep(this.manifestation, o.manifestation, true) && AllergyIntoleranceReactionComponent.compareDeep(this.description, o.description, true) && AllergyIntoleranceReactionComponent.compareDeep(this.onset, o.onset, true) && AllergyIntoleranceReactionComponent.compareDeep(this.severity, o.severity, true) && AllergyIntoleranceReactionComponent.compareDeep(this.exposureRoute, o.exposureRoute, true) && AllergyIntoleranceReactionComponent.compareDeep(this.note, o.note, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AllergyIntoleranceReactionComponent)) {
                return false;
            }
            AllergyIntoleranceReactionComponent o = (AllergyIntoleranceReactionComponent)other_;
            return AllergyIntoleranceReactionComponent.compareValues(this.description, o.description, true) && AllergyIntoleranceReactionComponent.compareValues(this.onset, o.onset, true) && AllergyIntoleranceReactionComponent.compareValues(this.severity, o.severity, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.substance, this.manifestation, this.description, this.onset, this.severity, this.exposureRoute, this.note);
        }

        @Override
        public String fhirType() {
            return "AllergyIntolerance.reaction";
        }
    }

    @Block
    public static class AllergyIntoleranceParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of involvement", formalDefinition="Distinguishes the type of involvement of the actor in the activities related to the allergy or intolerance.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/participation-role-type")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Patient.class, RelatedPerson.class, Device.class, Organization.class, CareTeam.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who or what participated in the activities related to the allergy or intolerance", formalDefinition="Indicates who or what participated in the activities related to the allergy or intolerance.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public AllergyIntoleranceParticipantComponent() {
        }

        public AllergyIntoleranceParticipantComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceParticipantComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public AllergyIntoleranceParticipantComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AllergyIntoleranceParticipantComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public AllergyIntoleranceParticipantComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the actor in the activities related to the allergy or intolerance.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Device|Organization|CareTeam)", "Indicates who or what participated in the activities related to the allergy or intolerance.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the actor in the activities related to the allergy or intolerance.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Patient|RelatedPerson|Device|Organization|CareTeam)", "Indicates who or what participated in the activities related to the allergy or intolerance.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public AllergyIntoleranceParticipantComponent copy() {
            AllergyIntoleranceParticipantComponent dst = new AllergyIntoleranceParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AllergyIntoleranceParticipantComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AllergyIntoleranceParticipantComponent)) {
                return false;
            }
            AllergyIntoleranceParticipantComponent o = (AllergyIntoleranceParticipantComponent)other_;
            return AllergyIntoleranceParticipantComponent.compareDeep(this.function, o.function, true) && AllergyIntoleranceParticipantComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AllergyIntoleranceParticipantComponent)) {
                return false;
            }
            AllergyIntoleranceParticipantComponent o = (AllergyIntoleranceParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.function, this.actor);
        }

        @Override
        public String fhirType() {
            return "AllergyIntolerance.participant";
        }
    }

    public static class AllergyIntoleranceSeverityEnumFactory
    implements EnumFactory<AllergyIntoleranceSeverity> {
        @Override
        public AllergyIntoleranceSeverity fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("mild".equals(codeString)) {
                return AllergyIntoleranceSeverity.MILD;
            }
            if ("moderate".equals(codeString)) {
                return AllergyIntoleranceSeverity.MODERATE;
            }
            if ("severe".equals(codeString)) {
                return AllergyIntoleranceSeverity.SEVERE;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceSeverity code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceSeverity> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.NULL, code);
            }
            if ("mild".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.MILD, code);
            }
            if ("moderate".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.MODERATE, code);
            }
            if ("severe".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceSeverity>(this, AllergyIntoleranceSeverity.SEVERE, code);
            }
            throw new FHIRException("Unknown AllergyIntoleranceSeverity code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceSeverity code) {
            if (code == AllergyIntoleranceSeverity.MILD) {
                return "mild";
            }
            if (code == AllergyIntoleranceSeverity.MODERATE) {
                return "moderate";
            }
            if (code == AllergyIntoleranceSeverity.SEVERE) {
                return "severe";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceSeverity code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceSeverity {
        MILD,
        MODERATE,
        SEVERE,
        NULL;


        public static AllergyIntoleranceSeverity fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("mild".equals(codeString)) {
                return MILD;
            }
            if ("moderate".equals(codeString)) {
                return MODERATE;
            }
            if ("severe".equals(codeString)) {
                return SEVERE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AllergyIntoleranceSeverity code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MILD: {
                    return "mild";
                }
                case MODERATE: {
                    return "moderate";
                }
                case SEVERE: {
                    return "severe";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MILD: {
                    return "http://hl7.org/fhir/reaction-event-severity";
                }
                case MODERATE: {
                    return "http://hl7.org/fhir/reaction-event-severity";
                }
                case SEVERE: {
                    return "http://hl7.org/fhir/reaction-event-severity";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MILD: {
                    return "Causes mild physiological effects.";
                }
                case MODERATE: {
                    return "Causes moderate physiological effects.";
                }
                case SEVERE: {
                    return "Causes severe physiological effects.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MILD: {
                    return "Mild";
                }
                case MODERATE: {
                    return "Moderate";
                }
                case SEVERE: {
                    return "Severe";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceCriticalityEnumFactory
    implements EnumFactory<AllergyIntoleranceCriticality> {
        @Override
        public AllergyIntoleranceCriticality fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("low".equals(codeString)) {
                return AllergyIntoleranceCriticality.LOW;
            }
            if ("high".equals(codeString)) {
                return AllergyIntoleranceCriticality.HIGH;
            }
            if ("unable-to-assess".equals(codeString)) {
                return AllergyIntoleranceCriticality.UNABLETOASSESS;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceCriticality code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceCriticality> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.NULL, code);
            }
            if ("low".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.LOW, code);
            }
            if ("high".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.HIGH, code);
            }
            if ("unable-to-assess".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCriticality>(this, AllergyIntoleranceCriticality.UNABLETOASSESS, code);
            }
            throw new FHIRException("Unknown AllergyIntoleranceCriticality code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceCriticality code) {
            if (code == AllergyIntoleranceCriticality.LOW) {
                return "low";
            }
            if (code == AllergyIntoleranceCriticality.HIGH) {
                return "high";
            }
            if (code == AllergyIntoleranceCriticality.UNABLETOASSESS) {
                return "unable-to-assess";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceCriticality code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceCriticality {
        LOW,
        HIGH,
        UNABLETOASSESS,
        NULL;


        public static AllergyIntoleranceCriticality fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("low".equals(codeString)) {
                return LOW;
            }
            if ("high".equals(codeString)) {
                return HIGH;
            }
            if ("unable-to-assess".equals(codeString)) {
                return UNABLETOASSESS;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AllergyIntoleranceCriticality code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case LOW: {
                    return "low";
                }
                case HIGH: {
                    return "high";
                }
                case UNABLETOASSESS: {
                    return "unable-to-assess";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case LOW: {
                    return "http://hl7.org/fhir/allergy-intolerance-criticality";
                }
                case HIGH: {
                    return "http://hl7.org/fhir/allergy-intolerance-criticality";
                }
                case UNABLETOASSESS: {
                    return "http://hl7.org/fhir/allergy-intolerance-criticality";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case LOW: {
                    return "Worst case result of a future exposure is not assessed to be life-threatening or having high potential for organ system failure.";
                }
                case HIGH: {
                    return "Worst case result of a future exposure is assessed to be life-threatening or having high potential for organ system failure.";
                }
                case UNABLETOASSESS: {
                    return "Unable to assess the worst case result of a future exposure.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case LOW: {
                    return "Low Risk";
                }
                case HIGH: {
                    return "High Risk";
                }
                case UNABLETOASSESS: {
                    return "Unable to Assess Risk";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class AllergyIntoleranceCategoryEnumFactory
    implements EnumFactory<AllergyIntoleranceCategory> {
        @Override
        public AllergyIntoleranceCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("food".equals(codeString)) {
                return AllergyIntoleranceCategory.FOOD;
            }
            if ("medication".equals(codeString)) {
                return AllergyIntoleranceCategory.MEDICATION;
            }
            if ("environment".equals(codeString)) {
                return AllergyIntoleranceCategory.ENVIRONMENT;
            }
            if ("biologic".equals(codeString)) {
                return AllergyIntoleranceCategory.BIOLOGIC;
            }
            throw new IllegalArgumentException("Unknown AllergyIntoleranceCategory code '" + codeString + "'");
        }

        public Enumeration<AllergyIntoleranceCategory> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.NULL, code);
            }
            if ("food".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.FOOD, code);
            }
            if ("medication".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.MEDICATION, code);
            }
            if ("environment".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.ENVIRONMENT, code);
            }
            if ("biologic".equals(codeString)) {
                return new Enumeration<AllergyIntoleranceCategory>(this, AllergyIntoleranceCategory.BIOLOGIC, code);
            }
            throw new FHIRException("Unknown AllergyIntoleranceCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(AllergyIntoleranceCategory code) {
            if (code == AllergyIntoleranceCategory.FOOD) {
                return "food";
            }
            if (code == AllergyIntoleranceCategory.MEDICATION) {
                return "medication";
            }
            if (code == AllergyIntoleranceCategory.ENVIRONMENT) {
                return "environment";
            }
            if (code == AllergyIntoleranceCategory.BIOLOGIC) {
                return "biologic";
            }
            return "?";
        }

        @Override
        public String toSystem(AllergyIntoleranceCategory code) {
            return code.getSystem();
        }
    }

    public static enum AllergyIntoleranceCategory {
        FOOD,
        MEDICATION,
        ENVIRONMENT,
        BIOLOGIC,
        NULL;


        public static AllergyIntoleranceCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("food".equals(codeString)) {
                return FOOD;
            }
            if ("medication".equals(codeString)) {
                return MEDICATION;
            }
            if ("environment".equals(codeString)) {
                return ENVIRONMENT;
            }
            if ("biologic".equals(codeString)) {
                return BIOLOGIC;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown AllergyIntoleranceCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case FOOD: {
                    return "food";
                }
                case MEDICATION: {
                    return "medication";
                }
                case ENVIRONMENT: {
                    return "environment";
                }
                case BIOLOGIC: {
                    return "biologic";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case FOOD: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case MEDICATION: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case ENVIRONMENT: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case BIOLOGIC: {
                    return "http://hl7.org/fhir/allergy-intolerance-category";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case FOOD: {
                    return "Any substance consumed to provide nutritional support for the body.";
                }
                case MEDICATION: {
                    return "Substances administered to achieve a physiological effect.";
                }
                case ENVIRONMENT: {
                    return "Any substances that are encountered in the environment, including any substance not already classified as food, medication, or biologic.";
                }
                case BIOLOGIC: {
                    return "A preparation that is synthesized from living organisms or their products, especially a human or animal protein, such as a hormone or antitoxin, that is used as a diagnostic, preventive, or therapeutic agent. Examples of biologic medications include: vaccines; allergenic extracts, which are used for both diagnosis and treatment (for example, allergy shots); gene therapies; cellular therapies.  There are other biologic products, such as tissues, which are not typically associated with allergies.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case FOOD: {
                    return "Food";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case ENVIRONMENT: {
                    return "Environment";
                }
                case BIOLOGIC: {
                    return "Biologic";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

