/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.formats;

import org.hl7.fhir.r5.formats.RdfParserBase;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Availability;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Contributor;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.Distance;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.MonetaryComponent;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Population;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.ProductShelfLife;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.RatioRange;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VirtualServiceDetail;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.turtle.Turtle;

public class RdfParser
extends RdfParserBase {
    public RdfParser() {
    }

    public RdfParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    private void composeEnum(Turtle.Complex parent, String parentType, String name, Enumeration<? extends Enum> value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
        this.decorateCode(t, value);
    }

    protected void composeDate(Turtle.Complex parent, String parentType, String name, DateType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeDateTime(Turtle.Complex parent, String parentType, String name, DateTimeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeCode(Turtle.Complex parent, String parentType, String name, CodeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
        this.decorateCode(t, value);
    }

    protected void composeString(Turtle.Complex parent, String parentType, String name, StringType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInteger(Turtle.Complex parent, String parentType, String name, IntegerType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInteger64(Turtle.Complex parent, String parentType, String name, Integer64Type value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeOid(Turtle.Complex parent, String parentType, String name, OidType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeCanonical(Turtle.Complex parent, String parentType, String name, CanonicalType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUri(Turtle.Complex parent, String parentType, String name, UriType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUuid(Turtle.Complex parent, String parentType, String name, UuidType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUrl(Turtle.Complex parent, String parentType, String name, UrlType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeInstant(Turtle.Complex parent, String parentType, String name, InstantType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBoolean(Turtle.Complex parent, String parentType, String name, BooleanType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBase64Binary(Turtle.Complex parent, String parentType, String name, Base64BinaryType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeUnsignedInt(Turtle.Complex parent, String parentType, String name, UnsignedIntType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeMarkdown(Turtle.Complex parent, String parentType, String name, MarkdownType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeTime(Turtle.Complex parent, String parentType, String name, TimeType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeId(Turtle.Complex parent, String parentType, String name, IdType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composePositiveInt(Turtle.Complex parent, String parentType, String name, PositiveIntType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeDecimal(Turtle.Complex parent, String parentType, String name, DecimalType value, int index) {
        if (value == null) {
            return;
        }
        Turtle.Complex t = parent.predicate("fhir:" + parentType + "." + name);
        t.predicate("fhir:value", this.ttlLiteral(value.asStringValue()));
        this.composeElement(t, parentType, name, value, index);
    }

    protected void composeBackboneElement(Turtle.Complex t, String parentType, String name, BackboneElement element, int index) {
        this.composeElement(t, parentType, name, element, index);
        for (int i2 = 0; i2 < element.getModifierExtension().size(); ++i2) {
            this.composeExtension(t, "BackboneElement", "modifierExtension", element.getModifierExtension().get(i2), i2);
        }
    }

    protected void composeBackboneType(Turtle.Complex t, String parentType, String name, BackboneType element, int index) {
        this.composeDataType(t, parentType, name, element, index);
        for (int i2 = 0; i2 < element.getModifierExtension().size(); ++i2) {
            this.composeExtension(t, "BackboneType", "modifierExtension", element.getModifierExtension().get(i2), i2);
        }
    }

    protected void composeDataType(Turtle.Complex t, String parentType, String name, DataType element, int index) {
        this.composeElement(t, parentType, name, element, index);
    }

    protected void composeElement(Turtle.Complex t, String parentType, String name, Element element, int index) {
        this.composeBase(t, parentType, name, element, index);
        if (element.hasIdElement()) {
            this.composeString(t, "Element", "id", element.getIdElement(), -1);
        }
        for (int i2 = 0; i2 < element.getExtension().size(); ++i2) {
            this.composeExtension(t, "Element", "extension", element.getExtension().get(i2), i2);
        }
    }

    protected void composeAddress(Turtle.Complex parent, String parentType, String name, Address element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Address", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "Address", "use", element.getUseElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Address", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Address", "text", element.getTextElement(), -1);
        }
        for (int i2 = 0; i2 < element.getLine().size(); ++i2) {
            this.composeString(t, "Address", "line", element.getLine().get(i2), i2);
        }
        if (element.hasCityElement()) {
            this.composeString(t, "Address", "city", element.getCityElement(), -1);
        }
        if (element.hasDistrictElement()) {
            this.composeString(t, "Address", "district", element.getDistrictElement(), -1);
        }
        if (element.hasStateElement()) {
            this.composeString(t, "Address", "state", element.getStateElement(), -1);
        }
        if (element.hasPostalCodeElement()) {
            this.composeString(t, "Address", "postalCode", element.getPostalCodeElement(), -1);
        }
        if (element.hasCountryElement()) {
            this.composeString(t, "Address", "country", element.getCountryElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Address", "period", element.getPeriod(), -1);
        }
    }

    protected void composeAge(Turtle.Complex parent, String parentType, String name, Age element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeQuantity(t, "Age", name, element, index);
    }

    protected void composeAnnotation(Turtle.Complex parent, String parentType, String name, Annotation element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Annotation", name, element, index);
        if (element.hasAuthor()) {
            this.composeType(t, "Annotation", "author", element.getAuthor(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "Annotation", "time", element.getTimeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeMarkdown(t, "Annotation", "text", element.getTextElement(), -1);
        }
    }

    protected void composeAttachment(Turtle.Complex parent, String parentType, String name, Attachment element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Attachment", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Attachment", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Attachment", "language", element.getLanguageElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Attachment", "data", element.getDataElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "Attachment", "url", element.getUrlElement(), -1);
        }
        if (element.hasSizeElement()) {
            this.composeInteger64(t, "Attachment", "size", element.getSizeElement(), -1);
        }
        if (element.hasHashElement()) {
            this.composeBase64Binary(t, "Attachment", "hash", element.getHashElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Attachment", "title", element.getTitleElement(), -1);
        }
        if (element.hasCreationElement()) {
            this.composeDateTime(t, "Attachment", "creation", element.getCreationElement(), -1);
        }
        if (element.hasHeightElement()) {
            this.composePositiveInt(t, "Attachment", "height", element.getHeightElement(), -1);
        }
        if (element.hasWidthElement()) {
            this.composePositiveInt(t, "Attachment", "width", element.getWidthElement(), -1);
        }
        if (element.hasFramesElement()) {
            this.composePositiveInt(t, "Attachment", "frames", element.getFramesElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeDecimal(t, "Attachment", "duration", element.getDurationElement(), -1);
        }
        if (element.hasPagesElement()) {
            this.composePositiveInt(t, "Attachment", "pages", element.getPagesElement(), -1);
        }
    }

    protected void composeAvailability(Turtle.Complex parent, String parentType, String name, Availability element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Availability", name, element, index);
        for (i2 = 0; i2 < element.getAvailableTime().size(); ++i2) {
            this.composeAvailabilityAvailableTimeComponent(t, "Availability", "availableTime", element.getAvailableTime().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNotAvailableTime().size(); ++i2) {
            this.composeAvailabilityNotAvailableTimeComponent(t, "Availability", "notAvailableTime", element.getNotAvailableTime().get(i2), i2);
        }
    }

    protected void composeAvailabilityAvailableTimeComponent(Turtle.Complex parent, String parentType, String name, Availability.AvailabilityAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "availableTime", name, element, index);
        for (int i2 = 0; i2 < element.getDaysOfWeek().size(); ++i2) {
            this.composeEnum(t, "AvailabilityAvailableTimeComponent", "daysOfWeek", element.getDaysOfWeek().get(i2), i2);
        }
        if (element.hasAllDayElement()) {
            this.composeBoolean(t, "AvailabilityAvailableTimeComponent", "allDay", element.getAllDayElement(), -1);
        }
        if (element.hasAvailableStartTimeElement()) {
            this.composeTime(t, "AvailabilityAvailableTimeComponent", "availableStartTime", element.getAvailableStartTimeElement(), -1);
        }
        if (element.hasAvailableEndTimeElement()) {
            this.composeTime(t, "AvailabilityAvailableTimeComponent", "availableEndTime", element.getAvailableEndTimeElement(), -1);
        }
    }

    protected void composeAvailabilityNotAvailableTimeComponent(Turtle.Complex parent, String parentType, String name, Availability.AvailabilityNotAvailableTimeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "notAvailableTime", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "AvailabilityNotAvailableTimeComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasDuring()) {
            this.composePeriod(t, "AvailabilityNotAvailableTimeComponent", "during", element.getDuring(), -1);
        }
    }

    protected void composeCodeableConcept(Turtle.Complex parent, String parentType, String name, CodeableConcept element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "CodeableConcept", name, element, index);
        this.decorateCodeableConcept(t, element);
        for (int i2 = 0; i2 < element.getCoding().size(); ++i2) {
            this.composeCoding(t, "CodeableConcept", "coding", element.getCoding().get(i2), i2);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "CodeableConcept", "text", element.getTextElement(), -1);
        }
    }

    protected void composeCodeableReference(Turtle.Complex parent, String parentType, String name, CodeableReference element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "CodeableReference", name, element, index);
        if (element.hasConcept()) {
            this.composeCodeableConcept(t, "CodeableReference", "concept", element.getConcept(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "CodeableReference", "reference", element.getReference(), -1);
        }
    }

    protected void composeCoding(Turtle.Complex parent, String parentType, String name, Coding element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Coding", name, element, index);
        this.decorateCoding(t, element);
        if (element.hasSystemElement()) {
            this.composeUri(t, "Coding", "system", element.getSystemElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Coding", "version", element.getVersionElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "Coding", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Coding", "display", element.getDisplayElement(), -1);
        }
        if (element.hasUserSelectedElement()) {
            this.composeBoolean(t, "Coding", "userSelected", element.getUserSelectedElement(), -1);
        }
    }

    protected void composeContactDetail(Turtle.Complex parent, String parentType, String name, ContactDetail element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "ContactDetail", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ContactDetail", "name", element.getNameElement(), -1);
        }
        for (int i2 = 0; i2 < element.getTelecom().size(); ++i2) {
            this.composeContactPoint(t, "ContactDetail", "telecom", element.getTelecom().get(i2), i2);
        }
    }

    protected void composeContactPoint(Turtle.Complex parent, String parentType, String name, ContactPoint element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "ContactPoint", name, element, index);
        if (element.hasSystemElement()) {
            this.composeEnum(t, "ContactPoint", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ContactPoint", "value", element.getValueElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ContactPoint", "use", element.getUseElement(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "ContactPoint", "rank", element.getRankElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ContactPoint", "period", element.getPeriod(), -1);
        }
    }

    protected void composeContributor(Turtle.Complex parent, String parentType, String name, Contributor element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Contributor", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Contributor", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Contributor", "name", element.getNameElement(), -1);
        }
        for (int i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "Contributor", "contact", element.getContact().get(i2), i2);
        }
    }

    protected void composeCount(Turtle.Complex parent, String parentType, String name, Count element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeQuantity(t, "Count", name, element, index);
    }

    protected void composeDataRequirement(Turtle.Complex parent, String parentType, String name, DataRequirement element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "DataRequirement", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DataRequirement", "type", element.getTypeElement(), -1);
        }
        for (i2 = 0; i2 < element.getProfile().size(); ++i2) {
            this.composeCanonical(t, "DataRequirement", "profile", element.getProfile().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeType(t, "DataRequirement", "subject", element.getSubject(), -1);
        }
        for (i2 = 0; i2 < element.getMustSupport().size(); ++i2) {
            this.composeString(t, "DataRequirement", "mustSupport", element.getMustSupport().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCodeFilter().size(); ++i2) {
            this.composeDataRequirementCodeFilterComponent(t, "DataRequirement", "codeFilter", element.getCodeFilter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDateFilter().size(); ++i2) {
            this.composeDataRequirementDateFilterComponent(t, "DataRequirement", "dateFilter", element.getDateFilter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getValueFilter().size(); ++i2) {
            this.composeDataRequirementValueFilterComponent(t, "DataRequirement", "valueFilter", element.getValueFilter().get(i2), i2);
        }
        if (element.hasLimitElement()) {
            this.composePositiveInt(t, "DataRequirement", "limit", element.getLimitElement(), -1);
        }
        for (i2 = 0; i2 < element.getSort().size(); ++i2) {
            this.composeDataRequirementSortComponent(t, "DataRequirement", "sort", element.getSort().get(i2), i2);
        }
    }

    protected void composeDataRequirementCodeFilterComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementCodeFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "codeFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirementCodeFilterComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasSearchParamElement()) {
            this.composeString(t, "DataRequirementCodeFilterComponent", "searchParam", element.getSearchParamElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "DataRequirementCodeFilterComponent", "valueSet", element.getValueSetElement(), -1);
        }
        for (int i2 = 0; i2 < element.getCode().size(); ++i2) {
            this.composeCoding(t, "DataRequirementCodeFilterComponent", "code", element.getCode().get(i2), i2);
        }
    }

    protected void composeDataRequirementDateFilterComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementDateFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "dateFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirementDateFilterComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasSearchParamElement()) {
            this.composeString(t, "DataRequirementDateFilterComponent", "searchParam", element.getSearchParamElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DataRequirementDateFilterComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeDataRequirementValueFilterComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementValueFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "valueFilter", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirementValueFilterComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasSearchParamElement()) {
            this.composeString(t, "DataRequirementValueFilterComponent", "searchParam", element.getSearchParamElement(), -1);
        }
        if (element.hasComparatorElement()) {
            this.composeEnum(t, "DataRequirementValueFilterComponent", "comparator", element.getComparatorElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DataRequirementValueFilterComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeDataRequirementSortComponent(Turtle.Complex parent, String parentType, String name, DataRequirement.DataRequirementSortComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "sort", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "DataRequirementSortComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasDirectionElement()) {
            this.composeEnum(t, "DataRequirementSortComponent", "direction", element.getDirectionElement(), -1);
        }
    }

    protected void composeDistance(Turtle.Complex parent, String parentType, String name, Distance element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeQuantity(t, "Distance", name, element, index);
    }

    protected void composeDosage(Turtle.Complex parent, String parentType, String name, Dosage element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "Dosage", name, element, index);
        if (element.hasSequenceElement()) {
            this.composeInteger(t, "Dosage", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "Dosage", "text", element.getTextElement(), -1);
        }
        for (i2 = 0; i2 < element.getAdditionalInstruction().size(); ++i2) {
            this.composeCodeableConcept(t, "Dosage", "additionalInstruction", element.getAdditionalInstruction().get(i2), i2);
        }
        if (element.hasPatientInstructionElement()) {
            this.composeString(t, "Dosage", "patientInstruction", element.getPatientInstructionElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeTiming(t, "Dosage", "timing", element.getTiming(), -1);
        }
        if (element.hasAsNeededElement()) {
            this.composeBoolean(t, "Dosage", "asNeeded", element.getAsNeededElement(), -1);
        }
        for (i2 = 0; i2 < element.getAsNeededFor().size(); ++i2) {
            this.composeCodeableConcept(t, "Dosage", "asNeededFor", element.getAsNeededFor().get(i2), i2);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "Dosage", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "Dosage", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Dosage", "method", element.getMethod(), -1);
        }
        for (i2 = 0; i2 < element.getDoseAndRate().size(); ++i2) {
            this.composeDosageDoseAndRateComponent(t, "Dosage", "doseAndRate", element.getDoseAndRate().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMaxDosePerPeriod().size(); ++i2) {
            this.composeRatio(t, "Dosage", "maxDosePerPeriod", element.getMaxDosePerPeriod().get(i2), i2);
        }
        if (element.hasMaxDosePerAdministration()) {
            this.composeQuantity(t, "Dosage", "maxDosePerAdministration", element.getMaxDosePerAdministration(), -1);
        }
        if (element.hasMaxDosePerLifetime()) {
            this.composeQuantity(t, "Dosage", "maxDosePerLifetime", element.getMaxDosePerLifetime(), -1);
        }
    }

    protected void composeDosageDoseAndRateComponent(Turtle.Complex parent, String parentType, String name, Dosage.DosageDoseAndRateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "doseAndRate", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DosageDoseAndRateComponent", "type", element.getType(), -1);
        }
        if (element.hasDose()) {
            this.composeType(t, "DosageDoseAndRateComponent", "dose", element.getDose(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "DosageDoseAndRateComponent", "rate", element.getRate(), -1);
        }
    }

    protected void composeDuration(Turtle.Complex parent, String parentType, String name, Duration element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeQuantity(t, "Duration", name, element, index);
    }

    protected void composeElementDefinition(Turtle.Complex parent, String parentType, String name, ElementDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "ElementDefinition", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinition", "path", element.getPathElement(), -1);
        }
        for (i2 = 0; i2 < element.getRepresentation().size(); ++i2) {
            this.composeEnum(t, "ElementDefinition", "representation", element.getRepresentation().get(i2), i2);
        }
        if (element.hasSliceNameElement()) {
            this.composeString(t, "ElementDefinition", "sliceName", element.getSliceNameElement(), -1);
        }
        if (element.hasSliceIsConstrainingElement()) {
            this.composeBoolean(t, "ElementDefinition", "sliceIsConstraining", element.getSliceIsConstrainingElement(), -1);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "ElementDefinition", "label", element.getLabelElement(), -1);
        }
        for (i2 = 0; i2 < element.getCode().size(); ++i2) {
            this.composeCoding(t, "ElementDefinition", "code", element.getCode().get(i2), i2);
        }
        if (element.hasSlicing()) {
            this.composeElementDefinitionSlicingComponent(t, "ElementDefinition", "slicing", element.getSlicing(), -1);
        }
        if (element.hasShortElement()) {
            this.composeString(t, "ElementDefinition", "short", element.getShortElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeMarkdown(t, "ElementDefinition", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "ElementDefinition", "comment", element.getCommentElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeMarkdown(t, "ElementDefinition", "requirements", element.getRequirementsElement(), -1);
        }
        for (i2 = 0; i2 < element.getAlias().size(); ++i2) {
            this.composeString(t, "ElementDefinition", "alias", element.getAlias().get(i2), i2);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "ElementDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ElementDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasBase()) {
            this.composeElementDefinitionBaseComponent(t, "ElementDefinition", "base", element.getBase(), -1);
        }
        if (element.hasContentReferenceElement()) {
            this.composeUri(t, "ElementDefinition", "contentReference", element.getContentReferenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeElementDefinitionTypeRefComponent(t, "ElementDefinition", "type", element.getType().get(i2), i2);
        }
        if (element.hasDefaultValue()) {
            this.composeType(t, "ElementDefinition", "defaultValue", element.getDefaultValue(), -1);
        }
        if (element.hasMeaningWhenMissingElement()) {
            this.composeMarkdown(t, "ElementDefinition", "meaningWhenMissing", element.getMeaningWhenMissingElement(), -1);
        }
        if (element.hasOrderMeaningElement()) {
            this.composeString(t, "ElementDefinition", "orderMeaning", element.getOrderMeaningElement(), -1);
        }
        if (element.hasFixed()) {
            this.composeType(t, "ElementDefinition", "fixed", element.getFixed(), -1);
        }
        if (element.hasPattern()) {
            this.composeType(t, "ElementDefinition", "pattern", element.getPattern(), -1);
        }
        for (i2 = 0; i2 < element.getExample().size(); ++i2) {
            this.composeElementDefinitionExampleComponent(t, "ElementDefinition", "example", element.getExample().get(i2), i2);
        }
        if (element.hasMinValue()) {
            this.composeType(t, "ElementDefinition", "minValue", element.getMinValue(), -1);
        }
        if (element.hasMaxValue()) {
            this.composeType(t, "ElementDefinition", "maxValue", element.getMaxValue(), -1);
        }
        if (element.hasMaxLengthElement()) {
            this.composeInteger(t, "ElementDefinition", "maxLength", element.getMaxLengthElement(), -1);
        }
        for (i2 = 0; i2 < element.getCondition().size(); ++i2) {
            this.composeId(t, "ElementDefinition", "condition", element.getCondition().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getConstraint().size(); ++i2) {
            this.composeElementDefinitionConstraintComponent(t, "ElementDefinition", "constraint", element.getConstraint().get(i2), i2);
        }
        if (element.hasMustHaveValueElement()) {
            this.composeBoolean(t, "ElementDefinition", "mustHaveValue", element.getMustHaveValueElement(), -1);
        }
        for (i2 = 0; i2 < element.getValueAlternatives().size(); ++i2) {
            this.composeCanonical(t, "ElementDefinition", "valueAlternatives", element.getValueAlternatives().get(i2), i2);
        }
        if (element.hasMustSupportElement()) {
            this.composeBoolean(t, "ElementDefinition", "mustSupport", element.getMustSupportElement(), -1);
        }
        for (i2 = 0; i2 < element.getObligation().size(); ++i2) {
            this.composeElementDefinitionObligationComponent(t, "ElementDefinition", "obligation", element.getObligation().get(i2), i2);
        }
        if (element.hasIsModifierElement()) {
            this.composeBoolean(t, "ElementDefinition", "isModifier", element.getIsModifierElement(), -1);
        }
        if (element.hasIsModifierReasonElement()) {
            this.composeString(t, "ElementDefinition", "isModifierReason", element.getIsModifierReasonElement(), -1);
        }
        if (element.hasIsSummaryElement()) {
            this.composeBoolean(t, "ElementDefinition", "isSummary", element.getIsSummaryElement(), -1);
        }
        if (element.hasBinding()) {
            this.composeElementDefinitionBindingComponent(t, "ElementDefinition", "binding", element.getBinding(), -1);
        }
        for (i2 = 0; i2 < element.getMapping().size(); ++i2) {
            this.composeElementDefinitionMappingComponent(t, "ElementDefinition", "mapping", element.getMapping().get(i2), i2);
        }
    }

    protected void composeElementDefinitionSlicingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "slicing", name, element, index);
        for (int i2 = 0; i2 < element.getDiscriminator().size(); ++i2) {
            this.composeElementDefinitionSlicingDiscriminatorComponent(t, "ElementDefinitionSlicingComponent", "discriminator", element.getDiscriminator().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ElementDefinitionSlicingComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasOrderedElement()) {
            this.composeBoolean(t, "ElementDefinitionSlicingComponent", "ordered", element.getOrderedElement(), -1);
        }
        if (element.hasRulesElement()) {
            this.composeEnum(t, "ElementDefinitionSlicingComponent", "rules", element.getRulesElement(), -1);
        }
    }

    protected void composeElementDefinitionSlicingDiscriminatorComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "discriminator", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ElementDefinitionSlicingDiscriminatorComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinitionSlicingDiscriminatorComponent", "path", element.getPathElement(), -1);
        }
    }

    protected void composeElementDefinitionBaseComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBaseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "base", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ElementDefinitionBaseComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "ElementDefinitionBaseComponent", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ElementDefinitionBaseComponent", "max", element.getMaxElement(), -1);
        }
    }

    protected void composeElementDefinitionTypeRefComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.TypeRefComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "type", name, element, index);
        if (element.hasCodeElement()) {
            this.composeUri(t, "TypeRefComponent", "code", element.getCodeElement(), -1);
        }
        for (i2 = 0; i2 < element.getProfile().size(); ++i2) {
            this.composeCanonical(t, "TypeRefComponent", "profile", element.getProfile().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTargetProfile().size(); ++i2) {
            this.composeCanonical(t, "TypeRefComponent", "targetProfile", element.getTargetProfile().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAggregation().size(); ++i2) {
            this.composeEnum(t, "TypeRefComponent", "aggregation", element.getAggregation().get(i2), i2);
        }
        if (element.hasVersioningElement()) {
            this.composeEnum(t, "TypeRefComponent", "versioning", element.getVersioningElement(), -1);
        }
    }

    protected void composeElementDefinitionExampleComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionExampleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "example", name, element, index);
        if (element.hasLabelElement()) {
            this.composeString(t, "ElementDefinitionExampleComponent", "label", element.getLabelElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ElementDefinitionExampleComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeElementDefinitionConstraintComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionConstraintComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "constraint", name, element, index);
        if (element.hasKeyElement()) {
            this.composeId(t, "ElementDefinitionConstraintComponent", "key", element.getKeyElement(), -1);
        }
        if (element.hasRequirementsElement()) {
            this.composeMarkdown(t, "ElementDefinitionConstraintComponent", "requirements", element.getRequirementsElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "ElementDefinitionConstraintComponent", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasSuppressElement()) {
            this.composeBoolean(t, "ElementDefinitionConstraintComponent", "suppress", element.getSuppressElement(), -1);
        }
        if (element.hasHumanElement()) {
            this.composeString(t, "ElementDefinitionConstraintComponent", "human", element.getHumanElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "ElementDefinitionConstraintComponent", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeCanonical(t, "ElementDefinitionConstraintComponent", "source", element.getSourceElement(), -1);
        }
    }

    protected void composeElementDefinitionObligationComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionObligationComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "obligation", name, element, index);
        if (element.hasCode()) {
            this.composeCoding(t, "ElementDefinitionObligationComponent", "code", element.getCode(), -1);
        }
        for (i2 = 0; i2 < element.getActor().size(); ++i2) {
            this.composeCanonical(t, "ElementDefinitionObligationComponent", "actor", element.getActor().get(i2), i2);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "ElementDefinitionObligationComponent", "documentation", element.getDocumentationElement(), -1);
        }
        for (i2 = 0; i2 < element.getUsage().size(); ++i2) {
            this.composeUsageContext(t, "ElementDefinitionObligationComponent", "usage", element.getUsage().get(i2), i2);
        }
        if (element.hasFilterElement()) {
            this.composeString(t, "ElementDefinitionObligationComponent", "filter", element.getFilterElement(), -1);
        }
        if (element.hasFilterDocumentationElement()) {
            this.composeString(t, "ElementDefinitionObligationComponent", "filterDocumentation", element.getFilterDocumentationElement(), -1);
        }
        for (i2 = 0; i2 < element.getProcess().size(); ++i2) {
            this.composeUri(t, "ElementDefinitionObligationComponent", "process", element.getProcess().get(i2), i2);
        }
    }

    protected void composeElementDefinitionBindingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "binding", name, element, index);
        if (element.hasStrengthElement()) {
            this.composeEnum(t, "ElementDefinitionBindingComponent", "strength", element.getStrengthElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ElementDefinitionBindingComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "ElementDefinitionBindingComponent", "valueSet", element.getValueSetElement(), -1);
        }
        for (int i2 = 0; i2 < element.getAdditional().size(); ++i2) {
            this.composeElementDefinitionBindingAdditionalComponent(t, "ElementDefinitionBindingComponent", "additional", element.getAdditional().get(i2), i2);
        }
    }

    protected void composeElementDefinitionBindingAdditionalComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionBindingAdditionalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "additional", name, element, index);
        if (element.hasPurposeElement()) {
            this.composeEnum(t, "ElementDefinitionBindingAdditionalComponent", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "ElementDefinitionBindingAdditionalComponent", "valueSet", element.getValueSetElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "ElementDefinitionBindingAdditionalComponent", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasShortDocoElement()) {
            this.composeString(t, "ElementDefinitionBindingAdditionalComponent", "shortDoco", element.getShortDocoElement(), -1);
        }
        for (int i2 = 0; i2 < element.getUsage().size(); ++i2) {
            this.composeUsageContext(t, "ElementDefinitionBindingAdditionalComponent", "usage", element.getUsage().get(i2), i2);
        }
        if (element.hasAnyElement()) {
            this.composeBoolean(t, "ElementDefinitionBindingAdditionalComponent", "any", element.getAnyElement(), -1);
        }
    }

    protected void composeElementDefinitionMappingComponent(Turtle.Complex parent, String parentType, String name, ElementDefinition.ElementDefinitionMappingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "mapping", name, element, index);
        if (element.hasIdentityElement()) {
            this.composeId(t, "ElementDefinitionMappingComponent", "identity", element.getIdentityElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ElementDefinitionMappingComponent", "language", element.getLanguageElement(), -1);
        }
        if (element.hasMapElement()) {
            this.composeString(t, "ElementDefinitionMappingComponent", "map", element.getMapElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "ElementDefinitionMappingComponent", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeExpression(Turtle.Complex parent, String parentType, String name, Expression element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Expression", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Expression", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeId(t, "Expression", "name", element.getNameElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Expression", "language", element.getLanguageElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "Expression", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "Expression", "reference", element.getReferenceElement(), -1);
        }
    }

    protected void composeExtendedContactDetail(Turtle.Complex parent, String parentType, String name, ExtendedContactDetail element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "ExtendedContactDetail", name, element, index);
        if (element.hasPurpose()) {
            this.composeCodeableConcept(t, "ExtendedContactDetail", "purpose", element.getPurpose(), -1);
        }
        for (i2 = 0; i2 < element.getName().size(); ++i2) {
            this.composeHumanName(t, "ExtendedContactDetail", "name", element.getName().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTelecom().size(); ++i2) {
            this.composeContactPoint(t, "ExtendedContactDetail", "telecom", element.getTelecom().get(i2), i2);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "ExtendedContactDetail", "address", element.getAddress(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "ExtendedContactDetail", "organization", element.getOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ExtendedContactDetail", "period", element.getPeriod(), -1);
        }
    }

    protected void composeExtension(Turtle.Complex parent, String parentType, String name, Extension element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Extension", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Extension", "url", element.getUrlElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "Extension", "value", element.getValue(), -1);
        }
    }

    protected void composeHumanName(Turtle.Complex parent, String parentType, String name, HumanName element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "HumanName", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "HumanName", "use", element.getUseElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "HumanName", "text", element.getTextElement(), -1);
        }
        if (element.hasFamilyElement()) {
            this.composeString(t, "HumanName", "family", element.getFamilyElement(), -1);
        }
        for (i2 = 0; i2 < element.getGiven().size(); ++i2) {
            this.composeString(t, "HumanName", "given", element.getGiven().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPrefix().size(); ++i2) {
            this.composeString(t, "HumanName", "prefix", element.getPrefix().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSuffix().size(); ++i2) {
            this.composeString(t, "HumanName", "suffix", element.getSuffix().get(i2), i2);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "HumanName", "period", element.getPeriod(), -1);
        }
    }

    protected void composeIdentifier(Turtle.Complex parent, String parentType, String name, Identifier element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Identifier", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "Identifier", "use", element.getUseElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Identifier", "type", element.getType(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "Identifier", "system", element.getSystemElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "Identifier", "value", element.getValueElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Identifier", "period", element.getPeriod(), -1);
        }
        if (element.hasAssigner()) {
            this.composeReference(t, "Identifier", "assigner", element.getAssigner(), -1);
        }
    }

    protected void composeMarketingStatus(Turtle.Complex parent, String parentType, String name, MarketingStatus element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "MarketingStatus", name, element, index);
        if (element.hasCountry()) {
            this.composeCodeableConcept(t, "MarketingStatus", "country", element.getCountry(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "MarketingStatus", "jurisdiction", element.getJurisdiction(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MarketingStatus", "status", element.getStatus(), -1);
        }
        if (element.hasDateRange()) {
            this.composePeriod(t, "MarketingStatus", "dateRange", element.getDateRange(), -1);
        }
        if (element.hasRestoreDateElement()) {
            this.composeDateTime(t, "MarketingStatus", "restoreDate", element.getRestoreDateElement(), -1);
        }
    }

    protected void composeMeta(Turtle.Complex parent, String parentType, String name, Meta element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Meta", name, element, index);
        if (element.hasVersionIdElement()) {
            this.composeId(t, "Meta", "versionId", element.getVersionIdElement(), -1);
        }
        if (element.hasLastUpdatedElement()) {
            this.composeInstant(t, "Meta", "lastUpdated", element.getLastUpdatedElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeUri(t, "Meta", "source", element.getSourceElement(), -1);
        }
        for (i2 = 0; i2 < element.getProfile().size(); ++i2) {
            this.composeCanonical(t, "Meta", "profile", element.getProfile().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSecurity().size(); ++i2) {
            this.composeCoding(t, "Meta", "security", element.getSecurity().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTag().size(); ++i2) {
            this.composeCoding(t, "Meta", "tag", element.getTag().get(i2), i2);
        }
    }

    protected void composeMonetaryComponent(Turtle.Complex parent, String parentType, String name, MonetaryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "MonetaryComponent", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MonetaryComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MonetaryComponent", "code", element.getCode(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "MonetaryComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "MonetaryComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeMoney(Turtle.Complex parent, String parentType, String name, Money element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Money", name, element, index);
        if (element.hasValueElement()) {
            this.composeDecimal(t, "Money", "value", element.getValueElement(), -1);
        }
        if (element.hasCurrencyElement()) {
            this.composeCode(t, "Money", "currency", element.getCurrencyElement(), -1);
        }
    }

    protected void composeNarrative(Turtle.Complex parent, String parentType, String name, Narrative element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Narrative", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Narrative", "status", element.getStatusElement(), -1);
        }
        if (element.hasDiv()) {
            this.composeXhtmlNode(t, "Narrative", "div", element.getDiv(), -1);
        }
    }

    protected void composeParameterDefinition(Turtle.Complex parent, String parentType, String name, ParameterDefinition element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "ParameterDefinition", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "ParameterDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ParameterDefinition", "use", element.getUseElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "ParameterDefinition", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "ParameterDefinition", "max", element.getMaxElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "ParameterDefinition", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ParameterDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ParameterDefinition", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composePeriod(Turtle.Complex parent, String parentType, String name, Period element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Period", name, element, index);
        if (element.hasStartElement()) {
            this.composeDateTime(t, "Period", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeDateTime(t, "Period", "end", element.getEndElement(), -1);
        }
    }

    protected void composePopulation(Turtle.Complex parent, String parentType, String name, Population element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "Population", name, element, index);
        if (element.hasAge()) {
            this.composeType(t, "Population", "age", element.getAge(), -1);
        }
        if (element.hasGender()) {
            this.composeCodeableConcept(t, "Population", "gender", element.getGender(), -1);
        }
        if (element.hasRace()) {
            this.composeCodeableConcept(t, "Population", "race", element.getRace(), -1);
        }
        if (element.hasPhysiologicalCondition()) {
            this.composeCodeableConcept(t, "Population", "physiologicalCondition", element.getPhysiologicalCondition(), -1);
        }
    }

    protected void composeProductShelfLife(Turtle.Complex parent, String parentType, String name, ProductShelfLife element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "ProductShelfLife", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ProductShelfLife", "type", element.getType(), -1);
        }
        if (element.hasPeriod()) {
            this.composeType(t, "ProductShelfLife", "period", element.getPeriod(), -1);
        }
        for (int i2 = 0; i2 < element.getSpecialPrecautionsForStorage().size(); ++i2) {
            this.composeCodeableConcept(t, "ProductShelfLife", "specialPrecautionsForStorage", element.getSpecialPrecautionsForStorage().get(i2), i2);
        }
    }

    protected void composeQuantity(Turtle.Complex parent, String parentType, String name, Quantity element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Quantity", name, element, index);
        if (element.hasValueElement()) {
            this.composeDecimal(t, "Quantity", "value", element.getValueElement(), -1);
        }
        if (element.hasComparatorElement()) {
            this.composeEnum(t, "Quantity", "comparator", element.getComparatorElement(), -1);
        }
        if (element.hasUnitElement()) {
            this.composeString(t, "Quantity", "unit", element.getUnitElement(), -1);
        }
        if (element.hasSystemElement()) {
            this.composeUri(t, "Quantity", "system", element.getSystemElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "Quantity", "code", element.getCodeElement(), -1);
        }
    }

    protected void composeRange(Turtle.Complex parent, String parentType, String name, Range element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Range", name, element, index);
        if (element.hasLow()) {
            this.composeQuantity(t, "Range", "low", element.getLow(), -1);
        }
        if (element.hasHigh()) {
            this.composeQuantity(t, "Range", "high", element.getHigh(), -1);
        }
    }

    protected void composeRatio(Turtle.Complex parent, String parentType, String name, Ratio element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Ratio", name, element, index);
        if (element.hasNumerator()) {
            this.composeQuantity(t, "Ratio", "numerator", element.getNumerator(), -1);
        }
        if (element.hasDenominator()) {
            this.composeQuantity(t, "Ratio", "denominator", element.getDenominator(), -1);
        }
    }

    protected void composeRatioRange(Turtle.Complex parent, String parentType, String name, RatioRange element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "RatioRange", name, element, index);
        if (element.hasLowNumerator()) {
            this.composeQuantity(t, "RatioRange", "lowNumerator", element.getLowNumerator(), -1);
        }
        if (element.hasHighNumerator()) {
            this.composeQuantity(t, "RatioRange", "highNumerator", element.getHighNumerator(), -1);
        }
        if (element.hasDenominator()) {
            this.composeQuantity(t, "RatioRange", "denominator", element.getDenominator(), -1);
        }
    }

    protected void composeReference(Turtle.Complex parent, String parentType, String name, Reference element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Reference", name, element, index);
        if (element.hasReferenceElement()) {
            this.composeString(t, "Reference", "reference", element.getReferenceElement_(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeUri(t, "Reference", "type", element.getTypeElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Reference", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "Reference", "display", element.getDisplayElement(), -1);
        }
    }

    protected void composeRelatedArtifact(Turtle.Complex parent, String parentType, String name, RelatedArtifact element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "RelatedArtifact", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "RelatedArtifact", "type", element.getTypeElement(), -1);
        }
        for (int i2 = 0; i2 < element.getClassifier().size(); ++i2) {
            this.composeCodeableConcept(t, "RelatedArtifact", "classifier", element.getClassifier().get(i2), i2);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "RelatedArtifact", "label", element.getLabelElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "RelatedArtifact", "display", element.getDisplayElement(), -1);
        }
        if (element.hasCitationElement()) {
            this.composeMarkdown(t, "RelatedArtifact", "citation", element.getCitationElement(), -1);
        }
        if (element.hasDocument()) {
            this.composeAttachment(t, "RelatedArtifact", "document", element.getDocument(), -1);
        }
        if (element.hasResourceElement()) {
            this.composeCanonical(t, "RelatedArtifact", "resource", element.getResourceElement(), -1);
        }
        if (element.hasResourceReference()) {
            this.composeReference(t, "RelatedArtifact", "resourceReference", element.getResourceReference(), -1);
        }
        if (element.hasPublicationStatusElement()) {
            this.composeEnum(t, "RelatedArtifact", "publicationStatus", element.getPublicationStatusElement(), -1);
        }
        if (element.hasPublicationDateElement()) {
            this.composeDate(t, "RelatedArtifact", "publicationDate", element.getPublicationDateElement(), -1);
        }
    }

    protected void composeSampledData(Turtle.Complex parent, String parentType, String name, SampledData element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "SampledData", name, element, index);
        if (element.hasOrigin()) {
            this.composeQuantity(t, "SampledData", "origin", element.getOrigin(), -1);
        }
        if (element.hasIntervalElement()) {
            this.composeDecimal(t, "SampledData", "interval", element.getIntervalElement(), -1);
        }
        if (element.hasIntervalUnitElement()) {
            this.composeCode(t, "SampledData", "intervalUnit", element.getIntervalUnitElement(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "SampledData", "factor", element.getFactorElement(), -1);
        }
        if (element.hasLowerLimitElement()) {
            this.composeDecimal(t, "SampledData", "lowerLimit", element.getLowerLimitElement(), -1);
        }
        if (element.hasUpperLimitElement()) {
            this.composeDecimal(t, "SampledData", "upperLimit", element.getUpperLimitElement(), -1);
        }
        if (element.hasDimensionsElement()) {
            this.composePositiveInt(t, "SampledData", "dimensions", element.getDimensionsElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeString(t, "SampledData", "data", element.getDataElement(), -1);
        }
    }

    protected void composeSignature(Turtle.Complex parent, String parentType, String name, Signature element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "Signature", name, element, index);
        for (int i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCoding(t, "Signature", "type", element.getType().get(i2), i2);
        }
        if (element.hasWhenElement()) {
            this.composeInstant(t, "Signature", "when", element.getWhenElement(), -1);
        }
        if (element.hasWho()) {
            this.composeReference(t, "Signature", "who", element.getWho(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "Signature", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
        if (element.hasTargetFormatElement()) {
            this.composeCode(t, "Signature", "targetFormat", element.getTargetFormatElement(), -1);
        }
        if (element.hasSigFormatElement()) {
            this.composeCode(t, "Signature", "sigFormat", element.getSigFormatElement(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Signature", "data", element.getDataElement(), -1);
        }
    }

    protected void composeTiming(Turtle.Complex parent, String parentType, String name, Timing element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneType(t, "Timing", name, element, index);
        for (int i2 = 0; i2 < element.getEvent().size(); ++i2) {
            this.composeDateTime(t, "Timing", "event", element.getEvent().get(i2), i2);
        }
        if (element.hasRepeat()) {
            this.composeTimingRepeatComponent(t, "Timing", "repeat", element.getRepeat(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Timing", "code", element.getCode(), -1);
        }
    }

    protected void composeTimingRepeatComponent(Turtle.Complex parent, String parentType, String name, Timing.TimingRepeatComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeElement(t, "repeat", name, element, index);
        if (element.hasBounds()) {
            this.composeType(t, "TimingRepeatComponent", "bounds", element.getBounds(), -1);
        }
        if (element.hasCountElement()) {
            this.composePositiveInt(t, "TimingRepeatComponent", "count", element.getCountElement(), -1);
        }
        if (element.hasCountMaxElement()) {
            this.composePositiveInt(t, "TimingRepeatComponent", "countMax", element.getCountMaxElement(), -1);
        }
        if (element.hasDurationElement()) {
            this.composeDecimal(t, "TimingRepeatComponent", "duration", element.getDurationElement(), -1);
        }
        if (element.hasDurationMaxElement()) {
            this.composeDecimal(t, "TimingRepeatComponent", "durationMax", element.getDurationMaxElement(), -1);
        }
        if (element.hasDurationUnitElement()) {
            this.composeEnum(t, "TimingRepeatComponent", "durationUnit", element.getDurationUnitElement(), -1);
        }
        if (element.hasFrequencyElement()) {
            this.composePositiveInt(t, "TimingRepeatComponent", "frequency", element.getFrequencyElement(), -1);
        }
        if (element.hasFrequencyMaxElement()) {
            this.composePositiveInt(t, "TimingRepeatComponent", "frequencyMax", element.getFrequencyMaxElement(), -1);
        }
        if (element.hasPeriodElement()) {
            this.composeDecimal(t, "TimingRepeatComponent", "period", element.getPeriodElement(), -1);
        }
        if (element.hasPeriodMaxElement()) {
            this.composeDecimal(t, "TimingRepeatComponent", "periodMax", element.getPeriodMaxElement(), -1);
        }
        if (element.hasPeriodUnitElement()) {
            this.composeEnum(t, "TimingRepeatComponent", "periodUnit", element.getPeriodUnitElement(), -1);
        }
        for (i2 = 0; i2 < element.getDayOfWeek().size(); ++i2) {
            this.composeEnum(t, "TimingRepeatComponent", "dayOfWeek", element.getDayOfWeek().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTimeOfDay().size(); ++i2) {
            this.composeTime(t, "TimingRepeatComponent", "timeOfDay", element.getTimeOfDay().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getWhen().size(); ++i2) {
            this.composeEnum(t, "TimingRepeatComponent", "when", element.getWhen().get(i2), i2);
        }
        if (element.hasOffsetElement()) {
            this.composeUnsignedInt(t, "TimingRepeatComponent", "offset", element.getOffsetElement(), -1);
        }
    }

    protected void composeTriggerDefinition(Turtle.Complex parent, String parentType, String name, TriggerDefinition element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "TriggerDefinition", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "TriggerDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "TriggerDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "TriggerDefinition", "code", element.getCode(), -1);
        }
        if (element.hasSubscriptionTopicElement()) {
            this.composeCanonical(t, "TriggerDefinition", "subscriptionTopic", element.getSubscriptionTopicElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "TriggerDefinition", "timing", element.getTiming(), -1);
        }
        for (int i2 = 0; i2 < element.getData().size(); ++i2) {
            this.composeDataRequirement(t, "TriggerDefinition", "data", element.getData().get(i2), i2);
        }
        if (element.hasCondition()) {
            this.composeExpression(t, "TriggerDefinition", "condition", element.getCondition(), -1);
        }
    }

    protected void composeUsageContext(Turtle.Complex parent, String parentType, String name, UsageContext element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "UsageContext", name, element, index);
        if (element.hasCode()) {
            this.composeCoding(t, "UsageContext", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "UsageContext", "value", element.getValue(), -1);
        }
    }

    protected void composeVirtualServiceDetail(Turtle.Complex parent, String parentType, String name, VirtualServiceDetail element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDataType(t, "VirtualServiceDetail", name, element, index);
        if (element.hasChannelType()) {
            this.composeCoding(t, "VirtualServiceDetail", "channelType", element.getChannelType(), -1);
        }
        if (element.hasAddress()) {
            this.composeType(t, "VirtualServiceDetail", "address", element.getAddress(), -1);
        }
        for (int i2 = 0; i2 < element.getAdditionalInfo().size(); ++i2) {
            this.composeUrl(t, "VirtualServiceDetail", "additionalInfo", element.getAdditionalInfo().get(i2), i2);
        }
        if (element.hasMaxParticipantsElement()) {
            this.composePositiveInt(t, "VirtualServiceDetail", "maxParticipants", element.getMaxParticipantsElement(), -1);
        }
        if (element.hasSessionKeyElement()) {
            this.composeString(t, "VirtualServiceDetail", "sessionKey", element.getSessionKeyElement(), -1);
        }
    }

    protected void composeCanonicalResource(Turtle.Complex t, String parentType, String name, CanonicalResource element, int index) {
        int i2;
        this.composeDomainResource(t, parentType, name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CanonicalResource", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "CanonicalResource", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CanonicalResource", "version", element.getVersionElement(), -1);
        }
        if (element.hasVersionAlgorithm()) {
            this.composeType(t, "CanonicalResource", "versionAlgorithm", element.getVersionAlgorithm(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CanonicalResource", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CanonicalResource", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CanonicalResource", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CanonicalResource", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CanonicalResource", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CanonicalResource", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "CanonicalResource", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CanonicalResource", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "CanonicalResource", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "CanonicalResource", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CanonicalResource", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CanonicalResource", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasCopyrightLabelElement()) {
            this.composeString(t, "CanonicalResource", "copyrightLabel", element.getCopyrightLabelElement(), -1);
        }
    }

    protected void composeDomainResource(Turtle.Complex t, String parentType, String name, DomainResource element, int index) {
        int i2;
        this.composeResource(t, parentType, name, element, index);
        if (element.hasText()) {
            this.composeNarrative(t, "DomainResource", "text", element.getText(), -1);
        }
        for (i2 = 0; i2 < element.getContained().size(); ++i2) {
            this.composeResource(t, "DomainResource", "contained", element.getContained().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getExtension().size(); ++i2) {
            this.composeExtension(t, "DomainResource", "extension", element.getExtension().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getModifierExtension().size(); ++i2) {
            this.composeExtension(t, "DomainResource", "modifierExtension", element.getModifierExtension().get(i2), i2);
        }
    }

    protected void composeMetadataResource(Turtle.Complex t, String parentType, String name, MetadataResource element, int index) {
        int i2;
        this.composeCanonicalResource(t, parentType, name, element, index);
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "MetadataResource", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "MetadataResource", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "MetadataResource", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getTopic().size(); ++i2) {
            this.composeCodeableConcept(t, "MetadataResource", "topic", element.getTopic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "MetadataResource", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "MetadataResource", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "MetadataResource", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "MetadataResource", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "MetadataResource", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
    }

    protected void composeResource(Turtle.Complex t, String parentType, String name, Resource element, int index) {
        this.composeBase(t, parentType, name, element, index);
        if (element.hasIdElement()) {
            this.composeId(t, "Resource", "id", element.getIdElement(), -1);
        }
        if (element.hasMeta()) {
            this.composeMeta(t, "Resource", "meta", element.getMeta(), -1);
        }
        if (element.hasImplicitRulesElement()) {
            this.composeUri(t, "Resource", "implicitRules", element.getImplicitRulesElement(), -1);
        }
        if (element.hasLanguageElement()) {
            this.composeCode(t, "Resource", "language", element.getLanguageElement(), -1);
        }
    }

    protected void composeAccount(Turtle.Complex parent, String parentType, String name, Account element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Account", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Account", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Account", "status", element.getStatusElement(), -1);
        }
        if (element.hasBillingStatus()) {
            this.composeCodeableConcept(t, "Account", "billingStatus", element.getBillingStatus(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Account", "type", element.getType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Account", "name", element.getNameElement(), -1);
        }
        for (i2 = 0; i2 < element.getSubject().size(); ++i2) {
            this.composeReference(t, "Account", "subject", element.getSubject().get(i2), i2);
        }
        if (element.hasServicePeriod()) {
            this.composePeriod(t, "Account", "servicePeriod", element.getServicePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getCoverage().size(); ++i2) {
            this.composeAccountCoverageComponent(t, "Account", "coverage", element.getCoverage().get(i2), i2);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Account", "owner", element.getOwner(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Account", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getGuarantor().size(); ++i2) {
            this.composeAccountGuarantorComponent(t, "Account", "guarantor", element.getGuarantor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedAccount().size(); ++i2) {
            this.composeAccountRelatedAccountComponent(t, "Account", "relatedAccount", element.getRelatedAccount().get(i2), i2);
        }
        if (element.hasCurrency()) {
            this.composeCodeableConcept(t, "Account", "currency", element.getCurrency(), -1);
        }
        for (i2 = 0; i2 < element.getBalance().size(); ++i2) {
            this.composeAccountBalanceComponent(t, "Account", "balance", element.getBalance().get(i2), i2);
        }
        if (element.hasCalculatedAtElement()) {
            this.composeInstant(t, "Account", "calculatedAt", element.getCalculatedAtElement(), -1);
        }
    }

    protected void composeAccountCoverageComponent(Turtle.Complex parent, String parentType, String name, Account.CoverageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "coverage", name, element, index);
        if (element.hasCoverage()) {
            this.composeReference(t, "CoverageComponent", "coverage", element.getCoverage(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composePositiveInt(t, "CoverageComponent", "priority", element.getPriorityElement(), -1);
        }
    }

    protected void composeAccountGuarantorComponent(Turtle.Complex parent, String parentType, String name, Account.GuarantorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "guarantor", name, element, index);
        if (element.hasParty()) {
            this.composeReference(t, "GuarantorComponent", "party", element.getParty(), -1);
        }
        if (element.hasOnHoldElement()) {
            this.composeBoolean(t, "GuarantorComponent", "onHold", element.getOnHoldElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "GuarantorComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeAccountRelatedAccountComponent(Turtle.Complex parent, String parentType, String name, Account.AccountRelatedAccountComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedAccount", name, element, index);
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "AccountRelatedAccountComponent", "relationship", element.getRelationship(), -1);
        }
        if (element.hasAccount()) {
            this.composeReference(t, "AccountRelatedAccountComponent", "account", element.getAccount(), -1);
        }
    }

    protected void composeAccountBalanceComponent(Turtle.Complex parent, String parentType, String name, Account.AccountBalanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "balance", name, element, index);
        if (element.hasAggregate()) {
            this.composeCodeableConcept(t, "AccountBalanceComponent", "aggregate", element.getAggregate(), -1);
        }
        if (element.hasTerm()) {
            this.composeCodeableConcept(t, "AccountBalanceComponent", "term", element.getTerm(), -1);
        }
        if (element.hasEstimateElement()) {
            this.composeBoolean(t, "AccountBalanceComponent", "estimate", element.getEstimateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "AccountBalanceComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeActivityDefinition(Turtle.Complex parent, String parentType, String name, ActivityDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "ActivityDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ActivityDefinition", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ActivityDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ActivityDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ActivityDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ActivityDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "ActivityDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ActivityDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ActivityDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "ActivityDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ActivityDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ActivityDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "ActivityDefinition", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "ActivityDefinition", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "ActivityDefinition", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "ActivityDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ActivityDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ActivityDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ActivityDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ActivityDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getTopic().size(); ++i2) {
            this.composeCodeableConcept(t, "ActivityDefinition", "topic", element.getTopic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "ActivityDefinition", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "ActivityDefinition", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "ActivityDefinition", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "ActivityDefinition", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "ActivityDefinition", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getLibrary().size(); ++i2) {
            this.composeCanonical(t, "ActivityDefinition", "library", element.getLibrary().get(i2), i2);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "ActivityDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ActivityDefinition", "profile", element.getProfileElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ActivityDefinition", "code", element.getCode(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "ActivityDefinition", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "ActivityDefinition", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "ActivityDefinition", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "ActivityDefinition", "timing", element.getTiming(), -1);
        }
        if (element.hasAsNeeded()) {
            this.composeType(t, "ActivityDefinition", "asNeeded", element.getAsNeeded(), -1);
        }
        if (element.hasLocation()) {
            this.composeCodeableReference(t, "ActivityDefinition", "location", element.getLocation(), -1);
        }
        for (i2 = 0; i2 < element.getParticipant().size(); ++i2) {
            this.composeActivityDefinitionParticipantComponent(t, "ActivityDefinition", "participant", element.getParticipant().get(i2), i2);
        }
        if (element.hasProduct()) {
            this.composeType(t, "ActivityDefinition", "product", element.getProduct(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ActivityDefinition", "quantity", element.getQuantity(), -1);
        }
        for (i2 = 0; i2 < element.getDosage().size(); ++i2) {
            this.composeDosage(t, "ActivityDefinition", "dosage", element.getDosage().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBodySite().size(); ++i2) {
            this.composeCodeableConcept(t, "ActivityDefinition", "bodySite", element.getBodySite().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSpecimenRequirement().size(); ++i2) {
            this.composeCanonical(t, "ActivityDefinition", "specimenRequirement", element.getSpecimenRequirement().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getObservationRequirement().size(); ++i2) {
            this.composeCanonical(t, "ActivityDefinition", "observationRequirement", element.getObservationRequirement().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getObservationResultRequirement().size(); ++i2) {
            this.composeCanonical(t, "ActivityDefinition", "observationResultRequirement", element.getObservationResultRequirement().get(i2), i2);
        }
        if (element.hasTransformElement()) {
            this.composeCanonical(t, "ActivityDefinition", "transform", element.getTransformElement(), -1);
        }
        for (i2 = 0; i2 < element.getDynamicValue().size(); ++i2) {
            this.composeActivityDefinitionDynamicValueComponent(t, "ActivityDefinition", "dynamicValue", element.getDynamicValue().get(i2), i2);
        }
    }

    protected void composeActivityDefinitionParticipantComponent(Turtle.Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ActivityDefinitionParticipantComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasTypeCanonicalElement()) {
            this.composeCanonical(t, "ActivityDefinitionParticipantComponent", "typeCanonical", element.getTypeCanonicalElement(), -1);
        }
        if (element.hasTypeReference()) {
            this.composeReference(t, "ActivityDefinitionParticipantComponent", "typeReference", element.getTypeReference(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ActivityDefinitionParticipantComponent", "role", element.getRole(), -1);
        }
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ActivityDefinitionParticipantComponent", "function", element.getFunction(), -1);
        }
    }

    protected void composeActivityDefinitionDynamicValueComponent(Turtle.Complex parent, String parentType, String name, ActivityDefinition.ActivityDefinitionDynamicValueComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dynamicValue", name, element, index);
        if (element.hasPathElement()) {
            this.composeString(t, "ActivityDefinitionDynamicValueComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasExpression()) {
            this.composeExpression(t, "ActivityDefinitionDynamicValueComponent", "expression", element.getExpression(), -1);
        }
    }

    protected void composeActorDefinition(Turtle.Complex parent, String parentType, String name, ActorDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeCanonicalResource(t, "ActorDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ActorDefinition", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ActorDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ActorDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ActorDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ActorDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ActorDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ActorDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ActorDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ActorDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "ActorDefinition", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ActorDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "ActorDefinition", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "ActorDefinition", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ActorDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ActorDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasCopyrightLabelElement()) {
            this.composeString(t, "ActorDefinition", "copyrightLabel", element.getCopyrightLabelElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ActorDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "ActorDefinition", "documentation", element.getDocumentationElement(), -1);
        }
        for (i2 = 0; i2 < element.getReference().size(); ++i2) {
            this.composeUrl(t, "ActorDefinition", "reference", element.getReference().get(i2), i2);
        }
        if (element.hasCapabilitiesElement()) {
            this.composeCanonical(t, "ActorDefinition", "capabilities", element.getCapabilitiesElement(), -1);
        }
        for (i2 = 0; i2 < element.getDerivedFrom().size(); ++i2) {
            this.composeCanonical(t, "ActorDefinition", "derivedFrom", element.getDerivedFrom().get(i2), i2);
        }
    }

    protected void composeAdministrableProductDefinition(Turtle.Complex parent, String parentType, String name, AdministrableProductDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AdministrableProductDefinition", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "AdministrableProductDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "AdministrableProductDefinition", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getFormOf().size(); ++i2) {
            this.composeReference(t, "AdministrableProductDefinition", "formOf", element.getFormOf().get(i2), i2);
        }
        if (element.hasAdministrableDoseForm()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinition", "administrableDoseForm", element.getAdministrableDoseForm(), -1);
        }
        if (element.hasUnitOfPresentation()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinition", "unitOfPresentation", element.getUnitOfPresentation(), -1);
        }
        for (i2 = 0; i2 < element.getProducedFrom().size(); ++i2) {
            this.composeReference(t, "AdministrableProductDefinition", "producedFrom", element.getProducedFrom().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIngredient().size(); ++i2) {
            this.composeCodeableConcept(t, "AdministrableProductDefinition", "ingredient", element.getIngredient().get(i2), i2);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "AdministrableProductDefinition", "device", element.getDevice(), -1);
        }
        for (i2 = 0; i2 < element.getProperty().size(); ++i2) {
            this.composeAdministrableProductDefinitionPropertyComponent(t, "AdministrableProductDefinition", "property", element.getProperty().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRouteOfAdministration().size(); ++i2) {
            this.composeAdministrableProductDefinitionRouteOfAdministrationComponent(t, "AdministrableProductDefinition", "routeOfAdministration", element.getRouteOfAdministration().get(i2), i2);
        }
    }

    protected void composeAdministrableProductDefinitionPropertyComponent(Turtle.Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinitionPropertyComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "AdministrableProductDefinitionPropertyComponent", "value", element.getValue(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinitionPropertyComponent", "status", element.getStatus(), -1);
        }
    }

    protected void composeAdministrableProductDefinitionRouteOfAdministrationComponent(Turtle.Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "routeOfAdministration", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "code", element.getCode(), -1);
        }
        if (element.hasFirstDose()) {
            this.composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "firstDose", element.getFirstDose(), -1);
        }
        if (element.hasMaxSingleDose()) {
            this.composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxSingleDose", element.getMaxSingleDose(), -1);
        }
        if (element.hasMaxDosePerDay()) {
            this.composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxDosePerDay", element.getMaxDosePerDay(), -1);
        }
        if (element.hasMaxDosePerTreatmentPeriod()) {
            this.composeRatio(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxDosePerTreatmentPeriod", element.getMaxDosePerTreatmentPeriod(), -1);
        }
        if (element.hasMaxTreatmentPeriod()) {
            this.composeDuration(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "maxTreatmentPeriod", element.getMaxTreatmentPeriod(), -1);
        }
        for (int i2 = 0; i2 < element.getTargetSpecies().size(); ++i2) {
            this.composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(t, "AdministrableProductDefinitionRouteOfAdministrationComponent", "targetSpecies", element.getTargetSpecies().get(i2), i2);
        }
    }

    protected void composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(Turtle.Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "targetSpecies", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent", "code", element.getCode(), -1);
        }
        for (int i2 = 0; i2 < element.getWithdrawalPeriod().size(); ++i2) {
            this.composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent", "withdrawalPeriod", element.getWithdrawalPeriod().get(i2), i2);
        }
    }

    protected void composeAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(Turtle.Complex parent, String parentType, String name, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "withdrawalPeriod", name, element, index);
        if (element.hasTissue()) {
            this.composeCodeableConcept(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "tissue", element.getTissue(), -1);
        }
        if (element.hasValue()) {
            this.composeQuantity(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "value", element.getValue(), -1);
        }
        if (element.hasSupportingInformationElement()) {
            this.composeString(t, "AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent", "supportingInformation", element.getSupportingInformationElement(), -1);
        }
    }

    protected void composeAdverseEvent(Turtle.Complex parent, String parentType, String name, AdverseEvent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AdverseEvent", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "AdverseEvent", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "AdverseEvent", "status", element.getStatusElement(), -1);
        }
        if (element.hasActualityElement()) {
            this.composeEnum(t, "AdverseEvent", "actuality", element.getActualityElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "AdverseEvent", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "AdverseEvent", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "AdverseEvent", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "AdverseEvent", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "AdverseEvent", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasDetectedElement()) {
            this.composeDateTime(t, "AdverseEvent", "detected", element.getDetectedElement(), -1);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTime(t, "AdverseEvent", "recordedDate", element.getRecordedDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getResultingEffect().size(); ++i2) {
            this.composeReference(t, "AdverseEvent", "resultingEffect", element.getResultingEffect().get(i2), i2);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "AdverseEvent", "location", element.getLocation(), -1);
        }
        if (element.hasSeriousness()) {
            this.composeCodeableConcept(t, "AdverseEvent", "seriousness", element.getSeriousness(), -1);
        }
        for (i2 = 0; i2 < element.getOutcome().size(); ++i2) {
            this.composeCodeableConcept(t, "AdverseEvent", "outcome", element.getOutcome().get(i2), i2);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "AdverseEvent", "recorder", element.getRecorder(), -1);
        }
        for (i2 = 0; i2 < element.getParticipant().size(); ++i2) {
            this.composeAdverseEventParticipantComponent(t, "AdverseEvent", "participant", element.getParticipant().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getStudy().size(); ++i2) {
            this.composeReference(t, "AdverseEvent", "study", element.getStudy().get(i2), i2);
        }
        if (element.hasExpectedInResearchStudyElement()) {
            this.composeBoolean(t, "AdverseEvent", "expectedInResearchStudy", element.getExpectedInResearchStudyElement(), -1);
        }
        for (i2 = 0; i2 < element.getSuspectEntity().size(); ++i2) {
            this.composeAdverseEventSuspectEntityComponent(t, "AdverseEvent", "suspectEntity", element.getSuspectEntity().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContributingFactor().size(); ++i2) {
            this.composeAdverseEventContributingFactorComponent(t, "AdverseEvent", "contributingFactor", element.getContributingFactor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPreventiveAction().size(); ++i2) {
            this.composeAdverseEventPreventiveActionComponent(t, "AdverseEvent", "preventiveAction", element.getPreventiveAction().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMitigatingAction().size(); ++i2) {
            this.composeAdverseEventMitigatingActionComponent(t, "AdverseEvent", "mitigatingAction", element.getMitigatingAction().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingInfo().size(); ++i2) {
            this.composeAdverseEventSupportingInfoComponent(t, "AdverseEvent", "supportingInfo", element.getSupportingInfo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "AdverseEvent", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeAdverseEventParticipantComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "AdverseEventParticipantComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "AdverseEventParticipantComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeAdverseEventSuspectEntityComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "suspectEntity", name, element, index);
        if (element.hasInstance()) {
            this.composeType(t, "AdverseEventSuspectEntityComponent", "instance", element.getInstance(), -1);
        }
        if (element.hasCausality()) {
            this.composeAdverseEventSuspectEntityCausalityComponent(t, "AdverseEventSuspectEntityComponent", "causality", element.getCausality(), -1);
        }
    }

    protected void composeAdverseEventSuspectEntityCausalityComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventSuspectEntityCausalityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "causality", name, element, index);
        if (element.hasAssessmentMethod()) {
            this.composeCodeableConcept(t, "AdverseEventSuspectEntityCausalityComponent", "assessmentMethod", element.getAssessmentMethod(), -1);
        }
        if (element.hasEntityRelatedness()) {
            this.composeCodeableConcept(t, "AdverseEventSuspectEntityCausalityComponent", "entityRelatedness", element.getEntityRelatedness(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "AdverseEventSuspectEntityCausalityComponent", "author", element.getAuthor(), -1);
        }
    }

    protected void composeAdverseEventContributingFactorComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventContributingFactorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contributingFactor", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "AdverseEventContributingFactorComponent", "item", element.getItem(), -1);
        }
    }

    protected void composeAdverseEventPreventiveActionComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventPreventiveActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "preventiveAction", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "AdverseEventPreventiveActionComponent", "item", element.getItem(), -1);
        }
    }

    protected void composeAdverseEventMitigatingActionComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventMitigatingActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "mitigatingAction", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "AdverseEventMitigatingActionComponent", "item", element.getItem(), -1);
        }
    }

    protected void composeAdverseEventSupportingInfoComponent(Turtle.Complex parent, String parentType, String name, AdverseEvent.AdverseEventSupportingInfoComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "AdverseEventSupportingInfoComponent", "item", element.getItem(), -1);
        }
    }

    protected void composeAllergyIntolerance(Turtle.Complex parent, String parentType, String name, AllergyIntolerance element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AllergyIntolerance", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "AllergyIntolerance", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasClinicalStatus()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "clinicalStatus", element.getClinicalStatus(), -1);
        }
        if (element.hasVerificationStatus()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "verificationStatus", element.getVerificationStatus(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeEnum(t, "AllergyIntolerance", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasCriticalityElement()) {
            this.composeEnum(t, "AllergyIntolerance", "criticality", element.getCriticalityElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "AllergyIntolerance", "code", element.getCode(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "AllergyIntolerance", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "AllergyIntolerance", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "AllergyIntolerance", "onset", element.getOnset(), -1);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "recordedDate", element.getRecordedDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getParticipant().size(); ++i2) {
            this.composeAllergyIntoleranceParticipantComponent(t, "AllergyIntolerance", "participant", element.getParticipant().get(i2), i2);
        }
        if (element.hasLastOccurrenceElement()) {
            this.composeDateTime(t, "AllergyIntolerance", "lastOccurrence", element.getLastOccurrenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "AllergyIntolerance", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReaction().size(); ++i2) {
            this.composeAllergyIntoleranceReactionComponent(t, "AllergyIntolerance", "reaction", element.getReaction().get(i2), i2);
        }
    }

    protected void composeAllergyIntoleranceParticipantComponent(Turtle.Complex parent, String parentType, String name, AllergyIntolerance.AllergyIntoleranceParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "AllergyIntoleranceParticipantComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "AllergyIntoleranceParticipantComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeAllergyIntoleranceReactionComponent(Turtle.Complex parent, String parentType, String name, AllergyIntolerance.AllergyIntoleranceReactionComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "reaction", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "AllergyIntoleranceReactionComponent", "substance", element.getSubstance(), -1);
        }
        for (i2 = 0; i2 < element.getManifestation().size(); ++i2) {
            this.composeCodeableReference(t, "AllergyIntoleranceReactionComponent", "manifestation", element.getManifestation().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "AllergyIntoleranceReactionComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasOnsetElement()) {
            this.composeDateTime(t, "AllergyIntoleranceReactionComponent", "onset", element.getOnsetElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "AllergyIntoleranceReactionComponent", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasExposureRoute()) {
            this.composeCodeableConcept(t, "AllergyIntoleranceReactionComponent", "exposureRoute", element.getExposureRoute(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "AllergyIntoleranceReactionComponent", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeAppointment(Turtle.Complex parent, String parentType, String name, Appointment element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Appointment", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Appointment", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Appointment", "status", element.getStatusElement(), -1);
        }
        if (element.hasCancellationReason()) {
            this.composeCodeableConcept(t, "Appointment", "cancellationReason", element.getCancellationReason(), -1);
        }
        for (i2 = 0; i2 < element.getClass_().size(); ++i2) {
            this.composeCodeableConcept(t, "Appointment", "class", element.getClass_().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getServiceCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "Appointment", "serviceCategory", element.getServiceCategory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getServiceType().size(); ++i2) {
            this.composeCodeableReference(t, "Appointment", "serviceType", element.getServiceType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSpecialty().size(); ++i2) {
            this.composeCodeableConcept(t, "Appointment", "specialty", element.getSpecialty().get(i2), i2);
        }
        if (element.hasAppointmentType()) {
            this.composeCodeableConcept(t, "Appointment", "appointmentType", element.getAppointmentType(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "Appointment", "reason", element.getReason().get(i2), i2);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Appointment", "priority", element.getPriority(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Appointment", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getReplaces().size(); ++i2) {
            this.composeReference(t, "Appointment", "replaces", element.getReplaces().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getVirtualService().size(); ++i2) {
            this.composeVirtualServiceDetail(t, "Appointment", "virtualService", element.getVirtualService().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingInformation().size(); ++i2) {
            this.composeReference(t, "Appointment", "supportingInformation", element.getSupportingInformation().get(i2), i2);
        }
        if (element.hasPreviousAppointment()) {
            this.composeReference(t, "Appointment", "previousAppointment", element.getPreviousAppointment(), -1);
        }
        if (element.hasOriginatingAppointment()) {
            this.composeReference(t, "Appointment", "originatingAppointment", element.getOriginatingAppointment(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "Appointment", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "Appointment", "end", element.getEndElement(), -1);
        }
        if (element.hasMinutesDurationElement()) {
            this.composePositiveInt(t, "Appointment", "minutesDuration", element.getMinutesDurationElement(), -1);
        }
        for (i2 = 0; i2 < element.getSlot().size(); ++i2) {
            this.composeReference(t, "Appointment", "slot", element.getSlot().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAccount().size(); ++i2) {
            this.composeReference(t, "Appointment", "account", element.getAccount().get(i2), i2);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Appointment", "created", element.getCreatedElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Appointment", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPatientInstruction().size(); ++i2) {
            this.composeCodeableReference(t, "Appointment", "patientInstruction", element.getPatientInstruction().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "Appointment", "basedOn", element.getBasedOn().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Appointment", "subject", element.getSubject(), -1);
        }
        for (i2 = 0; i2 < element.getParticipant().size(); ++i2) {
            this.composeAppointmentParticipantComponent(t, "Appointment", "participant", element.getParticipant().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRequestedPeriod().size(); ++i2) {
            this.composePeriod(t, "Appointment", "requestedPeriod", element.getRequestedPeriod().get(i2), i2);
        }
        if (element.hasRecurrenceIdElement()) {
            this.composePositiveInt(t, "Appointment", "recurrenceId", element.getRecurrenceIdElement(), -1);
        }
        if (element.hasOccurrenceChangedElement()) {
            this.composeBoolean(t, "Appointment", "occurrenceChanged", element.getOccurrenceChangedElement(), -1);
        }
        for (i2 = 0; i2 < element.getRecurrenceTemplate().size(); ++i2) {
            this.composeAppointmentRecurrenceTemplateComponent(t, "Appointment", "recurrenceTemplate", element.getRecurrenceTemplate().get(i2), i2);
        }
    }

    protected void composeAppointmentParticipantComponent(Turtle.Complex parent, String parentType, String name, Appointment.AppointmentParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "AppointmentParticipantComponent", "type", element.getType().get(i2), i2);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "AppointmentParticipantComponent", "period", element.getPeriod(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "AppointmentParticipantComponent", "actor", element.getActor(), -1);
        }
        if (element.hasRequiredElement()) {
            this.composeBoolean(t, "AppointmentParticipantComponent", "required", element.getRequiredElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "AppointmentParticipantComponent", "status", element.getStatusElement(), -1);
        }
    }

    protected void composeAppointmentRecurrenceTemplateComponent(Turtle.Complex parent, String parentType, String name, Appointment.AppointmentRecurrenceTemplateComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "recurrenceTemplate", name, element, index);
        if (element.hasTimezone()) {
            this.composeCodeableConcept(t, "AppointmentRecurrenceTemplateComponent", "timezone", element.getTimezone(), -1);
        }
        if (element.hasRecurrenceType()) {
            this.composeCodeableConcept(t, "AppointmentRecurrenceTemplateComponent", "recurrenceType", element.getRecurrenceType(), -1);
        }
        if (element.hasLastOccurrenceDateElement()) {
            this.composeDate(t, "AppointmentRecurrenceTemplateComponent", "lastOccurrenceDate", element.getLastOccurrenceDateElement(), -1);
        }
        if (element.hasOccurrenceCountElement()) {
            this.composePositiveInt(t, "AppointmentRecurrenceTemplateComponent", "occurrenceCount", element.getOccurrenceCountElement(), -1);
        }
        for (i2 = 0; i2 < element.getOccurrenceDate().size(); ++i2) {
            this.composeDate(t, "AppointmentRecurrenceTemplateComponent", "occurrenceDate", element.getOccurrenceDate().get(i2), i2);
        }
        if (element.hasWeeklyTemplate()) {
            this.composeAppointmentRecurrenceTemplateWeeklyTemplateComponent(t, "AppointmentRecurrenceTemplateComponent", "weeklyTemplate", element.getWeeklyTemplate(), -1);
        }
        if (element.hasMonthlyTemplate()) {
            this.composeAppointmentRecurrenceTemplateMonthlyTemplateComponent(t, "AppointmentRecurrenceTemplateComponent", "monthlyTemplate", element.getMonthlyTemplate(), -1);
        }
        if (element.hasYearlyTemplate()) {
            this.composeAppointmentRecurrenceTemplateYearlyTemplateComponent(t, "AppointmentRecurrenceTemplateComponent", "yearlyTemplate", element.getYearlyTemplate(), -1);
        }
        for (i2 = 0; i2 < element.getExcludingDate().size(); ++i2) {
            this.composeDate(t, "AppointmentRecurrenceTemplateComponent", "excludingDate", element.getExcludingDate().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getExcludingRecurrenceId().size(); ++i2) {
            this.composePositiveInt(t, "AppointmentRecurrenceTemplateComponent", "excludingRecurrenceId", element.getExcludingRecurrenceId().get(i2), i2);
        }
    }

    protected void composeAppointmentRecurrenceTemplateWeeklyTemplateComponent(Turtle.Complex parent, String parentType, String name, Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "weeklyTemplate", name, element, index);
        if (element.hasMondayElement()) {
            this.composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "monday", element.getMondayElement(), -1);
        }
        if (element.hasTuesdayElement()) {
            this.composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "tuesday", element.getTuesdayElement(), -1);
        }
        if (element.hasWednesdayElement()) {
            this.composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "wednesday", element.getWednesdayElement(), -1);
        }
        if (element.hasThursdayElement()) {
            this.composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "thursday", element.getThursdayElement(), -1);
        }
        if (element.hasFridayElement()) {
            this.composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "friday", element.getFridayElement(), -1);
        }
        if (element.hasSaturdayElement()) {
            this.composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "saturday", element.getSaturdayElement(), -1);
        }
        if (element.hasSundayElement()) {
            this.composeBoolean(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "sunday", element.getSundayElement(), -1);
        }
        if (element.hasWeekIntervalElement()) {
            this.composePositiveInt(t, "AppointmentRecurrenceTemplateWeeklyTemplateComponent", "weekInterval", element.getWeekIntervalElement(), -1);
        }
    }

    protected void composeAppointmentRecurrenceTemplateMonthlyTemplateComponent(Turtle.Complex parent, String parentType, String name, Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "monthlyTemplate", name, element, index);
        if (element.hasDayOfMonthElement()) {
            this.composePositiveInt(t, "AppointmentRecurrenceTemplateMonthlyTemplateComponent", "dayOfMonth", element.getDayOfMonthElement(), -1);
        }
        if (element.hasNthWeekOfMonth()) {
            this.composeCoding(t, "AppointmentRecurrenceTemplateMonthlyTemplateComponent", "nthWeekOfMonth", element.getNthWeekOfMonth(), -1);
        }
        if (element.hasDayOfWeek()) {
            this.composeCoding(t, "AppointmentRecurrenceTemplateMonthlyTemplateComponent", "dayOfWeek", element.getDayOfWeek(), -1);
        }
        if (element.hasMonthIntervalElement()) {
            this.composePositiveInt(t, "AppointmentRecurrenceTemplateMonthlyTemplateComponent", "monthInterval", element.getMonthIntervalElement(), -1);
        }
    }

    protected void composeAppointmentRecurrenceTemplateYearlyTemplateComponent(Turtle.Complex parent, String parentType, String name, Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "yearlyTemplate", name, element, index);
        if (element.hasYearIntervalElement()) {
            this.composePositiveInt(t, "AppointmentRecurrenceTemplateYearlyTemplateComponent", "yearInterval", element.getYearIntervalElement(), -1);
        }
    }

    protected void composeAppointmentResponse(Turtle.Complex parent, String parentType, String name, AppointmentResponse element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AppointmentResponse", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "AppointmentResponse", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasAppointment()) {
            this.composeReference(t, "AppointmentResponse", "appointment", element.getAppointment(), -1);
        }
        if (element.hasProposedNewTimeElement()) {
            this.composeBoolean(t, "AppointmentResponse", "proposedNewTime", element.getProposedNewTimeElement(), -1);
        }
        if (element.hasStartElement()) {
            this.composeInstant(t, "AppointmentResponse", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInstant(t, "AppointmentResponse", "end", element.getEndElement(), -1);
        }
        for (i2 = 0; i2 < element.getParticipantType().size(); ++i2) {
            this.composeCodeableConcept(t, "AppointmentResponse", "participantType", element.getParticipantType().get(i2), i2);
        }
        if (element.hasActor()) {
            this.composeReference(t, "AppointmentResponse", "actor", element.getActor(), -1);
        }
        if (element.hasParticipantStatusElement()) {
            this.composeEnum(t, "AppointmentResponse", "participantStatus", element.getParticipantStatusElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "AppointmentResponse", "comment", element.getCommentElement(), -1);
        }
        if (element.hasRecurringElement()) {
            this.composeBoolean(t, "AppointmentResponse", "recurring", element.getRecurringElement(), -1);
        }
        if (element.hasOccurrenceDateElement()) {
            this.composeDate(t, "AppointmentResponse", "occurrenceDate", element.getOccurrenceDateElement(), -1);
        }
        if (element.hasRecurrenceIdElement()) {
            this.composePositiveInt(t, "AppointmentResponse", "recurrenceId", element.getRecurrenceIdElement(), -1);
        }
    }

    protected void composeArtifactAssessment(Turtle.Complex parent, String parentType, String name, ArtifactAssessment element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ArtifactAssessment", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ArtifactAssessment", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasCiteAs()) {
            this.composeType(t, "ArtifactAssessment", "citeAs", element.getCiteAs(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ArtifactAssessment", "date", element.getDateElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ArtifactAssessment", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ArtifactAssessment", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ArtifactAssessment", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasArtifact()) {
            this.composeType(t, "ArtifactAssessment", "artifact", element.getArtifact(), -1);
        }
        for (i2 = 0; i2 < element.getContent().size(); ++i2) {
            this.composeArtifactAssessmentContentComponent(t, "ArtifactAssessment", "content", element.getContent().get(i2), i2);
        }
        if (element.hasWorkflowStatusElement()) {
            this.composeEnum(t, "ArtifactAssessment", "workflowStatus", element.getWorkflowStatusElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeEnum(t, "ArtifactAssessment", "disposition", element.getDispositionElement(), -1);
        }
    }

    protected void composeArtifactAssessmentContentComponent(Turtle.Complex parent, String parentType, String name, ArtifactAssessment.ArtifactAssessmentContentComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "content", name, element, index);
        if (element.hasInformationTypeElement()) {
            this.composeEnum(t, "ArtifactAssessmentContentComponent", "informationType", element.getInformationTypeElement(), -1);
        }
        if (element.hasSummaryElement()) {
            this.composeMarkdown(t, "ArtifactAssessmentContentComponent", "summary", element.getSummaryElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ArtifactAssessmentContentComponent", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getClassifier().size(); ++i2) {
            this.composeCodeableConcept(t, "ArtifactAssessmentContentComponent", "classifier", element.getClassifier().get(i2), i2);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "ArtifactAssessmentContentComponent", "author", element.getAuthor(), -1);
        }
        for (i2 = 0; i2 < element.getPath().size(); ++i2) {
            this.composeUri(t, "ArtifactAssessmentContentComponent", "path", element.getPath().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "ArtifactAssessmentContentComponent", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        if (element.hasFreeToShareElement()) {
            this.composeBoolean(t, "ArtifactAssessmentContentComponent", "freeToShare", element.getFreeToShareElement(), -1);
        }
        for (i2 = 0; i2 < element.getComponent().size(); ++i2) {
            this.composeArtifactAssessmentContentComponent(t, "ArtifactAssessmentContentComponent", "component", element.getComponent().get(i2), i2);
        }
    }

    protected void composeAuditEvent(Turtle.Complex parent, String parentType, String name, AuditEvent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "AuditEvent", name, element, index);
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "AuditEvent", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "AuditEvent", "code", element.getCode(), -1);
        }
        if (element.hasActionElement()) {
            this.composeEnum(t, "AuditEvent", "action", element.getActionElement(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "AuditEvent", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasOccurred()) {
            this.composeType(t, "AuditEvent", "occurred", element.getOccurred(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeInstant(t, "AuditEvent", "recorded", element.getRecordedElement(), -1);
        }
        if (element.hasOutcome()) {
            this.composeAuditEventOutcomeComponent(t, "AuditEvent", "outcome", element.getOutcome(), -1);
        }
        for (i2 = 0; i2 < element.getAuthorization().size(); ++i2) {
            this.composeCodeableConcept(t, "AuditEvent", "authorization", element.getAuthorization().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "AuditEvent", "basedOn", element.getBasedOn().get(i2), i2);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "AuditEvent", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "AuditEvent", "encounter", element.getEncounter(), -1);
        }
        for (i2 = 0; i2 < element.getAgent().size(); ++i2) {
            this.composeAuditEventAgentComponent(t, "AuditEvent", "agent", element.getAgent().get(i2), i2);
        }
        if (element.hasSource()) {
            this.composeAuditEventSourceComponent(t, "AuditEvent", "source", element.getSource(), -1);
        }
        for (i2 = 0; i2 < element.getEntity().size(); ++i2) {
            this.composeAuditEventEntityComponent(t, "AuditEvent", "entity", element.getEntity().get(i2), i2);
        }
    }

    protected void composeAuditEventOutcomeComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventOutcomeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "outcome", name, element, index);
        if (element.hasCode()) {
            this.composeCoding(t, "AuditEventOutcomeComponent", "code", element.getCode(), -1);
        }
        for (int i2 = 0; i2 < element.getDetail().size(); ++i2) {
            this.composeCodeableConcept(t, "AuditEventOutcomeComponent", "detail", element.getDetail().get(i2), i2);
        }
    }

    protected void composeAuditEventAgentComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventAgentComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "agent", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AuditEventAgentComponent", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getRole().size(); ++i2) {
            this.composeCodeableConcept(t, "AuditEventAgentComponent", "role", element.getRole().get(i2), i2);
        }
        if (element.hasWho()) {
            this.composeReference(t, "AuditEventAgentComponent", "who", element.getWho(), -1);
        }
        if (element.hasRequestorElement()) {
            this.composeBoolean(t, "AuditEventAgentComponent", "requestor", element.getRequestorElement(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "AuditEventAgentComponent", "location", element.getLocation(), -1);
        }
        for (i2 = 0; i2 < element.getPolicy().size(); ++i2) {
            this.composeUri(t, "AuditEventAgentComponent", "policy", element.getPolicy().get(i2), i2);
        }
        if (element.hasNetwork()) {
            this.composeType(t, "AuditEventAgentComponent", "network", element.getNetwork(), -1);
        }
        for (i2 = 0; i2 < element.getAuthorization().size(); ++i2) {
            this.composeCodeableConcept(t, "AuditEventAgentComponent", "authorization", element.getAuthorization().get(i2), i2);
        }
    }

    protected void composeAuditEventSourceComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasSite()) {
            this.composeReference(t, "AuditEventSourceComponent", "site", element.getSite(), -1);
        }
        if (element.hasObserver()) {
            this.composeReference(t, "AuditEventSourceComponent", "observer", element.getObserver(), -1);
        }
        for (int i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "AuditEventSourceComponent", "type", element.getType().get(i2), i2);
        }
    }

    protected void composeAuditEventEntityComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventEntityComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entity", name, element, index);
        if (element.hasWhat()) {
            this.composeReference(t, "AuditEventEntityComponent", "what", element.getWhat(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "AuditEventEntityComponent", "role", element.getRole(), -1);
        }
        for (i2 = 0; i2 < element.getSecurityLabel().size(); ++i2) {
            this.composeCodeableConcept(t, "AuditEventEntityComponent", "securityLabel", element.getSecurityLabel().get(i2), i2);
        }
        if (element.hasQueryElement()) {
            this.composeBase64Binary(t, "AuditEventEntityComponent", "query", element.getQueryElement(), -1);
        }
        for (i2 = 0; i2 < element.getDetail().size(); ++i2) {
            this.composeAuditEventEntityDetailComponent(t, "AuditEventEntityComponent", "detail", element.getDetail().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAgent().size(); ++i2) {
            this.composeAuditEventAgentComponent(t, "AuditEventEntityComponent", "agent", element.getAgent().get(i2), i2);
        }
    }

    protected void composeAuditEventEntityDetailComponent(Turtle.Complex parent, String parentType, String name, AuditEvent.AuditEventEntityDetailComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AuditEventEntityDetailComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "AuditEventEntityDetailComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeBasic(Turtle.Complex parent, String parentType, String name, Basic element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Basic", name, element, index);
        for (int i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Basic", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Basic", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Basic", "subject", element.getSubject(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Basic", "created", element.getCreatedElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Basic", "author", element.getAuthor(), -1);
        }
    }

    protected void composeBinary(Turtle.Complex parent, String parentType, String name, Binary element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Binary", name, element, index);
        if (element.hasContentTypeElement()) {
            this.composeCode(t, "Binary", "contentType", element.getContentTypeElement(), -1);
        }
        if (element.hasSecurityContext()) {
            this.composeReference(t, "Binary", "securityContext", element.getSecurityContext(), -1);
        }
        if (element.hasDataElement()) {
            this.composeBase64Binary(t, "Binary", "data", element.getDataElement(), -1);
        }
    }

    protected void composeBiologicallyDerivedProduct(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "BiologicallyDerivedProduct", name, element, index);
        if (element.hasProductCategory()) {
            this.composeCoding(t, "BiologicallyDerivedProduct", "productCategory", element.getProductCategory(), -1);
        }
        if (element.hasProductCode()) {
            this.composeCodeableConcept(t, "BiologicallyDerivedProduct", "productCode", element.getProductCode(), -1);
        }
        for (i2 = 0; i2 < element.getParent().size(); ++i2) {
            this.composeReference(t, "BiologicallyDerivedProduct", "parent", element.getParent().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRequest().size(); ++i2) {
            this.composeReference(t, "BiologicallyDerivedProduct", "request", element.getRequest().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "BiologicallyDerivedProduct", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasBiologicalSourceEvent()) {
            this.composeIdentifier(t, "BiologicallyDerivedProduct", "biologicalSourceEvent", element.getBiologicalSourceEvent(), -1);
        }
        for (i2 = 0; i2 < element.getProcessingFacility().size(); ++i2) {
            this.composeReference(t, "BiologicallyDerivedProduct", "processingFacility", element.getProcessingFacility().get(i2), i2);
        }
        if (element.hasDivisionElement()) {
            this.composeString(t, "BiologicallyDerivedProduct", "division", element.getDivisionElement(), -1);
        }
        if (element.hasProductStatus()) {
            this.composeCoding(t, "BiologicallyDerivedProduct", "productStatus", element.getProductStatus(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "BiologicallyDerivedProduct", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasCollection()) {
            this.composeBiologicallyDerivedProductCollectionComponent(t, "BiologicallyDerivedProduct", "collection", element.getCollection(), -1);
        }
        if (element.hasStorageTempRequirements()) {
            this.composeRange(t, "BiologicallyDerivedProduct", "storageTempRequirements", element.getStorageTempRequirements(), -1);
        }
        for (i2 = 0; i2 < element.getProperty().size(); ++i2) {
            this.composeBiologicallyDerivedProductPropertyComponent(t, "BiologicallyDerivedProduct", "property", element.getProperty().get(i2), i2);
        }
    }

    protected void composeBiologicallyDerivedProductCollectionComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "collection", name, element, index);
        if (element.hasCollector()) {
            this.composeReference(t, "BiologicallyDerivedProductCollectionComponent", "collector", element.getCollector(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "BiologicallyDerivedProductCollectionComponent", "source", element.getSource(), -1);
        }
        if (element.hasCollected()) {
            this.composeType(t, "BiologicallyDerivedProductCollectionComponent", "collected", element.getCollected(), -1);
        }
    }

    protected void composeBiologicallyDerivedProductPropertyComponent(Turtle.Complex parent, String parentType, String name, BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "BiologicallyDerivedProductPropertyComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "BiologicallyDerivedProductPropertyComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeBodyStructure(Turtle.Complex parent, String parentType, String name, BodyStructure element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "BodyStructure", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "BodyStructure", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "BodyStructure", "active", element.getActiveElement(), -1);
        }
        if (element.hasMorphology()) {
            this.composeCodeableConcept(t, "BodyStructure", "morphology", element.getMorphology(), -1);
        }
        for (i2 = 0; i2 < element.getIncludedStructure().size(); ++i2) {
            this.composeBodyStructureIncludedStructureComponent(t, "BodyStructure", "includedStructure", element.getIncludedStructure().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getExcludedStructure().size(); ++i2) {
            this.composeBodyStructureExcludedStructureComponent(t, "BodyStructure", "excludedStructure", element.getExcludedStructure().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BodyStructure", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getImage().size(); ++i2) {
            this.composeAttachment(t, "BodyStructure", "image", element.getImage().get(i2), i2);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "BodyStructure", "patient", element.getPatient(), -1);
        }
    }

    protected void composeBodyStructureIncludedStructureComponent(Turtle.Complex parent, String parentType, String name, BodyStructure.BodyStructureIncludedStructureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "includedStructure", name, element, index);
        if (element.hasStructure()) {
            this.composeCodeableConcept(t, "BodyStructureIncludedStructureComponent", "structure", element.getStructure(), -1);
        }
        if (element.hasLaterality()) {
            this.composeCodeableConcept(t, "BodyStructureIncludedStructureComponent", "laterality", element.getLaterality(), -1);
        }
        for (int i2 = 0; i2 < element.getQualifier().size(); ++i2) {
            this.composeCodeableConcept(t, "BodyStructureIncludedStructureComponent", "qualifier", element.getQualifier().get(i2), i2);
        }
    }

    protected void composeBodyStructureExcludedStructureComponent(Turtle.Complex parent, String parentType, String name, BodyStructure.BodyStructureExcludedStructureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "excludedStructure", name, element, index);
        if (element.hasStructure()) {
            this.composeCodeableConcept(t, "BodyStructureExcludedStructureComponent", "structure", element.getStructure(), -1);
        }
        if (element.hasLaterality()) {
            this.composeCodeableConcept(t, "BodyStructureExcludedStructureComponent", "laterality", element.getLaterality(), -1);
        }
        for (int i2 = 0; i2 < element.getQualifier().size(); ++i2) {
            this.composeCodeableConcept(t, "BodyStructureExcludedStructureComponent", "qualifier", element.getQualifier().get(i2), i2);
        }
    }

    protected void composeBundle(Turtle.Complex parent, String parentType, String name, Bundle element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Bundle", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Bundle", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Bundle", "type", element.getTypeElement(), -1);
        }
        if (element.hasTimestampElement()) {
            this.composeInstant(t, "Bundle", "timestamp", element.getTimestampElement(), -1);
        }
        if (element.hasTotalElement()) {
            this.composeUnsignedInt(t, "Bundle", "total", element.getTotalElement(), -1);
        }
        for (i2 = 0; i2 < element.getLink().size(); ++i2) {
            this.composeBundleLinkComponent(t, "Bundle", "link", element.getLink().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEntry().size(); ++i2) {
            this.composeBundleEntryComponent(t, "Bundle", "entry", element.getEntry().get(i2), i2);
        }
        if (element.hasSignature()) {
            this.composeSignature(t, "Bundle", "signature", element.getSignature(), -1);
        }
        if (element.hasIssues()) {
            this.composeResource(t, "Bundle", "issues", element.getIssues(), -1);
        }
    }

    protected void composeBundleLinkComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasRelationElement()) {
            this.composeEnum(t, "BundleLinkComponent", "relation", element.getRelationElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "BundleLinkComponent", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeBundleEntryComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        for (int i2 = 0; i2 < element.getLink().size(); ++i2) {
            this.composeBundleLinkComponent(t, "BundleEntryComponent", "link", element.getLink().get(i2), i2);
        }
        if (element.hasFullUrlElement()) {
            this.composeUri(t, "BundleEntryComponent", "fullUrl", element.getFullUrlElement(), -1);
        }
        if (element.hasResource()) {
            this.composeResource(t, "BundleEntryComponent", "resource", element.getResource(), -1);
        }
        if (element.hasSearch()) {
            this.composeBundleEntrySearchComponent(t, "BundleEntryComponent", "search", element.getSearch(), -1);
        }
        if (element.hasRequest()) {
            this.composeBundleEntryRequestComponent(t, "BundleEntryComponent", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeBundleEntryResponseComponent(t, "BundleEntryComponent", "response", element.getResponse(), -1);
        }
    }

    protected void composeBundleEntrySearchComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntrySearchComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "search", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "BundleEntrySearchComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasScoreElement()) {
            this.composeDecimal(t, "BundleEntrySearchComponent", "score", element.getScoreElement(), -1);
        }
    }

    protected void composeBundleEntryRequestComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryRequestComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "request", name, element, index);
        if (element.hasMethodElement()) {
            this.composeEnum(t, "BundleEntryRequestComponent", "method", element.getMethodElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "BundleEntryRequestComponent", "url", element.getUrlElement(), -1);
        }
        if (element.hasIfNoneMatchElement()) {
            this.composeString(t, "BundleEntryRequestComponent", "ifNoneMatch", element.getIfNoneMatchElement(), -1);
        }
        if (element.hasIfModifiedSinceElement()) {
            this.composeInstant(t, "BundleEntryRequestComponent", "ifModifiedSince", element.getIfModifiedSinceElement(), -1);
        }
        if (element.hasIfMatchElement()) {
            this.composeString(t, "BundleEntryRequestComponent", "ifMatch", element.getIfMatchElement(), -1);
        }
        if (element.hasIfNoneExistElement()) {
            this.composeString(t, "BundleEntryRequestComponent", "ifNoneExist", element.getIfNoneExistElement(), -1);
        }
    }

    protected void composeBundleEntryResponseComponent(Turtle.Complex parent, String parentType, String name, Bundle.BundleEntryResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "response", name, element, index);
        if (element.hasStatusElement()) {
            this.composeString(t, "BundleEntryResponseComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasLocationElement()) {
            this.composeUri(t, "BundleEntryResponseComponent", "location", element.getLocationElement(), -1);
        }
        if (element.hasEtagElement()) {
            this.composeString(t, "BundleEntryResponseComponent", "etag", element.getEtagElement(), -1);
        }
        if (element.hasLastModifiedElement()) {
            this.composeInstant(t, "BundleEntryResponseComponent", "lastModified", element.getLastModifiedElement(), -1);
        }
        if (element.hasOutcome()) {
            this.composeResource(t, "BundleEntryResponseComponent", "outcome", element.getOutcome(), -1);
        }
    }

    protected void composeCapabilityStatement(Turtle.Complex parent, String parentType, String name, CapabilityStatement element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeCanonicalResource(t, "CapabilityStatement", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CapabilityStatement", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CapabilityStatement", "version", element.getVersionElement(), -1);
        }
        if (element.hasVersionAlgorithm()) {
            this.composeType(t, "CapabilityStatement", "versionAlgorithm", element.getVersionAlgorithm(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatement", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CapabilityStatement", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CapabilityStatement", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CapabilityStatement", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CapabilityStatement", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CapabilityStatement", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "CapabilityStatement", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "CapabilityStatement", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "CapabilityStatement", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CapabilityStatement", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasCopyrightLabelElement()) {
            this.composeString(t, "CapabilityStatement", "copyrightLabel", element.getCopyrightLabelElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "CapabilityStatement", "kind", element.getKindElement(), -1);
        }
        for (i2 = 0; i2 < element.getInstantiates().size(); ++i2) {
            this.composeCanonical(t, "CapabilityStatement", "instantiates", element.getInstantiates().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getImports().size(); ++i2) {
            this.composeCanonical(t, "CapabilityStatement", "imports", element.getImports().get(i2), i2);
        }
        if (element.hasSoftware()) {
            this.composeCapabilityStatementSoftwareComponent(t, "CapabilityStatement", "software", element.getSoftware(), -1);
        }
        if (element.hasImplementation()) {
            this.composeCapabilityStatementImplementationComponent(t, "CapabilityStatement", "implementation", element.getImplementation(), -1);
        }
        if (element.hasFhirVersionElement()) {
            this.composeEnum(t, "CapabilityStatement", "fhirVersion", element.getFhirVersionElement(), -1);
        }
        for (i2 = 0; i2 < element.getFormat().size(); ++i2) {
            this.composeCode(t, "CapabilityStatement", "format", element.getFormat().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPatchFormat().size(); ++i2) {
            this.composeCode(t, "CapabilityStatement", "patchFormat", element.getPatchFormat().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAcceptLanguage().size(); ++i2) {
            this.composeCode(t, "CapabilityStatement", "acceptLanguage", element.getAcceptLanguage().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getImplementationGuide().size(); ++i2) {
            this.composeCanonical(t, "CapabilityStatement", "implementationGuide", element.getImplementationGuide().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRest().size(); ++i2) {
            this.composeCapabilityStatementRestComponent(t, "CapabilityStatement", "rest", element.getRest().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMessaging().size(); ++i2) {
            this.composeCapabilityStatementMessagingComponent(t, "CapabilityStatement", "messaging", element.getMessaging().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDocument().size(); ++i2) {
            this.composeCapabilityStatementDocumentComponent(t, "CapabilityStatement", "document", element.getDocument().get(i2), i2);
        }
    }

    protected void composeCapabilityStatementSoftwareComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementSoftwareComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "software", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatementSoftwareComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CapabilityStatementSoftwareComponent", "version", element.getVersionElement(), -1);
        }
        if (element.hasReleaseDateElement()) {
            this.composeDateTime(t, "CapabilityStatementSoftwareComponent", "releaseDate", element.getReleaseDateElement(), -1);
        }
    }

    protected void composeCapabilityStatementImplementationComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementImplementationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "implementation", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CapabilityStatementImplementationComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "CapabilityStatementImplementationComponent", "url", element.getUrlElement(), -1);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "CapabilityStatementImplementationComponent", "custodian", element.getCustodian(), -1);
        }
    }

    protected void composeCapabilityStatementRestComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rest", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatementRestComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementRestComponent", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasSecurity()) {
            this.composeCapabilityStatementRestSecurityComponent(t, "CapabilityStatementRestComponent", "security", element.getSecurity(), -1);
        }
        for (i2 = 0; i2 < element.getResource().size(); ++i2) {
            this.composeCapabilityStatementRestResourceComponent(t, "CapabilityStatementRestComponent", "resource", element.getResource().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInteraction().size(); ++i2) {
            this.composeCapabilityStatementSystemInteractionComponent(t, "CapabilityStatementRestComponent", "interaction", element.getInteraction().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSearchParam().size(); ++i2) {
            this.composeCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatementRestComponent", "searchParam", element.getSearchParam().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getOperation().size(); ++i2) {
            this.composeCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatementRestComponent", "operation", element.getOperation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCompartment().size(); ++i2) {
            this.composeCanonical(t, "CapabilityStatementRestComponent", "compartment", element.getCompartment().get(i2), i2);
        }
    }

    protected void composeCapabilityStatementRestSecurityComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestSecurityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "security", name, element, index);
        if (element.hasCorsElement()) {
            this.composeBoolean(t, "CapabilityStatementRestSecurityComponent", "cors", element.getCorsElement(), -1);
        }
        for (int i2 = 0; i2 < element.getService().size(); ++i2) {
            this.composeCodeableConcept(t, "CapabilityStatementRestSecurityComponent", "service", element.getService().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CapabilityStatementRestSecurityComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeCapabilityStatementRestResourceComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "CapabilityStatementRestResourceComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "CapabilityStatementRestResourceComponent", "profile", element.getProfileElement(), -1);
        }
        for (i2 = 0; i2 < element.getSupportedProfile().size(); ++i2) {
            this.composeCanonical(t, "CapabilityStatementRestResourceComponent", "supportedProfile", element.getSupportedProfile().get(i2), i2);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementRestResourceComponent", "documentation", element.getDocumentationElement(), -1);
        }
        for (i2 = 0; i2 < element.getInteraction().size(); ++i2) {
            this.composeCapabilityStatementResourceInteractionComponent(t, "CapabilityStatementRestResourceComponent", "interaction", element.getInteraction().get(i2), i2);
        }
        if (element.hasVersioningElement()) {
            this.composeEnum(t, "CapabilityStatementRestResourceComponent", "versioning", element.getVersioningElement(), -1);
        }
        if (element.hasReadHistoryElement()) {
            this.composeBoolean(t, "CapabilityStatementRestResourceComponent", "readHistory", element.getReadHistoryElement(), -1);
        }
        if (element.hasUpdateCreateElement()) {
            this.composeBoolean(t, "CapabilityStatementRestResourceComponent", "updateCreate", element.getUpdateCreateElement(), -1);
        }
        if (element.hasConditionalCreateElement()) {
            this.composeBoolean(t, "CapabilityStatementRestResourceComponent", "conditionalCreate", element.getConditionalCreateElement(), -1);
        }
        if (element.hasConditionalReadElement()) {
            this.composeEnum(t, "CapabilityStatementRestResourceComponent", "conditionalRead", element.getConditionalReadElement(), -1);
        }
        if (element.hasConditionalUpdateElement()) {
            this.composeBoolean(t, "CapabilityStatementRestResourceComponent", "conditionalUpdate", element.getConditionalUpdateElement(), -1);
        }
        if (element.hasConditionalPatchElement()) {
            this.composeBoolean(t, "CapabilityStatementRestResourceComponent", "conditionalPatch", element.getConditionalPatchElement(), -1);
        }
        if (element.hasConditionalDeleteElement()) {
            this.composeEnum(t, "CapabilityStatementRestResourceComponent", "conditionalDelete", element.getConditionalDeleteElement(), -1);
        }
        for (i2 = 0; i2 < element.getReferencePolicy().size(); ++i2) {
            this.composeEnum(t, "CapabilityStatementRestResourceComponent", "referencePolicy", element.getReferencePolicy().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSearchInclude().size(); ++i2) {
            this.composeString(t, "CapabilityStatementRestResourceComponent", "searchInclude", element.getSearchInclude().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSearchRevInclude().size(); ++i2) {
            this.composeString(t, "CapabilityStatementRestResourceComponent", "searchRevInclude", element.getSearchRevInclude().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSearchParam().size(); ++i2) {
            this.composeCapabilityStatementRestResourceSearchParamComponent(t, "CapabilityStatementRestResourceComponent", "searchParam", element.getSearchParam().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getOperation().size(); ++i2) {
            this.composeCapabilityStatementRestResourceOperationComponent(t, "CapabilityStatementRestResourceComponent", "operation", element.getOperation().get(i2), i2);
        }
    }

    protected void composeCapabilityStatementResourceInteractionComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.ResourceInteractionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "ResourceInteractionComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "ResourceInteractionComponent", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementRestResourceSearchParamComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "searchParam", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatementRestResourceSearchParamComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatementRestResourceSearchParamComponent", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "CapabilityStatementRestResourceSearchParamComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementRestResourceSearchParamComponent", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementRestResourceOperationComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementRestResourceOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "CapabilityStatementRestResourceOperationComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatementRestResourceOperationComponent", "definition", element.getDefinitionElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementRestResourceOperationComponent", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementSystemInteractionComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.SystemInteractionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "SystemInteractionComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "SystemInteractionComponent", "documentation", element.getDocumentationElement(), -1);
        }
    }

    protected void composeCapabilityStatementMessagingComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "messaging", name, element, index);
        for (i2 = 0; i2 < element.getEndpoint().size(); ++i2) {
            this.composeCapabilityStatementMessagingEndpointComponent(t, "CapabilityStatementMessagingComponent", "endpoint", element.getEndpoint().get(i2), i2);
        }
        if (element.hasReliableCacheElement()) {
            this.composeUnsignedInt(t, "CapabilityStatementMessagingComponent", "reliableCache", element.getReliableCacheElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementMessagingComponent", "documentation", element.getDocumentationElement(), -1);
        }
        for (i2 = 0; i2 < element.getSupportedMessage().size(); ++i2) {
            this.composeCapabilityStatementMessagingSupportedMessageComponent(t, "CapabilityStatementMessagingComponent", "supportedMessage", element.getSupportedMessage().get(i2), i2);
        }
    }

    protected void composeCapabilityStatementMessagingEndpointComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingEndpointComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "endpoint", name, element, index);
        if (element.hasProtocol()) {
            this.composeCoding(t, "CapabilityStatementMessagingEndpointComponent", "protocol", element.getProtocol(), -1);
        }
        if (element.hasAddressElement()) {
            this.composeUrl(t, "CapabilityStatementMessagingEndpointComponent", "address", element.getAddressElement(), -1);
        }
    }

    protected void composeCapabilityStatementMessagingSupportedMessageComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportedMessage", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatementMessagingSupportedMessageComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "CapabilityStatementMessagingSupportedMessageComponent", "definition", element.getDefinitionElement(), -1);
        }
    }

    protected void composeCapabilityStatementDocumentComponent(Turtle.Complex parent, String parentType, String name, CapabilityStatement.CapabilityStatementDocumentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "document", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "CapabilityStatementDocumentComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "CapabilityStatementDocumentComponent", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "CapabilityStatementDocumentComponent", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeCarePlan(Turtle.Complex parent, String parentType, String name, CarePlan element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CarePlan", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "CarePlan", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesCanonical().size(); ++i2) {
            this.composeCanonical(t, "CarePlan", "instantiatesCanonical", element.getInstantiatesCanonical().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesUri().size(); ++i2) {
            this.composeUri(t, "CarePlan", "instantiatesUri", element.getInstantiatesUri().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "CarePlan", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReplaces().size(); ++i2) {
            this.composeReference(t, "CarePlan", "replaces", element.getReplaces().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPartOf().size(); ++i2) {
            this.composeReference(t, "CarePlan", "partOf", element.getPartOf().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CarePlan", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "CarePlan", "intent", element.getIntentElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "CarePlan", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CarePlan", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CarePlan", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CarePlan", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "CarePlan", "encounter", element.getEncounter(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CarePlan", "period", element.getPeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "CarePlan", "created", element.getCreatedElement(), -1);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "CarePlan", "custodian", element.getCustodian(), -1);
        }
        for (i2 = 0; i2 < element.getContributor().size(); ++i2) {
            this.composeReference(t, "CarePlan", "contributor", element.getContributor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCareTeam().size(); ++i2) {
            this.composeReference(t, "CarePlan", "careTeam", element.getCareTeam().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAddresses().size(); ++i2) {
            this.composeCodeableReference(t, "CarePlan", "addresses", element.getAddresses().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingInfo().size(); ++i2) {
            this.composeReference(t, "CarePlan", "supportingInfo", element.getSupportingInfo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getGoal().size(); ++i2) {
            this.composeReference(t, "CarePlan", "goal", element.getGoal().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getActivity().size(); ++i2) {
            this.composeCarePlanActivityComponent(t, "CarePlan", "activity", element.getActivity().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "CarePlan", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeCarePlanActivityComponent(Turtle.Complex parent, String parentType, String name, CarePlan.CarePlanActivityComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "activity", name, element, index);
        for (i2 = 0; i2 < element.getPerformedActivity().size(); ++i2) {
            this.composeCodeableReference(t, "CarePlanActivityComponent", "performedActivity", element.getPerformedActivity().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgress().size(); ++i2) {
            this.composeAnnotation(t, "CarePlanActivityComponent", "progress", element.getProgress().get(i2), i2);
        }
        if (element.hasPlannedActivityReference()) {
            this.composeReference(t, "CarePlanActivityComponent", "plannedActivityReference", element.getPlannedActivityReference(), -1);
        }
        if (element.hasPlannedActivityDetail()) {
            this.composeCarePlanActivityPlannedActivityDetailComponent(t, "CarePlanActivityComponent", "plannedActivityDetail", element.getPlannedActivityDetail(), -1);
        }
    }

    protected void composeCarePlanActivityPlannedActivityDetailComponent(Turtle.Complex parent, String parentType, String name, CarePlan.CarePlanActivityPlannedActivityDetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "plannedActivityDetail", name, element, index);
        if (element.hasKindElement()) {
            this.composeEnum(t, "CarePlanActivityPlannedActivityDetailComponent", "kind", element.getKindElement(), -1);
        }
        for (i2 = 0; i2 < element.getInstantiatesCanonical().size(); ++i2) {
            this.composeCanonical(t, "CarePlanActivityPlannedActivityDetailComponent", "instantiatesCanonical", element.getInstantiatesCanonical().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesUri().size(); ++i2) {
            this.composeUri(t, "CarePlanActivityPlannedActivityDetailComponent", "instantiatesUri", element.getInstantiatesUri().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "CarePlanActivityPlannedActivityDetailComponent", "code", element.getCode(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "CarePlanActivityPlannedActivityDetailComponent", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getGoal().size(); ++i2) {
            this.composeReference(t, "CarePlanActivityPlannedActivityDetailComponent", "goal", element.getGoal().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CarePlanActivityPlannedActivityDetailComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "CarePlanActivityPlannedActivityDetailComponent", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "CarePlanActivityPlannedActivityDetailComponent", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasScheduled()) {
            this.composeType(t, "CarePlanActivityPlannedActivityDetailComponent", "scheduled", element.getScheduled(), -1);
        }
        if (element.hasLocation()) {
            this.composeCodeableReference(t, "CarePlanActivityPlannedActivityDetailComponent", "location", element.getLocation(), -1);
        }
        if (element.hasReported()) {
            this.composeType(t, "CarePlanActivityPlannedActivityDetailComponent", "reported", element.getReported(), -1);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeReference(t, "CarePlanActivityPlannedActivityDetailComponent", "performer", element.getPerformer().get(i2), i2);
        }
        if (element.hasProduct()) {
            this.composeType(t, "CarePlanActivityPlannedActivityDetailComponent", "product", element.getProduct(), -1);
        }
        if (element.hasDailyAmount()) {
            this.composeQuantity(t, "CarePlanActivityPlannedActivityDetailComponent", "dailyAmount", element.getDailyAmount(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "CarePlanActivityPlannedActivityDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CarePlanActivityPlannedActivityDetailComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeCareTeam(Turtle.Complex parent, String parentType, String name, CareTeam element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CareTeam", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "CareTeam", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CareTeam", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "CareTeam", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CareTeam", "name", element.getNameElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CareTeam", "subject", element.getSubject(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CareTeam", "period", element.getPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getParticipant().size(); ++i2) {
            this.composeCareTeamParticipantComponent(t, "CareTeam", "participant", element.getParticipant().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "CareTeam", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getManagingOrganization().size(); ++i2) {
            this.composeReference(t, "CareTeam", "managingOrganization", element.getManagingOrganization().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTelecom().size(); ++i2) {
            this.composeContactPoint(t, "CareTeam", "telecom", element.getTelecom().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "CareTeam", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeCareTeamParticipantComponent(Turtle.Complex parent, String parentType, String name, CareTeam.CareTeamParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "CareTeamParticipantComponent", "role", element.getRole(), -1);
        }
        if (element.hasMember()) {
            this.composeReference(t, "CareTeamParticipantComponent", "member", element.getMember(), -1);
        }
        if (element.hasOnBehalfOf()) {
            this.composeReference(t, "CareTeamParticipantComponent", "onBehalfOf", element.getOnBehalfOf(), -1);
        }
        if (element.hasCoverage()) {
            this.composeType(t, "CareTeamParticipantComponent", "coverage", element.getCoverage(), -1);
        }
    }

    protected void composeChargeItem(Turtle.Complex parent, String parentType, String name, ChargeItem element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ChargeItem", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ChargeItem", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDefinitionUri().size(); ++i2) {
            this.composeUri(t, "ChargeItem", "definitionUri", element.getDefinitionUri().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDefinitionCanonical().size(); ++i2) {
            this.composeCanonical(t, "ChargeItem", "definitionCanonical", element.getDefinitionCanonical().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ChargeItem", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getPartOf().size(); ++i2) {
            this.composeReference(t, "ChargeItem", "partOf", element.getPartOf().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ChargeItem", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ChargeItem", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ChargeItem", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "ChargeItem", "occurrence", element.getOccurrence(), -1);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeChargeItemPerformerComponent(t, "ChargeItem", "performer", element.getPerformer().get(i2), i2);
        }
        if (element.hasPerformingOrganization()) {
            this.composeReference(t, "ChargeItem", "performingOrganization", element.getPerformingOrganization(), -1);
        }
        if (element.hasRequestingOrganization()) {
            this.composeReference(t, "ChargeItem", "requestingOrganization", element.getRequestingOrganization(), -1);
        }
        if (element.hasCostCenter()) {
            this.composeReference(t, "ChargeItem", "costCenter", element.getCostCenter(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ChargeItem", "quantity", element.getQuantity(), -1);
        }
        for (i2 = 0; i2 < element.getBodysite().size(); ++i2) {
            this.composeCodeableConcept(t, "ChargeItem", "bodysite", element.getBodysite().get(i2), i2);
        }
        if (element.hasUnitPriceComponent()) {
            this.composeMonetaryComponent(t, "ChargeItem", "unitPriceComponent", element.getUnitPriceComponent(), -1);
        }
        if (element.hasTotalPriceComponent()) {
            this.composeMonetaryComponent(t, "ChargeItem", "totalPriceComponent", element.getTotalPriceComponent(), -1);
        }
        if (element.hasOverrideReason()) {
            this.composeCodeableConcept(t, "ChargeItem", "overrideReason", element.getOverrideReason(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "ChargeItem", "enterer", element.getEnterer(), -1);
        }
        if (element.hasEnteredDateElement()) {
            this.composeDateTime(t, "ChargeItem", "enteredDate", element.getEnteredDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableConcept(t, "ChargeItem", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getService().size(); ++i2) {
            this.composeCodeableReference(t, "ChargeItem", "service", element.getService().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProduct().size(); ++i2) {
            this.composeCodeableReference(t, "ChargeItem", "product", element.getProduct().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAccount().size(); ++i2) {
            this.composeReference(t, "ChargeItem", "account", element.getAccount().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "ChargeItem", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingInformation().size(); ++i2) {
            this.composeReference(t, "ChargeItem", "supportingInformation", element.getSupportingInformation().get(i2), i2);
        }
    }

    protected void composeChargeItemPerformerComponent(Turtle.Complex parent, String parentType, String name, ChargeItem.ChargeItemPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ChargeItemPerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ChargeItemPerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeChargeItemDefinition(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "ChargeItemDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ChargeItemDefinition", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ChargeItemDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ChargeItemDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ChargeItemDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ChargeItemDefinition", "title", element.getTitleElement(), -1);
        }
        for (i2 = 0; i2 < element.getDerivedFromUri().size(); ++i2) {
            this.composeUri(t, "ChargeItemDefinition", "derivedFromUri", element.getDerivedFromUri().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPartOf().size(); ++i2) {
            this.composeCanonical(t, "ChargeItemDefinition", "partOf", element.getPartOf().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReplaces().size(); ++i2) {
            this.composeCanonical(t, "ChargeItemDefinition", "replaces", element.getReplaces().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ChargeItemDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ChargeItemDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ChargeItemDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ChargeItemDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "ChargeItemDefinition", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ChargeItemDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "ChargeItemDefinition", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "ChargeItemDefinition", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ChargeItemDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ChargeItemDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ChargeItemDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ChargeItemDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ChargeItemDefinition", "code", element.getCode(), -1);
        }
        for (i2 = 0; i2 < element.getInstance().size(); ++i2) {
            this.composeReference(t, "ChargeItemDefinition", "instance", element.getInstance().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getApplicability().size(); ++i2) {
            this.composeChargeItemDefinitionApplicabilityComponent(t, "ChargeItemDefinition", "applicability", element.getApplicability().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPropertyGroup().size(); ++i2) {
            this.composeChargeItemDefinitionPropertyGroupComponent(t, "ChargeItemDefinition", "propertyGroup", element.getPropertyGroup().get(i2), i2);
        }
    }

    protected void composeChargeItemDefinitionApplicabilityComponent(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "applicability", name, element, index);
        if (element.hasCondition()) {
            this.composeExpression(t, "ChargeItemDefinitionApplicabilityComponent", "condition", element.getCondition(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ChargeItemDefinitionApplicabilityComponent", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        if (element.hasRelatedArtifact()) {
            this.composeRelatedArtifact(t, "ChargeItemDefinitionApplicabilityComponent", "relatedArtifact", element.getRelatedArtifact(), -1);
        }
    }

    protected void composeChargeItemDefinitionPropertyGroupComponent(Turtle.Complex parent, String parentType, String name, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "propertyGroup", name, element, index);
        for (i2 = 0; i2 < element.getApplicability().size(); ++i2) {
            this.composeChargeItemDefinitionApplicabilityComponent(t, "ChargeItemDefinitionPropertyGroupComponent", "applicability", element.getApplicability().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPriceComponent().size(); ++i2) {
            this.composeMonetaryComponent(t, "ChargeItemDefinitionPropertyGroupComponent", "priceComponent", element.getPriceComponent().get(i2), i2);
        }
    }

    protected void composeCitation(Turtle.Complex parent, String parentType, String name, Citation element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "Citation", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Citation", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Citation", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Citation", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Citation", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Citation", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Citation", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Citation", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Citation", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Citation", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "Citation", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Citation", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "Citation", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "Citation", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Citation", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Citation", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Citation", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Citation", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Citation", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "Citation", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "Citation", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "Citation", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "Citation", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSummary().size(); ++i2) {
            this.composeCitationSummaryComponent(t, "Citation", "summary", element.getSummary().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getClassification().size(); ++i2) {
            this.composeCitationClassificationComponent(t, "Citation", "classification", element.getClassification().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Citation", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCurrentState().size(); ++i2) {
            this.composeCodeableConcept(t, "Citation", "currentState", element.getCurrentState().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getStatusDate().size(); ++i2) {
            this.composeCitationStatusDateComponent(t, "Citation", "statusDate", element.getStatusDate().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "Citation", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        if (element.hasCitedArtifact()) {
            this.composeCitationCitedArtifactComponent(t, "Citation", "citedArtifact", element.getCitedArtifact(), -1);
        }
    }

    protected void composeCitationSummaryComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationSummaryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "summary", name, element, index);
        if (element.hasStyle()) {
            this.composeCodeableConcept(t, "CitationSummaryComponent", "style", element.getStyle(), -1);
        }
        if (element.hasTextElement()) {
            this.composeMarkdown(t, "CitationSummaryComponent", "text", element.getTextElement(), -1);
        }
    }

    protected void composeCitationClassificationComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationClassificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "classification", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationClassificationComponent", "type", element.getType(), -1);
        }
        for (int i2 = 0; i2 < element.getClassifier().size(); ++i2) {
            this.composeCodeableConcept(t, "CitationClassificationComponent", "classifier", element.getClassifier().get(i2), i2);
        }
    }

    protected void composeCitationStatusDateComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationStatusDateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusDate", name, element, index);
        if (element.hasActivity()) {
            this.composeCodeableConcept(t, "CitationStatusDateComponent", "activity", element.getActivity(), -1);
        }
        if (element.hasActualElement()) {
            this.composeBoolean(t, "CitationStatusDateComponent", "actual", element.getActualElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CitationStatusDateComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeCitationCitedArtifactComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "citedArtifact", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "CitationCitedArtifactComponent", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "CitationCitedArtifactComponent", "relatedIdentifier", element.getRelatedIdentifier().get(i2), i2);
        }
        if (element.hasDateAccessedElement()) {
            this.composeDateTime(t, "CitationCitedArtifactComponent", "dateAccessed", element.getDateAccessedElement(), -1);
        }
        if (element.hasVersion()) {
            this.composeCitationCitedArtifactVersionComponent(t, "CitationCitedArtifactComponent", "version", element.getVersion(), -1);
        }
        for (i2 = 0; i2 < element.getCurrentState().size(); ++i2) {
            this.composeCodeableConcept(t, "CitationCitedArtifactComponent", "currentState", element.getCurrentState().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getStatusDate().size(); ++i2) {
            this.composeCitationCitedArtifactStatusDateComponent(t, "CitationCitedArtifactComponent", "statusDate", element.getStatusDate().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTitle().size(); ++i2) {
            this.composeCitationCitedArtifactTitleComponent(t, "CitationCitedArtifactComponent", "title", element.getTitle().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAbstract().size(); ++i2) {
            this.composeCitationCitedArtifactAbstractComponent(t, "CitationCitedArtifactComponent", "abstract", element.getAbstract().get(i2), i2);
        }
        if (element.hasPart()) {
            this.composeCitationCitedArtifactPartComponent(t, "CitationCitedArtifactComponent", "part", element.getPart(), -1);
        }
        for (i2 = 0; i2 < element.getRelatesTo().size(); ++i2) {
            this.composeCitationCitedArtifactRelatesToComponent(t, "CitationCitedArtifactComponent", "relatesTo", element.getRelatesTo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPublicationForm().size(); ++i2) {
            this.composeCitationCitedArtifactPublicationFormComponent(t, "CitationCitedArtifactComponent", "publicationForm", element.getPublicationForm().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getWebLocation().size(); ++i2) {
            this.composeCitationCitedArtifactWebLocationComponent(t, "CitationCitedArtifactComponent", "webLocation", element.getWebLocation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getClassification().size(); ++i2) {
            this.composeCitationCitedArtifactClassificationComponent(t, "CitationCitedArtifactComponent", "classification", element.getClassification().get(i2), i2);
        }
        if (element.hasContributorship()) {
            this.composeCitationCitedArtifactContributorshipComponent(t, "CitationCitedArtifactComponent", "contributorship", element.getContributorship(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "CitationCitedArtifactComponent", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeCitationCitedArtifactVersionComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasValueElement()) {
            this.composeString(t, "CitationCitedArtifactVersionComponent", "value", element.getValueElement(), -1);
        }
        if (element.hasBaseCitation()) {
            this.composeReference(t, "CitationCitedArtifactVersionComponent", "baseCitation", element.getBaseCitation(), -1);
        }
    }

    protected void composeCitationCitedArtifactStatusDateComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactStatusDateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusDate", name, element, index);
        if (element.hasActivity()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactStatusDateComponent", "activity", element.getActivity(), -1);
        }
        if (element.hasActualElement()) {
            this.composeBoolean(t, "CitationCitedArtifactStatusDateComponent", "actual", element.getActualElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CitationCitedArtifactStatusDateComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeCitationCitedArtifactTitleComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactTitleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "title", name, element, index);
        for (int i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "CitationCitedArtifactTitleComponent", "type", element.getType().get(i2), i2);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactTitleComponent", "language", element.getLanguage(), -1);
        }
        if (element.hasTextElement()) {
            this.composeMarkdown(t, "CitationCitedArtifactTitleComponent", "text", element.getTextElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactAbstractComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactAbstractComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "abstract", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactAbstractComponent", "type", element.getType(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactAbstractComponent", "language", element.getLanguage(), -1);
        }
        if (element.hasTextElement()) {
            this.composeMarkdown(t, "CitationCitedArtifactAbstractComponent", "text", element.getTextElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CitationCitedArtifactAbstractComponent", "copyright", element.getCopyrightElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactPartComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactPartComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "part", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactPartComponent", "type", element.getType(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "CitationCitedArtifactPartComponent", "value", element.getValueElement(), -1);
        }
        if (element.hasBaseCitation()) {
            this.composeReference(t, "CitationCitedArtifactPartComponent", "baseCitation", element.getBaseCitation(), -1);
        }
    }

    protected void composeCitationCitedArtifactRelatesToComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "CitationCitedArtifactRelatesToComponent", "type", element.getTypeElement(), -1);
        }
        for (int i2 = 0; i2 < element.getClassifier().size(); ++i2) {
            this.composeCodeableConcept(t, "CitationCitedArtifactRelatesToComponent", "classifier", element.getClassifier().get(i2), i2);
        }
        if (element.hasLabelElement()) {
            this.composeString(t, "CitationCitedArtifactRelatesToComponent", "label", element.getLabelElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "CitationCitedArtifactRelatesToComponent", "display", element.getDisplayElement(), -1);
        }
        if (element.hasCitationElement()) {
            this.composeMarkdown(t, "CitationCitedArtifactRelatesToComponent", "citation", element.getCitationElement(), -1);
        }
        if (element.hasDocument()) {
            this.composeAttachment(t, "CitationCitedArtifactRelatesToComponent", "document", element.getDocument(), -1);
        }
        if (element.hasResourceElement()) {
            this.composeCanonical(t, "CitationCitedArtifactRelatesToComponent", "resource", element.getResourceElement(), -1);
        }
        if (element.hasResourceReference()) {
            this.composeReference(t, "CitationCitedArtifactRelatesToComponent", "resourceReference", element.getResourceReference(), -1);
        }
    }

    protected void composeCitationCitedArtifactPublicationFormComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "publicationForm", name, element, index);
        if (element.hasPublishedIn()) {
            this.composeCitationCitedArtifactPublicationFormPublishedInComponent(t, "CitationCitedArtifactPublicationFormComponent", "publishedIn", element.getPublishedIn(), -1);
        }
        if (element.hasCitedMedium()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactPublicationFormComponent", "citedMedium", element.getCitedMedium(), -1);
        }
        if (element.hasVolumeElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "volume", element.getVolumeElement(), -1);
        }
        if (element.hasIssueElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "issue", element.getIssueElement(), -1);
        }
        if (element.hasPublicationDateYearElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "publicationDateYear", element.getPublicationDateYearElement(), -1);
        }
        if (element.hasPublicationDateMonthElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "publicationDateMonth", element.getPublicationDateMonthElement(), -1);
        }
        if (element.hasPublicationDateDayElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "publicationDateDay", element.getPublicationDateDayElement(), -1);
        }
        if (element.hasPublicationDateSeasonElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "publicationDateSeason", element.getPublicationDateSeasonElement(), -1);
        }
        if (element.hasPublicationDateTextElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "publicationDateText", element.getPublicationDateTextElement(), -1);
        }
        if (element.hasArticleDateElement()) {
            this.composeDateTime(t, "CitationCitedArtifactPublicationFormComponent", "articleDate", element.getArticleDateElement(), -1);
        }
        if (element.hasLastRevisionDateElement()) {
            this.composeDateTime(t, "CitationCitedArtifactPublicationFormComponent", "lastRevisionDate", element.getLastRevisionDateElement(), -1);
        }
        for (int i2 = 0; i2 < element.getLanguage().size(); ++i2) {
            this.composeCodeableConcept(t, "CitationCitedArtifactPublicationFormComponent", "language", element.getLanguage().get(i2), i2);
        }
        if (element.hasAccessionNumberElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "accessionNumber", element.getAccessionNumberElement(), -1);
        }
        if (element.hasPageStringElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "pageString", element.getPageStringElement(), -1);
        }
        if (element.hasFirstPageElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "firstPage", element.getFirstPageElement(), -1);
        }
        if (element.hasLastPageElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "lastPage", element.getLastPageElement(), -1);
        }
        if (element.hasPageCountElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormComponent", "pageCount", element.getPageCountElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CitationCitedArtifactPublicationFormComponent", "copyright", element.getCopyrightElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactPublicationFormPublishedInComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactPublicationFormPublishedInComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "publishedIn", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "type", element.getType(), -1);
        }
        for (int i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasPublisher()) {
            this.composeReference(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "publisher", element.getPublisher(), -1);
        }
        if (element.hasPublisherLocationElement()) {
            this.composeString(t, "CitationCitedArtifactPublicationFormPublishedInComponent", "publisherLocation", element.getPublisherLocationElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactWebLocationComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactWebLocationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "webLocation", name, element, index);
        for (int i2 = 0; i2 < element.getClassifier().size(); ++i2) {
            this.composeCodeableConcept(t, "CitationCitedArtifactWebLocationComponent", "classifier", element.getClassifier().get(i2), i2);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "CitationCitedArtifactWebLocationComponent", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactClassificationComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactClassificationComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "classification", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactClassificationComponent", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getClassifier().size(); ++i2) {
            this.composeCodeableConcept(t, "CitationCitedArtifactClassificationComponent", "classifier", element.getClassifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getArtifactAssessment().size(); ++i2) {
            this.composeReference(t, "CitationCitedArtifactClassificationComponent", "artifactAssessment", element.getArtifactAssessment().get(i2), i2);
        }
    }

    protected void composeCitationCitedArtifactContributorshipComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contributorship", name, element, index);
        if (element.hasCompleteElement()) {
            this.composeBoolean(t, "CitationCitedArtifactContributorshipComponent", "complete", element.getCompleteElement(), -1);
        }
        for (i2 = 0; i2 < element.getEntry().size(); ++i2) {
            this.composeCitationCitedArtifactContributorshipEntryComponent(t, "CitationCitedArtifactContributorshipComponent", "entry", element.getEntry().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSummary().size(); ++i2) {
            this.composeCitationContributorshipSummaryComponent(t, "CitationCitedArtifactContributorshipComponent", "summary", element.getSummary().get(i2), i2);
        }
    }

    protected void composeCitationCitedArtifactContributorshipEntryComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipEntryComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        if (element.hasContributor()) {
            this.composeReference(t, "CitationCitedArtifactContributorshipEntryComponent", "contributor", element.getContributor(), -1);
        }
        if (element.hasForenameInitialsElement()) {
            this.composeString(t, "CitationCitedArtifactContributorshipEntryComponent", "forenameInitials", element.getForenameInitialsElement(), -1);
        }
        for (i2 = 0; i2 < element.getAffiliation().size(); ++i2) {
            this.composeReference(t, "CitationCitedArtifactContributorshipEntryComponent", "affiliation", element.getAffiliation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContributionType().size(); ++i2) {
            this.composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryComponent", "contributionType", element.getContributionType().get(i2), i2);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryComponent", "role", element.getRole(), -1);
        }
        for (i2 = 0; i2 < element.getContributionInstance().size(); ++i2) {
            this.composeCitationCitedArtifactContributorshipEntryContributionInstanceComponent(t, "CitationCitedArtifactContributorshipEntryComponent", "contributionInstance", element.getContributionInstance().get(i2), i2);
        }
        if (element.hasCorrespondingContactElement()) {
            this.composeBoolean(t, "CitationCitedArtifactContributorshipEntryComponent", "correspondingContact", element.getCorrespondingContactElement(), -1);
        }
        if (element.hasRankingOrderElement()) {
            this.composePositiveInt(t, "CitationCitedArtifactContributorshipEntryComponent", "rankingOrder", element.getRankingOrderElement(), -1);
        }
    }

    protected void composeCitationCitedArtifactContributorshipEntryContributionInstanceComponent(Turtle.Complex parent, String parentType, String name, Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contributionInstance", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CitationCitedArtifactContributorshipEntryContributionInstanceComponent", "type", element.getType(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "CitationCitedArtifactContributorshipEntryContributionInstanceComponent", "time", element.getTimeElement(), -1);
        }
    }

    protected void composeCitationContributorshipSummaryComponent(Turtle.Complex parent, String parentType, String name, Citation.ContributorshipSummaryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "summary", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ContributorshipSummaryComponent", "type", element.getType(), -1);
        }
        if (element.hasStyle()) {
            this.composeCodeableConcept(t, "ContributorshipSummaryComponent", "style", element.getStyle(), -1);
        }
        if (element.hasSource()) {
            this.composeCodeableConcept(t, "ContributorshipSummaryComponent", "source", element.getSource(), -1);
        }
        if (element.hasValueElement()) {
            this.composeMarkdown(t, "ContributorshipSummaryComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaim(Turtle.Complex parent, String parentType, String name, Claim element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Claim", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Claim", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Claim", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Claim", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "Claim", "subType", element.getSubType(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "Claim", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Claim", "patient", element.getPatient(), -1);
        }
        if (element.hasBillablePeriod()) {
            this.composePeriod(t, "Claim", "billablePeriod", element.getBillablePeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "Claim", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "Claim", "enterer", element.getEnterer(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "Claim", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "Claim", "provider", element.getProvider(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Claim", "priority", element.getPriority(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCodeableConcept(t, "Claim", "fundsReserve", element.getFundsReserve(), -1);
        }
        for (i2 = 0; i2 < element.getRelated().size(); ++i2) {
            this.composeClaimRelatedClaimComponent(t, "Claim", "related", element.getRelated().get(i2), i2);
        }
        if (element.hasPrescription()) {
            this.composeReference(t, "Claim", "prescription", element.getPrescription(), -1);
        }
        if (element.hasOriginalPrescription()) {
            this.composeReference(t, "Claim", "originalPrescription", element.getOriginalPrescription(), -1);
        }
        if (element.hasPayee()) {
            this.composeClaimPayeeComponent(t, "Claim", "payee", element.getPayee(), -1);
        }
        if (element.hasReferral()) {
            this.composeReference(t, "Claim", "referral", element.getReferral(), -1);
        }
        for (i2 = 0; i2 < element.getEncounter().size(); ++i2) {
            this.composeReference(t, "Claim", "encounter", element.getEncounter().get(i2), i2);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "Claim", "facility", element.getFacility(), -1);
        }
        if (element.hasDiagnosisRelatedGroup()) {
            this.composeCodeableConcept(t, "Claim", "diagnosisRelatedGroup", element.getDiagnosisRelatedGroup(), -1);
        }
        for (i2 = 0; i2 < element.getCareTeam().size(); ++i2) {
            this.composeClaimCareTeamComponent(t, "Claim", "careTeam", element.getCareTeam().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingInfo().size(); ++i2) {
            this.composeClaimSupportingInformationComponent(t, "Claim", "supportingInfo", element.getSupportingInfo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDiagnosis().size(); ++i2) {
            this.composeClaimDiagnosisComponent(t, "Claim", "diagnosis", element.getDiagnosis().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProcedure().size(); ++i2) {
            this.composeClaimProcedureComponent(t, "Claim", "procedure", element.getProcedure().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInsurance().size(); ++i2) {
            this.composeClaimInsuranceComponent(t, "Claim", "insurance", element.getInsurance().get(i2), i2);
        }
        if (element.hasAccident()) {
            this.composeClaimAccidentComponent(t, "Claim", "accident", element.getAccident(), -1);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "Claim", "patientPaid", element.getPatientPaid(), -1);
        }
        for (i2 = 0; i2 < element.getItem().size(); ++i2) {
            this.composeClaimItemComponent(t, "Claim", "item", element.getItem().get(i2), i2);
        }
        if (element.hasTotal()) {
            this.composeMoney(t, "Claim", "total", element.getTotal(), -1);
        }
    }

    protected void composeClaimRelatedClaimComponent(Turtle.Complex parent, String parentType, String name, Claim.RelatedClaimComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasClaim()) {
            this.composeReference(t, "RelatedClaimComponent", "claim", element.getClaim(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "RelatedClaimComponent", "relationship", element.getRelationship(), -1);
        }
        if (element.hasReference()) {
            this.composeIdentifier(t, "RelatedClaimComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeClaimPayeeComponent(Turtle.Complex parent, String parentType, String name, Claim.PayeeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payee", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PayeeComponent", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "PayeeComponent", "party", element.getParty(), -1);
        }
    }

    protected void composeClaimCareTeamComponent(Turtle.Complex parent, String parentType, String name, Claim.CareTeamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "careTeam", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "CareTeamComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "CareTeamComponent", "provider", element.getProvider(), -1);
        }
        if (element.hasResponsibleElement()) {
            this.composeBoolean(t, "CareTeamComponent", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "CareTeamComponent", "role", element.getRole(), -1);
        }
        if (element.hasSpecialty()) {
            this.composeCodeableConcept(t, "CareTeamComponent", "specialty", element.getSpecialty(), -1);
        }
    }

    protected void composeClaimSupportingInformationComponent(Turtle.Complex parent, String parentType, String name, Claim.SupportingInformationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "SupportingInformationComponent", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "SupportingInformationComponent", "code", element.getCode(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "SupportingInformationComponent", "timing", element.getTiming(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "SupportingInformationComponent", "value", element.getValue(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "SupportingInformationComponent", "reason", element.getReason(), -1);
        }
    }

    protected void composeClaimDiagnosisComponent(Turtle.Complex parent, String parentType, String name, Claim.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "DiagnosisComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDiagnosis()) {
            this.composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
        }
        for (int i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "type", element.getType().get(i2), i2);
        }
        if (element.hasOnAdmission()) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "onAdmission", element.getOnAdmission(), -1);
        }
    }

    protected void composeClaimProcedureComponent(Turtle.Complex parent, String parentType, String name, Claim.ProcedureComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ProcedureComponent", "sequence", element.getSequenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "ProcedureComponent", "type", element.getType().get(i2), i2);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ProcedureComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeType(t, "ProcedureComponent", "procedure", element.getProcedure(), -1);
        }
        for (i2 = 0; i2 < element.getUdi().size(); ++i2) {
            this.composeReference(t, "ProcedureComponent", "udi", element.getUdi().get(i2), i2);
        }
    }

    protected void composeClaimInsuranceComponent(Turtle.Complex parent, String parentType, String name, Claim.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "InsuranceComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "InsuranceComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        for (int i2 = 0; i2 < element.getPreAuthRef().size(); ++i2) {
            this.composeString(t, "InsuranceComponent", "preAuthRef", element.getPreAuthRef().get(i2), i2);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "InsuranceComponent", "claimResponse", element.getClaimResponse(), -1);
        }
    }

    protected void composeClaimAccidentComponent(Turtle.Complex parent, String parentType, String name, Claim.AccidentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "accident", name, element, index);
        if (element.hasDateElement()) {
            this.composeDate(t, "AccidentComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AccidentComponent", "type", element.getType(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "AccidentComponent", "location", element.getLocation(), -1);
        }
    }

    protected void composeClaimItemComponent(Turtle.Complex parent, String parentType, String name, Claim.ItemComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ItemComponent", "sequence", element.getSequenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getCareTeamSequence().size(); ++i2) {
            this.composePositiveInt(t, "ItemComponent", "careTeamSequence", element.getCareTeamSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDiagnosisSequence().size(); ++i2) {
            this.composePositiveInt(t, "ItemComponent", "diagnosisSequence", element.getDiagnosisSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProcedureSequence().size(); ++i2) {
            this.composePositiveInt(t, "ItemComponent", "procedureSequence", element.getProcedureSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInformationSequence().size(); ++i2) {
            this.composePositiveInt(t, "ItemComponent", "informationSequence", element.getInformationSequence().get(i2), i2);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "ItemComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ItemComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ItemComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "ItemComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "ItemComponent", "modifier", element.getModifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgramCode().size(); ++i2) {
            this.composeCodeableConcept(t, "ItemComponent", "programCode", element.getProgramCode().get(i2), i2);
        }
        if (element.hasServiced()) {
            this.composeType(t, "ItemComponent", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "ItemComponent", "location", element.getLocation(), -1);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "ItemComponent", "patientPaid", element.getPatientPaid(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ItemComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ItemComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ItemComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "ItemComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ItemComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getUdi().size(); ++i2) {
            this.composeReference(t, "ItemComponent", "udi", element.getUdi().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBodySite().size(); ++i2) {
            this.composeClaimBodySiteComponent(t, "ItemComponent", "bodySite", element.getBodySite().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEncounter().size(); ++i2) {
            this.composeReference(t, "ItemComponent", "encounter", element.getEncounter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDetail().size(); ++i2) {
            this.composeClaimDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i2), i2);
        }
    }

    protected void composeClaimBodySiteComponent(Turtle.Complex parent, String parentType, String name, Claim.BodySiteComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "bodySite", name, element, index);
        for (i2 = 0; i2 < element.getSite().size(); ++i2) {
            this.composeCodeableReference(t, "BodySiteComponent", "site", element.getSite().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubSite().size(); ++i2) {
            this.composeCodeableConcept(t, "BodySiteComponent", "subSite", element.getSubSite().get(i2), i2);
        }
    }

    protected void composeClaimDetailComponent(Turtle.Complex parent, String parentType, String name, Claim.DetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "DetailComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "DetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "DetailComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "DetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "DetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "DetailComponent", "modifier", element.getModifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgramCode().size(); ++i2) {
            this.composeCodeableConcept(t, "DetailComponent", "programCode", element.getProgramCode().get(i2), i2);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "DetailComponent", "patientPaid", element.getPatientPaid(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "DetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "DetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "DetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "DetailComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "DetailComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getUdi().size(); ++i2) {
            this.composeReference(t, "DetailComponent", "udi", element.getUdi().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubDetail().size(); ++i2) {
            this.composeClaimSubDetailComponent(t, "DetailComponent", "subDetail", element.getSubDetail().get(i2), i2);
        }
    }

    protected void composeClaimSubDetailComponent(Turtle.Complex parent, String parentType, String name, Claim.SubDetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "SubDetailComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "SubDetailComponent", "modifier", element.getModifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgramCode().size(); ++i2) {
            this.composeCodeableConcept(t, "SubDetailComponent", "programCode", element.getProgramCode().get(i2), i2);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "SubDetailComponent", "patientPaid", element.getPatientPaid(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "SubDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "SubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "SubDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "SubDetailComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "SubDetailComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getUdi().size(); ++i2) {
            this.composeReference(t, "SubDetailComponent", "udi", element.getUdi().get(i2), i2);
        }
    }

    protected void composeClaimResponse(Turtle.Complex parent, String parentType, String name, ClaimResponse element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ClaimResponse", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ClaimResponse", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ClaimResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "subType", element.getSubType(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ClaimResponse", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ClaimResponse", "patient", element.getPatient(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ClaimResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "ClaimResponse", "insurer", element.getInsurer(), -1);
        }
        if (element.hasRequestor()) {
            this.composeReference(t, "ClaimResponse", "requestor", element.getRequestor(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "ClaimResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "ClaimResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "ClaimResponse", "decision", element.getDecision(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ClaimResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasPreAuthRefElement()) {
            this.composeString(t, "ClaimResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
        }
        if (element.hasPreAuthPeriod()) {
            this.composePeriod(t, "ClaimResponse", "preAuthPeriod", element.getPreAuthPeriod(), -1);
        }
        if (element.hasPayeeType()) {
            this.composeCodeableConcept(t, "ClaimResponse", "payeeType", element.getPayeeType(), -1);
        }
        for (i2 = 0; i2 < element.getEncounter().size(); ++i2) {
            this.composeReference(t, "ClaimResponse", "encounter", element.getEncounter().get(i2), i2);
        }
        if (element.hasDiagnosisRelatedGroup()) {
            this.composeCodeableConcept(t, "ClaimResponse", "diagnosisRelatedGroup", element.getDiagnosisRelatedGroup(), -1);
        }
        for (i2 = 0; i2 < element.getItem().size(); ++i2) {
            this.composeClaimResponseItemComponent(t, "ClaimResponse", "item", element.getItem().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAddItem().size(); ++i2) {
            this.composeClaimResponseAddedItemComponent(t, "ClaimResponse", "addItem", element.getAddItem().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeClaimResponseAdjudicationComponent(t, "ClaimResponse", "adjudication", element.getAdjudication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTotal().size(); ++i2) {
            this.composeClaimResponseTotalComponent(t, "ClaimResponse", "total", element.getTotal().get(i2), i2);
        }
        if (element.hasPayment()) {
            this.composeClaimResponsePaymentComponent(t, "ClaimResponse", "payment", element.getPayment(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCodeableConcept(t, "ClaimResponse", "fundsReserve", element.getFundsReserve(), -1);
        }
        if (element.hasFormCode()) {
            this.composeCodeableConcept(t, "ClaimResponse", "formCode", element.getFormCode(), -1);
        }
        if (element.hasForm()) {
            this.composeAttachment(t, "ClaimResponse", "form", element.getForm(), -1);
        }
        for (i2 = 0; i2 < element.getProcessNote().size(); ++i2) {
            this.composeClaimResponseNoteComponent(t, "ClaimResponse", "processNote", element.getProcessNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCommunicationRequest().size(); ++i2) {
            this.composeReference(t, "ClaimResponse", "communicationRequest", element.getCommunicationRequest().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInsurance().size(); ++i2) {
            this.composeClaimResponseInsuranceComponent(t, "ClaimResponse", "insurance", element.getInsurance().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getError().size(); ++i2) {
            this.composeClaimResponseErrorComponent(t, "ClaimResponse", "error", element.getError().get(i2), i2);
        }
    }

    protected void composeClaimResponseItemComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ItemComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasItemSequenceElement()) {
            this.composePositiveInt(t, "ItemComponent", "itemSequence", element.getItemSequenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "ItemComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "ItemComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeClaimResponseAdjudicationComponent(t, "ItemComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDetail().size(); ++i2) {
            this.composeClaimResponseItemDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i2), i2);
        }
    }

    protected void composeClaimResponseAdjudicationComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "AdjudicationComponent", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "AdjudicationComponent", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "AdjudicationComponent", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "AdjudicationComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeClaimResponseItemDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ItemDetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasDetailSequenceElement()) {
            this.composePositiveInt(t, "ItemDetailComponent", "detailSequence", element.getDetailSequenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "ItemDetailComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "ItemDetailComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeClaimResponseAdjudicationComponent(t, "ItemDetailComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubDetail().size(); ++i2) {
            this.composeClaimResponseSubDetailComponent(t, "ItemDetailComponent", "subDetail", element.getSubDetail().get(i2), i2);
        }
    }

    protected void composeClaimResponseSubDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.SubDetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSubDetailSequenceElement()) {
            this.composePositiveInt(t, "SubDetailComponent", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "SubDetailComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeClaimResponseAdjudicationComponent(t, "SubDetailComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
    }

    protected void composeClaimResponseAddedItemComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AddedItemComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "addItem", name, element, index);
        for (i2 = 0; i2 < element.getItemSequence().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemComponent", "itemSequence", element.getItemSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDetailSequence().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemComponent", "detailSequence", element.getDetailSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubdetailSequence().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemComponent", "subdetailSequence", element.getSubdetailSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProvider().size(); ++i2) {
            this.composeReference(t, "AddedItemComponent", "provider", element.getProvider().get(i2), i2);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "AddedItemComponent", "modifier", element.getModifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgramCode().size(); ++i2) {
            this.composeCodeableConcept(t, "AddedItemComponent", "programCode", element.getProgramCode().get(i2), i2);
        }
        if (element.hasServiced()) {
            this.composeType(t, "AddedItemComponent", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "AddedItemComponent", "location", element.getLocation(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "AddedItemComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getBodySite().size(); ++i2) {
            this.composeClaimResponseBodySiteComponent(t, "AddedItemComponent", "bodySite", element.getBodySite().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeClaimResponseAdjudicationComponent(t, "AddedItemComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDetail().size(); ++i2) {
            this.composeClaimResponseAddedItemDetailComponent(t, "AddedItemComponent", "detail", element.getDetail().get(i2), i2);
        }
    }

    protected void composeClaimResponseBodySiteComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.BodySiteComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "bodySite", name, element, index);
        for (i2 = 0; i2 < element.getSite().size(); ++i2) {
            this.composeCodeableReference(t, "BodySiteComponent", "site", element.getSite().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubSite().size(); ++i2) {
            this.composeCodeableConcept(t, "BodySiteComponent", "subSite", element.getSubSite().get(i2), i2);
        }
    }

    protected void composeClaimResponseAddedItemDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AddedItemDetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "modifier", element.getModifier().get(i2), i2);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "AddedItemDetailComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemDetailComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemDetailComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeClaimResponseAdjudicationComponent(t, "AddedItemDetailComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubDetail().size(); ++i2) {
            this.composeClaimResponseAddedItemSubDetailComponent(t, "AddedItemDetailComponent", "subDetail", element.getSubDetail().get(i2), i2);
        }
    }

    protected void composeClaimResponseAddedItemSubDetailComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.AddedItemSubDetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "AddedItemSubDetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemSubDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "AddedItemSubDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "AddedItemSubDetailComponent", "modifier", element.getModifier().get(i2), i2);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemSubDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemSubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemSubDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "AddedItemSubDetailComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemSubDetailComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemSubDetailComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "AddedItemSubDetailComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeClaimResponseAdjudicationComponent(t, "AddedItemSubDetailComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
    }

    protected void composeClaimResponseTotalComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.TotalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "total", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "TotalComponent", "category", element.getCategory(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "TotalComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeClaimResponsePaymentComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.PaymentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payment", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PaymentComponent", "type", element.getType(), -1);
        }
        if (element.hasAdjustment()) {
            this.composeMoney(t, "PaymentComponent", "adjustment", element.getAdjustment(), -1);
        }
        if (element.hasAdjustmentReason()) {
            this.composeCodeableConcept(t, "PaymentComponent", "adjustmentReason", element.getAdjustmentReason(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "PaymentComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "PaymentComponent", "amount", element.getAmount(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "PaymentComponent", "identifier", element.getIdentifier(), -1);
        }
    }

    protected void composeClaimResponseNoteComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.NoteComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasNumberElement()) {
            this.composePositiveInt(t, "NoteComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "NoteComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "NoteComponent", "text", element.getTextElement(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "NoteComponent", "language", element.getLanguage(), -1);
        }
    }

    protected void composeClaimResponseInsuranceComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "InsuranceComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "InsuranceComponent", "claimResponse", element.getClaimResponse(), -1);
        }
    }

    protected void composeClaimResponseErrorComponent(Turtle.Complex parent, String parentType, String name, ClaimResponse.ErrorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "error", name, element, index);
        if (element.hasItemSequenceElement()) {
            this.composePositiveInt(t, "ErrorComponent", "itemSequence", element.getItemSequenceElement(), -1);
        }
        if (element.hasDetailSequenceElement()) {
            this.composePositiveInt(t, "ErrorComponent", "detailSequence", element.getDetailSequenceElement(), -1);
        }
        if (element.hasSubDetailSequenceElement()) {
            this.composePositiveInt(t, "ErrorComponent", "subDetailSequence", element.getSubDetailSequenceElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ErrorComponent", "code", element.getCode(), -1);
        }
    }

    protected void composeClinicalImpression(Turtle.Complex parent, String parentType, String name, ClinicalImpression element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ClinicalImpression", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ClinicalImpression", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ClinicalImpression", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ClinicalImpression", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ClinicalImpression", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ClinicalImpression", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "ClinicalImpression", "effective", element.getEffective(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ClinicalImpression", "date", element.getDateElement(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "ClinicalImpression", "performer", element.getPerformer(), -1);
        }
        if (element.hasPrevious()) {
            this.composeReference(t, "ClinicalImpression", "previous", element.getPrevious(), -1);
        }
        for (i2 = 0; i2 < element.getProblem().size(); ++i2) {
            this.composeReference(t, "ClinicalImpression", "problem", element.getProblem().get(i2), i2);
        }
        if (element.hasChangePattern()) {
            this.composeCodeableConcept(t, "ClinicalImpression", "changePattern", element.getChangePattern(), -1);
        }
        for (i2 = 0; i2 < element.getProtocol().size(); ++i2) {
            this.composeUri(t, "ClinicalImpression", "protocol", element.getProtocol().get(i2), i2);
        }
        if (element.hasSummaryElement()) {
            this.composeString(t, "ClinicalImpression", "summary", element.getSummaryElement(), -1);
        }
        for (i2 = 0; i2 < element.getFinding().size(); ++i2) {
            this.composeClinicalImpressionFindingComponent(t, "ClinicalImpression", "finding", element.getFinding().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPrognosisCodeableConcept().size(); ++i2) {
            this.composeCodeableConcept(t, "ClinicalImpression", "prognosisCodeableConcept", element.getPrognosisCodeableConcept().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPrognosisReference().size(); ++i2) {
            this.composeReference(t, "ClinicalImpression", "prognosisReference", element.getPrognosisReference().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingInfo().size(); ++i2) {
            this.composeReference(t, "ClinicalImpression", "supportingInfo", element.getSupportingInfo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "ClinicalImpression", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeClinicalImpressionFindingComponent(Turtle.Complex parent, String parentType, String name, ClinicalImpression.ClinicalImpressionFindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "finding", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableReference(t, "ClinicalImpressionFindingComponent", "item", element.getItem(), -1);
        }
        if (element.hasBasisElement()) {
            this.composeString(t, "ClinicalImpressionFindingComponent", "basis", element.getBasisElement(), -1);
        }
    }

    protected void composeClinicalUseDefinition(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ClinicalUseDefinition", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ClinicalUseDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ClinicalUseDefinition", "type", element.getTypeElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "ClinicalUseDefinition", "category", element.getCategory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubject().size(); ++i2) {
            this.composeReference(t, "ClinicalUseDefinition", "subject", element.getSubject().get(i2), i2);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinition", "status", element.getStatus(), -1);
        }
        if (element.hasContraindication()) {
            this.composeClinicalUseDefinitionContraindicationComponent(t, "ClinicalUseDefinition", "contraindication", element.getContraindication(), -1);
        }
        if (element.hasIndication()) {
            this.composeClinicalUseDefinitionIndicationComponent(t, "ClinicalUseDefinition", "indication", element.getIndication(), -1);
        }
        if (element.hasInteraction()) {
            this.composeClinicalUseDefinitionInteractionComponent(t, "ClinicalUseDefinition", "interaction", element.getInteraction(), -1);
        }
        for (i2 = 0; i2 < element.getPopulation().size(); ++i2) {
            this.composeReference(t, "ClinicalUseDefinition", "population", element.getPopulation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getLibrary().size(); ++i2) {
            this.composeCanonical(t, "ClinicalUseDefinition", "library", element.getLibrary().get(i2), i2);
        }
        if (element.hasUndesirableEffect()) {
            this.composeClinicalUseDefinitionUndesirableEffectComponent(t, "ClinicalUseDefinition", "undesirableEffect", element.getUndesirableEffect(), -1);
        }
        if (element.hasWarning()) {
            this.composeClinicalUseDefinitionWarningComponent(t, "ClinicalUseDefinition", "warning", element.getWarning(), -1);
        }
    }

    protected void composeClinicalUseDefinitionContraindicationComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contraindication", name, element, index);
        if (element.hasDiseaseSymptomProcedure()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "diseaseSymptomProcedure", element.getDiseaseSymptomProcedure(), -1);
        }
        if (element.hasDiseaseStatus()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "diseaseStatus", element.getDiseaseStatus(), -1);
        }
        for (i2 = 0; i2 < element.getComorbidity().size(); ++i2) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionContraindicationComponent", "comorbidity", element.getComorbidity().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIndication().size(); ++i2) {
            this.composeReference(t, "ClinicalUseDefinitionContraindicationComponent", "indication", element.getIndication().get(i2), i2);
        }
        if (element.hasApplicability()) {
            this.composeExpression(t, "ClinicalUseDefinitionContraindicationComponent", "applicability", element.getApplicability(), -1);
        }
        for (i2 = 0; i2 < element.getOtherTherapy().size(); ++i2) {
            this.composeClinicalUseDefinitionContraindicationOtherTherapyComponent(t, "ClinicalUseDefinitionContraindicationComponent", "otherTherapy", element.getOtherTherapy().get(i2), i2);
        }
    }

    protected void composeClinicalUseDefinitionContraindicationOtherTherapyComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "otherTherapy", name, element, index);
        if (element.hasRelationshipType()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionContraindicationOtherTherapyComponent", "relationshipType", element.getRelationshipType(), -1);
        }
        if (element.hasTreatment()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionContraindicationOtherTherapyComponent", "treatment", element.getTreatment(), -1);
        }
    }

    protected void composeClinicalUseDefinitionIndicationComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "indication", name, element, index);
        if (element.hasDiseaseSymptomProcedure()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "diseaseSymptomProcedure", element.getDiseaseSymptomProcedure(), -1);
        }
        if (element.hasDiseaseStatus()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "diseaseStatus", element.getDiseaseStatus(), -1);
        }
        for (i2 = 0; i2 < element.getComorbidity().size(); ++i2) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "comorbidity", element.getComorbidity().get(i2), i2);
        }
        if (element.hasIntendedEffect()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionIndicationComponent", "intendedEffect", element.getIntendedEffect(), -1);
        }
        if (element.hasDuration()) {
            this.composeType(t, "ClinicalUseDefinitionIndicationComponent", "duration", element.getDuration(), -1);
        }
        for (i2 = 0; i2 < element.getUndesirableEffect().size(); ++i2) {
            this.composeReference(t, "ClinicalUseDefinitionIndicationComponent", "undesirableEffect", element.getUndesirableEffect().get(i2), i2);
        }
        if (element.hasApplicability()) {
            this.composeExpression(t, "ClinicalUseDefinitionIndicationComponent", "applicability", element.getApplicability(), -1);
        }
        for (i2 = 0; i2 < element.getOtherTherapy().size(); ++i2) {
            this.composeClinicalUseDefinitionContraindicationOtherTherapyComponent(t, "ClinicalUseDefinitionIndicationComponent", "otherTherapy", element.getOtherTherapy().get(i2), i2);
        }
    }

    protected void composeClinicalUseDefinitionInteractionComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interaction", name, element, index);
        for (i2 = 0; i2 < element.getInteractant().size(); ++i2) {
            this.composeClinicalUseDefinitionInteractionInteractantComponent(t, "ClinicalUseDefinitionInteractionComponent", "interactant", element.getInteractant().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "type", element.getType(), -1);
        }
        if (element.hasEffect()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionInteractionComponent", "effect", element.getEffect(), -1);
        }
        if (element.hasIncidence()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "incidence", element.getIncidence(), -1);
        }
        for (i2 = 0; i2 < element.getManagement().size(); ++i2) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionInteractionComponent", "management", element.getManagement().get(i2), i2);
        }
    }

    protected void composeClinicalUseDefinitionInteractionInteractantComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "interactant", name, element, index);
        if (element.hasItem()) {
            this.composeType(t, "ClinicalUseDefinitionInteractionInteractantComponent", "item", element.getItem(), -1);
        }
    }

    protected void composeClinicalUseDefinitionUndesirableEffectComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "undesirableEffect", name, element, index);
        if (element.hasSymptomConditionEffect()) {
            this.composeCodeableReference(t, "ClinicalUseDefinitionUndesirableEffectComponent", "symptomConditionEffect", element.getSymptomConditionEffect(), -1);
        }
        if (element.hasClassification()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionUndesirableEffectComponent", "classification", element.getClassification(), -1);
        }
        if (element.hasFrequencyOfOccurrence()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionUndesirableEffectComponent", "frequencyOfOccurrence", element.getFrequencyOfOccurrence(), -1);
        }
    }

    protected void composeClinicalUseDefinitionWarningComponent(Turtle.Complex parent, String parentType, String name, ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "warning", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ClinicalUseDefinitionWarningComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ClinicalUseDefinitionWarningComponent", "code", element.getCode(), -1);
        }
    }

    protected void composeCodeSystem(Turtle.Complex parent, String parentType, String name, CodeSystem element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "CodeSystem", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CodeSystem", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "CodeSystem", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CodeSystem", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CodeSystem", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CodeSystem", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CodeSystem", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CodeSystem", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CodeSystem", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CodeSystem", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "CodeSystem", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CodeSystem", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "CodeSystem", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "CodeSystem", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CodeSystem", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "CodeSystem", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "CodeSystem", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "CodeSystem", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "CodeSystem", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getTopic().size(); ++i2) {
            this.composeCodeableConcept(t, "CodeSystem", "topic", element.getTopic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "CodeSystem", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "CodeSystem", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "CodeSystem", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "CodeSystem", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "CodeSystem", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        if (element.hasCaseSensitiveElement()) {
            this.composeBoolean(t, "CodeSystem", "caseSensitive", element.getCaseSensitiveElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "CodeSystem", "valueSet", element.getValueSetElement(), -1);
        }
        if (element.hasHierarchyMeaningElement()) {
            this.composeEnum(t, "CodeSystem", "hierarchyMeaning", element.getHierarchyMeaningElement(), -1);
        }
        if (element.hasCompositionalElement()) {
            this.composeBoolean(t, "CodeSystem", "compositional", element.getCompositionalElement(), -1);
        }
        if (element.hasVersionNeededElement()) {
            this.composeBoolean(t, "CodeSystem", "versionNeeded", element.getVersionNeededElement(), -1);
        }
        if (element.hasContentElement()) {
            this.composeEnum(t, "CodeSystem", "content", element.getContentElement(), -1);
        }
        if (element.hasSupplementsElement()) {
            this.composeCanonical(t, "CodeSystem", "supplements", element.getSupplementsElement(), -1);
        }
        if (element.hasCountElement()) {
            this.composeUnsignedInt(t, "CodeSystem", "count", element.getCountElement(), -1);
        }
        for (i2 = 0; i2 < element.getFilter().size(); ++i2) {
            this.composeCodeSystemFilterComponent(t, "CodeSystem", "filter", element.getFilter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProperty().size(); ++i2) {
            this.composeCodeSystemPropertyComponent(t, "CodeSystem", "property", element.getProperty().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getConcept().size(); ++i2) {
            this.composeCodeSystemConceptDefinitionComponent(t, "CodeSystem", "concept", element.getConcept().get(i2), i2);
        }
    }

    protected void composeCodeSystemFilterComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.CodeSystemFilterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "filter", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CodeSystemFilterComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "CodeSystemFilterComponent", "description", element.getDescriptionElement(), -1);
        }
        for (int i2 = 0; i2 < element.getOperator().size(); ++i2) {
            this.composeEnum(t, "CodeSystemFilterComponent", "operator", element.getOperator().get(i2), i2);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "CodeSystemFilterComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeCodeSystemPropertyComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.PropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "PropertyComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasUriElement()) {
            this.composeUri(t, "PropertyComponent", "uri", element.getUriElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "PropertyComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "PropertyComponent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeCodeSystemConceptDefinitionComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "concept", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptDefinitionComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptDefinitionComponent", "display", element.getDisplayElement(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeString(t, "ConceptDefinitionComponent", "definition", element.getDefinitionElement(), -1);
        }
        for (i2 = 0; i2 < element.getDesignation().size(); ++i2) {
            this.composeCodeSystemConceptDefinitionDesignationComponent(t, "ConceptDefinitionComponent", "designation", element.getDesignation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProperty().size(); ++i2) {
            this.composeCodeSystemConceptPropertyComponent(t, "ConceptDefinitionComponent", "property", element.getProperty().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getConcept().size(); ++i2) {
            this.composeCodeSystemConceptDefinitionComponent(t, "ConceptDefinitionComponent", "concept", element.getConcept().get(i2), i2);
        }
    }

    protected void composeCodeSystemConceptDefinitionDesignationComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptDefinitionDesignationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "designation", name, element, index);
        if (element.hasLanguageElement()) {
            this.composeCode(t, "ConceptDefinitionDesignationComponent", "language", element.getLanguageElement(), -1);
        }
        if (element.hasUse()) {
            this.composeCoding(t, "ConceptDefinitionDesignationComponent", "use", element.getUse(), -1);
        }
        for (int i2 = 0; i2 < element.getAdditionalUse().size(); ++i2) {
            this.composeCoding(t, "ConceptDefinitionDesignationComponent", "additionalUse", element.getAdditionalUse().get(i2), i2);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ConceptDefinitionDesignationComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeCodeSystemConceptPropertyComponent(Turtle.Complex parent, String parentType, String name, CodeSystem.ConceptPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptPropertyComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ConceptPropertyComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeCommunication(Turtle.Complex parent, String parentType, String name, Communication element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Communication", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Communication", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesCanonical().size(); ++i2) {
            this.composeCanonical(t, "Communication", "instantiatesCanonical", element.getInstantiatesCanonical().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesUri().size(); ++i2) {
            this.composeUri(t, "Communication", "instantiatesUri", element.getInstantiatesUri().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "Communication", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPartOf().size(); ++i2) {
            this.composeReference(t, "Communication", "partOf", element.getPartOf().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInResponseTo().size(); ++i2) {
            this.composeReference(t, "Communication", "inResponseTo", element.getInResponseTo().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Communication", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Communication", "statusReason", element.getStatusReason(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "Communication", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "Communication", "priority", element.getPriorityElement(), -1);
        }
        for (i2 = 0; i2 < element.getMedium().size(); ++i2) {
            this.composeCodeableConcept(t, "Communication", "medium", element.getMedium().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Communication", "subject", element.getSubject(), -1);
        }
        if (element.hasTopic()) {
            this.composeCodeableConcept(t, "Communication", "topic", element.getTopic(), -1);
        }
        for (i2 = 0; i2 < element.getAbout().size(); ++i2) {
            this.composeReference(t, "Communication", "about", element.getAbout().get(i2), i2);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Communication", "encounter", element.getEncounter(), -1);
        }
        if (element.hasSentElement()) {
            this.composeDateTime(t, "Communication", "sent", element.getSentElement(), -1);
        }
        if (element.hasReceivedElement()) {
            this.composeDateTime(t, "Communication", "received", element.getReceivedElement(), -1);
        }
        for (i2 = 0; i2 < element.getRecipient().size(); ++i2) {
            this.composeReference(t, "Communication", "recipient", element.getRecipient().get(i2), i2);
        }
        if (element.hasSender()) {
            this.composeReference(t, "Communication", "sender", element.getSender(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "Communication", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPayload().size(); ++i2) {
            this.composeCommunicationPayloadComponent(t, "Communication", "payload", element.getPayload().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Communication", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeCommunicationPayloadComponent(Turtle.Complex parent, String parentType, String name, Communication.CommunicationPayloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payload", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "CommunicationPayloadComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeCommunicationRequest(Turtle.Complex parent, String parentType, String name, CommunicationRequest element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CommunicationRequest", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "CommunicationRequest", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "CommunicationRequest", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReplaces().size(); ++i2) {
            this.composeReference(t, "CommunicationRequest", "replaces", element.getReplaces().get(i2), i2);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "CommunicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CommunicationRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "CommunicationRequest", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "CommunicationRequest", "intent", element.getIntentElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "CommunicationRequest", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "CommunicationRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "CommunicationRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        for (i2 = 0; i2 < element.getMedium().size(); ++i2) {
            this.composeCodeableConcept(t, "CommunicationRequest", "medium", element.getMedium().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "CommunicationRequest", "subject", element.getSubject(), -1);
        }
        for (i2 = 0; i2 < element.getAbout().size(); ++i2) {
            this.composeReference(t, "CommunicationRequest", "about", element.getAbout().get(i2), i2);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "CommunicationRequest", "encounter", element.getEncounter(), -1);
        }
        for (i2 = 0; i2 < element.getPayload().size(); ++i2) {
            this.composeCommunicationRequestPayloadComponent(t, "CommunicationRequest", "payload", element.getPayload().get(i2), i2);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "CommunicationRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "CommunicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "CommunicationRequest", "requester", element.getRequester(), -1);
        }
        for (i2 = 0; i2 < element.getRecipient().size(); ++i2) {
            this.composeReference(t, "CommunicationRequest", "recipient", element.getRecipient().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInformationProvider().size(); ++i2) {
            this.composeReference(t, "CommunicationRequest", "informationProvider", element.getInformationProvider().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "CommunicationRequest", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "CommunicationRequest", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeCommunicationRequestPayloadComponent(Turtle.Complex parent, String parentType, String name, CommunicationRequest.CommunicationRequestPayloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payload", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "CommunicationRequestPayloadComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeCompartmentDefinition(Turtle.Complex parent, String parentType, String name, CompartmentDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeCanonicalResource(t, "CompartmentDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "CompartmentDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "CompartmentDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasVersionAlgorithm()) {
            this.composeType(t, "CompartmentDefinition", "versionAlgorithm", element.getVersionAlgorithm(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "CompartmentDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "CompartmentDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CompartmentDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "CompartmentDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "CompartmentDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "CompartmentDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "CompartmentDefinition", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "CompartmentDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "CompartmentDefinition", "useContext", element.getUseContext().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "CompartmentDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "CompartmentDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasSearchElement()) {
            this.composeBoolean(t, "CompartmentDefinition", "search", element.getSearchElement(), -1);
        }
        for (i2 = 0; i2 < element.getResource().size(); ++i2) {
            this.composeCompartmentDefinitionResourceComponent(t, "CompartmentDefinition", "resource", element.getResource().get(i2), i2);
        }
    }

    protected void composeCompartmentDefinitionResourceComponent(Turtle.Complex parent, String parentType, String name, CompartmentDefinition.CompartmentDefinitionResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "CompartmentDefinitionResourceComponent", "code", element.getCodeElement(), -1);
        }
        for (int i2 = 0; i2 < element.getParam().size(); ++i2) {
            this.composeString(t, "CompartmentDefinitionResourceComponent", "param", element.getParam().get(i2), i2);
        }
        if (element.hasDocumentationElement()) {
            this.composeString(t, "CompartmentDefinitionResourceComponent", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasStartParamElement()) {
            this.composeUri(t, "CompartmentDefinitionResourceComponent", "startParam", element.getStartParamElement(), -1);
        }
        if (element.hasEndParamElement()) {
            this.composeUri(t, "CompartmentDefinitionResourceComponent", "endParam", element.getEndParamElement(), -1);
        }
    }

    protected void composeComposition(Turtle.Complex parent, String parentType, String name, Composition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Composition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Composition", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Composition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Composition", "version", element.getVersionElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Composition", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Composition", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "Composition", "category", element.getCategory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubject().size(); ++i2) {
            this.composeReference(t, "Composition", "subject", element.getSubject().get(i2), i2);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Composition", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Composition", "date", element.getDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "Composition", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeReference(t, "Composition", "author", element.getAuthor().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Composition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Composition", "title", element.getTitleElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Composition", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAttester().size(); ++i2) {
            this.composeCompositionAttesterComponent(t, "Composition", "attester", element.getAttester().get(i2), i2);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "Composition", "custodian", element.getCustodian(), -1);
        }
        for (i2 = 0; i2 < element.getRelatesTo().size(); ++i2) {
            this.composeRelatedArtifact(t, "Composition", "relatesTo", element.getRelatesTo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEvent().size(); ++i2) {
            this.composeCompositionEventComponent(t, "Composition", "event", element.getEvent().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSection().size(); ++i2) {
            this.composeCompositionSectionComponent(t, "Composition", "section", element.getSection().get(i2), i2);
        }
    }

    protected void composeCompositionAttesterComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionAttesterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "attester", name, element, index);
        if (element.hasMode()) {
            this.composeCodeableConcept(t, "CompositionAttesterComponent", "mode", element.getMode(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "CompositionAttesterComponent", "time", element.getTimeElement(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "CompositionAttesterComponent", "party", element.getParty(), -1);
        }
    }

    protected void composeCompositionEventComponent(Turtle.Complex parent, String parentType, String name, Composition.CompositionEventComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "event", name, element, index);
        for (i2 = 0; i2 < element.getCode().size(); ++i2) {
            this.composeCodeableConcept(t, "CompositionEventComponent", "code", element.getCode().get(i2), i2);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "CompositionEventComponent", "period", element.getPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getDetail().size(); ++i2) {
            this.composeReference(t, "CompositionEventComponent", "detail", element.getDetail().get(i2), i2);
        }
    }

    protected void composeCompositionSectionComponent(Turtle.Complex parent, String parentType, String name, Composition.SectionComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "section", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "SectionComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "SectionComponent", "code", element.getCode(), -1);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeReference(t, "SectionComponent", "author", element.getAuthor().get(i2), i2);
        }
        if (element.hasFocus()) {
            this.composeReference(t, "SectionComponent", "focus", element.getFocus(), -1);
        }
        if (element.hasText()) {
            this.composeNarrative(t, "SectionComponent", "text", element.getText(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "SectionComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "SectionComponent", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i2 = 0; i2 < element.getEntry().size(); ++i2) {
            this.composeReference(t, "SectionComponent", "entry", element.getEntry().get(i2), i2);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "SectionComponent", "emptyReason", element.getEmptyReason(), -1);
        }
        for (i2 = 0; i2 < element.getSection().size(); ++i2) {
            this.composeCompositionSectionComponent(t, "SectionComponent", "section", element.getSection().get(i2), i2);
        }
    }

    protected void composeConceptMap(Turtle.Complex parent, String parentType, String name, ConceptMap element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "ConceptMap", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ConceptMap", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ConceptMap", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ConceptMap", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ConceptMap", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ConceptMap", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ConceptMap", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ConceptMap", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ConceptMap", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ConceptMap", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "ConceptMap", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ConceptMap", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "ConceptMap", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "ConceptMap", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ConceptMap", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ConceptMap", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ConceptMap", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ConceptMap", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ConceptMap", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getTopic().size(); ++i2) {
            this.composeCodeableConcept(t, "ConceptMap", "topic", element.getTopic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "ConceptMap", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "ConceptMap", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "ConceptMap", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "ConceptMap", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "ConceptMap", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        if (element.hasSourceScope()) {
            this.composeType(t, "ConceptMap", "sourceScope", element.getSourceScope(), -1);
        }
        if (element.hasTargetScope()) {
            this.composeType(t, "ConceptMap", "targetScope", element.getTargetScope(), -1);
        }
        for (i2 = 0; i2 < element.getGroup().size(); ++i2) {
            this.composeConceptMapGroupComponent(t, "ConceptMap", "group", element.getGroup().get(i2), i2);
        }
    }

    protected void composeConceptMapGroupComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasSourceElement()) {
            this.composeCanonical(t, "ConceptMapGroupComponent", "source", element.getSourceElement(), -1);
        }
        if (element.hasTargetElement()) {
            this.composeCanonical(t, "ConceptMapGroupComponent", "target", element.getTargetElement(), -1);
        }
        for (int i2 = 0; i2 < element.getElement().size(); ++i2) {
            this.composeConceptMapSourceElementComponent(t, "ConceptMapGroupComponent", "element", element.getElement().get(i2), i2);
        }
        if (element.hasUnmapped()) {
            this.composeConceptMapGroupUnmappedComponent(t, "ConceptMapGroupComponent", "unmapped", element.getUnmapped(), -1);
        }
    }

    protected void composeConceptMapSourceElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.SourceElementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "element", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "SourceElementComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "SourceElementComponent", "display", element.getDisplayElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "SourceElementComponent", "valueSet", element.getValueSetElement(), -1);
        }
        if (element.hasNoMapElement()) {
            this.composeBoolean(t, "SourceElementComponent", "noMap", element.getNoMapElement(), -1);
        }
        for (int i2 = 0; i2 < element.getTarget().size(); ++i2) {
            this.composeConceptMapTargetElementComponent(t, "SourceElementComponent", "target", element.getTarget().get(i2), i2);
        }
    }

    protected void composeConceptMapTargetElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.TargetElementComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "TargetElementComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "TargetElementComponent", "display", element.getDisplayElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "TargetElementComponent", "valueSet", element.getValueSetElement(), -1);
        }
        if (element.hasRelationshipElement()) {
            this.composeEnum(t, "TargetElementComponent", "relationship", element.getRelationshipElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "TargetElementComponent", "comment", element.getCommentElement(), -1);
        }
        for (i2 = 0; i2 < element.getDependsOn().size(); ++i2) {
            this.composeConceptMapOtherElementComponent(t, "TargetElementComponent", "dependsOn", element.getDependsOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProduct().size(); ++i2) {
            this.composeConceptMapOtherElementComponent(t, "TargetElementComponent", "product", element.getProduct().get(i2), i2);
        }
    }

    protected void composeConceptMapOtherElementComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.OtherElementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dependsOn", name, element, index);
        if (element.hasPropertyElement()) {
            this.composeUri(t, "OtherElementComponent", "property", element.getPropertyElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "OtherElementComponent", "value", element.getValue(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "OtherElementComponent", "valueSet", element.getValueSetElement(), -1);
        }
    }

    protected void composeConceptMapGroupUnmappedComponent(Turtle.Complex parent, String parentType, String name, ConceptMap.ConceptMapGroupUnmappedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "unmapped", name, element, index);
        if (element.hasModeElement()) {
            this.composeEnum(t, "ConceptMapGroupUnmappedComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "ConceptMapGroupUnmappedComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeString(t, "ConceptMapGroupUnmappedComponent", "display", element.getDisplayElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "ConceptMapGroupUnmappedComponent", "valueSet", element.getValueSetElement(), -1);
        }
        if (element.hasRelationshipElement()) {
            this.composeEnum(t, "ConceptMapGroupUnmappedComponent", "relationship", element.getRelationshipElement(), -1);
        }
        if (element.hasOtherMapElement()) {
            this.composeCanonical(t, "ConceptMapGroupUnmappedComponent", "otherMap", element.getOtherMapElement(), -1);
        }
    }

    protected void composeCondition(Turtle.Complex parent, String parentType, String name, Condition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Condition", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Condition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasClinicalStatus()) {
            this.composeCodeableConcept(t, "Condition", "clinicalStatus", element.getClinicalStatus(), -1);
        }
        if (element.hasVerificationStatus()) {
            this.composeCodeableConcept(t, "Condition", "verificationStatus", element.getVerificationStatus(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "Condition", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasSeverity()) {
            this.composeCodeableConcept(t, "Condition", "severity", element.getSeverity(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Condition", "code", element.getCode(), -1);
        }
        for (i2 = 0; i2 < element.getBodySite().size(); ++i2) {
            this.composeCodeableConcept(t, "Condition", "bodySite", element.getBodySite().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Condition", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Condition", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "Condition", "onset", element.getOnset(), -1);
        }
        if (element.hasAbatement()) {
            this.composeType(t, "Condition", "abatement", element.getAbatement(), -1);
        }
        if (element.hasRecordedDateElement()) {
            this.composeDateTime(t, "Condition", "recordedDate", element.getRecordedDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getParticipant().size(); ++i2) {
            this.composeConditionParticipantComponent(t, "Condition", "participant", element.getParticipant().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getStage().size(); ++i2) {
            this.composeConditionStageComponent(t, "Condition", "stage", element.getStage().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEvidence().size(); ++i2) {
            this.composeCodeableReference(t, "Condition", "evidence", element.getEvidence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Condition", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeConditionParticipantComponent(Turtle.Complex parent, String parentType, String name, Condition.ConditionParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ConditionParticipantComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ConditionParticipantComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeConditionStageComponent(Turtle.Complex parent, String parentType, String name, Condition.ConditionStageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stage", name, element, index);
        if (element.hasSummary()) {
            this.composeCodeableConcept(t, "ConditionStageComponent", "summary", element.getSummary(), -1);
        }
        for (int i2 = 0; i2 < element.getAssessment().size(); ++i2) {
            this.composeReference(t, "ConditionStageComponent", "assessment", element.getAssessment().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ConditionStageComponent", "type", element.getType(), -1);
        }
    }

    protected void composeConditionDefinition(Turtle.Complex parent, String parentType, String name, ConditionDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "ConditionDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ConditionDefinition", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ConditionDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ConditionDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ConditionDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ConditionDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "ConditionDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ConditionDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ConditionDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ConditionDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ConditionDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "ConditionDefinition", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ConditionDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "ConditionDefinition", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "ConditionDefinition", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ConditionDefinition", "code", element.getCode(), -1);
        }
        if (element.hasSeverity()) {
            this.composeCodeableConcept(t, "ConditionDefinition", "severity", element.getSeverity(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "ConditionDefinition", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasStage()) {
            this.composeCodeableConcept(t, "ConditionDefinition", "stage", element.getStage(), -1);
        }
        if (element.hasHasSeverityElement()) {
            this.composeBoolean(t, "ConditionDefinition", "hasSeverity", element.getHasSeverityElement(), -1);
        }
        if (element.hasHasBodySiteElement()) {
            this.composeBoolean(t, "ConditionDefinition", "hasBodySite", element.getHasBodySiteElement(), -1);
        }
        if (element.hasHasStageElement()) {
            this.composeBoolean(t, "ConditionDefinition", "hasStage", element.getHasStageElement(), -1);
        }
        for (i2 = 0; i2 < element.getDefinition().size(); ++i2) {
            this.composeUri(t, "ConditionDefinition", "definition", element.getDefinition().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getObservation().size(); ++i2) {
            this.composeConditionDefinitionObservationComponent(t, "ConditionDefinition", "observation", element.getObservation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMedication().size(); ++i2) {
            this.composeConditionDefinitionMedicationComponent(t, "ConditionDefinition", "medication", element.getMedication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPrecondition().size(); ++i2) {
            this.composeConditionDefinitionPreconditionComponent(t, "ConditionDefinition", "precondition", element.getPrecondition().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTeam().size(); ++i2) {
            this.composeReference(t, "ConditionDefinition", "team", element.getTeam().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getQuestionnaire().size(); ++i2) {
            this.composeConditionDefinitionQuestionnaireComponent(t, "ConditionDefinition", "questionnaire", element.getQuestionnaire().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPlan().size(); ++i2) {
            this.composeConditionDefinitionPlanComponent(t, "ConditionDefinition", "plan", element.getPlan().get(i2), i2);
        }
    }

    protected void composeConditionDefinitionObservationComponent(Turtle.Complex parent, String parentType, String name, ConditionDefinition.ConditionDefinitionObservationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "observation", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ConditionDefinitionObservationComponent", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ConditionDefinitionObservationComponent", "code", element.getCode(), -1);
        }
    }

    protected void composeConditionDefinitionMedicationComponent(Turtle.Complex parent, String parentType, String name, ConditionDefinition.ConditionDefinitionMedicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "medication", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ConditionDefinitionMedicationComponent", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ConditionDefinitionMedicationComponent", "code", element.getCode(), -1);
        }
    }

    protected void composeConditionDefinitionPreconditionComponent(Turtle.Complex parent, String parentType, String name, ConditionDefinition.ConditionDefinitionPreconditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "precondition", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ConditionDefinitionPreconditionComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ConditionDefinitionPreconditionComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ConditionDefinitionPreconditionComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeConditionDefinitionQuestionnaireComponent(Turtle.Complex parent, String parentType, String name, ConditionDefinition.ConditionDefinitionQuestionnaireComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "questionnaire", name, element, index);
        if (element.hasPurposeElement()) {
            this.composeEnum(t, "ConditionDefinitionQuestionnaireComponent", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "ConditionDefinitionQuestionnaireComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeConditionDefinitionPlanComponent(Turtle.Complex parent, String parentType, String name, ConditionDefinition.ConditionDefinitionPlanComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "plan", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ConditionDefinitionPlanComponent", "role", element.getRole(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "ConditionDefinitionPlanComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeConsent(Turtle.Complex parent, String parentType, String name, Consent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Consent", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Consent", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Consent", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "Consent", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Consent", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "Consent", "date", element.getDateElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Consent", "period", element.getPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getGrantor().size(); ++i2) {
            this.composeReference(t, "Consent", "grantor", element.getGrantor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getGrantee().size(); ++i2) {
            this.composeReference(t, "Consent", "grantee", element.getGrantee().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getManager().size(); ++i2) {
            this.composeReference(t, "Consent", "manager", element.getManager().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getController().size(); ++i2) {
            this.composeReference(t, "Consent", "controller", element.getController().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSourceAttachment().size(); ++i2) {
            this.composeAttachment(t, "Consent", "sourceAttachment", element.getSourceAttachment().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSourceReference().size(); ++i2) {
            this.composeReference(t, "Consent", "sourceReference", element.getSourceReference().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRegulatoryBasis().size(); ++i2) {
            this.composeCodeableConcept(t, "Consent", "regulatoryBasis", element.getRegulatoryBasis().get(i2), i2);
        }
        if (element.hasPolicyBasis()) {
            this.composeConsentPolicyBasisComponent(t, "Consent", "policyBasis", element.getPolicyBasis(), -1);
        }
        for (i2 = 0; i2 < element.getPolicyText().size(); ++i2) {
            this.composeReference(t, "Consent", "policyText", element.getPolicyText().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getVerification().size(); ++i2) {
            this.composeConsentVerificationComponent(t, "Consent", "verification", element.getVerification().get(i2), i2);
        }
        if (element.hasProvision()) {
            this.composeConsentProvisionComponent(t, "Consent", "provision", element.getProvision(), -1);
        }
    }

    protected void composeConsentPolicyBasisComponent(Turtle.Complex parent, String parentType, String name, Consent.ConsentPolicyBasisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "policyBasis", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "ConsentPolicyBasisComponent", "reference", element.getReference(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUrl(t, "ConsentPolicyBasisComponent", "url", element.getUrlElement(), -1);
        }
    }

    protected void composeConsentVerificationComponent(Turtle.Complex parent, String parentType, String name, Consent.ConsentVerificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "verification", name, element, index);
        if (element.hasVerifiedElement()) {
            this.composeBoolean(t, "ConsentVerificationComponent", "verified", element.getVerifiedElement(), -1);
        }
        if (element.hasVerificationType()) {
            this.composeCodeableConcept(t, "ConsentVerificationComponent", "verificationType", element.getVerificationType(), -1);
        }
        if (element.hasVerifiedBy()) {
            this.composeReference(t, "ConsentVerificationComponent", "verifiedBy", element.getVerifiedBy(), -1);
        }
        if (element.hasVerifiedWith()) {
            this.composeReference(t, "ConsentVerificationComponent", "verifiedWith", element.getVerifiedWith(), -1);
        }
        for (int i2 = 0; i2 < element.getVerificationDate().size(); ++i2) {
            this.composeDateTime(t, "ConsentVerificationComponent", "verificationDate", element.getVerificationDate().get(i2), i2);
        }
    }

    protected void composeConsentProvisionComponent(Turtle.Complex parent, String parentType, String name, Consent.ProvisionComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "provision", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ProvisionComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ProvisionComponent", "period", element.getPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getActor().size(); ++i2) {
            this.composeConsentProvisionActorComponent(t, "ProvisionComponent", "actor", element.getActor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAction().size(); ++i2) {
            this.composeCodeableConcept(t, "ProvisionComponent", "action", element.getAction().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSecurityLabel().size(); ++i2) {
            this.composeCoding(t, "ProvisionComponent", "securityLabel", element.getSecurityLabel().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPurpose().size(); ++i2) {
            this.composeCoding(t, "ProvisionComponent", "purpose", element.getPurpose().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDocumentType().size(); ++i2) {
            this.composeCoding(t, "ProvisionComponent", "documentType", element.getDocumentType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getResourceType().size(); ++i2) {
            this.composeCoding(t, "ProvisionComponent", "resourceType", element.getResourceType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCode().size(); ++i2) {
            this.composeCodeableConcept(t, "ProvisionComponent", "code", element.getCode().get(i2), i2);
        }
        if (element.hasDataPeriod()) {
            this.composePeriod(t, "ProvisionComponent", "dataPeriod", element.getDataPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getData().size(); ++i2) {
            this.composeConsentProvisionDataComponent(t, "ProvisionComponent", "data", element.getData().get(i2), i2);
        }
        if (element.hasExpression()) {
            this.composeExpression(t, "ProvisionComponent", "expression", element.getExpression(), -1);
        }
        for (i2 = 0; i2 < element.getProvision().size(); ++i2) {
            this.composeConsentProvisionComponent(t, "ProvisionComponent", "provision", element.getProvision().get(i2), i2);
        }
    }

    protected void composeConsentProvisionActorComponent(Turtle.Complex parent, String parentType, String name, Consent.ProvisionActorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "actor", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ProvisionActorComponent", "role", element.getRole(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "ProvisionActorComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeConsentProvisionDataComponent(Turtle.Complex parent, String parentType, String name, Consent.ProvisionDataComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "data", name, element, index);
        if (element.hasMeaningElement()) {
            this.composeEnum(t, "ProvisionDataComponent", "meaning", element.getMeaningElement(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "ProvisionDataComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeContract(Turtle.Complex parent, String parentType, String name, Contract element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Contract", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Contract", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Contract", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Contract", "version", element.getVersionElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Contract", "status", element.getStatusElement(), -1);
        }
        if (element.hasLegalState()) {
            this.composeCodeableConcept(t, "Contract", "legalState", element.getLegalState(), -1);
        }
        if (element.hasInstantiatesCanonical()) {
            this.composeReference(t, "Contract", "instantiatesCanonical", element.getInstantiatesCanonical(), -1);
        }
        if (element.hasInstantiatesUriElement()) {
            this.composeUri(t, "Contract", "instantiatesUri", element.getInstantiatesUriElement(), -1);
        }
        if (element.hasContentDerivative()) {
            this.composeCodeableConcept(t, "Contract", "contentDerivative", element.getContentDerivative(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "Contract", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasApplies()) {
            this.composePeriod(t, "Contract", "applies", element.getApplies(), -1);
        }
        if (element.hasExpirationType()) {
            this.composeCodeableConcept(t, "Contract", "expirationType", element.getExpirationType(), -1);
        }
        for (i2 = 0; i2 < element.getSubject().size(); ++i2) {
            this.composeReference(t, "Contract", "subject", element.getSubject().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthority().size(); ++i2) {
            this.composeReference(t, "Contract", "authority", element.getAuthority().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDomain().size(); ++i2) {
            this.composeReference(t, "Contract", "domain", element.getDomain().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSite().size(); ++i2) {
            this.composeReference(t, "Contract", "site", element.getSite().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Contract", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Contract", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Contract", "subtitle", element.getSubtitleElement(), -1);
        }
        for (i2 = 0; i2 < element.getAlias().size(); ++i2) {
            this.composeString(t, "Contract", "alias", element.getAlias().get(i2), i2);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Contract", "author", element.getAuthor(), -1);
        }
        if (element.hasScope()) {
            this.composeCodeableConcept(t, "Contract", "scope", element.getScope(), -1);
        }
        if (element.hasTopic()) {
            this.composeType(t, "Contract", "topic", element.getTopic(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Contract", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getSubType().size(); ++i2) {
            this.composeCodeableConcept(t, "Contract", "subType", element.getSubType().get(i2), i2);
        }
        if (element.hasContentDefinition()) {
            this.composeContractContentDefinitionComponent(t, "Contract", "contentDefinition", element.getContentDefinition(), -1);
        }
        for (i2 = 0; i2 < element.getTerm().size(); ++i2) {
            this.composeContractTermComponent(t, "Contract", "term", element.getTerm().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingInfo().size(); ++i2) {
            this.composeReference(t, "Contract", "supportingInfo", element.getSupportingInfo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelevantHistory().size(); ++i2) {
            this.composeReference(t, "Contract", "relevantHistory", element.getRelevantHistory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSigner().size(); ++i2) {
            this.composeContractSignatoryComponent(t, "Contract", "signer", element.getSigner().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getFriendly().size(); ++i2) {
            this.composeContractFriendlyLanguageComponent(t, "Contract", "friendly", element.getFriendly().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getLegal().size(); ++i2) {
            this.composeContractLegalLanguageComponent(t, "Contract", "legal", element.getLegal().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRule().size(); ++i2) {
            this.composeContractComputableLanguageComponent(t, "Contract", "rule", element.getRule().get(i2), i2);
        }
        if (element.hasLegallyBinding()) {
            this.composeType(t, "Contract", "legallyBinding", element.getLegallyBinding(), -1);
        }
    }

    protected void composeContractContentDefinitionComponent(Turtle.Complex parent, String parentType, String name, Contract.ContentDefinitionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contentDefinition", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ContentDefinitionComponent", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "ContentDefinitionComponent", "subType", element.getSubType(), -1);
        }
        if (element.hasPublisher()) {
            this.composeReference(t, "ContentDefinitionComponent", "publisher", element.getPublisher(), -1);
        }
        if (element.hasPublicationDateElement()) {
            this.composeDateTime(t, "ContentDefinitionComponent", "publicationDate", element.getPublicationDateElement(), -1);
        }
        if (element.hasPublicationStatusElement()) {
            this.composeEnum(t, "ContentDefinitionComponent", "publicationStatus", element.getPublicationStatusElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ContentDefinitionComponent", "copyright", element.getCopyrightElement(), -1);
        }
    }

    protected void composeContractTermComponent(Turtle.Complex parent, String parentType, String name, Contract.TermComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "term", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "TermComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeDateTime(t, "TermComponent", "issued", element.getIssuedElement(), -1);
        }
        if (element.hasApplies()) {
            this.composePeriod(t, "TermComponent", "applies", element.getApplies(), -1);
        }
        if (element.hasTopic()) {
            this.composeType(t, "TermComponent", "topic", element.getTopic(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "TermComponent", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "TermComponent", "subType", element.getSubType(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "TermComponent", "text", element.getTextElement(), -1);
        }
        for (i2 = 0; i2 < element.getSecurityLabel().size(); ++i2) {
            this.composeContractSecurityLabelComponent(t, "TermComponent", "securityLabel", element.getSecurityLabel().get(i2), i2);
        }
        if (element.hasOffer()) {
            this.composeContractOfferComponent(t, "TermComponent", "offer", element.getOffer(), -1);
        }
        for (i2 = 0; i2 < element.getAsset().size(); ++i2) {
            this.composeContractAssetComponent(t, "TermComponent", "asset", element.getAsset().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAction().size(); ++i2) {
            this.composeContractActionComponent(t, "TermComponent", "action", element.getAction().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getGroup().size(); ++i2) {
            this.composeContractTermComponent(t, "TermComponent", "group", element.getGroup().get(i2), i2);
        }
    }

    protected void composeContractSecurityLabelComponent(Turtle.Complex parent, String parentType, String name, Contract.SecurityLabelComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "securityLabel", name, element, index);
        for (i2 = 0; i2 < element.getNumber().size(); ++i2) {
            this.composeUnsignedInt(t, "SecurityLabelComponent", "number", element.getNumber().get(i2), i2);
        }
        if (element.hasClassification()) {
            this.composeCoding(t, "SecurityLabelComponent", "classification", element.getClassification(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCoding(t, "SecurityLabelComponent", "category", element.getCategory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getControl().size(); ++i2) {
            this.composeCoding(t, "SecurityLabelComponent", "control", element.getControl().get(i2), i2);
        }
    }

    protected void composeContractOfferComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractOfferComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "offer", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ContractOfferComponent", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getParty().size(); ++i2) {
            this.composeContractPartyComponent(t, "ContractOfferComponent", "party", element.getParty().get(i2), i2);
        }
        if (element.hasTopic()) {
            this.composeReference(t, "ContractOfferComponent", "topic", element.getTopic(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ContractOfferComponent", "type", element.getType(), -1);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "ContractOfferComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getDecisionMode().size(); ++i2) {
            this.composeCodeableConcept(t, "ContractOfferComponent", "decisionMode", element.getDecisionMode().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAnswer().size(); ++i2) {
            this.composeContractAnswerComponent(t, "ContractOfferComponent", "answer", element.getAnswer().get(i2), i2);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ContractOfferComponent", "text", element.getTextElement(), -1);
        }
        for (i2 = 0; i2 < element.getLinkId().size(); ++i2) {
            this.composeString(t, "ContractOfferComponent", "linkId", element.getLinkId().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSecurityLabelNumber().size(); ++i2) {
            this.composeUnsignedInt(t, "ContractOfferComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i2), i2);
        }
    }

    protected void composeContractPartyComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractPartyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "party", name, element, index);
        for (int i2 = 0; i2 < element.getReference().size(); ++i2) {
            this.composeReference(t, "ContractPartyComponent", "reference", element.getReference().get(i2), i2);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ContractPartyComponent", "role", element.getRole(), -1);
        }
    }

    protected void composeContractAnswerComponent(Turtle.Complex parent, String parentType, String name, Contract.AnswerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "answer", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "AnswerComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeContractAssetComponent(Turtle.Complex parent, String parentType, String name, Contract.ContractAssetComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "asset", name, element, index);
        if (element.hasScope()) {
            this.composeCodeableConcept(t, "ContractAssetComponent", "scope", element.getScope(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "ContractAssetComponent", "type", element.getType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTypeReference().size(); ++i2) {
            this.composeReference(t, "ContractAssetComponent", "typeReference", element.getTypeReference().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubtype().size(); ++i2) {
            this.composeCodeableConcept(t, "ContractAssetComponent", "subtype", element.getSubtype().get(i2), i2);
        }
        if (element.hasRelationship()) {
            this.composeCoding(t, "ContractAssetComponent", "relationship", element.getRelationship(), -1);
        }
        for (i2 = 0; i2 < element.getContext().size(); ++i2) {
            this.composeContractAssetContextComponent(t, "ContractAssetComponent", "context", element.getContext().get(i2), i2);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "ContractAssetComponent", "condition", element.getConditionElement(), -1);
        }
        for (i2 = 0; i2 < element.getPeriodType().size(); ++i2) {
            this.composeCodeableConcept(t, "ContractAssetComponent", "periodType", element.getPeriodType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPeriod().size(); ++i2) {
            this.composePeriod(t, "ContractAssetComponent", "period", element.getPeriod().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getUsePeriod().size(); ++i2) {
            this.composePeriod(t, "ContractAssetComponent", "usePeriod", element.getUsePeriod().get(i2), i2);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ContractAssetComponent", "text", element.getTextElement(), -1);
        }
        for (i2 = 0; i2 < element.getLinkId().size(); ++i2) {
            this.composeString(t, "ContractAssetComponent", "linkId", element.getLinkId().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAnswer().size(); ++i2) {
            this.composeContractAnswerComponent(t, "ContractAssetComponent", "answer", element.getAnswer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSecurityLabelNumber().size(); ++i2) {
            this.composeUnsignedInt(t, "ContractAssetComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getValuedItem().size(); ++i2) {
            this.composeContractValuedItemComponent(t, "ContractAssetComponent", "valuedItem", element.getValuedItem().get(i2), i2);
        }
    }

    protected void composeContractAssetContextComponent(Turtle.Complex parent, String parentType, String name, Contract.AssetContextComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "context", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "AssetContextComponent", "reference", element.getReference(), -1);
        }
        for (int i2 = 0; i2 < element.getCode().size(); ++i2) {
            this.composeCodeableConcept(t, "AssetContextComponent", "code", element.getCode().get(i2), i2);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "AssetContextComponent", "text", element.getTextElement(), -1);
        }
    }

    protected void composeContractValuedItemComponent(Turtle.Complex parent, String parentType, String name, Contract.ValuedItemComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "valuedItem", name, element, index);
        if (element.hasEntity()) {
            this.composeType(t, "ValuedItemComponent", "entity", element.getEntity(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ValuedItemComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasEffectiveTimeElement()) {
            this.composeDateTime(t, "ValuedItemComponent", "effectiveTime", element.getEffectiveTimeElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ValuedItemComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ValuedItemComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ValuedItemComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasPointsElement()) {
            this.composeDecimal(t, "ValuedItemComponent", "points", element.getPointsElement(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ValuedItemComponent", "net", element.getNet(), -1);
        }
        if (element.hasPaymentElement()) {
            this.composeString(t, "ValuedItemComponent", "payment", element.getPaymentElement(), -1);
        }
        if (element.hasPaymentDateElement()) {
            this.composeDateTime(t, "ValuedItemComponent", "paymentDate", element.getPaymentDateElement(), -1);
        }
        if (element.hasResponsible()) {
            this.composeReference(t, "ValuedItemComponent", "responsible", element.getResponsible(), -1);
        }
        if (element.hasRecipient()) {
            this.composeReference(t, "ValuedItemComponent", "recipient", element.getRecipient(), -1);
        }
        for (i2 = 0; i2 < element.getLinkId().size(); ++i2) {
            this.composeString(t, "ValuedItemComponent", "linkId", element.getLinkId().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSecurityLabelNumber().size(); ++i2) {
            this.composeUnsignedInt(t, "ValuedItemComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i2), i2);
        }
    }

    protected void composeContractActionComponent(Turtle.Complex parent, String parentType, String name, Contract.ActionComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "action", name, element, index);
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "ActionComponent", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ActionComponent", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getSubject().size(); ++i2) {
            this.composeContractActionSubjectComponent(t, "ActionComponent", "subject", element.getSubject().get(i2), i2);
        }
        if (element.hasIntent()) {
            this.composeCodeableConcept(t, "ActionComponent", "intent", element.getIntent(), -1);
        }
        for (i2 = 0; i2 < element.getLinkId().size(); ++i2) {
            this.composeString(t, "ActionComponent", "linkId", element.getLinkId().get(i2), i2);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "ActionComponent", "status", element.getStatus(), -1);
        }
        if (element.hasContext()) {
            this.composeReference(t, "ActionComponent", "context", element.getContext(), -1);
        }
        for (i2 = 0; i2 < element.getContextLinkId().size(); ++i2) {
            this.composeString(t, "ActionComponent", "contextLinkId", element.getContextLinkId().get(i2), i2);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "ActionComponent", "occurrence", element.getOccurrence(), -1);
        }
        for (i2 = 0; i2 < element.getRequester().size(); ++i2) {
            this.composeReference(t, "ActionComponent", "requester", element.getRequester().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRequesterLinkId().size(); ++i2) {
            this.composeString(t, "ActionComponent", "requesterLinkId", element.getRequesterLinkId().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPerformerType().size(); ++i2) {
            this.composeCodeableConcept(t, "ActionComponent", "performerType", element.getPerformerType().get(i2), i2);
        }
        if (element.hasPerformerRole()) {
            this.composeCodeableConcept(t, "ActionComponent", "performerRole", element.getPerformerRole(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "ActionComponent", "performer", element.getPerformer(), -1);
        }
        for (i2 = 0; i2 < element.getPerformerLinkId().size(); ++i2) {
            this.composeString(t, "ActionComponent", "performerLinkId", element.getPerformerLinkId().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "ActionComponent", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReasonLinkId().size(); ++i2) {
            this.composeString(t, "ActionComponent", "reasonLinkId", element.getReasonLinkId().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "ActionComponent", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSecurityLabelNumber().size(); ++i2) {
            this.composeUnsignedInt(t, "ActionComponent", "securityLabelNumber", element.getSecurityLabelNumber().get(i2), i2);
        }
    }

    protected void composeContractActionSubjectComponent(Turtle.Complex parent, String parentType, String name, Contract.ActionSubjectComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subject", name, element, index);
        for (int i2 = 0; i2 < element.getReference().size(); ++i2) {
            this.composeReference(t, "ActionSubjectComponent", "reference", element.getReference().get(i2), i2);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "ActionSubjectComponent", "role", element.getRole(), -1);
        }
    }

    protected void composeContractSignatoryComponent(Turtle.Complex parent, String parentType, String name, Contract.SignatoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "signer", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "SignatoryComponent", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "SignatoryComponent", "party", element.getParty(), -1);
        }
        for (int i2 = 0; i2 < element.getSignature().size(); ++i2) {
            this.composeSignature(t, "SignatoryComponent", "signature", element.getSignature().get(i2), i2);
        }
    }

    protected void composeContractFriendlyLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.FriendlyLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "friendly", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "FriendlyLanguageComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeContractLegalLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.LegalLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "legal", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "LegalLanguageComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeContractComputableLanguageComponent(Turtle.Complex parent, String parentType, String name, Contract.ComputableLanguageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "rule", name, element, index);
        if (element.hasContent()) {
            this.composeType(t, "ComputableLanguageComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeCoverage(Turtle.Complex parent, String parentType, String name, Coverage element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Coverage", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Coverage", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Coverage", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "Coverage", "kind", element.getKindElement(), -1);
        }
        for (i2 = 0; i2 < element.getPaymentBy().size(); ++i2) {
            this.composeCoveragePaymentByComponent(t, "Coverage", "paymentBy", element.getPaymentBy().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Coverage", "type", element.getType(), -1);
        }
        if (element.hasPolicyHolder()) {
            this.composeReference(t, "Coverage", "policyHolder", element.getPolicyHolder(), -1);
        }
        if (element.hasSubscriber()) {
            this.composeReference(t, "Coverage", "subscriber", element.getSubscriber(), -1);
        }
        for (i2 = 0; i2 < element.getSubscriberId().size(); ++i2) {
            this.composeIdentifier(t, "Coverage", "subscriberId", element.getSubscriberId().get(i2), i2);
        }
        if (element.hasBeneficiary()) {
            this.composeReference(t, "Coverage", "beneficiary", element.getBeneficiary(), -1);
        }
        if (element.hasDependentElement()) {
            this.composeString(t, "Coverage", "dependent", element.getDependentElement(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "Coverage", "relationship", element.getRelationship(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Coverage", "period", element.getPeriod(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "Coverage", "insurer", element.getInsurer(), -1);
        }
        for (i2 = 0; i2 < element.getClass_().size(); ++i2) {
            this.composeCoverageClassComponent(t, "Coverage", "class", element.getClass_().get(i2), i2);
        }
        if (element.hasOrderElement()) {
            this.composePositiveInt(t, "Coverage", "order", element.getOrderElement(), -1);
        }
        if (element.hasNetworkElement()) {
            this.composeString(t, "Coverage", "network", element.getNetworkElement(), -1);
        }
        for (i2 = 0; i2 < element.getCostToBeneficiary().size(); ++i2) {
            this.composeCoverageCostToBeneficiaryComponent(t, "Coverage", "costToBeneficiary", element.getCostToBeneficiary().get(i2), i2);
        }
        if (element.hasSubrogationElement()) {
            this.composeBoolean(t, "Coverage", "subrogation", element.getSubrogationElement(), -1);
        }
        for (i2 = 0; i2 < element.getContract().size(); ++i2) {
            this.composeReference(t, "Coverage", "contract", element.getContract().get(i2), i2);
        }
        if (element.hasInsurancePlan()) {
            this.composeReference(t, "Coverage", "insurancePlan", element.getInsurancePlan(), -1);
        }
    }

    protected void composeCoveragePaymentByComponent(Turtle.Complex parent, String parentType, String name, Coverage.CoveragePaymentByComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "paymentBy", name, element, index);
        if (element.hasParty()) {
            this.composeReference(t, "CoveragePaymentByComponent", "party", element.getParty(), -1);
        }
        if (element.hasResponsibilityElement()) {
            this.composeString(t, "CoveragePaymentByComponent", "responsibility", element.getResponsibilityElement(), -1);
        }
    }

    protected void composeCoverageClassComponent(Turtle.Complex parent, String parentType, String name, Coverage.ClassComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "class", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ClassComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeIdentifier(t, "ClassComponent", "value", element.getValue(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ClassComponent", "name", element.getNameElement(), -1);
        }
    }

    protected void composeCoverageCostToBeneficiaryComponent(Turtle.Complex parent, String parentType, String name, Coverage.CostToBeneficiaryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "costToBeneficiary", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CostToBeneficiaryComponent", "type", element.getType(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "CostToBeneficiaryComponent", "category", element.getCategory(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCodeableConcept(t, "CostToBeneficiaryComponent", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "CostToBeneficiaryComponent", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCodeableConcept(t, "CostToBeneficiaryComponent", "term", element.getTerm(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "CostToBeneficiaryComponent", "value", element.getValue(), -1);
        }
        for (int i2 = 0; i2 < element.getException().size(); ++i2) {
            this.composeCoverageExemptionComponent(t, "CostToBeneficiaryComponent", "exception", element.getException().get(i2), i2);
        }
    }

    protected void composeCoverageExemptionComponent(Turtle.Complex parent, String parentType, String name, Coverage.ExemptionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "exception", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExemptionComponent", "type", element.getType(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ExemptionComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeCoverageEligibilityRequest(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CoverageEligibilityRequest", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "CoverageEligibilityRequest", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CoverageEligibilityRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "CoverageEligibilityRequest", "priority", element.getPriority(), -1);
        }
        for (i2 = 0; i2 < element.getPurpose().size(); ++i2) {
            this.composeEnum(t, "CoverageEligibilityRequest", "purpose", element.getPurpose().get(i2), i2);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "CoverageEligibilityRequest", "patient", element.getPatient(), -1);
        }
        if (element.hasServiced()) {
            this.composeType(t, "CoverageEligibilityRequest", "serviced", element.getServiced(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "CoverageEligibilityRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "CoverageEligibilityRequest", "enterer", element.getEnterer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "CoverageEligibilityRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "CoverageEligibilityRequest", "insurer", element.getInsurer(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "CoverageEligibilityRequest", "facility", element.getFacility(), -1);
        }
        for (i2 = 0; i2 < element.getSupportingInfo().size(); ++i2) {
            this.composeCoverageEligibilityRequestSupportingInformationComponent(t, "CoverageEligibilityRequest", "supportingInfo", element.getSupportingInfo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInsurance().size(); ++i2) {
            this.composeCoverageEligibilityRequestInsuranceComponent(t, "CoverageEligibilityRequest", "insurance", element.getInsurance().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getItem().size(); ++i2) {
            this.composeCoverageEligibilityRequestDetailsComponent(t, "CoverageEligibilityRequest", "item", element.getItem().get(i2), i2);
        }
    }

    protected void composeCoverageEligibilityRequestSupportingInformationComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.SupportingInformationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasInformation()) {
            this.composeReference(t, "SupportingInformationComponent", "information", element.getInformation(), -1);
        }
        if (element.hasAppliesToAllElement()) {
            this.composeBoolean(t, "SupportingInformationComponent", "appliesToAll", element.getAppliesToAllElement(), -1);
        }
    }

    protected void composeCoverageEligibilityRequestInsuranceComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
        }
        if (element.hasBusinessArrangementElement()) {
            this.composeString(t, "InsuranceComponent", "businessArrangement", element.getBusinessArrangementElement(), -1);
        }
    }

    protected void composeCoverageEligibilityRequestDetailsComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.DetailsComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        for (i2 = 0; i2 < element.getSupportingInfoSequence().size(); ++i2) {
            this.composePositiveInt(t, "DetailsComponent", "supportingInfoSequence", element.getSupportingInfoSequence().get(i2), i2);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "DetailsComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "DetailsComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "DetailsComponent", "modifier", element.getModifier().get(i2), i2);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "DetailsComponent", "provider", element.getProvider(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "DetailsComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "DetailsComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "DetailsComponent", "facility", element.getFacility(), -1);
        }
        for (i2 = 0; i2 < element.getDiagnosis().size(); ++i2) {
            this.composeCoverageEligibilityRequestDiagnosisComponent(t, "DetailsComponent", "diagnosis", element.getDiagnosis().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDetail().size(); ++i2) {
            this.composeReference(t, "DetailsComponent", "detail", element.getDetail().get(i2), i2);
        }
    }

    protected void composeCoverageEligibilityRequestDiagnosisComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityRequest.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasDiagnosis()) {
            this.composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
        }
    }

    protected void composeCoverageEligibilityResponse(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "CoverageEligibilityResponse", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "CoverageEligibilityResponse", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "CoverageEligibilityResponse", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getPurpose().size(); ++i2) {
            this.composeEnum(t, "CoverageEligibilityResponse", "purpose", element.getPurpose().get(i2), i2);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "CoverageEligibilityResponse", "patient", element.getPatient(), -1);
        }
        if (element.hasServiced()) {
            this.composeType(t, "CoverageEligibilityResponse", "serviced", element.getServiced(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "CoverageEligibilityResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasRequestor()) {
            this.composeReference(t, "CoverageEligibilityResponse", "requestor", element.getRequestor(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "CoverageEligibilityResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "CoverageEligibilityResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "CoverageEligibilityResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "CoverageEligibilityResponse", "insurer", element.getInsurer(), -1);
        }
        for (i2 = 0; i2 < element.getInsurance().size(); ++i2) {
            this.composeCoverageEligibilityResponseInsuranceComponent(t, "CoverageEligibilityResponse", "insurance", element.getInsurance().get(i2), i2);
        }
        if (element.hasPreAuthRefElement()) {
            this.composeString(t, "CoverageEligibilityResponse", "preAuthRef", element.getPreAuthRefElement(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "CoverageEligibilityResponse", "form", element.getForm(), -1);
        }
        for (i2 = 0; i2 < element.getError().size(); ++i2) {
            this.composeCoverageEligibilityResponseErrorsComponent(t, "CoverageEligibilityResponse", "error", element.getError().get(i2), i2);
        }
    }

    protected void composeCoverageEligibilityResponseInsuranceComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasCoverage()) {
            this.composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
        }
        if (element.hasInforceElement()) {
            this.composeBoolean(t, "InsuranceComponent", "inforce", element.getInforceElement(), -1);
        }
        if (element.hasBenefitPeriod()) {
            this.composePeriod(t, "InsuranceComponent", "benefitPeriod", element.getBenefitPeriod(), -1);
        }
        for (int i2 = 0; i2 < element.getItem().size(); ++i2) {
            this.composeCoverageEligibilityResponseItemsComponent(t, "InsuranceComponent", "item", element.getItem().get(i2), i2);
        }
    }

    protected void composeCoverageEligibilityResponseItemsComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.ItemsComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ItemsComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ItemsComponent", "productOrService", element.getProductOrService(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "ItemsComponent", "modifier", element.getModifier().get(i2), i2);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "ItemsComponent", "provider", element.getProvider(), -1);
        }
        if (element.hasExcludedElement()) {
            this.composeBoolean(t, "ItemsComponent", "excluded", element.getExcludedElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ItemsComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ItemsComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCodeableConcept(t, "ItemsComponent", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "ItemsComponent", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCodeableConcept(t, "ItemsComponent", "term", element.getTerm(), -1);
        }
        for (i2 = 0; i2 < element.getBenefit().size(); ++i2) {
            this.composeCoverageEligibilityResponseBenefitComponent(t, "ItemsComponent", "benefit", element.getBenefit().get(i2), i2);
        }
        if (element.hasAuthorizationRequiredElement()) {
            this.composeBoolean(t, "ItemsComponent", "authorizationRequired", element.getAuthorizationRequiredElement(), -1);
        }
        for (i2 = 0; i2 < element.getAuthorizationSupporting().size(); ++i2) {
            this.composeCodeableConcept(t, "ItemsComponent", "authorizationSupporting", element.getAuthorizationSupporting().get(i2), i2);
        }
        if (element.hasAuthorizationUrlElement()) {
            this.composeUri(t, "ItemsComponent", "authorizationUrl", element.getAuthorizationUrlElement(), -1);
        }
    }

    protected void composeCoverageEligibilityResponseBenefitComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.BenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefit", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "BenefitComponent", "type", element.getType(), -1);
        }
        if (element.hasAllowed()) {
            this.composeType(t, "BenefitComponent", "allowed", element.getAllowed(), -1);
        }
        if (element.hasUsed()) {
            this.composeType(t, "BenefitComponent", "used", element.getUsed(), -1);
        }
    }

    protected void composeCoverageEligibilityResponseErrorsComponent(Turtle.Complex parent, String parentType, String name, CoverageEligibilityResponse.ErrorsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "error", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ErrorsComponent", "code", element.getCode(), -1);
        }
    }

    protected void composeDetectedIssue(Turtle.Complex parent, String parentType, String name, DetectedIssue element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DetectedIssue", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "DetectedIssue", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DetectedIssue", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "DetectedIssue", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DetectedIssue", "code", element.getCode(), -1);
        }
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "DetectedIssue", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DetectedIssue", "subject", element.getSubject(), -1);
        }
        if (element.hasIdentified()) {
            this.composeType(t, "DetectedIssue", "identified", element.getIdentified(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "DetectedIssue", "author", element.getAuthor(), -1);
        }
        for (i2 = 0; i2 < element.getImplicated().size(); ++i2) {
            this.composeReference(t, "DetectedIssue", "implicated", element.getImplicated().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEvidence().size(); ++i2) {
            this.composeDetectedIssueEvidenceComponent(t, "DetectedIssue", "evidence", element.getEvidence().get(i2), i2);
        }
        if (element.hasDetailElement()) {
            this.composeString(t, "DetectedIssue", "detail", element.getDetailElement(), -1);
        }
        if (element.hasReferenceElement()) {
            this.composeUri(t, "DetectedIssue", "reference", element.getReferenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getMitigation().size(); ++i2) {
            this.composeDetectedIssueMitigationComponent(t, "DetectedIssue", "mitigation", element.getMitigation().get(i2), i2);
        }
    }

    protected void composeDetectedIssueEvidenceComponent(Turtle.Complex parent, String parentType, String name, DetectedIssue.DetectedIssueEvidenceComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "evidence", name, element, index);
        for (i2 = 0; i2 < element.getCode().size(); ++i2) {
            this.composeCodeableConcept(t, "DetectedIssueEvidenceComponent", "code", element.getCode().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDetail().size(); ++i2) {
            this.composeReference(t, "DetectedIssueEvidenceComponent", "detail", element.getDetail().get(i2), i2);
        }
    }

    protected void composeDetectedIssueMitigationComponent(Turtle.Complex parent, String parentType, String name, DetectedIssue.DetectedIssueMitigationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "mitigation", name, element, index);
        if (element.hasAction()) {
            this.composeCodeableConcept(t, "DetectedIssueMitigationComponent", "action", element.getAction(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "DetectedIssueMitigationComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "DetectedIssueMitigationComponent", "author", element.getAuthor(), -1);
        }
    }

    protected void composeDevice(Turtle.Complex parent, String parentType, String name, Device element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Device", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Device", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasDisplayNameElement()) {
            this.composeString(t, "Device", "displayName", element.getDisplayNameElement(), -1);
        }
        if (element.hasDefinition()) {
            this.composeCodeableReference(t, "Device", "definition", element.getDefinition(), -1);
        }
        for (i2 = 0; i2 < element.getUdiCarrier().size(); ++i2) {
            this.composeDeviceUdiCarrierComponent(t, "Device", "udiCarrier", element.getUdiCarrier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Device", "status", element.getStatusElement(), -1);
        }
        if (element.hasAvailabilityStatus()) {
            this.composeCodeableConcept(t, "Device", "availabilityStatus", element.getAvailabilityStatus(), -1);
        }
        if (element.hasBiologicalSourceEvent()) {
            this.composeIdentifier(t, "Device", "biologicalSourceEvent", element.getBiologicalSourceEvent(), -1);
        }
        if (element.hasManufacturerElement()) {
            this.composeString(t, "Device", "manufacturer", element.getManufacturerElement(), -1);
        }
        if (element.hasManufactureDateElement()) {
            this.composeDateTime(t, "Device", "manufactureDate", element.getManufactureDateElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "Device", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Device", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasSerialNumberElement()) {
            this.composeString(t, "Device", "serialNumber", element.getSerialNumberElement(), -1);
        }
        for (i2 = 0; i2 < element.getDeviceName().size(); ++i2) {
            this.composeDeviceDeviceNameComponent(t, "Device", "deviceName", element.getDeviceName().get(i2), i2);
        }
        if (element.hasModelNumberElement()) {
            this.composeString(t, "Device", "modelNumber", element.getModelNumberElement(), -1);
        }
        if (element.hasPartNumberElement()) {
            this.composeString(t, "Device", "partNumber", element.getPartNumberElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "Device", "category", element.getCategory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "Device", "type", element.getType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getVersion().size(); ++i2) {
            this.composeDeviceVersionComponent(t, "Device", "version", element.getVersion().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSpecialization().size(); ++i2) {
            this.composeDeviceSpecializationComponent(t, "Device", "specialization", element.getSpecialization().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProperty().size(); ++i2) {
            this.composeDevicePropertyComponent(t, "Device", "property", element.getProperty().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getOperation().size(); ++i2) {
            this.composeDeviceOperationComponent(t, "Device", "operation", element.getOperation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAssociation().size(); ++i2) {
            this.composeDeviceAssociationComponent(t, "Device", "association", element.getAssociation().get(i2), i2);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "Device", "owner", element.getOwner(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactPoint(t, "Device", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Device", "location", element.getLocation(), -1);
        }
        if (element.hasUrlElement()) {
            this.composeUri(t, "Device", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getEndpoint().size(); ++i2) {
            this.composeReference(t, "Device", "endpoint", element.getEndpoint().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getGateway().size(); ++i2) {
            this.composeCodeableReference(t, "Device", "gateway", element.getGateway().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Device", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSafety().size(); ++i2) {
            this.composeCodeableConcept(t, "Device", "safety", element.getSafety().get(i2), i2);
        }
        if (element.hasParent()) {
            this.composeReference(t, "Device", "parent", element.getParent(), -1);
        }
    }

    protected void composeDeviceUdiCarrierComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceUdiCarrierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "udiCarrier", name, element, index);
        if (element.hasDeviceIdentifierElement()) {
            this.composeString(t, "DeviceUdiCarrierComponent", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
        }
        if (element.hasIssuerElement()) {
            this.composeUri(t, "DeviceUdiCarrierComponent", "issuer", element.getIssuerElement(), -1);
        }
        if (element.hasJurisdictionElement()) {
            this.composeUri(t, "DeviceUdiCarrierComponent", "jurisdiction", element.getJurisdictionElement(), -1);
        }
        if (element.hasCarrierAIDCElement()) {
            this.composeBase64Binary(t, "DeviceUdiCarrierComponent", "carrierAIDC", element.getCarrierAIDCElement(), -1);
        }
        if (element.hasCarrierHRFElement()) {
            this.composeString(t, "DeviceUdiCarrierComponent", "carrierHRF", element.getCarrierHRFElement(), -1);
        }
        if (element.hasEntryTypeElement()) {
            this.composeEnum(t, "DeviceUdiCarrierComponent", "entryType", element.getEntryTypeElement(), -1);
        }
    }

    protected void composeDeviceDeviceNameComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceDeviceNameComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "deviceName", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "DeviceDeviceNameComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceDeviceNameComponent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeDeviceVersionComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceVersionComponent", "type", element.getType(), -1);
        }
        if (element.hasComponent()) {
            this.composeIdentifier(t, "DeviceVersionComponent", "component", element.getComponent(), -1);
        }
        if (element.hasInstallDateElement()) {
            this.composeDateTime(t, "DeviceVersionComponent", "installDate", element.getInstallDateElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "DeviceVersionComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeDeviceSpecializationComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceSpecializationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "specialization", name, element, index);
        if (element.hasSystemType()) {
            this.composeCodeableConcept(t, "DeviceSpecializationComponent", "systemType", element.getSystemType(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "DeviceSpecializationComponent", "version", element.getVersionElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCoding(t, "DeviceSpecializationComponent", "category", element.getCategory(), -1);
        }
    }

    protected void composeDevicePropertyComponent(Turtle.Complex parent, String parentType, String name, Device.DevicePropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DevicePropertyComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DevicePropertyComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeDeviceOperationComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceOperationComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "DeviceOperationComponent", "status", element.getStatus(), -1);
        }
        for (i2 = 0; i2 < element.getStatusReason().size(); ++i2) {
            this.composeCodeableConcept(t, "DeviceOperationComponent", "statusReason", element.getStatusReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getOperator().size(); ++i2) {
            this.composeReference(t, "DeviceOperationComponent", "operator", element.getOperator().get(i2), i2);
        }
        if (element.hasMode()) {
            this.composeCodeableConcept(t, "DeviceOperationComponent", "mode", element.getMode(), -1);
        }
        if (element.hasCycle()) {
            this.composeCount(t, "DeviceOperationComponent", "cycle", element.getCycle(), -1);
        }
        if (element.hasDuration()) {
            this.composeDuration(t, "DeviceOperationComponent", "duration", element.getDuration(), -1);
        }
    }

    protected void composeDeviceAssociationComponent(Turtle.Complex parent, String parentType, String name, Device.DeviceAssociationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "association", name, element, index);
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "DeviceAssociationComponent", "status", element.getStatus(), -1);
        }
        for (int i2 = 0; i2 < element.getStatusReason().size(); ++i2) {
            this.composeCodeableConcept(t, "DeviceAssociationComponent", "statusReason", element.getStatusReason().get(i2), i2);
        }
        if (element.hasHumanSubject()) {
            this.composeReference(t, "DeviceAssociationComponent", "humanSubject", element.getHumanSubject(), -1);
        }
        if (element.hasBodyStructure()) {
            this.composeCodeableReference(t, "DeviceAssociationComponent", "bodyStructure", element.getBodyStructure(), -1);
        }
    }

    protected void composeDeviceDefinition(Turtle.Complex parent, String parentType, String name, DeviceDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceDefinition", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "DeviceDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "DeviceDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getUdiDeviceIdentifier().size(); ++i2) {
            this.composeDeviceDefinitionUdiDeviceIdentifierComponent(t, "DeviceDefinition", "udiDeviceIdentifier", element.getUdiDeviceIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRegulatoryIdentifier().size(); ++i2) {
            this.composeDeviceDefinitionRegulatoryIdentifierComponent(t, "DeviceDefinition", "regulatoryIdentifier", element.getRegulatoryIdentifier().get(i2), i2);
        }
        if (element.hasPartNumberElement()) {
            this.composeString(t, "DeviceDefinition", "partNumber", element.getPartNumberElement(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "DeviceDefinition", "manufacturer", element.getManufacturer(), -1);
        }
        for (i2 = 0; i2 < element.getDeviceName().size(); ++i2) {
            this.composeDeviceDefinitionDeviceNameComponent(t, "DeviceDefinition", "deviceName", element.getDeviceName().get(i2), i2);
        }
        if (element.hasModelNumberElement()) {
            this.composeString(t, "DeviceDefinition", "modelNumber", element.getModelNumberElement(), -1);
        }
        for (i2 = 0; i2 < element.getClassification().size(); ++i2) {
            this.composeDeviceDefinitionClassificationComponent(t, "DeviceDefinition", "classification", element.getClassification().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSpecialization().size(); ++i2) {
            this.composeRelatedArtifact(t, "DeviceDefinition", "specialization", element.getSpecialization().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getHasPart().size(); ++i2) {
            this.composeDeviceDefinitionHasPartComponent(t, "DeviceDefinition", "hasPart", element.getHasPart().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPackaging().size(); ++i2) {
            this.composeDeviceDefinitionPackagingComponent(t, "DeviceDefinition", "packaging", element.getPackaging().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getVersion().size(); ++i2) {
            this.composeDeviceDefinitionVersionComponent(t, "DeviceDefinition", "version", element.getVersion().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSafety().size(); ++i2) {
            this.composeCodeableConcept(t, "DeviceDefinition", "safety", element.getSafety().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getShelfLifeStorage().size(); ++i2) {
            this.composeProductShelfLife(t, "DeviceDefinition", "shelfLifeStorage", element.getShelfLifeStorage().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getLanguageCode().size(); ++i2) {
            this.composeCodeableConcept(t, "DeviceDefinition", "languageCode", element.getLanguageCode().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProperty().size(); ++i2) {
            this.composeDeviceDefinitionPropertyComponent(t, "DeviceDefinition", "property", element.getProperty().get(i2), i2);
        }
        if (element.hasOwner()) {
            this.composeReference(t, "DeviceDefinition", "owner", element.getOwner(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactPoint(t, "DeviceDefinition", "contact", element.getContact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getLink().size(); ++i2) {
            this.composeDeviceDefinitionLinkComponent(t, "DeviceDefinition", "link", element.getLink().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "DeviceDefinition", "note", element.getNote().get(i2), i2);
        }
        if (element.hasParentDevice()) {
            this.composeReference(t, "DeviceDefinition", "parentDevice", element.getParentDevice(), -1);
        }
        for (i2 = 0; i2 < element.getMaterial().size(); ++i2) {
            this.composeDeviceDefinitionMaterialComponent(t, "DeviceDefinition", "material", element.getMaterial().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProductionIdentifierInUDI().size(); ++i2) {
            this.composeEnum(t, "DeviceDefinition", "productionIdentifierInUDI", element.getProductionIdentifierInUDI().get(i2), i2);
        }
        if (element.hasGuideline()) {
            this.composeDeviceDefinitionGuidelineComponent(t, "DeviceDefinition", "guideline", element.getGuideline(), -1);
        }
        if (element.hasCorrectiveAction()) {
            this.composeDeviceDefinitionCorrectiveActionComponent(t, "DeviceDefinition", "correctiveAction", element.getCorrectiveAction(), -1);
        }
        for (i2 = 0; i2 < element.getChargeItem().size(); ++i2) {
            this.composeDeviceDefinitionChargeItemComponent(t, "DeviceDefinition", "chargeItem", element.getChargeItem().get(i2), i2);
        }
    }

    protected void composeDeviceDefinitionUdiDeviceIdentifierComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "udiDeviceIdentifier", name, element, index);
        if (element.hasDeviceIdentifierElement()) {
            this.composeString(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
        }
        if (element.hasIssuerElement()) {
            this.composeUri(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "issuer", element.getIssuerElement(), -1);
        }
        if (element.hasJurisdictionElement()) {
            this.composeUri(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "jurisdiction", element.getJurisdictionElement(), -1);
        }
        for (int i2 = 0; i2 < element.getMarketDistribution().size(); ++i2) {
            this.composeDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponent(t, "DeviceDefinitionUdiDeviceIdentifierComponent", "marketDistribution", element.getMarketDistribution().get(i2), i2);
        }
    }

    protected void composeDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "marketDistribution", name, element, index);
        if (element.hasMarketPeriod()) {
            this.composePeriod(t, "UdiDeviceIdentifierMarketDistributionComponent", "marketPeriod", element.getMarketPeriod(), -1);
        }
        if (element.hasSubJurisdictionElement()) {
            this.composeUri(t, "UdiDeviceIdentifierMarketDistributionComponent", "subJurisdiction", element.getSubJurisdictionElement(), -1);
        }
    }

    protected void composeDeviceDefinitionRegulatoryIdentifierComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "regulatoryIdentifier", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceDefinitionRegulatoryIdentifierComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasDeviceIdentifierElement()) {
            this.composeString(t, "DeviceDefinitionRegulatoryIdentifierComponent", "deviceIdentifier", element.getDeviceIdentifierElement(), -1);
        }
        if (element.hasIssuerElement()) {
            this.composeUri(t, "DeviceDefinitionRegulatoryIdentifierComponent", "issuer", element.getIssuerElement(), -1);
        }
        if (element.hasJurisdictionElement()) {
            this.composeUri(t, "DeviceDefinitionRegulatoryIdentifierComponent", "jurisdiction", element.getJurisdictionElement(), -1);
        }
    }

    protected void composeDeviceDefinitionDeviceNameComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionDeviceNameComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "deviceName", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "DeviceDefinitionDeviceNameComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceDefinitionDeviceNameComponent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composeDeviceDefinitionClassificationComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionClassificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "classification", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDefinitionClassificationComponent", "type", element.getType(), -1);
        }
        for (int i2 = 0; i2 < element.getJustification().size(); ++i2) {
            this.composeRelatedArtifact(t, "DeviceDefinitionClassificationComponent", "justification", element.getJustification().get(i2), i2);
        }
    }

    protected void composeDeviceDefinitionHasPartComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionHasPartComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "hasPart", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "DeviceDefinitionHasPartComponent", "reference", element.getReference(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "DeviceDefinitionHasPartComponent", "count", element.getCountElement(), -1);
        }
    }

    protected void composeDeviceDefinitionPackagingComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionPackagingComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "packaging", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DeviceDefinitionPackagingComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDefinitionPackagingComponent", "type", element.getType(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "DeviceDefinitionPackagingComponent", "count", element.getCountElement(), -1);
        }
        for (i2 = 0; i2 < element.getDistributor().size(); ++i2) {
            this.composeDeviceDefinitionPackagingDistributorComponent(t, "DeviceDefinitionPackagingComponent", "distributor", element.getDistributor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getUdiDeviceIdentifier().size(); ++i2) {
            this.composeDeviceDefinitionUdiDeviceIdentifierComponent(t, "DeviceDefinitionPackagingComponent", "udiDeviceIdentifier", element.getUdiDeviceIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPackaging().size(); ++i2) {
            this.composeDeviceDefinitionPackagingComponent(t, "DeviceDefinitionPackagingComponent", "packaging", element.getPackaging().get(i2), i2);
        }
    }

    protected void composeDeviceDefinitionPackagingDistributorComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.PackagingDistributorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "distributor", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "PackagingDistributorComponent", "name", element.getNameElement(), -1);
        }
        for (int i2 = 0; i2 < element.getOrganizationReference().size(); ++i2) {
            this.composeReference(t, "PackagingDistributorComponent", "organizationReference", element.getOrganizationReference().get(i2), i2);
        }
    }

    protected void composeDeviceDefinitionVersionComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDefinitionVersionComponent", "type", element.getType(), -1);
        }
        if (element.hasComponent()) {
            this.composeIdentifier(t, "DeviceDefinitionVersionComponent", "component", element.getComponent(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "DeviceDefinitionVersionComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeDeviceDefinitionPropertyComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDefinitionPropertyComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DeviceDefinitionPropertyComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeDeviceDefinitionLinkComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasRelation()) {
            this.composeCoding(t, "DeviceDefinitionLinkComponent", "relation", element.getRelation(), -1);
        }
        if (element.hasRelatedDevice()) {
            this.composeCodeableReference(t, "DeviceDefinitionLinkComponent", "relatedDevice", element.getRelatedDevice(), -1);
        }
    }

    protected void composeDeviceDefinitionMaterialComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionMaterialComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "material", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableConcept(t, "DeviceDefinitionMaterialComponent", "substance", element.getSubstance(), -1);
        }
        if (element.hasAlternateElement()) {
            this.composeBoolean(t, "DeviceDefinitionMaterialComponent", "alternate", element.getAlternateElement(), -1);
        }
        if (element.hasAllergenicIndicatorElement()) {
            this.composeBoolean(t, "DeviceDefinitionMaterialComponent", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
        }
    }

    protected void composeDeviceDefinitionGuidelineComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionGuidelineComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "guideline", name, element, index);
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "DeviceDefinitionGuidelineComponent", "useContext", element.getUseContext().get(i2), i2);
        }
        if (element.hasUsageInstructionElement()) {
            this.composeMarkdown(t, "DeviceDefinitionGuidelineComponent", "usageInstruction", element.getUsageInstructionElement(), -1);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "DeviceDefinitionGuidelineComponent", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIndication().size(); ++i2) {
            this.composeCodeableReference(t, "DeviceDefinitionGuidelineComponent", "indication", element.getIndication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContraindication().size(); ++i2) {
            this.composeCodeableReference(t, "DeviceDefinitionGuidelineComponent", "contraindication", element.getContraindication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getWarning().size(); ++i2) {
            this.composeCodeableReference(t, "DeviceDefinitionGuidelineComponent", "warning", element.getWarning().get(i2), i2);
        }
        if (element.hasIntendedUseElement()) {
            this.composeString(t, "DeviceDefinitionGuidelineComponent", "intendedUse", element.getIntendedUseElement(), -1);
        }
    }

    protected void composeDeviceDefinitionCorrectiveActionComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionCorrectiveActionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "correctiveAction", name, element, index);
        if (element.hasRecallElement()) {
            this.composeBoolean(t, "DeviceDefinitionCorrectiveActionComponent", "recall", element.getRecallElement(), -1);
        }
        if (element.hasScopeElement()) {
            this.composeEnum(t, "DeviceDefinitionCorrectiveActionComponent", "scope", element.getScopeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "DeviceDefinitionCorrectiveActionComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeDeviceDefinitionChargeItemComponent(Turtle.Complex parent, String parentType, String name, DeviceDefinition.DeviceDefinitionChargeItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "chargeItem", name, element, index);
        if (element.hasChargeItemCode()) {
            this.composeCodeableReference(t, "DeviceDefinitionChargeItemComponent", "chargeItemCode", element.getChargeItemCode(), -1);
        }
        if (element.hasCount()) {
            this.composeQuantity(t, "DeviceDefinitionChargeItemComponent", "count", element.getCount(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "DeviceDefinitionChargeItemComponent", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (int i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "DeviceDefinitionChargeItemComponent", "useContext", element.getUseContext().get(i2), i2);
        }
    }

    protected void composeDeviceDispense(Turtle.Complex parent, String parentType, String name, DeviceDispense element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceDispense", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "DeviceDispense", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "DeviceDispense", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPartOf().size(); ++i2) {
            this.composeReference(t, "DeviceDispense", "partOf", element.getPartOf().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DeviceDispense", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableReference(t, "DeviceDispense", "statusReason", element.getStatusReason(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "DeviceDispense", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasDevice()) {
            this.composeCodeableReference(t, "DeviceDispense", "device", element.getDevice(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DeviceDispense", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "DeviceDispense", "encounter", element.getEncounter(), -1);
        }
        for (i2 = 0; i2 < element.getSupportingInformation().size(); ++i2) {
            this.composeReference(t, "DeviceDispense", "supportingInformation", element.getSupportingInformation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeDeviceDispensePerformerComponent(t, "DeviceDispense", "performer", element.getPerformer().get(i2), i2);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "DeviceDispense", "location", element.getLocation(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceDispense", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "DeviceDispense", "quantity", element.getQuantity(), -1);
        }
        if (element.hasPreparedDateElement()) {
            this.composeDateTime(t, "DeviceDispense", "preparedDate", element.getPreparedDateElement(), -1);
        }
        if (element.hasWhenHandedOverElement()) {
            this.composeDateTime(t, "DeviceDispense", "whenHandedOver", element.getWhenHandedOverElement(), -1);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "DeviceDispense", "destination", element.getDestination(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "DeviceDispense", "note", element.getNote().get(i2), i2);
        }
        if (element.hasUsageInstructionElement()) {
            this.composeString(t, "DeviceDispense", "usageInstruction", element.getUsageInstructionElement(), -1);
        }
        for (i2 = 0; i2 < element.getEventHistory().size(); ++i2) {
            this.composeReference(t, "DeviceDispense", "eventHistory", element.getEventHistory().get(i2), i2);
        }
    }

    protected void composeDeviceDispensePerformerComponent(Turtle.Complex parent, String parentType, String name, DeviceDispense.DeviceDispensePerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "DeviceDispensePerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "DeviceDispensePerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeDeviceMetric(Turtle.Complex parent, String parentType, String name, DeviceMetric element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceMetric", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "DeviceMetric", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DeviceMetric", "type", element.getType(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "DeviceMetric", "unit", element.getUnit(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "DeviceMetric", "source", element.getSource(), -1);
        }
        if (element.hasParent()) {
            this.composeReference(t, "DeviceMetric", "parent", element.getParent(), -1);
        }
        if (element.hasOperationalStatusElement()) {
            this.composeEnum(t, "DeviceMetric", "operationalStatus", element.getOperationalStatusElement(), -1);
        }
        if (element.hasColorElement()) {
            this.composeEnum(t, "DeviceMetric", "color", element.getColorElement(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "DeviceMetric", "category", element.getCategoryElement(), -1);
        }
        if (element.hasMeasurementPeriod()) {
            this.composeTiming(t, "DeviceMetric", "measurementPeriod", element.getMeasurementPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getCalibration().size(); ++i2) {
            this.composeDeviceMetricCalibrationComponent(t, "DeviceMetric", "calibration", element.getCalibration().get(i2), i2);
        }
    }

    protected void composeDeviceMetricCalibrationComponent(Turtle.Complex parent, String parentType, String name, DeviceMetric.DeviceMetricCalibrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "calibration", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "DeviceMetricCalibrationComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasStateElement()) {
            this.composeEnum(t, "DeviceMetricCalibrationComponent", "state", element.getStateElement(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeInstant(t, "DeviceMetricCalibrationComponent", "time", element.getTimeElement(), -1);
        }
    }

    protected void composeDeviceRequest(Turtle.Complex parent, String parentType, String name, DeviceRequest element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceRequest", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "DeviceRequest", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesCanonical().size(); ++i2) {
            this.composeCanonical(t, "DeviceRequest", "instantiatesCanonical", element.getInstantiatesCanonical().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesUri().size(); ++i2) {
            this.composeUri(t, "DeviceRequest", "instantiatesUri", element.getInstantiatesUri().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "DeviceRequest", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReplaces().size(); ++i2) {
            this.composeReference(t, "DeviceRequest", "replaces", element.getReplaces().get(i2), i2);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "DeviceRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DeviceRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "DeviceRequest", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "DeviceRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "DeviceRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableReference(t, "DeviceRequest", "code", element.getCode(), -1);
        }
        if (element.hasQuantityElement()) {
            this.composeInteger(t, "DeviceRequest", "quantity", element.getQuantityElement(), -1);
        }
        for (i2 = 0; i2 < element.getParameter().size(); ++i2) {
            this.composeDeviceRequestParameterComponent(t, "DeviceRequest", "parameter", element.getParameter().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DeviceRequest", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "DeviceRequest", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "DeviceRequest", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "DeviceRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "DeviceRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "DeviceRequest", "performerType", element.getPerformerType(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "DeviceRequest", "performer", element.getPerformer(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "DeviceRequest", "reason", element.getReason().get(i2), i2);
        }
        if (element.hasAsNeededElement()) {
            this.composeBoolean(t, "DeviceRequest", "asNeeded", element.getAsNeededElement(), -1);
        }
        if (element.hasAsNeededFor()) {
            this.composeCodeableConcept(t, "DeviceRequest", "asNeededFor", element.getAsNeededFor(), -1);
        }
        for (i2 = 0; i2 < element.getInsurance().size(); ++i2) {
            this.composeReference(t, "DeviceRequest", "insurance", element.getInsurance().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingInfo().size(); ++i2) {
            this.composeReference(t, "DeviceRequest", "supportingInfo", element.getSupportingInfo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "DeviceRequest", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelevantHistory().size(); ++i2) {
            this.composeReference(t, "DeviceRequest", "relevantHistory", element.getRelevantHistory().get(i2), i2);
        }
    }

    protected void composeDeviceRequestParameterComponent(Turtle.Complex parent, String parentType, String name, DeviceRequest.DeviceRequestParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DeviceRequestParameterComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "DeviceRequestParameterComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeDeviceUsage(Turtle.Complex parent, String parentType, String name, DeviceUsage element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DeviceUsage", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "DeviceUsage", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "DeviceUsage", "basedOn", element.getBasedOn().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DeviceUsage", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "DeviceUsage", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "DeviceUsage", "patient", element.getPatient(), -1);
        }
        for (i2 = 0; i2 < element.getDerivedFrom().size(); ++i2) {
            this.composeReference(t, "DeviceUsage", "derivedFrom", element.getDerivedFrom().get(i2), i2);
        }
        if (element.hasContext()) {
            this.composeReference(t, "DeviceUsage", "context", element.getContext(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "DeviceUsage", "timing", element.getTiming(), -1);
        }
        if (element.hasDateAssertedElement()) {
            this.composeDateTime(t, "DeviceUsage", "dateAsserted", element.getDateAssertedElement(), -1);
        }
        if (element.hasUsageStatus()) {
            this.composeCodeableConcept(t, "DeviceUsage", "usageStatus", element.getUsageStatus(), -1);
        }
        for (i2 = 0; i2 < element.getUsageReason().size(); ++i2) {
            this.composeCodeableConcept(t, "DeviceUsage", "usageReason", element.getUsageReason().get(i2), i2);
        }
        if (element.hasAdherence()) {
            this.composeDeviceUsageAdherenceComponent(t, "DeviceUsage", "adherence", element.getAdherence(), -1);
        }
        if (element.hasInformationSource()) {
            this.composeReference(t, "DeviceUsage", "informationSource", element.getInformationSource(), -1);
        }
        if (element.hasDevice()) {
            this.composeCodeableReference(t, "DeviceUsage", "device", element.getDevice(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "DeviceUsage", "reason", element.getReason().get(i2), i2);
        }
        if (element.hasBodySite()) {
            this.composeCodeableReference(t, "DeviceUsage", "bodySite", element.getBodySite(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "DeviceUsage", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeDeviceUsageAdherenceComponent(Turtle.Complex parent, String parentType, String name, DeviceUsage.DeviceUsageAdherenceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adherence", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DeviceUsageAdherenceComponent", "code", element.getCode(), -1);
        }
        for (int i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableConcept(t, "DeviceUsageAdherenceComponent", "reason", element.getReason().get(i2), i2);
        }
    }

    protected void composeDiagnosticReport(Turtle.Complex parent, String parentType, String name, DiagnosticReport element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DiagnosticReport", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "DiagnosticReport", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "DiagnosticReport", "basedOn", element.getBasedOn().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DiagnosticReport", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "DiagnosticReport", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DiagnosticReport", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DiagnosticReport", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "DiagnosticReport", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "DiagnosticReport", "effective", element.getEffective(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "DiagnosticReport", "issued", element.getIssuedElement(), -1);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeReference(t, "DiagnosticReport", "performer", element.getPerformer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getResultsInterpreter().size(); ++i2) {
            this.composeReference(t, "DiagnosticReport", "resultsInterpreter", element.getResultsInterpreter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSpecimen().size(); ++i2) {
            this.composeReference(t, "DiagnosticReport", "specimen", element.getSpecimen().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getResult().size(); ++i2) {
            this.composeReference(t, "DiagnosticReport", "result", element.getResult().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "DiagnosticReport", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getStudy().size(); ++i2) {
            this.composeReference(t, "DiagnosticReport", "study", element.getStudy().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingInfo().size(); ++i2) {
            this.composeDiagnosticReportSupportingInfoComponent(t, "DiagnosticReport", "supportingInfo", element.getSupportingInfo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMedia().size(); ++i2) {
            this.composeDiagnosticReportMediaComponent(t, "DiagnosticReport", "media", element.getMedia().get(i2), i2);
        }
        if (element.hasComposition()) {
            this.composeReference(t, "DiagnosticReport", "composition", element.getComposition(), -1);
        }
        if (element.hasConclusionElement()) {
            this.composeString(t, "DiagnosticReport", "conclusion", element.getConclusionElement(), -1);
        }
        for (i2 = 0; i2 < element.getConclusionCode().size(); ++i2) {
            this.composeCodeableConcept(t, "DiagnosticReport", "conclusionCode", element.getConclusionCode().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPresentedForm().size(); ++i2) {
            this.composeAttachment(t, "DiagnosticReport", "presentedForm", element.getPresentedForm().get(i2), i2);
        }
    }

    protected void composeDiagnosticReportSupportingInfoComponent(Turtle.Complex parent, String parentType, String name, DiagnosticReport.DiagnosticReportSupportingInfoComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DiagnosticReportSupportingInfoComponent", "type", element.getType(), -1);
        }
        if (element.hasReference()) {
            this.composeReference(t, "DiagnosticReportSupportingInfoComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeDiagnosticReportMediaComponent(Turtle.Complex parent, String parentType, String name, DiagnosticReport.DiagnosticReportMediaComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "media", name, element, index);
        if (element.hasCommentElement()) {
            this.composeString(t, "DiagnosticReportMediaComponent", "comment", element.getCommentElement(), -1);
        }
        if (element.hasLink()) {
            this.composeReference(t, "DiagnosticReportMediaComponent", "link", element.getLink(), -1);
        }
    }

    protected void composeDocumentManifest(Turtle.Complex parent, String parentType, String name, DocumentManifest element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DocumentManifest", name, element, index);
        if (element.hasMasterIdentifier()) {
            this.composeIdentifier(t, "DocumentManifest", "masterIdentifier", element.getMasterIdentifier(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "DocumentManifest", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DocumentManifest", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentManifest", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DocumentManifest", "subject", element.getSubject(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "DocumentManifest", "created", element.getCreatedElement(), -1);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeReference(t, "DocumentManifest", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRecipient().size(); ++i2) {
            this.composeReference(t, "DocumentManifest", "recipient", element.getRecipient().get(i2), i2);
        }
        if (element.hasSourceElement()) {
            this.composeUri(t, "DocumentManifest", "source", element.getSourceElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "DocumentManifest", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getContent().size(); ++i2) {
            this.composeReference(t, "DocumentManifest", "content", element.getContent().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelated().size(); ++i2) {
            this.composeDocumentManifestRelatedComponent(t, "DocumentManifest", "related", element.getRelated().get(i2), i2);
        }
    }

    protected void composeDocumentManifestRelatedComponent(Turtle.Complex parent, String parentType, String name, DocumentManifest.DocumentManifestRelatedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "DocumentManifestRelatedComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasRef()) {
            this.composeReference(t, "DocumentManifestRelatedComponent", "ref", element.getRef(), -1);
        }
    }

    protected void composeDocumentReference(Turtle.Complex parent, String parentType, String name, DocumentReference element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "DocumentReference", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "DocumentReference", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "DocumentReference", "basedOn", element.getBasedOn().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "DocumentReference", "status", element.getStatusElement(), -1);
        }
        if (element.hasDocStatusElement()) {
            this.composeEnum(t, "DocumentReference", "docStatus", element.getDocStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "DocumentReference", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "DocumentReference", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "DocumentReference", "subject", element.getSubject(), -1);
        }
        for (i2 = 0; i2 < element.getContext().size(); ++i2) {
            this.composeReference(t, "DocumentReference", "context", element.getContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEvent().size(); ++i2) {
            this.composeCodeableReference(t, "DocumentReference", "event", element.getEvent().get(i2), i2);
        }
        if (element.hasFacilityType()) {
            this.composeCodeableConcept(t, "DocumentReference", "facilityType", element.getFacilityType(), -1);
        }
        if (element.hasPracticeSetting()) {
            this.composeCodeableConcept(t, "DocumentReference", "practiceSetting", element.getPracticeSetting(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "DocumentReference", "period", element.getPeriod(), -1);
        }
        if (element.hasDateElement()) {
            this.composeInstant(t, "DocumentReference", "date", element.getDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeReference(t, "DocumentReference", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAttester().size(); ++i2) {
            this.composeDocumentReferenceAttesterComponent(t, "DocumentReference", "attester", element.getAttester().get(i2), i2);
        }
        if (element.hasCustodian()) {
            this.composeReference(t, "DocumentReference", "custodian", element.getCustodian(), -1);
        }
        for (i2 = 0; i2 < element.getRelatesTo().size(); ++i2) {
            this.composeDocumentReferenceRelatesToComponent(t, "DocumentReference", "relatesTo", element.getRelatesTo().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "DocumentReference", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getSecurityLabel().size(); ++i2) {
            this.composeCodeableConcept(t, "DocumentReference", "securityLabel", element.getSecurityLabel().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContent().size(); ++i2) {
            this.composeDocumentReferenceContentComponent(t, "DocumentReference", "content", element.getContent().get(i2), i2);
        }
    }

    protected void composeDocumentReferenceAttesterComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceAttesterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "attester", name, element, index);
        if (element.hasMode()) {
            this.composeCodeableConcept(t, "DocumentReferenceAttesterComponent", "mode", element.getMode(), -1);
        }
        if (element.hasTimeElement()) {
            this.composeDateTime(t, "DocumentReferenceAttesterComponent", "time", element.getTimeElement(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "DocumentReferenceAttesterComponent", "party", element.getParty(), -1);
        }
    }

    protected void composeDocumentReferenceRelatesToComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "DocumentReferenceRelatesToComponent", "code", element.getCode(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "DocumentReferenceRelatesToComponent", "target", element.getTarget(), -1);
        }
    }

    protected void composeDocumentReferenceContentComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "content", name, element, index);
        if (element.hasAttachment()) {
            this.composeAttachment(t, "DocumentReferenceContentComponent", "attachment", element.getAttachment(), -1);
        }
        for (int i2 = 0; i2 < element.getProfile().size(); ++i2) {
            this.composeDocumentReferenceContentProfileComponent(t, "DocumentReferenceContentComponent", "profile", element.getProfile().get(i2), i2);
        }
    }

    protected void composeDocumentReferenceContentProfileComponent(Turtle.Complex parent, String parentType, String name, DocumentReference.DocumentReferenceContentProfileComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "profile", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "DocumentReferenceContentProfileComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeEncounter(Turtle.Complex parent, String parentType, String name, Encounter element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Encounter", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Encounter", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Encounter", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getStatusHistory().size(); ++i2) {
            this.composeEncounterStatusHistoryComponent(t, "Encounter", "statusHistory", element.getStatusHistory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getClass_().size(); ++i2) {
            this.composeCodeableConcept(t, "Encounter", "class", element.getClass_().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getClassHistory().size(); ++i2) {
            this.composeEncounterClassHistoryComponent(t, "Encounter", "classHistory", element.getClassHistory().get(i2), i2);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Encounter", "priority", element.getPriority(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "Encounter", "type", element.getType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getServiceType().size(); ++i2) {
            this.composeCodeableReference(t, "Encounter", "serviceType", element.getServiceType().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Encounter", "subject", element.getSubject(), -1);
        }
        if (element.hasSubjectStatus()) {
            this.composeCodeableConcept(t, "Encounter", "subjectStatus", element.getSubjectStatus(), -1);
        }
        for (i2 = 0; i2 < element.getEpisodeOfCare().size(); ++i2) {
            this.composeReference(t, "Encounter", "episodeOfCare", element.getEpisodeOfCare().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "Encounter", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCareTeam().size(); ++i2) {
            this.composeReference(t, "Encounter", "careTeam", element.getCareTeam().get(i2), i2);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Encounter", "partOf", element.getPartOf(), -1);
        }
        if (element.hasServiceProvider()) {
            this.composeReference(t, "Encounter", "serviceProvider", element.getServiceProvider(), -1);
        }
        for (i2 = 0; i2 < element.getParticipant().size(); ++i2) {
            this.composeEncounterParticipantComponent(t, "Encounter", "participant", element.getParticipant().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAppointment().size(); ++i2) {
            this.composeReference(t, "Encounter", "appointment", element.getAppointment().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getVirtualService().size(); ++i2) {
            this.composeVirtualServiceDetail(t, "Encounter", "virtualService", element.getVirtualService().get(i2), i2);
        }
        if (element.hasActualPeriod()) {
            this.composePeriod(t, "Encounter", "actualPeriod", element.getActualPeriod(), -1);
        }
        if (element.hasPlannedStartDateElement()) {
            this.composeDateTime(t, "Encounter", "plannedStartDate", element.getPlannedStartDateElement(), -1);
        }
        if (element.hasPlannedEndDateElement()) {
            this.composeDateTime(t, "Encounter", "plannedEndDate", element.getPlannedEndDateElement(), -1);
        }
        if (element.hasLength()) {
            this.composeDuration(t, "Encounter", "length", element.getLength(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "Encounter", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDiagnosis().size(); ++i2) {
            this.composeEncounterDiagnosisComponent(t, "Encounter", "diagnosis", element.getDiagnosis().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAccount().size(); ++i2) {
            this.composeReference(t, "Encounter", "account", element.getAccount().get(i2), i2);
        }
        if (element.hasAdmission()) {
            this.composeEncounterAdmissionComponent(t, "Encounter", "admission", element.getAdmission(), -1);
        }
        for (i2 = 0; i2 < element.getLocation().size(); ++i2) {
            this.composeEncounterLocationComponent(t, "Encounter", "location", element.getLocation().get(i2), i2);
        }
    }

    protected void composeEncounterStatusHistoryComponent(Turtle.Complex parent, String parentType, String name, Encounter.StatusHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusHistory", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "StatusHistoryComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "StatusHistoryComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEncounterClassHistoryComponent(Turtle.Complex parent, String parentType, String name, Encounter.ClassHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "classHistory", name, element, index);
        if (element.hasClass_()) {
            this.composeCoding(t, "ClassHistoryComponent", "class", element.getClass_(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ClassHistoryComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEncounterParticipantComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        for (int i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "EncounterParticipantComponent", "type", element.getType().get(i2), i2);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EncounterParticipantComponent", "period", element.getPeriod(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "EncounterParticipantComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeEncounterDiagnosisComponent(Turtle.Complex parent, String parentType, String name, Encounter.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasCondition()) {
            this.composeReference(t, "DiagnosisComponent", "condition", element.getCondition(), -1);
        }
        if (element.hasUse()) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "use", element.getUse(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "DiagnosisComponent", "rank", element.getRankElement(), -1);
        }
    }

    protected void composeEncounterAdmissionComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterAdmissionComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "admission", name, element, index);
        if (element.hasPreAdmissionIdentifier()) {
            this.composeIdentifier(t, "EncounterAdmissionComponent", "preAdmissionIdentifier", element.getPreAdmissionIdentifier(), -1);
        }
        if (element.hasOrigin()) {
            this.composeReference(t, "EncounterAdmissionComponent", "origin", element.getOrigin(), -1);
        }
        if (element.hasAdmitSource()) {
            this.composeCodeableConcept(t, "EncounterAdmissionComponent", "admitSource", element.getAdmitSource(), -1);
        }
        if (element.hasReAdmission()) {
            this.composeCodeableConcept(t, "EncounterAdmissionComponent", "reAdmission", element.getReAdmission(), -1);
        }
        for (i2 = 0; i2 < element.getDietPreference().size(); ++i2) {
            this.composeCodeableConcept(t, "EncounterAdmissionComponent", "dietPreference", element.getDietPreference().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSpecialCourtesy().size(); ++i2) {
            this.composeCodeableConcept(t, "EncounterAdmissionComponent", "specialCourtesy", element.getSpecialCourtesy().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSpecialArrangement().size(); ++i2) {
            this.composeCodeableConcept(t, "EncounterAdmissionComponent", "specialArrangement", element.getSpecialArrangement().get(i2), i2);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "EncounterAdmissionComponent", "destination", element.getDestination(), -1);
        }
        if (element.hasDischargeDisposition()) {
            this.composeCodeableConcept(t, "EncounterAdmissionComponent", "dischargeDisposition", element.getDischargeDisposition(), -1);
        }
    }

    protected void composeEncounterLocationComponent(Turtle.Complex parent, String parentType, String name, Encounter.EncounterLocationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "location", name, element, index);
        if (element.hasLocation()) {
            this.composeReference(t, "EncounterLocationComponent", "location", element.getLocation(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EncounterLocationComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "EncounterLocationComponent", "form", element.getForm(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EncounterLocationComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEndpoint(Turtle.Complex parent, String parentType, String name, Endpoint element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Endpoint", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Endpoint", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Endpoint", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getConnectionType().size(); ++i2) {
            this.composeCodeableConcept(t, "Endpoint", "connectionType", element.getConnectionType().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Endpoint", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Endpoint", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getEnvironmentType().size(); ++i2) {
            this.composeCodeableConcept(t, "Endpoint", "environmentType", element.getEnvironmentType().get(i2), i2);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Endpoint", "managingOrganization", element.getManagingOrganization(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactPoint(t, "Endpoint", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Endpoint", "period", element.getPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getPayloadType().size(); ++i2) {
            this.composeCodeableConcept(t, "Endpoint", "payloadType", element.getPayloadType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPayloadMimeType().size(); ++i2) {
            this.composeCode(t, "Endpoint", "payloadMimeType", element.getPayloadMimeType().get(i2), i2);
        }
        if (element.hasAddressElement()) {
            this.composeUrl(t, "Endpoint", "address", element.getAddressElement(), -1);
        }
        for (i2 = 0; i2 < element.getHeader().size(); ++i2) {
            this.composeString(t, "Endpoint", "header", element.getHeader().get(i2), i2);
        }
    }

    protected void composeEnrollmentRequest(Turtle.Complex parent, String parentType, String name, EnrollmentRequest element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EnrollmentRequest", name, element, index);
        for (int i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "EnrollmentRequest", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EnrollmentRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EnrollmentRequest", "created", element.getCreatedElement(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "EnrollmentRequest", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "EnrollmentRequest", "provider", element.getProvider(), -1);
        }
        if (element.hasCandidate()) {
            this.composeReference(t, "EnrollmentRequest", "candidate", element.getCandidate(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "EnrollmentRequest", "coverage", element.getCoverage(), -1);
        }
    }

    protected void composeEnrollmentResponse(Turtle.Complex parent, String parentType, String name, EnrollmentResponse element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EnrollmentResponse", name, element, index);
        for (int i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "EnrollmentResponse", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EnrollmentResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "EnrollmentResponse", "request", element.getRequest(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "EnrollmentResponse", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "EnrollmentResponse", "disposition", element.getDispositionElement(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "EnrollmentResponse", "created", element.getCreatedElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "EnrollmentResponse", "organization", element.getOrganization(), -1);
        }
        if (element.hasRequestProvider()) {
            this.composeReference(t, "EnrollmentResponse", "requestProvider", element.getRequestProvider(), -1);
        }
    }

    protected void composeEpisodeOfCare(Turtle.Complex parent, String parentType, String name, EpisodeOfCare element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "EpisodeOfCare", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "EpisodeOfCare", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EpisodeOfCare", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getStatusHistory().size(); ++i2) {
            this.composeEpisodeOfCareStatusHistoryComponent(t, "EpisodeOfCare", "statusHistory", element.getStatusHistory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "EpisodeOfCare", "type", element.getType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDiagnosis().size(); ++i2) {
            this.composeEpisodeOfCareDiagnosisComponent(t, "EpisodeOfCare", "diagnosis", element.getDiagnosis().get(i2), i2);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "EpisodeOfCare", "patient", element.getPatient(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "EpisodeOfCare", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EpisodeOfCare", "period", element.getPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getReferralRequest().size(); ++i2) {
            this.composeReference(t, "EpisodeOfCare", "referralRequest", element.getReferralRequest().get(i2), i2);
        }
        if (element.hasCareManager()) {
            this.composeReference(t, "EpisodeOfCare", "careManager", element.getCareManager(), -1);
        }
        for (i2 = 0; i2 < element.getCareTeam().size(); ++i2) {
            this.composeReference(t, "EpisodeOfCare", "careTeam", element.getCareTeam().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAccount().size(); ++i2) {
            this.composeReference(t, "EpisodeOfCare", "account", element.getAccount().get(i2), i2);
        }
    }

    protected void composeEpisodeOfCareStatusHistoryComponent(Turtle.Complex parent, String parentType, String name, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statusHistory", name, element, index);
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EpisodeOfCareStatusHistoryComponent", "status", element.getStatusElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EpisodeOfCareStatusHistoryComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEpisodeOfCareDiagnosisComponent(Turtle.Complex parent, String parentType, String name, EpisodeOfCare.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasCondition()) {
            this.composeCodeableReference(t, "DiagnosisComponent", "condition", element.getCondition(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "role", element.getRole(), -1);
        }
        if (element.hasRankElement()) {
            this.composePositiveInt(t, "DiagnosisComponent", "rank", element.getRankElement(), -1);
        }
    }

    protected void composeEventDefinition(Turtle.Complex parent, String parentType, String name, EventDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "EventDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EventDefinition", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "EventDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "EventDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "EventDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "EventDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "EventDefinition", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EventDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "EventDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "EventDefinition", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "EventDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "EventDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "EventDefinition", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "EventDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "EventDefinition", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "EventDefinition", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "EventDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "EventDefinition", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "EventDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "EventDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "EventDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "EventDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getTopic().size(); ++i2) {
            this.composeCodeableConcept(t, "EventDefinition", "topic", element.getTopic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "EventDefinition", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "EventDefinition", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "EventDefinition", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "EventDefinition", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "EventDefinition", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTrigger().size(); ++i2) {
            this.composeTriggerDefinition(t, "EventDefinition", "trigger", element.getTrigger().get(i2), i2);
        }
    }

    protected void composeEvidence(Turtle.Complex parent, String parentType, String name, Evidence element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "Evidence", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Evidence", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Evidence", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Evidence", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Evidence", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Evidence", "title", element.getTitleElement(), -1);
        }
        if (element.hasCiteAs()) {
            this.composeType(t, "Evidence", "citeAs", element.getCiteAs(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Evidence", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Evidence", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Evidence", "date", element.getDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "Evidence", "useContext", element.getUseContext().get(i2), i2);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Evidence", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Evidence", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Evidence", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "Evidence", "contact", element.getContact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "Evidence", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "Evidence", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "Evidence", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "Evidence", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "Evidence", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Evidence", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasAssertionElement()) {
            this.composeMarkdown(t, "Evidence", "assertion", element.getAssertionElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Evidence", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getVariableDefinition().size(); ++i2) {
            this.composeEvidenceVariableDefinitionComponent(t, "Evidence", "variableDefinition", element.getVariableDefinition().get(i2), i2);
        }
        if (element.hasSynthesisType()) {
            this.composeCodeableConcept(t, "Evidence", "synthesisType", element.getSynthesisType(), -1);
        }
        for (i2 = 0; i2 < element.getStudyDesign().size(); ++i2) {
            this.composeCodeableConcept(t, "Evidence", "studyDesign", element.getStudyDesign().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getStatistic().size(); ++i2) {
            this.composeEvidenceStatisticComponent(t, "Evidence", "statistic", element.getStatistic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCertainty().size(); ++i2) {
            this.composeEvidenceCertaintyComponent(t, "Evidence", "certainty", element.getCertainty().get(i2), i2);
        }
    }

    protected void composeEvidenceVariableDefinitionComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceVariableDefinitionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "variableDefinition", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "EvidenceVariableDefinitionComponent", "description", element.getDescriptionElement(), -1);
        }
        for (int i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "EvidenceVariableDefinitionComponent", "note", element.getNote().get(i2), i2);
        }
        if (element.hasVariableRole()) {
            this.composeCodeableConcept(t, "EvidenceVariableDefinitionComponent", "variableRole", element.getVariableRole(), -1);
        }
        if (element.hasObserved()) {
            this.composeReference(t, "EvidenceVariableDefinitionComponent", "observed", element.getObserved(), -1);
        }
        if (element.hasIntended()) {
            this.composeReference(t, "EvidenceVariableDefinitionComponent", "intended", element.getIntended(), -1);
        }
        if (element.hasDirectnessMatch()) {
            this.composeCodeableConcept(t, "EvidenceVariableDefinitionComponent", "directnessMatch", element.getDirectnessMatch(), -1);
        }
    }

    protected void composeEvidenceStatisticComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceStatisticComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "statistic", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceStatisticComponent", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "EvidenceStatisticComponent", "note", element.getNote().get(i2), i2);
        }
        if (element.hasStatisticType()) {
            this.composeCodeableConcept(t, "EvidenceStatisticComponent", "statisticType", element.getStatisticType(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "EvidenceStatisticComponent", "category", element.getCategory(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "EvidenceStatisticComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasNumberOfEventsElement()) {
            this.composeUnsignedInt(t, "EvidenceStatisticComponent", "numberOfEvents", element.getNumberOfEventsElement(), -1);
        }
        if (element.hasNumberAffectedElement()) {
            this.composeUnsignedInt(t, "EvidenceStatisticComponent", "numberAffected", element.getNumberAffectedElement(), -1);
        }
        if (element.hasSampleSize()) {
            this.composeEvidenceStatisticSampleSizeComponent(t, "EvidenceStatisticComponent", "sampleSize", element.getSampleSize(), -1);
        }
        for (i2 = 0; i2 < element.getAttributeEstimate().size(); ++i2) {
            this.composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticComponent", "attributeEstimate", element.getAttributeEstimate().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getModelCharacteristic().size(); ++i2) {
            this.composeEvidenceStatisticModelCharacteristicComponent(t, "EvidenceStatisticComponent", "modelCharacteristic", element.getModelCharacteristic().get(i2), i2);
        }
    }

    protected void composeEvidenceStatisticSampleSizeComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceStatisticSampleSizeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "sampleSize", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceStatisticSampleSizeComponent", "description", element.getDescriptionElement(), -1);
        }
        for (int i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "EvidenceStatisticSampleSizeComponent", "note", element.getNote().get(i2), i2);
        }
        if (element.hasNumberOfStudiesElement()) {
            this.composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "numberOfStudies", element.getNumberOfStudiesElement(), -1);
        }
        if (element.hasNumberOfParticipantsElement()) {
            this.composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "numberOfParticipants", element.getNumberOfParticipantsElement(), -1);
        }
        if (element.hasKnownDataCountElement()) {
            this.composeUnsignedInt(t, "EvidenceStatisticSampleSizeComponent", "knownDataCount", element.getKnownDataCountElement(), -1);
        }
    }

    protected void composeEvidenceStatisticAttributeEstimateComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceStatisticAttributeEstimateComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "attributeEstimate", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceStatisticAttributeEstimateComponent", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "EvidenceStatisticAttributeEstimateComponent", "note", element.getNote().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EvidenceStatisticAttributeEstimateComponent", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "EvidenceStatisticAttributeEstimateComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasLevelElement()) {
            this.composeDecimal(t, "EvidenceStatisticAttributeEstimateComponent", "level", element.getLevelElement(), -1);
        }
        if (element.hasRange()) {
            this.composeRange(t, "EvidenceStatisticAttributeEstimateComponent", "range", element.getRange(), -1);
        }
        for (i2 = 0; i2 < element.getAttributeEstimate().size(); ++i2) {
            this.composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticAttributeEstimateComponent", "attributeEstimate", element.getAttributeEstimate().get(i2), i2);
        }
    }

    protected void composeEvidenceStatisticModelCharacteristicComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceStatisticModelCharacteristicComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "modelCharacteristic", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "EvidenceStatisticModelCharacteristicComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeQuantity(t, "EvidenceStatisticModelCharacteristicComponent", "value", element.getValue(), -1);
        }
        for (i2 = 0; i2 < element.getVariable().size(); ++i2) {
            this.composeEvidenceStatisticModelCharacteristicVariableComponent(t, "EvidenceStatisticModelCharacteristicComponent", "variable", element.getVariable().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAttributeEstimate().size(); ++i2) {
            this.composeEvidenceStatisticAttributeEstimateComponent(t, "EvidenceStatisticModelCharacteristicComponent", "attributeEstimate", element.getAttributeEstimate().get(i2), i2);
        }
    }

    protected void composeEvidenceStatisticModelCharacteristicVariableComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceStatisticModelCharacteristicVariableComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "variable", name, element, index);
        if (element.hasVariableDefinition()) {
            this.composeReference(t, "EvidenceStatisticModelCharacteristicVariableComponent", "variableDefinition", element.getVariableDefinition(), -1);
        }
        if (element.hasHandlingElement()) {
            this.composeEnum(t, "EvidenceStatisticModelCharacteristicVariableComponent", "handling", element.getHandlingElement(), -1);
        }
        for (i2 = 0; i2 < element.getValueCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueCategory", element.getValueCategory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getValueQuantity().size(); ++i2) {
            this.composeQuantity(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueQuantity", element.getValueQuantity().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getValueRange().size(); ++i2) {
            this.composeRange(t, "EvidenceStatisticModelCharacteristicVariableComponent", "valueRange", element.getValueRange().get(i2), i2);
        }
    }

    protected void composeEvidenceCertaintyComponent(Turtle.Complex parent, String parentType, String name, Evidence.EvidenceCertaintyComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "certainty", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceCertaintyComponent", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "EvidenceCertaintyComponent", "note", element.getNote().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EvidenceCertaintyComponent", "type", element.getType(), -1);
        }
        if (element.hasRating()) {
            this.composeCodeableConcept(t, "EvidenceCertaintyComponent", "rating", element.getRating(), -1);
        }
        if (element.hasRaterElement()) {
            this.composeString(t, "EvidenceCertaintyComponent", "rater", element.getRaterElement(), -1);
        }
        for (i2 = 0; i2 < element.getSubcomponent().size(); ++i2) {
            this.composeEvidenceCertaintyComponent(t, "EvidenceCertaintyComponent", "subcomponent", element.getSubcomponent().get(i2), i2);
        }
    }

    protected void composeEvidenceReport(Turtle.Complex parent, String parentType, String name, EvidenceReport element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "EvidenceReport", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EvidenceReport", "url", element.getUrlElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EvidenceReport", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "EvidenceReport", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "EvidenceReport", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "EvidenceReport", "relatedIdentifier", element.getRelatedIdentifier().get(i2), i2);
        }
        if (element.hasCiteAs()) {
            this.composeType(t, "EvidenceReport", "citeAs", element.getCiteAs(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EvidenceReport", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "EvidenceReport", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "EvidenceReport", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeEvidenceReportSubjectComponent(t, "EvidenceReport", "subject", element.getSubject(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "EvidenceReport", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "EvidenceReport", "contact", element.getContact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "EvidenceReport", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "EvidenceReport", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "EvidenceReport", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "EvidenceReport", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatesTo().size(); ++i2) {
            this.composeEvidenceReportRelatesToComponent(t, "EvidenceReport", "relatesTo", element.getRelatesTo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSection().size(); ++i2) {
            this.composeEvidenceReportSectionComponent(t, "EvidenceReport", "section", element.getSection().get(i2), i2);
        }
    }

    protected void composeEvidenceReportSubjectComponent(Turtle.Complex parent, String parentType, String name, EvidenceReport.EvidenceReportSubjectComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subject", name, element, index);
        for (i2 = 0; i2 < element.getCharacteristic().size(); ++i2) {
            this.composeEvidenceReportSubjectCharacteristicComponent(t, "EvidenceReportSubjectComponent", "characteristic", element.getCharacteristic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "EvidenceReportSubjectComponent", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeEvidenceReportSubjectCharacteristicComponent(Turtle.Complex parent, String parentType, String name, EvidenceReport.EvidenceReportSubjectCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "EvidenceReportSubjectCharacteristicComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "EvidenceReportSubjectCharacteristicComponent", "value", element.getValue(), -1);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "EvidenceReportSubjectCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "EvidenceReportSubjectCharacteristicComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeEvidenceReportRelatesToComponent(Turtle.Complex parent, String parentType, String name, EvidenceReport.EvidenceReportRelatesToComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatesTo", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "EvidenceReportRelatesToComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeEvidenceReportRelatesToTargetComponent(t, "EvidenceReportRelatesToComponent", "target", element.getTarget(), -1);
        }
    }

    protected void composeEvidenceReportRelatesToTargetComponent(Turtle.Complex parent, String parentType, String name, EvidenceReport.EvidenceReportRelatesToTargetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EvidenceReportRelatesToTargetComponent", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "EvidenceReportRelatesToTargetComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasDisplayElement()) {
            this.composeMarkdown(t, "EvidenceReportRelatesToTargetComponent", "display", element.getDisplayElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "EvidenceReportRelatesToTargetComponent", "resource", element.getResource(), -1);
        }
    }

    protected void composeEvidenceReportSectionComponent(Turtle.Complex parent, String parentType, String name, EvidenceReport.SectionComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "section", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "SectionComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasFocus()) {
            this.composeCodeableConcept(t, "SectionComponent", "focus", element.getFocus(), -1);
        }
        if (element.hasFocusReference()) {
            this.composeReference(t, "SectionComponent", "focusReference", element.getFocusReference(), -1);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeReference(t, "SectionComponent", "author", element.getAuthor().get(i2), i2);
        }
        if (element.hasText()) {
            this.composeNarrative(t, "SectionComponent", "text", element.getText(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "SectionComponent", "mode", element.getModeElement(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "SectionComponent", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i2 = 0; i2 < element.getEntryClassifier().size(); ++i2) {
            this.composeCodeableConcept(t, "SectionComponent", "entryClassifier", element.getEntryClassifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEntryReference().size(); ++i2) {
            this.composeReference(t, "SectionComponent", "entryReference", element.getEntryReference().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEntryQuantity().size(); ++i2) {
            this.composeQuantity(t, "SectionComponent", "entryQuantity", element.getEntryQuantity().get(i2), i2);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "SectionComponent", "emptyReason", element.getEmptyReason(), -1);
        }
        for (i2 = 0; i2 < element.getSection().size(); ++i2) {
            this.composeEvidenceReportSectionComponent(t, "SectionComponent", "section", element.getSection().get(i2), i2);
        }
    }

    protected void composeEvidenceVariable(Turtle.Complex parent, String parentType, String name, EvidenceVariable element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "EvidenceVariable", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "EvidenceVariable", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "EvidenceVariable", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "EvidenceVariable", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "EvidenceVariable", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "EvidenceVariable", "title", element.getTitleElement(), -1);
        }
        if (element.hasShortTitleElement()) {
            this.composeString(t, "EvidenceVariable", "shortTitle", element.getShortTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "EvidenceVariable", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "EvidenceVariable", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "EvidenceVariable", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "EvidenceVariable", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "EvidenceVariable", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "EvidenceVariable", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "EvidenceVariable", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "EvidenceVariable", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "EvidenceVariable", "useContext", element.getUseContext().get(i2), i2);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "EvidenceVariable", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "EvidenceVariable", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "EvidenceVariable", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "EvidenceVariable", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "EvidenceVariable", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "EvidenceVariable", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "EvidenceVariable", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "EvidenceVariable", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "EvidenceVariable", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        if (element.hasActualElement()) {
            this.composeBoolean(t, "EvidenceVariable", "actual", element.getActualElement(), -1);
        }
        for (i2 = 0; i2 < element.getCharacteristic().size(); ++i2) {
            this.composeEvidenceVariableCharacteristicComponent(t, "EvidenceVariable", "characteristic", element.getCharacteristic().get(i2), i2);
        }
        if (element.hasHandlingElement()) {
            this.composeEnum(t, "EvidenceVariable", "handling", element.getHandlingElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeEvidenceVariableCategoryComponent(t, "EvidenceVariable", "category", element.getCategory().get(i2), i2);
        }
    }

    protected void composeEvidenceVariableCharacteristicComponent(Turtle.Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasLinkIdElement()) {
            this.composeId(t, "EvidenceVariableCharacteristicComponent", "linkId", element.getLinkIdElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceVariableCharacteristicComponent", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "EvidenceVariableCharacteristicComponent", "note", element.getNote().get(i2), i2);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "EvidenceVariableCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasDefinitionReference()) {
            this.composeReference(t, "EvidenceVariableCharacteristicComponent", "definitionReference", element.getDefinitionReference(), -1);
        }
        if (element.hasDefinitionCanonicalElement()) {
            this.composeCanonical(t, "EvidenceVariableCharacteristicComponent", "definitionCanonical", element.getDefinitionCanonicalElement(), -1);
        }
        if (element.hasDefinitionCodeableConcept()) {
            this.composeCodeableConcept(t, "EvidenceVariableCharacteristicComponent", "definitionCodeableConcept", element.getDefinitionCodeableConcept(), -1);
        }
        if (element.hasDefinitionExpression()) {
            this.composeExpression(t, "EvidenceVariableCharacteristicComponent", "definitionExpression", element.getDefinitionExpression(), -1);
        }
        if (element.hasDefinitionIdElement()) {
            this.composeId(t, "EvidenceVariableCharacteristicComponent", "definitionId", element.getDefinitionIdElement(), -1);
        }
        if (element.hasDefinitionByTypeAndValue()) {
            this.composeEvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(t, "EvidenceVariableCharacteristicComponent", "definitionByTypeAndValue", element.getDefinitionByTypeAndValue(), -1);
        }
        if (element.hasDefinitionByCombination()) {
            this.composeEvidenceVariableCharacteristicDefinitionByCombinationComponent(t, "EvidenceVariableCharacteristicComponent", "definitionByCombination", element.getDefinitionByCombination(), -1);
        }
        for (i2 = 0; i2 < element.getTimeFromEvent().size(); ++i2) {
            this.composeEvidenceVariableCharacteristicTimeFromEventComponent(t, "EvidenceVariableCharacteristicComponent", "timeFromEvent", element.getTimeFromEvent().get(i2), i2);
        }
    }

    protected void composeEvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(Turtle.Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "definitionByTypeAndValue", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent", "type", element.getType(), -1);
        }
        for (int i2 = 0; i2 < element.getMethod().size(); ++i2) {
            this.composeCodeableConcept(t, "EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent", "method", element.getMethod().get(i2), i2);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent", "device", element.getDevice(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent", "value", element.getValue(), -1);
        }
        if (element.hasOffset()) {
            this.composeCodeableConcept(t, "EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent", "offset", element.getOffset(), -1);
        }
    }

    protected void composeEvidenceVariableCharacteristicDefinitionByCombinationComponent(Turtle.Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "definitionByCombination", name, element, index);
        if (element.hasCodeElement()) {
            this.composeEnum(t, "EvidenceVariableCharacteristicDefinitionByCombinationComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasThresholdElement()) {
            this.composePositiveInt(t, "EvidenceVariableCharacteristicDefinitionByCombinationComponent", "threshold", element.getThresholdElement(), -1);
        }
        for (int i2 = 0; i2 < element.getCharacteristic().size(); ++i2) {
            this.composeEvidenceVariableCharacteristicComponent(t, "EvidenceVariableCharacteristicDefinitionByCombinationComponent", "characteristic", element.getCharacteristic().get(i2), i2);
        }
    }

    protected void composeEvidenceVariableCharacteristicTimeFromEventComponent(Turtle.Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "timeFromEvent", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "EvidenceVariableCharacteristicTimeFromEventComponent", "description", element.getDescriptionElement(), -1);
        }
        for (int i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "EvidenceVariableCharacteristicTimeFromEventComponent", "note", element.getNote().get(i2), i2);
        }
        if (element.hasEvent()) {
            this.composeType(t, "EvidenceVariableCharacteristicTimeFromEventComponent", "event", element.getEvent(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "EvidenceVariableCharacteristicTimeFromEventComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasRange()) {
            this.composeRange(t, "EvidenceVariableCharacteristicTimeFromEventComponent", "range", element.getRange(), -1);
        }
    }

    protected void composeEvidenceVariableCategoryComponent(Turtle.Complex parent, String parentType, String name, EvidenceVariable.EvidenceVariableCategoryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "category", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "EvidenceVariableCategoryComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "EvidenceVariableCategoryComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeExampleScenario(Turtle.Complex parent, String parentType, String name, ExampleScenario element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeCanonicalResource(t, "ExampleScenario", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ExampleScenario", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ExampleScenario", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ExampleScenario", "version", element.getVersionElement(), -1);
        }
        if (element.hasVersionAlgorithm()) {
            this.composeType(t, "ExampleScenario", "versionAlgorithm", element.getVersionAlgorithm(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ExampleScenario", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenario", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ExampleScenario", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ExampleScenario", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ExampleScenario", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ExampleScenario", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "ExampleScenario", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenario", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "ExampleScenario", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "ExampleScenario", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ExampleScenario", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ExampleScenario", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasCopyrightLabelElement()) {
            this.composeString(t, "ExampleScenario", "copyrightLabel", element.getCopyrightLabelElement(), -1);
        }
        for (i2 = 0; i2 < element.getActor().size(); ++i2) {
            this.composeExampleScenarioActorComponent(t, "ExampleScenario", "actor", element.getActor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstance().size(); ++i2) {
            this.composeExampleScenarioInstanceComponent(t, "ExampleScenario", "instance", element.getInstance().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProcess().size(); ++i2) {
            this.composeExampleScenarioProcessComponent(t, "ExampleScenario", "process", element.getProcess().get(i2), i2);
        }
    }

    protected void composeExampleScenarioActorComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioActorComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "actor", name, element, index);
        if (element.hasKeyElement()) {
            this.composeString(t, "ExampleScenarioActorComponent", "key", element.getKeyElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ExampleScenarioActorComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenarioActorComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioActorComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeExampleScenarioInstanceComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasKeyElement()) {
            this.composeString(t, "ExampleScenarioInstanceComponent", "key", element.getKeyElement(), -1);
        }
        if (element.hasStructureType()) {
            this.composeCoding(t, "ExampleScenarioInstanceComponent", "structureType", element.getStructureType(), -1);
        }
        if (element.hasStructureVersionElement()) {
            this.composeString(t, "ExampleScenarioInstanceComponent", "structureVersion", element.getStructureVersionElement(), -1);
        }
        if (element.hasStructureProfile()) {
            this.composeType(t, "ExampleScenarioInstanceComponent", "structureProfile", element.getStructureProfile(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenarioInstanceComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioInstanceComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasContent()) {
            this.composeReference(t, "ExampleScenarioInstanceComponent", "content", element.getContent(), -1);
        }
        for (i2 = 0; i2 < element.getVersion().size(); ++i2) {
            this.composeExampleScenarioInstanceVersionComponent(t, "ExampleScenarioInstanceComponent", "version", element.getVersion().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContainedInstance().size(); ++i2) {
            this.composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioInstanceComponent", "containedInstance", element.getContainedInstance().get(i2), i2);
        }
    }

    protected void composeExampleScenarioInstanceVersionComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceVersionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "version", name, element, index);
        if (element.hasKeyElement()) {
            this.composeString(t, "ExampleScenarioInstanceVersionComponent", "key", element.getKeyElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenarioInstanceVersionComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioInstanceVersionComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasContent()) {
            this.composeReference(t, "ExampleScenarioInstanceVersionComponent", "content", element.getContent(), -1);
        }
    }

    protected void composeExampleScenarioInstanceContainedInstanceComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "containedInstance", name, element, index);
        if (element.hasInstanceReferenceElement()) {
            this.composeString(t, "ExampleScenarioInstanceContainedInstanceComponent", "instanceReference", element.getInstanceReferenceElement(), -1);
        }
        if (element.hasVersionReferenceElement()) {
            this.composeString(t, "ExampleScenarioInstanceContainedInstanceComponent", "versionReference", element.getVersionReferenceElement(), -1);
        }
    }

    protected void composeExampleScenarioProcessComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "process", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenarioProcessComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioProcessComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasPreConditionsElement()) {
            this.composeMarkdown(t, "ExampleScenarioProcessComponent", "preConditions", element.getPreConditionsElement(), -1);
        }
        if (element.hasPostConditionsElement()) {
            this.composeMarkdown(t, "ExampleScenarioProcessComponent", "postConditions", element.getPostConditionsElement(), -1);
        }
        for (int i2 = 0; i2 < element.getStep().size(); ++i2) {
            this.composeExampleScenarioProcessStepComponent(t, "ExampleScenarioProcessComponent", "step", element.getStep().get(i2), i2);
        }
    }

    protected void composeExampleScenarioProcessStepComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "step", name, element, index);
        if (element.hasNumberElement()) {
            this.composeString(t, "ExampleScenarioProcessStepComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasProcess()) {
            this.composeExampleScenarioProcessComponent(t, "ExampleScenarioProcessStepComponent", "process", element.getProcess(), -1);
        }
        if (element.hasWorkflowElement()) {
            this.composeCanonical(t, "ExampleScenarioProcessStepComponent", "workflow", element.getWorkflowElement(), -1);
        }
        if (element.hasOperation()) {
            this.composeExampleScenarioProcessStepOperationComponent(t, "ExampleScenarioProcessStepComponent", "operation", element.getOperation(), -1);
        }
        for (int i2 = 0; i2 < element.getAlternative().size(); ++i2) {
            this.composeExampleScenarioProcessStepAlternativeComponent(t, "ExampleScenarioProcessStepComponent", "alternative", element.getAlternative().get(i2), i2);
        }
        if (element.hasPauseElement()) {
            this.composeBoolean(t, "ExampleScenarioProcessStepComponent", "pause", element.getPauseElement(), -1);
        }
    }

    protected void composeExampleScenarioProcessStepOperationComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasType()) {
            this.composeCoding(t, "ExampleScenarioProcessStepOperationComponent", "type", element.getType(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenarioProcessStepOperationComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasInitiatorElement()) {
            this.composeString(t, "ExampleScenarioProcessStepOperationComponent", "initiator", element.getInitiatorElement(), -1);
        }
        if (element.hasReceiverElement()) {
            this.composeString(t, "ExampleScenarioProcessStepOperationComponent", "receiver", element.getReceiverElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioProcessStepOperationComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasInitiatorActiveElement()) {
            this.composeBoolean(t, "ExampleScenarioProcessStepOperationComponent", "initiatorActive", element.getInitiatorActiveElement(), -1);
        }
        if (element.hasReceiverActiveElement()) {
            this.composeBoolean(t, "ExampleScenarioProcessStepOperationComponent", "receiverActive", element.getReceiverActiveElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioProcessStepOperationComponent", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeExampleScenarioInstanceContainedInstanceComponent(t, "ExampleScenarioProcessStepOperationComponent", "response", element.getResponse(), -1);
        }
    }

    protected void composeExampleScenarioProcessStepAlternativeComponent(Turtle.Complex parent, String parentType, String name, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "alternative", name, element, index);
        if (element.hasTitleElement()) {
            this.composeString(t, "ExampleScenarioProcessStepAlternativeComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ExampleScenarioProcessStepAlternativeComponent", "description", element.getDescriptionElement(), -1);
        }
        for (int i2 = 0; i2 < element.getStep().size(); ++i2) {
            this.composeExampleScenarioProcessStepComponent(t, "ExampleScenarioProcessStepAlternativeComponent", "step", element.getStep().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefit(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ExplanationOfBenefit", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ExplanationOfBenefit", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "status", element.getStatusElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "type", element.getType(), -1);
        }
        if (element.hasSubType()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "subType", element.getSubType(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "use", element.getUseElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ExplanationOfBenefit", "patient", element.getPatient(), -1);
        }
        if (element.hasBillablePeriod()) {
            this.composePeriod(t, "ExplanationOfBenefit", "billablePeriod", element.getBillablePeriod(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "ExplanationOfBenefit", "created", element.getCreatedElement(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "ExplanationOfBenefit", "enterer", element.getEnterer(), -1);
        }
        if (element.hasInsurer()) {
            this.composeReference(t, "ExplanationOfBenefit", "insurer", element.getInsurer(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "ExplanationOfBenefit", "provider", element.getProvider(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "priority", element.getPriority(), -1);
        }
        if (element.hasFundsReserveRequested()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "fundsReserveRequested", element.getFundsReserveRequested(), -1);
        }
        if (element.hasFundsReserve()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "fundsReserve", element.getFundsReserve(), -1);
        }
        for (i2 = 0; i2 < element.getRelated().size(); ++i2) {
            this.composeExplanationOfBenefitRelatedClaimComponent(t, "ExplanationOfBenefit", "related", element.getRelated().get(i2), i2);
        }
        if (element.hasPrescription()) {
            this.composeReference(t, "ExplanationOfBenefit", "prescription", element.getPrescription(), -1);
        }
        if (element.hasOriginalPrescription()) {
            this.composeReference(t, "ExplanationOfBenefit", "originalPrescription", element.getOriginalPrescription(), -1);
        }
        if (element.hasPayee()) {
            this.composeExplanationOfBenefitPayeeComponent(t, "ExplanationOfBenefit", "payee", element.getPayee(), -1);
        }
        if (element.hasReferral()) {
            this.composeReference(t, "ExplanationOfBenefit", "referral", element.getReferral(), -1);
        }
        for (i2 = 0; i2 < element.getEncounter().size(); ++i2) {
            this.composeReference(t, "ExplanationOfBenefit", "encounter", element.getEncounter().get(i2), i2);
        }
        if (element.hasFacility()) {
            this.composeReference(t, "ExplanationOfBenefit", "facility", element.getFacility(), -1);
        }
        if (element.hasClaim()) {
            this.composeReference(t, "ExplanationOfBenefit", "claim", element.getClaim(), -1);
        }
        if (element.hasClaimResponse()) {
            this.composeReference(t, "ExplanationOfBenefit", "claimResponse", element.getClaimResponse(), -1);
        }
        if (element.hasOutcomeElement()) {
            this.composeEnum(t, "ExplanationOfBenefit", "outcome", element.getOutcomeElement(), -1);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "decision", element.getDecision(), -1);
        }
        if (element.hasDispositionElement()) {
            this.composeString(t, "ExplanationOfBenefit", "disposition", element.getDispositionElement(), -1);
        }
        for (i2 = 0; i2 < element.getPreAuthRef().size(); ++i2) {
            this.composeString(t, "ExplanationOfBenefit", "preAuthRef", element.getPreAuthRef().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPreAuthRefPeriod().size(); ++i2) {
            this.composePeriod(t, "ExplanationOfBenefit", "preAuthRefPeriod", element.getPreAuthRefPeriod().get(i2), i2);
        }
        if (element.hasDiagnosisRelatedGroup()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "diagnosisRelatedGroup", element.getDiagnosisRelatedGroup(), -1);
        }
        for (i2 = 0; i2 < element.getCareTeam().size(); ++i2) {
            this.composeExplanationOfBenefitCareTeamComponent(t, "ExplanationOfBenefit", "careTeam", element.getCareTeam().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingInfo().size(); ++i2) {
            this.composeExplanationOfBenefitSupportingInformationComponent(t, "ExplanationOfBenefit", "supportingInfo", element.getSupportingInfo().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDiagnosis().size(); ++i2) {
            this.composeExplanationOfBenefitDiagnosisComponent(t, "ExplanationOfBenefit", "diagnosis", element.getDiagnosis().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProcedure().size(); ++i2) {
            this.composeExplanationOfBenefitProcedureComponent(t, "ExplanationOfBenefit", "procedure", element.getProcedure().get(i2), i2);
        }
        if (element.hasPrecedenceElement()) {
            this.composePositiveInt(t, "ExplanationOfBenefit", "precedence", element.getPrecedenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getInsurance().size(); ++i2) {
            this.composeExplanationOfBenefitInsuranceComponent(t, "ExplanationOfBenefit", "insurance", element.getInsurance().get(i2), i2);
        }
        if (element.hasAccident()) {
            this.composeExplanationOfBenefitAccidentComponent(t, "ExplanationOfBenefit", "accident", element.getAccident(), -1);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "ExplanationOfBenefit", "patientPaid", element.getPatientPaid(), -1);
        }
        for (i2 = 0; i2 < element.getItem().size(); ++i2) {
            this.composeExplanationOfBenefitItemComponent(t, "ExplanationOfBenefit", "item", element.getItem().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAddItem().size(); ++i2) {
            this.composeExplanationOfBenefitAddedItemComponent(t, "ExplanationOfBenefit", "addItem", element.getAddItem().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ExplanationOfBenefit", "adjudication", element.getAdjudication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTotal().size(); ++i2) {
            this.composeExplanationOfBenefitTotalComponent(t, "ExplanationOfBenefit", "total", element.getTotal().get(i2), i2);
        }
        if (element.hasPayment()) {
            this.composeExplanationOfBenefitPaymentComponent(t, "ExplanationOfBenefit", "payment", element.getPayment(), -1);
        }
        if (element.hasFormCode()) {
            this.composeCodeableConcept(t, "ExplanationOfBenefit", "formCode", element.getFormCode(), -1);
        }
        if (element.hasForm()) {
            this.composeAttachment(t, "ExplanationOfBenefit", "form", element.getForm(), -1);
        }
        for (i2 = 0; i2 < element.getProcessNote().size(); ++i2) {
            this.composeExplanationOfBenefitNoteComponent(t, "ExplanationOfBenefit", "processNote", element.getProcessNote().get(i2), i2);
        }
        if (element.hasBenefitPeriod()) {
            this.composePeriod(t, "ExplanationOfBenefit", "benefitPeriod", element.getBenefitPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getBenefitBalance().size(); ++i2) {
            this.composeExplanationOfBenefitBenefitBalanceComponent(t, "ExplanationOfBenefit", "benefitBalance", element.getBenefitBalance().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitRelatedClaimComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.RelatedClaimComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "related", name, element, index);
        if (element.hasClaim()) {
            this.composeReference(t, "RelatedClaimComponent", "claim", element.getClaim(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "RelatedClaimComponent", "relationship", element.getRelationship(), -1);
        }
        if (element.hasReference()) {
            this.composeIdentifier(t, "RelatedClaimComponent", "reference", element.getReference(), -1);
        }
    }

    protected void composeExplanationOfBenefitPayeeComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.PayeeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payee", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PayeeComponent", "type", element.getType(), -1);
        }
        if (element.hasParty()) {
            this.composeReference(t, "PayeeComponent", "party", element.getParty(), -1);
        }
    }

    protected void composeExplanationOfBenefitCareTeamComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.CareTeamComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "careTeam", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "CareTeamComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "CareTeamComponent", "provider", element.getProvider(), -1);
        }
        if (element.hasResponsibleElement()) {
            this.composeBoolean(t, "CareTeamComponent", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "CareTeamComponent", "role", element.getRole(), -1);
        }
        if (element.hasSpecialty()) {
            this.composeCodeableConcept(t, "CareTeamComponent", "specialty", element.getSpecialty(), -1);
        }
    }

    protected void composeExplanationOfBenefitSupportingInformationComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.SupportingInformationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supportingInfo", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "SupportingInformationComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "SupportingInformationComponent", "category", element.getCategory(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "SupportingInformationComponent", "code", element.getCode(), -1);
        }
        if (element.hasTiming()) {
            this.composeType(t, "SupportingInformationComponent", "timing", element.getTiming(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "SupportingInformationComponent", "value", element.getValue(), -1);
        }
        if (element.hasReason()) {
            this.composeCoding(t, "SupportingInformationComponent", "reason", element.getReason(), -1);
        }
    }

    protected void composeExplanationOfBenefitDiagnosisComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.DiagnosisComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "diagnosis", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "DiagnosisComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasDiagnosis()) {
            this.composeType(t, "DiagnosisComponent", "diagnosis", element.getDiagnosis(), -1);
        }
        for (int i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "type", element.getType().get(i2), i2);
        }
        if (element.hasOnAdmission()) {
            this.composeCodeableConcept(t, "DiagnosisComponent", "onAdmission", element.getOnAdmission(), -1);
        }
    }

    protected void composeExplanationOfBenefitProcedureComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.ProcedureComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ProcedureComponent", "sequence", element.getSequenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "ProcedureComponent", "type", element.getType().get(i2), i2);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ProcedureComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasProcedure()) {
            this.composeType(t, "ProcedureComponent", "procedure", element.getProcedure(), -1);
        }
        for (i2 = 0; i2 < element.getUdi().size(); ++i2) {
            this.composeReference(t, "ProcedureComponent", "udi", element.getUdi().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitInsuranceComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.InsuranceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "insurance", name, element, index);
        if (element.hasFocalElement()) {
            this.composeBoolean(t, "InsuranceComponent", "focal", element.getFocalElement(), -1);
        }
        if (element.hasCoverage()) {
            this.composeReference(t, "InsuranceComponent", "coverage", element.getCoverage(), -1);
        }
        for (int i2 = 0; i2 < element.getPreAuthRef().size(); ++i2) {
            this.composeString(t, "InsuranceComponent", "preAuthRef", element.getPreAuthRef().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitAccidentComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AccidentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "accident", name, element, index);
        if (element.hasDateElement()) {
            this.composeDate(t, "AccidentComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "AccidentComponent", "type", element.getType(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "AccidentComponent", "location", element.getLocation(), -1);
        }
    }

    protected void composeExplanationOfBenefitItemComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.ItemComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "ItemComponent", "sequence", element.getSequenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getCareTeamSequence().size(); ++i2) {
            this.composePositiveInt(t, "ItemComponent", "careTeamSequence", element.getCareTeamSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDiagnosisSequence().size(); ++i2) {
            this.composePositiveInt(t, "ItemComponent", "diagnosisSequence", element.getDiagnosisSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProcedureSequence().size(); ++i2) {
            this.composePositiveInt(t, "ItemComponent", "procedureSequence", element.getProcedureSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInformationSequence().size(); ++i2) {
            this.composePositiveInt(t, "ItemComponent", "informationSequence", element.getInformationSequence().get(i2), i2);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "ItemComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "ItemComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "ItemComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "ItemComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "ItemComponent", "modifier", element.getModifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgramCode().size(); ++i2) {
            this.composeCodeableConcept(t, "ItemComponent", "programCode", element.getProgramCode().get(i2), i2);
        }
        if (element.hasServiced()) {
            this.composeType(t, "ItemComponent", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "ItemComponent", "location", element.getLocation(), -1);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "ItemComponent", "patientPaid", element.getPatientPaid(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "ItemComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "ItemComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "ItemComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "ItemComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "ItemComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getUdi().size(); ++i2) {
            this.composeReference(t, "ItemComponent", "udi", element.getUdi().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBodySite().size(); ++i2) {
            this.composeExplanationOfBenefitItemBodySiteComponent(t, "ItemComponent", "bodySite", element.getBodySite().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEncounter().size(); ++i2) {
            this.composeReference(t, "ItemComponent", "encounter", element.getEncounter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "ItemComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "ItemComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "ItemComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDetail().size(); ++i2) {
            this.composeExplanationOfBenefitDetailComponent(t, "ItemComponent", "detail", element.getDetail().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitItemBodySiteComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.ItemBodySiteComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "bodySite", name, element, index);
        for (i2 = 0; i2 < element.getSite().size(); ++i2) {
            this.composeCodeableReference(t, "ItemBodySiteComponent", "site", element.getSite().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubSite().size(); ++i2) {
            this.composeCodeableConcept(t, "ItemBodySiteComponent", "subSite", element.getSubSite().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitAdjudicationComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AdjudicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adjudication", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "AdjudicationComponent", "category", element.getCategory(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "AdjudicationComponent", "reason", element.getReason(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "AdjudicationComponent", "amount", element.getAmount(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDecimal(t, "AdjudicationComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeExplanationOfBenefitDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.DetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "DetailComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "DetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "DetailComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "DetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "DetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "DetailComponent", "modifier", element.getModifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgramCode().size(); ++i2) {
            this.composeCodeableConcept(t, "DetailComponent", "programCode", element.getProgramCode().get(i2), i2);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "DetailComponent", "patientPaid", element.getPatientPaid(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "DetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "DetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "DetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "DetailComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "DetailComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getUdi().size(); ++i2) {
            this.composeReference(t, "DetailComponent", "udi", element.getUdi().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "DetailComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "DetailComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "DetailComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubDetail().size(); ++i2) {
            this.composeExplanationOfBenefitSubDetailComponent(t, "DetailComponent", "subDetail", element.getSubDetail().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitSubDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.SubDetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "SubDetailComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "category", element.getCategory(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "SubDetailComponent", "modifier", element.getModifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgramCode().size(); ++i2) {
            this.composeCodeableConcept(t, "SubDetailComponent", "programCode", element.getProgramCode().get(i2), i2);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "SubDetailComponent", "patientPaid", element.getPatientPaid(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "SubDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "SubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "SubDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "SubDetailComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "SubDetailComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getUdi().size(); ++i2) {
            this.composeReference(t, "SubDetailComponent", "udi", element.getUdi().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "SubDetailComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "SubDetailComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "SubDetailComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitAddedItemComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "addItem", name, element, index);
        for (i2 = 0; i2 < element.getItemSequence().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemComponent", "itemSequence", element.getItemSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDetailSequence().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemComponent", "detailSequence", element.getDetailSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubDetailSequence().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemComponent", "subDetailSequence", element.getSubDetailSequence().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProvider().size(); ++i2) {
            this.composeReference(t, "AddedItemComponent", "provider", element.getProvider().get(i2), i2);
        }
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "AddedItemComponent", "modifier", element.getModifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgramCode().size(); ++i2) {
            this.composeCodeableConcept(t, "AddedItemComponent", "programCode", element.getProgramCode().get(i2), i2);
        }
        if (element.hasServiced()) {
            this.composeType(t, "AddedItemComponent", "serviced", element.getServiced(), -1);
        }
        if (element.hasLocation()) {
            this.composeType(t, "AddedItemComponent", "location", element.getLocation(), -1);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "AddedItemComponent", "patientPaid", element.getPatientPaid(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "AddedItemComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getBodySite().size(); ++i2) {
            this.composeExplanationOfBenefitAddedItemBodySiteComponent(t, "AddedItemComponent", "bodySite", element.getBodySite().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "AddedItemComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDetail().size(); ++i2) {
            this.composeExplanationOfBenefitAddedItemDetailComponent(t, "AddedItemComponent", "detail", element.getDetail().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitAddedItemBodySiteComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemBodySiteComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "bodySite", name, element, index);
        for (i2 = 0; i2 < element.getSite().size(); ++i2) {
            this.composeCodeableReference(t, "AddedItemBodySiteComponent", "site", element.getSite().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubSite().size(); ++i2) {
            this.composeCodeableConcept(t, "AddedItemBodySiteComponent", "subSite", element.getSubSite().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitAddedItemDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "detail", name, element, index);
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "modifier", element.getModifier().get(i2), i2);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "AddedItemDetailComponent", "patientPaid", element.getPatientPaid(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "AddedItemDetailComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemDetailComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemDetailComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "AddedItemDetailComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemDetailComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubDetail().size(); ++i2) {
            this.composeExplanationOfBenefitAddedItemDetailSubDetailComponent(t, "AddedItemDetailComponent", "subDetail", element.getSubDetail().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitAddedItemDetailSubDetailComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.AddedItemDetailSubDetailComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "subDetail", name, element, index);
        if (element.hasRevenue()) {
            this.composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "revenue", element.getRevenue(), -1);
        }
        if (element.hasProductOrService()) {
            this.composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "productOrService", element.getProductOrService(), -1);
        }
        if (element.hasProductOrServiceEnd()) {
            this.composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "productOrServiceEnd", element.getProductOrServiceEnd(), -1);
        }
        for (i2 = 0; i2 < element.getModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "modifier", element.getModifier().get(i2), i2);
        }
        if (element.hasPatientPaid()) {
            this.composeMoney(t, "AddedItemDetailSubDetailComponent", "patientPaid", element.getPatientPaid(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "AddedItemDetailSubDetailComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasUnitPrice()) {
            this.composeMoney(t, "AddedItemDetailSubDetailComponent", "unitPrice", element.getUnitPrice(), -1);
        }
        if (element.hasFactorElement()) {
            this.composeDecimal(t, "AddedItemDetailSubDetailComponent", "factor", element.getFactorElement(), -1);
        }
        if (element.hasTax()) {
            this.composeMoney(t, "AddedItemDetailSubDetailComponent", "tax", element.getTax(), -1);
        }
        if (element.hasNet()) {
            this.composeMoney(t, "AddedItemDetailSubDetailComponent", "net", element.getNet(), -1);
        }
        for (i2 = 0; i2 < element.getNoteNumber().size(); ++i2) {
            this.composePositiveInt(t, "AddedItemDetailSubDetailComponent", "noteNumber", element.getNoteNumber().get(i2), i2);
        }
        if (element.hasDecision()) {
            this.composeCodeableConcept(t, "AddedItemDetailSubDetailComponent", "decision", element.getDecision(), -1);
        }
        for (i2 = 0; i2 < element.getAdjudication().size(); ++i2) {
            this.composeExplanationOfBenefitAdjudicationComponent(t, "AddedItemDetailSubDetailComponent", "adjudication", element.getAdjudication().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitTotalComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.TotalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "total", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "TotalComponent", "category", element.getCategory(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "TotalComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeExplanationOfBenefitPaymentComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.PaymentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "payment", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PaymentComponent", "type", element.getType(), -1);
        }
        if (element.hasAdjustment()) {
            this.composeMoney(t, "PaymentComponent", "adjustment", element.getAdjustment(), -1);
        }
        if (element.hasAdjustmentReason()) {
            this.composeCodeableConcept(t, "PaymentComponent", "adjustmentReason", element.getAdjustmentReason(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDate(t, "PaymentComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "PaymentComponent", "amount", element.getAmount(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "PaymentComponent", "identifier", element.getIdentifier(), -1);
        }
    }

    protected void composeExplanationOfBenefitNoteComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.NoteComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "processNote", name, element, index);
        if (element.hasNumberElement()) {
            this.composePositiveInt(t, "NoteComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "NoteComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "NoteComponent", "text", element.getTextElement(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "NoteComponent", "language", element.getLanguage(), -1);
        }
    }

    protected void composeExplanationOfBenefitBenefitBalanceComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitBalanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefitBalance", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "BenefitBalanceComponent", "category", element.getCategory(), -1);
        }
        if (element.hasExcludedElement()) {
            this.composeBoolean(t, "BenefitBalanceComponent", "excluded", element.getExcludedElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "BenefitBalanceComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "BenefitBalanceComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNetwork()) {
            this.composeCodeableConcept(t, "BenefitBalanceComponent", "network", element.getNetwork(), -1);
        }
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "BenefitBalanceComponent", "unit", element.getUnit(), -1);
        }
        if (element.hasTerm()) {
            this.composeCodeableConcept(t, "BenefitBalanceComponent", "term", element.getTerm(), -1);
        }
        for (int i2 = 0; i2 < element.getFinancial().size(); ++i2) {
            this.composeExplanationOfBenefitBenefitComponent(t, "BenefitBalanceComponent", "financial", element.getFinancial().get(i2), i2);
        }
    }

    protected void composeExplanationOfBenefitBenefitComponent(Turtle.Complex parent, String parentType, String name, ExplanationOfBenefit.BenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "financial", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "BenefitComponent", "type", element.getType(), -1);
        }
        if (element.hasAllowed()) {
            this.composeType(t, "BenefitComponent", "allowed", element.getAllowed(), -1);
        }
        if (element.hasUsed()) {
            this.composeType(t, "BenefitComponent", "used", element.getUsed(), -1);
        }
    }

    protected void composeFamilyMemberHistory(Turtle.Complex parent, String parentType, String name, FamilyMemberHistory element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "FamilyMemberHistory", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "FamilyMemberHistory", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesCanonical().size(); ++i2) {
            this.composeCanonical(t, "FamilyMemberHistory", "instantiatesCanonical", element.getInstantiatesCanonical().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesUri().size(); ++i2) {
            this.composeUri(t, "FamilyMemberHistory", "instantiatesUri", element.getInstantiatesUri().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "FamilyMemberHistory", "status", element.getStatusElement(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "FamilyMemberHistory", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "FamilyMemberHistory", "date", element.getDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getParticipant().size(); ++i2) {
            this.composeFamilyMemberHistoryParticipantComponent(t, "FamilyMemberHistory", "participant", element.getParticipant().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "FamilyMemberHistory", "name", element.getNameElement(), -1);
        }
        if (element.hasRelationship()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "relationship", element.getRelationship(), -1);
        }
        if (element.hasSex()) {
            this.composeCodeableConcept(t, "FamilyMemberHistory", "sex", element.getSex(), -1);
        }
        if (element.hasBorn()) {
            this.composeType(t, "FamilyMemberHistory", "born", element.getBorn(), -1);
        }
        if (element.hasAge()) {
            this.composeType(t, "FamilyMemberHistory", "age", element.getAge(), -1);
        }
        if (element.hasEstimatedAgeElement()) {
            this.composeBoolean(t, "FamilyMemberHistory", "estimatedAge", element.getEstimatedAgeElement(), -1);
        }
        if (element.hasDeceased()) {
            this.composeType(t, "FamilyMemberHistory", "deceased", element.getDeceased(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "FamilyMemberHistory", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "FamilyMemberHistory", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCondition().size(); ++i2) {
            this.composeFamilyMemberHistoryConditionComponent(t, "FamilyMemberHistory", "condition", element.getCondition().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProcedure().size(); ++i2) {
            this.composeFamilyMemberHistoryProcedureComponent(t, "FamilyMemberHistory", "procedure", element.getProcedure().get(i2), i2);
        }
    }

    protected void composeFamilyMemberHistoryParticipantComponent(Turtle.Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "FamilyMemberHistoryParticipantComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "FamilyMemberHistoryParticipantComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeFamilyMemberHistoryConditionComponent(Turtle.Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryConditionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "condition", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "FamilyMemberHistoryConditionComponent", "code", element.getCode(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "FamilyMemberHistoryConditionComponent", "outcome", element.getOutcome(), -1);
        }
        if (element.hasContributedToDeathElement()) {
            this.composeBoolean(t, "FamilyMemberHistoryConditionComponent", "contributedToDeath", element.getContributedToDeathElement(), -1);
        }
        if (element.hasOnset()) {
            this.composeType(t, "FamilyMemberHistoryConditionComponent", "onset", element.getOnset(), -1);
        }
        for (int i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "FamilyMemberHistoryConditionComponent", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeFamilyMemberHistoryProcedureComponent(Turtle.Complex parent, String parentType, String name, FamilyMemberHistory.FamilyMemberHistoryProcedureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "procedure", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "FamilyMemberHistoryProcedureComponent", "code", element.getCode(), -1);
        }
        if (element.hasOutcome()) {
            this.composeCodeableConcept(t, "FamilyMemberHistoryProcedureComponent", "outcome", element.getOutcome(), -1);
        }
        if (element.hasContributedToDeathElement()) {
            this.composeBoolean(t, "FamilyMemberHistoryProcedureComponent", "contributedToDeath", element.getContributedToDeathElement(), -1);
        }
        if (element.hasPerformed()) {
            this.composeType(t, "FamilyMemberHistoryProcedureComponent", "performed", element.getPerformed(), -1);
        }
        for (int i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "FamilyMemberHistoryProcedureComponent", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeFlag(Turtle.Complex parent, String parentType, String name, Flag element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Flag", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Flag", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Flag", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "Flag", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Flag", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Flag", "subject", element.getSubject(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "Flag", "period", element.getPeriod(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Flag", "encounter", element.getEncounter(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Flag", "author", element.getAuthor(), -1);
        }
    }

    protected void composeFormularyItem(Turtle.Complex parent, String parentType, String name, FormularyItem element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "FormularyItem", name, element, index);
        for (int i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "FormularyItem", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "FormularyItem", "code", element.getCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "FormularyItem", "status", element.getStatusElement(), -1);
        }
    }

    protected void composeGenomicStudy(Turtle.Complex parent, String parentType, String name, GenomicStudy element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "GenomicStudy", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "GenomicStudy", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "GenomicStudy", "status", element.getStatus(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "GenomicStudy", "type", element.getType().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "GenomicStudy", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "GenomicStudy", "encounter", element.getEncounter(), -1);
        }
        if (element.hasStartDateElement()) {
            this.composeDateTime(t, "GenomicStudy", "startDate", element.getStartDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "GenomicStudy", "basedOn", element.getBasedOn().get(i2), i2);
        }
        if (element.hasReferrer()) {
            this.composeReference(t, "GenomicStudy", "referrer", element.getReferrer(), -1);
        }
        for (i2 = 0; i2 < element.getInterpreter().size(); ++i2) {
            this.composeReference(t, "GenomicStudy", "interpreter", element.getInterpreter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "GenomicStudy", "reason", element.getReason().get(i2), i2);
        }
        if (element.hasInstantiatesCanonicalElement()) {
            this.composeCanonical(t, "GenomicStudy", "instantiatesCanonical", element.getInstantiatesCanonicalElement(), -1);
        }
        if (element.hasInstantiatesUriElement()) {
            this.composeUri(t, "GenomicStudy", "instantiatesUri", element.getInstantiatesUriElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "GenomicStudy", "note", element.getNote().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GenomicStudy", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getAnalysis().size(); ++i2) {
            this.composeGenomicStudyAnalysisComponent(t, "GenomicStudy", "analysis", element.getAnalysis().get(i2), i2);
        }
    }

    protected void composeGenomicStudyAnalysisComponent(Turtle.Complex parent, String parentType, String name, GenomicStudy.GenomicStudyAnalysisComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "analysis", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "GenomicStudyAnalysisComponent", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMethodType().size(); ++i2) {
            this.composeCodeableConcept(t, "GenomicStudyAnalysisComponent", "methodType", element.getMethodType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getChangeType().size(); ++i2) {
            this.composeCodeableConcept(t, "GenomicStudyAnalysisComponent", "changeType", element.getChangeType().get(i2), i2);
        }
        if (element.hasGenomeBuild()) {
            this.composeCodeableConcept(t, "GenomicStudyAnalysisComponent", "genomeBuild", element.getGenomeBuild(), -1);
        }
        if (element.hasInstantiatesCanonicalElement()) {
            this.composeCanonical(t, "GenomicStudyAnalysisComponent", "instantiatesCanonical", element.getInstantiatesCanonicalElement(), -1);
        }
        if (element.hasInstantiatesUriElement()) {
            this.composeUri(t, "GenomicStudyAnalysisComponent", "instantiatesUri", element.getInstantiatesUriElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "GenomicStudyAnalysisComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "GenomicStudyAnalysisComponent", "subject", element.getSubject(), -1);
        }
        for (i2 = 0; i2 < element.getSpecimen().size(); ++i2) {
            this.composeReference(t, "GenomicStudyAnalysisComponent", "specimen", element.getSpecimen().get(i2), i2);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "GenomicStudyAnalysisComponent", "date", element.getDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "GenomicStudyAnalysisComponent", "note", element.getNote().get(i2), i2);
        }
        if (element.hasProtocolPerformed()) {
            this.composeReference(t, "GenomicStudyAnalysisComponent", "protocolPerformed", element.getProtocolPerformed(), -1);
        }
        for (i2 = 0; i2 < element.getRegionsStudied().size(); ++i2) {
            this.composeReference(t, "GenomicStudyAnalysisComponent", "regionsStudied", element.getRegionsStudied().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRegionsCalled().size(); ++i2) {
            this.composeReference(t, "GenomicStudyAnalysisComponent", "regionsCalled", element.getRegionsCalled().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInput().size(); ++i2) {
            this.composeGenomicStudyAnalysisInputComponent(t, "GenomicStudyAnalysisComponent", "input", element.getInput().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getOutput().size(); ++i2) {
            this.composeGenomicStudyAnalysisOutputComponent(t, "GenomicStudyAnalysisComponent", "output", element.getOutput().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeGenomicStudyAnalysisPerformerComponent(t, "GenomicStudyAnalysisComponent", "performer", element.getPerformer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDevice().size(); ++i2) {
            this.composeGenomicStudyAnalysisDeviceComponent(t, "GenomicStudyAnalysisComponent", "device", element.getDevice().get(i2), i2);
        }
    }

    protected void composeGenomicStudyAnalysisInputComponent(Turtle.Complex parent, String parentType, String name, GenomicStudy.GenomicStudyAnalysisInputComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "input", name, element, index);
        if (element.hasFile()) {
            this.composeReference(t, "GenomicStudyAnalysisInputComponent", "file", element.getFile(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "GenomicStudyAnalysisInputComponent", "type", element.getType(), -1);
        }
        if (element.hasGeneratedBy()) {
            this.composeType(t, "GenomicStudyAnalysisInputComponent", "generatedBy", element.getGeneratedBy(), -1);
        }
    }

    protected void composeGenomicStudyAnalysisOutputComponent(Turtle.Complex parent, String parentType, String name, GenomicStudy.GenomicStudyAnalysisOutputComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "output", name, element, index);
        if (element.hasFile()) {
            this.composeReference(t, "GenomicStudyAnalysisOutputComponent", "file", element.getFile(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "GenomicStudyAnalysisOutputComponent", "type", element.getType(), -1);
        }
    }

    protected void composeGenomicStudyAnalysisPerformerComponent(Turtle.Complex parent, String parentType, String name, GenomicStudy.GenomicStudyAnalysisPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasActor()) {
            this.composeReference(t, "GenomicStudyAnalysisPerformerComponent", "actor", element.getActor(), -1);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "GenomicStudyAnalysisPerformerComponent", "role", element.getRole(), -1);
        }
    }

    protected void composeGenomicStudyAnalysisDeviceComponent(Turtle.Complex parent, String parentType, String name, GenomicStudy.GenomicStudyAnalysisDeviceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "device", name, element, index);
        if (element.hasDevice()) {
            this.composeReference(t, "GenomicStudyAnalysisDeviceComponent", "device", element.getDevice(), -1);
        }
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "GenomicStudyAnalysisDeviceComponent", "function", element.getFunction(), -1);
        }
    }

    protected void composeGoal(Turtle.Complex parent, String parentType, String name, Goal element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Goal", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Goal", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasLifecycleStatusElement()) {
            this.composeEnum(t, "Goal", "lifecycleStatus", element.getLifecycleStatusElement(), -1);
        }
        if (element.hasAchievementStatus()) {
            this.composeCodeableConcept(t, "Goal", "achievementStatus", element.getAchievementStatus(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "Goal", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasContinuousElement()) {
            this.composeBoolean(t, "Goal", "continuous", element.getContinuousElement(), -1);
        }
        if (element.hasPriority()) {
            this.composeCodeableConcept(t, "Goal", "priority", element.getPriority(), -1);
        }
        if (element.hasDescription()) {
            this.composeCodeableConcept(t, "Goal", "description", element.getDescription(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Goal", "subject", element.getSubject(), -1);
        }
        if (element.hasStart()) {
            this.composeType(t, "Goal", "start", element.getStart(), -1);
        }
        for (i2 = 0; i2 < element.getTarget().size(); ++i2) {
            this.composeGoalTargetComponent(t, "Goal", "target", element.getTarget().get(i2), i2);
        }
        if (element.hasStatusDateElement()) {
            this.composeDate(t, "Goal", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasStatusReasonElement()) {
            this.composeString(t, "Goal", "statusReason", element.getStatusReasonElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "Goal", "source", element.getSource(), -1);
        }
        for (i2 = 0; i2 < element.getAddresses().size(); ++i2) {
            this.composeReference(t, "Goal", "addresses", element.getAddresses().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Goal", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getOutcome().size(); ++i2) {
            this.composeCodeableReference(t, "Goal", "outcome", element.getOutcome().get(i2), i2);
        }
    }

    protected void composeGoalTargetComponent(Turtle.Complex parent, String parentType, String name, Goal.GoalTargetComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "target", name, element, index);
        if (element.hasMeasure()) {
            this.composeCodeableConcept(t, "GoalTargetComponent", "measure", element.getMeasure(), -1);
        }
        if (element.hasDetail()) {
            this.composeType(t, "GoalTargetComponent", "detail", element.getDetail(), -1);
        }
        if (element.hasDue()) {
            this.composeType(t, "GoalTargetComponent", "due", element.getDue(), -1);
        }
    }

    protected void composeGraphDefinition(Turtle.Complex parent, String parentType, String name, GraphDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeCanonicalResource(t, "GraphDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "GraphDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "GraphDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasVersionAlgorithm()) {
            this.composeType(t, "GraphDefinition", "versionAlgorithm", element.getVersionAlgorithm(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "GraphDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "GraphDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "GraphDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "GraphDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "GraphDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "GraphDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "GraphDefinition", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "GraphDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "GraphDefinition", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "GraphDefinition", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "GraphDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasStartElement()) {
            this.composeId(t, "GraphDefinition", "start", element.getStartElement(), -1);
        }
        for (i2 = 0; i2 < element.getNode().size(); ++i2) {
            this.composeGraphDefinitionNodeComponent(t, "GraphDefinition", "node", element.getNode().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getLink().size(); ++i2) {
            this.composeGraphDefinitionLinkComponent(t, "GraphDefinition", "link", element.getLink().get(i2), i2);
        }
    }

    protected void composeGraphDefinitionNodeComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionNodeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "node", name, element, index);
        if (element.hasNodeIdElement()) {
            this.composeId(t, "GraphDefinitionNodeComponent", "nodeId", element.getNodeIdElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GraphDefinitionNodeComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "GraphDefinitionNodeComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "GraphDefinitionNodeComponent", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeGraphDefinitionLinkComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GraphDefinitionLinkComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "GraphDefinitionLinkComponent", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "GraphDefinitionLinkComponent", "max", element.getMaxElement(), -1);
        }
        if (element.hasSourceIdElement()) {
            this.composeId(t, "GraphDefinitionLinkComponent", "sourceId", element.getSourceIdElement(), -1);
        }
        if (element.hasPathElement()) {
            this.composeString(t, "GraphDefinitionLinkComponent", "path", element.getPathElement(), -1);
        }
        if (element.hasSliceNameElement()) {
            this.composeString(t, "GraphDefinitionLinkComponent", "sliceName", element.getSliceNameElement(), -1);
        }
        if (element.hasTargetIdElement()) {
            this.composeId(t, "GraphDefinitionLinkComponent", "targetId", element.getTargetIdElement(), -1);
        }
        if (element.hasParamsElement()) {
            this.composeString(t, "GraphDefinitionLinkComponent", "params", element.getParamsElement(), -1);
        }
        for (int i2 = 0; i2 < element.getCompartment().size(); ++i2) {
            this.composeGraphDefinitionLinkCompartmentComponent(t, "GraphDefinitionLinkComponent", "compartment", element.getCompartment().get(i2), i2);
        }
    }

    protected void composeGraphDefinitionLinkCompartmentComponent(Turtle.Complex parent, String parentType, String name, GraphDefinition.GraphDefinitionLinkCompartmentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "compartment", name, element, index);
        if (element.hasUseElement()) {
            this.composeEnum(t, "GraphDefinitionLinkCompartmentComponent", "use", element.getUseElement(), -1);
        }
        if (element.hasRuleElement()) {
            this.composeEnum(t, "GraphDefinitionLinkCompartmentComponent", "rule", element.getRuleElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "GraphDefinitionLinkCompartmentComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasExpressionElement()) {
            this.composeString(t, "GraphDefinitionLinkCompartmentComponent", "expression", element.getExpressionElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "GraphDefinitionLinkCompartmentComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeGroup(Turtle.Complex parent, String parentType, String name, Group element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Group", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Group", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Group", "active", element.getActiveElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "Group", "type", element.getTypeElement(), -1);
        }
        if (element.hasMembershipElement()) {
            this.composeEnum(t, "Group", "membership", element.getMembershipElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Group", "code", element.getCode(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Group", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Group", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasQuantityElement()) {
            this.composeUnsignedInt(t, "Group", "quantity", element.getQuantityElement(), -1);
        }
        if (element.hasManagingEntity()) {
            this.composeReference(t, "Group", "managingEntity", element.getManagingEntity(), -1);
        }
        for (i2 = 0; i2 < element.getCharacteristic().size(); ++i2) {
            this.composeGroupCharacteristicComponent(t, "Group", "characteristic", element.getCharacteristic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMember().size(); ++i2) {
            this.composeGroupMemberComponent(t, "Group", "member", element.getMember().get(i2), i2);
        }
    }

    protected void composeGroupCharacteristicComponent(Turtle.Complex parent, String parentType, String name, Group.GroupCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "GroupCharacteristicComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "GroupCharacteristicComponent", "value", element.getValue(), -1);
        }
        if (element.hasExcludeElement()) {
            this.composeBoolean(t, "GroupCharacteristicComponent", "exclude", element.getExcludeElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "GroupCharacteristicComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeGroupMemberComponent(Turtle.Complex parent, String parentType, String name, Group.GroupMemberComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "member", name, element, index);
        if (element.hasEntity()) {
            this.composeReference(t, "GroupMemberComponent", "entity", element.getEntity(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "GroupMemberComponent", "period", element.getPeriod(), -1);
        }
        if (element.hasInactiveElement()) {
            this.composeBoolean(t, "GroupMemberComponent", "inactive", element.getInactiveElement(), -1);
        }
    }

    protected void composeGuidanceResponse(Turtle.Complex parent, String parentType, String name, GuidanceResponse element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "GuidanceResponse", name, element, index);
        if (element.hasRequestIdentifier()) {
            this.composeIdentifier(t, "GuidanceResponse", "requestIdentifier", element.getRequestIdentifier(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "GuidanceResponse", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasModule()) {
            this.composeType(t, "GuidanceResponse", "module", element.getModule(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "GuidanceResponse", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "GuidanceResponse", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "GuidanceResponse", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrenceDateTimeElement()) {
            this.composeDateTime(t, "GuidanceResponse", "occurrenceDateTime", element.getOccurrenceDateTimeElement(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "GuidanceResponse", "performer", element.getPerformer(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "GuidanceResponse", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "GuidanceResponse", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEvaluationMessage().size(); ++i2) {
            this.composeReference(t, "GuidanceResponse", "evaluationMessage", element.getEvaluationMessage().get(i2), i2);
        }
        if (element.hasOutputParameters()) {
            this.composeReference(t, "GuidanceResponse", "outputParameters", element.getOutputParameters(), -1);
        }
        if (element.hasResult()) {
            this.composeReference(t, "GuidanceResponse", "result", element.getResult(), -1);
        }
        for (i2 = 0; i2 < element.getDataRequirement().size(); ++i2) {
            this.composeDataRequirement(t, "GuidanceResponse", "dataRequirement", element.getDataRequirement().get(i2), i2);
        }
    }

    protected void composeHealthcareService(Turtle.Complex parent, String parentType, String name, HealthcareService element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "HealthcareService", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "HealthcareService", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "HealthcareService", "active", element.getActiveElement(), -1);
        }
        if (element.hasProvidedBy()) {
            this.composeReference(t, "HealthcareService", "providedBy", element.getProvidedBy(), -1);
        }
        for (i2 = 0; i2 < element.getOfferedIn().size(); ++i2) {
            this.composeReference(t, "HealthcareService", "offeredIn", element.getOfferedIn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "HealthcareService", "category", element.getCategory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "HealthcareService", "type", element.getType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSpecialty().size(); ++i2) {
            this.composeCodeableConcept(t, "HealthcareService", "specialty", element.getSpecialty().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getLocation().size(); ++i2) {
            this.composeReference(t, "HealthcareService", "location", element.getLocation().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "HealthcareService", "name", element.getNameElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "HealthcareService", "comment", element.getCommentElement(), -1);
        }
        if (element.hasExtraDetailsElement()) {
            this.composeMarkdown(t, "HealthcareService", "extraDetails", element.getExtraDetailsElement(), -1);
        }
        if (element.hasPhoto()) {
            this.composeAttachment(t, "HealthcareService", "photo", element.getPhoto(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeExtendedContactDetail(t, "HealthcareService", "contact", element.getContact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCoverageArea().size(); ++i2) {
            this.composeReference(t, "HealthcareService", "coverageArea", element.getCoverageArea().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getServiceProvisionCode().size(); ++i2) {
            this.composeCodeableConcept(t, "HealthcareService", "serviceProvisionCode", element.getServiceProvisionCode().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEligibility().size(); ++i2) {
            this.composeHealthcareServiceEligibilityComponent(t, "HealthcareService", "eligibility", element.getEligibility().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgram().size(); ++i2) {
            this.composeCodeableConcept(t, "HealthcareService", "program", element.getProgram().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCharacteristic().size(); ++i2) {
            this.composeCodeableConcept(t, "HealthcareService", "characteristic", element.getCharacteristic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCommunication().size(); ++i2) {
            this.composeCodeableConcept(t, "HealthcareService", "communication", element.getCommunication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReferralMethod().size(); ++i2) {
            this.composeCodeableConcept(t, "HealthcareService", "referralMethod", element.getReferralMethod().get(i2), i2);
        }
        if (element.hasAppointmentRequiredElement()) {
            this.composeBoolean(t, "HealthcareService", "appointmentRequired", element.getAppointmentRequiredElement(), -1);
        }
        for (i2 = 0; i2 < element.getAvailability().size(); ++i2) {
            this.composeAvailability(t, "HealthcareService", "availability", element.getAvailability().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndpoint().size(); ++i2) {
            this.composeReference(t, "HealthcareService", "endpoint", element.getEndpoint().get(i2), i2);
        }
    }

    protected void composeHealthcareServiceEligibilityComponent(Turtle.Complex parent, String parentType, String name, HealthcareService.HealthcareServiceEligibilityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "eligibility", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "HealthcareServiceEligibilityComponent", "code", element.getCode(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "HealthcareServiceEligibilityComponent", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeImagingSelection(Turtle.Complex parent, String parentType, String name, ImagingSelection element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImagingSelection", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ImagingSelection", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImagingSelection", "status", element.getStatusElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ImagingSelection", "subject", element.getSubject(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "ImagingSelection", "issued", element.getIssuedElement(), -1);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeImagingSelectionPerformerComponent(t, "ImagingSelection", "performer", element.getPerformer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "ImagingSelection", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "ImagingSelection", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ImagingSelection", "code", element.getCode(), -1);
        }
        if (element.hasStudyUidElement()) {
            this.composeId(t, "ImagingSelection", "studyUid", element.getStudyUidElement(), -1);
        }
        for (i2 = 0; i2 < element.getDerivedFrom().size(); ++i2) {
            this.composeReference(t, "ImagingSelection", "derivedFrom", element.getDerivedFrom().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndpoint().size(); ++i2) {
            this.composeReference(t, "ImagingSelection", "endpoint", element.getEndpoint().get(i2), i2);
        }
        if (element.hasSeriesUidElement()) {
            this.composeId(t, "ImagingSelection", "seriesUid", element.getSeriesUidElement(), -1);
        }
        if (element.hasSeriesNumberElement()) {
            this.composeUnsignedInt(t, "ImagingSelection", "seriesNumber", element.getSeriesNumberElement(), -1);
        }
        if (element.hasFrameOfReferenceUidElement()) {
            this.composeId(t, "ImagingSelection", "frameOfReferenceUid", element.getFrameOfReferenceUidElement(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableReference(t, "ImagingSelection", "bodySite", element.getBodySite(), -1);
        }
        for (i2 = 0; i2 < element.getFocus().size(); ++i2) {
            this.composeReference(t, "ImagingSelection", "focus", element.getFocus().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstance().size(); ++i2) {
            this.composeImagingSelectionInstanceComponent(t, "ImagingSelection", "instance", element.getInstance().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getImageRegion().size(); ++i2) {
            this.composeImagingSelectionImageRegion3DComponent(t, "ImagingSelection", "imageRegion", element.getImageRegion().get(i2), i2);
        }
    }

    protected void composeImagingSelectionPerformerComponent(Turtle.Complex parent, String parentType, String name, ImagingSelection.ImagingSelectionPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ImagingSelectionPerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ImagingSelectionPerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeImagingSelectionInstanceComponent(Turtle.Complex parent, String parentType, String name, ImagingSelection.ImagingSelectionInstanceComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasUidElement()) {
            this.composeId(t, "ImagingSelectionInstanceComponent", "uid", element.getUidElement(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingSelectionInstanceComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasSopClass()) {
            this.composeCoding(t, "ImagingSelectionInstanceComponent", "sopClass", element.getSopClass(), -1);
        }
        for (i2 = 0; i2 < element.getSubset().size(); ++i2) {
            this.composeString(t, "ImagingSelectionInstanceComponent", "subset", element.getSubset().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getImageRegion().size(); ++i2) {
            this.composeImagingSelectionImageRegion2DComponent(t, "ImagingSelectionInstanceComponent", "imageRegion", element.getImageRegion().get(i2), i2);
        }
    }

    protected void composeImagingSelectionImageRegion2DComponent(Turtle.Complex parent, String parentType, String name, ImagingSelection.ImageRegion2DComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "imageRegion", name, element, index);
        if (element.hasRegionTypeElement()) {
            this.composeEnum(t, "ImageRegion2DComponent", "regionType", element.getRegionTypeElement(), -1);
        }
        for (int i2 = 0; i2 < element.getCoordinate().size(); ++i2) {
            this.composeDecimal(t, "ImageRegion2DComponent", "coordinate", element.getCoordinate().get(i2), i2);
        }
    }

    protected void composeImagingSelectionImageRegion3DComponent(Turtle.Complex parent, String parentType, String name, ImagingSelection.ImageRegion3DComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "imageRegion", name, element, index);
        if (element.hasRegionTypeElement()) {
            this.composeEnum(t, "ImageRegion3DComponent", "regionType", element.getRegionTypeElement(), -1);
        }
        for (int i2 = 0; i2 < element.getCoordinate().size(); ++i2) {
            this.composeDecimal(t, "ImageRegion3DComponent", "coordinate", element.getCoordinate().get(i2), i2);
        }
    }

    protected void composeImagingStudy(Turtle.Complex parent, String parentType, String name, ImagingStudy element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImagingStudy", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ImagingStudy", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImagingStudy", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getModality().size(); ++i2) {
            this.composeCodeableConcept(t, "ImagingStudy", "modality", element.getModality().get(i2), i2);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ImagingStudy", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ImagingStudy", "encounter", element.getEncounter(), -1);
        }
        if (element.hasStartedElement()) {
            this.composeDateTime(t, "ImagingStudy", "started", element.getStartedElement(), -1);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "ImagingStudy", "basedOn", element.getBasedOn().get(i2), i2);
        }
        if (element.hasReferrer()) {
            this.composeReference(t, "ImagingStudy", "referrer", element.getReferrer(), -1);
        }
        for (i2 = 0; i2 < element.getInterpreter().size(); ++i2) {
            this.composeReference(t, "ImagingStudy", "interpreter", element.getInterpreter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndpoint().size(); ++i2) {
            this.composeReference(t, "ImagingStudy", "endpoint", element.getEndpoint().get(i2), i2);
        }
        if (element.hasNumberOfSeriesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfSeries", element.getNumberOfSeriesElement(), -1);
        }
        if (element.hasNumberOfInstancesElement()) {
            this.composeUnsignedInt(t, "ImagingStudy", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
        }
        for (i2 = 0; i2 < element.getProcedure().size(); ++i2) {
            this.composeCodeableReference(t, "ImagingStudy", "procedure", element.getProcedure().get(i2), i2);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "ImagingStudy", "location", element.getLocation(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "ImagingStudy", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "ImagingStudy", "note", element.getNote().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingStudy", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getSeries().size(); ++i2) {
            this.composeImagingStudySeriesComponent(t, "ImagingStudy", "series", element.getSeries().get(i2), i2);
        }
    }

    protected void composeImagingStudySeriesComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "series", name, element, index);
        if (element.hasUidElement()) {
            this.composeId(t, "ImagingStudySeriesComponent", "uid", element.getUidElement(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingStudySeriesComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasModality()) {
            this.composeCodeableConcept(t, "ImagingStudySeriesComponent", "modality", element.getModality(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImagingStudySeriesComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasNumberOfInstancesElement()) {
            this.composeUnsignedInt(t, "ImagingStudySeriesComponent", "numberOfInstances", element.getNumberOfInstancesElement(), -1);
        }
        for (i2 = 0; i2 < element.getEndpoint().size(); ++i2) {
            this.composeReference(t, "ImagingStudySeriesComponent", "endpoint", element.getEndpoint().get(i2), i2);
        }
        if (element.hasBodySite()) {
            this.composeCodeableReference(t, "ImagingStudySeriesComponent", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasLaterality()) {
            this.composeCodeableConcept(t, "ImagingStudySeriesComponent", "laterality", element.getLaterality(), -1);
        }
        for (i2 = 0; i2 < element.getSpecimen().size(); ++i2) {
            this.composeReference(t, "ImagingStudySeriesComponent", "specimen", element.getSpecimen().get(i2), i2);
        }
        if (element.hasStartedElement()) {
            this.composeDateTime(t, "ImagingStudySeriesComponent", "started", element.getStartedElement(), -1);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeImagingStudySeriesPerformerComponent(t, "ImagingStudySeriesComponent", "performer", element.getPerformer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstance().size(); ++i2) {
            this.composeImagingStudySeriesInstanceComponent(t, "ImagingStudySeriesComponent", "instance", element.getInstance().get(i2), i2);
        }
    }

    protected void composeImagingStudySeriesPerformerComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ImagingStudySeriesPerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ImagingStudySeriesPerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeImagingStudySeriesInstanceComponent(Turtle.Complex parent, String parentType, String name, ImagingStudy.ImagingStudySeriesInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasUidElement()) {
            this.composeId(t, "ImagingStudySeriesInstanceComponent", "uid", element.getUidElement(), -1);
        }
        if (element.hasSopClass()) {
            this.composeCoding(t, "ImagingStudySeriesInstanceComponent", "sopClass", element.getSopClass(), -1);
        }
        if (element.hasNumberElement()) {
            this.composeUnsignedInt(t, "ImagingStudySeriesInstanceComponent", "number", element.getNumberElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImagingStudySeriesInstanceComponent", "title", element.getTitleElement(), -1);
        }
    }

    protected void composeImmunization(Turtle.Complex parent, String parentType, String name, Immunization element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Immunization", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Immunization", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "Immunization", "basedOn", element.getBasedOn().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Immunization", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "Immunization", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasVaccineCode()) {
            this.composeCodeableConcept(t, "Immunization", "vaccineCode", element.getVaccineCode(), -1);
        }
        if (element.hasAdministeredProduct()) {
            this.composeCodeableReference(t, "Immunization", "administeredProduct", element.getAdministeredProduct(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeCodeableReference(t, "Immunization", "manufacturer", element.getManufacturer(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "Immunization", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDate(t, "Immunization", "expirationDate", element.getExpirationDateElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "Immunization", "patient", element.getPatient(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Immunization", "encounter", element.getEncounter(), -1);
        }
        for (i2 = 0; i2 < element.getSupportingInformation().size(); ++i2) {
            this.composeReference(t, "Immunization", "supportingInformation", element.getSupportingInformation().get(i2), i2);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "Immunization", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasPrimarySourceElement()) {
            this.composeBoolean(t, "Immunization", "primarySource", element.getPrimarySourceElement(), -1);
        }
        if (element.hasInformationSource()) {
            this.composeCodeableReference(t, "Immunization", "informationSource", element.getInformationSource(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "Immunization", "location", element.getLocation(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "Immunization", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "Immunization", "route", element.getRoute(), -1);
        }
        if (element.hasDoseQuantity()) {
            this.composeQuantity(t, "Immunization", "doseQuantity", element.getDoseQuantity(), -1);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeImmunizationPerformerComponent(t, "Immunization", "performer", element.getPerformer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Immunization", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "Immunization", "reason", element.getReason().get(i2), i2);
        }
        if (element.hasIsSubpotentElement()) {
            this.composeBoolean(t, "Immunization", "isSubpotent", element.getIsSubpotentElement(), -1);
        }
        for (i2 = 0; i2 < element.getSubpotentReason().size(); ++i2) {
            this.composeCodeableConcept(t, "Immunization", "subpotentReason", element.getSubpotentReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProgramEligibility().size(); ++i2) {
            this.composeImmunizationProgramEligibilityComponent(t, "Immunization", "programEligibility", element.getProgramEligibility().get(i2), i2);
        }
        if (element.hasFundingSource()) {
            this.composeCodeableConcept(t, "Immunization", "fundingSource", element.getFundingSource(), -1);
        }
        for (i2 = 0; i2 < element.getReaction().size(); ++i2) {
            this.composeImmunizationReactionComponent(t, "Immunization", "reaction", element.getReaction().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProtocolApplied().size(); ++i2) {
            this.composeImmunizationProtocolAppliedComponent(t, "Immunization", "protocolApplied", element.getProtocolApplied().get(i2), i2);
        }
    }

    protected void composeImmunizationPerformerComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "ImmunizationPerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "ImmunizationPerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeImmunizationProgramEligibilityComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationProgramEligibilityComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "programEligibility", name, element, index);
        if (element.hasProgram()) {
            this.composeCodeableConcept(t, "ImmunizationProgramEligibilityComponent", "program", element.getProgram(), -1);
        }
        if (element.hasProgramStatus()) {
            this.composeCodeableConcept(t, "ImmunizationProgramEligibilityComponent", "programStatus", element.getProgramStatus(), -1);
        }
    }

    protected void composeImmunizationReactionComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationReactionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "reaction", name, element, index);
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationReactionComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasManifestation()) {
            this.composeCodeableReference(t, "ImmunizationReactionComponent", "manifestation", element.getManifestation(), -1);
        }
        if (element.hasReportedElement()) {
            this.composeBoolean(t, "ImmunizationReactionComponent", "reported", element.getReportedElement(), -1);
        }
    }

    protected void composeImmunizationProtocolAppliedComponent(Turtle.Complex parent, String parentType, String name, Immunization.ImmunizationProtocolAppliedComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "protocolApplied", name, element, index);
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationProtocolAppliedComponent", "series", element.getSeriesElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationProtocolAppliedComponent", "authority", element.getAuthority(), -1);
        }
        for (int i2 = 0; i2 < element.getTargetDisease().size(); ++i2) {
            this.composeCodeableConcept(t, "ImmunizationProtocolAppliedComponent", "targetDisease", element.getTargetDisease().get(i2), i2);
        }
        if (element.hasDoseNumberElement()) {
            this.composeString(t, "ImmunizationProtocolAppliedComponent", "doseNumber", element.getDoseNumberElement(), -1);
        }
        if (element.hasSeriesDosesElement()) {
            this.composeString(t, "ImmunizationProtocolAppliedComponent", "seriesDoses", element.getSeriesDosesElement(), -1);
        }
    }

    protected void composeImmunizationEvaluation(Turtle.Complex parent, String parentType, String name, ImmunizationEvaluation element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImmunizationEvaluation", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ImmunizationEvaluation", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImmunizationEvaluation", "status", element.getStatusElement(), -1);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImmunizationEvaluation", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationEvaluation", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationEvaluation", "authority", element.getAuthority(), -1);
        }
        if (element.hasTargetDisease()) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "targetDisease", element.getTargetDisease(), -1);
        }
        if (element.hasImmunizationEvent()) {
            this.composeReference(t, "ImmunizationEvaluation", "immunizationEvent", element.getImmunizationEvent(), -1);
        }
        if (element.hasDoseStatus()) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatus", element.getDoseStatus(), -1);
        }
        for (i2 = 0; i2 < element.getDoseStatusReason().size(); ++i2) {
            this.composeCodeableConcept(t, "ImmunizationEvaluation", "doseStatusReason", element.getDoseStatusReason().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImmunizationEvaluation", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationEvaluation", "series", element.getSeriesElement(), -1);
        }
        if (element.hasDoseNumberElement()) {
            this.composeString(t, "ImmunizationEvaluation", "doseNumber", element.getDoseNumberElement(), -1);
        }
        if (element.hasSeriesDosesElement()) {
            this.composeString(t, "ImmunizationEvaluation", "seriesDoses", element.getSeriesDosesElement(), -1);
        }
    }

    protected void composeImmunizationRecommendation(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ImmunizationRecommendation", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ImmunizationRecommendation", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasPatient()) {
            this.composeReference(t, "ImmunizationRecommendation", "patient", element.getPatient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImmunizationRecommendation", "date", element.getDateElement(), -1);
        }
        if (element.hasAuthority()) {
            this.composeReference(t, "ImmunizationRecommendation", "authority", element.getAuthority(), -1);
        }
        for (i2 = 0; i2 < element.getRecommendation().size(); ++i2) {
            this.composeImmunizationRecommendationRecommendationComponent(t, "ImmunizationRecommendation", "recommendation", element.getRecommendation().get(i2), i2);
        }
    }

    protected void composeImmunizationRecommendationRecommendationComponent(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "recommendation", name, element, index);
        for (i2 = 0; i2 < element.getVaccineCode().size(); ++i2) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "vaccineCode", element.getVaccineCode().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTargetDisease().size(); ++i2) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "targetDisease", element.getTargetDisease().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContraindicatedVaccineCode().size(); ++i2) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "contraindicatedVaccineCode", element.getContraindicatedVaccineCode().get(i2), i2);
        }
        if (element.hasForecastStatus()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "forecastStatus", element.getForecastStatus(), -1);
        }
        for (i2 = 0; i2 < element.getForecastReason().size(); ++i2) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationComponent", "forecastReason", element.getForecastReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDateCriterion().size(); ++i2) {
            this.composeImmunizationRecommendationRecommendationDateCriterionComponent(t, "ImmunizationRecommendationRecommendationComponent", "dateCriterion", element.getDateCriterion().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "ImmunizationRecommendationRecommendationComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasSeriesElement()) {
            this.composeString(t, "ImmunizationRecommendationRecommendationComponent", "series", element.getSeriesElement(), -1);
        }
        if (element.hasDoseNumberElement()) {
            this.composeString(t, "ImmunizationRecommendationRecommendationComponent", "doseNumber", element.getDoseNumberElement(), -1);
        }
        if (element.hasSeriesDosesElement()) {
            this.composeString(t, "ImmunizationRecommendationRecommendationComponent", "seriesDoses", element.getSeriesDosesElement(), -1);
        }
        for (i2 = 0; i2 < element.getSupportingImmunization().size(); ++i2) {
            this.composeReference(t, "ImmunizationRecommendationRecommendationComponent", "supportingImmunization", element.getSupportingImmunization().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupportingPatientInformation().size(); ++i2) {
            this.composeReference(t, "ImmunizationRecommendationRecommendationComponent", "supportingPatientInformation", element.getSupportingPatientInformation().get(i2), i2);
        }
    }

    protected void composeImmunizationRecommendationRecommendationDateCriterionComponent(Turtle.Complex parent, String parentType, String name, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dateCriterion", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ImmunizationRecommendationRecommendationDateCriterionComponent", "code", element.getCode(), -1);
        }
        if (element.hasValueElement()) {
            this.composeDateTime(t, "ImmunizationRecommendationRecommendationDateCriterionComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeImplementationGuide(Turtle.Complex parent, String parentType, String name, ImplementationGuide element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeCanonicalResource(t, "ImplementationGuide", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ImplementationGuide", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ImplementationGuide", "version", element.getVersionElement(), -1);
        }
        if (element.hasVersionAlgorithm()) {
            this.composeType(t, "ImplementationGuide", "versionAlgorithm", element.getVersionAlgorithm(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuide", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImplementationGuide", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ImplementationGuide", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ImplementationGuide", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ImplementationGuide", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ImplementationGuide", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "ImplementationGuide", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ImplementationGuide", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "ImplementationGuide", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "ImplementationGuide", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ImplementationGuide", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasCopyrightLabelElement()) {
            this.composeString(t, "ImplementationGuide", "copyrightLabel", element.getCopyrightLabelElement(), -1);
        }
        if (element.hasPackageIdElement()) {
            this.composeId(t, "ImplementationGuide", "packageId", element.getPackageIdElement(), -1);
        }
        if (element.hasLicenseElement()) {
            this.composeEnum(t, "ImplementationGuide", "license", element.getLicenseElement(), -1);
        }
        for (i2 = 0; i2 < element.getFhirVersion().size(); ++i2) {
            this.composeEnum(t, "ImplementationGuide", "fhirVersion", element.getFhirVersion().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDependsOn().size(); ++i2) {
            this.composeImplementationGuideDependsOnComponent(t, "ImplementationGuide", "dependsOn", element.getDependsOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getGlobal().size(); ++i2) {
            this.composeImplementationGuideGlobalComponent(t, "ImplementationGuide", "global", element.getGlobal().get(i2), i2);
        }
        if (element.hasDefinition()) {
            this.composeImplementationGuideDefinitionComponent(t, "ImplementationGuide", "definition", element.getDefinition(), -1);
        }
        if (element.hasManifest()) {
            this.composeImplementationGuideManifestComponent(t, "ImplementationGuide", "manifest", element.getManifest(), -1);
        }
    }

    protected void composeImplementationGuideDependsOnComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDependsOnComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dependsOn", name, element, index);
        if (element.hasUriElement()) {
            this.composeCanonical(t, "ImplementationGuideDependsOnComponent", "uri", element.getUriElement(), -1);
        }
        if (element.hasPackageIdElement()) {
            this.composeId(t, "ImplementationGuideDependsOnComponent", "packageId", element.getPackageIdElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ImplementationGuideDependsOnComponent", "version", element.getVersionElement(), -1);
        }
        if (element.hasReasonElement()) {
            this.composeMarkdown(t, "ImplementationGuideDependsOnComponent", "reason", element.getReasonElement(), -1);
        }
    }

    protected void composeImplementationGuideGlobalComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideGlobalComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "global", name, element, index);
        if (element.hasTypeElement()) {
            this.composeCode(t, "ImplementationGuideGlobalComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "ImplementationGuideGlobalComponent", "profile", element.getProfileElement(), -1);
        }
    }

    protected void composeImplementationGuideDefinitionComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "definition", name, element, index);
        for (i2 = 0; i2 < element.getGrouping().size(); ++i2) {
            this.composeImplementationGuideDefinitionGroupingComponent(t, "ImplementationGuideDefinitionComponent", "grouping", element.getGrouping().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getResource().size(); ++i2) {
            this.composeImplementationGuideDefinitionResourceComponent(t, "ImplementationGuideDefinitionComponent", "resource", element.getResource().get(i2), i2);
        }
        if (element.hasPage()) {
            this.composeImplementationGuideDefinitionPageComponent(t, "ImplementationGuideDefinitionComponent", "page", element.getPage(), -1);
        }
        for (i2 = 0; i2 < element.getParameter().size(); ++i2) {
            this.composeImplementationGuideDefinitionParameterComponent(t, "ImplementationGuideDefinitionComponent", "parameter", element.getParameter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTemplate().size(); ++i2) {
            this.composeImplementationGuideDefinitionTemplateComponent(t, "ImplementationGuideDefinitionComponent", "template", element.getTemplate().get(i2), i2);
        }
    }

    protected void composeImplementationGuideDefinitionGroupingComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "grouping", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuideDefinitionGroupingComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ImplementationGuideDefinitionGroupingComponent", "description", element.getDescriptionElement(), -1);
        }
    }

    protected void composeImplementationGuideDefinitionResourceComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionResourceComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "ImplementationGuideDefinitionResourceComponent", "reference", element.getReference(), -1);
        }
        for (i2 = 0; i2 < element.getFhirVersion().size(); ++i2) {
            this.composeEnum(t, "ImplementationGuideDefinitionResourceComponent", "fhirVersion", element.getFhirVersion().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ImplementationGuideDefinitionResourceComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ImplementationGuideDefinitionResourceComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasIsExampleElement()) {
            this.composeBoolean(t, "ImplementationGuideDefinitionResourceComponent", "isExample", element.getIsExampleElement(), -1);
        }
        for (i2 = 0; i2 < element.getProfile().size(); ++i2) {
            this.composeCanonical(t, "ImplementationGuideDefinitionResourceComponent", "profile", element.getProfile().get(i2), i2);
        }
        if (element.hasGroupingIdElement()) {
            this.composeId(t, "ImplementationGuideDefinitionResourceComponent", "groupingId", element.getGroupingIdElement(), -1);
        }
    }

    protected void composeImplementationGuideDefinitionPageComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionPageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "page", name, element, index);
        if (element.hasSource()) {
            this.composeType(t, "ImplementationGuideDefinitionPageComponent", "source", element.getSource(), -1);
        }
        if (element.hasNameElement()) {
            this.composeUrl(t, "ImplementationGuideDefinitionPageComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ImplementationGuideDefinitionPageComponent", "title", element.getTitleElement(), -1);
        }
        if (element.hasGenerationElement()) {
            this.composeEnum(t, "ImplementationGuideDefinitionPageComponent", "generation", element.getGenerationElement(), -1);
        }
        for (int i2 = 0; i2 < element.getPage().size(); ++i2) {
            this.composeImplementationGuideDefinitionPageComponent(t, "ImplementationGuideDefinitionPageComponent", "page", element.getPage().get(i2), i2);
        }
    }

    protected void composeImplementationGuideDefinitionParameterComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasCode()) {
            this.composeCoding(t, "ImplementationGuideDefinitionParameterComponent", "code", element.getCode(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "ImplementationGuideDefinitionParameterComponent", "value", element.getValueElement(), -1);
        }
    }

    protected void composeImplementationGuideDefinitionTemplateComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "template", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "ImplementationGuideDefinitionTemplateComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeString(t, "ImplementationGuideDefinitionTemplateComponent", "source", element.getSourceElement(), -1);
        }
        if (element.hasScopeElement()) {
            this.composeString(t, "ImplementationGuideDefinitionTemplateComponent", "scope", element.getScopeElement(), -1);
        }
    }

    protected void composeImplementationGuideManifestComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ImplementationGuideManifestComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "manifest", name, element, index);
        if (element.hasRenderingElement()) {
            this.composeUrl(t, "ImplementationGuideManifestComponent", "rendering", element.getRenderingElement(), -1);
        }
        for (i2 = 0; i2 < element.getResource().size(); ++i2) {
            this.composeImplementationGuideManifestResourceComponent(t, "ImplementationGuideManifestComponent", "resource", element.getResource().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPage().size(); ++i2) {
            this.composeImplementationGuideManifestPageComponent(t, "ImplementationGuideManifestComponent", "page", element.getPage().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getImage().size(); ++i2) {
            this.composeString(t, "ImplementationGuideManifestComponent", "image", element.getImage().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getOther().size(); ++i2) {
            this.composeString(t, "ImplementationGuideManifestComponent", "other", element.getOther().get(i2), i2);
        }
    }

    protected void composeImplementationGuideManifestResourceComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ManifestResourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "resource", name, element, index);
        if (element.hasReference()) {
            this.composeReference(t, "ManifestResourceComponent", "reference", element.getReference(), -1);
        }
        if (element.hasIsExampleElement()) {
            this.composeBoolean(t, "ManifestResourceComponent", "isExample", element.getIsExampleElement(), -1);
        }
        for (int i2 = 0; i2 < element.getProfile().size(); ++i2) {
            this.composeCanonical(t, "ManifestResourceComponent", "profile", element.getProfile().get(i2), i2);
        }
        if (element.hasRelativePathElement()) {
            this.composeUrl(t, "ManifestResourceComponent", "relativePath", element.getRelativePathElement(), -1);
        }
    }

    protected void composeImplementationGuideManifestPageComponent(Turtle.Complex parent, String parentType, String name, ImplementationGuide.ManifestPageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "page", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ManifestPageComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ManifestPageComponent", "title", element.getTitleElement(), -1);
        }
        for (int i2 = 0; i2 < element.getAnchor().size(); ++i2) {
            this.composeString(t, "ManifestPageComponent", "anchor", element.getAnchor().get(i2), i2);
        }
    }

    protected void composeIngredient(Turtle.Complex parent, String parentType, String name, Ingredient element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Ingredient", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "Ingredient", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Ingredient", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getFor().size(); ++i2) {
            this.composeReference(t, "Ingredient", "for", element.getFor().get(i2), i2);
        }
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "Ingredient", "role", element.getRole(), -1);
        }
        for (i2 = 0; i2 < element.getFunction().size(); ++i2) {
            this.composeCodeableConcept(t, "Ingredient", "function", element.getFunction().get(i2), i2);
        }
        if (element.hasGroup()) {
            this.composeCodeableConcept(t, "Ingredient", "group", element.getGroup(), -1);
        }
        if (element.hasAllergenicIndicatorElement()) {
            this.composeBoolean(t, "Ingredient", "allergenicIndicator", element.getAllergenicIndicatorElement(), -1);
        }
        for (i2 = 0; i2 < element.getManufacturer().size(); ++i2) {
            this.composeIngredientManufacturerComponent(t, "Ingredient", "manufacturer", element.getManufacturer().get(i2), i2);
        }
        if (element.hasSubstance()) {
            this.composeIngredientSubstanceComponent(t, "Ingredient", "substance", element.getSubstance(), -1);
        }
    }

    protected void composeIngredientManufacturerComponent(Turtle.Complex parent, String parentType, String name, Ingredient.IngredientManufacturerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "manufacturer", name, element, index);
        if (element.hasRoleElement()) {
            this.composeEnum(t, "IngredientManufacturerComponent", "role", element.getRoleElement(), -1);
        }
        if (element.hasManufacturer()) {
            this.composeReference(t, "IngredientManufacturerComponent", "manufacturer", element.getManufacturer(), -1);
        }
    }

    protected void composeIngredientSubstanceComponent(Turtle.Complex parent, String parentType, String name, Ingredient.IngredientSubstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substance", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableReference(t, "IngredientSubstanceComponent", "code", element.getCode(), -1);
        }
        for (int i2 = 0; i2 < element.getStrength().size(); ++i2) {
            this.composeIngredientSubstanceStrengthComponent(t, "IngredientSubstanceComponent", "strength", element.getStrength().get(i2), i2);
        }
    }

    protected void composeIngredientSubstanceStrengthComponent(Turtle.Complex parent, String parentType, String name, Ingredient.IngredientSubstanceStrengthComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "strength", name, element, index);
        if (element.hasPresentation()) {
            this.composeType(t, "IngredientSubstanceStrengthComponent", "presentation", element.getPresentation(), -1);
        }
        if (element.hasTextPresentationElement()) {
            this.composeString(t, "IngredientSubstanceStrengthComponent", "textPresentation", element.getTextPresentationElement(), -1);
        }
        if (element.hasConcentration()) {
            this.composeType(t, "IngredientSubstanceStrengthComponent", "concentration", element.getConcentration(), -1);
        }
        if (element.hasTextConcentrationElement()) {
            this.composeString(t, "IngredientSubstanceStrengthComponent", "textConcentration", element.getTextConcentrationElement(), -1);
        }
        if (element.hasBasis()) {
            this.composeCodeableConcept(t, "IngredientSubstanceStrengthComponent", "basis", element.getBasis(), -1);
        }
        if (element.hasMeasurementPointElement()) {
            this.composeString(t, "IngredientSubstanceStrengthComponent", "measurementPoint", element.getMeasurementPointElement(), -1);
        }
        for (i2 = 0; i2 < element.getCountry().size(); ++i2) {
            this.composeCodeableConcept(t, "IngredientSubstanceStrengthComponent", "country", element.getCountry().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReferenceStrength().size(); ++i2) {
            this.composeIngredientSubstanceStrengthReferenceStrengthComponent(t, "IngredientSubstanceStrengthComponent", "referenceStrength", element.getReferenceStrength().get(i2), i2);
        }
    }

    protected void composeIngredientSubstanceStrengthReferenceStrengthComponent(Turtle.Complex parent, String parentType, String name, Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referenceStrength", name, element, index);
        if (element.hasSubstance()) {
            this.composeCodeableReference(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "substance", element.getSubstance(), -1);
        }
        if (element.hasStrength()) {
            this.composeType(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "strength", element.getStrength(), -1);
        }
        if (element.hasMeasurementPointElement()) {
            this.composeString(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "measurementPoint", element.getMeasurementPointElement(), -1);
        }
        for (int i2 = 0; i2 < element.getCountry().size(); ++i2) {
            this.composeCodeableConcept(t, "IngredientSubstanceStrengthReferenceStrengthComponent", "country", element.getCountry().get(i2), i2);
        }
    }

    protected void composeInsurancePlan(Turtle.Complex parent, String parentType, String name, InsurancePlan element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "InsurancePlan", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "InsurancePlan", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "InsurancePlan", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "InsurancePlan", "type", element.getType().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "InsurancePlan", "name", element.getNameElement(), -1);
        }
        for (i2 = 0; i2 < element.getAlias().size(); ++i2) {
            this.composeString(t, "InsurancePlan", "alias", element.getAlias().get(i2), i2);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "InsurancePlan", "period", element.getPeriod(), -1);
        }
        if (element.hasOwnedBy()) {
            this.composeReference(t, "InsurancePlan", "ownedBy", element.getOwnedBy(), -1);
        }
        if (element.hasAdministeredBy()) {
            this.composeReference(t, "InsurancePlan", "administeredBy", element.getAdministeredBy(), -1);
        }
        for (i2 = 0; i2 < element.getCoverageArea().size(); ++i2) {
            this.composeReference(t, "InsurancePlan", "coverageArea", element.getCoverageArea().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeExtendedContactDetail(t, "InsurancePlan", "contact", element.getContact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndpoint().size(); ++i2) {
            this.composeReference(t, "InsurancePlan", "endpoint", element.getEndpoint().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNetwork().size(); ++i2) {
            this.composeReference(t, "InsurancePlan", "network", element.getNetwork().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCoverage().size(); ++i2) {
            this.composeInsurancePlanCoverageComponent(t, "InsurancePlan", "coverage", element.getCoverage().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPlan().size(); ++i2) {
            this.composeInsurancePlanPlanComponent(t, "InsurancePlan", "plan", element.getPlan().get(i2), i2);
        }
    }

    protected void composeInsurancePlanCoverageComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanCoverageComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "coverage", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlanCoverageComponent", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getNetwork().size(); ++i2) {
            this.composeReference(t, "InsurancePlanCoverageComponent", "network", element.getNetwork().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBenefit().size(); ++i2) {
            this.composeInsurancePlanCoverageBenefitComponent(t, "InsurancePlanCoverageComponent", "benefit", element.getBenefit().get(i2), i2);
        }
    }

    protected void composeInsurancePlanCoverageBenefitComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.CoverageBenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefit", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "CoverageBenefitComponent", "type", element.getType(), -1);
        }
        if (element.hasRequirementElement()) {
            this.composeString(t, "CoverageBenefitComponent", "requirement", element.getRequirementElement(), -1);
        }
        for (int i2 = 0; i2 < element.getLimit().size(); ++i2) {
            this.composeInsurancePlanCoverageBenefitLimitComponent(t, "CoverageBenefitComponent", "limit", element.getLimit().get(i2), i2);
        }
    }

    protected void composeInsurancePlanCoverageBenefitLimitComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.CoverageBenefitLimitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "limit", name, element, index);
        if (element.hasValue()) {
            this.composeQuantity(t, "CoverageBenefitLimitComponent", "value", element.getValue(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "CoverageBenefitLimitComponent", "code", element.getCode(), -1);
        }
    }

    protected void composeInsurancePlanPlanComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "plan", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "InsurancePlanPlanComponent", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlanPlanComponent", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getCoverageArea().size(); ++i2) {
            this.composeReference(t, "InsurancePlanPlanComponent", "coverageArea", element.getCoverageArea().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNetwork().size(); ++i2) {
            this.composeReference(t, "InsurancePlanPlanComponent", "network", element.getNetwork().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getGeneralCost().size(); ++i2) {
            this.composeInsurancePlanPlanGeneralCostComponent(t, "InsurancePlanPlanComponent", "generalCost", element.getGeneralCost().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSpecificCost().size(); ++i2) {
            this.composeInsurancePlanPlanSpecificCostComponent(t, "InsurancePlanPlanComponent", "specificCost", element.getSpecificCost().get(i2), i2);
        }
    }

    protected void composeInsurancePlanPlanGeneralCostComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanGeneralCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "generalCost", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "InsurancePlanPlanGeneralCostComponent", "type", element.getType(), -1);
        }
        if (element.hasGroupSizeElement()) {
            this.composePositiveInt(t, "InsurancePlanPlanGeneralCostComponent", "groupSize", element.getGroupSizeElement(), -1);
        }
        if (element.hasCost()) {
            this.composeMoney(t, "InsurancePlanPlanGeneralCostComponent", "cost", element.getCost(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "InsurancePlanPlanGeneralCostComponent", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeInsurancePlanPlanSpecificCostComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.InsurancePlanPlanSpecificCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "specificCost", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "InsurancePlanPlanSpecificCostComponent", "category", element.getCategory(), -1);
        }
        for (int i2 = 0; i2 < element.getBenefit().size(); ++i2) {
            this.composeInsurancePlanPlanBenefitComponent(t, "InsurancePlanPlanSpecificCostComponent", "benefit", element.getBenefit().get(i2), i2);
        }
    }

    protected void composeInsurancePlanPlanBenefitComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.PlanBenefitComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "benefit", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PlanBenefitComponent", "type", element.getType(), -1);
        }
        for (int i2 = 0; i2 < element.getCost().size(); ++i2) {
            this.composeInsurancePlanPlanBenefitCostComponent(t, "PlanBenefitComponent", "cost", element.getCost().get(i2), i2);
        }
    }

    protected void composeInsurancePlanPlanBenefitCostComponent(Turtle.Complex parent, String parentType, String name, InsurancePlan.PlanBenefitCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "cost", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PlanBenefitCostComponent", "type", element.getType(), -1);
        }
        if (element.hasApplicability()) {
            this.composeCodeableConcept(t, "PlanBenefitCostComponent", "applicability", element.getApplicability(), -1);
        }
        for (int i2 = 0; i2 < element.getQualifiers().size(); ++i2) {
            this.composeCodeableConcept(t, "PlanBenefitCostComponent", "qualifiers", element.getQualifiers().get(i2), i2);
        }
        if (element.hasValue()) {
            this.composeQuantity(t, "PlanBenefitCostComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeInventoryReport(Turtle.Complex parent, String parentType, String name, InventoryReport element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "InventoryReport", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "InventoryReport", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "InventoryReport", "status", element.getStatusElement(), -1);
        }
        if (element.hasCountTypeElement()) {
            this.composeEnum(t, "InventoryReport", "countType", element.getCountTypeElement(), -1);
        }
        if (element.hasOperationType()) {
            this.composeCodeableConcept(t, "InventoryReport", "operationType", element.getOperationType(), -1);
        }
        if (element.hasOperationTypeReason()) {
            this.composeCodeableConcept(t, "InventoryReport", "operationTypeReason", element.getOperationTypeReason(), -1);
        }
        if (element.hasReportedDateTimeElement()) {
            this.composeDateTime(t, "InventoryReport", "reportedDateTime", element.getReportedDateTimeElement(), -1);
        }
        if (element.hasReporter()) {
            this.composeReference(t, "InventoryReport", "reporter", element.getReporter(), -1);
        }
        if (element.hasReportingPeriod()) {
            this.composePeriod(t, "InventoryReport", "reportingPeriod", element.getReportingPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getInventoryListing().size(); ++i2) {
            this.composeInventoryReportInventoryListingComponent(t, "InventoryReport", "inventoryListing", element.getInventoryListing().get(i2), i2);
        }
        if (element.hasNote()) {
            this.composeAnnotation(t, "InventoryReport", "note", element.getNote(), -1);
        }
    }

    protected void composeInventoryReportInventoryListingComponent(Turtle.Complex parent, String parentType, String name, InventoryReport.InventoryReportInventoryListingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "inventoryListing", name, element, index);
        if (element.hasLocation()) {
            this.composeReference(t, "InventoryReportInventoryListingComponent", "location", element.getLocation(), -1);
        }
        if (element.hasItemStatus()) {
            this.composeCodeableConcept(t, "InventoryReportInventoryListingComponent", "itemStatus", element.getItemStatus(), -1);
        }
        if (element.hasCountingDateTimeElement()) {
            this.composeDateTime(t, "InventoryReportInventoryListingComponent", "countingDateTime", element.getCountingDateTimeElement(), -1);
        }
        for (int i2 = 0; i2 < element.getItems().size(); ++i2) {
            this.composeInventoryReportInventoryListingItemsComponent(t, "InventoryReportInventoryListingComponent", "items", element.getItems().get(i2), i2);
        }
    }

    protected void composeInventoryReportInventoryListingItemsComponent(Turtle.Complex parent, String parentType, String name, InventoryReport.InventoryReportInventoryListingItemsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "items", name, element, index);
        if (element.hasCategory()) {
            this.composeCodeableConcept(t, "InventoryReportInventoryListingItemsComponent", "category", element.getCategory(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "InventoryReportInventoryListingItemsComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasItem()) {
            this.composeCodeableReference(t, "InventoryReportInventoryListingItemsComponent", "item", element.getItem(), -1);
        }
        if (element.hasLotElement()) {
            this.composeString(t, "InventoryReportInventoryListingItemsComponent", "lot", element.getLotElement(), -1);
        }
        if (element.hasSerialElement()) {
            this.composeString(t, "InventoryReportInventoryListingItemsComponent", "serial", element.getSerialElement(), -1);
        }
        if (element.hasExpiryElement()) {
            this.composeDateTime(t, "InventoryReportInventoryListingItemsComponent", "expiry", element.getExpiryElement(), -1);
        }
        if (element.hasManufacturingDateElement()) {
            this.composeDateTime(t, "InventoryReportInventoryListingItemsComponent", "manufacturingDate", element.getManufacturingDateElement(), -1);
        }
    }

    protected void composeInvoice(Turtle.Complex parent, String parentType, String name, Invoice element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Invoice", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Invoice", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Invoice", "status", element.getStatusElement(), -1);
        }
        if (element.hasCancelledReasonElement()) {
            this.composeString(t, "Invoice", "cancelledReason", element.getCancelledReasonElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Invoice", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Invoice", "subject", element.getSubject(), -1);
        }
        if (element.hasRecipient()) {
            this.composeReference(t, "Invoice", "recipient", element.getRecipient(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Invoice", "date", element.getDateElement(), -1);
        }
        if (element.hasCreationElement()) {
            this.composeDateTime(t, "Invoice", "creation", element.getCreationElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composeType(t, "Invoice", "period", element.getPeriod(), -1);
        }
        for (i2 = 0; i2 < element.getParticipant().size(); ++i2) {
            this.composeInvoiceParticipantComponent(t, "Invoice", "participant", element.getParticipant().get(i2), i2);
        }
        if (element.hasIssuer()) {
            this.composeReference(t, "Invoice", "issuer", element.getIssuer(), -1);
        }
        if (element.hasAccount()) {
            this.composeReference(t, "Invoice", "account", element.getAccount(), -1);
        }
        for (i2 = 0; i2 < element.getLineItem().size(); ++i2) {
            this.composeInvoiceLineItemComponent(t, "Invoice", "lineItem", element.getLineItem().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTotalPriceComponent().size(); ++i2) {
            this.composeMonetaryComponent(t, "Invoice", "totalPriceComponent", element.getTotalPriceComponent().get(i2), i2);
        }
        if (element.hasTotalNet()) {
            this.composeMoney(t, "Invoice", "totalNet", element.getTotalNet(), -1);
        }
        if (element.hasTotalGross()) {
            this.composeMoney(t, "Invoice", "totalGross", element.getTotalGross(), -1);
        }
        if (element.hasPaymentTermsElement()) {
            this.composeMarkdown(t, "Invoice", "paymentTerms", element.getPaymentTermsElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Invoice", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeInvoiceParticipantComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceParticipantComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "participant", name, element, index);
        if (element.hasRole()) {
            this.composeCodeableConcept(t, "InvoiceParticipantComponent", "role", element.getRole(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "InvoiceParticipantComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeInvoiceLineItemComponent(Turtle.Complex parent, String parentType, String name, Invoice.InvoiceLineItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "lineItem", name, element, index);
        if (element.hasSequenceElement()) {
            this.composePositiveInt(t, "InvoiceLineItemComponent", "sequence", element.getSequenceElement(), -1);
        }
        if (element.hasServiced()) {
            this.composeType(t, "InvoiceLineItemComponent", "serviced", element.getServiced(), -1);
        }
        if (element.hasChargeItem()) {
            this.composeType(t, "InvoiceLineItemComponent", "chargeItem", element.getChargeItem(), -1);
        }
        for (int i2 = 0; i2 < element.getPriceComponent().size(); ++i2) {
            this.composeMonetaryComponent(t, "InvoiceLineItemComponent", "priceComponent", element.getPriceComponent().get(i2), i2);
        }
    }

    protected void composeLibrary(Turtle.Complex parent, String parentType, String name, Library element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "Library", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Library", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Library", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Library", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Library", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Library", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Library", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Library", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Library", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "Library", "type", element.getType(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "Library", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Library", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Library", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "Library", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Library", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "Library", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "Library", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Library", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "Library", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Library", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Library", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Library", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Library", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getTopic().size(); ++i2) {
            this.composeCodeableConcept(t, "Library", "topic", element.getTopic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "Library", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "Library", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "Library", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "Library", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "Library", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getParameter().size(); ++i2) {
            this.composeParameterDefinition(t, "Library", "parameter", element.getParameter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDataRequirement().size(); ++i2) {
            this.composeDataRequirement(t, "Library", "dataRequirement", element.getDataRequirement().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContent().size(); ++i2) {
            this.composeAttachment(t, "Library", "content", element.getContent().get(i2), i2);
        }
    }

    protected void composeLinkage(Turtle.Complex parent, String parentType, String name, Linkage element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Linkage", name, element, index);
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Linkage", "active", element.getActiveElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "Linkage", "author", element.getAuthor(), -1);
        }
        for (int i2 = 0; i2 < element.getItem().size(); ++i2) {
            this.composeLinkageItemComponent(t, "Linkage", "item", element.getItem().get(i2), i2);
        }
    }

    protected void composeLinkageItemComponent(Turtle.Complex parent, String parentType, String name, Linkage.LinkageItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "item", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "LinkageItemComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasResource()) {
            this.composeReference(t, "LinkageItemComponent", "resource", element.getResource(), -1);
        }
    }

    protected void composeListResource(Turtle.Complex parent, String parentType, String name, ListResource element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "List", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ListResource", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ListResource", "status", element.getStatusElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "ListResource", "mode", element.getModeElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ListResource", "title", element.getTitleElement(), -1);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ListResource", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "ListResource", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "ListResource", "encounter", element.getEncounter(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ListResource", "date", element.getDateElement(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "ListResource", "source", element.getSource(), -1);
        }
        if (element.hasOrderedBy()) {
            this.composeCodeableConcept(t, "ListResource", "orderedBy", element.getOrderedBy(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "ListResource", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEntry().size(); ++i2) {
            this.composeListResourceEntryComponent(t, "ListResource", "entry", element.getEntry().get(i2), i2);
        }
        if (element.hasEmptyReason()) {
            this.composeCodeableConcept(t, "ListResource", "emptyReason", element.getEmptyReason(), -1);
        }
    }

    protected void composeListResourceEntryComponent(Turtle.Complex parent, String parentType, String name, ListResource.ListResourceEntryComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "entry", name, element, index);
        if (element.hasFlag()) {
            this.composeCodeableConcept(t, "ListResourceEntryComponent", "flag", element.getFlag(), -1);
        }
        if (element.hasDeletedElement()) {
            this.composeBoolean(t, "ListResourceEntryComponent", "deleted", element.getDeletedElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ListResourceEntryComponent", "date", element.getDateElement(), -1);
        }
        if (element.hasItem()) {
            this.composeReference(t, "ListResourceEntryComponent", "item", element.getItem(), -1);
        }
    }

    protected void composeLocation(Turtle.Complex parent, String parentType, String name, Location element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Location", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Location", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Location", "status", element.getStatusElement(), -1);
        }
        if (element.hasOperationalStatus()) {
            this.composeCoding(t, "Location", "operationalStatus", element.getOperationalStatus(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Location", "name", element.getNameElement(), -1);
        }
        for (i2 = 0; i2 < element.getAlias().size(); ++i2) {
            this.composeString(t, "Location", "alias", element.getAlias().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Location", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasModeElement()) {
            this.composeEnum(t, "Location", "mode", element.getModeElement(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "Location", "type", element.getType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeExtendedContactDetail(t, "Location", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "Location", "address", element.getAddress(), -1);
        }
        if (element.hasForm()) {
            this.composeCodeableConcept(t, "Location", "form", element.getForm(), -1);
        }
        if (element.hasPosition()) {
            this.composeLocationPositionComponent(t, "Location", "position", element.getPosition(), -1);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Location", "managingOrganization", element.getManagingOrganization(), -1);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Location", "partOf", element.getPartOf(), -1);
        }
        for (i2 = 0; i2 < element.getCharacteristic().size(); ++i2) {
            this.composeCodeableConcept(t, "Location", "characteristic", element.getCharacteristic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getHoursOfOperation().size(); ++i2) {
            this.composeAvailability(t, "Location", "hoursOfOperation", element.getHoursOfOperation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getVirtualService().size(); ++i2) {
            this.composeVirtualServiceDetail(t, "Location", "virtualService", element.getVirtualService().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndpoint().size(); ++i2) {
            this.composeReference(t, "Location", "endpoint", element.getEndpoint().get(i2), i2);
        }
    }

    protected void composeLocationPositionComponent(Turtle.Complex parent, String parentType, String name, Location.LocationPositionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "position", name, element, index);
        if (element.hasLongitudeElement()) {
            this.composeDecimal(t, "LocationPositionComponent", "longitude", element.getLongitudeElement(), -1);
        }
        if (element.hasLatitudeElement()) {
            this.composeDecimal(t, "LocationPositionComponent", "latitude", element.getLatitudeElement(), -1);
        }
        if (element.hasAltitudeElement()) {
            this.composeDecimal(t, "LocationPositionComponent", "altitude", element.getAltitudeElement(), -1);
        }
    }

    protected void composeManufacturedItemDefinition(Turtle.Complex parent, String parentType, String name, ManufacturedItemDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ManufacturedItemDefinition", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "ManufacturedItemDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ManufacturedItemDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ManufacturedItemDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasManufacturedDoseForm()) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinition", "manufacturedDoseForm", element.getManufacturedDoseForm(), -1);
        }
        if (element.hasUnitOfPresentation()) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinition", "unitOfPresentation", element.getUnitOfPresentation(), -1);
        }
        for (i2 = 0; i2 < element.getManufacturer().size(); ++i2) {
            this.composeReference(t, "ManufacturedItemDefinition", "manufacturer", element.getManufacturer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMarketingStatus().size(); ++i2) {
            this.composeMarketingStatus(t, "ManufacturedItemDefinition", "marketingStatus", element.getMarketingStatus().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIngredient().size(); ++i2) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinition", "ingredient", element.getIngredient().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProperty().size(); ++i2) {
            this.composeManufacturedItemDefinitionPropertyComponent(t, "ManufacturedItemDefinition", "property", element.getProperty().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getComponent().size(); ++i2) {
            this.composeManufacturedItemDefinitionComponentComponent(t, "ManufacturedItemDefinition", "component", element.getComponent().get(i2), i2);
        }
    }

    protected void composeManufacturedItemDefinitionPropertyComponent(Turtle.Complex parent, String parentType, String name, ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinitionPropertyComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ManufacturedItemDefinitionPropertyComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeManufacturedItemDefinitionComponentComponent(Turtle.Complex parent, String parentType, String name, ManufacturedItemDefinition.ManufacturedItemDefinitionComponentComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinitionComponentComponent", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getFunction().size(); ++i2) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinitionComponentComponent", "function", element.getFunction().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAmount().size(); ++i2) {
            this.composeQuantity(t, "ManufacturedItemDefinitionComponentComponent", "amount", element.getAmount().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getConstituent().size(); ++i2) {
            this.composeManufacturedItemDefinitionComponentConstituentComponent(t, "ManufacturedItemDefinitionComponentComponent", "constituent", element.getConstituent().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProperty().size(); ++i2) {
            this.composeManufacturedItemDefinitionPropertyComponent(t, "ManufacturedItemDefinitionComponentComponent", "property", element.getProperty().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getComponent().size(); ++i2) {
            this.composeManufacturedItemDefinitionComponentComponent(t, "ManufacturedItemDefinitionComponentComponent", "component", element.getComponent().get(i2), i2);
        }
    }

    protected void composeManufacturedItemDefinitionComponentConstituentComponent(Turtle.Complex parent, String parentType, String name, ManufacturedItemDefinition.ManufacturedItemDefinitionComponentConstituentComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "constituent", name, element, index);
        for (i2 = 0; i2 < element.getAmount().size(); ++i2) {
            this.composeQuantity(t, "ManufacturedItemDefinitionComponentConstituentComponent", "amount", element.getAmount().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getLocation().size(); ++i2) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinitionComponentConstituentComponent", "location", element.getLocation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getFunction().size(); ++i2) {
            this.composeCodeableConcept(t, "ManufacturedItemDefinitionComponentConstituentComponent", "function", element.getFunction().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getHasIngredient().size(); ++i2) {
            this.composeCodeableReference(t, "ManufacturedItemDefinitionComponentConstituentComponent", "hasIngredient", element.getHasIngredient().get(i2), i2);
        }
    }

    protected void composeMeasure(Turtle.Complex parent, String parentType, String name, Measure element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "Measure", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "Measure", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Measure", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "Measure", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Measure", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "Measure", "title", element.getTitleElement(), -1);
        }
        if (element.hasSubtitleElement()) {
            this.composeString(t, "Measure", "subtitle", element.getSubtitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Measure", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "Measure", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeType(t, "Measure", "subject", element.getSubject(), -1);
        }
        if (element.hasBasisElement()) {
            this.composeEnum(t, "Measure", "basis", element.getBasisElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "Measure", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "Measure", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "Measure", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "Measure", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "Measure", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "Measure", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "Measure", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "Measure", "usage", element.getUsageElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "Measure", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "Measure", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "Measure", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "Measure", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getTopic().size(); ++i2) {
            this.composeCodeableConcept(t, "Measure", "topic", element.getTopic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "Measure", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "Measure", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "Measure", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "Measure", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "Measure", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getLibrary().size(); ++i2) {
            this.composeCanonical(t, "Measure", "library", element.getLibrary().get(i2), i2);
        }
        if (element.hasDisclaimerElement()) {
            this.composeMarkdown(t, "Measure", "disclaimer", element.getDisclaimerElement(), -1);
        }
        if (element.hasScoring()) {
            this.composeCodeableConcept(t, "Measure", "scoring", element.getScoring(), -1);
        }
        if (element.hasScoringUnit()) {
            this.composeCodeableConcept(t, "Measure", "scoringUnit", element.getScoringUnit(), -1);
        }
        if (element.hasCompositeScoring()) {
            this.composeCodeableConcept(t, "Measure", "compositeScoring", element.getCompositeScoring(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "Measure", "type", element.getType().get(i2), i2);
        }
        if (element.hasRiskAdjustmentElement()) {
            this.composeString(t, "Measure", "riskAdjustment", element.getRiskAdjustmentElement(), -1);
        }
        if (element.hasRateAggregationElement()) {
            this.composeString(t, "Measure", "rateAggregation", element.getRateAggregationElement(), -1);
        }
        if (element.hasRationaleElement()) {
            this.composeMarkdown(t, "Measure", "rationale", element.getRationaleElement(), -1);
        }
        if (element.hasClinicalRecommendationStatementElement()) {
            this.composeMarkdown(t, "Measure", "clinicalRecommendationStatement", element.getClinicalRecommendationStatementElement(), -1);
        }
        if (element.hasImprovementNotation()) {
            this.composeCodeableConcept(t, "Measure", "improvementNotation", element.getImprovementNotation(), -1);
        }
        for (i2 = 0; i2 < element.getTerm().size(); ++i2) {
            this.composeMeasureTermComponent(t, "Measure", "term", element.getTerm().get(i2), i2);
        }
        if (element.hasGuidanceElement()) {
            this.composeMarkdown(t, "Measure", "guidance", element.getGuidanceElement(), -1);
        }
        for (i2 = 0; i2 < element.getGroup().size(); ++i2) {
            this.composeMeasureGroupComponent(t, "Measure", "group", element.getGroup().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSupplementalData().size(); ++i2) {
            this.composeMeasureSupplementalDataComponent(t, "Measure", "supplementalData", element.getSupplementalData().get(i2), i2);
        }
    }

    protected void composeMeasureTermComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureTermComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "term", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureTermComponent", "code", element.getCode(), -1);
        }
        if (element.hasDefinitionElement()) {
            this.composeMarkdown(t, "MeasureTermComponent", "definition", element.getDefinitionElement(), -1);
        }
    }

    protected void composeMeasureGroupComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureGroupComponent", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MeasureGroupComponent", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "MeasureGroupComponent", "type", element.getType().get(i2), i2);
        }
        if (element.hasBasisElement()) {
            this.composeEnum(t, "MeasureGroupComponent", "basis", element.getBasisElement(), -1);
        }
        if (element.hasScoring()) {
            this.composeCodeableConcept(t, "MeasureGroupComponent", "scoring", element.getScoring(), -1);
        }
        if (element.hasScoringUnit()) {
            this.composeCodeableConcept(t, "MeasureGroupComponent", "scoringUnit", element.getScoringUnit(), -1);
        }
        if (element.hasImprovementNotation()) {
            this.composeCodeableConcept(t, "MeasureGroupComponent", "improvementNotation", element.getImprovementNotation(), -1);
        }
        for (i2 = 0; i2 < element.getPopulation().size(); ++i2) {
            this.composeMeasureGroupPopulationComponent(t, "MeasureGroupComponent", "population", element.getPopulation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getStratifier().size(); ++i2) {
            this.composeMeasureGroupStratifierComponent(t, "MeasureGroupComponent", "stratifier", element.getStratifier().get(i2), i2);
        }
    }

    protected void composeMeasureGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureGroupPopulationComponent", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MeasureGroupPopulationComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "MeasureGroupPopulationComponent", "criteria", element.getCriteria(), -1);
        }
        if (element.hasInputPopulationIdElement()) {
            this.composeString(t, "MeasureGroupPopulationComponent", "inputPopulationId", element.getInputPopulationIdElement(), -1);
        }
        if (element.hasAggregateMethod()) {
            this.composeCodeableConcept(t, "MeasureGroupPopulationComponent", "aggregateMethod", element.getAggregateMethod(), -1);
        }
    }

    protected void composeMeasureGroupStratifierComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratifier", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureGroupStratifierComponent", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MeasureGroupStratifierComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "MeasureGroupStratifierComponent", "criteria", element.getCriteria(), -1);
        }
        for (int i2 = 0; i2 < element.getComponent().size(); ++i2) {
            this.composeMeasureGroupStratifierComponentComponent(t, "MeasureGroupStratifierComponent", "component", element.getComponent().get(i2), i2);
        }
    }

    protected void composeMeasureGroupStratifierComponentComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureGroupStratifierComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureGroupStratifierComponentComponent", "code", element.getCode(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MeasureGroupStratifierComponentComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "MeasureGroupStratifierComponentComponent", "criteria", element.getCriteria(), -1);
        }
    }

    protected void composeMeasureSupplementalDataComponent(Turtle.Complex parent, String parentType, String name, Measure.MeasureSupplementalDataComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supplementalData", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureSupplementalDataComponent", "code", element.getCode(), -1);
        }
        for (int i2 = 0; i2 < element.getUsage().size(); ++i2) {
            this.composeCodeableConcept(t, "MeasureSupplementalDataComponent", "usage", element.getUsage().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "MeasureSupplementalDataComponent", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCriteria()) {
            this.composeExpression(t, "MeasureSupplementalDataComponent", "criteria", element.getCriteria(), -1);
        }
    }

    protected void composeMeasureReport(Turtle.Complex parent, String parentType, String name, MeasureReport element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MeasureReport", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "MeasureReport", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MeasureReport", "status", element.getStatusElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MeasureReport", "type", element.getTypeElement(), -1);
        }
        if (element.hasDataUpdateTypeElement()) {
            this.composeEnum(t, "MeasureReport", "dataUpdateType", element.getDataUpdateTypeElement(), -1);
        }
        if (element.hasMeasureElement()) {
            this.composeCanonical(t, "MeasureReport", "measure", element.getMeasureElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MeasureReport", "subject", element.getSubject(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MeasureReport", "date", element.getDateElement(), -1);
        }
        if (element.hasReporter()) {
            this.composeReference(t, "MeasureReport", "reporter", element.getReporter(), -1);
        }
        if (element.hasReportingVendor()) {
            this.composeReference(t, "MeasureReport", "reportingVendor", element.getReportingVendor(), -1);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "MeasureReport", "location", element.getLocation(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "MeasureReport", "period", element.getPeriod(), -1);
        }
        if (element.hasInputParameters()) {
            this.composeReference(t, "MeasureReport", "inputParameters", element.getInputParameters(), -1);
        }
        if (element.hasScoring()) {
            this.composeCodeableConcept(t, "MeasureReport", "scoring", element.getScoring(), -1);
        }
        if (element.hasImprovementNotation()) {
            this.composeCodeableConcept(t, "MeasureReport", "improvementNotation", element.getImprovementNotation(), -1);
        }
        for (i2 = 0; i2 < element.getGroup().size(); ++i2) {
            this.composeMeasureReportGroupComponent(t, "MeasureReport", "group", element.getGroup().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEvaluatedResource().size(); ++i2) {
            this.composeReference(t, "MeasureReport", "evaluatedResource", element.getEvaluatedResource().get(i2), i2);
        }
    }

    protected void composeMeasureReportGroupComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "group", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReportGroupComponent", "code", element.getCode(), -1);
        }
        for (i2 = 0; i2 < element.getPopulation().size(); ++i2) {
            this.composeMeasureReportGroupPopulationComponent(t, "MeasureReportGroupComponent", "population", element.getPopulation().get(i2), i2);
        }
        if (element.hasMeasureScore()) {
            this.composeType(t, "MeasureReportGroupComponent", "measureScore", element.getMeasureScore(), -1);
        }
        for (i2 = 0; i2 < element.getStratifier().size(); ++i2) {
            this.composeMeasureReportGroupStratifierComponent(t, "MeasureReportGroupComponent", "stratifier", element.getStratifier().get(i2), i2);
        }
    }

    protected void composeMeasureReportGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReportGroupPopulationComponent", "code", element.getCode(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "MeasureReportGroupPopulationComponent", "count", element.getCountElement(), -1);
        }
        if (element.hasSubjectResults()) {
            this.composeReference(t, "MeasureReportGroupPopulationComponent", "subjectResults", element.getSubjectResults(), -1);
        }
    }

    protected void composeMeasureReportGroupStratifierComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.MeasureReportGroupStratifierComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratifier", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MeasureReportGroupStratifierComponent", "code", element.getCode(), -1);
        }
        for (int i2 = 0; i2 < element.getStratum().size(); ++i2) {
            this.composeMeasureReportStratifierGroupComponent(t, "MeasureReportGroupStratifierComponent", "stratum", element.getStratum().get(i2), i2);
        }
    }

    protected void composeMeasureReportStratifierGroupComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "stratum", name, element, index);
        if (element.hasValue()) {
            this.composeType(t, "StratifierGroupComponent", "value", element.getValue(), -1);
        }
        for (i2 = 0; i2 < element.getComponent().size(); ++i2) {
            this.composeMeasureReportStratifierGroupComponentComponent(t, "StratifierGroupComponent", "component", element.getComponent().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPopulation().size(); ++i2) {
            this.composeMeasureReportStratifierGroupPopulationComponent(t, "StratifierGroupComponent", "population", element.getPopulation().get(i2), i2);
        }
        if (element.hasMeasureScore()) {
            this.composeType(t, "StratifierGroupComponent", "measureScore", element.getMeasureScore(), -1);
        }
    }

    protected void composeMeasureReportStratifierGroupComponentComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupComponentComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "StratifierGroupComponentComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "StratifierGroupComponentComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeMeasureReportStratifierGroupPopulationComponent(Turtle.Complex parent, String parentType, String name, MeasureReport.StratifierGroupPopulationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "population", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "StratifierGroupPopulationComponent", "code", element.getCode(), -1);
        }
        if (element.hasCountElement()) {
            this.composeInteger(t, "StratifierGroupPopulationComponent", "count", element.getCountElement(), -1);
        }
        if (element.hasSubjectResults()) {
            this.composeReference(t, "StratifierGroupPopulationComponent", "subjectResults", element.getSubjectResults(), -1);
        }
    }

    protected void composeMedication(Turtle.Complex parent, String parentType, String name, Medication element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Medication", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Medication", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Medication", "code", element.getCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Medication", "status", element.getStatusElement(), -1);
        }
        if (element.hasMarketingAuthorizationHolder()) {
            this.composeReference(t, "Medication", "marketingAuthorizationHolder", element.getMarketingAuthorizationHolder(), -1);
        }
        if (element.hasDoseForm()) {
            this.composeCodeableConcept(t, "Medication", "doseForm", element.getDoseForm(), -1);
        }
        if (element.hasTotalVolume()) {
            this.composeRatio(t, "Medication", "totalVolume", element.getTotalVolume(), -1);
        }
        for (i2 = 0; i2 < element.getIngredient().size(); ++i2) {
            this.composeMedicationIngredientComponent(t, "Medication", "ingredient", element.getIngredient().get(i2), i2);
        }
        if (element.hasBatch()) {
            this.composeMedicationBatchComponent(t, "Medication", "batch", element.getBatch(), -1);
        }
    }

    protected void composeMedicationIngredientComponent(Turtle.Complex parent, String parentType, String name, Medication.MedicationIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableReference(t, "MedicationIngredientComponent", "item", element.getItem(), -1);
        }
        if (element.hasIsActiveElement()) {
            this.composeBoolean(t, "MedicationIngredientComponent", "isActive", element.getIsActiveElement(), -1);
        }
        if (element.hasStrength()) {
            this.composeType(t, "MedicationIngredientComponent", "strength", element.getStrength(), -1);
        }
    }

    protected void composeMedicationBatchComponent(Turtle.Complex parent, String parentType, String name, Medication.MedicationBatchComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "batch", name, element, index);
        if (element.hasLotNumberElement()) {
            this.composeString(t, "MedicationBatchComponent", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpirationDateElement()) {
            this.composeDateTime(t, "MedicationBatchComponent", "expirationDate", element.getExpirationDateElement(), -1);
        }
    }

    protected void composeMedicationAdministration(Turtle.Complex parent, String parentType, String name, MedicationAdministration element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationAdministration", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "MedicationAdministration", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "MedicationAdministration", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPartOf().size(); ++i2) {
            this.composeReference(t, "MedicationAdministration", "partOf", element.getPartOf().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationAdministration", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getStatusReason().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationAdministration", "statusReason", element.getStatusReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationAdministration", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasMedication()) {
            this.composeCodeableReference(t, "MedicationAdministration", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationAdministration", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "MedicationAdministration", "encounter", element.getEncounter(), -1);
        }
        for (i2 = 0; i2 < element.getSupportingInformation().size(); ++i2) {
            this.composeReference(t, "MedicationAdministration", "supportingInformation", element.getSupportingInformation().get(i2), i2);
        }
        if (element.hasOccurence()) {
            this.composeType(t, "MedicationAdministration", "occurence", element.getOccurence(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeDateTime(t, "MedicationAdministration", "recorded", element.getRecordedElement(), -1);
        }
        if (element.hasIsSubPotentElement()) {
            this.composeBoolean(t, "MedicationAdministration", "isSubPotent", element.getIsSubPotentElement(), -1);
        }
        for (i2 = 0; i2 < element.getSubPotentReason().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationAdministration", "subPotentReason", element.getSubPotentReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeMedicationAdministrationPerformerComponent(t, "MedicationAdministration", "performer", element.getPerformer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "MedicationAdministration", "reason", element.getReason().get(i2), i2);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "MedicationAdministration", "request", element.getRequest(), -1);
        }
        for (i2 = 0; i2 < element.getDevice().size(); ++i2) {
            this.composeReference(t, "MedicationAdministration", "device", element.getDevice().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "MedicationAdministration", "note", element.getNote().get(i2), i2);
        }
        if (element.hasDosage()) {
            this.composeMedicationAdministrationDosageComponent(t, "MedicationAdministration", "dosage", element.getDosage(), -1);
        }
        for (i2 = 0; i2 < element.getEventHistory().size(); ++i2) {
            this.composeReference(t, "MedicationAdministration", "eventHistory", element.getEventHistory().get(i2), i2);
        }
    }

    protected void composeMedicationAdministrationPerformerComponent(Turtle.Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationPerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "MedicationAdministrationPerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "MedicationAdministrationPerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeMedicationAdministrationDosageComponent(Turtle.Complex parent, String parentType, String name, MedicationAdministration.MedicationAdministrationDosageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosage", name, element, index);
        if (element.hasTextElement()) {
            this.composeString(t, "MedicationAdministrationDosageComponent", "text", element.getTextElement(), -1);
        }
        if (element.hasSite()) {
            this.composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "site", element.getSite(), -1);
        }
        if (element.hasRoute()) {
            this.composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "route", element.getRoute(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "MedicationAdministrationDosageComponent", "method", element.getMethod(), -1);
        }
        if (element.hasDose()) {
            this.composeQuantity(t, "MedicationAdministrationDosageComponent", "dose", element.getDose(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "MedicationAdministrationDosageComponent", "rate", element.getRate(), -1);
        }
    }

    protected void composeMedicationDispense(Turtle.Complex parent, String parentType, String name, MedicationDispense element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationDispense", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "MedicationDispense", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "MedicationDispense", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPartOf().size(); ++i2) {
            this.composeReference(t, "MedicationDispense", "partOf", element.getPartOf().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationDispense", "status", element.getStatusElement(), -1);
        }
        if (element.hasNotPerformedReason()) {
            this.composeCodeableReference(t, "MedicationDispense", "notPerformedReason", element.getNotPerformedReason(), -1);
        }
        if (element.hasStatusChangedElement()) {
            this.composeDateTime(t, "MedicationDispense", "statusChanged", element.getStatusChangedElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationDispense", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasMedication()) {
            this.composeCodeableReference(t, "MedicationDispense", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationDispense", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "MedicationDispense", "encounter", element.getEncounter(), -1);
        }
        for (i2 = 0; i2 < element.getSupportingInformation().size(); ++i2) {
            this.composeReference(t, "MedicationDispense", "supportingInformation", element.getSupportingInformation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeMedicationDispensePerformerComponent(t, "MedicationDispense", "performer", element.getPerformer().get(i2), i2);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "MedicationDispense", "location", element.getLocation(), -1);
        }
        for (i2 = 0; i2 < element.getAuthorizingPrescription().size(); ++i2) {
            this.composeReference(t, "MedicationDispense", "authorizingPrescription", element.getAuthorizingPrescription().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationDispense", "type", element.getType(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationDispense", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDaysSupply()) {
            this.composeQuantity(t, "MedicationDispense", "daysSupply", element.getDaysSupply(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeDateTime(t, "MedicationDispense", "recorded", element.getRecordedElement(), -1);
        }
        if (element.hasWhenPreparedElement()) {
            this.composeDateTime(t, "MedicationDispense", "whenPrepared", element.getWhenPreparedElement(), -1);
        }
        if (element.hasWhenHandedOverElement()) {
            this.composeDateTime(t, "MedicationDispense", "whenHandedOver", element.getWhenHandedOverElement(), -1);
        }
        if (element.hasDestination()) {
            this.composeReference(t, "MedicationDispense", "destination", element.getDestination(), -1);
        }
        for (i2 = 0; i2 < element.getReceiver().size(); ++i2) {
            this.composeReference(t, "MedicationDispense", "receiver", element.getReceiver().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "MedicationDispense", "note", element.getNote().get(i2), i2);
        }
        if (element.hasRenderedDosageInstructionElement()) {
            this.composeString(t, "MedicationDispense", "renderedDosageInstruction", element.getRenderedDosageInstructionElement(), -1);
        }
        for (i2 = 0; i2 < element.getDosageInstruction().size(); ++i2) {
            this.composeDosage(t, "MedicationDispense", "dosageInstruction", element.getDosageInstruction().get(i2), i2);
        }
        if (element.hasSubstitution()) {
            this.composeMedicationDispenseSubstitutionComponent(t, "MedicationDispense", "substitution", element.getSubstitution(), -1);
        }
        for (i2 = 0; i2 < element.getEventHistory().size(); ++i2) {
            this.composeReference(t, "MedicationDispense", "eventHistory", element.getEventHistory().get(i2), i2);
        }
    }

    protected void composeMedicationDispensePerformerComponent(Turtle.Complex parent, String parentType, String name, MedicationDispense.MedicationDispensePerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "MedicationDispensePerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "MedicationDispensePerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeMedicationDispenseSubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationDispense.MedicationDispenseSubstitutionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasWasSubstitutedElement()) {
            this.composeBoolean(t, "MedicationDispenseSubstitutionComponent", "wasSubstituted", element.getWasSubstitutedElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationDispenseSubstitutionComponent", "type", element.getType(), -1);
        }
        for (int i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationDispenseSubstitutionComponent", "reason", element.getReason().get(i2), i2);
        }
        if (element.hasResponsibleParty()) {
            this.composeReference(t, "MedicationDispenseSubstitutionComponent", "responsibleParty", element.getResponsibleParty(), -1);
        }
    }

    protected void composeMedicationKnowledge(Turtle.Complex parent, String parentType, String name, MedicationKnowledge element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationKnowledge", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "MedicationKnowledge", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "code", element.getCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationKnowledge", "status", element.getStatusElement(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "MedicationKnowledge", "author", element.getAuthor(), -1);
        }
        for (i2 = 0; i2 < element.getIntendedJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "intendedJurisdiction", element.getIntendedJurisdiction().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getName().size(); ++i2) {
            this.composeString(t, "MedicationKnowledge", "name", element.getName().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedMedicationKnowledge().size(); ++i2) {
            this.composeMedicationKnowledgeRelatedMedicationKnowledgeComponent(t, "MedicationKnowledge", "relatedMedicationKnowledge", element.getRelatedMedicationKnowledge().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAssociatedMedication().size(); ++i2) {
            this.composeReference(t, "MedicationKnowledge", "associatedMedication", element.getAssociatedMedication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProductType().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationKnowledge", "productType", element.getProductType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMonograph().size(); ++i2) {
            this.composeMedicationKnowledgeMonographComponent(t, "MedicationKnowledge", "monograph", element.getMonograph().get(i2), i2);
        }
        if (element.hasPreparationInstructionElement()) {
            this.composeMarkdown(t, "MedicationKnowledge", "preparationInstruction", element.getPreparationInstructionElement(), -1);
        }
        for (i2 = 0; i2 < element.getCost().size(); ++i2) {
            this.composeMedicationKnowledgeCostComponent(t, "MedicationKnowledge", "cost", element.getCost().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMonitoringProgram().size(); ++i2) {
            this.composeMedicationKnowledgeMonitoringProgramComponent(t, "MedicationKnowledge", "monitoringProgram", element.getMonitoringProgram().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIndicationGuideline().size(); ++i2) {
            this.composeMedicationKnowledgeIndicationGuidelineComponent(t, "MedicationKnowledge", "indicationGuideline", element.getIndicationGuideline().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMedicineClassification().size(); ++i2) {
            this.composeMedicationKnowledgeMedicineClassificationComponent(t, "MedicationKnowledge", "medicineClassification", element.getMedicineClassification().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPackaging().size(); ++i2) {
            this.composeMedicationKnowledgePackagingComponent(t, "MedicationKnowledge", "packaging", element.getPackaging().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getClinicalUseIssue().size(); ++i2) {
            this.composeReference(t, "MedicationKnowledge", "clinicalUseIssue", element.getClinicalUseIssue().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getStorageGuideline().size(); ++i2) {
            this.composeMedicationKnowledgeStorageGuidelineComponent(t, "MedicationKnowledge", "storageGuideline", element.getStorageGuideline().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRegulatory().size(); ++i2) {
            this.composeMedicationKnowledgeRegulatoryComponent(t, "MedicationKnowledge", "regulatory", element.getRegulatory().get(i2), i2);
        }
        if (element.hasDefinitional()) {
            this.composeMedicationKnowledgeDefinitionalComponent(t, "MedicationKnowledge", "definitional", element.getDefinitional(), -1);
        }
    }

    protected void composeMedicationKnowledgeRelatedMedicationKnowledgeComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relatedMedicationKnowledge", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeRelatedMedicationKnowledgeComponent", "type", element.getType(), -1);
        }
        for (int i2 = 0; i2 < element.getReference().size(); ++i2) {
            this.composeReference(t, "MedicationKnowledgeRelatedMedicationKnowledgeComponent", "reference", element.getReference().get(i2), i2);
        }
    }

    protected void composeMedicationKnowledgeMonographComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonographComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "monograph", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeMonographComponent", "type", element.getType(), -1);
        }
        if (element.hasSource()) {
            this.composeReference(t, "MedicationKnowledgeMonographComponent", "source", element.getSource(), -1);
        }
    }

    protected void composeMedicationKnowledgeCostComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeCostComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "cost", name, element, index);
        for (int i2 = 0; i2 < element.getEffectiveDate().size(); ++i2) {
            this.composePeriod(t, "MedicationKnowledgeCostComponent", "effectiveDate", element.getEffectiveDate().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeCostComponent", "type", element.getType(), -1);
        }
        if (element.hasSourceElement()) {
            this.composeString(t, "MedicationKnowledgeCostComponent", "source", element.getSourceElement(), -1);
        }
        if (element.hasCost()) {
            this.composeType(t, "MedicationKnowledgeCostComponent", "cost", element.getCost(), -1);
        }
    }

    protected void composeMedicationKnowledgeMonitoringProgramComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "monitoringProgram", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeMonitoringProgramComponent", "type", element.getType(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "MedicationKnowledgeMonitoringProgramComponent", "name", element.getNameElement(), -1);
        }
    }

    protected void composeMedicationKnowledgeIndicationGuidelineComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIndicationGuidelineComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "indicationGuideline", name, element, index);
        for (i2 = 0; i2 < element.getIndication().size(); ++i2) {
            this.composeCodeableReference(t, "MedicationKnowledgeIndicationGuidelineComponent", "indication", element.getIndication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDosingGuideline().size(); ++i2) {
            this.composeMedicationKnowledgeIndicationGuidelineDosingGuidelineComponent(t, "MedicationKnowledgeIndicationGuidelineComponent", "dosingGuideline", element.getDosingGuideline().get(i2), i2);
        }
    }

    protected void composeMedicationKnowledgeIndicationGuidelineDosingGuidelineComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosingGuideline", name, element, index);
        if (element.hasTreatmentIntent()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent", "treatmentIntent", element.getTreatmentIntent(), -1);
        }
        for (i2 = 0; i2 < element.getDosage().size(); ++i2) {
            this.composeMedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent", "dosage", element.getDosage().get(i2), i2);
        }
        if (element.hasAdministrationTreatment()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent", "administrationTreatment", element.getAdministrationTreatment(), -1);
        }
        for (i2 = 0; i2 < element.getPatientCharacteristic().size(); ++i2) {
            this.composeMedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineComponent", "patientCharacteristic", element.getPatientCharacteristic().get(i2), i2);
        }
    }

    protected void composeMedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dosage", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent", "type", element.getType(), -1);
        }
        for (int i2 = 0; i2 < element.getDosage().size(); ++i2) {
            this.composeDosage(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelineDosageComponent", "dosage", element.getDosage().get(i2), i2);
        }
    }

    protected void composeMedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "patientCharacteristic", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "MedicationKnowledgeIndicationGuidelineDosingGuidelinePatientCharacteristicComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeMedicationKnowledgeMedicineClassificationComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "medicineClassification", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeMedicineClassificationComponent", "type", element.getType(), -1);
        }
        if (element.hasSource()) {
            this.composeType(t, "MedicationKnowledgeMedicineClassificationComponent", "source", element.getSource(), -1);
        }
        for (int i2 = 0; i2 < element.getClassification().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationKnowledgeMedicineClassificationComponent", "classification", element.getClassification().get(i2), i2);
        }
    }

    protected void composeMedicationKnowledgePackagingComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgePackagingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "packaging", name, element, index);
        for (int i2 = 0; i2 < element.getCost().size(); ++i2) {
            this.composeMedicationKnowledgeCostComponent(t, "MedicationKnowledgePackagingComponent", "cost", element.getCost().get(i2), i2);
        }
        if (element.hasPackagedProduct()) {
            this.composeReference(t, "MedicationKnowledgePackagingComponent", "packagedProduct", element.getPackagedProduct(), -1);
        }
    }

    protected void composeMedicationKnowledgeStorageGuidelineComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeStorageGuidelineComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "storageGuideline", name, element, index);
        if (element.hasReferenceElement()) {
            this.composeUri(t, "MedicationKnowledgeStorageGuidelineComponent", "reference", element.getReferenceElement(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "MedicationKnowledgeStorageGuidelineComponent", "note", element.getNote().get(i2), i2);
        }
        if (element.hasStabilityDuration()) {
            this.composeDuration(t, "MedicationKnowledgeStorageGuidelineComponent", "stabilityDuration", element.getStabilityDuration(), -1);
        }
        for (i2 = 0; i2 < element.getEnvironmentalSetting().size(); ++i2) {
            this.composeMedicationKnowledgeStorageGuidelineEnvironmentalSettingComponent(t, "MedicationKnowledgeStorageGuidelineComponent", "environmentalSetting", element.getEnvironmentalSetting().get(i2), i2);
        }
    }

    protected void composeMedicationKnowledgeStorageGuidelineEnvironmentalSettingComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeStorageGuidelineEnvironmentalSettingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "environmentalSetting", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeStorageGuidelineEnvironmentalSettingComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "MedicationKnowledgeStorageGuidelineEnvironmentalSettingComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeMedicationKnowledgeRegulatoryComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "regulatory", name, element, index);
        if (element.hasRegulatoryAuthority()) {
            this.composeReference(t, "MedicationKnowledgeRegulatoryComponent", "regulatoryAuthority", element.getRegulatoryAuthority(), -1);
        }
        for (i2 = 0; i2 < element.getSubstitution().size(); ++i2) {
            this.composeMedicationKnowledgeRegulatorySubstitutionComponent(t, "MedicationKnowledgeRegulatoryComponent", "substitution", element.getSubstitution().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSchedule().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationKnowledgeRegulatoryComponent", "schedule", element.getSchedule().get(i2), i2);
        }
        if (element.hasMaxDispense()) {
            this.composeMedicationKnowledgeRegulatoryMaxDispenseComponent(t, "MedicationKnowledgeRegulatoryComponent", "maxDispense", element.getMaxDispense(), -1);
        }
    }

    protected void composeMedicationKnowledgeRegulatorySubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeRegulatorySubstitutionComponent", "type", element.getType(), -1);
        }
        if (element.hasAllowedElement()) {
            this.composeBoolean(t, "MedicationKnowledgeRegulatorySubstitutionComponent", "allowed", element.getAllowedElement(), -1);
        }
    }

    protected void composeMedicationKnowledgeRegulatoryMaxDispenseComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "maxDispense", name, element, index);
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationKnowledgeRegulatoryMaxDispenseComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasPeriod()) {
            this.composeDuration(t, "MedicationKnowledgeRegulatoryMaxDispenseComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composeMedicationKnowledgeDefinitionalComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeDefinitionalComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "definitional", name, element, index);
        for (i2 = 0; i2 < element.getDefinition().size(); ++i2) {
            this.composeReference(t, "MedicationKnowledgeDefinitionalComponent", "definition", element.getDefinition().get(i2), i2);
        }
        if (element.hasDoseForm()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeDefinitionalComponent", "doseForm", element.getDoseForm(), -1);
        }
        for (i2 = 0; i2 < element.getIntendedRoute().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationKnowledgeDefinitionalComponent", "intendedRoute", element.getIntendedRoute().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIngredient().size(); ++i2) {
            this.composeMedicationKnowledgeDefinitionalIngredientComponent(t, "MedicationKnowledgeDefinitionalComponent", "ingredient", element.getIngredient().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDrugCharacteristic().size(); ++i2) {
            this.composeMedicationKnowledgeDefinitionalDrugCharacteristicComponent(t, "MedicationKnowledgeDefinitionalComponent", "drugCharacteristic", element.getDrugCharacteristic().get(i2), i2);
        }
    }

    protected void composeMedicationKnowledgeDefinitionalIngredientComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeDefinitionalIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableReference(t, "MedicationKnowledgeDefinitionalIngredientComponent", "item", element.getItem(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeDefinitionalIngredientComponent", "type", element.getType(), -1);
        }
        if (element.hasStrength()) {
            this.composeType(t, "MedicationKnowledgeDefinitionalIngredientComponent", "strength", element.getStrength(), -1);
        }
    }

    protected void composeMedicationKnowledgeDefinitionalDrugCharacteristicComponent(Turtle.Complex parent, String parentType, String name, MedicationKnowledge.MedicationKnowledgeDefinitionalDrugCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "drugCharacteristic", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicationKnowledgeDefinitionalDrugCharacteristicComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "MedicationKnowledgeDefinitionalDrugCharacteristicComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeMedicationRequest(Turtle.Complex parent, String parentType, String name, MedicationRequest element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationRequest", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "MedicationRequest", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "MedicationRequest", "basedOn", element.getBasedOn().get(i2), i2);
        }
        if (element.hasPriorPrescription()) {
            this.composeReference(t, "MedicationRequest", "priorPrescription", element.getPriorPrescription(), -1);
        }
        if (element.hasGroupIdentifier()) {
            this.composeIdentifier(t, "MedicationRequest", "groupIdentifier", element.getGroupIdentifier(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationRequest", "status", element.getStatusElement(), -1);
        }
        if (element.hasStatusReason()) {
            this.composeCodeableConcept(t, "MedicationRequest", "statusReason", element.getStatusReason(), -1);
        }
        if (element.hasStatusChangedElement()) {
            this.composeDateTime(t, "MedicationRequest", "statusChanged", element.getStatusChangedElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "MedicationRequest", "intent", element.getIntentElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationRequest", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasPriorityElement()) {
            this.composeEnum(t, "MedicationRequest", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasDoNotPerformElement()) {
            this.composeBoolean(t, "MedicationRequest", "doNotPerform", element.getDoNotPerformElement(), -1);
        }
        if (element.hasMedication()) {
            this.composeCodeableReference(t, "MedicationRequest", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationRequest", "subject", element.getSubject(), -1);
        }
        for (i2 = 0; i2 < element.getInformationSource().size(); ++i2) {
            this.composeReference(t, "MedicationRequest", "informationSource", element.getInformationSource().get(i2), i2);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "MedicationRequest", "encounter", element.getEncounter(), -1);
        }
        for (i2 = 0; i2 < element.getSupportingInformation().size(); ++i2) {
            this.composeReference(t, "MedicationRequest", "supportingInformation", element.getSupportingInformation().get(i2), i2);
        }
        if (element.hasAuthoredOnElement()) {
            this.composeDateTime(t, "MedicationRequest", "authoredOn", element.getAuthoredOnElement(), -1);
        }
        if (element.hasRequester()) {
            this.composeReference(t, "MedicationRequest", "requester", element.getRequester(), -1);
        }
        if (element.hasReportedElement()) {
            this.composeBoolean(t, "MedicationRequest", "reported", element.getReportedElement(), -1);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "MedicationRequest", "performerType", element.getPerformerType(), -1);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeReference(t, "MedicationRequest", "performer", element.getPerformer().get(i2), i2);
        }
        if (element.hasDevice()) {
            this.composeCodeableReference(t, "MedicationRequest", "device", element.getDevice(), -1);
        }
        if (element.hasRecorder()) {
            this.composeReference(t, "MedicationRequest", "recorder", element.getRecorder(), -1);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "MedicationRequest", "reason", element.getReason().get(i2), i2);
        }
        if (element.hasCourseOfTherapyType()) {
            this.composeCodeableConcept(t, "MedicationRequest", "courseOfTherapyType", element.getCourseOfTherapyType(), -1);
        }
        for (i2 = 0; i2 < element.getInsurance().size(); ++i2) {
            this.composeReference(t, "MedicationRequest", "insurance", element.getInsurance().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "MedicationRequest", "note", element.getNote().get(i2), i2);
        }
        if (element.hasDose()) {
            this.composeMedicationRequestDoseComponent(t, "MedicationRequest", "dose", element.getDose(), -1);
        }
        if (element.hasDispenseRequest()) {
            this.composeMedicationRequestDispenseRequestComponent(t, "MedicationRequest", "dispenseRequest", element.getDispenseRequest(), -1);
        }
        if (element.hasSubstitution()) {
            this.composeMedicationRequestSubstitutionComponent(t, "MedicationRequest", "substitution", element.getSubstitution(), -1);
        }
        for (i2 = 0; i2 < element.getEventHistory().size(); ++i2) {
            this.composeReference(t, "MedicationRequest", "eventHistory", element.getEventHistory().get(i2), i2);
        }
    }

    protected void composeMedicationRequestDoseComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDoseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dose", name, element, index);
        if (element.hasRenderedDosageInstructionElement()) {
            this.composeString(t, "MedicationRequestDoseComponent", "renderedDosageInstruction", element.getRenderedDosageInstructionElement(), -1);
        }
        if (element.hasEffectiveDosePeriod()) {
            this.composePeriod(t, "MedicationRequestDoseComponent", "effectiveDosePeriod", element.getEffectiveDosePeriod(), -1);
        }
        for (int i2 = 0; i2 < element.getDosageInstruction().size(); ++i2) {
            this.composeDosage(t, "MedicationRequestDoseComponent", "dosageInstruction", element.getDosageInstruction().get(i2), i2);
        }
    }

    protected void composeMedicationRequestDispenseRequestComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "dispenseRequest", name, element, index);
        if (element.hasInitialFill()) {
            this.composeMedicationRequestDispenseRequestInitialFillComponent(t, "MedicationRequestDispenseRequestComponent", "initialFill", element.getInitialFill(), -1);
        }
        if (element.hasDispenseInterval()) {
            this.composeDuration(t, "MedicationRequestDispenseRequestComponent", "dispenseInterval", element.getDispenseInterval(), -1);
        }
        if (element.hasValidityPeriod()) {
            this.composePeriod(t, "MedicationRequestDispenseRequestComponent", "validityPeriod", element.getValidityPeriod(), -1);
        }
        if (element.hasNumberOfRepeatsAllowedElement()) {
            this.composeUnsignedInt(t, "MedicationRequestDispenseRequestComponent", "numberOfRepeatsAllowed", element.getNumberOfRepeatsAllowedElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationRequestDispenseRequestComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasExpectedSupplyDuration()) {
            this.composeDuration(t, "MedicationRequestDispenseRequestComponent", "expectedSupplyDuration", element.getExpectedSupplyDuration(), -1);
        }
        if (element.hasDispenser()) {
            this.composeReference(t, "MedicationRequestDispenseRequestComponent", "dispenser", element.getDispenser(), -1);
        }
        for (int i2 = 0; i2 < element.getDispenserInstruction().size(); ++i2) {
            this.composeAnnotation(t, "MedicationRequestDispenseRequestComponent", "dispenserInstruction", element.getDispenserInstruction().get(i2), i2);
        }
        if (element.hasDoseAdministrationAid()) {
            this.composeCodeableConcept(t, "MedicationRequestDispenseRequestComponent", "doseAdministrationAid", element.getDoseAdministrationAid(), -1);
        }
    }

    protected void composeMedicationRequestDispenseRequestInitialFillComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "initialFill", name, element, index);
        if (element.hasQuantity()) {
            this.composeQuantity(t, "MedicationRequestDispenseRequestInitialFillComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasDuration()) {
            this.composeDuration(t, "MedicationRequestDispenseRequestInitialFillComponent", "duration", element.getDuration(), -1);
        }
    }

    protected void composeMedicationRequestSubstitutionComponent(Turtle.Complex parent, String parentType, String name, MedicationRequest.MedicationRequestSubstitutionComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "substitution", name, element, index);
        if (element.hasAllowed()) {
            this.composeType(t, "MedicationRequestSubstitutionComponent", "allowed", element.getAllowed(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MedicationRequestSubstitutionComponent", "reason", element.getReason(), -1);
        }
    }

    protected void composeMedicationUsage(Turtle.Complex parent, String parentType, String name, MedicationUsage element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicationUsage", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "MedicationUsage", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPartOf().size(); ++i2) {
            this.composeReference(t, "MedicationUsage", "partOf", element.getPartOf().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MedicationUsage", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicationUsage", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasMedication()) {
            this.composeCodeableReference(t, "MedicationUsage", "medication", element.getMedication(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MedicationUsage", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "MedicationUsage", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "MedicationUsage", "effective", element.getEffective(), -1);
        }
        if (element.hasDateAssertedElement()) {
            this.composeDateTime(t, "MedicationUsage", "dateAsserted", element.getDateAssertedElement(), -1);
        }
        for (i2 = 0; i2 < element.getInformationSource().size(); ++i2) {
            this.composeReference(t, "MedicationUsage", "informationSource", element.getInformationSource().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDerivedFrom().size(); ++i2) {
            this.composeReference(t, "MedicationUsage", "derivedFrom", element.getDerivedFrom().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "MedicationUsage", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "MedicationUsage", "note", element.getNote().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedClinicalInformation().size(); ++i2) {
            this.composeReference(t, "MedicationUsage", "relatedClinicalInformation", element.getRelatedClinicalInformation().get(i2), i2);
        }
        if (element.hasRenderedDosageInstructionElement()) {
            this.composeString(t, "MedicationUsage", "renderedDosageInstruction", element.getRenderedDosageInstructionElement(), -1);
        }
        for (i2 = 0; i2 < element.getDosage().size(); ++i2) {
            this.composeDosage(t, "MedicationUsage", "dosage", element.getDosage().get(i2), i2);
        }
        if (element.hasAdherence()) {
            this.composeMedicationUsageAdherenceComponent(t, "MedicationUsage", "adherence", element.getAdherence(), -1);
        }
    }

    protected void composeMedicationUsageAdherenceComponent(Turtle.Complex parent, String parentType, String name, MedicationUsage.MedicationUsageAdherenceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "adherence", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "MedicationUsageAdherenceComponent", "code", element.getCode(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MedicationUsageAdherenceComponent", "reason", element.getReason(), -1);
        }
    }

    protected void composeMedicinalProductDefinition(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MedicinalProductDefinition", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "MedicinalProductDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "type", element.getType(), -1);
        }
        if (element.hasDomain()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "domain", element.getDomain(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MedicinalProductDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "status", element.getStatus(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDateTime(t, "MedicinalProductDefinition", "statusDate", element.getStatusDateElement(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "MedicinalProductDefinition", "description", element.getDescriptionElement(), -1);
        }
        if (element.hasCombinedPharmaceuticalDoseForm()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "combinedPharmaceuticalDoseForm", element.getCombinedPharmaceuticalDoseForm(), -1);
        }
        for (i2 = 0; i2 < element.getRoute().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "route", element.getRoute().get(i2), i2);
        }
        if (element.hasIndicationElement()) {
            this.composeMarkdown(t, "MedicinalProductDefinition", "indication", element.getIndicationElement(), -1);
        }
        if (element.hasLegalStatusOfSupply()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "legalStatusOfSupply", element.getLegalStatusOfSupply(), -1);
        }
        if (element.hasAdditionalMonitoringIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "additionalMonitoringIndicator", element.getAdditionalMonitoringIndicator(), -1);
        }
        for (i2 = 0; i2 < element.getSpecialMeasures().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "specialMeasures", element.getSpecialMeasures().get(i2), i2);
        }
        if (element.hasPediatricUseIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "pediatricUseIndicator", element.getPediatricUseIndicator(), -1);
        }
        for (i2 = 0; i2 < element.getClassification().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "classification", element.getClassification().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMarketingStatus().size(); ++i2) {
            this.composeMarketingStatus(t, "MedicinalProductDefinition", "marketingStatus", element.getMarketingStatus().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPackagedMedicinalProduct().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "packagedMedicinalProduct", element.getPackagedMedicinalProduct().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getComprisedOf().size(); ++i2) {
            this.composeReference(t, "MedicinalProductDefinition", "comprisedOf", element.getComprisedOf().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIngredient().size(); ++i2) {
            this.composeCodeableConcept(t, "MedicinalProductDefinition", "ingredient", element.getIngredient().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getImpurity().size(); ++i2) {
            this.composeCodeableReference(t, "MedicinalProductDefinition", "impurity", element.getImpurity().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAttachedDocument().size(); ++i2) {
            this.composeReference(t, "MedicinalProductDefinition", "attachedDocument", element.getAttachedDocument().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMasterFile().size(); ++i2) {
            this.composeReference(t, "MedicinalProductDefinition", "masterFile", element.getMasterFile().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeMedicinalProductDefinitionContactComponent(t, "MedicinalProductDefinition", "contact", element.getContact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getClinicalTrial().size(); ++i2) {
            this.composeReference(t, "MedicinalProductDefinition", "clinicalTrial", element.getClinicalTrial().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCode().size(); ++i2) {
            this.composeCoding(t, "MedicinalProductDefinition", "code", element.getCode().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getName().size(); ++i2) {
            this.composeMedicinalProductDefinitionNameComponent(t, "MedicinalProductDefinition", "name", element.getName().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCrossReference().size(); ++i2) {
            this.composeMedicinalProductDefinitionCrossReferenceComponent(t, "MedicinalProductDefinition", "crossReference", element.getCrossReference().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getOperation().size(); ++i2) {
            this.composeMedicinalProductDefinitionOperationComponent(t, "MedicinalProductDefinition", "operation", element.getOperation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCharacteristic().size(); ++i2) {
            this.composeMedicinalProductDefinitionCharacteristicComponent(t, "MedicinalProductDefinition", "characteristic", element.getCharacteristic().get(i2), i2);
        }
    }

    protected void composeMedicinalProductDefinitionContactComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionContactComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionContactComponent", "type", element.getType(), -1);
        }
        if (element.hasContact()) {
            this.composeReference(t, "MedicinalProductDefinitionContactComponent", "contact", element.getContact(), -1);
        }
    }

    protected void composeMedicinalProductDefinitionNameComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNameComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "name", name, element, index);
        if (element.hasProductNameElement()) {
            this.composeString(t, "MedicinalProductDefinitionNameComponent", "productName", element.getProductNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionNameComponent", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getPart().size(); ++i2) {
            this.composeMedicinalProductDefinitionNamePartComponent(t, "MedicinalProductDefinitionNameComponent", "part", element.getPart().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getUsage().size(); ++i2) {
            this.composeMedicinalProductDefinitionNameUsageComponent(t, "MedicinalProductDefinitionNameComponent", "usage", element.getUsage().get(i2), i2);
        }
    }

    protected void composeMedicinalProductDefinitionNamePartComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNamePartComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "part", name, element, index);
        if (element.hasPartElement()) {
            this.composeString(t, "MedicinalProductDefinitionNamePartComponent", "part", element.getPartElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionNamePartComponent", "type", element.getType(), -1);
        }
    }

    protected void composeMedicinalProductDefinitionNameUsageComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionNameUsageComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "usage", name, element, index);
        if (element.hasCountry()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionNameUsageComponent", "country", element.getCountry(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionNameUsageComponent", "jurisdiction", element.getJurisdiction(), -1);
        }
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionNameUsageComponent", "language", element.getLanguage(), -1);
        }
    }

    protected void composeMedicinalProductDefinitionCrossReferenceComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionCrossReferenceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "crossReference", name, element, index);
        if (element.hasProduct()) {
            this.composeCodeableReference(t, "MedicinalProductDefinitionCrossReferenceComponent", "product", element.getProduct(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionCrossReferenceComponent", "type", element.getType(), -1);
        }
    }

    protected void composeMedicinalProductDefinitionOperationComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionOperationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "operation", name, element, index);
        if (element.hasType()) {
            this.composeCodeableReference(t, "MedicinalProductDefinitionOperationComponent", "type", element.getType(), -1);
        }
        if (element.hasEffectiveDate()) {
            this.composePeriod(t, "MedicinalProductDefinitionOperationComponent", "effectiveDate", element.getEffectiveDate(), -1);
        }
        for (int i2 = 0; i2 < element.getOrganization().size(); ++i2) {
            this.composeReference(t, "MedicinalProductDefinitionOperationComponent", "organization", element.getOrganization().get(i2), i2);
        }
        if (element.hasConfidentialityIndicator()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionOperationComponent", "confidentialityIndicator", element.getConfidentialityIndicator(), -1);
        }
    }

    protected void composeMedicinalProductDefinitionCharacteristicComponent(Turtle.Complex parent, String parentType, String name, MedicinalProductDefinition.MedicinalProductDefinitionCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "MedicinalProductDefinitionCharacteristicComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "MedicinalProductDefinitionCharacteristicComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeMessageDefinition(Turtle.Complex parent, String parentType, String name, MessageDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeCanonicalResource(t, "MessageDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "MessageDefinition", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "MessageDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MessageDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "MessageDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "MessageDefinition", "title", element.getTitleElement(), -1);
        }
        for (i2 = 0; i2 < element.getReplaces().size(); ++i2) {
            this.composeCanonical(t, "MessageDefinition", "replaces", element.getReplaces().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "MessageDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "MessageDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "MessageDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "MessageDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "MessageDefinition", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "MessageDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "MessageDefinition", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "MessageDefinition", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "MessageDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "MessageDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeCanonical(t, "MessageDefinition", "base", element.getBaseElement(), -1);
        }
        for (i2 = 0; i2 < element.getParent().size(); ++i2) {
            this.composeCanonical(t, "MessageDefinition", "parent", element.getParent().get(i2), i2);
        }
        if (element.hasEvent()) {
            this.composeType(t, "MessageDefinition", "event", element.getEvent(), -1);
        }
        if (element.hasCategoryElement()) {
            this.composeEnum(t, "MessageDefinition", "category", element.getCategoryElement(), -1);
        }
        for (i2 = 0; i2 < element.getFocus().size(); ++i2) {
            this.composeMessageDefinitionFocusComponent(t, "MessageDefinition", "focus", element.getFocus().get(i2), i2);
        }
        if (element.hasResponseRequiredElement()) {
            this.composeEnum(t, "MessageDefinition", "responseRequired", element.getResponseRequiredElement(), -1);
        }
        for (i2 = 0; i2 < element.getAllowedResponse().size(); ++i2) {
            this.composeMessageDefinitionAllowedResponseComponent(t, "MessageDefinition", "allowedResponse", element.getAllowedResponse().get(i2), i2);
        }
        if (element.hasGraphElement()) {
            this.composeCanonical(t, "MessageDefinition", "graph", element.getGraphElement(), -1);
        }
    }

    protected void composeMessageDefinitionFocusComponent(Turtle.Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionFocusComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "focus", name, element, index);
        if (element.hasCodeElement()) {
            this.composeCode(t, "MessageDefinitionFocusComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasProfileElement()) {
            this.composeCanonical(t, "MessageDefinitionFocusComponent", "profile", element.getProfileElement(), -1);
        }
        if (element.hasMinElement()) {
            this.composeUnsignedInt(t, "MessageDefinitionFocusComponent", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "MessageDefinitionFocusComponent", "max", element.getMaxElement(), -1);
        }
    }

    protected void composeMessageDefinitionAllowedResponseComponent(Turtle.Complex parent, String parentType, String name, MessageDefinition.MessageDefinitionAllowedResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "allowedResponse", name, element, index);
        if (element.hasMessageElement()) {
            this.composeCanonical(t, "MessageDefinitionAllowedResponseComponent", "message", element.getMessageElement(), -1);
        }
        if (element.hasSituationElement()) {
            this.composeMarkdown(t, "MessageDefinitionAllowedResponseComponent", "situation", element.getSituationElement(), -1);
        }
    }

    protected void composeMessageHeader(Turtle.Complex parent, String parentType, String name, MessageHeader element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MessageHeader", name, element, index);
        if (element.hasEvent()) {
            this.composeType(t, "MessageHeader", "event", element.getEvent(), -1);
        }
        for (i2 = 0; i2 < element.getDestination().size(); ++i2) {
            this.composeMessageHeaderMessageDestinationComponent(t, "MessageHeader", "destination", element.getDestination().get(i2), i2);
        }
        if (element.hasSender()) {
            this.composeReference(t, "MessageHeader", "sender", element.getSender(), -1);
        }
        if (element.hasEnterer()) {
            this.composeReference(t, "MessageHeader", "enterer", element.getEnterer(), -1);
        }
        if (element.hasAuthor()) {
            this.composeReference(t, "MessageHeader", "author", element.getAuthor(), -1);
        }
        if (element.hasSource()) {
            this.composeMessageHeaderMessageSourceComponent(t, "MessageHeader", "source", element.getSource(), -1);
        }
        if (element.hasResponsible()) {
            this.composeReference(t, "MessageHeader", "responsible", element.getResponsible(), -1);
        }
        if (element.hasReason()) {
            this.composeCodeableConcept(t, "MessageHeader", "reason", element.getReason(), -1);
        }
        if (element.hasResponse()) {
            this.composeMessageHeaderResponseComponent(t, "MessageHeader", "response", element.getResponse(), -1);
        }
        for (i2 = 0; i2 < element.getFocus().size(); ++i2) {
            this.composeReference(t, "MessageHeader", "focus", element.getFocus().get(i2), i2);
        }
        if (element.hasDefinitionElement()) {
            this.composeCanonical(t, "MessageHeader", "definition", element.getDefinitionElement(), -1);
        }
    }

    protected void composeMessageHeaderMessageDestinationComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageDestinationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "destination", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "MessageDestinationComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasTarget()) {
            this.composeReference(t, "MessageDestinationComponent", "target", element.getTarget(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUrl(t, "MessageDestinationComponent", "endpoint", element.getEndpointElement(), -1);
        }
        if (element.hasReceiver()) {
            this.composeReference(t, "MessageDestinationComponent", "receiver", element.getReceiver(), -1);
        }
    }

    protected void composeMessageHeaderMessageSourceComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageSourceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "source", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "MessageSourceComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasSoftwareElement()) {
            this.composeString(t, "MessageSourceComponent", "software", element.getSoftwareElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "MessageSourceComponent", "version", element.getVersionElement(), -1);
        }
        if (element.hasContact()) {
            this.composeContactPoint(t, "MessageSourceComponent", "contact", element.getContact(), -1);
        }
        if (element.hasEndpointElement()) {
            this.composeUrl(t, "MessageSourceComponent", "endpoint", element.getEndpointElement(), -1);
        }
    }

    protected void composeMessageHeaderResponseComponent(Turtle.Complex parent, String parentType, String name, MessageHeader.MessageHeaderResponseComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "response", name, element, index);
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "MessageHeaderResponseComponent", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "MessageHeaderResponseComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDetails()) {
            this.composeReference(t, "MessageHeaderResponseComponent", "details", element.getDetails(), -1);
        }
    }

    protected void composeMolecularSequence(Turtle.Complex parent, String parentType, String name, MolecularSequence element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "MolecularSequence", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "MolecularSequence", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "MolecularSequence", "type", element.getTypeElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "MolecularSequence", "subject", element.getSubject(), -1);
        }
        if (element.hasSpecimen()) {
            this.composeReference(t, "MolecularSequence", "specimen", element.getSpecimen(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "MolecularSequence", "device", element.getDevice(), -1);
        }
        if (element.hasPerformer()) {
            this.composeReference(t, "MolecularSequence", "performer", element.getPerformer(), -1);
        }
        if (element.hasLiteralElement()) {
            this.composeString(t, "MolecularSequence", "literal", element.getLiteralElement(), -1);
        }
        for (i2 = 0; i2 < element.getFormatted().size(); ++i2) {
            this.composeAttachment(t, "MolecularSequence", "formatted", element.getFormatted().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelative().size(); ++i2) {
            this.composeMolecularSequenceRelativeComponent(t, "MolecularSequence", "relative", element.getRelative().get(i2), i2);
        }
    }

    protected void composeMolecularSequenceRelativeComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceRelativeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "relative", name, element, index);
        if (element.hasCoordinateSystem()) {
            this.composeCodeableConcept(t, "MolecularSequenceRelativeComponent", "coordinateSystem", element.getCoordinateSystem(), -1);
        }
        if (element.hasOrdinalPositionElement()) {
            this.composeInteger(t, "MolecularSequenceRelativeComponent", "ordinalPosition", element.getOrdinalPositionElement(), -1);
        }
        if (element.hasSequenceRange()) {
            this.composeRange(t, "MolecularSequenceRelativeComponent", "sequenceRange", element.getSequenceRange(), -1);
        }
        if (element.hasStartingSequence()) {
            this.composeMolecularSequenceRelativeStartingSequenceComponent(t, "MolecularSequenceRelativeComponent", "startingSequence", element.getStartingSequence(), -1);
        }
        for (int i2 = 0; i2 < element.getEdit().size(); ++i2) {
            this.composeMolecularSequenceRelativeEditComponent(t, "MolecularSequenceRelativeComponent", "edit", element.getEdit().get(i2), i2);
        }
    }

    protected void composeMolecularSequenceRelativeStartingSequenceComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceRelativeStartingSequenceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "startingSequence", name, element, index);
        if (element.hasGenomeAssembly()) {
            this.composeCodeableConcept(t, "MolecularSequenceRelativeStartingSequenceComponent", "genomeAssembly", element.getGenomeAssembly(), -1);
        }
        if (element.hasChromosome()) {
            this.composeCodeableConcept(t, "MolecularSequenceRelativeStartingSequenceComponent", "chromosome", element.getChromosome(), -1);
        }
        if (element.hasSequence()) {
            this.composeType(t, "MolecularSequenceRelativeStartingSequenceComponent", "sequence", element.getSequence(), -1);
        }
        if (element.hasWindowStartElement()) {
            this.composeInteger(t, "MolecularSequenceRelativeStartingSequenceComponent", "windowStart", element.getWindowStartElement(), -1);
        }
        if (element.hasWindowEndElement()) {
            this.composeInteger(t, "MolecularSequenceRelativeStartingSequenceComponent", "windowEnd", element.getWindowEndElement(), -1);
        }
        if (element.hasOrientationElement()) {
            this.composeEnum(t, "MolecularSequenceRelativeStartingSequenceComponent", "orientation", element.getOrientationElement(), -1);
        }
        if (element.hasStrandElement()) {
            this.composeEnum(t, "MolecularSequenceRelativeStartingSequenceComponent", "strand", element.getStrandElement(), -1);
        }
    }

    protected void composeMolecularSequenceRelativeEditComponent(Turtle.Complex parent, String parentType, String name, MolecularSequence.MolecularSequenceRelativeEditComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "edit", name, element, index);
        if (element.hasStartElement()) {
            this.composeInteger(t, "MolecularSequenceRelativeEditComponent", "start", element.getStartElement(), -1);
        }
        if (element.hasEndElement()) {
            this.composeInteger(t, "MolecularSequenceRelativeEditComponent", "end", element.getEndElement(), -1);
        }
        if (element.hasReplacementSequenceElement()) {
            this.composeString(t, "MolecularSequenceRelativeEditComponent", "replacementSequence", element.getReplacementSequenceElement(), -1);
        }
        if (element.hasReplacedSequenceElement()) {
            this.composeString(t, "MolecularSequenceRelativeEditComponent", "replacedSequence", element.getReplacedSequenceElement(), -1);
        }
    }

    protected void composeNamingSystem(Turtle.Complex parent, String parentType, String name, NamingSystem element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeMetadataResource(t, "NamingSystem", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "NamingSystem", "url", element.getUrlElement(), -1);
        }
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "NamingSystem", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "NamingSystem", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "NamingSystem", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "NamingSystem", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NamingSystem", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "NamingSystem", "kind", element.getKindElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "NamingSystem", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "NamingSystem", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "NamingSystem", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "NamingSystem", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasResponsibleElement()) {
            this.composeString(t, "NamingSystem", "responsible", element.getResponsibleElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NamingSystem", "type", element.getType(), -1);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "NamingSystem", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "NamingSystem", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "NamingSystem", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "NamingSystem", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "NamingSystem", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "NamingSystem", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "NamingSystem", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "NamingSystem", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getTopic().size(); ++i2) {
            this.composeCodeableConcept(t, "NamingSystem", "topic", element.getTopic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAuthor().size(); ++i2) {
            this.composeContactDetail(t, "NamingSystem", "author", element.getAuthor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEditor().size(); ++i2) {
            this.composeContactDetail(t, "NamingSystem", "editor", element.getEditor().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReviewer().size(); ++i2) {
            this.composeContactDetail(t, "NamingSystem", "reviewer", element.getReviewer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndorser().size(); ++i2) {
            this.composeContactDetail(t, "NamingSystem", "endorser", element.getEndorser().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getRelatedArtifact().size(); ++i2) {
            this.composeRelatedArtifact(t, "NamingSystem", "relatedArtifact", element.getRelatedArtifact().get(i2), i2);
        }
        if (element.hasUsageElement()) {
            this.composeString(t, "NamingSystem", "usage", element.getUsageElement(), -1);
        }
        for (i2 = 0; i2 < element.getUniqueId().size(); ++i2) {
            this.composeNamingSystemUniqueIdComponent(t, "NamingSystem", "uniqueId", element.getUniqueId().get(i2), i2);
        }
    }

    protected void composeNamingSystemUniqueIdComponent(Turtle.Complex parent, String parentType, String name, NamingSystem.NamingSystemUniqueIdComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "uniqueId", name, element, index);
        if (element.hasTypeElement()) {
            this.composeEnum(t, "NamingSystemUniqueIdComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasValueElement()) {
            this.composeString(t, "NamingSystemUniqueIdComponent", "value", element.getValueElement(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "NamingSystemUniqueIdComponent", "preferred", element.getPreferredElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "NamingSystemUniqueIdComponent", "comment", element.getCommentElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "NamingSystemUniqueIdComponent", "period", element.getPeriod(), -1);
        }
        if (element.hasAuthoritativeElement()) {
            this.composeBoolean(t, "NamingSystemUniqueIdComponent", "authoritative", element.getAuthoritativeElement(), -1);
        }
    }

    protected void composeNutritionIntake(Turtle.Complex parent, String parentType, String name, NutritionIntake element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "NutritionIntake", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "NutritionIntake", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesCanonical().size(); ++i2) {
            this.composeCanonical(t, "NutritionIntake", "instantiatesCanonical", element.getInstantiatesCanonical().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesUri().size(); ++i2) {
            this.composeUri(t, "NutritionIntake", "instantiatesUri", element.getInstantiatesUri().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "NutritionIntake", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPartOf().size(); ++i2) {
            this.composeReference(t, "NutritionIntake", "partOf", element.getPartOf().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NutritionIntake", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getStatusReason().size(); ++i2) {
            this.composeCodeableConcept(t, "NutritionIntake", "statusReason", element.getStatusReason().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "NutritionIntake", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "NutritionIntake", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "NutritionIntake", "encounter", element.getEncounter(), -1);
        }
        if (element.hasOccurrence()) {
            this.composeType(t, "NutritionIntake", "occurrence", element.getOccurrence(), -1);
        }
        if (element.hasRecordedElement()) {
            this.composeDateTime(t, "NutritionIntake", "recorded", element.getRecordedElement(), -1);
        }
        if (element.hasReported()) {
            this.composeType(t, "NutritionIntake", "reported", element.getReported(), -1);
        }
        for (i2 = 0; i2 < element.getConsumedItem().size(); ++i2) {
            this.composeNutritionIntakeConsumedItemComponent(t, "NutritionIntake", "consumedItem", element.getConsumedItem().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIngredientLabel().size(); ++i2) {
            this.composeNutritionIntakeIngredientLabelComponent(t, "NutritionIntake", "ingredientLabel", element.getIngredientLabel().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeNutritionIntakePerformerComponent(t, "NutritionIntake", "performer", element.getPerformer().get(i2), i2);
        }
        if (element.hasLocation()) {
            this.composeReference(t, "NutritionIntake", "location", element.getLocation(), -1);
        }
        for (i2 = 0; i2 < element.getDerivedFrom().size(); ++i2) {
            this.composeReference(t, "NutritionIntake", "derivedFrom", element.getDerivedFrom().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReason().size(); ++i2) {
            this.composeCodeableReference(t, "NutritionIntake", "reason", element.getReason().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "NutritionIntake", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeNutritionIntakeConsumedItemComponent(Turtle.Complex parent, String parentType, String name, NutritionIntake.NutritionIntakeConsumedItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "consumedItem", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NutritionIntakeConsumedItemComponent", "type", element.getType(), -1);
        }
        if (element.hasNutritionProduct()) {
            this.composeCodeableReference(t, "NutritionIntakeConsumedItemComponent", "nutritionProduct", element.getNutritionProduct(), -1);
        }
        if (element.hasSchedule()) {
            this.composeTiming(t, "NutritionIntakeConsumedItemComponent", "schedule", element.getSchedule(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "NutritionIntakeConsumedItemComponent", "amount", element.getAmount(), -1);
        }
        if (element.hasRate()) {
            this.composeQuantity(t, "NutritionIntakeConsumedItemComponent", "rate", element.getRate(), -1);
        }
        if (element.hasNotConsumedElement()) {
            this.composeBoolean(t, "NutritionIntakeConsumedItemComponent", "notConsumed", element.getNotConsumedElement(), -1);
        }
        if (element.hasNotConsumedReason()) {
            this.composeCodeableConcept(t, "NutritionIntakeConsumedItemComponent", "notConsumedReason", element.getNotConsumedReason(), -1);
        }
    }

    protected void composeNutritionIntakeIngredientLabelComponent(Turtle.Complex parent, String parentType, String name, NutritionIntake.NutritionIntakeIngredientLabelComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredientLabel", name, element, index);
        if (element.hasNutrient()) {
            this.composeCodeableReference(t, "NutritionIntakeIngredientLabelComponent", "nutrient", element.getNutrient(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "NutritionIntakeIngredientLabelComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeNutritionIntakePerformerComponent(Turtle.Complex parent, String parentType, String name, NutritionIntake.NutritionIntakePerformerComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "performer", name, element, index);
        if (element.hasFunction()) {
            this.composeCodeableConcept(t, "NutritionIntakePerformerComponent", "function", element.getFunction(), -1);
        }
        if (element.hasActor()) {
            this.composeReference(t, "NutritionIntakePerformerComponent", "actor", element.getActor(), -1);
        }
    }

    protected void composeNutritionOrder(Turtle.Complex parent, String parentType, String name, NutritionOrder element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "NutritionOrder", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "NutritionOrder", "identifier", element.getIdentifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesCanonical().size(); ++i2) {
            this.composeCanonical(t, "NutritionOrder", "instantiatesCanonical", element.getInstantiatesCanonical().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiatesUri().size(); ++i2) {
            this.composeUri(t, "NutritionOrder", "instantiatesUri", element.getInstantiatesUri().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstantiates().size(); ++i2) {
            this.composeUri(t, "NutritionOrder", "instantiates", element.getInstantiates().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "NutritionOrder", "basedOn", element.getBasedOn().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NutritionOrder", "status", element.getStatusElement(), -1);
        }
        if (element.hasIntentElement()) {
            this.composeEnum(t, "NutritionOrder", "intent", element.getIntentElement(), -1);
        }
        if (element.hasPriorityElement()) {
            this.composeCode(t, "NutritionOrder", "priority", element.getPriorityElement(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "NutritionOrder", "subject", element.getSubject(), -1);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "NutritionOrder", "encounter", element.getEncounter(), -1);
        }
        for (i2 = 0; i2 < element.getSupportingInformation().size(); ++i2) {
            this.composeReference(t, "NutritionOrder", "supportingInformation", element.getSupportingInformation().get(i2), i2);
        }
        if (element.hasDateTimeElement()) {
            this.composeDateTime(t, "NutritionOrder", "dateTime", element.getDateTimeElement(), -1);
        }
        if (element.hasOrderer()) {
            this.composeReference(t, "NutritionOrder", "orderer", element.getOrderer(), -1);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeCodeableReference(t, "NutritionOrder", "performer", element.getPerformer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAllergyIntolerance().size(); ++i2) {
            this.composeReference(t, "NutritionOrder", "allergyIntolerance", element.getAllergyIntolerance().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getFoodPreferenceModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "NutritionOrder", "foodPreferenceModifier", element.getFoodPreferenceModifier().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getExcludeFoodModifier().size(); ++i2) {
            this.composeCodeableConcept(t, "NutritionOrder", "excludeFoodModifier", element.getExcludeFoodModifier().get(i2), i2);
        }
        if (element.hasOutsideFoodAllowedElement()) {
            this.composeBoolean(t, "NutritionOrder", "outsideFoodAllowed", element.getOutsideFoodAllowedElement(), -1);
        }
        if (element.hasOralDiet()) {
            this.composeNutritionOrderOralDietComponent(t, "NutritionOrder", "oralDiet", element.getOralDiet(), -1);
        }
        for (i2 = 0; i2 < element.getSupplement().size(); ++i2) {
            this.composeNutritionOrderSupplementComponent(t, "NutritionOrder", "supplement", element.getSupplement().get(i2), i2);
        }
        if (element.hasEnteralFormula()) {
            this.composeNutritionOrderEnteralFormulaComponent(t, "NutritionOrder", "enteralFormula", element.getEnteralFormula(), -1);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "NutritionOrder", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeNutritionOrderOralDietComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "oralDiet", name, element, index);
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "NutritionOrderOralDietComponent", "type", element.getType().get(i2), i2);
        }
        if (element.hasSchedule()) {
            this.composeNutritionOrderOralDietScheduleComponent(t, "NutritionOrderOralDietComponent", "schedule", element.getSchedule(), -1);
        }
        for (i2 = 0; i2 < element.getNutrient().size(); ++i2) {
            this.composeNutritionOrderOralDietNutrientComponent(t, "NutritionOrderOralDietComponent", "nutrient", element.getNutrient().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTexture().size(); ++i2) {
            this.composeNutritionOrderOralDietTextureComponent(t, "NutritionOrderOralDietComponent", "texture", element.getTexture().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getFluidConsistencyType().size(); ++i2) {
            this.composeCodeableConcept(t, "NutritionOrderOralDietComponent", "fluidConsistencyType", element.getFluidConsistencyType().get(i2), i2);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "NutritionOrderOralDietComponent", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderOralDietScheduleComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.OralDietScheduleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "schedule", name, element, index);
        for (int i2 = 0; i2 < element.getTiming().size(); ++i2) {
            this.composeTiming(t, "OralDietScheduleComponent", "timing", element.getTiming().get(i2), i2);
        }
        if (element.hasAsNeededElement()) {
            this.composeBoolean(t, "OralDietScheduleComponent", "asNeeded", element.getAsNeededElement(), -1);
        }
        if (element.hasAsNeededFor()) {
            this.composeCodeableConcept(t, "OralDietScheduleComponent", "asNeededFor", element.getAsNeededFor(), -1);
        }
    }

    protected void composeNutritionOrderOralDietNutrientComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietNutrientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "nutrient", name, element, index);
        if (element.hasModifier()) {
            this.composeCodeableConcept(t, "NutritionOrderOralDietNutrientComponent", "modifier", element.getModifier(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "NutritionOrderOralDietNutrientComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeNutritionOrderOralDietTextureComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderOralDietTextureComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "texture", name, element, index);
        if (element.hasModifier()) {
            this.composeCodeableConcept(t, "NutritionOrderOralDietTextureComponent", "modifier", element.getModifier(), -1);
        }
        if (element.hasFoodType()) {
            this.composeCodeableConcept(t, "NutritionOrderOralDietTextureComponent", "foodType", element.getFoodType(), -1);
        }
    }

    protected void composeNutritionOrderSupplementComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderSupplementComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "supplement", name, element, index);
        if (element.hasType()) {
            this.composeCodeableReference(t, "NutritionOrderSupplementComponent", "type", element.getType(), -1);
        }
        if (element.hasProductNameElement()) {
            this.composeString(t, "NutritionOrderSupplementComponent", "productName", element.getProductNameElement(), -1);
        }
        if (element.hasSchedule()) {
            this.composeNutritionOrderSupplementScheduleComponent(t, "NutritionOrderSupplementComponent", "schedule", element.getSchedule(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrderSupplementComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasInstructionElement()) {
            this.composeString(t, "NutritionOrderSupplementComponent", "instruction", element.getInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderSupplementScheduleComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.SupplementScheduleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "schedule", name, element, index);
        for (int i2 = 0; i2 < element.getTiming().size(); ++i2) {
            this.composeTiming(t, "SupplementScheduleComponent", "timing", element.getTiming().get(i2), i2);
        }
        if (element.hasAsNeededElement()) {
            this.composeBoolean(t, "SupplementScheduleComponent", "asNeeded", element.getAsNeededElement(), -1);
        }
        if (element.hasAsNeededFor()) {
            this.composeCodeableConcept(t, "SupplementScheduleComponent", "asNeededFor", element.getAsNeededFor(), -1);
        }
    }

    protected void composeNutritionOrderEnteralFormulaComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "enteralFormula", name, element, index);
        if (element.hasBaseFormulaType()) {
            this.composeCodeableReference(t, "NutritionOrderEnteralFormulaComponent", "baseFormulaType", element.getBaseFormulaType(), -1);
        }
        if (element.hasBaseFormulaProductNameElement()) {
            this.composeString(t, "NutritionOrderEnteralFormulaComponent", "baseFormulaProductName", element.getBaseFormulaProductNameElement(), -1);
        }
        for (i2 = 0; i2 < element.getDeliveryDevice().size(); ++i2) {
            this.composeCodeableReference(t, "NutritionOrderEnteralFormulaComponent", "deliveryDevice", element.getDeliveryDevice().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAdditive().size(); ++i2) {
            this.composeNutritionOrderEnteralFormulaAdditiveComponent(t, "NutritionOrderEnteralFormulaComponent", "additive", element.getAdditive().get(i2), i2);
        }
        if (element.hasCaloricDensity()) {
            this.composeQuantity(t, "NutritionOrderEnteralFormulaComponent", "caloricDensity", element.getCaloricDensity(), -1);
        }
        if (element.hasRouteOfAdministration()) {
            this.composeCodeableConcept(t, "NutritionOrderEnteralFormulaComponent", "routeOfAdministration", element.getRouteOfAdministration(), -1);
        }
        for (i2 = 0; i2 < element.getAdministration().size(); ++i2) {
            this.composeNutritionOrderEnteralFormulaAdministrationComponent(t, "NutritionOrderEnteralFormulaComponent", "administration", element.getAdministration().get(i2), i2);
        }
        if (element.hasMaxVolumeToDeliver()) {
            this.composeQuantity(t, "NutritionOrderEnteralFormulaComponent", "maxVolumeToDeliver", element.getMaxVolumeToDeliver(), -1);
        }
        if (element.hasAdministrationInstructionElement()) {
            this.composeString(t, "NutritionOrderEnteralFormulaComponent", "administrationInstruction", element.getAdministrationInstructionElement(), -1);
        }
    }

    protected void composeNutritionOrderEnteralFormulaAdditiveComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaAdditiveComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "additive", name, element, index);
        if (element.hasType()) {
            this.composeCodeableReference(t, "NutritionOrderEnteralFormulaAdditiveComponent", "type", element.getType(), -1);
        }
        if (element.hasProductNameElement()) {
            this.composeString(t, "NutritionOrderEnteralFormulaAdditiveComponent", "productName", element.getProductNameElement(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrderEnteralFormulaAdditiveComponent", "quantity", element.getQuantity(), -1);
        }
    }

    protected void composeNutritionOrderEnteralFormulaAdministrationComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "administration", name, element, index);
        if (element.hasSchedule()) {
            this.composeNutritionOrderEnteralFormulaScheduleComponent(t, "NutritionOrderEnteralFormulaAdministrationComponent", "schedule", element.getSchedule(), -1);
        }
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionOrderEnteralFormulaAdministrationComponent", "quantity", element.getQuantity(), -1);
        }
        if (element.hasRate()) {
            this.composeType(t, "NutritionOrderEnteralFormulaAdministrationComponent", "rate", element.getRate(), -1);
        }
    }

    protected void composeNutritionOrderEnteralFormulaScheduleComponent(Turtle.Complex parent, String parentType, String name, NutritionOrder.EnteralFormulaScheduleComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "schedule", name, element, index);
        for (int i2 = 0; i2 < element.getTiming().size(); ++i2) {
            this.composeTiming(t, "EnteralFormulaScheduleComponent", "timing", element.getTiming().get(i2), i2);
        }
        if (element.hasAsNeededElement()) {
            this.composeBoolean(t, "EnteralFormulaScheduleComponent", "asNeeded", element.getAsNeededElement(), -1);
        }
        if (element.hasAsNeededFor()) {
            this.composeCodeableConcept(t, "EnteralFormulaScheduleComponent", "asNeededFor", element.getAsNeededFor(), -1);
        }
    }

    protected void composeNutritionProduct(Turtle.Complex parent, String parentType, String name, NutritionProduct element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "NutritionProduct", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "NutritionProduct", "code", element.getCode(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "NutritionProduct", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "NutritionProduct", "category", element.getCategory().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getManufacturer().size(); ++i2) {
            this.composeReference(t, "NutritionProduct", "manufacturer", element.getManufacturer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNutrient().size(); ++i2) {
            this.composeNutritionProductNutrientComponent(t, "NutritionProduct", "nutrient", element.getNutrient().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getIngredient().size(); ++i2) {
            this.composeNutritionProductIngredientComponent(t, "NutritionProduct", "ingredient", element.getIngredient().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getKnownAllergen().size(); ++i2) {
            this.composeCodeableReference(t, "NutritionProduct", "knownAllergen", element.getKnownAllergen().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCharacteristic().size(); ++i2) {
            this.composeNutritionProductCharacteristicComponent(t, "NutritionProduct", "characteristic", element.getCharacteristic().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getInstance().size(); ++i2) {
            this.composeNutritionProductInstanceComponent(t, "NutritionProduct", "instance", element.getInstance().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "NutritionProduct", "note", element.getNote().get(i2), i2);
        }
    }

    protected void composeNutritionProductNutrientComponent(Turtle.Complex parent, String parentType, String name, NutritionProduct.NutritionProductNutrientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "nutrient", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableReference(t, "NutritionProductNutrientComponent", "item", element.getItem(), -1);
        }
        for (int i2 = 0; i2 < element.getAmount().size(); ++i2) {
            this.composeRatio(t, "NutritionProductNutrientComponent", "amount", element.getAmount().get(i2), i2);
        }
    }

    protected void composeNutritionProductIngredientComponent(Turtle.Complex parent, String parentType, String name, NutritionProduct.NutritionProductIngredientComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "ingredient", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableReference(t, "NutritionProductIngredientComponent", "item", element.getItem(), -1);
        }
        for (int i2 = 0; i2 < element.getAmount().size(); ++i2) {
            this.composeRatio(t, "NutritionProductIngredientComponent", "amount", element.getAmount().get(i2), i2);
        }
    }

    protected void composeNutritionProductCharacteristicComponent(Turtle.Complex parent, String parentType, String name, NutritionProduct.NutritionProductCharacteristicComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "characteristic", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "NutritionProductCharacteristicComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "NutritionProductCharacteristicComponent", "value", element.getValue(), -1);
        }
    }

    protected void composeNutritionProductInstanceComponent(Turtle.Complex parent, String parentType, String name, NutritionProduct.NutritionProductInstanceComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "instance", name, element, index);
        if (element.hasQuantity()) {
            this.composeQuantity(t, "NutritionProductInstanceComponent", "quantity", element.getQuantity(), -1);
        }
        for (int i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "NutritionProductInstanceComponent", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "NutritionProductInstanceComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasLotNumberElement()) {
            this.composeString(t, "NutritionProductInstanceComponent", "lotNumber", element.getLotNumberElement(), -1);
        }
        if (element.hasExpiryElement()) {
            this.composeDateTime(t, "NutritionProductInstanceComponent", "expiry", element.getExpiryElement(), -1);
        }
        if (element.hasUseByElement()) {
            this.composeDateTime(t, "NutritionProductInstanceComponent", "useBy", element.getUseByElement(), -1);
        }
        if (element.hasBiologicalSourceEvent()) {
            this.composeIdentifier(t, "NutritionProductInstanceComponent", "biologicalSourceEvent", element.getBiologicalSourceEvent(), -1);
        }
    }

    protected void composeObservation(Turtle.Complex parent, String parentType, String name, Observation element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Observation", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Observation", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasInstantiates()) {
            this.composeType(t, "Observation", "instantiates", element.getInstantiates(), -1);
        }
        for (i2 = 0; i2 < element.getBasedOn().size(); ++i2) {
            this.composeReference(t, "Observation", "basedOn", element.getBasedOn().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTriggeredBy().size(); ++i2) {
            this.composeObservationTriggeredByComponent(t, "Observation", "triggeredBy", element.getTriggeredBy().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPartOf().size(); ++i2) {
            this.composeReference(t, "Observation", "partOf", element.getPartOf().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "Observation", "status", element.getStatusElement(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "Observation", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "Observation", "code", element.getCode(), -1);
        }
        if (element.hasSubject()) {
            this.composeReference(t, "Observation", "subject", element.getSubject(), -1);
        }
        for (i2 = 0; i2 < element.getFocus().size(); ++i2) {
            this.composeReference(t, "Observation", "focus", element.getFocus().get(i2), i2);
        }
        if (element.hasEncounter()) {
            this.composeReference(t, "Observation", "encounter", element.getEncounter(), -1);
        }
        if (element.hasEffective()) {
            this.composeType(t, "Observation", "effective", element.getEffective(), -1);
        }
        if (element.hasIssuedElement()) {
            this.composeInstant(t, "Observation", "issued", element.getIssuedElement(), -1);
        }
        for (i2 = 0; i2 < element.getPerformer().size(); ++i2) {
            this.composeReference(t, "Observation", "performer", element.getPerformer().get(i2), i2);
        }
        if (element.hasValue()) {
            this.composeType(t, "Observation", "value", element.getValue(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "Observation", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        for (i2 = 0; i2 < element.getInterpretation().size(); ++i2) {
            this.composeCodeableConcept(t, "Observation", "interpretation", element.getInterpretation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getNote().size(); ++i2) {
            this.composeAnnotation(t, "Observation", "note", element.getNote().get(i2), i2);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "Observation", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasBodyStructure()) {
            this.composeReference(t, "Observation", "bodyStructure", element.getBodyStructure(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "Observation", "method", element.getMethod(), -1);
        }
        if (element.hasSpecimen()) {
            this.composeReference(t, "Observation", "specimen", element.getSpecimen(), -1);
        }
        if (element.hasDevice()) {
            this.composeReference(t, "Observation", "device", element.getDevice(), -1);
        }
        for (i2 = 0; i2 < element.getReferenceRange().size(); ++i2) {
            this.composeObservationReferenceRangeComponent(t, "Observation", "referenceRange", element.getReferenceRange().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getHasMember().size(); ++i2) {
            this.composeReference(t, "Observation", "hasMember", element.getHasMember().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDerivedFrom().size(); ++i2) {
            this.composeReference(t, "Observation", "derivedFrom", element.getDerivedFrom().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getComponent().size(); ++i2) {
            this.composeObservationComponentComponent(t, "Observation", "component", element.getComponent().get(i2), i2);
        }
    }

    protected void composeObservationTriggeredByComponent(Turtle.Complex parent, String parentType, String name, Observation.ObservationTriggeredByComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "triggeredBy", name, element, index);
        if (element.hasObservation()) {
            this.composeReference(t, "ObservationTriggeredByComponent", "observation", element.getObservation(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "ObservationTriggeredByComponent", "type", element.getTypeElement(), -1);
        }
        if (element.hasReasonElement()) {
            this.composeString(t, "ObservationTriggeredByComponent", "reason", element.getReasonElement(), -1);
        }
    }

    protected void composeObservationReferenceRangeComponent(Turtle.Complex parent, String parentType, String name, Observation.ObservationReferenceRangeComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referenceRange", name, element, index);
        if (element.hasLow()) {
            this.composeQuantity(t, "ObservationReferenceRangeComponent", "low", element.getLow(), -1);
        }
        if (element.hasHigh()) {
            this.composeQuantity(t, "ObservationReferenceRangeComponent", "high", element.getHigh(), -1);
        }
        if (element.hasNormalValue()) {
            this.composeCodeableConcept(t, "ObservationReferenceRangeComponent", "normalValue", element.getNormalValue(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "ObservationReferenceRangeComponent", "type", element.getType(), -1);
        }
        for (int i2 = 0; i2 < element.getAppliesTo().size(); ++i2) {
            this.composeCodeableConcept(t, "ObservationReferenceRangeComponent", "appliesTo", element.getAppliesTo().get(i2), i2);
        }
        if (element.hasAge()) {
            this.composeRange(t, "ObservationReferenceRangeComponent", "age", element.getAge(), -1);
        }
        if (element.hasTextElement()) {
            this.composeString(t, "ObservationReferenceRangeComponent", "text", element.getTextElement(), -1);
        }
    }

    protected void composeObservationComponentComponent(Turtle.Complex parent, String parentType, String name, Observation.ObservationComponentComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ObservationComponentComponent", "code", element.getCode(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ObservationComponentComponent", "value", element.getValue(), -1);
        }
        if (element.hasDataAbsentReason()) {
            this.composeCodeableConcept(t, "ObservationComponentComponent", "dataAbsentReason", element.getDataAbsentReason(), -1);
        }
        for (i2 = 0; i2 < element.getInterpretation().size(); ++i2) {
            this.composeCodeableConcept(t, "ObservationComponentComponent", "interpretation", element.getInterpretation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getReferenceRange().size(); ++i2) {
            this.composeObservationReferenceRangeComponent(t, "ObservationComponentComponent", "referenceRange", element.getReferenceRange().get(i2), i2);
        }
    }

    protected void composeObservationDefinition(Turtle.Complex parent, String parentType, String name, ObservationDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "ObservationDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "ObservationDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasIdentifier()) {
            this.composeIdentifier(t, "ObservationDefinition", "identifier", element.getIdentifier(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "ObservationDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "ObservationDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "ObservationDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "ObservationDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "ObservationDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "ObservationDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "ObservationDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "ObservationDefinition", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "ObservationDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "ObservationDefinition", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "ObservationDefinition", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "ObservationDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "ObservationDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasApprovalDateElement()) {
            this.composeDate(t, "ObservationDefinition", "approvalDate", element.getApprovalDateElement(), -1);
        }
        if (element.hasLastReviewDateElement()) {
            this.composeDate(t, "ObservationDefinition", "lastReviewDate", element.getLastReviewDateElement(), -1);
        }
        if (element.hasEffectivePeriod()) {
            this.composePeriod(t, "ObservationDefinition", "effectivePeriod", element.getEffectivePeriod(), -1);
        }
        for (i2 = 0; i2 < element.getDerivedFromCanonical().size(); ++i2) {
            this.composeCanonical(t, "ObservationDefinition", "derivedFromCanonical", element.getDerivedFromCanonical().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDerivedFromUri().size(); ++i2) {
            this.composeUri(t, "ObservationDefinition", "derivedFromUri", element.getDerivedFromUri().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSubject().size(); ++i2) {
            this.composeCodeableConcept(t, "ObservationDefinition", "subject", element.getSubject().get(i2), i2);
        }
        if (element.hasPerformerType()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "performerType", element.getPerformerType(), -1);
        }
        for (i2 = 0; i2 < element.getCategory().size(); ++i2) {
            this.composeCodeableConcept(t, "ObservationDefinition", "category", element.getCategory().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "code", element.getCode(), -1);
        }
        for (i2 = 0; i2 < element.getPermittedDataType().size(); ++i2) {
            this.composeEnum(t, "ObservationDefinition", "permittedDataType", element.getPermittedDataType().get(i2), i2);
        }
        if (element.hasMultipleResultsAllowedElement()) {
            this.composeBoolean(t, "ObservationDefinition", "multipleResultsAllowed", element.getMultipleResultsAllowedElement(), -1);
        }
        if (element.hasBodySite()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "bodySite", element.getBodySite(), -1);
        }
        if (element.hasMethod()) {
            this.composeCodeableConcept(t, "ObservationDefinition", "method", element.getMethod(), -1);
        }
        for (i2 = 0; i2 < element.getSpecimen().size(); ++i2) {
            this.composeReference(t, "ObservationDefinition", "specimen", element.getSpecimen().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getDevice().size(); ++i2) {
            this.composeReference(t, "ObservationDefinition", "device", element.getDevice().get(i2), i2);
        }
        if (element.hasPreferredReportNameElement()) {
            this.composeString(t, "ObservationDefinition", "preferredReportName", element.getPreferredReportNameElement(), -1);
        }
        if (element.hasQuantitativeDetails()) {
            this.composeObservationDefinitionQuantitativeDetailsComponent(t, "ObservationDefinition", "quantitativeDetails", element.getQuantitativeDetails(), -1);
        }
        for (i2 = 0; i2 < element.getQualifiedValue().size(); ++i2) {
            this.composeObservationDefinitionQualifiedValueComponent(t, "ObservationDefinition", "qualifiedValue", element.getQualifiedValue().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getHasMember().size(); ++i2) {
            this.composeReference(t, "ObservationDefinition", "hasMember", element.getHasMember().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getComponent().size(); ++i2) {
            this.composeObservationDefinitionComponentComponent(t, "ObservationDefinition", "component", element.getComponent().get(i2), i2);
        }
    }

    protected void composeObservationDefinitionQuantitativeDetailsComponent(Turtle.Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQuantitativeDetailsComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "quantitativeDetails", name, element, index);
        if (element.hasUnit()) {
            this.composeCodeableConcept(t, "ObservationDefinitionQuantitativeDetailsComponent", "unit", element.getUnit(), -1);
        }
        if (element.hasCustomaryUnit()) {
            this.composeCodeableConcept(t, "ObservationDefinitionQuantitativeDetailsComponent", "customaryUnit", element.getCustomaryUnit(), -1);
        }
        if (element.hasConversionFactorElement()) {
            this.composeDecimal(t, "ObservationDefinitionQuantitativeDetailsComponent", "conversionFactor", element.getConversionFactorElement(), -1);
        }
        if (element.hasDecimalPrecisionElement()) {
            this.composeInteger(t, "ObservationDefinitionQuantitativeDetailsComponent", "decimalPrecision", element.getDecimalPrecisionElement(), -1);
        }
    }

    protected void composeObservationDefinitionQualifiedValueComponent(Turtle.Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionQualifiedValueComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "qualifiedValue", name, element, index);
        if (element.hasContext()) {
            this.composeCodeableConcept(t, "ObservationDefinitionQualifiedValueComponent", "context", element.getContext(), -1);
        }
        for (int i2 = 0; i2 < element.getAppliesTo().size(); ++i2) {
            this.composeCodeableConcept(t, "ObservationDefinitionQualifiedValueComponent", "appliesTo", element.getAppliesTo().get(i2), i2);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "ObservationDefinitionQualifiedValueComponent", "gender", element.getGenderElement(), -1);
        }
        if (element.hasAge()) {
            this.composeRange(t, "ObservationDefinitionQualifiedValueComponent", "age", element.getAge(), -1);
        }
        if (element.hasGestationalAge()) {
            this.composeRange(t, "ObservationDefinitionQualifiedValueComponent", "gestationalAge", element.getGestationalAge(), -1);
        }
        if (element.hasConditionElement()) {
            this.composeString(t, "ObservationDefinitionQualifiedValueComponent", "condition", element.getConditionElement(), -1);
        }
        if (element.hasRangeCategoryElement()) {
            this.composeEnum(t, "ObservationDefinitionQualifiedValueComponent", "rangeCategory", element.getRangeCategoryElement(), -1);
        }
        if (element.hasRange()) {
            this.composeRange(t, "ObservationDefinitionQualifiedValueComponent", "range", element.getRange(), -1);
        }
        if (element.hasValidCodedValueSetElement()) {
            this.composeCanonical(t, "ObservationDefinitionQualifiedValueComponent", "validCodedValueSet", element.getValidCodedValueSetElement(), -1);
        }
        if (element.hasNormalCodedValueSetElement()) {
            this.composeCanonical(t, "ObservationDefinitionQualifiedValueComponent", "normalCodedValueSet", element.getNormalCodedValueSetElement(), -1);
        }
        if (element.hasAbnormalCodedValueSetElement()) {
            this.composeCanonical(t, "ObservationDefinitionQualifiedValueComponent", "abnormalCodedValueSet", element.getAbnormalCodedValueSetElement(), -1);
        }
        if (element.hasCriticalCodedValueSetElement()) {
            this.composeCanonical(t, "ObservationDefinitionQualifiedValueComponent", "criticalCodedValueSet", element.getCriticalCodedValueSetElement(), -1);
        }
    }

    protected void composeObservationDefinitionComponentComponent(Turtle.Complex parent, String parentType, String name, ObservationDefinition.ObservationDefinitionComponentComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "component", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "ObservationDefinitionComponentComponent", "code", element.getCode(), -1);
        }
        for (i2 = 0; i2 < element.getPermittedDataType().size(); ++i2) {
            this.composeEnum(t, "ObservationDefinitionComponentComponent", "permittedDataType", element.getPermittedDataType().get(i2), i2);
        }
        if (element.hasQuantitativeDetails()) {
            this.composeObservationDefinitionQuantitativeDetailsComponent(t, "ObservationDefinitionComponentComponent", "quantitativeDetails", element.getQuantitativeDetails(), -1);
        }
        for (i2 = 0; i2 < element.getQualifiedValue().size(); ++i2) {
            this.composeObservationDefinitionQualifiedValueComponent(t, "ObservationDefinitionComponentComponent", "qualifiedValue", element.getQualifiedValue().get(i2), i2);
        }
    }

    protected void composeOperationDefinition(Turtle.Complex parent, String parentType, String name, OperationDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeCanonicalResource(t, "OperationDefinition", name, element, index);
        if (element.hasUrlElement()) {
            this.composeUri(t, "OperationDefinition", "url", element.getUrlElement(), -1);
        }
        if (element.hasVersionElement()) {
            this.composeString(t, "OperationDefinition", "version", element.getVersionElement(), -1);
        }
        if (element.hasVersionAlgorithm()) {
            this.composeType(t, "OperationDefinition", "versionAlgorithm", element.getVersionAlgorithm(), -1);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "OperationDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasTitleElement()) {
            this.composeString(t, "OperationDefinition", "title", element.getTitleElement(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "OperationDefinition", "status", element.getStatusElement(), -1);
        }
        if (element.hasKindElement()) {
            this.composeEnum(t, "OperationDefinition", "kind", element.getKindElement(), -1);
        }
        if (element.hasExperimentalElement()) {
            this.composeBoolean(t, "OperationDefinition", "experimental", element.getExperimentalElement(), -1);
        }
        if (element.hasDateElement()) {
            this.composeDateTime(t, "OperationDefinition", "date", element.getDateElement(), -1);
        }
        if (element.hasPublisherElement()) {
            this.composeString(t, "OperationDefinition", "publisher", element.getPublisherElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeContactDetail(t, "OperationDefinition", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "OperationDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getUseContext().size(); ++i2) {
            this.composeUsageContext(t, "OperationDefinition", "useContext", element.getUseContext().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getJurisdiction().size(); ++i2) {
            this.composeCodeableConcept(t, "OperationDefinition", "jurisdiction", element.getJurisdiction().get(i2), i2);
        }
        if (element.hasPurposeElement()) {
            this.composeMarkdown(t, "OperationDefinition", "purpose", element.getPurposeElement(), -1);
        }
        if (element.hasCopyrightElement()) {
            this.composeMarkdown(t, "OperationDefinition", "copyright", element.getCopyrightElement(), -1);
        }
        if (element.hasCopyrightLabelElement()) {
            this.composeString(t, "OperationDefinition", "copyrightLabel", element.getCopyrightLabelElement(), -1);
        }
        if (element.hasAffectsStateElement()) {
            this.composeBoolean(t, "OperationDefinition", "affectsState", element.getAffectsStateElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeCode(t, "OperationDefinition", "code", element.getCodeElement(), -1);
        }
        if (element.hasCommentElement()) {
            this.composeMarkdown(t, "OperationDefinition", "comment", element.getCommentElement(), -1);
        }
        if (element.hasBaseElement()) {
            this.composeCanonical(t, "OperationDefinition", "base", element.getBaseElement(), -1);
        }
        for (i2 = 0; i2 < element.getResource().size(); ++i2) {
            this.composeCode(t, "OperationDefinition", "resource", element.getResource().get(i2), i2);
        }
        if (element.hasSystemElement()) {
            this.composeBoolean(t, "OperationDefinition", "system", element.getSystemElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeBoolean(t, "OperationDefinition", "type", element.getTypeElement(), -1);
        }
        if (element.hasInstanceElement()) {
            this.composeBoolean(t, "OperationDefinition", "instance", element.getInstanceElement(), -1);
        }
        if (element.hasInputProfileElement()) {
            this.composeCanonical(t, "OperationDefinition", "inputProfile", element.getInputProfileElement(), -1);
        }
        if (element.hasOutputProfileElement()) {
            this.composeCanonical(t, "OperationDefinition", "outputProfile", element.getOutputProfileElement(), -1);
        }
        for (i2 = 0; i2 < element.getParameter().size(); ++i2) {
            this.composeOperationDefinitionParameterComponent(t, "OperationDefinition", "parameter", element.getParameter().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getOverload().size(); ++i2) {
            this.composeOperationDefinitionOverloadComponent(t, "OperationDefinition", "overload", element.getOverload().get(i2), i2);
        }
    }

    protected void composeOperationDefinitionParameterComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeCode(t, "OperationDefinitionParameterComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasUseElement()) {
            this.composeEnum(t, "OperationDefinitionParameterComponent", "use", element.getUseElement(), -1);
        }
        for (i2 = 0; i2 < element.getScope().size(); ++i2) {
            this.composeEnum(t, "OperationDefinitionParameterComponent", "scope", element.getScope().get(i2), i2);
        }
        if (element.hasMinElement()) {
            this.composeInteger(t, "OperationDefinitionParameterComponent", "min", element.getMinElement(), -1);
        }
        if (element.hasMaxElement()) {
            this.composeString(t, "OperationDefinitionParameterComponent", "max", element.getMaxElement(), -1);
        }
        if (element.hasDocumentationElement()) {
            this.composeMarkdown(t, "OperationDefinitionParameterComponent", "documentation", element.getDocumentationElement(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "OperationDefinitionParameterComponent", "type", element.getTypeElement(), -1);
        }
        for (i2 = 0; i2 < element.getAllowedType().size(); ++i2) {
            this.composeEnum(t, "OperationDefinitionParameterComponent", "allowedType", element.getAllowedType().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTargetProfile().size(); ++i2) {
            this.composeCanonical(t, "OperationDefinitionParameterComponent", "targetProfile", element.getTargetProfile().get(i2), i2);
        }
        if (element.hasSearchTypeElement()) {
            this.composeEnum(t, "OperationDefinitionParameterComponent", "searchType", element.getSearchTypeElement(), -1);
        }
        if (element.hasBinding()) {
            this.composeOperationDefinitionParameterBindingComponent(t, "OperationDefinitionParameterComponent", "binding", element.getBinding(), -1);
        }
        for (i2 = 0; i2 < element.getReferencedFrom().size(); ++i2) {
            this.composeOperationDefinitionParameterReferencedFromComponent(t, "OperationDefinitionParameterComponent", "referencedFrom", element.getReferencedFrom().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPart().size(); ++i2) {
            this.composeOperationDefinitionParameterComponent(t, "OperationDefinitionParameterComponent", "part", element.getPart().get(i2), i2);
        }
    }

    protected void composeOperationDefinitionParameterBindingComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterBindingComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "binding", name, element, index);
        if (element.hasStrengthElement()) {
            this.composeEnum(t, "OperationDefinitionParameterBindingComponent", "strength", element.getStrengthElement(), -1);
        }
        if (element.hasValueSetElement()) {
            this.composeCanonical(t, "OperationDefinitionParameterBindingComponent", "valueSet", element.getValueSetElement(), -1);
        }
    }

    protected void composeOperationDefinitionParameterReferencedFromComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionParameterReferencedFromComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "referencedFrom", name, element, index);
        if (element.hasSourceElement()) {
            this.composeString(t, "OperationDefinitionParameterReferencedFromComponent", "source", element.getSourceElement(), -1);
        }
        if (element.hasSourceIdElement()) {
            this.composeString(t, "OperationDefinitionParameterReferencedFromComponent", "sourceId", element.getSourceIdElement(), -1);
        }
    }

    protected void composeOperationDefinitionOverloadComponent(Turtle.Complex parent, String parentType, String name, OperationDefinition.OperationDefinitionOverloadComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "overload", name, element, index);
        for (int i2 = 0; i2 < element.getParameterName().size(); ++i2) {
            this.composeString(t, "OperationDefinitionOverloadComponent", "parameterName", element.getParameterName().get(i2), i2);
        }
        if (element.hasCommentElement()) {
            this.composeString(t, "OperationDefinitionOverloadComponent", "comment", element.getCommentElement(), -1);
        }
    }

    protected void composeOperationOutcome(Turtle.Complex parent, String parentType, String name, OperationOutcome element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OperationOutcome", name, element, index);
        for (int i2 = 0; i2 < element.getIssue().size(); ++i2) {
            this.composeOperationOutcomeIssueComponent(t, "OperationOutcome", "issue", element.getIssue().get(i2), i2);
        }
    }

    protected void composeOperationOutcomeIssueComponent(Turtle.Complex parent, String parentType, String name, OperationOutcome.OperationOutcomeIssueComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "issue", name, element, index);
        if (element.hasSeverityElement()) {
            this.composeEnum(t, "OperationOutcomeIssueComponent", "severity", element.getSeverityElement(), -1);
        }
        if (element.hasCodeElement()) {
            this.composeEnum(t, "OperationOutcomeIssueComponent", "code", element.getCodeElement(), -1);
        }
        if (element.hasDetails()) {
            this.composeCodeableConcept(t, "OperationOutcomeIssueComponent", "details", element.getDetails(), -1);
        }
        if (element.hasDiagnosticsElement()) {
            this.composeString(t, "OperationOutcomeIssueComponent", "diagnostics", element.getDiagnosticsElement(), -1);
        }
        for (i2 = 0; i2 < element.getLocation().size(); ++i2) {
            this.composeString(t, "OperationOutcomeIssueComponent", "location", element.getLocation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getExpression().size(); ++i2) {
            this.composeString(t, "OperationOutcomeIssueComponent", "expression", element.getExpression().get(i2), i2);
        }
    }

    protected void composeOrganization(Turtle.Complex parent, String parentType, String name, Organization element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Organization", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Organization", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Organization", "active", element.getActiveElement(), -1);
        }
        for (i2 = 0; i2 < element.getType().size(); ++i2) {
            this.composeCodeableConcept(t, "Organization", "type", element.getType().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "Organization", "name", element.getNameElement(), -1);
        }
        for (i2 = 0; i2 < element.getAlias().size(); ++i2) {
            this.composeString(t, "Organization", "alias", element.getAlias().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeString(t, "Organization", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeExtendedContactDetail(t, "Organization", "contact", element.getContact().get(i2), i2);
        }
        if (element.hasPartOf()) {
            this.composeReference(t, "Organization", "partOf", element.getPartOf(), -1);
        }
        for (i2 = 0; i2 < element.getEndpoint().size(); ++i2) {
            this.composeReference(t, "Organization", "endpoint", element.getEndpoint().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getQualification().size(); ++i2) {
            this.composeOrganizationQualificationComponent(t, "Organization", "qualification", element.getQualification().get(i2), i2);
        }
    }

    protected void composeOrganizationQualificationComponent(Turtle.Complex parent, String parentType, String name, Organization.OrganizationQualificationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "qualification", name, element, index);
        for (int i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "OrganizationQualificationComponent", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "OrganizationQualificationComponent", "code", element.getCode(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "OrganizationQualificationComponent", "period", element.getPeriod(), -1);
        }
        if (element.hasIssuer()) {
            this.composeReference(t, "OrganizationQualificationComponent", "issuer", element.getIssuer(), -1);
        }
    }

    protected void composeOrganizationAffiliation(Turtle.Complex parent, String parentType, String name, OrganizationAffiliation element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "OrganizationAffiliation", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "OrganizationAffiliation", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "OrganizationAffiliation", "active", element.getActiveElement(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "OrganizationAffiliation", "period", element.getPeriod(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "OrganizationAffiliation", "organization", element.getOrganization(), -1);
        }
        if (element.hasParticipatingOrganization()) {
            this.composeReference(t, "OrganizationAffiliation", "participatingOrganization", element.getParticipatingOrganization(), -1);
        }
        for (i2 = 0; i2 < element.getNetwork().size(); ++i2) {
            this.composeReference(t, "OrganizationAffiliation", "network", element.getNetwork().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCode().size(); ++i2) {
            this.composeCodeableConcept(t, "OrganizationAffiliation", "code", element.getCode().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getSpecialty().size(); ++i2) {
            this.composeCodeableConcept(t, "OrganizationAffiliation", "specialty", element.getSpecialty().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getLocation().size(); ++i2) {
            this.composeReference(t, "OrganizationAffiliation", "location", element.getLocation().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getHealthcareService().size(); ++i2) {
            this.composeReference(t, "OrganizationAffiliation", "healthcareService", element.getHealthcareService().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composeExtendedContactDetail(t, "OrganizationAffiliation", "contact", element.getContact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getEndpoint().size(); ++i2) {
            this.composeReference(t, "OrganizationAffiliation", "endpoint", element.getEndpoint().get(i2), i2);
        }
    }

    protected void composePackagedProductDefinition(Turtle.Complex parent, String parentType, String name, PackagedProductDefinition element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PackagedProductDefinition", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "PackagedProductDefinition", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasNameElement()) {
            this.composeString(t, "PackagedProductDefinition", "name", element.getNameElement(), -1);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PackagedProductDefinition", "type", element.getType(), -1);
        }
        for (i2 = 0; i2 < element.getPackageFor().size(); ++i2) {
            this.composeReference(t, "PackagedProductDefinition", "packageFor", element.getPackageFor().get(i2), i2);
        }
        if (element.hasStatus()) {
            this.composeCodeableConcept(t, "PackagedProductDefinition", "status", element.getStatus(), -1);
        }
        if (element.hasStatusDateElement()) {
            this.composeDateTime(t, "PackagedProductDefinition", "statusDate", element.getStatusDateElement(), -1);
        }
        for (i2 = 0; i2 < element.getContainedItemQuantity().size(); ++i2) {
            this.composeQuantity(t, "PackagedProductDefinition", "containedItemQuantity", element.getContainedItemQuantity().get(i2), i2);
        }
        if (element.hasDescriptionElement()) {
            this.composeMarkdown(t, "PackagedProductDefinition", "description", element.getDescriptionElement(), -1);
        }
        for (i2 = 0; i2 < element.getLegalStatusOfSupply().size(); ++i2) {
            this.composePackagedProductDefinitionLegalStatusOfSupplyComponent(t, "PackagedProductDefinition", "legalStatusOfSupply", element.getLegalStatusOfSupply().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getMarketingStatus().size(); ++i2) {
            this.composeMarketingStatus(t, "PackagedProductDefinition", "marketingStatus", element.getMarketingStatus().get(i2), i2);
        }
        if (element.hasCopackagedIndicatorElement()) {
            this.composeBoolean(t, "PackagedProductDefinition", "copackagedIndicator", element.getCopackagedIndicatorElement(), -1);
        }
        for (i2 = 0; i2 < element.getManufacturer().size(); ++i2) {
            this.composeReference(t, "PackagedProductDefinition", "manufacturer", element.getManufacturer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAttachedDocument().size(); ++i2) {
            this.composeReference(t, "PackagedProductDefinition", "attachedDocument", element.getAttachedDocument().get(i2), i2);
        }
        if (element.hasPackaging()) {
            this.composePackagedProductDefinitionPackagingComponent(t, "PackagedProductDefinition", "packaging", element.getPackaging(), -1);
        }
        for (i2 = 0; i2 < element.getCharacteristic().size(); ++i2) {
            this.composePackagedProductDefinitionPackagingPropertyComponent(t, "PackagedProductDefinition", "characteristic", element.getCharacteristic().get(i2), i2);
        }
    }

    protected void composePackagedProductDefinitionLegalStatusOfSupplyComponent(Turtle.Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionLegalStatusOfSupplyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "legalStatusOfSupply", name, element, index);
        if (element.hasCode()) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionLegalStatusOfSupplyComponent", "code", element.getCode(), -1);
        }
        if (element.hasJurisdiction()) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionLegalStatusOfSupplyComponent", "jurisdiction", element.getJurisdiction(), -1);
        }
    }

    protected void composePackagedProductDefinitionPackagingComponent(Turtle.Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackagingComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "packaging", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "PackagedProductDefinitionPackagingComponent", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionPackagingComponent", "type", element.getType(), -1);
        }
        if (element.hasComponentPartElement()) {
            this.composeBoolean(t, "PackagedProductDefinitionPackagingComponent", "componentPart", element.getComponentPartElement(), -1);
        }
        if (element.hasQuantityElement()) {
            this.composeInteger(t, "PackagedProductDefinitionPackagingComponent", "quantity", element.getQuantityElement(), -1);
        }
        for (i2 = 0; i2 < element.getMaterial().size(); ++i2) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionPackagingComponent", "material", element.getMaterial().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getAlternateMaterial().size(); ++i2) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionPackagingComponent", "alternateMaterial", element.getAlternateMaterial().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getShelfLifeStorage().size(); ++i2) {
            this.composeProductShelfLife(t, "PackagedProductDefinitionPackagingComponent", "shelfLifeStorage", element.getShelfLifeStorage().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getManufacturer().size(); ++i2) {
            this.composeReference(t, "PackagedProductDefinitionPackagingComponent", "manufacturer", element.getManufacturer().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getProperty().size(); ++i2) {
            this.composePackagedProductDefinitionPackagingPropertyComponent(t, "PackagedProductDefinitionPackagingComponent", "property", element.getProperty().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContainedItem().size(); ++i2) {
            this.composePackagedProductDefinitionPackagingContainedItemComponent(t, "PackagedProductDefinitionPackagingComponent", "containedItem", element.getContainedItem().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getPackaging().size(); ++i2) {
            this.composePackagedProductDefinitionPackagingComponent(t, "PackagedProductDefinitionPackagingComponent", "packaging", element.getPackaging().get(i2), i2);
        }
    }

    protected void composePackagedProductDefinitionPackagingPropertyComponent(Turtle.Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackagingPropertyComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "property", name, element, index);
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PackagedProductDefinitionPackagingPropertyComponent", "type", element.getType(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "PackagedProductDefinitionPackagingPropertyComponent", "value", element.getValue(), -1);
        }
    }

    protected void composePackagedProductDefinitionPackagingContainedItemComponent(Turtle.Complex parent, String parentType, String name, PackagedProductDefinition.PackagedProductDefinitionPackagingContainedItemComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "containedItem", name, element, index);
        if (element.hasItem()) {
            this.composeCodeableReference(t, "PackagedProductDefinitionPackagingContainedItemComponent", "item", element.getItem(), -1);
        }
        if (element.hasAmount()) {
            this.composeQuantity(t, "PackagedProductDefinitionPackagingContainedItemComponent", "amount", element.getAmount(), -1);
        }
    }

    protected void composeParameters(Turtle.Complex parent, String parentType, String name, Parameters element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeResource(t, "Parameters", name, element, index);
        for (int i2 = 0; i2 < element.getParameter().size(); ++i2) {
            this.composeParametersParameterComponent(t, "Parameters", "parameter", element.getParameter().get(i2), i2);
        }
    }

    protected void composeParametersParameterComponent(Turtle.Complex parent, String parentType, String name, Parameters.ParametersParameterComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "parameter", name, element, index);
        if (element.hasNameElement()) {
            this.composeString(t, "ParametersParameterComponent", "name", element.getNameElement(), -1);
        }
        if (element.hasValue()) {
            this.composeType(t, "ParametersParameterComponent", "value", element.getValue(), -1);
        }
        if (element.hasResource()) {
            this.composeResource(t, "ParametersParameterComponent", "resource", element.getResource(), -1);
        }
        for (int i2 = 0; i2 < element.getPart().size(); ++i2) {
            this.composeParametersParameterComponent(t, "ParametersParameterComponent", "part", element.getPart().get(i2), i2);
        }
    }

    protected void composePatient(Turtle.Complex parent, String parentType, String name, Patient element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "Patient", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "Patient", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasActiveElement()) {
            this.composeBoolean(t, "Patient", "active", element.getActiveElement(), -1);
        }
        for (i2 = 0; i2 < element.getName().size(); ++i2) {
            this.composeHumanName(t, "Patient", "name", element.getName().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getTelecom().size(); ++i2) {
            this.composeContactPoint(t, "Patient", "telecom", element.getTelecom().get(i2), i2);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "Patient", "gender", element.getGenderElement(), -1);
        }
        if (element.hasBirthDateElement()) {
            this.composeDate(t, "Patient", "birthDate", element.getBirthDateElement(), -1);
        }
        if (element.hasDeceased()) {
            this.composeType(t, "Patient", "deceased", element.getDeceased(), -1);
        }
        for (i2 = 0; i2 < element.getAddress().size(); ++i2) {
            this.composeAddress(t, "Patient", "address", element.getAddress().get(i2), i2);
        }
        if (element.hasMaritalStatus()) {
            this.composeCodeableConcept(t, "Patient", "maritalStatus", element.getMaritalStatus(), -1);
        }
        if (element.hasMultipleBirth()) {
            this.composeType(t, "Patient", "multipleBirth", element.getMultipleBirth(), -1);
        }
        for (i2 = 0; i2 < element.getPhoto().size(); ++i2) {
            this.composeAttachment(t, "Patient", "photo", element.getPhoto().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getContact().size(); ++i2) {
            this.composePatientContactComponent(t, "Patient", "contact", element.getContact().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getCommunication().size(); ++i2) {
            this.composePatientCommunicationComponent(t, "Patient", "communication", element.getCommunication().get(i2), i2);
        }
        for (i2 = 0; i2 < element.getGeneralPractitioner().size(); ++i2) {
            this.composeReference(t, "Patient", "generalPractitioner", element.getGeneralPractitioner().get(i2), i2);
        }
        if (element.hasManagingOrganization()) {
            this.composeReference(t, "Patient", "managingOrganization", element.getManagingOrganization(), -1);
        }
        for (i2 = 0; i2 < element.getLink().size(); ++i2) {
            this.composePatientLinkComponent(t, "Patient", "link", element.getLink().get(i2), i2);
        }
    }

    protected void composePatientContactComponent(Turtle.Complex parent, String parentType, String name, Patient.ContactComponent element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "contact", name, element, index);
        for (i2 = 0; i2 < element.getRelationship().size(); ++i2) {
            this.composeCodeableConcept(t, "ContactComponent", "relationship", element.getRelationship().get(i2), i2);
        }
        if (element.hasName()) {
            this.composeHumanName(t, "ContactComponent", "name", element.getName(), -1);
        }
        for (i2 = 0; i2 < element.getTelecom().size(); ++i2) {
            this.composeContactPoint(t, "ContactComponent", "telecom", element.getTelecom().get(i2), i2);
        }
        if (element.hasAddress()) {
            this.composeAddress(t, "ContactComponent", "address", element.getAddress(), -1);
        }
        if (element.hasGenderElement()) {
            this.composeEnum(t, "ContactComponent", "gender", element.getGenderElement(), -1);
        }
        if (element.hasOrganization()) {
            this.composeReference(t, "ContactComponent", "organization", element.getOrganization(), -1);
        }
        if (element.hasPeriod()) {
            this.composePeriod(t, "ContactComponent", "period", element.getPeriod(), -1);
        }
    }

    protected void composePatientCommunicationComponent(Turtle.Complex parent, String parentType, String name, Patient.PatientCommunicationComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "communication", name, element, index);
        if (element.hasLanguage()) {
            this.composeCodeableConcept(t, "PatientCommunicationComponent", "language", element.getLanguage(), -1);
        }
        if (element.hasPreferredElement()) {
            this.composeBoolean(t, "PatientCommunicationComponent", "preferred", element.getPreferredElement(), -1);
        }
    }

    protected void composePatientLinkComponent(Turtle.Complex parent, String parentType, String name, Patient.PatientLinkComponent element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeBackboneElement(t, "link", name, element, index);
        if (element.hasOther()) {
            this.composeReference(t, "PatientLinkComponent", "other", element.getOther(), -1);
        }
        if (element.hasTypeElement()) {
            this.composeEnum(t, "PatientLinkComponent", "type", element.getTypeElement(), -1);
        }
    }

    protected void composePaymentNotice(Turtle.Complex parent, String parentType, String name, PaymentNotice element, int index) {
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PaymentNotice", name, element, index);
        for (int i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "PaymentNotice", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PaymentNotice", "status", element.getStatusElement(), -1);
        }
        if (element.hasRequest()) {
            this.composeReference(t, "PaymentNotice", "request", element.getRequest(), -1);
        }
        if (element.hasResponse()) {
            this.composeReference(t, "PaymentNotice", "response", element.getResponse(), -1);
        }
        if (element.hasCreatedElement()) {
            this.composeDateTime(t, "PaymentNotice", "created", element.getCreatedElement(), -1);
        }
        if (element.hasProvider()) {
            this.composeReference(t, "PaymentNotice", "provider", element.getProvider(), -1);
        }
        if (element.hasPayment()) {
            this.composeReference(t, "PaymentNotice", "payment", element.getPayment(), -1);
        }
        if (element.hasPaymentDateElement()) {
            this.composeDate(t, "PaymentNotice", "paymentDate", element.getPaymentDateElement(), -1);
        }
        if (element.hasPayee()) {
            this.composeReference(t, "PaymentNotice", "payee", element.getPayee(), -1);
        }
        if (element.hasRecipient()) {
            this.composeReference(t, "PaymentNotice", "recipient", element.getRecipient(), -1);
        }
        if (element.hasAmount()) {
            this.composeMoney(t, "PaymentNotice", "amount", element.getAmount(), -1);
        }
        if (element.hasPaymentStatus()) {
            this.composeCodeableConcept(t, "PaymentNotice", "paymentStatus", element.getPaymentStatus(), -1);
        }
    }

    protected void composePaymentReconciliation(Turtle.Complex parent, String parentType, String name, PaymentReconciliation element, int index) {
        int i2;
        if (element == null) {
            return;
        }
        Turtle.Complex t = Utilities.noString(parentType) ? parent : parent.predicate("fhir:" + parentType + "." + name);
        this.composeDomainResource(t, "PaymentReconciliation", name, element, index);
        for (i2 = 0; i2 < element.getIdentifier().size(); ++i2) {
            this.composeIdentifier(t, "PaymentReconciliation", "identifier", element.getIdentifier().get(i2), i2);
        }
        if (element.hasType()) {
            this.composeCodeableConcept(t, "PaymentReconciliation", "type", element.getType(), -1);
        }
        if (element.hasStatusElement()) {
            this.composeEnum(t, "PaymentReconciliation", "status", element.getStatusElement(), -1);
        }
        if (element.hasKind()) {
            this.composeCodeableConcept(t, "PaymentReconciliation", "kind", element.getKind(), -1);
        }
        if (element.hasPeriod()) {
    