/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;

public class Tester {
    private static JsonParser parser = new JsonParser();

    public static void main(String[] args) throws Exception {
        SimpleWorkerContext context = new SimpleWorkerContext.SimpleWorkerContextBuilder().fromPack(Utilities.path("C:\\work\\org.hl7.fhir\\build\\publish", "validation-min.xml.zip"));
        int t = 0;
        int ok = 0;
        for (String f : new File("C:\\work\\org.hl7.fhir\\build\\publish").list()) {
            if (!f.endsWith(".xml") || f.endsWith(".canonical.xml") || f.contains("profile") || f.contains("questionnaire") || !new File("C:\\work\\org.hl7.fhir\\build\\publish\\" + Utilities.changeFileExt(f, ".ttl")).exists()) continue;
            System.out.print("convert " + f);
            Element e = Manager.parseSingle(context, new FileInputStream("C:\\work\\org.hl7.fhir\\build\\publish\\" + f), Manager.FhirFormat.XML);
            Manager.compose(context, e, new FileOutputStream("C:\\work\\org.hl7.fhir\\build\\publish\\" + Utilities.changeFileExt(f, ".mm.ttl")), Manager.FhirFormat.TURTLE, IParser.OutputStyle.PRETTY, null);
            Manager.compose(context, e, new FileOutputStream(Utilities.path("[tmp]", "resource.xml")), Manager.FhirFormat.XML, IParser.OutputStyle.PRETTY, null);
            String src = TextFile.fileToString("C:\\work\\org.hl7.fhir\\build\\publish\\" + Utilities.changeFileExt(f, ".mm.ttl"));
            String tgt = TextFile.fileToString("C:\\work\\org.hl7.fhir\\build\\publish\\" + Utilities.changeFileExt(f, ".ttl"));
            ++t;
            if (src.equals(tgt)) {
                System.out.println(".. ok");
                ++ok;
                continue;
            }
            System.out.println(".. fail");
        }
        System.out.println("done - " + Integer.toString(t) + " files, " + Integer.toString(ok) + " ok");
    }

    private static String normalise(String s2) {
        JsonObject json = parser.parse(s2).getAsJsonObject();
        JsonElement txt = json.get("text");
        if (txt != null && ((JsonObject)txt).has("div")) {
            ((JsonObject)txt).remove("div");
        }
        Tester.removeComments(json);
        return json.toString();
    }

    private static void removeComments(JsonArray arr) {
        for (JsonElement i2 : arr) {
            if (i2 instanceof JsonObject) {
                Tester.removeComments((JsonObject)i2);
            }
            if (!(i2 instanceof JsonArray)) continue;
            Tester.removeComments((JsonArray)i2);
        }
    }

    private static void removeComments(JsonObject json) {
        if (json.has("fhir_comments")) {
            json.remove("fhir_comments");
        }
        for (Map.Entry p : json.entrySet()) {
            if (p.getValue() instanceof JsonObject) {
                Tester.removeComments((JsonObject)p.getValue());
            }
            if (!(p.getValue() instanceof JsonArray)) continue;
            Tester.removeComments((JsonArray)p.getValue());
        }
    }
}

