/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.r5.context.BaseLogger;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;

public class TextClientLogger
extends BaseLogger
implements ToolingClientLogger {
    private PrintStream file;

    public TextClientLogger(String log) {
        if (log != null) {
            try {
                this.file = new PrintStream(new FileOutputStream(log));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void logRequest(String method, String url, List<String> headers, byte[] body2) {
        if (this.file == null) {
            return;
        }
        String id = this.nextId();
        this.file.println("\r\n--- " + id + " -----------------\r\nRequest: \r\n");
        this.file.println(method + " " + url + " HTTP/1.0");
        for (String s2 : headers) {
            this.file.println(Utilities.escapeXml(s2));
        }
        if (body2 != null) {
            this.file.println("");
            try {
                this.file.println(Utilities.escapeXml(new String(body2, "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    @Override
    public void logResponse(String outcome, List<String> headers, byte[] body2) {
        if (this.file == null) {
            return;
        }
        this.file.println("\r\n\r\nResponse: \r\n");
        this.file.println(outcome);
        for (String s2 : headers) {
            this.file.println(Utilities.escapeXml(s2));
        }
        if (body2 != null) {
            this.file.println("");
            try {
                this.file.println(Utilities.escapeXml(new String(body2, "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }
}

