/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.r5.context.BaseLogger;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;

public class HTMLClientLogger
extends BaseLogger
implements ToolingClientLogger {
    private static final boolean DEBUG = false;
    private boolean req = false;
    private PrintStream file;

    public HTMLClientLogger(String log) {
        if (log != null) {
            try {
                this.file = new PrintStream(new FileOutputStream(log));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void logRequest(String method, String url, List<String> headers, byte[] body2) {
        if (this.file == null) {
            return;
        }
        String id = this.nextId();
        this.file.println("<hr/><a name=\"l" + id + "\"> </a>");
        this.file.println("<p>#" + id + "</p>");
        this.file.println("<pre>");
        this.file.println(method + " " + url + " HTTP/1.0");
        if (headers != null) {
            for (String s2 : headers) {
                this.file.println(Utilities.escapeXml(s2));
            }
        }
        if (body2 != null) {
            this.file.println("");
            try {
                this.file.println(Utilities.escapeXml(new String(body2, "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.file.println("</pre>");
        this.req = true;
    }

    @Override
    public void logResponse(String outcome, List<String> headers, byte[] body2) {
        if (this.file == null) {
            return;
        }
        if (!this.req) {
            System.out.println("Record Response without request");
        }
        this.req = false;
        this.file.println("<pre>");
        this.file.println(outcome);
        for (String s2 : headers) {
            this.file.println(Utilities.escapeXml(s2));
        }
        if (body2 != null) {
            this.file.println("");
            try {
                this.file.println(Utilities.escapeXml(new String(body2, "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.file.println("</pre>");
    }

    private String present(byte[] body2) {
        if (body2 == null) {
            return "";
        }
        String cnt = new String(body2);
        if ((cnt = cnt.replace("\n", " ").replace("\r", "")).length() > 800) {
            return cnt.substring(0, 798) + "...";
        }
        return cnt;
    }
}

