/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.utilities.VersionUtilities;

public class CanonicalResourceManager<T extends CanonicalResource> {
    private final String[] INVALID_TERMINOLOGY_URLS = new String[]{"http://snomed.info/sct", "http://dicom.nema.org/resources/ontology/DCM", "http://nucc.org/provider-taxonomy"};
    private boolean enforceUniqueId;
    private List<CachedCanonicalResource<T>> list = new ArrayList<CachedCanonicalResource<T>>();
    private Map<String, List<CachedCanonicalResource<T>>> listForId = new HashMap<String, List<CachedCanonicalResource<T>>>();
    private Map<String, List<CachedCanonicalResource<T>>> listForUrl = new HashMap<String, List<CachedCanonicalResource<T>>>();
    private Map<String, CachedCanonicalResource<T>> map = new HashMap<String, CachedCanonicalResource<T>>();
    private String version;

    public CanonicalResourceManager(boolean enforceUniqueId) {
        this.enforceUniqueId = enforceUniqueId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void copy(CanonicalResourceManager<T> source) {
        this.list.clear();
        this.map.clear();
        this.list.addAll(source.list);
        this.map.putAll(source.map);
    }

    public void register(CanonicalResourceProxy r, PackageInformation packgeInfo) {
        if (!r.hasId()) {
            throw new FHIRException("An id is required for a deferred load resource");
        }
        CachedCanonicalResource cr = new CachedCanonicalResource(this, r, packgeInfo);
        this.see(cr);
    }

    public void see(T r, PackageInformation packgeInfo) {
        if (r != null) {
            if (!((Resource)r).hasId()) {
                ((Resource)r).setId(UUID.randomUUID().toString());
            }
            CachedCanonicalResource cr = new CachedCanonicalResource(this, r, packgeInfo);
            this.see(cr);
        }
    }

    public void see(CachedCanonicalResource<T> cr) {
        String mm3;
        int n;
        List<CachedCanonicalResource<T>> set;
        if (cr.getPackageInfo() != null && cr.getPackageInfo().getId() != null && cr.getPackageInfo().getId().startsWith("hl7.terminology") && Arrays.stream(this.INVALID_TERMINOLOGY_URLS).anyMatch(it -> it.equals(cr.getUrl()))) {
            return;
        }
        if (this.map.get(cr.getUrl()) != null && cr.getPackageInfo() != null && cr.getPackageInfo().isExamplesPackage()) {
            return;
        }
        if (cr.resource != null) {
            ((Resource)cr.resource).setSourcePackage(cr.getPackageInfo());
        }
        if (this.enforceUniqueId && this.map.containsKey(cr.getId())) {
            this.drop(cr.getId());
        }
        if (cr.getPackageInfo() != null && cr.getPackageInfo().getId().startsWith("hl7.terminology")) {
            ArrayList<CachedCanonicalResource<T>> toDrop = new ArrayList<CachedCanonicalResource<T>>();
            for (CachedCanonicalResource<T> cachedCanonicalResource : this.list) {
                if (cachedCanonicalResource.getUrl() == null || !cachedCanonicalResource.getUrl().equals(cr.getUrl()) || !this.isBasePackage(cachedCanonicalResource.getPackageInfo())) continue;
                toDrop.add(cachedCanonicalResource);
            }
            for (CachedCanonicalResource<Object> cachedCanonicalResource : toDrop) {
                this.drop(cachedCanonicalResource);
            }
        }
        if (!this.enforceUniqueId) {
            if (!this.listForId.containsKey(cr.getId())) {
                this.listForId.put(cr.getId(), new ArrayList());
            }
            set = this.listForId.get(cr.getId());
            set.add(cr);
        }
        this.list.add(cr);
        if (!this.listForUrl.containsKey(cr.getUrl())) {
            this.listForUrl.put(cr.getUrl(), new ArrayList());
        }
        set = this.listForUrl.get(cr.getUrl());
        set.add(cr);
        Collections.sort(set, new MetadataResourceVersionComparator());
        String pv = cr.getPackageInfo() != null ? cr.getPackageInfo().getVID() : null;
        this.map.put(cr.getId(), cr);
        this.map.put(cr.hasVersion() ? cr.getUrl() + "|" + cr.getVersion() : cr.getUrl() + "|#0", cr);
        if (pv != null) {
            this.map.put(pv + ":" + (cr.hasVersion() ? cr.getUrl() + "|" + cr.getVersion() : cr.getUrl() + "|#0"), cr);
        }
        if ((n = set.indexOf(cr)) == set.size() - 1) {
            this.map.put(cr.getUrl(), cr);
            if (pv != null) {
                this.map.put(pv + ":" + cr.getUrl(), cr);
            }
        }
        if ((mm3 = VersionUtilities.getMajMin(cr.getVersion())) != null) {
            if (pv != null) {
                this.map.put(pv + ":" + cr.getUrl() + "|" + mm3, cr);
            }
            if (set.size() - 1 == n) {
                this.map.put(cr.getUrl() + "|" + mm3, cr);
            } else {
                for (int i2 = set.size() - 1; i2 > n; --i2) {
                    if (mm3.equals(VersionUtilities.getMajMin(set.get(i2).getVersion()))) {
                        return;
                    }
                    this.map.put(cr.getUrl() + "|" + mm3, cr);
                }
            }
        }
    }

    public void drop(CachedCanonicalResource<T> cr) {
        while (this.map.values().remove(cr)) {
        }
        while (this.listForId.values().remove(cr)) {
        }
        while (this.listForUrl.values().remove(cr)) {
        }
        this.list.remove(cr);
        List<CachedCanonicalResource<T>> set = this.listForUrl.get(cr.getUrl());
        if (set != null) {
            boolean last = set.indexOf(cr) == set.size() - 1;
            set.remove(cr);
            if (!set.isEmpty()) {
                String mm3;
                CachedCanonicalResource<T> crl = set.get(set.size() - 1);
                if (last) {
                    this.map.put(crl.getUrl(), crl);
                }
                if ((mm3 = VersionUtilities.getMajMin(cr.getVersion())) != null) {
                    for (int i2 = set.size() - 1; i2 >= 0; --i2) {
                        if (!mm3.equals(VersionUtilities.getMajMin(set.get(i2).getVersion()))) continue;
                        this.map.put(cr.getUrl() + "|" + mm3, set.get(i2));
                        break;
                    }
                }
            }
        }
    }

    public void drop(String id) {
        if (this.enforceUniqueId) {
            CachedCanonicalResource<T> cr = this.map.get(id);
            if (cr != null) {
                this.drop(cr);
            }
        } else {
            List<CachedCanonicalResource<T>> set = this.listForId.get(id);
            if (set != null) {
                for (CachedCanonicalResource<T> i2 : set) {
                    this.drop(i2);
                }
            }
        }
    }

    private boolean isBasePackage(PackageInformation packageInfo) {
        return packageInfo == null ? false : VersionUtilities.isCorePackage(packageInfo.getId());
    }

    private void updateList(String url, String version) {
        ArrayList<CachedCanonicalResource<T>> rl = new ArrayList<CachedCanonicalResource<T>>();
        for (CachedCanonicalResource<T> t : this.list) {
            if (!url.equals(t.getUrl()) || rl.contains(t)) continue;
            rl.add(t);
        }
        if (rl.size() > 0) {
            this.map.put(url, (CachedCanonicalResource)rl.get(rl.size() - 1));
            if (version != null) {
                String lv;
                CachedCanonicalResource latest = null;
                for (CachedCanonicalResource cachedCanonicalResource : rl) {
                    if (!VersionUtilities.versionsCompatible(cachedCanonicalResource.getVersion(), version)) continue;
                    latest = cachedCanonicalResource;
                }
                if (latest != null && (lv = VersionUtilities.getMajMin(latest.getVersion())) != null && !lv.equals(version)) {
                    this.map.put(url + "|" + lv, (CachedCanonicalResource)rl.get(rl.size() - 1));
                }
            }
        }
    }

    public boolean has(String url) {
        return this.map.containsKey(url);
    }

    public boolean has(String system, String version) {
        if (this.map.containsKey(system + "|" + version)) {
            return true;
        }
        String mm3 = VersionUtilities.getMajMin(version);
        if (mm3 != null) {
            return this.map.containsKey(system + "|" + mm3);
        }
        return false;
    }

    public T get(String url) {
        return this.map.containsKey(url) ? (T)this.map.get(url).getResource() : null;
    }

    public T get(String system, String version) {
        if (version == null) {
            return this.get(system);
        }
        if (this.map.containsKey(system + "|" + version)) {
            return this.map.get(system + "|" + version).getResource();
        }
        String mm3 = VersionUtilities.getMajMin(version);
        if (mm3 != null && this.map.containsKey(system + "|" + mm3)) {
            return this.map.get(system + "|" + mm3).getResource();
        }
        return null;
    }

    public T get(String url, List<String> pvlist) {
        for (String pv : pvlist) {
            if (!this.map.containsKey(pv + ":" + url)) continue;
            return this.map.get(pv + ":" + url).getResource();
        }
        return this.map.containsKey(url) ? (T)this.map.get(url).getResource() : null;
    }

    public T get(String system, String version, List<String> pvlist) {
        if (version == null) {
            return this.get(system, pvlist);
        }
        for (String pv : pvlist) {
            if (!this.map.containsKey(pv + ":" + system + "|" + version)) continue;
            return this.map.get(pv + ":" + system + "|" + version).getResource();
        }
        String mm3 = VersionUtilities.getMajMin(version);
        if (mm3 != null && this.map.containsKey(system + "|" + mm3)) {
            for (String pv : pvlist) {
                if (!this.map.containsKey(pv + ":" + system + "|" + mm3)) continue;
                return this.map.get(pv + ":" + system + "|" + mm3).getResource();
            }
        }
        if (this.map.containsKey(system + "|" + version)) {
            return this.map.get(system + "|" + version).getResource();
        }
        if (mm3 != null && this.map.containsKey(system + "|" + mm3)) {
            return this.map.get(system + "|" + mm3).getResource();
        }
        return null;
    }

    public PackageInformation getPackageInfo(String system, String version) {
        if (version == null) {
            return this.map.containsKey(system) ? this.map.get(system).getPackageInfo() : null;
        }
        if (this.map.containsKey(system + "|" + version)) {
            return this.map.get(system + "|" + version).getPackageInfo();
        }
        String mm3 = VersionUtilities.getMajMin(version);
        if (mm3 != null && this.map.containsKey(system + "|" + mm3)) {
            return this.map.get(system + "|" + mm3).getPackageInfo();
        }
        return null;
    }

    public int size() {
        return this.list.size();
    }

    public void listAll(List<T> result) {
        for (CachedCanonicalResource<T> t : this.list) {
            result.add(t.getResource());
        }
    }

    public void listAllM(List<CanonicalResource> result) {
        for (CachedCanonicalResource<T> t : this.list) {
            result.add((CanonicalResource)t.getResource());
        }
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public List<T> getList() {
        ArrayList<T> res = new ArrayList<T>();
        for (CachedCanonicalResource<T> t : this.list) {
            if (res.contains(t.getResource())) continue;
            res.add(t.getResource());
        }
        return res;
    }

    public List<T> getSortedList() {
        List<T> res = this.getList();
        Collections.sort(res, new CanonicalListSorter());
        return res;
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public boolean isEnforceUniqueId() {
        return this.enforceUniqueId;
    }

    public class MetadataResourceVersionComparator<T1 extends CachedCanonicalResource<T>>
    implements Comparator<T1> {
        @Override
        public int compare(T1 arg1, T1 arg2) {
            String v1 = ((CachedCanonicalResource)arg1).getVersion();
            String v2 = ((CachedCanonicalResource)arg2).getVersion();
            if (v1 == null && v2 == null) {
                return Integer.compare(CanonicalResourceManager.this.list.indexOf(arg1), CanonicalResourceManager.this.list.indexOf(arg2));
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String mm1 = VersionUtilities.getMajMin(v1);
            String mm22 = VersionUtilities.getMajMin(v2);
            if (mm1 == null || mm22 == null) {
                return v1.compareTo(v2);
            }
            return mm1.compareTo(mm22);
        }
    }

    private static class CachedCanonicalResource<T1 extends CanonicalResource> {
        private T1 resource;
        private CanonicalResourceProxy proxy;
        private PackageInformation packageInfo;
        final /* synthetic */ CanonicalResourceManager this$0;

        public CachedCanonicalResource(T1 resource, PackageInformation packageInfo) {
            this.this$0 = var1_1;
            this.resource = resource;
            this.packageInfo = packageInfo;
        }

        public CachedCanonicalResource(CanonicalResourceManager canonicalResourceManager, CanonicalResourceProxy proxy, PackageInformation packageInfo) {
            this.this$0 = canonicalResourceManager;
            this.proxy = proxy;
            this.packageInfo = packageInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T1 getResource() {
            if (this.resource == null) {
                CanonicalResource res = this.proxy.getResource();
                if (res == null) {
                    throw new Error("Proxy loading a resource from " + this.packageInfo + " failed and returned null");
                }
                CachedCanonicalResource cachedCanonicalResource = this;
                synchronized (cachedCanonicalResource) {
                    this.resource = res;
                }
                ((Resource)this.resource).setSourcePackage(this.packageInfo);
                this.proxy = null;
            }
            return this.resource;
        }

        public PackageInformation getPackageInfo() {
            return this.packageInfo;
        }

        public String getUrl() {
            return this.resource != null ? ((CanonicalResource)this.resource).getUrl() : this.proxy.getUrl();
        }

        public String getId() {
            return this.resource != null ? ((Resource)this.resource).getId() : this.proxy.getId();
        }

        public String getVersion() {
            return this.resource != null ? ((CanonicalResource)this.resource).getVersion() : this.proxy.getVersion();
        }

        public boolean hasVersion() {
            return this.resource != null ? ((CanonicalResource)this.resource).hasVersion() : this.proxy.getVersion() != null;
        }

        public String toString() {
            return this.resource != null ? ((CanonicalResource)this.resource).fhirType() + "/" + ((Resource)this.resource).getId() + "[" + ((CanonicalResource)this.resource).getUrl() + "|" + ((CanonicalResource)this.resource).getVersion() + "]" : this.proxy.toString();
        }
    }

    public class CanonicalListSorter
    implements Comparator<CanonicalResource> {
        @Override
        public int compare(CanonicalResource arg0, CanonicalResource arg1) {
            String u0 = arg0.getUrl();
            String u1 = arg1.getUrl();
            return u0.compareTo(u1);
        }
    }

    public static abstract class CanonicalResourceProxy {
        private String type;
        private String id;
        private String url;
        private String version;
        private CanonicalResource resource;

        public CanonicalResourceProxy(String type, String id, String url, String version) {
            this.type = type;
            this.id = id;
            this.url = url;
            this.version = version;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean hasId() {
            return this.id != null;
        }

        public boolean hasUrl() {
            return this.url != null;
        }

        public boolean hasVersion() {
            return this.version != null;
        }

        public CanonicalResource getResource() throws FHIRException {
            if (this.resource == null) {
                this.resource = this.loadResource();
                if (this.resource instanceof CodeSystem) {
                    CodeSystemUtilities.crossLinkCodeSystem((CodeSystem)this.resource);
                }
            }
            return this.resource;
        }

        public void setResource(CanonicalResource resource) {
            this.resource = resource;
        }

        public abstract CanonicalResource loadResource() throws FHIRException;

        public String toString() {
            return this.type + "/" + this.id + ": " + this.url + "|" + this.version;
        }

        public void hack(String url, String version) {
            this.url = url;
            this.version = version;
            this.getResource().setUrl(url).setVersion(version);
        }
    }
}

