/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.personname;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.personname.PersonNamePattern;
import com.ibm.icu.lang.UScript;
import com.ibm.icu.text.PersonName;
import com.ibm.icu.text.PersonNameFormatter;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class PersonNameFormatterImpl {
    private final Locale locale;
    private final PersonNamePattern[] gnFirstPatterns;
    private final PersonNamePattern[] snFirstPatterns;
    private final Set<String> gnFirstLocales;
    private final Set<String> snFirstLocales;
    private final String initialPattern;
    private final String initialSequencePattern;
    private final boolean capitalizeSurname;
    private final String foreignSpaceReplacement;
    private final boolean formatterLocaleUsesSpaces;
    private final PersonNameFormatter.Length length;
    private final PersonNameFormatter.Usage usage;
    private final PersonNameFormatter.Formality formality;
    private final Set<PersonNameFormatter.Options> options;
    private final Set<String> LOCALES_THAT_DONT_USE_SPACES = new HashSet<String>(Arrays.asList("ja", "zh", "th", "yue", "km", "lo"));

    public PersonNameFormatterImpl(Locale locale, PersonNameFormatter.Length length, PersonNameFormatter.Usage usage, PersonNameFormatter.Formality formality, Set<PersonNameFormatter.Options> options2) {
        if (options2 == null) {
            options2 = new HashSet<PersonNameFormatter.Options>();
        }
        this.length = length;
        this.usage = usage;
        this.formality = formality;
        this.options = options2;
        ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt72b", locale);
        this.locale = locale;
        this.initialPattern = rb.getStringWithFallback("personNames/initialPattern/initial");
        this.initialSequencePattern = rb.getStringWithFallback("personNames/initialPattern/initialSequence");
        this.capitalizeSurname = options2.contains((Object)PersonNameFormatter.Options.SURNAME_ALLCAPS);
        this.foreignSpaceReplacement = rb.getStringWithFallback("personNames/foreignSpaceReplacement");
        boolean bl = this.formatterLocaleUsesSpaces = !this.LOCALES_THAT_DONT_USE_SPACES.contains(locale.getLanguage());
        if (usage == PersonNameFormatter.Usage.MONOGRAM) {
            options2.remove((Object)PersonNameFormatter.Options.SORTING);
        } else if (options2.contains((Object)PersonNameFormatter.Options.SORTING)) {
            usage = PersonNameFormatter.Usage.REFERRING;
        }
        String RESOURCE_PATH_PREFIX = "personNames/namePattern/";
        String resourceNameBody = length.toString().toLowerCase() + "-" + usage.toString().toLowerCase() + "-" + formality.toString().toLowerCase();
        if (!options2.contains((Object)PersonNameFormatter.Options.SORTING)) {
            ICUResourceBundle gnFirstResource = rb.getWithFallback("personNames/namePattern/givenFirst-" + resourceNameBody);
            ICUResourceBundle snFirstResource = rb.getWithFallback("personNames/namePattern/surnameFirst-" + resourceNameBody);
            this.gnFirstPatterns = PersonNamePattern.makePatterns(this.asStringArray(gnFirstResource), this);
            this.snFirstPatterns = PersonNamePattern.makePatterns(this.asStringArray(snFirstResource), this);
            this.gnFirstLocales = new HashSet<String>();
            Collections.addAll(this.gnFirstLocales, this.asStringArray(rb.getWithFallback("personNames/nameOrderLocales/givenFirst")));
            this.snFirstLocales = new HashSet<String>();
            Collections.addAll(this.snFirstLocales, this.asStringArray(rb.getWithFallback("personNames/nameOrderLocales/surnameFirst")));
        } else {
            ICUResourceBundle patternResource = rb.getWithFallback("personNames/namePattern/sorting-" + resourceNameBody);
            this.gnFirstPatterns = PersonNamePattern.makePatterns(this.asStringArray(patternResource), this);
            this.snFirstPatterns = null;
            this.gnFirstLocales = null;
            this.snFirstLocales = null;
        }
    }

    public PersonNameFormatterImpl(Locale locale, String[] patterns) {
        this.snFirstPatterns = null;
        this.gnFirstLocales = null;
        this.snFirstLocales = null;
        this.length = PersonNameFormatter.Length.MEDIUM;
        this.usage = PersonNameFormatter.Usage.REFERRING;
        this.formality = PersonNameFormatter.Formality.FORMAL;
        this.options = Collections.emptySet();
        this.initialPattern = "{0}.";
        this.initialSequencePattern = "{0} {1}";
        this.capitalizeSurname = false;
        this.foreignSpaceReplacement = " ";
        this.formatterLocaleUsesSpaces = true;
        this.locale = locale;
        this.gnFirstPatterns = PersonNamePattern.makePatterns(patterns, this);
    }

    public String formatToString(PersonName name) {
        boolean nameLocaleUsesSpaces;
        Locale nameLocale = this.getNameLocale(name);
        boolean bl = nameLocaleUsesSpaces = !this.LOCALES_THAT_DONT_USE_SPACES.contains(nameLocale.getLanguage());
        if (!this.formatterLocaleUsesSpaces && nameLocaleUsesSpaces) {
            PersonNameFormatterImpl nativeFormatter = new PersonNameFormatterImpl(nameLocale, this.length, this.usage, this.formality, this.options);
            String result = nativeFormatter.formatToString(name);
            if (!this.foreignSpaceReplacement.equals(" ") && this.scriptMatchesLocale(result, this.locale)) {
                result = result.replace(" ", this.foreignSpaceReplacement);
            }
            return result;
        }
        if (this.snFirstPatterns == null || this.nameIsGnFirst(name)) {
            return this.getBestPattern(this.gnFirstPatterns, name).format(name);
        }
        return this.getBestPattern(this.snFirstPatterns, name).format(name);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public PersonNameFormatter.Length getLength() {
        return this.length;
    }

    public PersonNameFormatter.Usage getUsage() {
        return this.usage;
    }

    public PersonNameFormatter.Formality getFormality() {
        return this.formality;
    }

    public Set<PersonNameFormatter.Options> getOptions() {
        return this.options;
    }

    public String getInitialPattern() {
        return this.initialPattern;
    }

    public String getInitialSequencePattern() {
        return this.initialSequencePattern;
    }

    public boolean shouldCapitalizeSurname() {
        return this.capitalizeSurname;
    }

    private String[] asStringArray(ICUResourceBundle resource) {
        if (resource.getType() == 0) {
            return new String[]{resource.getString()};
        }
        if (resource.getType() == 8) {
            return resource.getStringArray();
        }
        throw new IllegalStateException("Unsupported resource type " + resource.getType());
    }

    private boolean nameIsGnFirst(PersonName name) {
        int lastUnderbarPos;
        HashSet<PersonName.FieldModifier> modifiers = new HashSet<PersonName.FieldModifier>();
        String preferredOrder = name.getFieldValue(PersonName.NameField.PREFERRED_ORDER, modifiers);
        if (preferredOrder != null) {
            if (preferredOrder.equals("givenFirst")) {
                return true;
            }
            if (preferredOrder.equals("surnameFirst")) {
                return false;
            }
            throw new IllegalArgumentException("Illegal preferredOrder value " + preferredOrder);
        }
        String localeStr = this.getNameLocale(name).toString();
        do {
            if (this.gnFirstLocales.contains(localeStr)) {
                return true;
            }
            if (!this.snFirstLocales.contains(localeStr)) continue;
            return false;
        } while (!(localeStr = (lastUnderbarPos = localeStr.lastIndexOf("_")) >= 0 ? localeStr.substring(0, lastUnderbarPos) : "root").equals("root"));
        return true;
    }

    private PersonNamePattern getBestPattern(PersonNamePattern[] patterns, PersonName name) {
        if (patterns.length == 1) {
            return patterns[0];
        }
        int maxPopulatedFields = 0;
        int minEmptyFields = Integer.MAX_VALUE;
        PersonNamePattern bestPattern = null;
        for (PersonNamePattern pattern : patterns) {
            int populatedFields = pattern.numPopulatedFields(name);
            int emptyFields = pattern.numEmptyFields(name);
            if (populatedFields > maxPopulatedFields) {
                maxPopulatedFields = populatedFields;
                minEmptyFields = emptyFields;
                bestPattern = pattern;
                continue;
            }
            if (populatedFields != maxPopulatedFields || emptyFields >= minEmptyFields) continue;
            minEmptyFields = emptyFields;
            bestPattern = pattern;
        }
        return bestPattern;
    }

    private Locale getNameLocale(PersonName name) {
        Locale nameLocale = name.getNameLocale();
        if (nameLocale == null) {
            int formatterScript = UScript.getCodeFromName(ULocale.addLikelySubtags(ULocale.forLocale(this.locale)).getScript());
            String givenName = name.getFieldValue(PersonName.NameField.GIVEN, new HashSet<PersonName.FieldModifier>());
            int nameScript = -1;
            for (int i2 = 0; nameScript == -1 && i2 < givenName.length(); ++i2) {
                int script = UScript.getScript(givenName.charAt(i2));
                if (script == 0 || script == 1) continue;
                nameScript = script;
            }
            nameLocale = formatterScript == nameScript ? this.locale : new Locale(ULocale.addLikelySubtags(new ULocale("und_" + UScript.getShortName(nameScript))).getLanguage());
        }
        return nameLocale;
    }

    private boolean scriptMatchesLocale(String s2, Locale locale) {
        int[] localeScripts = UScript.getCode(locale);
        int stringScript = 0;
        for (int i2 = 0; stringScript == 0 && i2 < s2.length(); ++i2) {
            char c = s2.charAt(i2);
            stringScript = UScript.getScript(c);
        }
        for (int localeScript : localeScripts) {
            if (localeScript != stringScript) continue;
            return true;
        }
        return false;
    }
}

