/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.jar;

import ca.uhn.fhir.util.XmlUtil;
import ca.uhn.fhir.util.jar.IDependencyLog;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyLogImpl
implements IDependencyLog {
    private static final Attributes.Name BUNDLE_SYMBOLIC_NAME = new Attributes.Name("Bundle-SymbolicName");
    private static final Attributes.Name BUNDLE_VENDOR = new Attributes.Name("Bundle-Vendor");
    private static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    private static final Attributes.Name IMPLEMENTATION_TITLE = new Attributes.Name("Implementation-Title");
    private static final Attributes.Name IMPLEMENTATION_VENDOR = new Attributes.Name("Implementation-Vendor");
    private static final Attributes.Name IMPLEMENTATION_VERSION = new Attributes.Name("Implementation-Version");
    private static final Logger ourLog = LoggerFactory.getLogger(XmlUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logStaxImplementation(Class<?> theClass) {
        block11: {
            try {
                String version;
                String vendor;
                int i2;
                Manifest manifest;
                URL rootUrl = DependencyLogImpl.getRootUrlForClass(theClass);
                if (rootUrl == null) {
                    ourLog.info("Unable to determine location of StAX implementation containing class");
                    break block11;
                }
                URL metaInfUrl = new URL(rootUrl, "META-INF/MANIFEST.MF");
                try (InputStream is = metaInfUrl.openStream();){
                    manifest = new Manifest(is);
                }
                Attributes attrs = manifest.getMainAttributes();
                String title = attrs.getValue(IMPLEMENTATION_TITLE);
                String symbolicName = attrs.getValue(BUNDLE_SYMBOLIC_NAME);
                if (symbolicName != null && (i2 = symbolicName.indexOf(59)) != -1) {
                    symbolicName = symbolicName.substring(0, i2);
                }
                if ((vendor = attrs.getValue(IMPLEMENTATION_VENDOR)) == null) {
                    vendor = attrs.getValue(BUNDLE_VENDOR);
                }
                if ((version = attrs.getValue(IMPLEMENTATION_VERSION)) == null) {
                    version = attrs.getValue(BUNDLE_VERSION);
                }
                if (ourLog.isDebugEnabled()) {
                    ourLog.debug("FHIR XML procesing will use StAX implementation at {}\n  Title:         {}\n  Symbolic name: {}\n  Vendor:        {}\n  Version:       {}", rootUrl, title, symbolicName, vendor, version);
                } else {
                    ourLog.info("FHIR XML procesing will use StAX implementation '{}' version '{}'", (Object)title, (Object)version);
                }
            }
            catch (Throwable e) {
                ourLog.info("Unable to determine StAX implementation: " + e.getMessage());
            }
        }
    }

    private static URL getRootUrlForClass(Class<?> cls) {
        URL url;
        ClassLoader classLoader = cls.getClassLoader();
        String resource = cls.getName().replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((url = classLoader.getResource(resource)) == null) {
            return null;
        }
        String file = url.getFile();
        if (file.endsWith(resource)) {
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file.substring(0, file.length() - resource.length()));
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }
}

