/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.system.HapiSystemProperties;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(VersionUtil.class);
    private static String ourVersion;
    private static String ourBuildNumber;
    private static String ourBuildTime;
    private static boolean ourSnapshot;

    public static boolean isSnapshot() {
        return ourSnapshot;
    }

    public static String getBuildNumber() {
        return ourBuildNumber;
    }

    public static String getBuildTime() {
        return ourBuildTime;
    }

    public static String getVersion() {
        return ourVersion;
    }

    private static void initialize() {
        try (InputStream is = VersionUtil.class.getResourceAsStream("/ca/uhn/fhir/hapi-fhir-base-build.properties");){
            Properties p = new Properties();
            if (is != null) {
                p.load(is);
            }
            ourVersion = p.getProperty("hapifhir.version");
            ourVersion = StringUtils.defaultIfBlank(ourVersion, "(unknown)");
            ourSnapshot = ourVersion.contains("SNAPSHOT");
            ourBuildNumber = StringUtils.left(p.getProperty("hapifhir.buildnumber"), 10);
            ourBuildTime = p.getProperty("hapifhir.timestamp");
            if (!HapiSystemProperties.isSuppressHapiFhirVersionLogEnabled()) {
                Object buildNumber = ourBuildNumber;
                if (VersionUtil.isSnapshot()) {
                    buildNumber = (String)buildNumber + "/" + VersionUtil.getBuildDate();
                }
                ourLog.info("HAPI FHIR version {} - Rev {}", (Object)ourVersion, buildNumber);
            }
        }
        catch (Exception e) {
            ourLog.warn("Unable to determine HAPI version information", e);
        }
    }

    public static String getBuildDate() {
        return ourBuildTime.substring(0, 10);
    }

    static {
        VersionUtil.initialize();
    }
}

