/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.hl7.fhir.instance.model.api.IIdType;

public interface ISearchParamRegistry {
    public RuntimeSearchParam getActiveSearchParam(String var1, String var2);

    public ResourceSearchParams getActiveSearchParams(String var1);

    default public void forceRefresh() {
    }

    default public void requestRefresh() {
    }

    default public void setPhoneticEncoder(IPhoneticEncoder thePhoneticEncoder) {
    }

    default public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName) {
        return Collections.emptyList();
    }

    default public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName, ComboSearchParamType theParamType) {
        return Collections.emptyList();
    }

    default public Optional<RuntimeSearchParam> getActiveComboSearchParamById(String theResourceName, IIdType theId) {
        return Optional.empty();
    }

    default public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName, Set<String> theParamNames) {
        return Collections.emptyList();
    }

    default public Collection<String> getValidSearchParameterNamesIncludingMeta(String theResourceName) {
        ResourceSearchParams activeSearchParams = this.getActiveSearchParams(theResourceName);
        TreeSet<Object> retval = activeSearchParams == null ? new TreeSet<String>() : new TreeSet<String>(activeSearchParams.getSearchParamNames());
        retval.add("_id");
        retval.add("_lastUpdated");
        return retval;
    }

    @Nullable
    public RuntimeSearchParam getActiveSearchParamByUrl(String var1);

    default public RuntimeSearchParam getRuntimeSearchParam(String theResourceType, String theParamName) {
        RuntimeSearchParam availableSearchParamDef = this.getActiveSearchParam(theResourceType, theParamName);
        if (availableSearchParamDef == null) {
            availableSearchParamDef = this.getActiveSearchParam("Resource", theParamName);
        }
        if (availableSearchParamDef == null) {
            throw new InvalidRequestException(Msg.code(1209) + "Unknown parameter name: " + theResourceType + ":" + theParamName);
        }
        return availableSearchParamDef;
    }
}

