/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IIdType;

public class FhirContextSearchParamRegistry
implements ISearchParamRegistry {
    private final List<RuntimeSearchParam> myExtraSearchParams = new ArrayList<RuntimeSearchParam>();
    private final FhirContext myCtx;

    public FhirContextSearchParamRegistry(@Nonnull FhirContext theCtx) {
        Validate.notNull(theCtx, "theCtx must not be null", new Object[0]);
        this.myCtx = theCtx;
    }

    @Override
    public void forceRefresh() {
    }

    @Override
    public RuntimeSearchParam getActiveSearchParam(String theResourceName, String theParamName) {
        return this.getActiveSearchParams(theResourceName).get(theParamName);
    }

    @Override
    public ResourceSearchParams getActiveSearchParams(String theResourceName) {
        ResourceSearchParams retval = new ResourceSearchParams(theResourceName);
        RuntimeResourceDefinition nextResDef = this.myCtx.getResourceDefinition(theResourceName);
        for (RuntimeSearchParam nextSp : nextResDef.getSearchParams()) {
            retval.put(nextSp.getName(), nextSp);
        }
        for (RuntimeSearchParam next : this.myExtraSearchParams) {
            retval.put(next.getName(), next);
        }
        return retval;
    }

    public void addSearchParam(RuntimeSearchParam theSearchParam) {
        this.myExtraSearchParams.add(theSearchParam);
    }

    @Override
    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName, Set<String> theParamNames) {
        throw new UnsupportedOperationException(Msg.code(2066));
    }

    @Override
    @Nullable
    public RuntimeSearchParam getActiveSearchParamByUrl(String theUrl) {
        return this.myCtx.getResourceTypes().stream().flatMap(type -> this.getActiveSearchParams((String)type).values().stream()).filter(rsp -> theUrl.equals(rsp.getUri())).findFirst().orElse(null);
    }

    @Override
    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName) {
        throw new UnsupportedOperationException(Msg.code(2068));
    }

    @Override
    public List<RuntimeSearchParam> getActiveComboSearchParams(String theResourceName, ComboSearchParamType theParamType) {
        throw new UnsupportedOperationException(Msg.code(2209));
    }

    @Override
    public Optional<RuntimeSearchParam> getActiveComboSearchParamById(String theResourceName, IIdType theId) {
        throw new UnsupportedOperationException(Msg.code(2211));
    }

    @Override
    public void requestRefresh() {
    }

    @Override
    public void setPhoneticEncoder(IPhoneticEncoder thePhoneticEncoder) {
    }
}

