/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.util;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import javax.annotation.Nullable;

public class CompositeInterceptorBroadcaster {
    private CompositeInterceptorBroadcaster() {
    }

    public static boolean doCallHooks(IInterceptorBroadcaster theInterceptorBroadcaster, @Nullable RequestDetails theRequestDetails, Pointcut thePointcut, HookParams theParams) {
        return CompositeInterceptorBroadcaster.newCompositeBroadcaster(theInterceptorBroadcaster, theRequestDetails).callHooks(thePointcut, theParams);
    }

    public static Object doCallHooksAndReturnObject(IInterceptorBroadcaster theInterceptorBroadcaster, RequestDetails theRequestDetails, Pointcut thePointcut, HookParams theParams) {
        return CompositeInterceptorBroadcaster.newCompositeBroadcaster(theInterceptorBroadcaster, theRequestDetails).callHooksAndReturnObject(thePointcut, theParams);
    }

    public static boolean hasHooks(Pointcut thePointcut, IInterceptorBroadcaster theInterceptorBroadcaster, RequestDetails theRequestDetails) {
        return CompositeInterceptorBroadcaster.newCompositeBroadcaster(theInterceptorBroadcaster, theRequestDetails).hasHooks(thePointcut);
    }

    public static IInterceptorBroadcaster newCompositeBroadcaster(final IInterceptorBroadcaster theInterceptorBroadcaster, final RequestDetails theRequestDetails) {
        return new IInterceptorBroadcaster(){

            @Override
            public boolean callHooks(Pointcut thePointcut, HookParams theParams) {
                boolean retVal = true;
                if (theInterceptorBroadcaster != null) {
                    retVal = theInterceptorBroadcaster.callHooks(thePointcut, theParams);
                }
                if (theRequestDetails != null && theRequestDetails.getInterceptorBroadcaster() != null && retVal) {
                    IInterceptorBroadcaster interceptorBroadcaster = theRequestDetails.getInterceptorBroadcaster();
                    interceptorBroadcaster.callHooks(thePointcut, theParams);
                }
                return retVal;
            }

            @Override
            public Object callHooksAndReturnObject(Pointcut thePointcut, HookParams theParams) {
                Object retVal = true;
                if (theInterceptorBroadcaster != null) {
                    retVal = theInterceptorBroadcaster.callHooksAndReturnObject(thePointcut, theParams);
                }
                if (theRequestDetails != null && theRequestDetails.getInterceptorBroadcaster() != null && retVal == null) {
                    IInterceptorBroadcaster interceptorBroadcaster = theRequestDetails.getInterceptorBroadcaster();
                    retVal = interceptorBroadcaster.callHooksAndReturnObject(thePointcut, theParams);
                }
                return retVal;
            }

            @Override
            public boolean hasHooks(Pointcut thePointcut) {
                if (theInterceptorBroadcaster != null && theInterceptorBroadcaster.hasHooks(thePointcut)) {
                    return true;
                }
                return theRequestDetails != null && theRequestDetails.getInterceptorBroadcaster() != null && theRequestDetails.getInterceptorBroadcaster().hasHooks(thePointcut);
            }
        };
    }
}

