/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.Bindings;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerConfiguration;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationParameter;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchParameter;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ResourceSearchParams;
import ca.uhn.fhir.util.ExtensionUtil;
import ca.uhn.fhir.util.FhirTerser;
import com.google.common.collect.TreeMultimap;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCapabilityStatementProvider
implements IServerConformanceProvider<IBaseConformance> {
    public static final boolean DEFAULT_REST_RESOURCE_REV_INCLUDES_ENABLED = true;
    private static final Logger ourLog = LoggerFactory.getLogger(ServerCapabilityStatementProvider.class);
    private final FhirContext myContext;
    private final RestfulServer myServer;
    private final ISearchParamRegistry mySearchParamRegistry;
    private final RestfulServerConfiguration myServerConfiguration;
    private final IValidationSupport myValidationSupport;
    private String myPublisher = "Not provided";
    private boolean myRestResourceRevIncludesEnabled = true;
    private HashMap<String, String> operationCanonicalUrlToId = new HashMap();

    public ServerCapabilityStatementProvider(RestfulServer theServer) {
        this.myServer = theServer;
        this.myContext = theServer.getFhirContext();
        this.mySearchParamRegistry = null;
        this.myServerConfiguration = null;
        this.myValidationSupport = null;
    }

    public ServerCapabilityStatementProvider(FhirContext theContext, RestfulServerConfiguration theServerConfiguration) {
        this.myContext = theContext;
        this.myServerConfiguration = theServerConfiguration;
        this.mySearchParamRegistry = null;
        this.myServer = null;
        this.myValidationSupport = null;
    }

    public ServerCapabilityStatementProvider(RestfulServer theRestfulServer, ISearchParamRegistry theSearchParamRegistry, IValidationSupport theValidationSupport) {
        this.myContext = theRestfulServer.getFhirContext();
        this.mySearchParamRegistry = theSearchParamRegistry;
        this.myServer = theRestfulServer;
        this.myServerConfiguration = null;
        this.myValidationSupport = theValidationSupport;
    }

    private void checkBindingForSystemOps(FhirTerser theTerser, IBase theRest, Set<String> theSystemOps, BaseMethodBinding theMethodBinding) {
        String sysOp;
        RestOperationTypeEnum restOperationType = theMethodBinding.getRestOperationType();
        if (restOperationType.isSystemLevel() && !theSystemOps.contains(sysOp = restOperationType.getCode())) {
            theSystemOps.add(sysOp);
            Object interaction = theTerser.addElement(theRest, "interaction");
            theTerser.addElement((IBase)interaction, "code", sysOp);
        }
    }

    private String conformanceDate(RestfulServerConfiguration theServerConfiguration) {
        IPrimitiveType<Date> buildDate = theServerConfiguration.getConformanceDate();
        if (buildDate != null && buildDate.getValue() != null) {
            try {
                return buildDate.getValueAsString();
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return InstantDt.withCurrentTime().getValueAsString();
    }

    private RestfulServerConfiguration getServerConfiguration() {
        if (this.myServer != null) {
            return this.myServer.createConfiguration();
        }
        return this.myServerConfiguration;
    }

    public String getPublisher() {
        return this.myPublisher;
    }

    public void setPublisher(String thePublisher) {
        this.myPublisher = thePublisher;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Metadata
    public IBaseConformance getServerConformance(HttpServletRequest theRequest, RequestDetails theRequestDetails) {
        HttpServletRequest servletRequest = null;
        if (theRequestDetails instanceof ServletRequestDetails) {
            servletRequest = ((ServletRequestDetails)theRequestDetails).getServletRequest();
        }
        RestfulServerConfiguration configuration = this.getServerConfiguration();
        Bindings bindings = configuration.provideBindings();
        IBaseConformance retVal = (IBaseConformance)this.myContext.getResourceDefinition("CapabilityStatement").newInstance();
        FhirTerser terser = this.myContext.newTerser();
        TreeMultimap<String, String> resourceTypeToSupportedProfiles = this.getSupportedProfileMultimap(terser);
        terser.addElement(retVal, "id", UUID.randomUUID().toString());
        terser.addElement(retVal, "name", "RestServer");
        terser.addElement(retVal, "publisher", this.myPublisher);
        terser.addElement(retVal, "date", this.conformanceDate(configuration));
        terser.addElement(retVal, "fhirVersion", this.myContext.getVersion().getVersion().getFhirVersionString());
        ServletContext servletContext = (ServletContext)(theRequest == null ? null : theRequest.getAttribute("ca.uhn.fhir.rest.server.RestfulServer.servlet_context"));
        String serverBase = configuration.getServerAddressStrategy().determineServerBase(servletContext, theRequest);
        terser.addElement(retVal, "implementation.url", serverBase);
        terser.addElement(retVal, "implementation.description", configuration.getImplementationDescription());
        terser.addElement(retVal, "kind", "instance");
        if (this.myServer != null && StringUtils.isNotBlank(this.myServer.getCopyright())) {
            terser.addElement(retVal, "copyright", this.myServer.getCopyright());
        }
        terser.addElement(retVal, "software.name", configuration.getServerName());
        terser.addElement(retVal, "software.version", configuration.getServerVersion());
        if (this.myContext.isFormatXmlSupported()) {
            terser.addElement(retVal, "format", "application/fhir+xml");
            terser.addElement(retVal, "format", "xml");
        }
        if (this.myContext.isFormatJsonSupported()) {
            terser.addElement(retVal, "format", "application/fhir+json");
            terser.addElement(retVal, "format", "json");
        }
        if (this.myContext.isFormatRdfSupported()) {
            terser.addElement(retVal, "format", "application/x-turtle");
            terser.addElement(retVal, "format", "ttl");
        }
        terser.addElement(retVal, "status", "active");
        Object rest = terser.addElement(retVal, "rest");
        terser.addElement((IBase)rest, "mode", "server");
        HashSet<String> systemOps = new HashSet<String>();
        Map<String, List<BaseMethodBinding>> resourceToMethods = configuration.collectMethodBindings();
        Map<String, Class<? extends IBaseResource>> resourceNameToSharedSupertype = configuration.getNameToSharedSupertype();
        List<BaseMethodBinding> globalMethodBindings = configuration.getGlobalBindings();
        TreeMultimap resourceNameToIncludes = TreeMultimap.create();
        TreeMultimap resourceNameToRevIncludes = TreeMultimap.create();
        for (Map.Entry<String, List<BaseMethodBinding>> nextEntry : resourceToMethods.entrySet()) {
            String resourceName = nextEntry.getKey();
            for (BaseMethodBinding nextMethod : nextEntry.getValue()) {
                if (!(nextMethod instanceof SearchMethodBinding)) continue;
                resourceNameToIncludes.putAll(resourceName, nextMethod.getIncludes());
                resourceNameToRevIncludes.putAll(resourceName, nextMethod.getRevIncludes());
            }
        }
        for (Map.Entry<String, List<BaseMethodBinding>> nextEntry : resourceToMethods.entrySet()) {
            HashSet<String> operationNames = new HashSet<String>();
            String resourceName = nextEntry.getKey();
            if (!nextEntry.getKey().isEmpty()) {
                Iterator nextInclude;
                Object searchParam;
                void var27_27;
                ISearchParamRegistry searchParamRegistry;
                Object operation;
                Object opName;
                OperationMethodBinding methodBinding;
                HashSet resourceOps = new HashSet();
                Object resource = terser.addElement((IBase)rest, "resource");
                this.postProcessRestResource(terser, (IBase)resource, resourceName);
                FhirContext context = configuration.getFhirContext();
                RuntimeResourceDefinition def = resourceNameToSharedSupertype.containsKey(resourceName) ? context.getResourceDefinition(resourceNameToSharedSupertype.get(resourceName)) : context.getResourceDefinition(resourceName);
                terser.addElement((IBase)resource, "type", def.getName());
                terser.addElement((IBase)resource, "profile", def.getResourceProfile(serverBase));
                for (BaseMethodBinding baseMethodBinding : nextEntry.getValue()) {
                    RestOperationTypeEnum resOpCode = baseMethodBinding.getRestOperationType();
                    if (resOpCode.isTypeLevel() || resOpCode.isInstanceLevel()) {
                        Object interaction;
                        String resOp = resOpCode.getCode();
                        if (!resourceOps.contains(resOp)) {
                            resourceOps.add(resOp);
                            interaction = terser.addElement((IBase)resource, "interaction");
                            terser.addElement((IBase)interaction, "code", resOp);
                        }
                        if (RestOperationTypeEnum.VREAD.equals((Object)resOpCode) && !resourceOps.contains(resOp = "read")) {
                            resourceOps.add(resOp);
                            interaction = terser.addElement((IBase)resource, "interaction");
                            terser.addElement((IBase)interaction, "code", resOp);
                        }
                    }
                    if (baseMethodBinding.isSupportsConditional()) {
                        switch (resOpCode) {
                            case CREATE: {
                                terser.setElement((IBase)resource, "conditionalCreate", "true");
                                break;
                            }
                            case DELETE: {
                                if (baseMethodBinding.isSupportsConditionalMultiple()) {
                                    terser.setElement((IBase)resource, "conditionalDelete", "multiple");
                                    break;
                                }
                                terser.setElement((IBase)resource, "conditionalDelete", "single");
                                break;
                            }
                            case UPDATE: {
                                terser.setElement((IBase)resource, "conditionalUpdate", "true");
                                break;
                            }
                        }
                    }
                    this.checkBindingForSystemOps(terser, (IBase)rest, (Set<String>)systemOps, baseMethodBinding);
                    if (baseMethodBinding instanceof SearchMethodBinding) {
                        this.addSearchMethodIfSearchIsNamedQuery(theRequestDetails, bindings, terser, (Set<String>)operationNames, (IBase)resource, (SearchMethodBinding)baseMethodBinding);
                        continue;
                    }
                    if (!(baseMethodBinding instanceof OperationMethodBinding)) continue;
                    methodBinding = (OperationMethodBinding)baseMethodBinding;
                    opName = bindings.getOperationBindingToId().get(methodBinding);
                    if (!operationNames.add((String)opName)) continue;
                    operation = terser.addElement((IBase)resource, "operation");
                    this.populateOperation(theRequestDetails, terser, methodBinding, (String)opName, (IBase)operation);
                }
                if (globalMethodBindings != null) {
                    HashSet<Object> globalOperationNames = new HashSet<Object>();
                    for (BaseMethodBinding next : globalMethodBindings) {
                        if (!(next instanceof OperationMethodBinding) || !(methodBinding = (OperationMethodBinding)next).isGlobalMethod() || !methodBinding.isCanOperateAtInstanceLevel() && !methodBinding.isCanOperateAtTypeLevel() || !globalOperationNames.add(opName = bindings.getOperationBindingToId().get(methodBinding))) continue;
                        operation = terser.addElement((IBase)resource, "operation");
                        this.populateOperation(theRequestDetails, terser, methodBinding, (String)opName, (IBase)operation);
                    }
                }
                RestfulServerConfiguration serverConfiguration = this.myServerConfiguration != null ? this.myServerConfiguration : this.myServer.createConfiguration();
                ResourceSearchParams serverConfigurationActiveSearchParams = serverConfiguration.getActiveSearchParams(resourceName);
                if (this.mySearchParamRegistry != null) {
                    searchParamRegistry = this.mySearchParamRegistry;
                    ResourceSearchParams resourceSearchParams = this.mySearchParamRegistry.getActiveSearchParams(resourceName).makeCopy();
                    for (String nextBuiltInSpName : serverConfigurationActiveSearchParams.getSearchParamNames()) {
                        if (!nextBuiltInSpName.startsWith("_") || resourceSearchParams.containsParamName(nextBuiltInSpName) || !this.searchParamEnabled(nextBuiltInSpName)) continue;
                        resourceSearchParams.put(nextBuiltInSpName, serverConfigurationActiveSearchParams.get(nextBuiltInSpName));
                    }
                } else {
                    searchParamRegistry = serverConfiguration;
                    ResourceSearchParams resourceSearchParams = serverConfigurationActiveSearchParams;
                }
                opName = var27_27.values().iterator();
                while (opName.hasNext()) {
                    String spUri;
                    RuntimeSearchParam next = opName.next();
                    searchParam = terser.addElement((IBase)resource, "searchParam");
                    terser.addElement((IBase)searchParam, "name", next.getName());
                    terser.addElement((IBase)searchParam, "type", next.getParamType().getCode());
                    if (StringUtils.isNotBlank(next.getDescription())) {
                        terser.addElement((IBase)searchParam, "documentation", next.getDescription());
                    }
                    if (!StringUtils.isNotBlank(spUri = next.getUri())) continue;
                    terser.addElement((IBase)searchParam, "definition", spUri);
                }
                SortedSet resourceIncludes = resourceNameToIncludes.get(resourceName);
                if (resourceIncludes.isEmpty()) {
                    List includes = var27_27.values().stream().filter(t -> t.getParamType() == RestSearchParameterTypeEnum.REFERENCE).map(t -> resourceName + ":" + t.getName()).sorted().collect(Collectors.toList());
                    terser.addElement((IBase)resource, "searchInclude", "*");
                    searchParam = includes.iterator();
                    while (searchParam.hasNext()) {
                        nextInclude = (String)searchParam.next();
                        terser.addElement((IBase)resource, "searchInclude", (String)((Object)nextInclude));
                    }
                } else {
                    for (String resourceInclude : resourceIncludes) {
                        terser.addElement((IBase)resource, "searchInclude", resourceInclude);
                    }
                }
                if (this.myRestResourceRevIncludesEnabled) {
                    SortedSet resourceRevIncludes = resourceNameToRevIncludes.get(resourceName);
                    if (resourceRevIncludes.isEmpty()) {
                        TreeSet revIncludes = new TreeSet();
                        for (String nextResourceName : resourceToMethods.keySet()) {
                            if (StringUtils.isBlank(nextResourceName)) continue;
                            for (RuntimeSearchParam t2 : searchParamRegistry.getActiveSearchParams(nextResourceName).values()) {
                                if (t2.getParamType() != RestSearchParameterTypeEnum.REFERENCE || !StringUtils.isNotBlank(t2.getName())) continue;
                                boolean appropriateTarget = false;
                                if (t2.getTargets().contains(resourceName) || t2.getTargets().isEmpty()) {
                                    appropriateTarget = true;
                                }
                                if (!appropriateTarget) continue;
                                revIncludes.add(nextResourceName + ":" + t2.getName());
                            }
                        }
                        nextInclude = revIncludes.iterator();
                        while (nextInclude.hasNext()) {
                            String nextInclude2 = (String)nextInclude.next();
                            terser.addElement((IBase)resource, "searchRevInclude", nextInclude2);
                        }
                    } else {
                        for (String resourceInclude : resourceRevIncludes) {
                            terser.addElement((IBase)resource, "searchRevInclude", resourceInclude);
                        }
                    }
                }
                for (String supportedProfile : resourceTypeToSupportedProfiles.get((Object)resourceName)) {
                    terser.addElement((IBase)resource, "supportedProfile", supportedProfile);
                }
                continue;
            }
            for (BaseMethodBinding nextMethodBinding : nextEntry.getValue()) {
                this.checkBindingForSystemOps(terser, (IBase)rest, (Set<String>)systemOps, nextMethodBinding);
                if (nextMethodBinding instanceof OperationMethodBinding) {
                    String opName;
                    OperationMethodBinding methodBinding = (OperationMethodBinding)nextMethodBinding;
                    if (methodBinding.isGlobalMethod() || !operationNames.add(opName = bindings.getOperationBindingToId().get(methodBinding))) continue;
                    ourLog.debug("Found bound operation: {}", (Object)opName);
                    Object operation = terser.addElement((IBase)rest, "operation");
                    this.populateOperation(theRequestDetails, terser, methodBinding, opName, (IBase)operation);
                    continue;
                }
                if (!(nextMethodBinding instanceof SearchMethodBinding)) continue;
                this.addSearchMethodIfSearchIsNamedQuery(theRequestDetails, bindings, terser, (Set<String>)operationNames, (IBase)rest, (SearchMethodBinding)nextMethodBinding);
            }
        }
        if (globalMethodBindings != null) {
            HashSet<String> globalOperationNames = new HashSet<String>();
            for (BaseMethodBinding next : globalMethodBindings) {
                String opName;
                OperationMethodBinding methodBinding;
                if (!(next instanceof OperationMethodBinding) || !(methodBinding = (OperationMethodBinding)next).isGlobalMethod() || !methodBinding.isCanOperateAtServerLevel() || !globalOperationNames.add(opName = bindings.getOperationBindingToId().get(methodBinding))) continue;
                Object operation = terser.addElement((IBase)rest, "operation");
                this.populateOperation(theRequestDetails, terser, methodBinding, opName, (IBase)operation);
            }
        }
        this.postProcessRest(terser, (IBase)rest);
        this.postProcess(terser, retVal);
        return retVal;
    }

    protected boolean searchParamEnabled(String theSearchParam) {
        return true;
    }

    private void addSearchMethodIfSearchIsNamedQuery(RequestDetails theRequestDetails, Bindings theBindings, FhirTerser theTerser, Set<String> theOperationNamesAlreadyAdded, IBase theElementToAddTo, SearchMethodBinding theSearchMethodBinding) {
        String queryName;
        if (theSearchMethodBinding.getQueryName() != null && theOperationNamesAlreadyAdded.add(queryName = theBindings.getNamedSearchMethodBindingToName().get(theSearchMethodBinding))) {
            Object operation = theTerser.addElement(theElementToAddTo, "operation");
            theTerser.addElement((IBase)operation, "name", theSearchMethodBinding.getQueryName());
            theTerser.addElement((IBase)operation, "definition", this.createOperationUrl(theRequestDetails, queryName));
        }
    }

    private void populateOperation(RequestDetails theRequestDetails, FhirTerser theTerser, OperationMethodBinding theMethodBinding, String theOpName, IBase theOperation) {
        String operationName = theMethodBinding.getName().substring(1);
        theTerser.addElement(theOperation, "name", operationName);
        String operationCanonicalUrl = theMethodBinding.getCanonicalUrl();
        if (StringUtils.isNotBlank(operationCanonicalUrl)) {
            theTerser.addElement(theOperation, "definition", operationCanonicalUrl);
            this.operationCanonicalUrlToId.put(operationCanonicalUrl, theOpName);
        } else {
            theTerser.addElement(theOperation, "definition", this.createOperationUrl(theRequestDetails, theOpName));
        }
        if (StringUtils.isNotBlank(theMethodBinding.getDescription())) {
            theTerser.addElement(theOperation, "documentation", theMethodBinding.getDescription());
        }
    }

    @Nonnull
    private String createOperationUrl(RequestDetails theRequestDetails, String theOpName) {
        return this.getOperationDefinitionPrefix(theRequestDetails) + "OperationDefinition/" + theOpName;
    }

    private TreeMultimap<String, String> getSupportedProfileMultimap(FhirTerser terser) {
        List allStructureDefinitions;
        TreeMultimap<String, String> resourceTypeToSupportedProfiles = TreeMultimap.create();
        if (this.myValidationSupport != null && (allStructureDefinitions = this.myValidationSupport.fetchAllNonBaseStructureDefinitions()) != null) {
            for (IBaseResource next : allStructureDefinitions) {
                String kind = terser.getSinglePrimitiveValueOrNull(next, "kind");
                String url = terser.getSinglePrimitiveValueOrNull(next, "url");
                String baseDefinition = StringUtils.defaultString(terser.getSinglePrimitiveValueOrNull(next, "baseDefinition"));
                if (!"resource".equals(kind) || !StringUtils.isNotBlank(url) || baseDefinition.equals("http://hl7.org/fhir/StructureDefinition/DomainResource") || baseDefinition.equals("http://hl7.org/fhir/StructureDefinition/Resource")) continue;
                String resourceType = terser.getSinglePrimitiveValueOrNull(next, "snapshot.element.path");
                if (StringUtils.isBlank(resourceType)) {
                    resourceType = terser.getSinglePrimitiveValueOrNull(next, "differential.element.path");
                }
                if (!StringUtils.isNotBlank(resourceType)) continue;
                resourceTypeToSupportedProfiles.put((Object)resourceType, (Object)url);
            }
        }
        return resourceTypeToSupportedProfiles;
    }

    protected void postProcess(FhirTerser theTerser, IBaseConformance theCapabilityStatement) {
    }

    protected void postProcessRest(FhirTerser theTerser, IBase theRest) {
    }

    protected void postProcessRestResource(FhirTerser theTerser, IBase theResource, String theResourceName) {
    }

    protected String getOperationDefinitionPrefix(RequestDetails theRequestDetails) {
        if (theRequestDetails == null) {
            return "";
        }
        return theRequestDetails.getServerBaseForRequest() + "/";
    }

    @Override
    @Read(typeName="OperationDefinition")
    public IBaseResource readOperationDefinition(@IdParam IIdType theId, RequestDetails theRequestDetails) {
        if (theId == null || !theId.hasIdPart()) {
            throw new ResourceNotFoundException(Msg.code(1977) + theId);
        }
        RestfulServerConfiguration configuration = this.getServerConfiguration();
        Bindings bindings = configuration.provideBindings();
        String operationId = this.getOperationId(theId);
        List<OperationMethodBinding> operationBindings = bindings.getOperationIdToBindings().get(operationId);
        if (operationBindings != null && !operationBindings.isEmpty()) {
            return this.readOperationDefinitionForOperation(theRequestDetails, bindings, operationBindings);
        }
        List<SearchMethodBinding> searchBindings = bindings.getSearchNameToBindings().get(theId.getIdPart());
        if (searchBindings != null && !searchBindings.isEmpty()) {
            return this.readOperationDefinitionForNamedSearch(searchBindings);
        }
        throw new ResourceNotFoundException(Msg.code(1978) + theId);
    }

    private String getOperationId(IIdType theId) {
        if (this.operationCanonicalUrlToId.get(theId.getValue()) != null) {
            return this.operationCanonicalUrlToId.get(theId.getValue());
        }
        return theId.getIdPart();
    }

    private IBaseResource readOperationDefinitionForNamedSearch(List<SearchMethodBinding> bindings) {
        IBaseResource op = (IBaseResource)this.myContext.getResourceDefinition("OperationDefinition").newInstance();
        FhirTerser terser = this.myContext.newTerser();
        terser.addElement(op, "status", "active");
        terser.addElement(op, "kind", "query");
        terser.addElement(op, "affectsState", "false");
        terser.addElement(op, "instance", "false");
        HashSet<String> inParams = new HashSet<String>();
        String operationCode = null;
        for (SearchMethodBinding binding : bindings) {
            if (StringUtils.isNotBlank(binding.getDescription())) {
                terser.addElement(op, "description", binding.getDescription());
            }
            if (StringUtils.isBlank(binding.getResourceProviderResourceName())) {
                terser.addElement(op, "system", "true");
                terser.addElement(op, "type", "false");
            } else {
                terser.addElement(op, "system", "false");
                terser.addElement(op, "type", "true");
                terser.addElement(op, "resource", binding.getResourceProviderResourceName());
            }
            if (operationCode == null) {
                operationCode = binding.getQueryName();
            }
            for (IParameter nextParamUntyped : binding.getParameters()) {
                SearchParameter nextParam;
                if (!(nextParamUntyped instanceof SearchParameter) || !inParams.add((nextParam = (SearchParameter)nextParamUntyped).getName())) continue;
                Object param = terser.addElement(op, "parameter");
                terser.addElement((IBase)param, "use", "in");
                terser.addElement((IBase)param, "type", "string");
                terser.addElement((IBase)param, "searchType", nextParam.getParamType().getCode());
                terser.addElement((IBase)param, "min", nextParam.isRequired() ? "1" : "0");
                terser.addElement((IBase)param, "max", "1");
                terser.addElement((IBase)param, "name", nextParam.getName());
            }
        }
        terser.addElement(op, "code", operationCode);
        String operationName = WordUtils.capitalize(operationCode);
        terser.addElement(op, "name", operationName);
        return op;
    }

    private IBaseResource readOperationDefinitionForOperation(RequestDetails theRequestDetails, Bindings theBindings, List<OperationMethodBinding> theOperationMethodBindings) {
        IBaseResource op = (IBaseResource)this.myContext.getResourceDefinition("OperationDefinition").newInstance();
        FhirTerser terser = this.myContext.newTerser();
        terser.addElement(op, "status", "active");
        terser.addElement(op, "kind", "operation");
        boolean systemLevel = false;
        boolean typeLevel = false;
        boolean instanceLevel = false;
        boolean affectsState = false;
        String description = null;
        String title = null;
        String code = null;
        String url = null;
        TreeSet<String> resourceNames = new TreeSet<String>();
        HashMap<String, IBase> inParams = new HashMap<String, IBase>();
        HashMap outParams = new HashMap();
        for (OperationMethodBinding operationMethodBinding : theOperationMethodBindings) {
            if (StringUtils.isNotBlank(operationMethodBinding.getDescription()) && StringUtils.isBlank(description)) {
                description = operationMethodBinding.getDescription();
            }
            if (StringUtils.isNotBlank(operationMethodBinding.getShortDescription()) && StringUtils.isBlank(title)) {
                title = operationMethodBinding.getShortDescription();
            }
            if (operationMethodBinding.isCanOperateAtInstanceLevel()) {
                instanceLevel = true;
            }
            if (operationMethodBinding.isCanOperateAtServerLevel()) {
                systemLevel = true;
            }
            if (operationMethodBinding.isCanOperateAtTypeLevel()) {
                typeLevel = true;
            }
            if (!operationMethodBinding.isIdempotent()) {
                affectsState |= true;
            }
            code = operationMethodBinding.getName().substring(1);
            if (StringUtils.isNotBlank(operationMethodBinding.getResourceName())) {
                resourceNames.add(operationMethodBinding.getResourceName());
            }
            if (StringUtils.isBlank(url) && StringUtils.isNotBlank(url = theBindings.getOperationBindingToId().get(operationMethodBinding))) {
                url = this.createOperationUrl(theRequestDetails, url);
            }
            for (IParameter nextParamUntyped : operationMethodBinding.getParameters()) {
                if (!(nextParamUntyped instanceof OperationParameter)) continue;
                OperationParameter nextParam = (OperationParameter)nextParamUntyped;
                IBase param = (IBase)inParams.get(nextParam.getName());
                if (param == null) {
                    param = terser.addElement(op, "parameter");
                    inParams.put(nextParam.getName(), param);
                }
                IBase existingParam = (IBase)inParams.get(nextParam.getName());
                if (StringUtils.isNotBlank(nextParam.getDescription()) && terser.getValues(existingParam, "documentation").isEmpty()) {
                    terser.addElement(existingParam, "documentation", nextParam.getDescription());
                }
                if (nextParam.getParamType() != null) {
                    String existingType = terser.getSinglePrimitiveValueOrNull(existingParam, "type");
                    if (!nextParam.getParamType().equals(existingType)) {
                        if (existingType == null) {
                            terser.setElement(existingParam, "type", nextParam.getParamType());
                        } else {
                            terser.setElement(existingParam, "type", "Resource");
                        }
                    }
                }
                terser.setElement(param, "use", "in");
                if (nextParam.getSearchParamType() != null) {
                    terser.setElement(param, "searchType", nextParam.getSearchParamType());
                }
                terser.setElement(param, "min", Integer.toString(nextParam.getMin()));
                terser.setElement(param, "max", nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                terser.setElement(param, "name", nextParam.getName());
                List<IBaseExtension<?, ?>> existingExampleExtensions = ExtensionUtil.getExtensionsByUrl((IBaseHasExtensions)param, "http://hapifhir.io/fhir/StructureDefinition/op-parameter-example-value");
                Set existingExamples = existingExampleExtensions.stream().map(t -> t.getValue()).filter(t -> t != null).map(t -> (IPrimitiveType)t).map(t -> t.getValueAsString()).collect(Collectors.toSet());
                for (String nextExample : nextParam.getExampleValues()) {
                    if (existingExamples.contains(nextExample)) continue;
                    ExtensionUtil.addExtension(this.myContext, param, "http://hapifhir.io/fhir/StructureDefinition/op-parameter-example-value", "string", nextExample);
                }
            }
            for (OperationMethodBinding.ReturnType nextParam : operationMethodBinding.getReturnParams()) {
                if (outParams.containsKey(nextParam.getName())) continue;
                Object param = terser.addElement(op, "parameter");
                outParams.put(nextParam.getName(), param);
                terser.addElement((IBase)param, "use", "out");
                if (nextParam.getType() != null) {
                    terser.addElement((IBase)param, "type", nextParam.getType());
                }
                terser.addElement((IBase)param, "min", Integer.toString(nextParam.getMin()));
                terser.addElement((IBase)param, "max", nextParam.getMax() == -1 ? "*" : Integer.toString(nextParam.getMax()));
                terser.addElement((IBase)param, "name", nextParam.getName());
            }
        }
        String name = WordUtils.capitalize(code);
        terser.addElements(op, "resource", resourceNames);
        terser.addElement(op, "name", name);
        terser.addElement(op, "url", url);
        terser.addElement(op, "code", code);
        terser.addElement(op, "description", description);
        terser.addElement(op, "title", title);
        terser.addElement(op, "affectsState", Boolean.toString(affectsState));
        terser.addElement(op, "system", Boolean.toString(systemLevel));
        terser.addElement(op, "type", Boolean.toString(typeLevel));
        terser.addElement(op, "instance", Boolean.toString(instanceLevel));
        return op;
    }

    @Override
    public void setRestfulServer(RestfulServer theRestfulServer) {
    }

    public void setRestResourceRevIncludesEnabled(boolean theRestResourceRevIncludesEnabled) {
        this.myRestResourceRevIncludesEnabled = theRestResourceRevIncludesEnabled;
    }
}

