/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import ca.uhn.fhir.util.BundleUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class TransactionParameter
implements IParameter {
    private FhirContext myContext;
    private ParamStyle myParamStyle;
    private Class<? extends IBaseResource> myResourceBundleType;

    TransactionParameter(FhirContext theContext) {
        this.myContext = theContext;
    }

    private String createParameterTypeError(Method theMethod) {
        return "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + TransactionParam.class.getName() + " but is not of type Bundle, IBaseResource, IBaseBundle, or List<" + IResource.class.getCanonicalName() + ">";
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException(Msg.code(429) + "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + TransactionParam.class.getName() + " but can not be a collection of collections");
        }
        if (!Modifier.isInterface(theParameterType.getModifiers()) && IBaseResource.class.isAssignableFrom(theParameterType)) {
            Class<?> parameterType = theParameterType;
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(parameterType);
            if ("Bundle".equals(def.getName())) {
                this.myParamStyle = ParamStyle.RESOURCE_BUNDLE;
                this.myResourceBundleType = parameterType;
                return;
            }
        } else {
            if (theParameterType.equals(IBaseResource.class) || theParameterType.equals(IBaseBundle.class)) {
                this.myParamStyle = ParamStyle.RESOURCE_BUNDLE;
                this.myResourceBundleType = this.myContext.getResourceDefinition("Bundle").getImplementingClass();
                return;
            }
            if (theInnerCollectionType != null) {
                if (!theInnerCollectionType.equals(List.class)) {
                    throw new ConfigurationException(Msg.code(430) + this.createParameterTypeError(theMethod));
                }
                if (!theParameterType.equals(IResource.class)) {
                    throw new ConfigurationException(Msg.code(431) + this.createParameterTypeError(theMethod));
                }
                this.myParamStyle = ParamStyle.RESOURCE_LIST;
                return;
            }
        }
        throw new ConfigurationException(Msg.code(432) + this.createParameterTypeError(theMethod));
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding theMethodBinding) throws InternalErrorException, InvalidRequestException {
        IBaseResource parsedBundle = ResourceParameter.parseResourceFromRequest(theRequest, theMethodBinding, this.myResourceBundleType);
        switch (this.myParamStyle) {
            case RESOURCE_LIST: {
                return BundleUtil.toListOfResources(this.myContext, (IBaseBundle)parsedBundle);
            }
        }
        assert (this.myParamStyle == ParamStyle.RESOURCE_BUNDLE);
        return parsedBundle;
    }

    ParamStyle getParamStyle() {
        return this.myParamStyle;
    }

    public static enum ParamStyle {
        RESOURCE_BUNDLE,
        RESOURCE_LIST;

    }
}

