/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.BundleLinks;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceReturningMethodBinding
extends BaseMethodBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseResourceReturningMethodBinding.class);
    private MethodReturnTypeEnum myMethodReturnType;
    private String myResourceName;

    public BaseResourceReturningMethodBinding(Class<?> theReturnResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider);
        Class<?> methodReturnType = theMethod.getReturnType();
        Set<Class<?>> expectedReturnTypes = this.provideExpectedReturnTypes();
        if (expectedReturnTypes != null) {
            Validate.isTrue(expectedReturnTypes.contains(methodReturnType), "Unexpected method return type on %s - Allowed: %s", theMethod, expectedReturnTypes);
        } else if (Collection.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.LIST_OF_RESOURCES;
            Class<?> collectionType = ReflectionUtil.getGenericCollectionTypeOfMethodReturnType(theMethod);
            if (collectionType != null && !Object.class.equals(collectionType) && !IBaseResource.class.isAssignableFrom(collectionType)) {
                throw new ConfigurationException(Msg.code(433) + "Method " + theMethod.getDeclaringClass().getSimpleName() + "#" + theMethod.getName() + " returns an invalid collection generic type: " + collectionType);
            }
        } else if (IBaseResource.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = IBaseBundle.class.isAssignableFrom(methodReturnType) ? MethodReturnTypeEnum.BUNDLE_RESOURCE : MethodReturnTypeEnum.RESOURCE;
        } else if (IBundleProvider.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.BUNDLE_PROVIDER;
        } else if (MethodOutcome.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.METHOD_OUTCOME;
        } else if (Void.TYPE.equals(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.VOID;
        } else {
            throw new ConfigurationException(Msg.code(434) + "Invalid return type '" + methodReturnType.getCanonicalName() + "' on method '" + theMethod.getName() + "' on type: " + theMethod.getDeclaringClass().getCanonicalName());
        }
        if (theReturnResourceType != null && IBaseResource.class.isAssignableFrom(theReturnResourceType) && !Modifier.isAbstract(theReturnResourceType.getModifiers()) && !Modifier.isInterface(theReturnResourceType.getModifiers())) {
            Class<?> resourceType = theReturnResourceType;
            RuntimeResourceDefinition resourceDefinition = theContext.getResourceDefinition(resourceType);
            this.myResourceName = resourceDefinition.getName();
        }
    }

    protected Set<Class<?>> provideExpectedReturnTypes() {
        return null;
    }

    IBaseResource createBundleFromBundleProvider(IRestfulServer<?> theServer, RequestDetails theRequest, Integer theLimit, String theLinkSelf, Set<Include> theIncludes, IBundleProvider theResult, int theOffset, BundleTypeEnum theBundleType, EncodingEnum theLinkEncoding, String theSearchId) {
        List<Object> resourceList;
        int numToReturn;
        int pageSize;
        Integer offset;
        IVersionSpecificBundleFactory bundleFactory = theServer.getFhirContext().newBundleFactory();
        Integer limit = theLimit;
        if (theResult.getCurrentPageOffset() != null) {
            offset = theResult.getCurrentPageOffset();
            limit = theResult.getCurrentPageSize();
            Validate.notNull(limit, "IBundleProvider returned a non-null offset, but did not return a non-null page size", new Object[0]);
        } else {
            offset = RestfulServerUtils.tryToExtractNamedParameter(theRequest, "_offset");
        }
        String searchId = null;
        Integer numTotalResults = theResult.size();
        if (offset != null || !theServer.canStoreSearchResults()) {
            pageSize = limit != null ? limit : (theServer.getDefaultPageSize() != null ? theServer.getDefaultPageSize() : (numTotalResults != null ? numTotalResults : Integer.MAX_VALUE));
            numToReturn = pageSize;
            resourceList = offset != null && !this.isOffsetModeHistory() || theResult.getCurrentPageOffset() != null ? theResult.getResources(0, Integer.MAX_VALUE) : (numToReturn > 0 ? theResult.getResources(0, numToReturn) : Collections.emptyList());
            RestfulServerUtils.validateResourceListNotNull(resourceList);
        } else {
            IPagingProvider pagingProvider = theServer.getPagingProvider();
            pageSize = limit == null || limit.equals(0) ? pagingProvider.getDefaultPageSize() : Math.min(pagingProvider.getMaximumPageSize(), limit);
            numToReturn = pageSize;
            if (numTotalResults != null) {
                numToReturn = Math.min(numToReturn, numTotalResults - theOffset);
            }
            resourceList = numToReturn > 0 || theResult.getCurrentPageId() != null ? theResult.getResources(theOffset, numToReturn + theOffset) : Collections.emptyList();
            RestfulServerUtils.validateResourceListNotNull(resourceList);
            if (numTotalResults == null) {
                numTotalResults = theResult.size();
            }
            if (theSearchId != null) {
                searchId = theSearchId;
            } else if ((numTotalResults == null || numTotalResults > numToReturn) && StringUtils.isBlank(searchId = pagingProvider.storeResultList(theRequest, theResult))) {
                ourLog.info("Found {} results but paging provider did not provide an ID to use for paging", (Object)numTotalResults);
                searchId = null;
            }
        }
        boolean hasNull = false;
        for (IBaseResource iBaseResource : resourceList) {
            if (iBaseResource != null) continue;
            hasNull = true;
            break;
        }
        if (hasNull) {
            resourceList.removeIf(Objects::isNull);
        }
        for (IBaseResource iBaseResource : resourceList) {
            if (iBaseResource.getIdElement() != null && !iBaseResource.getIdElement().isEmpty() || iBaseResource instanceof IBaseOperationOutcome) continue;
            throw new InternalErrorException(Msg.code(435) + "Server method returned resource of type[" + iBaseResource.getClass().getSimpleName() + "] with no ID specified (IResource#setId(IdDt) must be called)");
        }
        BundleLinks links = new BundleLinks(theRequest.getFhirServerBase(), theIncludes, RestfulServerUtils.prettyPrintResponse(theServer, theRequest), theBundleType);
        links.setSelf(theLinkSelf);
        if (theResult.getCurrentPageOffset() != null) {
            if (StringUtils.isNotBlank(theResult.getNextPageId())) {
                links.setNext(RestfulServerUtils.createOffsetPagingLink(links, theRequest.getRequestPath(), theRequest.getTenantId(), offset + limit, limit, theRequest.getParameters()));
            }
            if (StringUtils.isNotBlank(theResult.getPreviousPageId())) {
                links.setNext(RestfulServerUtils.createOffsetPagingLink(links, theRequest.getRequestPath(), theRequest.getTenantId(), Math.max(offset - limit, 0), limit, theRequest.getParameters()));
            }
        }
        if (offset != null || !theServer.canStoreSearchResults() && !this.isEverythingOperation(theRequest) || this.isOffsetModeHistory()) {
            int n;
            int n2 = numToReturn;
            if (theServer.getPagingProvider() == null && offset != null) {
                n = n2 + offset;
            }
            if (!(numTotalResults != null && n >= numTotalResults || resourceList.isEmpty())) {
                links.setNext(RestfulServerUtils.createOffsetPagingLink(links, theRequest.getRequestPath(), theRequest.getTenantId(), ObjectUtils.defaultIfNull(offset, 0) + numToReturn, numToReturn, theRequest.getParameters()));
            }
            if (offset != null && offset > 0) {
                int start = Math.max(0, theOffset - pageSize);
                links.setPrev(RestfulServerUtils.createOffsetPagingLink(links, theRequest.getRequestPath(), theRequest.getTenantId(), start, pageSize, theRequest.getParameters()));
            }
        } else if (StringUtils.isNotBlank(theResult.getCurrentPageId())) {
            searchId = theResult.getUuid();
            if (StringUtils.isNotBlank(theResult.getNextPageId())) {
                links.setNext(RestfulServerUtils.createPagingLink(links, theRequest, searchId, theResult.getNextPageId(), theRequest.getParameters()));
            }
            if (StringUtils.isNotBlank(theResult.getPreviousPageId())) {
                links.setPrev(RestfulServerUtils.createPagingLink(links, theRequest, searchId, theResult.getPreviousPageId(), theRequest.getParameters()));
            }
        } else if (searchId != null && resourceList.size() > 0) {
            if (numTotalResults == null || theOffset + numToReturn < numTotalResults) {
                links.setNext(RestfulServerUtils.createPagingLink(links, theRequest, searchId, theOffset + numToReturn, numToReturn, theRequest.getParameters()));
            }
            if (theOffset > 0) {
                int n = Math.max(0, theOffset - pageSize);
                links.setPrev(RestfulServerUtils.createPagingLink(links, theRequest, searchId, n, pageSize, theRequest.getParameters()));
            }
        }
        bundleFactory.addRootPropertiesToBundle(theResult.getUuid(), links, theResult.size(), theResult.getPublished());
        bundleFactory.addResourcesToBundle(new ArrayList<Object>(resourceList), theBundleType, links.serverBase, theServer.getBundleInclusionRule(), theIncludes);
        return bundleFactory.getResourceBundle();
    }

    protected boolean isOffsetModeHistory() {
        return false;
    }

    private boolean isEverythingOperation(RequestDetails theRequest) {
        return (theRequest.getRestOperationType() == RestOperationTypeEnum.EXTENDED_OPERATION_TYPE || theRequest.getRestOperationType() == RestOperationTypeEnum.EXTENDED_OPERATION_INSTANCE) && theRequest.getOperation() != null && theRequest.getOperation().equals("$everything");
    }

    public IBaseResource doInvokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) {
        IBaseResource responseObject;
        Object[] params = this.createMethodParams(theRequest);
        Object resultObj = this.invokeServer(theServer, theRequest, params);
        if (resultObj == null) {
            return null;
        }
        Integer count = RestfulServerUtils.extractCountParameter(theRequest);
        switch (this.getReturnType()) {
            case BUNDLE: {
                Integer offset;
                BundleLinks bundleLinks = new BundleLinks(theRequest.getServerBaseForRequest(), null, RestfulServerUtils.prettyPrintResponse(theServer, theRequest), this.getResponseBundleType());
                bundleLinks.setSelf(RestfulServerUtils.createLinkSelf(theRequest.getFhirServerBase(), theRequest));
                if (this.getMethodReturnType() == MethodReturnTypeEnum.BUNDLE_RESOURCE) {
                    IPrimitiveType<Date> lastUpdated;
                    IBaseResource resource;
                    if (resultObj instanceof IBundleProvider) {
                        IBundleProvider result = (IBundleProvider)resultObj;
                        resource = result.getResources(0, 1).get(0);
                        lastUpdated = result.getPublished();
                    } else {
                        resource = (IBaseResource)resultObj;
                        lastUpdated = theServer.getFhirContext().getVersion().getLastUpdated(resource);
                    }
                    IVersionSpecificBundleFactory bundleFactory = theServer.getFhirContext().newBundleFactory();
                    bundleFactory.initializeWithBundleResource(resource);
                    bundleFactory.addRootPropertiesToBundle(null, bundleLinks, count, lastUpdated);
                    responseObject = resource;
                    break;
                }
                Set<Include> includes = this.getRequestIncludesFromParams(params);
                IBundleProvider result = (IBundleProvider)resultObj;
                if (count == null) {
                    count = result.preferredPageSize();
                }
                if ((offset = RestfulServerUtils.tryToExtractNamedParameter(theRequest, "_getpagesoffset")) == null || offset < 0) {
                    offset = 0;
                }
                Integer resultSize = result.size();
                int start = offset;
                if (resultSize != null) {
                    start = Math.max(0, Math.min(offset, resultSize));
                }
                RestfulServerUtils.ResponseEncoding responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequest, theServer.getDefaultResponseEncoding());
                EncodingEnum linkEncoding = theRequest.getParameters().containsKey("_format") && responseEncoding != null ? responseEncoding.getEncoding() : null;
                responseObject = this.createBundleFromBundleProvider(theServer, theRequest, count, RestfulServerUtils.createLinkSelf(theRequest.getFhirServerBase(), theRequest), includes, result, start, this.getResponseBundleType(), linkEncoding, null);
                break;
            }
            case RESOURCE: {
                IBaseResource resource;
                IBundleProvider result = (IBundleProvider)resultObj;
                if (result.size() == 0) {
                    throw new ResourceNotFoundException(Msg.code(436) + "Resource " + theRequest.getId() + " is not known");
                }
                if (result.size() > 1) {
                    throw new InternalErrorException(Msg.code(437) + "Method returned multiple resources");
                }
                responseObject = resource = result.getResources(0, 1).get(0);
                break;
            }
            default: {
                throw new IllegalStateException(Msg.code(438));
            }
        }
        return responseObject;
    }

    public MethodReturnTypeEnum getMethodReturnType() {
        return this.myMethodReturnType;
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    protected void setResourceName(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    protected abstract BundleTypeEnum getResponseBundleType();

    public abstract ReturnTypeEnum getReturnType();

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        IBaseResource response = this.doInvokeServer(theServer, theRequest);
        if (response == null) {
            ResponseDetails responseDetails = new ResponseDetails();
            responseDetails.setResponseCode(200);
            BaseResourceReturningMethodBinding.callOutgoingResponseHook(theRequest, responseDetails);
            return null;
        }
        Set<SummaryEnum> summaryMode = RestfulServerUtils.determineSummaryMode(theRequest);
        ResponseDetails responseDetails = new ResponseDetails();
        responseDetails.setResponseResource(response);
        responseDetails.setResponseCode(200);
        if (!BaseResourceReturningMethodBinding.callOutgoingResponseHook(theRequest, responseDetails)) {
            return null;
        }
        return RestfulServerUtils.streamResponseAsResource(theServer, responseDetails.getResponseResource(), summaryMode, responseDetails.getResponseCode(), this.isAddContentLocationHeader(), theRequest.isRespondGzip(), theRequest, null, null);
    }

    public abstract Object invokeServer(IRestfulServer<?> var1, RequestDetails var2, Object[] var3) throws InvalidRequestException, InternalErrorException;

    protected boolean isAddContentLocationHeader() {
        return true;
    }

    public static boolean callOutgoingResponseHook(RequestDetails theRequest, ResponseDetails theResponseDetails) {
        HttpServletRequest servletRequest = null;
        HttpServletResponse servletResponse = null;
        if (theRequest instanceof ServletRequestDetails) {
            servletRequest = ((ServletRequestDetails)theRequest).getServletRequest();
            servletResponse = ((ServletRequestDetails)theRequest).getServletResponse();
        }
        HookParams responseParams = new HookParams();
        responseParams.add(RequestDetails.class, theRequest);
        responseParams.addIfMatchesType(ServletRequestDetails.class, theRequest);
        responseParams.add(IBaseResource.class, theResponseDetails.getResponseResource());
        responseParams.add(ResponseDetails.class, theResponseDetails);
        responseParams.add(HttpServletRequest.class, servletRequest);
        responseParams.add(HttpServletResponse.class, servletResponse);
        return theRequest.getInterceptorBroadcaster() == null || theRequest.getInterceptorBroadcaster().callHooks(Pointcut.SERVER_OUTGOING_RESPONSE, responseParams);
    }

    public static void callOutgoingFailureOperationOutcomeHook(RequestDetails theRequestDetails, IBaseOperationOutcome theOperationOutcome) {
        HookParams responseParams = new HookParams();
        responseParams.add(RequestDetails.class, theRequestDetails);
        responseParams.addIfMatchesType(ServletRequestDetails.class, theRequestDetails);
        responseParams.add(IBaseOperationOutcome.class, theOperationOutcome);
        if (theRequestDetails.getInterceptorBroadcaster() != null) {
            theRequestDetails.getInterceptorBroadcaster().callHooks(Pointcut.SERVER_OUTGOING_FAILURE_OPERATIONOUTCOME, responseParams);
        }
    }

    public static enum MethodReturnTypeEnum {
        BUNDLE,
        BUNDLE_PROVIDER,
        BUNDLE_RESOURCE,
        LIST_OF_RESOURCES,
        METHOD_OUTCOME,
        VOID,
        RESOURCE;

    }

    public static enum ReturnTypeEnum {
        BUNDLE,
        RESOURCE;

    }
}

