/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.QualifierDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQueryParameter
implements IParameter {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseQueryParameter.class);

    public abstract List<QualifiedParamList> encode(FhirContext var1, Object var2) throws InternalErrorException;

    public abstract String getName();

    public abstract RestSearchParameterTypeEnum getParamType();

    public Set<String> getQualifierBlacklist() {
        return null;
    }

    public Set<String> getQualifierWhitelist() {
        return null;
    }

    protected abstract boolean supportsRepetition();

    public abstract boolean handlesMissing();

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
    }

    public abstract boolean isRequired();

    public abstract Object parse(FhirContext var1, List<QualifiedParamList> var2) throws InternalErrorException, InvalidRequestException;

    private void parseParams(RequestDetails theRequest, List<QualifiedParamList> paramList, String theQualifiedParamName, String theQualifier) {
        QualifierDetails qualifiers = QualifierDetails.extractQualifiersFromParameterName(theQualifier);
        if (!qualifiers.passes(this.getQualifierWhitelist(), this.getQualifierBlacklist())) {
            return;
        }
        String[] value = theRequest.getParameters().get(theQualifiedParamName);
        if (value != null) {
            for (String nextParam : value) {
                if (!nextParam.contains(",")) {
                    paramList.add(QualifiedParamList.singleton(theQualifier, nextParam));
                    continue;
                }
                paramList.add(QualifiedParamList.splitQueryStringByCommasIgnoreEscape(theQualifier, nextParam));
            }
        }
    }

    @Override
    public Object translateQueryParametersIntoServerArgument(RequestDetails theRequest, BaseMethodBinding theMethodBinding) throws InternalErrorException, InvalidRequestException {
        ArrayList<QualifiedParamList> paramList = new ArrayList<QualifiedParamList>();
        String name = this.getName();
        this.parseParams(theRequest, paramList, name, null);
        List<String> qualified = theRequest.getUnqualifiedToQualifiedNames().get(name);
        if (qualified != null) {
            for (String nextQualified : qualified) {
                this.parseParams(theRequest, paramList, nextQualified, nextQualified.substring(name.length()));
            }
        }
        if (paramList.isEmpty()) {
            ourLog.debug("No value for parameter '{}' - Qualified names {} and qualifier whitelist {}", this.getName(), qualified, this.getQualifierWhitelist());
            if (this.handlesMissing()) {
                return this.parse(theRequest.getFhirContext(), paramList);
            }
            return null;
        }
        return this.parse(theRequest.getFhirContext(), paramList);
    }
}

