/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.annotation.AddTags;
import ca.uhn.fhir.rest.annotation.Create;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.annotation.DeleteTags;
import ca.uhn.fhir.rest.annotation.GetPage;
import ca.uhn.fhir.rest.annotation.GraphQL;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.Patch;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.annotation.Validate;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.BundleProviders;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.method.BaseQueryParameter;
import ca.uhn.fhir.rest.server.method.ConditionalParamBinder;
import ca.uhn.fhir.rest.server.method.ConformanceMethodBinding;
import ca.uhn.fhir.rest.server.method.CreateMethodBinding;
import ca.uhn.fhir.rest.server.method.DeleteMethodBinding;
import ca.uhn.fhir.rest.server.method.GraphQLMethodBinding;
import ca.uhn.fhir.rest.server.method.HistoryMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.IncludeParameter;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import ca.uhn.fhir.rest.server.method.MethodUtil;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.PageMethodBinding;
import ca.uhn.fhir.rest.server.method.PatchMethodBinding;
import ca.uhn.fhir.rest.server.method.ReadMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.rest.server.method.TransactionMethodBinding;
import ca.uhn.fhir.rest.server.method.UpdateMethodBinding;
import ca.uhn.fhir.rest.server.method.ValidateMethodBindingDstu2Plus;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMethodBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseMethodBinding.class);
    private final List<BaseQueryParameter> myQueryParameters;
    private FhirContext myContext;
    private Method myMethod;
    private List<IParameter> myParameters;
    private Object myProvider;
    private boolean mySupportsConditional;
    private boolean mySupportsConditionalMultiple;

    public BaseMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        assert (theMethod != null);
        assert (theContext != null);
        this.myMethod = theMethod;
        this.myContext = theContext;
        this.myProvider = theProvider;
        this.myParameters = MethodUtil.getResourceParameters(theContext, theMethod, theProvider);
        this.myQueryParameters = this.myParameters.stream().filter(t -> t instanceof BaseQueryParameter).map(t -> (BaseQueryParameter)t).collect(Collectors.toList());
        for (IParameter next : this.myParameters) {
            if (!(next instanceof ConditionalParamBinder)) continue;
            this.mySupportsConditional = true;
            if (!((ConditionalParamBinder)next).isSupportsMultiple()) break;
            this.mySupportsConditionalMultiple = true;
            break;
        }
        this.myMethod.setAccessible(true);
    }

    protected List<BaseQueryParameter> getQueryParameters() {
        return this.myQueryParameters;
    }

    protected Object[] createMethodParams(RequestDetails theRequest) {
        Object[] params = new Object[this.getParameters().size()];
        for (int i2 = 0; i2 < this.getParameters().size(); ++i2) {
            IParameter param = this.getParameters().get(i2);
            if (param == null) continue;
            params[i2] = param.translateQueryParametersIntoServerArgument(theRequest, this);
        }
        return params;
    }

    protected Object[] createParametersForServerRequest(RequestDetails theRequest) {
        Object[] params = new Object[this.getParameters().size()];
        for (int i2 = 0; i2 < this.getParameters().size(); ++i2) {
            IParameter param = this.getParameters().get(i2);
            if (param == null) continue;
            params[i2] = param.translateQueryParametersIntoServerArgument(theRequest, this);
        }
        return params;
    }

    public boolean isGlobalMethod() {
        return false;
    }

    public List<Class<?>> getAllowableParamAnnotations() {
        return null;
    }

    public FhirContext getContext() {
        return this.myContext;
    }

    public Set<String> getIncludes() {
        return this.doGetIncludesOrRevIncludes(false);
    }

    public Set<String> getRevIncludes() {
        return this.doGetIncludesOrRevIncludes(true);
    }

    private Set<String> doGetIncludesOrRevIncludes(boolean reverse) {
        TreeSet<String> retVal = new TreeSet<String>();
        for (IParameter next : this.myParameters) {
            IncludeParameter includeParameter;
            if (!(next instanceof IncludeParameter) || (includeParameter = (IncludeParameter)next).isReverse() != reverse) continue;
            retVal.addAll(includeParameter.getAllow());
        }
        return retVal;
    }

    public Method getMethod() {
        return this.myMethod;
    }

    public List<IParameter> getParameters() {
        return this.myParameters;
    }

    public void setParameters(List<IParameter> theParameters) {
        this.myParameters = theParameters;
    }

    public Object getProvider() {
        return this.myProvider;
    }

    public Set<Include> getRequestIncludesFromParams(Object[] params) {
        if (params == null || params.length == 0) {
            return null;
        }
        int index = 0;
        boolean match = false;
        for (IParameter parameter : this.myParameters) {
            if (parameter instanceof IncludeParameter) {
                match = true;
                break;
            }
            ++index;
        }
        if (!match) {
            return null;
        }
        if (index >= params.length) {
            ourLog.warn("index out of parameter range (should never happen");
            return null;
        }
        if (params[index] instanceof Set) {
            return (Set)params[index];
        }
        if (params[index] instanceof Iterable) {
            HashSet<Include> includes = new HashSet<Include>();
            for (Object o : (Iterable)params[index]) {
                if (!(o instanceof Include)) continue;
                includes.add((Include)o);
            }
            return includes;
        }
        ourLog.warn("include params wasn't Set or Iterable, it was {}", (Object)params[index].getClass());
        return null;
    }

    public abstract String getResourceName();

    @Nonnull
    public abstract RestOperationTypeEnum getRestOperationType();

    public RestOperationTypeEnum getRestOperationType(RequestDetails theRequestDetails) {
        return this.getRestOperationType();
    }

    public abstract MethodMatchEnum incomingServerRequestMatchesMethod(RequestDetails var1);

    public abstract Object invokeServer(IRestfulServer<?> var1, RequestDetails var2) throws BaseServerResponseException, IOException;

    protected final Object invokeServerMethod(RequestDetails theRequest, Object[] theMethodParams) {
        RestOperationTypeEnum operationType = this.getRestOperationType(theRequest);
        if (operationType != null) {
            this.populateRequestDetailsForInterceptor(theRequest, theMethodParams);
            HookParams preHandledParams = new HookParams();
            preHandledParams.add(RestOperationTypeEnum.class, theRequest.getRestOperationType());
            preHandledParams.add(RequestDetails.class, theRequest);
            preHandledParams.addIfMatchesType(ServletRequestDetails.class, theRequest);
            if (theRequest.getInterceptorBroadcaster() != null) {
                theRequest.getInterceptorBroadcaster().callHooks(Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED, preHandledParams);
            }
        }
        try {
            Method method = this.getMethod();
            return method.invoke(this.getProvider(), theMethodParams);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof BaseServerResponseException) {
                throw (BaseServerResponseException)e.getCause();
            }
            if (e.getTargetException() instanceof DataFormatException) {
                throw (DataFormatException)e.getTargetException();
            }
            throw new InternalErrorException(Msg.code(389) + "Failed to call access method: " + e.getCause(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException(Msg.code(390) + "Failed to call access method: " + e.getCause(), (Throwable)e);
        }
    }

    public boolean isSupportsConditional() {
        return this.mySupportsConditional;
    }

    public boolean isSupportsConditionalMultiple() {
        return this.mySupportsConditionalMultiple;
    }

    protected void populateRequestDetailsForInterceptor(RequestDetails theRequestDetails, Object[] theMethodParams) {
    }

    protected IBundleProvider toResourceList(Object response) throws InternalErrorException {
        if (response == null) {
            return BundleProviders.newEmptyList();
        }
        if (response instanceof IBundleProvider) {
            return (IBundleProvider)response;
        }
        if (response instanceof IBaseResource) {
            return BundleProviders.newList((IBaseResource)response);
        }
        if (response instanceof Collection) {
            ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
            for (Object next : (Collection)response) {
                retVal.add((IBaseResource)next);
            }
            return BundleProviders.newList(retVal);
        }
        if (response instanceof MethodOutcome) {
            IBaseResource retVal = ((MethodOutcome)response).getOperationOutcome();
            if (retVal == null) {
                retVal = (IBaseResource)this.getContext().getResourceDefinition("OperationOutcome").newInstance();
            }
            return BundleProviders.newList(retVal);
        }
        throw new InternalErrorException(Msg.code(391) + "Unexpected return type: " + response.getClass().getCanonicalName());
    }

    public void close() {
    }

    public static BaseMethodBinding bindMethod(Method theMethod, FhirContext theContext, Object theProvider) {
        Class<IBaseResource> returnType;
        GraphQL graphQL;
        Patch patch2;
        GetPage getPage;
        Operation operation;
        Transaction transaction;
        DeleteTags deleteTags;
        AddTags addTags;
        Validate validate;
        History history;
        Delete delete2;
        Update update;
        Create create;
        Metadata conformance;
        Search search;
        Read read = theMethod.getAnnotation(Read.class);
        if (!BaseMethodBinding.verifyMethodHasZeroOrOneOperationAnnotation(theMethod, read, search = theMethod.getAnnotation(Search.class), conformance = theMethod.getAnnotation(Metadata.class), create = theMethod.getAnnotation(Create.class), update = theMethod.getAnnotation(Update.class), delete2 = theMethod.getAnnotation(Delete.class), history = theMethod.getAnnotation(History.class), validate = theMethod.getAnnotation(Validate.class), addTags = theMethod.getAnnotation(AddTags.class), deleteTags = theMethod.getAnnotation(DeleteTags.class), transaction = theMethod.getAnnotation(Transaction.class), operation = theMethod.getAnnotation(Operation.class), getPage = theMethod.getAnnotation(GetPage.class), patch2 = theMethod.getAnnotation(Patch.class), graphQL = theMethod.getAnnotation(GraphQL.class))) {
            return null;
        }
        if (getPage != null) {
            return new PageMethodBinding(theContext, theMethod);
        }
        if (graphQL != null) {
            return new GraphQLMethodBinding(theMethod, graphQL.type(), theContext, theProvider);
        }
        Class<? extends IBaseResource> returnTypeFromRp = null;
        if (theProvider instanceof IResourceProvider && !BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromRp = ((IResourceProvider)theProvider).getResourceType())) {
            throw new ConfigurationException(Msg.code(392) + "getResourceType() from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returned " + BaseMethodBinding.toLogString(returnTypeFromRp) + " - Must return a resource type");
        }
        Class<?> returnTypeFromMethod = theMethod.getReturnType();
        if (!(MethodOutcome.class.isAssignableFrom(returnTypeFromMethod) || IBundleProvider.class.equals(returnTypeFromMethod) || Void.TYPE.equals(returnTypeFromMethod))) {
            if (Collection.class.isAssignableFrom(returnTypeFromMethod)) {
                returnTypeFromMethod = ReflectionUtil.getGenericCollectionTypeOfMethodReturnType(theMethod);
                if (returnTypeFromMethod == null) {
                    ourLog.trace("Method {} returns a non-typed list, can't verify return type", (Object)theMethod);
                } else if (!BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromMethod) && !BaseMethodBinding.isResourceInterface(returnTypeFromMethod)) {
                    throw new ConfigurationException(Msg.code(393) + "Method '" + theMethod.getName() + "' from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returns a collection with generic type " + BaseMethodBinding.toLogString(returnTypeFromMethod) + " - Must return a resource type or a collection (List, Set) with a resource type parameter (e.g. List<Patient> or List<IBaseResource> )");
                }
            } else if (IBaseBundle.class.isAssignableFrom(returnTypeFromMethod) && returnTypeFromRp == null) {
                returnTypeFromMethod = null;
            } else if (!BaseMethodBinding.isResourceInterface(returnTypeFromMethod) && !BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromMethod)) {
                throw new ConfigurationException(Msg.code(394) + "Method '" + theMethod.getName() + "' from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returns " + BaseMethodBinding.toLogString(returnTypeFromMethod) + " - Must return a resource type (eg Patient, Bundle, " + IBundleProvider.class.getSimpleName() + ", etc., see the documentation for more details)");
            }
        }
        Class returnTypeFromAnnotation = IBaseResource.class;
        String returnTypeNameFromAnnotation = null;
        if (read != null) {
            returnTypeFromAnnotation = read.type();
            returnTypeNameFromAnnotation = read.typeName();
        } else if (search != null) {
            returnTypeFromAnnotation = search.type();
            returnTypeNameFromAnnotation = search.typeName();
        } else if (history != null) {
            returnTypeFromAnnotation = history.type();
            returnTypeNameFromAnnotation = history.typeName();
        } else if (delete2 != null) {
            returnTypeFromAnnotation = delete2.type();
            returnTypeNameFromAnnotation = delete2.typeName();
        } else if (patch2 != null) {
            returnTypeFromAnnotation = patch2.type();
            returnTypeNameFromAnnotation = patch2.typeName();
        } else if (create != null) {
            returnTypeFromAnnotation = create.type();
            returnTypeNameFromAnnotation = create.typeName();
        } else if (update != null) {
            returnTypeFromAnnotation = update.type();
            returnTypeNameFromAnnotation = update.typeName();
        } else if (validate != null) {
            returnTypeFromAnnotation = validate.type();
            returnTypeNameFromAnnotation = validate.typeName();
        } else if (addTags != null) {
            returnTypeFromAnnotation = addTags.type();
            returnTypeNameFromAnnotation = addTags.typeName();
        } else if (deleteTags != null) {
            returnTypeFromAnnotation = deleteTags.type();
            returnTypeNameFromAnnotation = deleteTags.typeName();
        }
        if (StringUtils.isNotBlank(returnTypeNameFromAnnotation)) {
            returnTypeFromAnnotation = theContext.getResourceDefinition(returnTypeNameFromAnnotation).getImplementingClass();
        }
        if (returnTypeFromRp != null) {
            if (returnTypeFromAnnotation != null && !BaseMethodBinding.isResourceInterface(returnTypeFromAnnotation)) {
                if (returnTypeFromMethod != null && !returnTypeFromRp.isAssignableFrom(returnTypeFromMethod)) {
                    throw new ConfigurationException(Msg.code(395) + "Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " returns type " + returnTypeFromMethod.getCanonicalName() + " - Must return " + returnTypeFromRp.getCanonicalName() + " (or a subclass of it) per IResourceProvider contract");
                }
                if (!returnTypeFromRp.isAssignableFrom(returnTypeFromAnnotation)) {
                    throw new ConfigurationException(Msg.code(396) + "Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " claims to return type " + returnTypeFromAnnotation.getCanonicalName() + " per method annotation - Must return " + returnTypeFromRp.getCanonicalName() + " (or a subclass of it) per IResourceProvider contract");
                }
                returnType = returnTypeFromAnnotation;
            } else {
                returnType = returnTypeFromRp;
            }
        } else if (!BaseMethodBinding.isResourceInterface(returnTypeFromAnnotation)) {
            if (!BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromAnnotation)) {
                throw new ConfigurationException(Msg.code(397) + "Method '" + theMethod.getName() + "' from " + IResourceProvider.class.getSimpleName() + " type " + theMethod.getDeclaringClass().getCanonicalName() + " returns " + BaseMethodBinding.toLogString(returnTypeFromAnnotation) + " according to annotation - Must return a resource type");
            }
            returnType = returnTypeFromAnnotation;
        } else {
            returnType = returnTypeFromMethod;
        }
        if (read != null) {
            return new ReadMethodBinding((Class<? extends IBaseResource>)returnType, theMethod, theContext, theProvider);
        }
        if (search != null) {
            return new SearchMethodBinding(returnType, returnTypeFromRp, theMethod, theContext, theProvider);
        }
        if (conformance != null) {
            return new ConformanceMethodBinding(theMethod, theContext, theProvider);
        }
        if (create != null) {
            return new CreateMethodBinding(theMethod, theContext, theProvider);
        }
        if (update != null) {
            return new UpdateMethodBinding(theMethod, theContext, theProvider);
        }
        if (delete2 != null) {
            return new DeleteMethodBinding(theMethod, theContext, theProvider);
        }
        if (patch2 != null) {
            return new PatchMethodBinding(theMethod, theContext, theProvider);
        }
        if (history != null) {
            return new HistoryMethodBinding(theMethod, theContext, theProvider);
        }
        if (validate != null) {
            return new ValidateMethodBindingDstu2Plus(returnType, returnTypeFromRp, theMethod, theContext, theProvider, validate);
        }
        if (transaction != null) {
            return new TransactionMethodBinding(theMethod, theContext, theProvider);
        }
        if (operation != null) {
            return new OperationMethodBinding(returnType, returnTypeFromRp, theMethod, theContext, theProvider, operation);
        }
        throw new ConfigurationException(Msg.code(398) + "Did not detect any FHIR annotations on method '" + theMethod.getName() + "' on type: " + theMethod.getDeclaringClass().getCanonicalName());
    }

    private static boolean isResourceInterface(Class<?> theReturnTypeFromMethod) {
        return theReturnTypeFromMethod != null && (theReturnTypeFromMethod.equals(IBaseResource.class) || theReturnTypeFromMethod.equals(IResource.class) || theReturnTypeFromMethod.equals(IAnyResource.class));
    }

    private static String toLogString(Class<?> theType) {
        if (theType == null) {
            return null;
        }
        return theType.getCanonicalName();
    }

    private static boolean verifyIsValidResourceReturnType(Class<?> theReturnType) {
        if (theReturnType == null) {
            return false;
        }
        return IBaseResource.class.isAssignableFrom(theReturnType);
    }

    public static boolean verifyMethodHasZeroOrOneOperationAnnotation(Method theNextMethod, Object ... theAnnotations) {
        Object obj1 = null;
        for (Object object : theAnnotations) {
            if (object == null) continue;
            if (obj1 == null) {
                obj1 = object;
                continue;
            }
            throw new ConfigurationException(Msg.code(399) + "Method " + theNextMethod.getName() + " on type '" + theNextMethod.getDeclaringClass().getSimpleName() + " has annotations @" + obj1.getClass().getSimpleName() + " and @" + object.getClass().getSimpleName() + ". Can not have both.");
        }
        return obj1 != null;
    }
}

