/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.validation.address.impl;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.interceptor.validation.address.AddressValidationException;
import ca.uhn.fhir.rest.server.interceptor.validation.address.AddressValidationResult;
import ca.uhn.fhir.rest.server.interceptor.validation.address.IAddressValidator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Properties;
import org.hl7.fhir.instance.model.api.IBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public abstract class BaseRestfulValidator
implements IAddressValidator {
    public static final String PROPERTY_SERVICE_KEY = "service.key";
    public static final String PROPERTY_SERVICE_ENDPOINT = "service.endpoint";
    private static final Logger ourLog = LoggerFactory.getLogger(BaseRestfulValidator.class);
    private Properties myProperties;

    protected abstract AddressValidationResult getValidationResult(AddressValidationResult var1, JsonNode var2, FhirContext var3) throws Exception;

    protected abstract ResponseEntity<String> getResponseEntity(IBase var1, FhirContext var2) throws Exception;

    protected RestTemplate newTemplate() {
        return new RestTemplate();
    }

    public BaseRestfulValidator(Properties theProperties) {
        this.myProperties = theProperties;
    }

    @Override
    public AddressValidationResult isValid(IBase theAddress, FhirContext theFhirContext) throws AddressValidationException {
        ResponseEntity<String> entity;
        try {
            entity = this.getResponseEntity(theAddress, theFhirContext);
        }
        catch (Exception e) {
            throw new AddressValidationException(Msg.code(345) + "Unable to complete address validation web-service call", e);
        }
        if (this.isError(entity)) {
            throw new AddressValidationException(Msg.code(346) + String.format("Service returned an error code %s", new Object[]{entity.getStatusCode()}));
        }
        String responseBody = (String)entity.getBody();
        ourLog.debug("Validation service returned {}", (Object)responseBody);
        AddressValidationResult retVal = new AddressValidationResult();
        retVal.setRawResponse(responseBody);
        try {
            JsonNode response = new ObjectMapper().readTree(responseBody);
            ourLog.debug("Parsed address validator response {}", (Object)response);
            return this.getValidationResult(retVal, response, theFhirContext);
        }
        catch (Exception e) {
            throw new AddressValidationException(Msg.code(347) + "Unable to validate the address", e);
        }
    }

    protected boolean isError(ResponseEntity<String> entity) {
        return entity.getStatusCode().isError();
    }

    public Properties getProperties() {
        return this.myProperties;
    }

    public void setProperties(Properties theProperties) {
        this.myProperties = theProperties;
    }

    protected String getApiKey() {
        return this.getProperties().getProperty(PROPERTY_SERVICE_KEY);
    }

    protected String getApiEndpoint() {
        return this.getProperties().getProperty(PROPERTY_SERVICE_ENDPOINT);
    }
}

