/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.s13n.standardizers;

import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.LastNameStandardizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TitleStandardizer
extends LastNameStandardizer {
    private Set<String> myExceptions = new HashSet<String>(Arrays.asList("EAS", "EPS", "LLC", "LLP", "of", "at", "in", "and"));
    private Set<String[]> myBiGramExceptions = new HashSet<String[]>();

    public TitleStandardizer() {
        this.addDelimiters("/", ".", "|", ">", "<", "(", ")", ":", "!");
        this.addAllowed('(', ')', '@', ':', '!', '|', '>', '<');
        this.myBiGramExceptions.add(new String[]{"'", "s"});
    }

    private void addAllowed(char ... theCharacter) {
        for (char ch : theCharacter) {
            this.addAllowedExtendedAsciiRange(ch, ch);
            this.addAllowedNonLetterAndDigitCharacters(Character.valueOf(ch));
        }
    }

    @Override
    public String standardize(String theString) {
        theString = this.replaceTranslates(theString);
        return Arrays.stream(theString.split("\\s+")).map(String::trim).map(this::standardizeText).filter(s2 -> !StringUtils.isEmpty(s2)).map(this::checkTitleExceptions).collect(Collectors.joining(" "));
    }

    private List<String> split(String theString) {
        int cursor = 0;
        boolean start = false;
        ArrayList<String> retVal = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        while (cursor < theString.length()) {
            int codePoint = theString.codePointAt(cursor);
            cursor += Character.charCount(codePoint);
            if (this.isNoiseCharacter(codePoint)) continue;
            String str = new String(Character.toChars(codePoint));
            if (this.isDelimiter(str)) {
                if (buf.length() != 0) {
                    retVal.add(buf.toString());
                    buf.setLength(0);
                }
                retVal.add(str);
                continue;
            }
            buf.append(str);
        }
        if (buf.length() != 0) {
            retVal.add(buf.toString());
        }
        return retVal;
    }

    protected String standardizeText(String theToken) {
        StringBuilder buf = new StringBuilder();
        List<String> parts = this.split(theToken);
        String prevPart = null;
        for (String part : parts) {
            if (this.isAllText(part)) {
                part = this.standardizeNameToken(part);
            }
            part = this.checkBiGram(prevPart, part);
            buf.append(part);
            prevPart = part;
        }
        return buf.toString();
    }

    private String checkBiGram(String thePart0, String thePart1) {
        for (String[] biGram : this.myBiGramExceptions) {
            if (!biGram[0].equalsIgnoreCase(thePart0) || !biGram[1].equalsIgnoreCase(thePart1)) continue;
            return biGram[1];
        }
        return thePart1;
    }

    private boolean isAllText(String thePart) {
        int codePoint;
        for (int offset = 0; offset < thePart.length(); offset += Character.charCount(codePoint)) {
            codePoint = thePart.codePointAt(offset);
            if (Character.isLetter(codePoint)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String standardizeNameToken(String theToken) {
        String exception = this.myExceptions.stream().filter(s2 -> s2.equalsIgnoreCase(theToken)).findFirst().orElse(null);
        if (exception != null) {
            return exception;
        }
        return super.standardizeNameToken(theToken);
    }

    private String checkTitleExceptions(String theString) {
        return this.myExceptions.stream().filter(s2 -> s2.equalsIgnoreCase(theString)).findFirst().orElse(theString);
    }
}

