/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.s13n.standardizers;

import ca.uhn.fhir.rest.server.interceptor.s13n.standardizers.FirstNameStandardizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.text.WordUtils;

public class LastNameStandardizer
extends FirstNameStandardizer {
    private Set<String> myParticles = new HashSet<String>(Arrays.asList("van", "der", "ter", "de", "da", "la"));
    private Set<String> myPrefixes = new HashSet<String>(Arrays.asList("mac", "mc"));
    private Set<String> myPrefixExcludes = new HashSet<String>(Arrays.asList("machi"));

    @Override
    protected LastNameStandardizer addDelimiters(String ... theDelimiters) {
        super.addDelimiters(theDelimiters);
        return this;
    }

    @Override
    protected String standardizeNameToken(String theToken) {
        if (theToken.isEmpty()) {
            return theToken;
        }
        if (this.myParticles.contains(theToken.toLowerCase())) {
            return theToken.toLowerCase();
        }
        String retVal = super.standardizeNameToken(theToken);
        return this.handlePrefix(retVal);
    }

    protected String handlePrefix(String theToken) {
        String lowerCaseToken = theToken.toLowerCase();
        for (String exclude : this.myPrefixExcludes) {
            if (!lowerCaseToken.startsWith(exclude)) continue;
            return theToken;
        }
        for (String prefix : this.myPrefixes) {
            if (!lowerCaseToken.startsWith(prefix)) continue;
            String capitalizedPrefix = WordUtils.capitalize(prefix);
            String capitalizedSuffix = WordUtils.capitalize(lowerCaseToken.replaceFirst(prefix, ""));
            return capitalizedPrefix.concat(capitalizedSuffix);
        }
        return theToken;
    }
}

