/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.partition;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SystemRequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@Interceptor
public class RequestTenantPartitionInterceptor {
    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_ANY)
    public RequestPartitionId partitionIdentifyCreate(RequestDetails theRequestDetails) {
        return this.extractPartitionIdFromRequest(theRequestDetails);
    }

    @Nonnull
    protected RequestPartitionId extractPartitionIdFromRequest(RequestDetails theRequestDetails) {
        String tenantId = theRequestDetails.getTenantId();
        if (StringUtils.isBlank(tenantId)) {
            if (theRequestDetails instanceof SystemRequestDetails) {
                SystemRequestDetails requestDetails = (SystemRequestDetails)theRequestDetails;
                if (requestDetails.getRequestPartitionId() != null) {
                    return requestDetails.getRequestPartitionId();
                }
                return RequestPartitionId.defaultPartition();
            }
            throw new InternalErrorException(Msg.code(343) + "No partition ID has been specified");
        }
        return RequestPartitionId.fromPartitionName(tenantId);
    }
}

