/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.auth.AllowedCodeInValueSet;
import ca.uhn.fhir.rest.server.interceptor.auth.SearchNarrowingInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.SearchParameterAndValueSetRuleImpl;
import ca.uhn.fhir.rest.server.interceptor.consent.ConsentOutcome;
import ca.uhn.fhir.rest.server.interceptor.consent.IConsentContextServices;
import ca.uhn.fhir.rest.server.interceptor.consent.IConsentService;
import ca.uhn.fhir.rest.server.util.FhirContextSearchParamRegistry;
import ca.uhn.fhir.rest.server.util.ISearchParamRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchNarrowingConsentService
implements IConsentService {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchNarrowingConsentService.class);
    private final IValidationSupport myValidationSupport;
    private final ISearchParamRegistry mySearchParamRegistry;
    private Logger myTroubleshootingLog = ourLog;

    public SearchNarrowingConsentService(IValidationSupport theValidationSupport, FhirContext theFhirContext) {
        this(theValidationSupport, new FhirContextSearchParamRegistry(theFhirContext));
    }

    public SearchNarrowingConsentService(IValidationSupport theValidationSupport, ISearchParamRegistry theSearchParamRegistry) {
        this.myValidationSupport = theValidationSupport;
        this.mySearchParamRegistry = theSearchParamRegistry;
    }

    public void setTroubleshootingLog(@Nonnull Logger theTroubleshootingLog) {
        Validate.notNull(theTroubleshootingLog, "theTroubleshootingLog must not be null", new Object[0]);
        this.myTroubleshootingLog = theTroubleshootingLog;
    }

    @Override
    public boolean shouldProcessCanSeeResource(RequestDetails theRequestDetails, IConsentContextServices theContextServices) {
        List<AllowedCodeInValueSet> postFilteringList = SearchNarrowingInterceptor.getPostFilteringListOrNull(theRequestDetails);
        return postFilteringList != null && !postFilteringList.isEmpty();
    }

    @Override
    public ConsentOutcome canSeeResource(RequestDetails theRequestDetails, IBaseResource theResource, IConsentContextServices theContextServices) {
        return this.applyFilterForResource(theRequestDetails, theResource);
    }

    @Override
    public ConsentOutcome willSeeResource(RequestDetails theRequestDetails, IBaseResource theResource, IConsentContextServices theContextServices) {
        return this.applyFilterForResource(theRequestDetails, theResource);
    }

    @Nonnull
    private ConsentOutcome applyFilterForResource(RequestDetails theRequestDetails, IBaseResource theResource) {
        List<AllowedCodeInValueSet> postFilteringList = SearchNarrowingInterceptor.getPostFilteringListOrNull(theRequestDetails);
        if (postFilteringList == null) {
            return ConsentOutcome.PROCEED;
        }
        String resourceType = this.myValidationSupport.getFhirContext().getResourceType(theResource);
        boolean allPositiveRulesMatched = true;
        for (AllowedCodeInValueSet next : postFilteringList) {
            String valueSetUrl;
            if (!next.getResourceName().equals(resourceType)) continue;
            boolean returnOnFirstMatch = true;
            String searchParamName = next.getSearchParameterName();
            SearchParameterAndValueSetRuleImpl.CodeMatchCount outcome = SearchParameterAndValueSetRuleImpl.countMatchingCodesInValueSetForSearchParameter(theResource, this.myValidationSupport, this.mySearchParamRegistry, returnOnFirstMatch, searchParamName, valueSetUrl = next.getValueSetUrl(), this.myTroubleshootingLog, "Search Narrowing");
            if (outcome.isAtLeastOneUnableToValidate()) {
                this.myTroubleshootingLog.warn("Terminology Services failed to validate value from " + next.getResourceName() + ":" + next.getSearchParameterName() + " in ValueSet " + next.getValueSetUrl() + " - Assuming REJECT");
                return ConsentOutcome.REJECT;
            }
            if (next.isNegate()) {
                if (outcome.getMatchingCodeCount() <= 0) continue;
                return ConsentOutcome.REJECT;
            }
            if (outcome.getMatchingCodeCount() != 0) continue;
            allPositiveRulesMatched = false;
            break;
        }
        if (!allPositiveRulesMatched) {
            return ConsentOutcome.REJECT;
        }
        return ConsentOutcome.PROCEED;
    }
}

