/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleTester;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthorizationSearchParamMatcher;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class FhirQueryRuleTester
implements IAuthRuleTester {
    private final String myQueryParameters;

    public FhirQueryRuleTester(String theQueryParameters) {
        this.myQueryParameters = theQueryParameters;
    }

    @Override
    public boolean matches(IAuthRuleTester.RuleTestRequest theRuleTestRequest) {
        return this.checkMatch(theRuleTestRequest);
    }

    @Override
    public boolean matchesOutput(IAuthRuleTester.RuleTestRequest theRuleTestRequest) {
        return this.checkMatch(theRuleTestRequest);
    }

    private boolean checkMatch(IAuthRuleTester.RuleTestRequest theRuleTestRequest) {
        IAuthorizationSearchParamMatcher matcher = theRuleTestRequest.ruleApplier.getSearchParamMatcher();
        if (matcher == null) {
            theRuleTestRequest.ruleApplier.getTroubleshootingLog().warn("No matcher provided.  Can't apply filter permission.");
            return false;
        }
        if (theRuleTestRequest.resource == null) {
            return true;
        }
        IAuthorizationSearchParamMatcher.MatchResult mr = matcher.match(theRuleTestRequest.resource.fhirType() + "?" + this.myQueryParameters, theRuleTestRequest.resource);
        switch (mr.match) {
            case MATCH: {
                return true;
            }
            case UNSUPPORTED: {
                theRuleTestRequest.ruleApplier.getTroubleshootingLog().warn("Unsupported matcher expression {}: {}.", (Object)this.myQueryParameters, (Object)mr.unsupportedReason);
                return theRuleTestRequest.mode == PolicyEnum.DENY;
            }
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("filter", this.myQueryParameters).toString();
    }
}

