/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.rest.server.interceptor.auth.AllowedCodeInValueSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class AuthorizedList {
    private List<String> myAllowedCompartments;
    private List<String> myAllowedInstances;
    private List<AllowedCodeInValueSet> myAllowedCodeInValueSets;

    @Nullable
    List<String> getAllowedCompartments() {
        return this.myAllowedCompartments;
    }

    @Nullable
    List<AllowedCodeInValueSet> getAllowedCodeInValueSets() {
        return this.myAllowedCodeInValueSets;
    }

    @Nullable
    List<String> getAllowedInstances() {
        return this.myAllowedInstances;
    }

    public AuthorizedList addCompartment(String theCompartment) {
        Validate.notNull(theCompartment, "theCompartment must not be null", new Object[0]);
        if (this.myAllowedCompartments == null) {
            this.myAllowedCompartments = new ArrayList<String>();
        }
        this.myAllowedCompartments.add(theCompartment);
        return this;
    }

    public AuthorizedList addCompartments(String ... theCompartments) {
        Validate.notNull(theCompartments, "theCompartments must not be null", new Object[0]);
        for (String next : theCompartments) {
            this.addCompartment(next);
        }
        return this;
    }

    public AuthorizedList addResource(String theResource) {
        Validate.notNull(theResource, "theResource must not be null", new Object[0]);
        if (this.myAllowedInstances == null) {
            this.myAllowedInstances = new ArrayList<String>();
        }
        this.myAllowedInstances.add(theResource);
        return this;
    }

    public AuthorizedList addResources(String ... theResources) {
        Validate.notNull(theResources, "theResources must not be null", new Object[0]);
        for (String next : theResources) {
            this.addResource(next);
        }
        return this;
    }

    public AuthorizedList addCodeInValueSet(@Nonnull String theResourceName, @Nonnull String theSearchParameterName, @Nonnull String theValueSetUrl) {
        Validate.notBlank(theResourceName, "theResourceName must not be missing or null", new Object[0]);
        Validate.notBlank(theSearchParameterName, "theSearchParameterName must not be missing or null", new Object[0]);
        Validate.notBlank(theValueSetUrl, "theResourceUrl must not be missing or null", new Object[0]);
        return this.doAddCodeInValueSet(theResourceName, theSearchParameterName, theValueSetUrl, false);
    }

    public AuthorizedList addCodeNotInValueSet(@Nonnull String theResourceName, @Nonnull String theSearchParameterName, @Nonnull String theValueSetUrl) {
        Validate.notBlank(theResourceName, "theResourceName must not be missing or null", new Object[0]);
        Validate.notBlank(theSearchParameterName, "theSearchParameterName must not be missing or null", new Object[0]);
        Validate.notBlank(theValueSetUrl, "theResourceUrl must not be missing or null", new Object[0]);
        return this.doAddCodeInValueSet(theResourceName, theSearchParameterName, theValueSetUrl, true);
    }

    private AuthorizedList doAddCodeInValueSet(String theResourceName, String theSearchParameterName, String theValueSetUrl, boolean negate) {
        if (this.myAllowedCodeInValueSets == null) {
            this.myAllowedCodeInValueSets = new ArrayList<AllowedCodeInValueSet>();
        }
        this.myAllowedCodeInValueSets.add(new AllowedCodeInValueSet(theResourceName, theSearchParameterName, theValueSetUrl, negate));
        return this;
    }
}

