/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerboseLoggingInterceptor
extends InterceptorAdapter {
    private static final Logger ourLog = LoggerFactory.getLogger(VerboseLoggingInterceptor.class);

    @Override
    public boolean incomingRequestPostProcessed(RequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        StringBuilder b = new StringBuilder("Incoming request: ");
        b.append(theRequest.getMethod());
        b.append(" ");
        b.append(theRequest.getRequestURL());
        b.append("\n");
        Enumeration<String> headerEnumeration = theRequest.getHeaderNames();
        while (headerEnumeration.hasMoreElements()) {
            String nextName = headerEnumeration.nextElement();
            Enumeration<String> valueEnumeration = theRequest.getHeaders(nextName);
            while (valueEnumeration.hasMoreElements()) {
                b.append(" * ").append(nextName).append(": ").append(valueEnumeration.nextElement()).append("\n");
            }
        }
        ourLog.info(b.toString());
        return true;
    }
}

