/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.SimplePreResourceShowDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ServerInterceptorUtil {
    private ServerInterceptorUtil() {
    }

    @CheckReturnValue
    public static List<IBaseResource> fireStoragePreshowResource(List<IBaseResource> theResources, RequestDetails theRequest, IInterceptorBroadcaster theInterceptorBroadcaster) {
        List<IBaseResource> retVal = theResources;
        retVal.removeIf(Objects::isNull);
        if (retVal.size() > 0) {
            SimplePreResourceShowDetails accessDetails = new SimplePreResourceShowDetails(retVal);
            HookParams params = new HookParams().add(IPreResourceShowDetails.class, accessDetails).add(RequestDetails.class, theRequest).addIfMatchesType(ServletRequestDetails.class, theRequest);
            CompositeInterceptorBroadcaster.doCallHooks(theInterceptorBroadcaster, theRequest, Pointcut.STORAGE_PRESHOW_RESOURCES, params);
            retVal = accessDetails.toList();
            retVal.removeIf(Objects::isNull);
        }
        return retVal;
    }
}

