/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.BaseValidatingInterceptor;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.ValidationResult;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseValidatingInterceptor
extends BaseValidatingInterceptor<IBaseResource> {
    public static final String DEFAULT_RESPONSE_HEADER_NAME = "X-FHIR-Response-Validation";
    private static final Logger ourLog = LoggerFactory.getLogger(ResponseValidatingInterceptor.class);
    private Set<RestOperationTypeEnum> myExcludeOperationTypes;

    public void addExcludeOperationType(RestOperationTypeEnum theOperationType) {
        Validate.notNull(theOperationType, "theOperationType must not be null", new Object[0]);
        if (this.myExcludeOperationTypes == null) {
            this.myExcludeOperationTypes = new HashSet<RestOperationTypeEnum>();
        }
        this.myExcludeOperationTypes.add(theOperationType);
    }

    @Override
    ValidationResult doValidate(FhirValidator theValidator, IBaseResource theRequest) {
        return theValidator.validateWithResult(theRequest);
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails theRequestDetails, IBaseResource theResponseObject) {
        RestOperationTypeEnum operationType = theRequestDetails.getRestOperationType();
        if (operationType != null && this.myExcludeOperationTypes != null && this.myExcludeOperationTypes.contains((Object)operationType)) {
            ourLog.trace("Operation type {} is excluded from validation", (Object)operationType);
            return true;
        }
        this.validate(theResponseObject, theRequestDetails);
        return true;
    }

    @Override
    String provideDefaultResponseHeaderName() {
        return DEFAULT_RESPONSE_HEADER_NAME;
    }

    @Override
    public void setResponseHeaderName(String theResponseHeaderName) {
        super.setResponseHeaderName(theResponseHeaderName);
    }
}

