/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.FhirPathExecutionException;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirPathFilterInterceptor {
    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public void preProcessOutgoingResponse(RequestDetails theRequestDetails, ResponseDetails theResponseDetails) {
        String[] fhirPathParams;
        IBaseResource responseResource = theResponseDetails.getResponseResource();
        if (responseResource != null && (fhirPathParams = theRequestDetails.getParameters().get("_fhirpath")) != null) {
            FhirContext ctx = theRequestDetails.getFhirContext();
            IBaseParameters responseParameters = ParametersUtil.newInstance(ctx);
            for (String expression : fhirPathParams) {
                List<IBase> outputs;
                if (!StringUtils.isNotBlank(expression)) continue;
                IBase resultPart = ParametersUtil.addParameterToParameters(ctx, responseParameters, "result");
                ParametersUtil.addPartString(ctx, resultPart, "expression", expression);
                IFhirPath fhirPath = ctx.newFhirPath();
                try {
                    outputs = fhirPath.evaluate(responseResource, expression, IBase.class);
                }
                catch (FhirPathExecutionException e) {
                    throw new InvalidRequestException(Msg.code(327) + "Error parsing FHIRPath expression: " + e.getMessage());
                }
                for (IBase nextOutput : outputs) {
                    if (nextOutput instanceof IBaseResource) {
                        ParametersUtil.addPartResource(ctx, resultPart, "result", (IBaseResource)nextOutput);
                        continue;
                    }
                    ParametersUtil.addPart(ctx, resultPart, "result", nextOutput);
                }
            }
            theResponseDetails.setResponseResource(responseParameters);
        }
    }
}

