/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IRestfulResponse;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnclassifiedServerFailureException;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletRestfulResponse;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class ExceptionHandlingInterceptor {
    public static final String PROCESSING = "processing";
    private static final Logger ourLog = LoggerFactory.getLogger(ExceptionHandlingInterceptor.class);
    public static final Set<SummaryEnum> SUMMARY_MODE = Collections.singleton(SummaryEnum.FALSE);
    private Class<?>[] myReturnStackTracesForExceptionTypes;

    @Hook(value=Pointcut.SERVER_HANDLE_EXCEPTION)
    public boolean handleException(RequestDetails theRequestDetails, BaseServerResponseException theException, HttpServletRequest theRequest, HttpServletResponse theResponse) throws ServletException, IOException {
        this.handleException(theRequestDetails, theException);
        return false;
    }

    public Object handleException(RequestDetails theRequestDetails, BaseServerResponseException theException) throws ServletException, IOException {
        String sm;
        IRestfulResponse response = theRequestDetails.getResponse();
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        IBaseOperationOutcome oo = theException.getOperationOutcome();
        if (oo == null) {
            oo = this.createOperationOutcome(theException, ctx);
        }
        int statusCode = theException.getStatusCode();
        if (theException.hasResponseHeaders()) {
            Map<String, List<String>> additional = theException.getResponseHeaders();
            for (Map.Entry<String, List<String>> next : additional.entrySet()) {
                if (!StringUtils.isNotBlank(next.getKey()) || next.getValue() == null) continue;
                String nextKey = next.getKey();
                for (String nextValue : next.getValue()) {
                    response.addHeader(nextKey, nextValue);
                }
            }
        }
        String statusMessage = null;
        if (theException instanceof UnclassifiedServerFailureException && StringUtils.isNotBlank(sm = theException.getMessage()) && sm.indexOf(10) == -1) {
            statusMessage = sm;
        }
        BaseResourceReturningMethodBinding.callOutgoingFailureOperationOutcomeHook(theRequestDetails, oo);
        try {
            this.resetOutputStreamIfPossible(response);
        }
        catch (Throwable t) {
            ourLog.error("HAPI-FHIR was unable to reset the output stream during exception handling. The root causes follows:", t);
        }
        return RestfulServerUtils.streamResponseAsResource(theRequestDetails.getServer(), oo, SUMMARY_MODE, statusCode, false, false, theRequestDetails, null, null);
    }

    private void resetOutputStreamIfPossible(IRestfulResponse response) {
        if (response.getClass().isAssignableFrom(ServletRestfulResponse.class)) {
            ServletRestfulResponse servletRestfulResponse = (ServletRestfulResponse)response;
            HttpServletResponse servletResponse = ((ServletRequestDetails)servletRestfulResponse.getRequestDetails()).getServletResponse();
            Collection<String> headerNames = servletResponse.getHeaderNames();
            HashedMap<String, Collection<String>> oldHeaders = new HashedMap<String, Collection<String>>();
            for (String headerName : headerNames) {
                oldHeaders.put(headerName, servletResponse.getHeaders(headerName));
            }
            servletResponse.reset();
            oldHeaders.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("Content-Encoding")).forEach(entry -> ((Collection)entry.getValue()).stream().forEach(value -> servletResponse.addHeader((String)entry.getKey(), (String)value)));
        }
    }

    @Hook(value=Pointcut.SERVER_PRE_PROCESS_OUTGOING_EXCEPTION)
    public BaseServerResponseException preProcessOutgoingException(RequestDetails theRequestDetails, Throwable theException, HttpServletRequest theServletRequest) throws ServletException {
        BaseServerResponseException retVal = theException instanceof DataFormatException ? new InvalidRequestException(theException) : (!(theException instanceof BaseServerResponseException) ? new InternalErrorException(theException) : (BaseServerResponseException)theException);
        if (retVal.getOperationOutcome() == null) {
            retVal.setOperationOutcome(this.createOperationOutcome(theException, theRequestDetails.getServer().getFhirContext()));
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IBaseOperationOutcome createOperationOutcome(Throwable theException, FhirContext ctx) throws ServletException {
        IBaseOperationOutcome oo = null;
        if (theException instanceof BaseServerResponseException) {
            oo = ((BaseServerResponseException)theException).getOperationOutcome();
        }
        if (oo == null) {
            try {
                oo = OperationOutcomeUtil.newInstance(ctx);
                if (theException instanceof InternalErrorException) {
                    ourLog.error("Failure during REST processing", theException);
                    this.populateDetails(ctx, theException, oo);
                    return oo;
                }
                if (theException instanceof BaseServerResponseException) {
                    int statusCode = ((BaseServerResponseException)theException).getStatusCode();
                    if (statusCode < 500) {
                        ourLog.warn("Failure during REST processing: {}", (Object)theException.toString());
                    } else {
                        ourLog.warn("Failure during REST processing", theException);
                    }
                    BaseServerResponseException baseServerResponseException = (BaseServerResponseException)theException;
                    this.populateDetails(ctx, theException, oo);
                    if (baseServerResponseException.getAdditionalMessages() == null) return oo;
                    for (String next : baseServerResponseException.getAdditionalMessages()) {
                        OperationOutcomeUtil.addIssue(ctx, oo, "error", next, null, PROCESSING);
                    }
                    return oo;
                }
                ourLog.error("Failure during REST processing: " + theException.toString(), theException);
                this.populateDetails(ctx, theException, oo);
                return oo;
            }
            catch (Exception e1) {
                ourLog.error("Failed to instantiate OperationOutcome resource instance", e1);
                throw new ServletException(Msg.code(328) + "Failed to instantiate OperationOutcome resource instance", e1);
            }
        } else {
            ourLog.error("Unknown error during processing", theException);
        }
        return oo;
    }

    private void populateDetails(FhirContext theCtx, Throwable theException, IBaseOperationOutcome theOo) {
        if (this.myReturnStackTracesForExceptionTypes != null) {
            for (Class<?> next : this.myReturnStackTracesForExceptionTypes) {
                if (!next.isAssignableFrom(theException.getClass())) continue;
                String detailsValue = theException.getMessage() + "\n\n" + ExceptionUtils.getStackTrace(theException);
                OperationOutcomeUtil.addIssue(theCtx, theOo, "error", detailsValue, null, PROCESSING);
                return;
            }
        }
        OperationOutcomeUtil.addIssue(theCtx, theOo, "error", theException.getMessage(), null, PROCESSING);
    }

    public ExceptionHandlingInterceptor setReturnStackTracesForExceptionTypes(Class<?> ... theExceptionTypes) {
        this.myReturnStackTracesForExceptionTypes = theExceptionTypes;
        return this;
    }
}

