/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.util.BundleUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public abstract class BaseResponseTerminologyInterceptor {
    protected final IValidationSupport myValidationSupport;
    protected final FhirContext myContext;

    public BaseResponseTerminologyInterceptor(@Nonnull IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
        Validate.notNull(theValidationSupport, "The validation support must not be null", new Object[0]);
        this.myContext = theValidationSupport.getFhirContext();
        Validate.notNull(this.myContext, "The validation support must not return a null context", new Object[0]);
    }

    @Nonnull
    protected List<IBaseResource> toListForProcessing(RequestDetails theRequestDetails, IBaseResource theResource) {
        switch (theRequestDetails.getRestOperationType()) {
            default: {
                return Collections.emptyList();
            }
            case HISTORY_INSTANCE: 
            case HISTORY_SYSTEM: 
            case HISTORY_TYPE: 
            case SEARCH_SYSTEM: 
            case SEARCH_TYPE: 
            case READ: 
            case VREAD: 
        }
        List<IBaseResource> resources = theResource instanceof IBaseBundle ? BundleUtil.toListOfResources(this.myContext, (IBaseBundle)theResource) : Collections.singletonList(theResource);
        return resources;
    }
}

