/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletRequestTracing {
    private static final Logger ourLog = LoggerFactory.getLogger(ServletRequestTracing.class);
    public static final String ATTRIBUTE_REQUEST_ID = ServletRequestTracing.class.getName() + ".X-Request-ID";

    ServletRequestTracing() {
    }

    public static String getOrGenerateRequestId(ServletRequest theServletRequest) {
        String requestId = ServletRequestTracing.maybeGetRequestId(theServletRequest);
        if (StringUtils.isBlank(requestId)) {
            requestId = RandomStringUtils.randomAlphanumeric(16);
        }
        ourLog.debug("Assigned tracing id {}", (Object)requestId);
        theServletRequest.setAttribute(ATTRIBUTE_REQUEST_ID, requestId);
        return requestId;
    }

    @Nullable
    public static String maybeGetRequestId(ServletRequest theServletRequest) {
        HttpServletRequest request2;
        String requestId = (String)theServletRequest.getAttribute(ATTRIBUTE_REQUEST_ID);
        if (requestId == null && theServletRequest instanceof HttpServletRequest && StringUtils.isNotBlank(requestId = (request2 = (HttpServletRequest)theServletRequest).getHeader("X-Request-ID"))) {
            for (char nextChar : requestId.toCharArray()) {
                if (Character.isLetterOrDigit(nextChar) || nextChar == '.' || nextChar == '-' || nextChar == '_' || nextChar == ' ') continue;
                requestId = null;
                break;
            }
        }
        return requestId;
    }
}

