/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server;

import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SimplePreResourceAccessDetails
implements IPreResourceAccessDetails {
    private final List<IBaseResource> myResources;
    private final boolean[] myBlocked;

    public SimplePreResourceAccessDetails(IBaseResource theResource) {
        this(Collections.singletonList(theResource));
    }

    public <T extends IBaseResource> SimplePreResourceAccessDetails(List<T> theResources) {
        this.myResources = theResources;
        this.myBlocked = new boolean[this.myResources.size()];
    }

    @Override
    public int size() {
        return this.myResources.size();
    }

    @Override
    public IBaseResource getResource(int theIndex) {
        return this.myResources.get(theIndex);
    }

    @Override
    public void setDontReturnResourceAtIndex(int theIndex) {
        this.myBlocked[theIndex] = true;
    }

    public boolean isDontReturnResourceAtIndex(int theIndex) {
        return this.myBlocked[theIndex];
    }

    public void applyFilterToList() {
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            if (!this.isDontReturnResourceAtIndex(i2)) continue;
            this.myResources.remove(i2);
        }
    }
}

