/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser.path;

import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class EncodeContextPathElement {
    private final String myName;
    private final boolean myResource;

    public EncodeContextPathElement(String theName, boolean theResource) {
        Validate.notBlank(theName);
        this.myName = theName;
        this.myResource = theResource;
    }

    public boolean matches(EncodeContextPathElement theOther) {
        char ch;
        if (this.myResource != theOther.isResource()) {
            return false;
        }
        String otherName = theOther.getName();
        if (this.myName.equals(otherName)) {
            return true;
        }
        if (this.myName.length() > otherName.length() && this.myName.startsWith(otherName) && Character.isUpperCase(ch = this.myName.charAt(otherName.length()))) {
            return true;
        }
        return this.myName.equals("*") || otherName.equals("*");
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        EncodeContextPathElement that = (EncodeContextPathElement)theO;
        return new EqualsBuilder().append(this.myResource, that.myResource).append(this.myName, that.myName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.myName).append(this.myResource).toHashCode();
    }

    public String toString() {
        if (this.myResource) {
            return this.myName + "(res)";
        }
        return this.myName;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isResource() {
        return this.myResource;
    }
}

