/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.base.composite;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseQuantityDt
extends BaseIdentifiableElement
implements ICompositeDatatype,
IQueryParameterType {
    private static final long serialVersionUID = 1L;

    public abstract BaseQuantityDt setValue(BigDecimal var1);

    @Override
    public void setValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        this.getComparatorElement().setValue((Object)null);
        this.setCode(null);
        this.setSystem(null);
        this.setUnits(null);
        this.setValue(null);
        if (theValue == null) {
            return;
        }
        String[] parts = theValue.split("\\|");
        if (parts.length > 0 && StringUtils.isNotBlank(parts[0])) {
            if (parts[0].startsWith("le")) {
                this.getComparatorElement().setValue(ParamPrefixEnum.LESSTHAN_OR_EQUALS.getValue());
                this.setValue(new BigDecimal(parts[0].substring(2)));
            } else if (parts[0].startsWith("lt")) {
                this.getComparatorElement().setValue(ParamPrefixEnum.LESSTHAN.getValue());
                this.setValue(new BigDecimal(parts[0].substring(1)));
            } else if (parts[0].startsWith("ge")) {
                this.getComparatorElement().setValue(ParamPrefixEnum.GREATERTHAN_OR_EQUALS.getValue());
                this.setValue(new BigDecimal(parts[0].substring(2)));
            } else if (parts[0].startsWith("gt")) {
                this.getComparatorElement().setValue(ParamPrefixEnum.GREATERTHAN.getValue());
                this.setValue(new BigDecimal(parts[0].substring(1)));
            } else {
                this.setValue(new BigDecimal(parts[0]));
            }
        }
        if (parts.length > 1 && StringUtils.isNotBlank(parts[1])) {
            this.setSystem(parts[1]);
        }
        if (parts.length > 2 && StringUtils.isNotBlank(parts[2])) {
            this.setUnits(parts[2]);
        }
    }

    public abstract BoundCodeDt<?> getComparatorElement();

    @Override
    public String getValueAsQueryToken(FhirContext theContext) {
        StringBuilder b = new StringBuilder();
        if (this.getComparatorElement() != null) {
            b.append((String)this.getComparatorElement().getValue());
        }
        if (!this.getValueElement().isEmpty()) {
            b.append(this.getValueElement().getValueAsString());
        }
        b.append('|');
        if (!this.getSystemElement().isEmpty()) {
            b.append(this.getSystemElement().getValueAsString());
        }
        b.append('|');
        if (!this.getUnitsElement().isEmpty()) {
            b.append(this.getUnitsElement().getValueAsString());
        }
        return b.toString();
    }

    @Override
    public String getQueryParameterQualifier() {
        return null;
    }

    public abstract BaseQuantityDt setUnits(String var1);

    public abstract UriDt getSystemElement();

    public abstract BaseQuantityDt setSystem(String var1);

    public abstract CodeDt getCodeElement();

    public abstract BaseQuantityDt setCode(String var1);

    public abstract StringDt getUnitsElement();

    public abstract DecimalDt getValueElement();

    @Override
    @Deprecated
    public Boolean getMissing() {
        return null;
    }

    @Override
    @Deprecated
    public IQueryParameterType setMissing(Boolean theMissing) {
        throw new UnsupportedOperationException(Msg.code(1904) + "get/setMissing is not supported in StringDt. Use {@link StringParam} instead if you need this functionality");
    }
}

