/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.BaseElement;
import ca.uhn.fhir.model.api.IElement;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseCoding;

public class Tag
extends BaseElement
implements IElement,
IBaseCoding {
    private static final long serialVersionUID = 1L;
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_SCHEME = "scheme";
    public static final String ATTR_TERM = "term";
    public static final String HL7_ORG_FHIR_TAG = "http://hl7.org/fhir/tag";
    public static final String HL7_ORG_PROFILE_TAG = "http://hl7.org/fhir/tag/profile";
    public static final String HL7_ORG_SECURITY_TAG = "http://hl7.org/fhir/tag/security";
    private String myLabel;
    private String myScheme;
    private String myTerm;
    private String myVersion;
    private boolean myUserSelected;

    public Tag() {
    }

    @Deprecated
    public Tag(String theTerm) {
        this((String)null, theTerm, null);
    }

    public Tag(String theScheme, String theTerm) {
        this.myScheme = theScheme;
        this.myTerm = theTerm;
    }

    public Tag(String theScheme, String theTerm, String theLabel) {
        this.myTerm = theTerm;
        this.myLabel = theLabel;
        this.myScheme = theScheme;
    }

    public Tag(URI theScheme, URI theTerm, String theLabel) {
        if (theScheme != null) {
            this.myScheme = theScheme.toASCIIString();
        }
        if (theTerm != null) {
            this.myTerm = theTerm.toASCIIString();
        }
        this.myLabel = theLabel;
    }

    public String getLabel() {
        return this.myLabel;
    }

    public String getScheme() {
        return this.myScheme;
    }

    public String getTerm() {
        return this.myTerm;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        if (this.myScheme == null ? other.myScheme != null : !this.myScheme.equals(other.myScheme)) {
            return false;
        }
        if (this.myTerm == null ? other.myTerm != null : !this.myTerm.equals(other.myTerm)) {
            return false;
        }
        if (this.myVersion == null ? other.getVersion() != null : !this.myVersion.equals(other.getVersion())) {
            return false;
        }
        return this.myUserSelected == other.getUserSelected();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myScheme == null ? 0 : this.myScheme.hashCode());
        result = 31 * result + (this.myTerm == null ? 0 : this.myTerm.hashCode());
        result = 31 * result + (this.myVersion == null ? 0 : this.myVersion.hashCode());
        result = 31 * result + Boolean.hashCode(this.myUserSelected);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isBlank(this.myScheme) && StringUtils.isBlank(this.myTerm);
    }

    public Tag setLabel(String theLabel) {
        this.myLabel = theLabel;
        return this;
    }

    public Tag setScheme(String theScheme) {
        this.myScheme = theScheme;
        return this;
    }

    public Tag setTerm(String theTerm) {
        this.myTerm = theTerm;
        return this;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("Scheme", this.myScheme);
        b.append("Term", this.myTerm);
        b.append("Label", this.myLabel);
        b.append("Version", this.myVersion);
        b.append("UserSelected", this.myUserSelected);
        return b.toString();
    }

    @Override
    public String getCode() {
        return this.getTerm();
    }

    @Override
    public String getDisplay() {
        return this.getLabel();
    }

    @Override
    public String getSystem() {
        return this.getScheme();
    }

    @Override
    public IBaseCoding setCode(String theTerm) {
        this.setTerm(theTerm);
        return this;
    }

    @Override
    public IBaseCoding setDisplay(String theLabel) {
        this.setLabel(theLabel);
        return this;
    }

    @Override
    public IBaseCoding setSystem(String theScheme) {
        this.setScheme(theScheme);
        return this;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public IBaseCoding setVersion(String theVersion) {
        this.myVersion = theVersion;
        return this;
    }

    @Override
    public boolean getUserSelected() {
        return this.myUserSelected;
    }

    @Override
    public IBaseCoding setUserSelected(boolean theUserSelected) {
        this.myUserSelected = theUserSelected;
        return this;
    }
}

