/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.PerformanceOptionsEnum;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeExtensionDtDefinition;
import ca.uhn.fhir.context.RuntimeIdDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeNarrativeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IBaseXhtml;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelScanner {
    private static final Logger ourLog = LoggerFactory.getLogger(ModelScanner.class);
    private Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myClassToElementDefinitions = new HashMap();
    private FhirContext myContext;
    private Map<String, RuntimeResourceDefinition> myIdToResourceDefinition = new HashMap<String, RuntimeResourceDefinition>();
    private Map<String, BaseRuntimeElementDefinition<?>> myNameToElementDefinitions = new HashMap();
    private Map<String, RuntimeResourceDefinition> myNameToResourceDefinitions = new HashMap<String, RuntimeResourceDefinition>();
    private Map<String, Class<? extends IBaseResource>> myNameToResourceType = new HashMap<String, Class<? extends IBaseResource>>();
    private RuntimeChildUndeclaredExtensionDefinition myRuntimeChildUndeclaredExtensionDefinition;
    private Set<Class<? extends IBase>> myScanAlso = new HashSet<Class<? extends IBase>>();
    private FhirVersionEnum myVersion;
    private Set<Class<? extends IBase>> myVersionTypes;

    ModelScanner(FhirContext theContext, FhirVersionEnum theVersion, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theExistingDefinitions, @Nonnull Collection<Class<? extends IBase>> theResourceTypes) throws ConfigurationException {
        this.myContext = theContext;
        this.myVersion = theVersion;
        HashSet<Class<? extends IBase>> toScan = new HashSet<Class<? extends IBase>>(theResourceTypes);
        this.init(theExistingDefinitions, toScan);
    }

    Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> getClassToElementDefinitions() {
        return this.myClassToElementDefinitions;
    }

    Map<String, RuntimeResourceDefinition> getIdToResourceDefinition() {
        return this.myIdToResourceDefinition;
    }

    Map<String, BaseRuntimeElementDefinition<?>> getNameToElementDefinitions() {
        return this.myNameToElementDefinitions;
    }

    Map<String, RuntimeResourceDefinition> getNameToResourceDefinition() {
        return this.myNameToResourceDefinitions;
    }

    Map<String, Class<? extends IBaseResource>> getNameToResourceType() {
        return this.myNameToResourceType;
    }

    RuntimeChildUndeclaredExtensionDefinition getRuntimeChildUndeclaredExtensionDefinition() {
        return this.myRuntimeChildUndeclaredExtensionDefinition;
    }

    private void init(Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theExistingDefinitions, Set<Class<? extends IBase>> theTypesToScan) {
        if (theExistingDefinitions != null) {
            this.myClassToElementDefinitions.putAll(theExistingDefinitions);
        }
        int startSize = this.myClassToElementDefinitions.size();
        long start = System.currentTimeMillis();
        Map<String, Class<? extends IBaseResource>> resourceTypes = this.myNameToResourceType;
        Set<Class<? extends IBase>> typesToScan = theTypesToScan;
        this.myVersionTypes = ModelScanner.scanVersionPropertyFile(typesToScan, resourceTypes, this.myVersion, this.myClassToElementDefinitions);
        do {
            for (Class<? extends IBase> clazz : typesToScan) {
                this.scan(clazz);
            }
            this.myScanAlso.removeIf(theClass -> this.myClassToElementDefinitions.containsKey(theClass));
            typesToScan.clear();
            typesToScan.addAll(this.myScanAlso);
            this.myScanAlso.clear();
        } while (!typesToScan.isEmpty());
        for (Map.Entry entry : this.myClassToElementDefinitions.entrySet()) {
            if (theExistingDefinitions != null && theExistingDefinitions.containsKey(entry.getKey())) continue;
            BaseRuntimeElementDefinition next = (BaseRuntimeElementDefinition)entry.getValue();
            boolean deferredSeal = false;
            if (this.myContext.getPerformanceOptions().contains((Object)PerformanceOptionsEnum.DEFERRED_MODEL_SCANNING) && next instanceof BaseRuntimeElementCompositeDefinition) {
                deferredSeal = true;
            }
            if (deferredSeal) continue;
            next.sealAndInitialize(this.myContext, this.myClassToElementDefinitions);
        }
        this.myRuntimeChildUndeclaredExtensionDefinition = new RuntimeChildUndeclaredExtensionDefinition();
        this.myRuntimeChildUndeclaredExtensionDefinition.sealAndInitialize(this.myContext, this.myClassToElementDefinitions);
        long time = System.currentTimeMillis() - start;
        int size = this.myClassToElementDefinitions.size() - startSize;
        ourLog.debug("Done scanning FHIR library, found {} model entries in {}ms", (Object)size, (Object)time);
    }

    private boolean isStandardType(Class<? extends IBase> theClass) {
        return this.myVersionTypes.contains(theClass);
    }

    void scan(Class<? extends IBase> theClass) throws ConfigurationException {
        BaseRuntimeElementDefinition<?> existingDef = this.myClassToElementDefinitions.get(theClass);
        if (existingDef != null) {
            return;
        }
        ResourceDef resourceDefinition = ModelScanner.pullAnnotation(theClass, ResourceDef.class);
        if (resourceDefinition != null) {
            if (!IBaseResource.class.isAssignableFrom(theClass)) {
                throw new ConfigurationException(Msg.code(1714) + "Resource type contains a @" + ResourceDef.class.getSimpleName() + " annotation but does not implement " + IResource.class.getCanonicalName() + ": " + theClass.getCanonicalName());
            }
            Class<? extends IBase> resClass = theClass;
            this.scanResource(resClass, resourceDefinition);
            return;
        }
        DatatypeDef datatypeDefinition = ModelScanner.pullAnnotation(theClass, DatatypeDef.class);
        if (datatypeDefinition != null) {
            if (ICompositeType.class.isAssignableFrom(theClass)) {
                Class<? extends IBase> resClass = theClass;
                this.scanCompositeDatatype(resClass, datatypeDefinition);
            } else if (IPrimitiveType.class.isAssignableFrom(theClass)) {
                Class<? extends IBase> resClass = theClass;
                this.scanPrimitiveDatatype(resClass, datatypeDefinition);
            }
            return;
        }
        Block blockDefinition = ModelScanner.pullAnnotation(theClass, Block.class);
        if (blockDefinition != null) {
            if (IResourceBlock.class.isAssignableFrom(theClass) || IBaseBackboneElement.class.isAssignableFrom(theClass) || IBaseDatatypeElement.class.isAssignableFrom(theClass)) {
                this.scanBlock(theClass);
            } else {
                throw new ConfigurationException(Msg.code(1715) + "Type contains a @" + Block.class.getSimpleName() + " annotation but does not implement " + IResourceBlock.class.getCanonicalName() + ": " + theClass.getCanonicalName());
            }
        }
        if (blockDefinition == null) {
            if (theClass.getSimpleName().equals("XhtmlType")) {
                return;
            }
            throw new ConfigurationException(Msg.code(1716) + "Resource class[" + theClass.getName() + "] does not contain any valid HAPI-FHIR annotations");
        }
    }

    private void scanBlock(Class<? extends IBase> theClass) {
        ourLog.debug("Scanning resource block class: {}", (Object)theClass.getName());
        String resourceName = theClass.getCanonicalName();
        if (this.myContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3) && BaseIdentifiableElement.class.isAssignableFrom(theClass)) {
            throw new ConfigurationException(Msg.code(1717) + "@Block class for version " + this.myContext.getVersion().getVersion().name() + " should not extend " + BaseIdentifiableElement.class.getSimpleName() + ": " + theClass.getName());
        }
        RuntimeResourceBlockDefinition blockDef = new RuntimeResourceBlockDefinition(resourceName, theClass, this.isStandardType(theClass), this.myContext, this.myClassToElementDefinitions);
        blockDef.populateScanAlso(this.myScanAlso);
        this.myClassToElementDefinitions.put(theClass, blockDef);
    }

    private void scanCompositeDatatype(Class<? extends ICompositeType> theClass, DatatypeDef theDatatypeDefinition) {
        ourLog.debug("Scanning datatype class: {}", (Object)theClass.getName());
        RuntimeCompositeDatatypeDefinition elementDef = theClass.equals(ExtensionDt.class) ? new RuntimeExtensionDtDefinition(theDatatypeDefinition, theClass, true, this.myContext, this.myClassToElementDefinitions) : new RuntimeCompositeDatatypeDefinition(theDatatypeDefinition, theClass, this.isStandardType(theClass), this.myContext, this.myClassToElementDefinitions);
        this.myClassToElementDefinitions.put(theClass, elementDef);
        this.myNameToElementDefinitions.put(elementDef.getName().toLowerCase(), elementDef);
        elementDef.populateScanAlso(this.myScanAlso);
    }

    private String scanPrimitiveDatatype(Class<? extends IPrimitiveType<?>> theClass, DatatypeDef theDatatypeDefinition) {
        BaseRuntimeElementDefinition elementDef;
        ourLog.debug("Scanning resource class: {}", (Object)theClass.getName());
        String resourceName = theDatatypeDefinition.name();
        if (StringUtils.isBlank(resourceName)) {
            throw new ConfigurationException(Msg.code(1718) + "Resource type @" + ResourceDef.class.getSimpleName() + " annotation contains no resource name: " + theClass.getCanonicalName());
        }
        if (theClass.equals(XhtmlDt.class)) {
            Class<IPrimitiveType<?>> clazz = theClass;
            elementDef = new RuntimePrimitiveDatatypeNarrativeDefinition(resourceName, (Class<XhtmlDt>)clazz, this.isStandardType(clazz));
        } else if (IBaseXhtml.class.isAssignableFrom(theClass)) {
            Class<IPrimitiveType<?>> clazz = theClass;
            elementDef = new RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition(resourceName, (Class<? extends IBaseXhtml>)clazz, this.isStandardType(clazz));
        } else {
            elementDef = IIdType.class.isAssignableFrom(theClass) ? new RuntimeIdDatatypeDefinition(theDatatypeDefinition, theClass, this.isStandardType(theClass)) : new RuntimePrimitiveDatatypeDefinition(theDatatypeDefinition, theClass, this.isStandardType(theClass));
        }
        this.myClassToElementDefinitions.put(theClass, elementDef);
        if (!theDatatypeDefinition.isSpecialization()) {
            if (this.myVersion.isRi() && IDatatype.class.isAssignableFrom(theClass)) {
                ourLog.debug("Not adding non RI type {} to RI context", (Object)theClass);
            } else if (!this.myVersion.isRi() && !IDatatype.class.isAssignableFrom(theClass)) {
                ourLog.debug("Not adding RI type {} to non RI context", (Object)theClass);
            } else {
                this.myNameToElementDefinitions.put(resourceName, elementDef);
            }
        }
        return resourceName;
    }

    private String scanResource(Class<? extends IBaseResource> theClass, ResourceDef resourceDefinition) {
        String resourceId;
        String resourceNameLowerCase;
        Class<? extends IBaseResource> builtInType;
        boolean standardType;
        ourLog.debug("Scanning resource class: {}", (Object)theClass.getName());
        boolean primaryNameProvider = true;
        String resourceName = resourceDefinition.name();
        if (StringUtils.isBlank(resourceName)) {
            Class<? extends IBaseResource> parent = theClass.getSuperclass();
            primaryNameProvider = false;
            while (!parent.equals(Object.class) && StringUtils.isBlank(resourceName)) {
                ResourceDef nextDef = ModelScanner.pullAnnotation(parent, ResourceDef.class);
                if (nextDef != null) {
                    resourceName = nextDef.name();
                }
                parent = parent.getSuperclass();
            }
            if (StringUtils.isBlank(resourceName)) {
                throw new ConfigurationException(Msg.code(1719) + "Resource type @" + ResourceDef.class.getSimpleName() + " annotation contains no resource name(): " + theClass.getCanonicalName() + " - This is only allowed for types that extend other resource types ");
            }
        }
        boolean bl = standardType = (builtInType = this.myNameToResourceType.get(resourceNameLowerCase = resourceName.toLowerCase())) != null && builtInType.equals(theClass);
        if (primaryNameProvider && builtInType != null && !builtInType.equals(theClass)) {
            primaryNameProvider = false;
        }
        if (!StringUtils.isBlank(resourceId = resourceDefinition.id()) && this.myIdToResourceDefinition.containsKey(resourceId)) {
            throw new ConfigurationException(Msg.code(1720) + "The following resource types have the same ID of '" + resourceId + "' - " + theClass.getCanonicalName() + " and " + this.myIdToResourceDefinition.get(resourceId).getImplementingClass().getCanonicalName());
        }
        RuntimeResourceDefinition resourceDef = new RuntimeResourceDefinition(this.myContext, resourceName, theClass, resourceDefinition, standardType, this.myClassToElementDefinitions);
        this.myClassToElementDefinitions.put(theClass, resourceDef);
        if (primaryNameProvider) {
            if (resourceDef.getStructureVersion() == this.myVersion) {
                this.myNameToResourceDefinitions.put(resourceNameLowerCase, resourceDef);
            }
            if (resourceDef.getStructureVersion() == FhirVersionEnum.R5 && this.myVersion == FhirVersionEnum.R4B) {
                this.myNameToResourceDefinitions.put(resourceNameLowerCase, resourceDef);
            }
        }
        this.myIdToResourceDefinition.put(resourceId, resourceDef);
        this.scanResourceForSearchParams(theClass, resourceDef);
        resourceDef.populateScanAlso(this.myScanAlso);
        return resourceName;
    }

    private void scanResourceForSearchParams(Class<? extends IBaseResource> theClass, RuntimeResourceDefinition theResourceDef) {
        HashMap<String, RuntimeSearchParam> nameToParam = new HashMap<String, RuntimeSearchParam>();
        LinkedHashMap compositeFields = new LinkedHashMap();
        HashSet<Field> fields = new HashSet<Field>(Arrays.asList(theClass.getFields()));
        Class<? extends IBaseResource> nextClass = theClass;
        do {
            for (Class<?> nextInterface : nextClass.getInterfaces()) {
                fields.addAll(Arrays.asList(nextInterface.getFields()));
            }
        } while (!(nextClass = nextClass.getSuperclass()).equals(Object.class));
        for (Field nextField : fields) {
            SearchParamDefinition searchParam = ModelScanner.pullAnnotation(nextField, SearchParamDefinition.class);
            if (searchParam == null) continue;
            RestSearchParameterTypeEnum paramType = RestSearchParameterTypeEnum.forCode(searchParam.type().toLowerCase());
            if (paramType == null) {
                throw new ConfigurationException(Msg.code(1721) + "Search param " + searchParam.name() + " has an invalid type: " + searchParam.type());
            }
            HashSet<String> providesMembershipInCompartments = new HashSet<String>();
            for (Compartment next : searchParam.providesMembershipIn()) {
                if (paramType != RestSearchParameterTypeEnum.REFERENCE) {
                    StringBuilder b = new StringBuilder();
                    b.append("Search param ");
                    b.append(searchParam.name());
                    b.append(" on resource type ");
                    b.append(theClass.getName());
                    b.append(" provides compartment membership but is not of type 'reference'");
                    ourLog.warn(b.toString());
                    continue;
                }
                String name = next.name();
                if (name.startsWith("Base FHIR compartment definition for ")) {
                    name = name.substring("Base FHIR compartment definition for ".length());
                }
                providesMembershipInCompartments.add(name);
            }
            ArrayList<RuntimeSearchParam.Component> components = null;
            if (paramType == RestSearchParameterTypeEnum.COMPOSITE) {
                components = new ArrayList<RuntimeSearchParam.Component>();
                for (String name : searchParam.compositeOf()) {
                    String ref = this.toCanonicalSearchParameterUri(theResourceDef, name);
                    components.add(new RuntimeSearchParam.Component(null, ref));
                }
            }
            List<String> base = Collections.singletonList(theResourceDef.getName());
            String url = null;
            if (theResourceDef.isStandardType()) {
                String name = searchParam.name();
                url = this.toCanonicalSearchParameterUri(theResourceDef, name);
            }
            RuntimeSearchParam param = new RuntimeSearchParam(null, url, searchParam.name(), searchParam.description(), searchParam.path(), paramType, providesMembershipInCompartments, this.toTargetList(searchParam.target()), RuntimeSearchParam.RuntimeSearchParamStatusEnum.ACTIVE, null, components, base);
            theResourceDef.addSearchParam(param);
            nameToParam.put(param.getName(), param);
        }
    }

    private String toCanonicalSearchParameterUri(RuntimeResourceDefinition theResourceDef, String theName) {
        return "http://hl7.org/fhir/SearchParameter/" + theResourceDef.getName() + "-" + theName;
    }

    private Set<String> toTargetList(Class<? extends IBaseResource>[] theTarget) {
        HashSet<String> retVal = new HashSet<String>();
        for (Class<? extends IBaseResource> nextType : theTarget) {
            ResourceDef resourceDef = nextType.getAnnotation(ResourceDef.class);
            if (resourceDef == null) continue;
            retVal.add(resourceDef.name());
        }
        return retVal;
    }

    static Class<?> determineElementType(Field next) {
        Class<?> nextElementType = next.getType();
        if (List.class.equals(nextElementType)) {
            nextElementType = ReflectionUtil.getGenericCollectionTypeOfField(next);
        } else if (Collection.class.isAssignableFrom(nextElementType)) {
            throw new ConfigurationException(Msg.code(1722) + "Field '" + next.getName() + "' in type '" + next.getClass().getCanonicalName() + "' is a Collection - Only java.util.List curently supported");
        }
        return nextElementType;
    }

    static IValueSetEnumBinder<Enum<?>> getBoundCodeBinder(Field theNext) {
        Class<?> bound = ModelScanner.getGenericCollectionTypeOfCodedField(theNext);
        if (bound == null) {
            throw new ConfigurationException(Msg.code(1723) + "Field '" + theNext + "' has no parameter for " + BoundCodeDt.class.getSimpleName() + " to determine enum type");
        }
        String fieldName = "VALUESET_BINDER";
        try {
            Field bindingField = bound.getField(fieldName);
            return (IValueSetEnumBinder)bindingField.get(null);
        }
        catch (Exception e) {
            throw new ConfigurationException(Msg.code(1724) + "Field '" + theNext + "' has type parameter " + bound.getCanonicalName() + " but this class has no valueset binding field (must have a field called " + fieldName + ")", e);
        }
    }

    static <T extends Annotation> T pullAnnotation(AnnotatedElement theTarget, Class<T> theAnnotationType) {
        T retVal = theTarget.getAnnotation(theAnnotationType);
        return retVal;
    }

    static Class<? extends Enum<?>> determineEnumTypeForBoundField(Field next) {
        Class<?> enumType = ReflectionUtil.getGenericCollectionTypeOfFieldWithSecondOrderForList(next);
        return enumType;
    }

    private static Class<?> getGenericCollectionTypeOfCodedField(Field next) {
        Class type;
        ParameterizedType collectionType = (ParameterizedType)next.getGenericType();
        Type firstArg = collectionType.getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(firstArg.getClass())) {
            ParameterizedType pt = (ParameterizedType)firstArg;
            firstArg = pt.getActualTypeArguments()[0];
            type = (Class)firstArg;
        } else {
            type = (Class)firstArg;
        }
        return type;
    }

    static Set<Class<? extends IBase>> scanVersionPropertyFile(Set<Class<? extends IBase>> theDatatypes, Map<String, Class<? extends IBaseResource>> theResourceTypes, FhirVersionEnum theVersion, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theExistingElementDefinitions) {
        HashSet<Class<? extends IBase>> retVal = new HashSet<Class<? extends IBase>>();
        try (InputStream str = theVersion.getVersionImplementation().getFhirVersionPropertiesFile();){
            Properties prop = new Properties();
            prop.load(str);
            for (Map.Entry<Object, Object> nextEntry : prop.entrySet()) {
                Class<?> nextClass;
                String nextKey = nextEntry.getKey().toString();
                String nextValue = nextEntry.getValue().toString();
                if (nextKey.startsWith("datatype.")) {
                    if (theDatatypes == null) continue;
                    try {
                        Class<?> dtType = Class.forName(nextValue);
                        if (theExistingElementDefinitions.containsKey(dtType)) continue;
                        retVal.add(dtType);
                        if (IElement.class.isAssignableFrom(dtType)) {
                            nextClass = dtType;
                            theDatatypes.add(nextClass);
                            continue;
                        }
                        if (IBaseDatatype.class.isAssignableFrom(dtType)) {
                            nextClass = dtType;
                            theDatatypes.add(nextClass);
                            continue;
                        }
                        ourLog.warn("Class is not assignable from " + IElement.class.getSimpleName() + " or " + IBaseDatatype.class.getSimpleName() + ": " + nextValue);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new ConfigurationException(Msg.code(1725) + "Unknown class[" + nextValue + "] for data type definition: " + nextKey.substring("datatype.".length()), e);
                    }
                }
                if (nextKey.startsWith("resource.")) {
                    String resName = nextKey.substring("resource.".length()).toLowerCase();
                    try {
                        nextClass = Class.forName(nextValue);
                        if (theExistingElementDefinitions.containsKey(nextClass)) continue;
                        if (!IBaseResource.class.isAssignableFrom(nextClass)) {
                            throw new ConfigurationException(Msg.code(1726) + "Class is not assignable from " + IBaseResource.class.getSimpleName() + ": " + nextValue);
                        }
                        theResourceTypes.put(resName, nextClass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new ConfigurationException(Msg.code(1727) + "Unknown class[" + nextValue + "] for resource definition: " + nextKey.substring("resource.".length()), e);
                    }
                }
                throw new ConfigurationException(Msg.code(1728) + "Unexpected property in version property file: " + nextKey + "=" + nextValue);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(Msg.code(1729) + "Failed to load model property file from classpath: /ca/uhn/fhir/model/dstu/model.properties");
        }
        return retVal;
    }
}

