/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.ValidateUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;

public abstract class BaseRuntimeDeclaredChildDefinition
extends BaseRuntimeChildDefinition {
    private final BaseRuntimeChildDefinition.IAccessor myAccessor;
    private final String myElementName;
    private final Field myField;
    private final String myFormalDefinition;
    private final int myMax;
    private final int myMin;
    private final BaseRuntimeChildDefinition.IMutator myMutator;
    private final String myShortDefinition;
    private String myBindingValueSet;
    private boolean myModifier;
    private boolean mySummary;

    BaseRuntimeDeclaredChildDefinition(Field theField, Child theChildAnnotation, Description theDescriptionAnnotation, String theElementName) throws ConfigurationException {
        Validate.notNull(theField, "No field specified", new Object[0]);
        ValidateUtil.isGreaterThanOrEqualTo(theChildAnnotation.min(), 0L, "Min must be >= 0");
        Validate.isTrue(theChildAnnotation.max() == -1 || theChildAnnotation.max() >= theChildAnnotation.min(), "Max must be >= Min (unless it is -1 / unlimited)", new Object[0]);
        Validate.notBlank(theElementName, "Element name must not be blank", new Object[0]);
        this.myField = theField;
        this.myMin = theChildAnnotation.min();
        this.myMax = theChildAnnotation.max();
        this.mySummary = theChildAnnotation.summary();
        this.myModifier = theChildAnnotation.modifier();
        this.myElementName = theElementName;
        if (theDescriptionAnnotation != null) {
            this.myShortDefinition = theDescriptionAnnotation.shortDefinition();
            this.myFormalDefinition = ParametersUtil.extractDescription(theDescriptionAnnotation);
        } else {
            this.myShortDefinition = null;
            this.myFormalDefinition = null;
        }
        this.myField.setAccessible(true);
        if (List.class.equals(this.myField.getType())) {
            this.myAccessor = new FieldListAccessor();
            this.myMutator = new FieldListMutator();
        } else {
            this.myAccessor = new FieldPlainAccessor();
            this.myMutator = new FieldPlainMutator();
        }
    }

    @Override
    public BaseRuntimeChildDefinition.IAccessor getAccessor() {
        return this.myAccessor;
    }

    public String getBindingValueSet() {
        return this.myBindingValueSet;
    }

    void setBindingValueSet(String theBindingValueSet) {
        this.myBindingValueSet = theBindingValueSet;
    }

    @Override
    public String getElementName() {
        return this.myElementName;
    }

    public Field getField() {
        return this.myField;
    }

    public String getFormalDefinition() {
        return this.myFormalDefinition;
    }

    @Override
    public int getMax() {
        return this.myMax;
    }

    @Override
    public int getMin() {
        return this.myMin;
    }

    @Override
    public BaseRuntimeChildDefinition.IMutator getMutator() {
        return this.myMutator;
    }

    public String getShortDefinition() {
        return this.myShortDefinition;
    }

    public boolean isModifier() {
        return this.myModifier;
    }

    protected void setModifier(boolean theModifier) {
        this.myModifier = theModifier;
    }

    @Override
    public boolean isSummary() {
        return this.mySummary;
    }

    private static void setFieldValue(IBase theTarget, Object theValue, Field theField) {
        try {
            theField.set(theTarget, theValue);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(Msg.code(1736) + "Failed to set value", e);
        }
    }

    private static Object getFieldValue(IBase theTarget, Field theField) {
        try {
            return theField.get(theTarget);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(Msg.code(1737) + "Failed to get value", e);
        }
    }

    private final class FieldListAccessor
    implements BaseRuntimeChildDefinition.IAccessor {
        private FieldListAccessor() {
        }

        @Override
        public List<IBase> getValues(IBase theTarget) {
            List<IBase> retVal = (List<IBase>)BaseRuntimeDeclaredChildDefinition.getFieldValue(theTarget, BaseRuntimeDeclaredChildDefinition.this.myField);
            if (retVal == null) {
                retVal = Collections.emptyList();
            }
            return retVal;
        }
    }

    protected final class FieldListMutator
    implements BaseRuntimeChildDefinition.IMutator {
        protected FieldListMutator() {
        }

        @Override
        public void addValue(IBase theTarget, IBase theValue) {
            this.addValue(theTarget, theValue, false);
        }

        private void addValue(IBase theTarget, IBase theValue, boolean theClear) {
            ArrayList<IBase> existingList = (ArrayList<IBase>)BaseRuntimeDeclaredChildDefinition.getFieldValue(theTarget, BaseRuntimeDeclaredChildDefinition.this.myField);
            if (existingList == null) {
                existingList = new ArrayList<IBase>(2);
                BaseRuntimeDeclaredChildDefinition.setFieldValue(theTarget, existingList, BaseRuntimeDeclaredChildDefinition.this.myField);
            }
            if (theClear) {
                existingList.clear();
                if (theValue == null) {
                    return;
                }
            }
            existingList.add(theValue);
        }

        @Override
        public void setValue(IBase theTarget, IBase theValue) {
            this.addValue(theTarget, theValue, true);
        }

        @Override
        public void remove(IBase theTarget, int theIndex) {
            List existingList = (List)BaseRuntimeDeclaredChildDefinition.getFieldValue(theTarget, BaseRuntimeDeclaredChildDefinition.this.myField);
            if (existingList == null) {
                throw new IndexOutOfBoundsException(Msg.code(2143) + "Can not remove element at index " + theIndex + " from list - List is null");
            }
            if (theIndex >= existingList.size()) {
                throw new IndexOutOfBoundsException(Msg.code(2144) + "Can not remove element at index " + theIndex + " from list - List size is " + existingList.size());
            }
            existingList.remove(theIndex);
        }
    }

    private final class FieldPlainAccessor
    implements BaseRuntimeChildDefinition.IAccessor {
        private FieldPlainAccessor() {
        }

        @Override
        public List<IBase> getValues(IBase theTarget) {
            Object values = BaseRuntimeDeclaredChildDefinition.getFieldValue(theTarget, BaseRuntimeDeclaredChildDefinition.this.myField);
            if (values == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList((IBase)values);
        }

        @Override
        public <T extends IBase> Optional<T> getFirstValueOrNull(IBase theTarget) {
            return Optional.ofNullable((IBase)BaseRuntimeDeclaredChildDefinition.getFieldValue(theTarget, BaseRuntimeDeclaredChildDefinition.this.myField));
        }
    }

    protected final class FieldPlainMutator
    implements BaseRuntimeChildDefinition.IMutator {
        protected FieldPlainMutator() {
        }

        @Override
        public void addValue(IBase theTarget, IBase theValue) {
            BaseRuntimeDeclaredChildDefinition.setFieldValue(theTarget, theValue, BaseRuntimeDeclaredChildDefinition.this.myField);
        }

        @Override
        public void setValue(IBase theTarget, IBase theValue) {
            this.addValue(theTarget, theValue);
        }

        @Override
        public void remove(IBase theTarget, int theIndex) {
            throw new UnsupportedOperationException(Msg.code(2142) + "Remove by index can only be called on a list-valued field.  '" + BaseRuntimeDeclaredChildDefinition.this.myField.getName() + "' is a single-valued field.");
        }
    }
}

