/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Reference;

public class Toolbox {
    public static String TAG_PATIENT_NAME = "0010,0010";
    public static String TAG_PATIENT_ID = "0010,0020";
    public static String TAG_PATIENT_BIRTH_DATE = "0010,0030";
    public static String TAG_PATIENT_SEX = "0010,0040";
    public static String TAG_STUDY_INSTANCE_UID = "0020,000d";
    public static String TAG_STUDY_DATE = "0008,0020";
    public static String TAG_SERIES_DESCRIPTION = "0008,103e";
    public static String TAG_SERIES_INSTANCE_UID = "0020,000e";
    public static String TAG_MODALITY = "0008,0060";
    public static String TAG_SERIES_NUMBER = "0020,0011";
    public static String TAG_SOP_INSTANCE_UID = "0008,0018";
    public static String TAG_INSTANCE_NUMBER = "0020,0013";
    public static String TAG_STUDY_DESCRIPTION = "0008,1030";

    public static Date parseDicomDate(String date) {
        Pattern pattern = Pattern.compile("^([0-9]{4})([0-9]{2})([0-9]{2})$");
        Matcher matcher = pattern.matcher(date);
        if (matcher.matches()) {
            GregorianCalendar calendar = new GregorianCalendar(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)));
            return calendar.getTime();
        }
        throw new IllegalArgumentException("Badly formatted DICOM date: " + date);
    }

    public static Date parseFhirDate(String date) {
        Pattern pattern = Pattern.compile("^([0-9]{4})-([0-9]{2})-([0-9]{2})$");
        Matcher matcher = pattern.matcher(date);
        if (matcher.matches()) {
            Calendar c = Calendar.getInstance();
            c.set(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)) - 1, Integer.parseInt(matcher.group(3)));
            return c.getTime();
        }
        throw new IllegalArgumentException("Badly formatted FHIR date: " + date);
    }

    public static String formatDicomDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return String.format("%04d%02d%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static String formatFhirDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return String.format("%04d-%02d-%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static CodeableConcept createCodeableConcept(String system, String code) {
        CodeableConcept codeable = new CodeableConcept();
        codeable.addCoding();
        codeable.getCoding().get(0).setSystem(system);
        codeable.getCoding().get(0).setCode(code);
        return codeable;
    }

    public static CodeableConcept createDicomCodeableConcept(String code) {
        return Toolbox.createCodeableConcept("http://dicom.nema.org/resources/ontology/DCM", code);
    }

    public static Reference createLocalReference(String type, String id) {
        Reference reference = new Reference();
        reference.setReference(type + "/" + id);
        return reference;
    }
}

