/*
 * Decompiled with CFR 0.152.
 */
import be.uclouvain.orthanc.ResourceType;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.server.IResourceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Patient;

public class PatientProvider
implements IResourceProvider {
    private IOrthancConnection orthanc;

    PatientProvider(IOrthancConnection orthanc) {
        this.orthanc = orthanc;
    }

    public Class<Patient> getResourceType() {
        return Patient.class;
    }

    @Read
    public Patient getResourceById(@IdParam IdType theId) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(Toolbox.TAG_PATIENT_ID, theId.getIdPart());
        List<OrthancResource> resources = OrthancResource.find(this.orthanc, ResourceType.PATIENT, tags, true);
        if (resources.size() == 0) {
            return null;
        }
        if (resources.size() > 1) {
            throw new RuntimeException("Too many matching resources");
        }
        return resources.get(0).getFhirPatient();
    }

    @Search
    public List<Patient> getPatients(@OptionalParam(name="family") StringParam theFamilyName, @OptionalParam(name="given") StringParam theGivenName, @OptionalParam(name="identifier") StringParam theIdentifier, @OptionalParam(name="birthdate") DateParam theBirthDate, @Offset Integer theOffset, @Count Integer theCount) {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (theFamilyName != null && theGivenName != null) {
            tags.put(Toolbox.TAG_PATIENT_NAME, "*" + theFamilyName.getValue() + "*" + theGivenName.getValue() + "*");
        } else if (theFamilyName != null) {
            tags.put(Toolbox.TAG_PATIENT_NAME, "*" + theFamilyName.getValue() + "*");
        } else if (theGivenName != null) {
            tags.put(Toolbox.TAG_PATIENT_NAME, "*" + theGivenName.getValue() + "*");
        }
        if (theIdentifier != null) {
            tags.put(Toolbox.TAG_PATIENT_ID, theIdentifier.getValue());
        }
        if (theBirthDate != null) {
            tags.put(Toolbox.TAG_PATIENT_BIRTH_DATE, Toolbox.formatDicomDate(theBirthDate.getValue()));
        }
        boolean caseSensitive = false;
        List<OrthancResource> resources = theOffset != null && theCount != null ? OrthancResource.find(this.orthanc, ResourceType.PATIENT, tags, false, theOffset, theCount) : (theCount != null ? OrthancResource.find(this.orthanc, ResourceType.PATIENT, tags, false, 0, theCount) : OrthancResource.find(this.orthanc, ResourceType.PATIENT, tags, false));
        ArrayList<Patient> patients = new ArrayList<Patient>();
        for (OrthancResource resource : resources) {
            Patient patient = resource.getFhirPatient();
            if (!patient.hasId()) continue;
            patients.add(patient);
        }
        return patients;
    }
}

