/*
 * Decompiled with CFR 0.152.
 */
import be.uclouvain.orthanc.ResourceType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Patient;
import org.json.JSONArray;
import org.json.JSONObject;

public class OrthancResource {
    private ResourceType type;
    private String id;
    private String lastUpdate;
    private Map<String, String> tags;
    private List<String> children;

    public OrthancResource(JSONObject info) {
        String s2 = info.getString("Type");
        if (s2.equals("Patient")) {
            this.type = ResourceType.PATIENT;
        } else if (s2.equals("Study")) {
            this.type = ResourceType.STUDY;
        } else if (s2.equals("Series")) {
            this.type = ResourceType.SERIES;
        } else if (s2.equals("Instance")) {
            this.type = ResourceType.INSTANCE;
        } else {
            throw new RuntimeException("Unknown resource type");
        }
        this.id = info.getString("ID");
        this.lastUpdate = info.optString("LastUpdate");
        this.tags = new HashMap<String, String>();
        OrthancResource.addToDictionary(this.tags, info.getJSONObject("MainDicomTags"));
        if (this.type != ResourceType.INSTANCE) {
            String childKey;
            switch (this.type) {
                case PATIENT: {
                    childKey = "Studies";
                    break;
                }
                case STUDY: {
                    childKey = "Series";
                    OrthancResource.addToDictionary(this.tags, info.getJSONObject("PatientMainDicomTags"));
                    break;
                }
                case SERIES: {
                    childKey = "Instances";
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            this.children = new ArrayList<String>();
            OrthancResource.addToListOfStrings(this.children, info.getJSONArray(childKey));
        }
    }

    public static void addToDictionary(Map<String, String> target, JSONObject source) {
        for (String key : source.keySet()) {
            target.put(key, source.getString(key));
        }
    }

    public static void addToListOfStrings(List<String> target, JSONArray source) {
        for (int i2 = 0; i2 < source.length(); ++i2) {
            target.add(source.getString(i2));
        }
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public List<String> getChildren() {
        if (this.type == ResourceType.INSTANCE) {
            throw new RuntimeException("A DICOM instance has no child");
        }
        return this.children;
    }

    private static List<OrthancResource> find(IOrthancConnection connection, ResourceType type, Map<String, String> tags, boolean caseSensitive, boolean hasPaging, int since, int limit) {
        JSONObject query = new JSONObject();
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            query.put(entry.getKey(), entry.getValue());
        }
        JSONObject request2 = new JSONObject();
        request2.put("Expand", true);
        request2.put("Query", query);
        request2.put("Short", true);
        request2.put("CaseSensitive", caseSensitive);
        if (hasPaging) {
            request2.put("Since", since);
            request2.put("Limit", limit);
        }
        switch (type) {
            case PATIENT: {
                request2.put("Level", "Patient");
                break;
            }
            case STUDY: {
                request2.put("Level", "Study");
                break;
            }
            case SERIES: {
                request2.put("Level", "Series");
                break;
            }
            case INSTANCE: {
                request2.put("Level", "Instance");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        byte[] response = connection.doPost("/tools/find", request2.toString().getBytes(StandardCharsets.UTF_8));
        JSONArray arr = new JSONArray(new String(response, StandardCharsets.UTF_8));
        ArrayList<OrthancResource> result = new ArrayList<OrthancResource>();
        for (int i2 = 0; i2 < arr.length(); ++i2) {
            result.add(new OrthancResource(arr.getJSONObject(i2)));
        }
        return result;
    }

    public static List<OrthancResource> find(IOrthancConnection connection, ResourceType type, Map<String, String> tags, boolean caseSensitive, int since, int limit) {
        return OrthancResource.find(connection, type, tags, caseSensitive, true, since, limit);
    }

    public static List<OrthancResource> find(IOrthancConnection connection, ResourceType type, Map<String, String> tags, boolean caseSensitive) {
        return OrthancResource.find(connection, type, tags, caseSensitive, false, 0, 0);
    }

    public Patient getFhirPatient() {
        String sex;
        String patientName;
        if (this.type != ResourceType.PATIENT) {
            throw new RuntimeException("Not a patient");
        }
        Patient patient = new Patient();
        patient.setId(this.getTags().getOrDefault(Toolbox.TAG_PATIENT_ID, ""));
        String birthDate = this.getTags().getOrDefault(Toolbox.TAG_PATIENT_BIRTH_DATE, "");
        if (birthDate != null) {
            try {
                patient.setBirthDate(Toolbox.parseDicomDate(birthDate));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!(patientName = this.getTags().getOrDefault(Toolbox.TAG_PATIENT_NAME, "")).isEmpty()) {
            patient.addName();
            HumanName name = patient.getName().get(0);
            String[] parts = patientName.split("\\^");
            if (parts.length > 0) {
                name.setFamily(parts[0]);
            }
            for (int i2 = 1; i2 < parts.length; ++i2) {
                name.addGiven(parts[i2]);
            }
        }
        if ((sex = this.getTags().getOrDefault(Toolbox.TAG_PATIENT_SEX, "")).equals("M")) {
            patient.setGender(Enumerations.AdministrativeGender.MALE);
        } else if (sex.equals("F")) {
            patient.setGender(Enumerations.AdministrativeGender.FEMALE);
        }
        return patient;
    }

    public ImagingStudy getFhirStudy(IOrthancConnection orthanc) {
        String studyDescription;
        if (this.type != ResourceType.STUDY) {
            throw new RuntimeException("Not a study");
        }
        boolean hasDicomWeb = IOrthancConnection.hasPluginInstalled(orthanc, "dicom-web");
        ImagingStudy study = new ImagingStudy();
        study.setId(this.getTags().getOrDefault(Toolbox.TAG_STUDY_INSTANCE_UID, ""));
        study.setStatus(ImagingStudy.ImagingStudyStatus.AVAILABLE);
        if (hasDicomWeb) {
            study.addEndpoint(Toolbox.createLocalReference("Endpoint", "wado-rs"));
        }
        study.setSubject(Toolbox.createLocalReference("Patient", this.getTags().getOrDefault(Toolbox.TAG_PATIENT_ID, "")));
        String studyDate = this.getTags().getOrDefault(Toolbox.TAG_STUDY_DATE, "");
        if (!studyDate.isEmpty()) {
            try {
                study.setStarted(Toolbox.parseDicomDate(studyDate));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (!(studyDescription = this.getTags().getOrDefault(Toolbox.TAG_STUDY_DESCRIPTION, "")).isEmpty()) {
            study.setDescription(studyDescription);
        }
        study.addIdentifier();
        study.getIdentifier().get(0).setSystem("urn:dicom:uid");
        study.getIdentifier().get(0).setValue("urn:oid:" + study.getId());
        study.setNumberOfSeries(this.getChildren().size());
        int countInstances = 0;
        HashMap<String, String> shortTags = new HashMap<String, String>();
        shortTags.put("short", "");
        HashMap<String, String> expand = new HashMap<String, String>();
        expand.put("expand", "");
        for (int i2 = 0; i2 < this.getChildren().size(); ++i2) {
            String seriesNumber;
            String seriesDescription;
            String seriesUri = "/series/" + this.getChildren().get(i2);
            OrthancResource orthancSeries = new OrthancResource(IOrthancConnection.getJSONObject(orthanc, seriesUri, shortTags));
            ImagingStudy.ImagingStudySeriesComponent fhirSeries = study.addSeries();
            fhirSeries.setUid(orthancSeries.getTags().getOrDefault(Toolbox.TAG_SERIES_INSTANCE_UID, ""));
            String modality = orthancSeries.getTags().getOrDefault(Toolbox.TAG_MODALITY, "");
            if (!modality.isEmpty()) {
                fhirSeries.setModality(Toolbox.createDicomCodeableConcept(modality));
            }
            if (!(seriesDescription = orthancSeries.getTags().getOrDefault(Toolbox.TAG_SERIES_DESCRIPTION, "")).isEmpty()) {
                fhirSeries.setDescription(seriesDescription);
            }
            if (!(seriesNumber = orthancSeries.getTags().getOrDefault(Toolbox.TAG_SERIES_NUMBER, "")).isEmpty()) {
                fhirSeries.setNumber(Integer.parseInt(seriesNumber));
            }
            fhirSeries.setNumberOfInstances(orthancSeries.getChildren().size());
            for (int j = 0; j < orthancSeries.getChildren().size(); ++j) {
                String sopClassUid;
                String instanceUri = "/instances/" + orthancSeries.getChildren().get(j);
                OrthancResource orthancInstance = new OrthancResource(IOrthancConnection.getJSONObject(orthanc, instanceUri, shortTags));
                JSONObject instanceMetadata = IOrthancConnection.getJSONObject(orthanc, instanceUri + "/metadata", expand);
                ImagingStudy.ImagingStudySeriesInstanceComponent fhirInstance = fhirSeries.addInstance();
                fhirInstance.setUid(orthancInstance.getTags().getOrDefault(Toolbox.TAG_SOP_INSTANCE_UID, ""));
                String instanceNumber = orthancInstance.getTags().getOrDefault(Toolbox.TAG_INSTANCE_NUMBER, "");
                if (!instanceNumber.isEmpty()) {
                    fhirInstance.setNumber(Integer.parseInt(instanceNumber));
                }
                if ((sopClassUid = instanceMetadata.optString("SopClassUid", "")).isEmpty()) continue;
                fhirInstance.setSopClass(new Coding("urn:ietf:rfc:3986", "urn:oid:" + sopClassUid, ""));
            }
            countInstances += orthancSeries.getChildren().size();
        }
        study.setNumberOfInstances(countInstances);
        return study;
    }
}

